/**************************************************************************
 *
 * Copyright 2012 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **************************************************************************/

/*
 * Central place for all D2D/DWRITE includes, and respective OS dependent headers.
 */

#pragma once

#include <windows.h>
#include <tchar.h>

#include "winsdk_compat.h"

#include <d2d1_1.h>
#include <d2d1effectauthor.h>  // for D2D1_PROPERTY_BINDING
#include <dwrite_1.h>

#ifndef WINCODEC_ERR_UNSUPPORTEDPIXELFORMAT
#define WINCODEC_ERR_UNSUPPORTEDPIXELFORMAT 0x88982f80
#endif

DEFINE_GUID(IID_ID2D1Resource,0x2cd90691,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1Bitmap,0xa2296057,0xea42,0x4099,0x98,0x3b,0x53,0x9f,0xb6,0x50,0x54,0x26);
DEFINE_GUID(IID_ID2D1GradientStopCollection,0x2cd906a7,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1Brush,0x2cd906a8,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1BitmapBrush,0x2cd906aa,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1SolidColorBrush,0x2cd906a9,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1LinearGradientBrush,0x2cd906ab,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1RadialGradientBrush,0x2cd906ac,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1StrokeStyle,0x2cd9069d,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1Geometry,0x2cd906a1,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1RectangleGeometry,0x2cd906a2,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1RoundedRectangleGeometry,0x2cd906a3,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1EllipseGeometry,0x2cd906a4,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1GeometryGroup,0x2cd906a6,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1TransformedGeometry,0x2cd906bb,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1SimplifiedGeometrySink,0x2cd9069e,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1GeometrySink,0x2cd9069f,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1TessellationSink,0x2cd906c1,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1PathGeometry,0x2cd906a5,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1Mesh,0x2cd906c2,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1Layer,0x2cd9069b,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1DrawingStateBlock,0x28506e39,0xebf6,0x46a1,0xbb,0x47,0xfd,0x85,0x56,0x5a,0xb9,0x57);
DEFINE_GUID(IID_ID2D1RenderTarget,0x2cd90694,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1BitmapRenderTarget,0x2cd90695,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1HwndRenderTarget,0x2cd90698,0x12e2,0x11dc,0x9f,0xed,0x00,0x11,0x43,0xa0,0x55,0xf9);
DEFINE_GUID(IID_ID2D1GdiInteropRenderTarget,0xe0db51c3,0x6f77,0x4bae,0xb3,0xd5,0xe4,0x75,0x09,0xb3,0x58,0x38);
DEFINE_GUID(IID_ID2D1DCRenderTarget,0x1c51bc64,0xde61,0x46fd,0x98,0x99,0x63,0xa5,0xd8,0xf0,0x39,0x50);
DEFINE_GUID(IID_ID2D1Factory,0x06152247,0x6f50,0x465a,0x92,0x45,0x11,0x8b,0xfd,0x3b,0x60,0x07);

DEFINE_GUID(IID_IDWriteFontFileLoader,0x727cad4e,0xd6af,0x4c9e,0x8a,0x08,0xd6,0x95,0xb1,0x1c,0xaa,0x49);
DEFINE_GUID(IID_IDWriteLocalFontFileLoader,0xb2d9f3ec,0xc9fe,0x4a11,0xa2,0xec,0xd8,0x62,0x08,0xf7,0xc0,0xa2);
DEFINE_GUID(IID_IDWriteFontFileStream,0x6d4865fe,0x0ab8,0x4d91,0x8f,0x62,0x5d,0xd6,0xbe,0x34,0xa3,0xe0);
DEFINE_GUID(IID_IDWriteFontFile,0x739d886a,0xcef5,0x47dc,0x87,0x69,0x1a,0x8b,0x41,0xbe,0xbb,0xb0);
DEFINE_GUID(IID_IDWriteRenderingParams,0x2f0da53a,0x2add,0x47cd,0x82,0xee,0xd9,0xec,0x34,0x68,0x8e,0x75);
DEFINE_GUID(IID_IDWriteFontFace,0x5f49804d,0x7024,0x4d43,0xbf,0xa9,0xd2,0x59,0x84,0xf5,0x38,0x49);
DEFINE_GUID(IID_IDWriteFontCollectionLoader,0xcca920e4,0x52f0,0x492b,0xbf,0xa8,0x29,0xc7,0x2e,0xe0,0xa4,0x68);
DEFINE_GUID(IID_IDWriteFontFileEnumerator,0x72755049,0x5ff7,0x435d,0x83,0x48,0x4b,0xe9,0x7c,0xfa,0x6c,0x7c);
DEFINE_GUID(IID_IDWriteLocalizedStrings,0x08256209,0x099a,0x4b34,0xb8,0x6d,0xc2,0x2b,0x11,0x0e,0x77,0x71);
DEFINE_GUID(IID_IDWriteFontCollection,0xa84cee02,0x3eea,0x4eee,0xa8,0x27,0x87,0xc1,0xa0,0x2a,0x0f,0xcc);
DEFINE_GUID(IID_IDWriteFontList,0x1a0d8438,0x1d97,0x4ec1,0xae,0xf9,0xa2,0xfb,0x86,0xed,0x6a,0xcb);
DEFINE_GUID(IID_IDWriteFontFamily,0xda20d8ef,0x812a,0x4c43,0x98,0x02,0x62,0xec,0x4a,0xbd,0x7a,0xdd);
DEFINE_GUID(IID_IDWriteFont,0xacd16696,0x8c14,0x4f5d,0x87,0x7e,0xfe,0x3f,0xc1,0xd3,0x27,0x37);
DEFINE_GUID(IID_IDWriteTextFormat,0x9c906818,0x31d7,0x4fd3,0xa1,0x51,0x7c,0x5e,0x22,0x5d,0xb5,0x5a);
DEFINE_GUID(IID_IDWriteTypography,0x55f1112b,0x1dc2,0x4b3c,0x95,0x41,0xf4,0x68,0x94,0xed,0x85,0xb6);
DEFINE_GUID(IID_IDWriteNumberSubstitution,0x14885CC9,0xBAB0,0x4f90,0xB6,0xED,0x5C,0x36,0x6A,0x2C,0xD0,0x3D);
DEFINE_GUID(IID_IDWriteTextAnalysisSource,0x688e1a58,0x5094,0x47c8,0xad,0xc8,0xfb,0xce,0xa6,0x0a,0xe9,0x2b);
DEFINE_GUID(IID_IDWriteTextAnalysisSink,0x5810cd44,0x0ca0,0x4701,0xb3,0xfa,0xbe,0xc5,0x18,0x2a,0xe4,0xf6);
DEFINE_GUID(IID_IDWriteTextAnalyzer,0xb7e6163e,0x7f46,0x43b4,0x84,0xb3,0xe4,0xe6,0x24,0x9c,0x36,0x5d);
DEFINE_GUID(IID_IDWriteInlineObject,0x8339FDE3,0x106F,0x47ab,0x83,0x73,0x1C,0x62,0x95,0xEB,0x10,0xB3);
DEFINE_GUID(IID_IDWritePixelSnapping,0xeaf3a2da,0xecf4,0x4d24,0xb6,0x44,0xb3,0x4f,0x68,0x42,0x02,0x4b);
DEFINE_GUID(IID_IDWriteTextRenderer,0xef8a8135,0x5cc6,0x45fe,0x88,0x25,0xc5,0xa0,0x72,0x4e,0xb8,0x19);
DEFINE_GUID(IID_IDWriteTextLayout,0x53737037,0x6d14,0x410b,0x9b,0xfe,0x0b,0x18,0x2b,0xb7,0x09,0x61);
DEFINE_GUID(IID_IDWriteBitmapRenderTarget,0x5e5a32a3,0x8dff,0x4773,0x9f,0xf6,0x06,0x96,0xea,0xb7,0x72,0x67);
DEFINE_GUID(IID_IDWriteGdiInterop,0x1edd9491,0x9853,0x4299,0x89,0x8f,0x64,0x32,0x98,0x3b,0x6f,0x3a);
DEFINE_GUID(IID_IDWriteGlyphRunAnalysis,0x7d97dbf7,0xe085,0x42d4,0x81,0xe3,0x6a,0x88,0x3b,0xde,0xd1,0x18);
DEFINE_GUID(IID_IDWriteFactory,0xb859ee5a,0xd838,0x4b5b,0xa2,0xe8,0x1a,0xdc,0x7d,0x93,0xdb,0x48);

