#********************************************************************
# Makefile for SAS/C on Amiga
#********************************************************************

CC = sc
LD = sc
CFLAGS = NOVERSION OPTIMIZE STRINGMERGE
LDFLAGS = NOVERSION

SOURCES = avrp.c io_amiga.c talking.c file.c memtalk.c

OBJECTS = avrp.o io_amiga.o talking.o file.o memtalk.o

OBJ_ALL = $(OBJECTS) args.o stdextra.o

DISTFILES = *.c *.h README Makefile.* avrp.def COPYING avrp.1

ARCHFILES = $(DISTFILES) ex/* tab2space space2tab ToDo

BINFILES = avrp avrp.def README COPYING avrp.1 avrp.txt

VERSION = 1.0-beta3

#********************************************************************

all: avrp

install: avrp
	copy avrp.def env:
	copy avrp.def envarc:
	copy avrp c:

clean:
	delete avrp avrp.info \#?.o \#?.lnk

avrp: $(OBJ_ALL)
	$(LD) link $(OBJ_ALL) $(LDFLAGS)

$(OBJECTS): avrp.h args.h misc.h
args.o: args.h misc.h
stdextra.o: misc.h
talking.o memtalk.o: talk.h

#********************************************************************
disk: archive
	copy avrp.lha df0:avrp.lha

archive: avrp.lha

avrp.lha: #$(ARCHFILES)
	lha -xr u avrp.lha $(ARCHFILES)

dist: avrp-$(VERSION).lha

avrp-$(VERSION).lha: #$(DISTFILES)
	makedir avrp-$(VERSION)
	copy $(DISTFILES) TO avrp-$(VERSION)/
	lha -xr u avrp-$(VERSION).lha avrp-$(VERSION)/*
	delete ALL avrp-$(VERSION)

bin: avrp-$(VERSION)-Amiga.lha

avrp-$(VERSION)-Amiga.lha: $(BINFILES)
	makedir avrp-$(VERSION)
	copy $(BINFILES) avrp-$(VERSION)/
	lha -xr u avrp-$(VERSION)-Amiga.lha avrp-$(VERSION)/*
	delete ALL avrp-$(VERSION)

#********************************************************************
