/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef __HOTPLUG_ACTION_EXTENSION__
#define __HOTPLUG_ACTION_EXTENSION__

#include "ActionExtension.h"

class VariantDataModel;

namespace camitk {

class HotPlugAction;

/**
 * @brief An ActionExtension that can be created on the fly from a camitk extension file.
 *
 * Note: the location of the extension is the path to the camitk extension file.
 * Use getLocation() to get the file path of the CamiTK extension file that generated this extension.
 *
 */
class CAMITK_API HotPlugActionExtension : public ActionExtension {
    Q_OBJECT

protected:
    /// constructor
    HotPlugActionExtension(const QString& camitkFilePath);

public:
    static HotPlugActionExtension* newHotPlugActionExtension(const QString& camitkFilePath, bool forceVerifyOrRebuild);

    /// destructor
    ~HotPlugActionExtension() override;

    /// returns the action extension name (to be overriden in your ActionExtension)
    virtual QString getName() const override;

    /// returns the action extension small description (to be overriden in your ActionExtension)
    virtual QString getDescription() const override;

    /// get the programming language of this extension (either C++ or Python)
    virtual QString getProgrammingLanguage() const = 0;

    /// This calls initActions, but ignores the return value.
    /// Should never be called directly.
    virtual void init() override;

    /// instantiate all the actions (might generate some warnings)
    /// @note this method must set the successfullyLoaded to false and return false when some action could not
    /// be instantiated
    /// @param progressMinimum is the current initial progress value
    /// @param progressMaximum is the maximum progress bar value to use when all actions are initialized
    virtual bool initActions(int progressMinimum = 0, int progressMaximum = 100) = 0;

    /// @return number of actions declared in the CamiTKExtensionModel
    virtual int declaredActionCount() const;

    /// @return true if all the action were instantiated and loaded successfully
    // used to get the state of init at any time.
    // For instance this is used to show a specific icon beside the registered extension name
    // Dev menu in imp for instance uses it to show a QStyle::SP_DialogApplyButton (a tick mark)
    // when all actions are correctly loaded, and QStyle::SP_DialogCancelButton (a noway sign)
    // when some actions failed
    bool isSuccessfullyLoaded();

protected:
    /// short name of the extension (as it will displayed in the Dev Studio menu for instance)
    QString name;

    /// description in few word/sentences
    QString description;

    /// true if the extension as well ass all the actions libraries were loaded successfully
    bool successfullyLoaded;
};

} // namespace camitk

#endif // __HOTPLUG_ACTION_EXTENSION__
