/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __MORSE_CODE
#define __MORSE_CODE

#include "command.h"
#include "multi_curve.h"
#include "curve_editor.h"
#include "listeners.h"

#include <map>
#include <string>

struct morse_code : command { // convert text to morse code to multi_curve to use as a pattern

  // international morse code
  std::map <char, std::string> code;
  int ncodes;

  // bezier curves for morse code primitives
  multi_curve dot, dash;
  multi_curve inner_space, letter_space, word_space;

  // morse code editor
  curve_editor ed;
  morse_code_listener lis;

  // generation
  int add_first_vertex;
  point<float> org;
  point<float> vi;


  morse_code (const std::string& ln, const std::string& sn);
  ~morse_code ();
  bool load (const std::string& fname);
  bool operator() (tokenizer& tz);
  bool create_pattern (const std::string& text, float tox);
  void append (multi_curve& m, multi_curve& p);
  void scale_tox (multi_curve& m, float tox);


};

#endif
