/*
// $Id: //open/dev/farrago/src/net/sf/farrago/runtime/FennelTupleReader.java#12 $
// Farrago is an extensible data management system.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2005-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package net.sf.farrago.runtime;

import java.nio.*;


/**
 * FennelTupleReader defines an interface for unmarshalling tuples returned by
 * Fennel. Implementations are generated by FennelToIteratorConverter for
 * unmarshalling specific tuple formats.
 *
 * @author John V. Sichi
 * @version $Id: //open/dev/farrago/src/net/sf/farrago/runtime/FennelTupleReader.java#12 $
 */
public interface FennelTupleReader
{
    //~ Methods ----------------------------------------------------------------

    /**
     * Unmarshals one tuple.
     *
     * @param byteBuffer read-only buffer containing marshalled tuple data; on
     * entry, the buffer position is at beginning of tuple
     * @param byteArray byte array underlying byteBuffer
     * @param sliceBuffer result of byteBuffer.slice(), for use in relative
     * offsets; on return, sliceBuffer position should be at the unaligned end
     * of tuple
     *
     * @return subclass-specific object containing unmarshalled tuple data
     */
    Object unmarshalTuple(
        ByteBuffer byteBuffer,
        byte [] byteArray,
        ByteBuffer sliceBuffer);
}

// End FennelTupleReader.java
