//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicefabricmesh_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicefabricmesh/armservicefabricmesh"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/gateways/create_update.json
func ExampleGatewayClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armservicefabricmesh.NewGatewayClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Create(ctx,
		"sbz_demo",
		"sampleGateway",
		armservicefabricmesh.GatewayResourceDescription{
			Location: to.Ptr("EastUS"),
			Tags:     map[string]*string{},
			Properties: &armservicefabricmesh.GatewayResourceProperties{
				Description: to.Ptr("Service Fabric Mesh sample gateway."),
				DestinationNetwork: &armservicefabricmesh.NetworkRef{
					Name: to.Ptr("helloWorldNetwork"),
				},
				SourceNetwork: &armservicefabricmesh.NetworkRef{
					Name: to.Ptr("Open"),
				},
				TCP: []*armservicefabricmesh.TCPConfig{
					{
						Name: to.Ptr("web"),
						Destination: &armservicefabricmesh.GatewayDestination{
							ApplicationName: to.Ptr("helloWorldApp"),
							EndpointName:    to.Ptr("helloWorldListener"),
							ServiceName:     to.Ptr("helloWorldService"),
						},
						Port: to.Ptr[int32](80),
					}},
				HTTP: []*armservicefabricmesh.HTTPConfig{
					{
						Name: to.Ptr("contosoWebsite"),
						Hosts: []*armservicefabricmesh.HTTPHostConfig{
							{
								Name: to.Ptr("contoso.com"),
								Routes: []*armservicefabricmesh.HTTPRouteConfig{
									{
										Name: to.Ptr("index"),
										Destination: &armservicefabricmesh.GatewayDestination{
											ApplicationName: to.Ptr("httpHelloWorldApp"),
											EndpointName:    to.Ptr("indexHttpEndpoint"),
											ServiceName:     to.Ptr("indexService"),
										},
										Match: &armservicefabricmesh.HTTPRouteMatchRule{
											Path: &armservicefabricmesh.HTTPRouteMatchPath{
												Type:    to.Ptr(armservicefabricmesh.PathMatchTypePrefix),
												Rewrite: to.Ptr("/"),
												Value:   to.Ptr("/index"),
											},
											Headers: []*armservicefabricmesh.HTTPRouteMatchHeader{
												{
													Name:  to.Ptr("accept"),
													Type:  to.Ptr(armservicefabricmesh.HeaderMatchTypeExact),
													Value: to.Ptr("application/json"),
												}},
										},
									}},
							}},
						Port: to.Ptr[int32](8081),
					}},
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/gateways/get.json
func ExampleGatewayClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armservicefabricmesh.NewGatewayClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx,
		"sbz_demo",
		"sampleGateway",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/gateways/delete.json
func ExampleGatewayClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armservicefabricmesh.NewGatewayClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.Delete(ctx,
		"sbz_demo",
		"sampleGateway",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/gateways/list_byResourceGroup.json
func ExampleGatewayClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armservicefabricmesh.NewGatewayClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListByResourceGroupPager("sbz_demo",
		nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/gateways/list_bySubscriptionId.json
func ExampleGatewayClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armservicefabricmesh.NewGatewayClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListBySubscriptionPager(nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}
