// Code generated by smithy-go-codegen DO NOT EDIT.

package deadline

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/deadline/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get credentials from the fleet role for a worker.
func (c *Client) AssumeFleetRoleForWorker(ctx context.Context, params *AssumeFleetRoleForWorkerInput, optFns ...func(*Options)) (*AssumeFleetRoleForWorkerOutput, error) {
	if params == nil {
		params = &AssumeFleetRoleForWorkerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssumeFleetRoleForWorker", params, optFns, c.addOperationAssumeFleetRoleForWorkerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssumeFleetRoleForWorkerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssumeFleetRoleForWorkerInput struct {

	// The farm ID for the fleet's farm.
	//
	// This member is required.
	FarmId *string

	// The fleet ID that contains the worker.
	//
	// This member is required.
	FleetId *string

	// The ID of the worker assuming the fleet role.
	//
	// This member is required.
	WorkerId *string

	noSmithyDocumentSerde
}

type AssumeFleetRoleForWorkerOutput struct {

	// The credentials for the worker.
	//
	// This member is required.
	Credentials *types.AwsCredentials

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssumeFleetRoleForWorkerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAssumeFleetRoleForWorker{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAssumeFleetRoleForWorker{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssumeFleetRoleForWorker"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opAssumeFleetRoleForWorkerMiddleware(stack); err != nil {
		return err
	}
	if err = addOpAssumeFleetRoleForWorkerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssumeFleetRoleForWorker(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opAssumeFleetRoleForWorkerMiddleware struct {
}

func (*endpointPrefix_opAssumeFleetRoleForWorkerMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opAssumeFleetRoleForWorkerMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "scheduling." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opAssumeFleetRoleForWorkerMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opAssumeFleetRoleForWorkerMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opAssumeFleetRoleForWorker(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssumeFleetRoleForWorker",
	}
}
