// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptography

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the public key certificate of the asymmetric key pair that exists within
// Amazon Web Services Payment Cryptography.
//
// Unlike the private key of an asymmetric key, which never leaves Amazon Web
// Services Payment Cryptography unencrypted, callers with GetPublicKeyCertificate
// permission can download the public key certificate of the asymmetric key. You
// can share the public key certificate to allow others to encrypt messages and
// verify signatures outside of Amazon Web Services Payment Cryptography
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
func (c *Client) GetPublicKeyCertificate(ctx context.Context, params *GetPublicKeyCertificateInput, optFns ...func(*Options)) (*GetPublicKeyCertificateOutput, error) {
	if params == nil {
		params = &GetPublicKeyCertificateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPublicKeyCertificate", params, optFns, c.addOperationGetPublicKeyCertificateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPublicKeyCertificateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPublicKeyCertificateInput struct {

	// The KeyARN of the asymmetric key pair.
	//
	// This member is required.
	KeyIdentifier *string

	noSmithyDocumentSerde
}

type GetPublicKeyCertificateOutput struct {

	// The public key component of the asymmetric key pair in a certificate PEM format
	// (base64 encoded). It is signed by the root certificate authority (CA). The
	// certificate expires in 90 days.
	//
	// This member is required.
	KeyCertificate *string

	// The root certificate authority (CA) that signed the public key certificate in
	// PEM format (base64 encoded) of the asymmetric key pair.
	//
	// This member is required.
	KeyCertificateChain *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPublicKeyCertificateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetPublicKeyCertificate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetPublicKeyCertificate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPublicKeyCertificate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetPublicKeyCertificateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPublicKeyCertificate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetPublicKeyCertificate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPublicKeyCertificate",
	}
}
