/*************************************************************************
* Copyright (C) 2021 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#ifndef IFMA_ECPRECOMP4_PSM2_H
#define IFMA_ECPRECOMP4_PSM2_H

#include <internal/sm2/ifma_ecpoint_sm2.h>

#if (_MBX >= _MBX_K1)

#define MUL_BASEPOINT_WIN_SIZE (4)

#define BP_WIN_SIZE MUL_BASEPOINT_WIN_SIZE
#define BP_N_SLOTS  NUMBER_OF_DIGITS(PSM2_BITSIZE + 1, BP_WIN_SIZE)
#define BP_N_ENTRY  (1 << (BP_WIN_SIZE - 1))

/* clang-format off */
__ALIGN64 static SINGLE_SM2_POINT_AFFINE ifma_ec_sm2_bp_precomp[][BP_N_ENTRY] = {
{   /*digit=0 [{1,2,3,..,}]*([2^0]*G)  */
    {{0x0008990f418029e9,0x000e6ca6c04fd132,0x00024c3c33e7981e,0x000b05d6a1ed99ac,0x00001167a5f71c13}, {0x0004e593c2d0ddd6,0x0008ed3295fa6135,0x0002a48f8c1f5e57,0x0005bd8d4cfb066e,0x00003cd65d4e1d73}},
    {{0x00037bfbc3be46a0,0x000a2d8fa9380af0,0x00088cd2483bdc9b,0x00036a5349d94b57,0x0000d7e9c18caa57}, {0x0001a1d69db9ac19,0x000854a8e82ada7e,0x0007157acccbd8d3,0x000df5c7b145169b,0x000047e7465fc21b}},
    {{0x00054fdab589e4a3,0x000a0b4f0a0cecda,0x000eb4a0a2676528,0x000c640a265a308c,0x0000019fd6c2e887}, {0x000fbe94b2fc1902,0x000ba7cbce5fea10,0x000c13c97f40aa52,0x000bb4cc496bfa6d,0x00008ad34787bb3f}},
    {{0x0007c5a986150605,0x000039016208e93f,0x0009f9020487ea28,0x000be18a86bcb4a0,0x00000dc8e3b1899d}, {0x0009043fd6199986,0x000adc7383bd9c09,0x000cf70ed1de135e,0x0009e34d0bd55632,0x0000ffc31c585bce}},
    {{0x00056336a9c81620,0x000221dfcc539a57,0x000f5f4c515aa58f,0x0005b97ad354bf1e,0x0000f443ef363f87}, {0x000d68fd34501337,0x000e53607d17be81,0x0002258efb30f4bb,0x000768b1826a4c36,0x0000b415276842a6}},
    {{0x0009c4c0acd72ba8,0x0005de7ec73b936a,0x000e34db6b1274a2,0x000047f15a876e5d,0x00005e74ca10cba8}, {0x0004cddb469eb37b,0x0000799754f75845,0x00030e9848fbf6d2,0x00098a1060e7f8ec,0x0000568bc97fb8c5}},
    {{0x00031c781f06784b,0x0003b713251ffa35,0x000fe18c50b89419,0x000c2884ee5b69ac,0x0000bf492e189fbe}, {0x00035c1e5f6186d2,0x000e957a01b8113a,0x000d99baf0e449a2,0x00077796c9b9922b,0x0000ba05a8f5b84d}},
    {{0x0003a1c091226701,0x000a32cc810cce52,0x00087df9e90be6f2,0x000134086e634143,0x000015c2fc0e9c44}, {0x000430d8799302ae,0x0001c27b7ea3b334,0x0008f3382693b350,0x000247cbe1136f9a,0x000077fd5f395778}},
},
{   /*digit=1 [{1,2,3,..,}]*([2^4]*G)  */
    {{0x00060c939e8a120c,0x00093273b59a3715,0x000f4639d7121d6b,0x000d58649535ce8e,0x0000d01076ed4cc6}, {0x000729a96e74f8a6,0x0000b533037dc705,0x0003c5c62b07e323,0x000ac10846dcc166,0x0000a4759c170fc3}},
    {{0x0001369adbb3c8b5,0x000b9c8ec37856c1,0x000f0a982d78af40,0x00050affb3a80d03,0x000050e3e71f83be}, {0x0000fb2418ee45bb,0x0003b791b963d45c,0x00047e33b5297cf4,0x0005b2676b638ccc,0x00001c52fadaecf8}},
    {{0x000f511b36362ecf,0x0007240859590a8f,0x00070c62b11c5a9f,0x000827272b86f297,0x000006262266c7e8}, {0x00068bfea1e13ebf,0x0002be59b0f4a291,0x000826f34db89297,0x000cec6769e31d4f,0x0000a1dd934fa955}},
    {{0x000a5ae0d038ad4f,0x000426256c8e90ff,0x000978dcef44d3df,0x0003170a3077c8bc,0x00003d9b4b1645b8}, {0x0004484b6b1852c5,0x00045e78ff073bbf,0x000c242380cd02ed,0x000b5591cb827e49,0x00008adaee62aa3c}},
    {{0x0001687af48d3524,0x0000068c04010e5a,0x0003b2e10fa700b7,0x0001f5c06c84139f,0x00007cd5ff4bcf2f}, {0x000c6996a3ebd39b,0x00085f9371d6b52d,0x000c57dadb8d9103,0x000b8bee3f1d85f2,0x0000c987637ef0d8}},
    {{0x00091da5f6fbf645,0x000364de051b9b7a,0x0005a1ac8ad5bf46,0x0002fa13e4455d48,0x0000d09b6e064f3a}, {0x000ffc804bf14165,0x000c1e88e44737c3,0x0003777ca4b5beda,0x0001181fc4f3fd98,0x00005e4509f06d4b}},
    {{0x0007754a47073753,0x00053923a9dc5b93,0x000ab2dd726607db,0x0000a7690f12ae67,0x0000a39fc8c30a65}, {0x00095fd0ae53d66e,0x000319b1c44980fe,0x000eb8e6eefebcba,0x000c8cf8b3ca72f1,0x0000586e40734f5c}},
    {{0x000ce4d033fc12ae,0x00022886f31527e6,0x0006f3f11ba4f98a,0x000de3b24b38f3e6,0x00003f6205b3ea4b}, {0x0005387a77b998f4,0x0007d549f3b0c070,0x0003a61d62c9b445,0x00081adef6625b53,0x0000eda7e2abe4f7}},
},
{   /*digit=2 [{1,2,3,..,}]*([2^8]*G)  */
    {{0x0000aaafd1201340,0x0009c057309ce973,0x000726ce7b22b908,0x00058498e7956584,0x0000e1431a0d635a}, {0x0007023e834ffa6a,0x000fa36ab1ae1d38,0x00024b68464198dd,0x000c6d46e5ebb191,0x0000316fa44c33b3}},
    {{0x0000210a1371aa41,0x000064b5424eac97,0x00064269baff481a,0x0007cfbcdf91fd0e,0x00008bb37bbc02fc}, {0x000dd796f69d4390,0x000f169514b2d99e,0x000e19ae44e27a58,0x00096d80eca1ca66,0x0000470e96507886}},
    {{0x0008bfc3dfdc228b,0x000e69648a35b377,0x0005a99b5c0bae0a,0x00058ada8cb8ab01,0x0000045cccc3366b}, {0x0008ef44164cebd7,0x000935e00e5f04ef,0x00079468e41e71fc,0x00072d753cf90644,0x00008b5223fa32ea}},
    {{0x0009e2f5876d6e8b,0x000682b622d6a28a,0x0005411d793c48f8,0x000e9188d9eac83e,0x00007e4a6bab0a70}, {0x000e5baf1c43b2ea,0x000f42f347de0f18,0x00009638f46578c7,0x000d2919ca736df0,0x00006563f1f5d1ac}},
    {{0x00054b5577dae353,0x0006dac3a655cefc,0x000c31d009d2f054,0x00063db96bd298fa,0x0000328a51d1e695}, {0x000098e43195f4e8,0x00062998010ade19,0x00047ccb6657f4ba,0x000da645f29a8440,0x000033a5443ee423}},
    {{0x000f29899229a90d,0x0008ed71d5319e6c,0x000e3a8b7a6840bc,0x000a0e803e540771,0x00005611ee53afd9}, {0x000ca0ebbbefa73b,0x000c75ec48b72739,0x000dea0ec6082dba,0x000e03a0ab10dfbb,0x00001b7ebe5a1633}},
    {{0x0004475ad1cac223,0x000ef7e1139532e6,0x000479c4a2008653,0x0000d1a875ad01d9,0x0000e6cf633b04b3}, {0x000ef6eb6b06e46b,0x000fa7b8410aa8b3,0x00078458d74c45db,0x000bd102675759c2,0x00002ef49575cd30}},
    {{0x00012dd12ee579d7,0x000b76dd62d6170b,0x0001d75822a9a12a,0x000457bcd5259907,0x0000a36193b1869c}, {0x0006592e976ae5bf,0x00039dfecd57e29e,0x00014686de82c871,0x0003babc83a440f7,0x0000e19344afc21e}},
},
{   /*digit=3 [{1,2,3,..,}]*([2^12]*G)  */
    {{0x000010b2c4391719,0x0007781393878f41,0x0000776333ff85ee,0x0000234ada4c7d8f,0x0000976011b124e6}, {0x0001197eaf49f638,0x0000560b0c4c2250,0x000b3df90dff2123,0x000d5f1a6a3abbba,0x000054bbcc7366ff}},
    {{0x000c28718d13bd32,0x000443c6dd1a9b45,0x000b9cf87bbf3a89,0x00048dc8171c5e13,0x0000dfc779254f53}, {0x000662d985cabd47,0x000cbd971de02b9a,0x0004cba64588a6eb,0x000e67da9fd89457,0x0000e0f0ccad51e6}},
    {{0x000572f9f177d653,0x00055c2394c3f74c,0x000307ad6c39e9e1,0x0009c8c9e7b18c1e,0x00003da596c7c22d}, {0x0000e12b74b9c00c,0x000e19f5d1339c30,0x0009e84425f434a9,0x0001c35b87294371,0x00000164ba54acd1}},
    {{0x000276c4b8bceb84,0x0001b52d110648ca,0x00034dcbf6d4ec10,0x0009d02ad98063f8,0x0000da81d1a1fff1}, {0x0007cd23a9828ffc,0x0000ee64b3318ccc,0x00008b81cf1e389b,0x000ac6e2fb6a6c73,0x00006df66b31bcc0}},
    {{0x00029d74220fbbff,0x0004f09ba10d52f0,0x000858df9405e1d8,0x000b23e53bd89048,0x0000d7bc7aa35dab}, {0x000f3807f06c21c7,0x0000b324828efe76,0x00017d5a3616f89c,0x00060fe30abf04a5,0x0000714fd2e0d0db}},
    {{0x00013306dccac081,0x00050610b07430a3,0x000edd616b67ab62,0x0006666fd86597e7,0x000029abb54bf0c4}, {0x000f5f3c3ca87bd2,0x0002fde60e830fef,0x00077b8c7bee8fe9,0x00030251c192c984,0x0000b0bc40c43995}},
    {{0x000e53d299f5d074,0x00060132e675167f,0x0007ce589b1afc7c,0x0006d18ac9a60464,0x000054e627504184}, {0x000160130ed07dbb,0x000342bd885fb63b,0x00069a710648bea2,0x000c83def2b055c5,0x0000a36e625f096b}},
    {{0x0008c75e1c58c801,0x000493fcc95a4ccb,0x000ccbcf92ba9de0,0x0003adccdeb0eedf,0x0000d667d4f80f3d}, {0x00014a536269820c,0x000bcfe8794006aa,0x000e5cfb2329a308,0x000b2c39869970ed,0x000033c3069b601b}},
},
{   /*digit=4 [{1,2,3,..,}]*([2^16]*G)  */
    {{0x000045511c092897,0x0007864079c97c25,0x0003879a283042ba,0x0002ee4881640c6e,0x00007c5babcf0245}, {0x00059a67088f360a,0x000d574be7e8da77,0x00033828902da352,0x0008c615800cdbe0,0x0000d69f7c9f0168}},
    {{0x000c67faee039995,0x0003c9ff7f90c64a,0x0008da6ea4de174d,0x000df7063e494354,0x0000264880c2b7cc}, {0x000f34b49b992ccc,0x000dd406586f8a18,0x000db0e21e16b6f4,0x0009f8d32479ac4c,0x0000e8151f6d62bc}},
    {{0x0002a1cc216cf37f,0x0006673828be9ae8,0x00051a85bac437f4,0x0005788c12ff189d,0x0000eb563bf24c16}, {0x00053b6c67069662,0x000a2cda87337d93,0x0004953dbcdc6eb5,0x000f7c033c186e3e,0x0000ba46a66d2e37}},
    {{0x000f516da0abf3eb,0x000511b3381eceb7,0x0004188703c92ac9,0x000066bad7320ed3,0x0000ab7a126b7dbe}, {0x00059be2def303f7,0x00079d1e0c9f77ce,0x000f418dc0bf1f23,0x00067612c18d1e38,0x0000fcc5e3f285bb}},
    {{0x000e7047e1754b8b,0x000261c0027aeefe,0x000af4e6d5408547,0x000569c5e7a6fa45,0x00004d3cd58e0048}, {0x0000014f3ae8e79e,0x0004649f3f22f2c2,0x000982a8cd0b6af1,0x000f903a1db91517,0x0000a3c809ad9ffc}},
    {{0x000c9530fa12b5b4,0x0003b7d159b4d8ea,0x000844a0d45ccf07,0x000c18a74804446e,0x0000404e6c7177d1}, {0x00043a6ce1af18fa,0x0001b7fdffcb603e,0x000bf3d178a82808,0x00028691b63c11ca,0x00004dedc224d26f}},
    {{0x000853b60aa5c141,0x00044850cc05c202,0x000abccfd1dc35d3,0x00025a8014357e0c,0x0000aa44ce9d5a52}, {0x000f9203a8444b4b,0x0004795384b0f3ce,0x000e5da54cf3f91b,0x00046a1d625ba1c9,0x0000f1fba3861d0f}},
    {{0x0005caee30ae90b2,0x0000eaabea0d0cda,0x000e678562cc3429,0x0008b7564afcd941,0x000010c7a09ef6ef}, {0x000d352f82a591d2,0x000dcb43d2a1a316,0x0004e94705fe8cc4,0x000a07d8ebce978b,0x00006c78f44da321}},
},
{   /*digit=5 [{1,2,3,..,}]*([2^20]*G)  */
    {{0x00038c7656047260,0x0003247a421e681a,0x00094956e4f8c6ae,0x0003241a51eaa012,0x0000984b1ef47c9b}, {0x000bd0d597b76968,0x000888e57ee6b749,0x000a112d29d432b7,0x0007f53092afe12b,0x00009ccee4996c5a}},
    {{0x0009d7b54089685c,0x000000818348755e,0x00061b80f9f0ec69,0x000a144cf4d8cd38,0x0000ce669fe81f5f}, {0x00025091788f9dae,0x0004d3ccf2390a21,0x000027f3b3295361,0x000bcb1048d09250,0x0000807b39e2270f}},
    {{0x000c73cdf18eddfb,0x000a92465ee8a660,0x000f950c877edb4b,0x00068baf24eff83a,0x0000822c6b31f6cb}, {0x00052f6149d2bb2d,0x000bc4a66ae65503,0x0007e1c68926809d,0x00029b9964c2803f,0x0000253298b86681}},
    {{0x000dc5595e388c34,0x00062a44e3ea1099,0x000b41f7bd0670ff,0x000305d212c99361,0x0000f594afa3af13}, {0x0008bf205c01232b,0x0006e9ff08a50c50,0x00037741a7683353,0x000d2aa1cf70bdb8,0x0000a8e66175af7b}},
    {{0x00068da909bf8c66,0x000bef4bad4a4b7b,0x000e39585b5bd7c8,0x0002d9a0ebb027fa,0x00008932a372676d}, {0x000954b730901cb5,0x000774fa3192062f,0x00047b351108194a,0x000765e32829e6a5,0x0000ca08b2eab343}},
    {{0x000c343def27938c,0x000208cee32a1e04,0x000d142da3f15ca9,0x0009bccb61573b9d,0x0000094eefdd26dd}, {0x000f1a5136bb4da9,0x00036b2f3448cd42,0x00016795e7569395,0x0007db98017cd65c,0x0000e401530bafb6}},
    {{0x000608550643d18f,0x00046902eb90a0cd,0x0007964ba821f27f,0x000ad5766f7c645d,0x000056feaa57c7bd}, {0x00029281bfda5eca,0x000e6624a7de56aa,0x000f7f3b15c09581,0x000e4b33d1a64a6f,0x000019a86e60c36d}},
    {{0x000749f9b7c6c75e,0x000d8cbca35c8376,0x000145b32680eacd,0x0006afe87fd5b55e,0x0000b20d1bb16b88}, {0x0009055779b12bbf,0x0002fbe39fb6da49,0x000a128ce6f290ff,0x000a8133ad6fe0f4,0x000009e2a418b31d}},
},
{   /*digit=6 [{1,2,3,..,}]*([2^24]*G)  */
    {{0x0004783f357999bb,0x000cd6bfacb340c2,0x000ddb9452c21474,0x0005eae3abed6ad3,0x0000b21b7651031a}, {0x000b68b8afc2a09a,0x000921306b70cdb3,0x0002eb6f51aac2f0,0x000b6f882c337185,0x0000dfe0c1b798e9}},
    {{0x000f0633fd5a1de4,0x0001e75b5b8bde0b,0x0003c617a5d05e90,0x000706bbbdb1abcb,0x00004954a8c5aef4}, {0x000eea3ff6a6e47c,0x0001cded1274fc3c,0x000abe95f6140f42,0x000813bb4b4c044d,0x000055e87db3135e}},
    {{0x000fda84e1d5d9a1,0x0005445ccdef5a65,0x000d72c0a0c0fe38,0x00013119ff360fd6,0x0000be1e8d80b016}, {0x0007e91025b45e13,0x000635259bf1b2f2,0x0001cc67e25bec26,0x00020ed7b8b4e7e5,0x0000a839aa5db80a}},
    {{0x000de9738f4194d9,0x000acb996b636fa1,0x0002053a733d2726,0x000c0c787c0ec30d,0x0000447e9cc7ecd5}, {0x000121c284773c09,0x0005115829a0777f,0x000def08b496427e,0x0007784b11978694,0x0000e7b29e72c15a}},
    {{0x0009c5550b66feca,0x0001ac065cfa1f7e,0x000d459ea5db7dd7,0x00041a3525e31050,0x0000d7abe5b21229}, {0x000ba80122d92fa4,0x00062fcc1c2487ae,0x000fd71b1066c376,0x000dbca6d767ca8f,0x0000a75fab5dcc16}},
    {{0x00018af2988abcdf,0x00007e7da51801b3,0x000836b57f887559,0x000cf3b8b9939c97,0x0000793e3b6b0a74}, {0x000008a376841700,0x000b05cb453ce191,0x0001beb2c7708823,0x0008f4ec221d4036,0x0000e5a6cceeb1b6}},
    {{0x000a0068ae66f002,0x000e98d648f0a6f0,0x000d2880f2620157,0x000017fc71776240,0x0000e0e293cde105}, {0x000f214854116f41,0x00003d5cd4eca320,0x000fc1c555e4fa70,0x000a1583fa0a23df,0x00008fcb8d2d9a9c}},
    {{0x000995e2a8ed3d7c,0x0008ef319e47285f,0x0006d98a29dc712e,0x000e35c4402eff53,0x0000a61e310f7521}, {0x0009621c3196672f,0x0000ef17e8a70ed3,0x0002a7c4929e7744,0x0006da47eca48841,0x0000011451423a2a}},
},
{   /*digit=7 [{1,2,3,..,}]*([2^28]*G)  */
    {{0x000a12ae6880b5f3,0x000d12606d252675,0x0003b21259ba1e92,0x000099b012facbeb,0x0000c50fdfbf37b0}, {0x000461c9ce223e96,0x00074efbd8ac69ce,0x00031ea8ecb90bdd,0x000ff6f657e5a4c6,0x0000584520b98a83}},
    {{0x000f317635abcf02,0x000fb9e17618b959,0x0003bd99ba516a43,0x000290ed90ccf2ce,0x0000fc6d460c9fb3}, {0x000be090cde43021,0x00000908003ba61e,0x0000f57875a3b062,0x000c2ff51bb736f6,0x0000717f6e9157ef}},
    {{0x000cf931ca260efd,0x000ec1811d22865a,0x0003e42c87d6e797,0x000158e63c692078,0x0000c9dbce95dcb5}, {0x000dc7ac8e39022b,0x0004e0ebfe466426,0x0007d6395f3037f3,0x00053975aa6845f8,0x0000f792fd611f53}},
    {{0x00021726ddc3d836,0x000f388207bb48bf,0x00003bd7ef68deb6,0x0009a4a8eae2ebcd,0x00004c7f57ef51f5}, {0x000b223a1786d576,0x0000d11827902bad,0x0005a94572e7fda6,0x000e079dc90e369a,0x0000eca838c54b07}},
    {{0x000235b032648719,0x000448b933de1d2e,0x000354c8eb4c5624,0x000c76d9c2bdda91,0x00007d743fffa73f}, {0x000109dce88013e3,0x000623b3bf4f8ed4,0x0001e761ca242827,0x0006c2900d356001,0x00004925d7e124fd}},
    {{0x00066caa81982353,0x000d1d2d7649d8b9,0x000d63f3a355d098,0x000140fac27f7ca3,0x0000e553f6d03edc}, {0x0002c7f11ff4334c,0x000c7c62cb56a4d7,0x000a2108248735aa,0x0006fdcf064294eb,0x00001f9e4577b8d9}},
    {{0x000bdbc293cd9450,0x000bea254e361d24,0x0006fb48576985bc,0x00073d3df2cb6a87,0x0000176969fcd1f6}, {0x000cacb642133a78,0x0008b73880e20b41,0x000b1463f31ea88f,0x000a27ccf1ff85b3,0x00008fffa162ca74}},
    {{0x0009b92167cdd1ff,0x0001e879b893aa4b,0x0005479f5a9118fc,0x000292f6e73387c5,0x0000adf82eeb626d}, {0x000b76156e80e6a2,0x000a127555d1803b,0x000087e4359a783f,0x000ded027d63b63d,0x00009f9ff3222fde}},
},
{   /*digit=8 [{1,2,3,..,}]*([2^32]*G)  */
    {{0x000f92d0cf4efe5d,0x0005660e2d221cb8,0x00059f07988c4721,0x000a7cca9549ef60,0x00000a3774b4016d}, {0x00095f61d001cabb,0x000053feeec1251c,0x000fedf2b2d744df,0x0004a5b7c20cc20a,0x0000f16c5f221d14}},
    {{0x0005450677b7a8f8,0x000f669273d20112,0x0002c5990ba889fc,0x0004c34a40a85958,0x000036638b474893}, {0x000e189f3596ba60,0x000ede8b0754e964,0x000f93f1b2f417c0,0x000389d883169fd5,0x0000318fe4ed45bb}},
    {{0x000e34d674d10cf3,0x0009cf962ec58559,0x0002af42d6955bb6,0x0002568bf1ab6c54,0x0000f2f33fb0fa61}, {0x000019573d1049ed,0x0009afd7f39a6214,0x000237be0f508927,0x000e57b42eb51cb4,0x0000f747f45574d0}},
    {{0x000537af0c1bb4f5,0x0000206b90f4d6bc,0x0007c89cf37f3770,0x0000034d48d994be,0x000011c2158dd572}, {0x000bac1088dda1ee,0x000a5ad4934be26f,0x000dcaf7cc3d5518,0x00073d5233c17685,0x0000c3a8a2a888b4}},
    {{0x0000fbb573c9aaf3,0x000a13cc6c7870a3,0x000cc5c2f0e71124,0x00003e3b57c921a1,0x00005b1badbfd70c}, {0x000286a9384dc1ec,0x000903a5febac82b,0x00046e3c694e98c4,0x000b10f2872b3abb,0x00008258ff96fa45}},
    {{0x000a3a880b5f763f,0x000a54ed2fd06e09,0x00069d361c365267,0x000a6292b39fb7bd,0x0000801859aa1386}, {0x0002d562056479b9,0x0004e837087f6f64,0x000a2e3c3ace29a1,0x00010ad5dac94ce8,0x0000f0d3dce1bbf8}},
    {{0x00001c95b2614292,0x0003bf1c4c90e560,0x000708120f1566d6,0x000a442e30662c3c,0x0000130cfa81a306}, {0x0001a8e4f57f7720,0x00069cca3398686c,0x000fde0e6d53c9e6,0x000b53a355d4890b,0x0000daf31990e2ee}},
    {{0x000667ab1f0c1753,0x00015ab99e7dcd96,0x000e43f9da256a61,0x000cd6ff07c1ea05,0x000005700bcae1c9}, {0x00025462b2887a31,0x0009d772fd142f1e,0x000584057dd782f4,0x000cf99125f99638,0x00009fd039626a02}},
},
{   /*digit=9 [{1,2,3,..,}]*([2^36]*G)  */
    {{0x0002bd34c58174d5,0x0003f900551f58d6,0x0002802c3872251d,0x00055506f5862df1,0x0000d93c48b2d925}, {0x00067d5bd6006f82,0x000c196ccc67a39b,0x0003014dbea6f756,0x0002c0140e853e54,0x0000bdc567509de4}},
    {{0x00058faeda49f746,0x00076e4545a39a1a,0x0004c07e4ddb8995,0x000008d3576489c7,0x00004e4b39f159b1}, {0x0000340f66b546c5,0x00041deb912eeb09,0x000e55cca0e0f401,0x000768bb00b46c01,0x00005b61b34e9ad0}},
    {{0x0002337e989963ee,0x000fb3778d59e0d2,0x0008c41782c4831c,0x000894d775c6a5ee,0x000023916557d0c2}, {0x000fe865d0eb314c,0x00004b2290d337d4,0x000cefa7842801b9,0x000fea73e9b332cd,0x00000d169d9fe877}},
    {{0x0002370734a13273,0x000c4951afa89ab0,0x000638b8aa1df7af,0x000aa6581cfbaf42,0x00009db6d2b5130e}, {0x000805bda2f91a5a,0x000f8569add7abbc,0x00021fa7d3dcb0a7,0x000008724ab65ad7,0x00005152b96988f8}},
    {{0x0008dc441177a460,0x000b7f039a7bedf3,0x0008ae7c2d9a955b,0x0008194f1525814d,0x000063c9f834f848}, {0x0004526841e87839,0x000a3a5f2b31c4ea,0x000846dcfe86a411,0x000d70b7529a3b19,0x00001356a07c5689}},
    {{0x0004dea8910763ed,0x0008d76a0f7f958f,0x00065f9b96e5fcb4,0x0000c56a5447a4ab,0x00007d863d5775bb}, {0x00034a7e87e79168,0x000a4d961e88006c,0x000fe6aeb0539155,0x000ca15def2d8874,0x0000ac350b379226}},
    {{0x00035d081443d166,0x000b06cc364b9f96,0x000bf84382342cbf,0x00029863b0a03225,0x0000ccd3ce60078d}, {0x000d10891292fd30,0x000b14073286f93b,0x00062cd16c887a31,0x000b46eb1275bf9f,0x0000335bae361578}},
    {{0x000aca7614d9ff3c,0x000cf58f2459fee2,0x0006f62abd1f13b2,0x0003749e92d83fc4,0x00001dd32de427d7}, {0x000d593c3e566e7a,0x0007a4ccb02a7636,0x00035b65281c2f4e,0x000d42b57782c6cd,0x0000d88787f28210}},
},
{   /*digit=10 [{1,2,3,..,}]*([2^40]*G)  */
    {{0x00083c6150b0fcd3,0x00011d9b0f4c85b3,0x000d05413f948da8,0x000e64cf075225cc,0x0000f31b12c7f62b}, {0x0001fc8368c17f6e,0x000a200bc68f43b2,0x000ac140e423d536,0x000d615335dd1ede,0x0000631c24a7493a}},
    {{0x000262021afa86f1,0x000396b11457a23d,0x000148d30ea757f0,0x0001700bc4d2d1b0,0x000019b553598ce4}, {0x000bb670aa9c8f62,0x000ca8e05de28ab5,0x000f1e9c3dfc9693,0x000b9c6cae7e57e3,0x0000b1ceb548f6c3}},
    {{0x0009fcb03cdcc63a,0x00026fc3afa8c753,0x00099aa9772fdb55,0x000651573534e102,0x0000ffe7179c664d}, {0x000fa10f5ecccf0c,0x0000003d6c622660,0x0007f57868df4395,0x000d741bec4f0f31,0x0000019916d7a461}},
    {{0x00035ca876361830,0x000a719d1ca312e3,0x0004161d81461a65,0x0001128150080ab1,0x00008da4ebfc612e}, {0x000fb6ba8498a9af,0x000eaa0f8db9d95d,0x000b4f497099cf91,0x00030612d2ae144f,0x0000a3a28b123cb7}},
    {{0x000577b9ec7f1ff9,0x0007936c299fce38,0x000f0939b9deaab6,0x0005c0624127222c,0x00008c2a3492b510}, {0x000a08656706b8d6,0x000bd14add6ad069,0x000d85a98a2296ff,0x000bd6537a875bde,0x0000705fef2603de}},
    {{0x00079bdc3141d130,0x0002918736859cd7,0x0004305b9e4acdef,0x000d6de804c2cc4e,0x00003c2e8392d86b}, {0x0003c44aee7c9a30,0x000a9f8d49b095d5,0x000c57bc9b303ea1,0x0006a65c3579b5c2,0x00009ac7359ad03f}},
    {{0x000cfc3afb8cec58,0x000eb630ab5869b3,0x000322634533076a,0x000a3dd50dcfb8f0,0x000053af6f4fb737}, {0x00062cefa4582dca,0x000b14554a478703,0x0004c8a663019bfd,0x00010e61487a210f,0x00005b5f361c1306}},
    {{0x000c5d00f01c7cee,0x000e5283bdefe89f,0x0001519236fc45ff,0x000cc971dece8181,0x0000d1cb14da433f}, {0x000612bd3959bcfe,0x000c15b5732e6279,0x000d0a1cae163880,0x0007f335414ca771,0x00008b9e6520c1e4}},
},
{   /*digit=11 [{1,2,3,..,}]*([2^44]*G)  */
    {{0x000a78a08b213629,0x000069fe0b35cce8,0x00087837cf37f5e8,0x000993dca66c7f2c,0x00002524b949bf2e}, {0x000020c71745788b,0x0006ecbfbf4c4c0f,0x0003de1c86018de4,0x000e41a8446691ac,0x0000194d41a0de5a}},
    {{0x000a4a89ce76a94e,0x0002a0725c9649aa,0x000e16665847cd08,0x000fc40c099e9097,0x0000409ffca6f7b1}, {0x0005b80690941ed6,0x000af2c0ee9d6057,0x00075837d8e25100,0x00022b71662d279b,0x0000eeb9e98456bb}},
    {{0x0000d52390e35da2,0x000347a9947be434,0x000cc7a3fc098e3d,0x000df6e6d781989e,0x0000c39102e43aa6}, {0x000ed0d300f3cb15,0x00072cfbe054683f,0x000cf45a8c0b1e35,0x000eda3da2224c20,0x0000be55df77f30d}},
    {{0x0006e66528960b13,0x0004084aecb383e7,0x00012ad64445dc39,0x000e371361843616,0x0000ccbecccbc831}, {0x000bd416121383c2,0x0003a0d895a2efb0,0x0003f2f1e316164a,0x000225c3d3415323,0x0000905907000d92}},
    {{0x000f0d3a3d89e152,0x00092d07f5eb1d0e,0x000e4887a4d5a30c,0x000349c359e31073,0x0000f4c6b7efbdec}, {0x000d3e9ba1426435,0x000e61c794b675a1,0x00010c63d8f4fd58,0x00076ccad091d118,0x0000b61623a40bfa}},
    {{0x000afb7b790881c4,0x00047663e76c567d,0x000e824902002b8e,0x00047a3bd28edef8,0x00004dd2e818bb2a}, {0x0000dfedbc3f2f8d,0x00033e2eec700e75,0x0004c4d2fd9b6e91,0x000be2e8400e2f1e,0x00003325697f3217}},
    {{0x0008e40347dfaefc,0x000e24464bf2717c,0x00064ec20795b0f7,0x000d3f15dc99d613,0x000007fce2951600}, {0x000338bc8bebbdac,0x000768547c02d825,0x000040b845e5e89f,0x00033d3c50032f1a,0x0000ea7544feb3a5}},
    {{0x00087934d217a2e3,0x00064fa4702d663d,0x000431f1b099e8c5,0x0003996d91bc47e6,0x0000fd21287d5f61}, {0x0000bae682fa08b0,0x0005c1ca371c2fc9,0x0001c428f51699c8,0x00050416f29d7483,0x0000ecefb669fa2b}},
},
{   /*digit=12 [{1,2,3,..,}]*([2^48]*G)  */
    {{0x000eb9068755cf37,0x000eefe125411487,0x000af8ca81887394,0x0009dc2e4c65d446,0x00002aae64629e11}, {0x00000941ec6ad734,0x0004cce4573e558e,0x000254b9684a7eec,0x0007323d6d00d4f9,0x0000ef44f58ce421}},
    {{0x000e0f87d3ad2ac1,0x0001d0f92c5ce59d,0x00000b6a5d2670cb,0x0008eb8f05944ac9,0x00001aeed239d966}, {0x00038e47c488ea6d,0x000848083d7451b0,0x000d31fe2406ea3f,0x000f9ad22197b43b,0x0000c8f8ccbf8a6e}},
    {{0x000cfbffc9188216,0x000c7e0fbf5fd2b3,0x00062452f51cb7e5,0x0009f0a73f6716bf,0x00002b74252c05f2}, {0x0009d259e88b0f1b,0x000175841f6142f1,0x000378ac867525d1,0x0002d6e54c3b5661,0x00009fade95d9a45}},
    {{0x000648302887281a,0x000c1f9de66ec79a,0x000a7dee213f3d39,0x0008b8289c3c50f1,0x0000510a53ce0b69}, {0x000c3fb06f799adb,0x000a653746501566,0x000c947b2cc95a87,0x00051bbd7343c061,0x0000bbff69e4543e}},
    {{0x00041aa7a0a745a0,0x000243371bd1327a,0x000b5f82492d43e3,0x000478cde41b9031,0x0000f5e1e18cda04}, {0x000c186247853141,0x00025ef5518b5db2,0x000b7c8ee0c4cfdb,0x0009d7acc9f6ec1f,0x0000efb06595d6c0}},
    {{0x00038dcba75aba90,0x0006d150f881b80d,0x0007b47c5e9b61ac,0x0001289f56af52ca,0x000040300d977fb3}, {0x0007184c01fd0c1e,0x00056b6e134a5687,0x000d7165340112a0,0x00062e56daed90cc,0x0000c553aa7974bd}},
    {{0x000472aab109ef7c,0x000d759b268a33d8,0x000314e79dbdfe41,0x00077c147dd06eeb,0x0000ae5583823c5b}, {0x000d83c8b1c89525,0x0008f1ba0321bc8b,0x00098beeecf4b71c,0x00034268f32934ea,0x0000580dbb671a4b}},
    {{0x000381d11476ddee,0x000dfea0923e2398,0x0007745bd4959204,0x000467d67427ad01,0x0000f022a754935e}, {0x00099f524e0380a0,0x000fb5f1a73057e7,0x0001771d86ee2b64,0x00013c9aeaac4852,0x00002c8521c0992a}},
},
{   /*digit=13 [{1,2,3,..,}]*([2^52]*G)  */
    {{0x000c43b153adbf74,0x000fc0351fec7fe5,0x000109e6007a66ed,0x0001623d8042353b,0x0000dc97176e832c}, {0x000c75fb1db1e5c9,0x0007315b98ff73fe,0x000aa1cff6aa02da,0x000a265f9e808f4f,0x00000aa28be36412}},
    {{0x000f1c99ce0fcd68,0x000eb232a8468dba,0x00075d822732ea65,0x0003cadb2ce2186a,0x00008ffd479bd227}, {0x0002ad2f2f26b61a,0x000e086706aae909,0x00023597cfb7041b,0x000c84e3d5fa755e,0x00002035bf8f995f}},
    {{0x0006c1ab9ac4754c,0x000a0d3f305a1b45,0x000a62dc0f497e6e,0x00094f84d27e3a3f,0x000018c3569e524b}, {0x0008954e380f5cb8,0x000ca72ea4581219,0x00032849181d8221,0x000ccf6fa082f65f,0x000010ca5b00e304}},
    {{0x000b892313de667f,0x000856a478a7c5de,0x00099242875c872d,0x000e09b67b5513c4,0x000097e010fe70fd}, {0x000f05360ee268c1,0x0002067cd32139b0,0x000bc187c981b514,0x000da8b5a1ac8d4f,0x000062417e2d12e6}},
    {{0x000e262502e26d19,0x000cc294e23f905e,0x000a7733db961ef9,0x000f737178f1fb6d,0x000089b69fbb32ec}, {0x0008a359a9bccae8,0x000bc00a01f33727,0x000b213bab1c81a0,0x00017e0781855aa6,0x0000acc1b78b4298}},
    {{0x000d3a83016e5135,0x00004b0f7bfadbde,0x0002be716a3c508b,0x000b9fa6a490deaa,0x0000a04d9e644485}, {0x00099d16ad25b5d0,0x000965a72cb4d07b,0x000c45a95a184010,0x000cffc8e2b32d14,0x0000fae6e86e4f2e}},
    {{0x000115e55a0c9314,0x0009e5c920a3d764,0x00090371034ea18b,0x000c7a6a099ddcaf,0x0000b937dc2249f2}, {0x0004a1a430f0a7e5,0x0008921dbe965cfc,0x00011d3fe8f106a5,0x0003c548ac702618,0x0000484226b080f1}},
    {{0x00050f8849e6d32e,0x0005de16485df445,0x000343924e7bc29d,0x0005ce29bbfec62f,0x0000eb802f320f2b}, {0x0007542bbb64f333,0x0006cf9bdb3bfb33,0x000a1cb884c1d3a3,0x000b6e1067cf3bc7,0x0000f12a31d7601f}},
},
{   /*digit=14 [{1,2,3,..,}]*([2^56]*G)  */
    {{0x000a78f1f8a4a913,0x0001a53dbe738720,0x000d0991a59e2221,0x00026f9f5ad99cad,0x0000a0db802a3807}, {0x000761c7dfb4f1c5,0x000aaac819cce7f0,0x000ffe34868e7098,0x0001409683d61037,0x0000bf205e57b7b5}},
    {{0x000b5f661a972624,0x000bd74a82f75846,0x000439654edf2cac,0x000e093dfab85faf,0x00003fb0efa0724e}, {0x000016f53b0119a0,0x00035bc8fc81d0d5,0x00065d2986844536,0x00064f6d10b6491f,0x0000f3c88c621a4e}},
    {{0x00072a17f34c5177,0x00069378bc26c203,0x000aae0245602bd1,0x000daa666a592d91,0x000016886aba17bb}, {0x000fe68e30451039,0x00030de1d7013e55,0x000724cb6f2c4b0b,0x0003148da358857d,0x0000aac623d2ec47}},
    {{0x000ff46b8529a018,0x0002c856b95c024c,0x0005af7f76e4d82a,0x000e5358c6b833c6,0x0000a6c41262e110}, {0x0007c304f0833403,0x000b476cdb310820,0x000882de171aa384,0x000e4a1ada294142,0x00008b1ad2ef16a2}},
    {{0x0002720142bcb30d,0x0004caf604d0edda,0x0007963145617526,0x000d19086189c1e6,0x0000ab01c692b04d}, {0x000e4b0ba8ed3c18,0x000c6281acfb4e54,0x0000a6319f616513,0x00087baf1796295e,0x00005e79ac9b28b5}},
    {{0x0004588c9fd7da08,0x00009238d0c391d8,0x0009d6475a78682d,0x000e18333ddde082,0x00000c88440e9de9}, {0x000f21ac6d8176ff,0x00059509d46f6d15,0x000bbfcd5daff943,0x0006880191bb0a8b,0x0000f7732b8f8fc2}},
    {{0x000772d5ab3d89e9,0x000a2a786c9072fe,0x000323866f1580ec,0x00096f8fd834175a,0x00003711d4a4adec}, {0x000c34a6b9b4a308,0x000138b0de23a020,0x000de3ce5bf10e00,0x000c632a5f298d28,0x000007a398f7e1a1}},
    {{0x00040cd73f7c45c6,0x000d6afe059c3fb6,0x000b168d4eb1f87a,0x00003fa3c3979a52,0x0000eef460cdb1e4}, {0x0003e502724bb3f3,0x000c29d922d13d94,0x000538b4a53f3f1b,0x00045f547e7a03cd,0x00007631e2102c41}},
},
{   /*digit=15 [{1,2,3,..,}]*([2^60]*G)  */
    {{0x000bf06970e164d1,0x0008cd3d3087a7c9,0x000e7c899c27a88d,0x0003718a37c9cdf4,0x00008494d5abb411}, {0x0002375d9d8b29c0,0x000c915a2f740653,0x0005acb02b92dd45,0x000a898a23f6bf51,0x0000e69248c435bf}},
    {{0x00054fd6113a9f82,0x0004070e67e63614,0x0003f2feb78ebe73,0x000f368764360b90,0x0000ba3b3d8b7902}, {0x0008cef87490b8a1,0x0005005f31b31880,0x0009b4f4db117595,0x000e60bd5d60056c,0x00002b13fcaed254}},
    {{0x00074449a7a4edea,0x000695cfd20f1f84,0x000b33b64b26b1f1,0x0008c9f380ed7d83,0x000021f9564dd199}, {0x000c7d3a720e347f,0x00057bdf09d4e985,0x0009476929807897,0x000385a1f34ce2ce,0x000069e6145e419c}},
    {{0x00071ef16f55d400,0x00089bb45ea57fc0,0x0005543ca7019543,0x000c1983cf09f2a3,0x00007e91a8420554}, {0x000d70162a9d06ef,0x00031044a66261ec,0x000423dd900e14c6,0x000b4cb1317c1300,0x000049431bd946ea}},
    {{0x000548a60bffa601,0x000b7e0c4e341ed5,0x000db5bad903708b,0x0008a5cbc42d78a1,0x000052ad7377be14}, {0x000cda3ef8265d6d,0x0004490c675cbb3f,0x00033d235cfcb34f,0x0003cb0c2954b5d3,0x00004a7d16a1a320}},
    {{0x000dffbcdc0e5cfb,0x00040f611432a75b,0x000c16d43eeb8cc1,0x000997e3b489f974,0x00005c174e0722ed}, {0x000a9b6afb9c1d83,0x000295cb574a38ce,0x00015c4a8da546da,0x000307688d2edc0e,0x0000ffc898fef45b}},
    {{0x0005f1be45b69cf1,0x00077a5a8c531e35,0x0007d0264570bb79,0x000a61a0a43c059f,0x0000cd74a04320e4}, {0x0002e876cf3ac0a3,0x0002b212cb77fc35,0x0006c032db7672e6,0x000bc2045a0ba3fc,0x00003e7bc4433ad9}},
    {{0x0008434d0614aa12,0x0009f14184341511,0x000c15b898bae977,0x0002ebf5641d82b8,0x0000383af5661643}, {0x000d3f02c73f990c,0x000f66bbdc7ce552,0x0005ec6348df82e9,0x00053f0f336aa8d7,0x000042e3b2dd603e}},
},
{   /*digit=16 [{1,2,3,..,}]*([2^64]*G)  */
    {{0x000e020bad830d23,0x000e890dffb31b33,0x00080ecb05c101f9,0x00093ecd0e0498bc,0x000002787f882aa2}, {0x0004ced220f8fc84,0x0000fe0ee3777fd6,0x00013b128cf5cebe,0x000279dc03a03889,0x0000b0969723de23}},
    {{0x00089aff727ef3ad,0x000603db88fa9c53,0x000ae077795ffeb9,0x000f0227cb70429d,0x000020afe82316db}, {0x0008e18914bf7060,0x00030517cd090fab,0x000e406443b1e66f,0x0008fa24b46dce12,0x0000ff1016808f2d}},
    {{0x00034c883dc54470,0x000b04e4e9a0e55f,0x0009166a2be76243,0x00080a78fb4cbc81,0x0000bdfb703ae37f}, {0x000288ec217cda8e,0x000242af41561869,0x000ae9d302662bb7,0x0003c9ce64f29150,0x0000e0d4441bc035}},
    {{0x000aaddca9a95262,0x000a89a303e9913c,0x000a50f3c701c63f,0x00057fb97d667ab0,0x00007c03d7c88e65}, {0x000e712eb1056070,0x000d8dd86ccbab24,0x000986d684936aed,0x000a6532196f8a0a,0x0000307b826248f5}},
    {{0x00058b5ebbe949f8,0x0006e982215ad88f,0x000f863c0b776229,0x000f513cc83dd6cf,0x00001ec094d81098}, {0x00069aabe0432d02,0x000c8455957d014d,0x000dc1eabe4e52a9,0x00016f94743ba8fa,0x0000c395d97a1763}},
    {{0x000ab7799458b24a,0x0005ceba3064364b,0x000068f036fe19e2,0x0006559aabd83d74,0x0000ef812190fdf8}, {0x000d27b65593fefe,0x000edaa457b21506,0x00003dff40a1ad85,0x0006e3266d0f06a3,0x00008114f4f8bb41}},
    {{0x000e2d38fc2ed938,0x0005f8f0f8582acf,0x000a35ec48344664,0x0009b158de6f09dd,0x000091e5ece778c6}, {0x0004ba991c13d675,0x000d987d5575af4a,0x000303a7e6e78063,0x0007ed226b621e8d,0x0000c9bc10419598}},
    {{0x000581a88a45b65d,0x000138e58c1b905f,0x0005bfe1ccb78920,0x0001d714cbed65bc,0x00001af7dc8c02b1}, {0x0001bc0cd3a7cc82,0x0008c01a77b79834,0x000e2a4028e9aefe,0x0008598eeafe875a,0x00007a0698fe11f3}},
},
{   /*digit=17 [{1,2,3,..,}]*([2^68]*G)  */
    {{0x0005759c85448853,0x000aabfcad786b80,0x0008fe78ebe9b99c,0x000bcfd1db36e12b,0x00007255a2e05387}, {0x0003a3ea150ad323,0x00039671ae58d44b,0x00052384bc65bc2a,0x00030041ce078e1d,0x0000115f1b1ce72c}},
    {{0x000517480eed542e,0x00021362ef7e34a4,0x000dd0396add6456,0x00038b39228bfcc5,0x00009fdf904ca0c5}, {0x00091ec74d235de0,0x000824aa0a476bfd,0x0008d616896ec237,0x00060bf5699241af,0x0000a7b9be3c548a}},
    {{0x0002854f2b4c5818,0x0009ca26223a3e67,0x000aa188c6df8d84,0x0004ebd1debdf2e3,0x00000bfdc0a33d8c}, {0x00049164502ad485,0x00013c4eec044436,0x000526b7ad1ce82b,0x000ec1b7c386c272,0x0000a6cc4f4bb8de}},
    {{0x0005c302ade9556b,0x000c25ba2e9b3525,0x000ce9e47e328af1,0x000cc99d3391ef41,0x000074cd669ab0ff}, {0x00003e4e3226acf3,0x000d02959e429671,0x000d490fca65ad22,0x0003563aaa840699,0x0000e26a1c2cecc6}},
    {{0x000c3180561c002a,0x000500356bad1178,0x0006c78568e636d7,0x00001af8d07145e3,0x00007730567cae79}, {0x0005ddcb77d9db90,0x000989d16e89691f,0x0005142a2f824b7f,0x000bfaafb5c9b7eb,0x00009b34446f6015}},
    {{0x0000be45824c88aa,0x0001e847b35a949b,0x000027aa0e3a35e8,0x00082301594fd284,0x0000aff184b8e873}, {0x000e135810fa4740,0x000a8f7398d7d5fc,0x00096a1f3aba6165,0x000924e3aaa99a8a,0x00006ff0fd3b6295}},
    {{0x0008b7dfddda1bc2,0x0009d5f713ecc26b,0x00012edcbc93512b,0x000095029ffeb33b,0x0000ea0649923564}, {0x000b5a0fcd32167d,0x000a0c2eb30bde37,0x0006cd0182008416,0x000502b2663d607c,0x0000810c96305b2b}},
    {{0x00075de4e92defc4,0x00041008988331c9,0x000c0919081aeb17,0x000d648a30ce4a2e,0x000026e7838a9a36}, {0x000a0b6309bd2d7d,0x00000cc1a4ae8899,0x0005163b33b1c24b,0x00086db2aa814234,0x00002ad9a69fc78c}},
},
{   /*digit=18 [{1,2,3,..,}]*([2^72]*G)  */
    {{0x00033c6ba4e4651b,0x0000b714d4ac4672,0x000f1f8da8cf9566,0x00070ed70decc371,0x0000674732b20783}, {0x000416d4ccc773bd,0x0006ae87951d7270,0x0003dfb56c848ff3,0x000110a61506a849,0x00008371eaa467eb}},
    {{0x000ee2fda3adfe0b,0x000cbc964e7d1066,0x000859476ce6a9bd,0x00099c04a0115b0c,0x00005e02dca4c956}, {0x0001f6211377eb91,0x0002272bca2ee830,0x00047cf1f57b245a,0x0001c1a7d9b4707b,0x0000b469bab2774b}},
    {{0x000fa67dfd6586eb,0x0005cba23faa1dfc,0x000ec5d6f358953e,0x000b2a0f467275ae,0x0000815967b0b0e6}, {0x000f133012b89b41,0x000c7839cc04a01b,0x0000dfd73dd924bb,0x000098a5cd218012,0x0000abb11ef29bf8}},
    {{0x0007889f1ef22320,0x00019c7409a50397,0x000004e03be2c82f,0x0003a335ac44f932,0x000048bb35985682}, {0x0008d6cec1cf253f,0x0008603eb1d13e10,0x0000ac34de98e74d,0x0007facaf64f6057,0x0000f814e7e3d779}},
    {{0x000b2eb0d1b96aa9,0x0003ce52ccf0cdee,0x000d534ef25783ce,0x000dade4e251f429,0x0000fe9693de5797}, {0x0003d69c6ab9935e,0x00095721ca8d8a17,0x00093eb262399131,0x000a9e38cbcd30c3,0x00003627aba51d95}},
    {{0x0000e575ef764b4a,0x000d5e73c69849b6,0x0002be1ee61ad29f,0x000a7118489017dd,0x0000c95e3b71febd}, {0x00053465ac960924,0x0003ffc835666698,0x00072fa4a906265c,0x0005401692c81259,0x0000e76f87940773}},
    {{0x0005c3ea7b82f5c5,0x000f3a98adfad6a4,0x0004b182c494694d,0x000b4144a06ec313,0x0000570befac5b82}, {0x0006808129f952e9,0x0000214f87c3f19f,0x0007be905a6fad26,0x0005c2831e56687c,0x00003107f397623a}},
    {{0x0001bcc89e35108a,0x000433f1cbaf57cd,0x0005b13ac924efa4,0x000a1de3716559f3,0x00000a88e8800370}, {0x000be0a8c286ea33,0x00069ebd50c6e203,0x000284d0897fc5ab,0x0000e02b5b360274,0x0000055716f994a2}},
},
{   /*digit=19 [{1,2,3,..,}]*([2^76]*G)  */
    {{0x000a63d5b99708d3,0x00077b80189a4d67,0x0001c402efb29bef,0x0007673cb7eeaa24,0x000028cb6de5c5c2}, {0x000a7b49cec231d2,0x000c2e2e6a7eed24,0x000f17b13725955f,0x0001cfa2040cfab7,0x000015eff8dc25c7}},
    {{0x000cab1c0d41a942,0x000abe60f7d4c4d9,0x00036116cc38b202,0x000f132bbf6b1793,0x0000f9aa8774e068}, {0x0000627a4bac9fd4,0x000eca593cb4b882,0x0004179312209cb9,0x000fbfaa78ec63c7,0x00002d21251bcfcc}},
    {{0x000fb305334d7b56,0x0005a11f7073b233,0x00097794e41b5755,0x0000dd099a53713c,0x000056ead5a9a5f0}, {0x000696f1e3511dc7,0x00070e5e30fd2ece,0x0004ace651828a64,0x00061ce007b8ff60,0x00003da66390b892}},
    {{0x000e5ae3e6119407,0x00097aa090ebd0ce,0x000926e424e2d9ea,0x0002a373d167ef1b,0x0000fff36dfcd511}, {0x0007745caffa3fbe,0x000fa5a835034558,0x00047bf2a224f7f4,0x0005c65ceff0183b,0x0000d9bfa74ccfab}},
    {{0x000c13c73f076b32,0x000eaa3baf1a5581,0x00086b1ccf225af7,0x0005b36fa0d82d4e,0x000009f416823464}, {0x000cfcb2fbe643e7,0x000163c46a73f613,0x00019477d806abcd,0x000c02d04bc1028a,0x000068888cb668be}},
    {{0x00070b8d9b429c9a,0x000765ad81cb53d5,0x0006825bd6946011,0x00036a30833a082f,0x0000297122b1c99f}, {0x000b84805c3abdf7,0x0008cf2e24b1ffc9,0x00015d922efe9529,0x000726f045275a89,0x00009146aab998a9}},
    {{0x00051d89cdbd4b33,0x0000e1195d208087,0x000c6618eae8de7a,0x000cfbdb08e2fc12,0x000097fc24f3fc4a}, {0x0002071844eeaa70,0x000b2c004c259869,0x00035fcca2b3e1e6,0x000be4a1211da1e8,0x0000c881208c73ff}},
    {{0x00059054f831d0b7,0x000c9d47d4fd9c7d,0x000042e12faaaa26,0x00077d5ac2859985,0x0000eda370be7969}, {0x000d71d95c0be637,0x000cfe8210052f0b,0x0002ffae97c4601b,0x000173f1ecbc604c,0x0000e3efc580b688}},
},
{   /*digit=20 [{1,2,3,..,}]*([2^80]*G)  */
    {{0x000ca15587feffa0,0x00007d69e4ad8348,0x0005a0745585d074,0x0004dd6fbe561988,0x00004ee9ebab10b2}, {0x000075c0f4c12d76,0x000c9c51c604fc27,0x000e336d0acf4acd,0x0001d2782fa52bfc,0x0000e1d078fa8362}},
    {{0x0007a1bb2b806a85,0x00010ad5d0f42438,0x000a0e9e414efa30,0x000decee7e442123,0x000004ae4288b6ab}, {0x0006fcb927b1aac6,0x000c923b71d358c0,0x000d6dae155e1c85,0x0000b8f47e180f48,0x0000d80dd64084cb}},
    {{0x000c3819ec64698b,0x0001cef36dd1f0db,0x00056bdfd770e4d1,0x00094701d179158d,0x000048153ce25eb9}, {0x0007a54fde983909,0x00079fe2d6fc31d1,0x000a704f10817eaf,0x00018244a63591a6,0x000042346600f554}},
    {{0x00086430d7fff59a,0x000407bfe742e8a6,0x000ce06f982b9219,0x0001341a8b86cfc2,0x000038414a199ad6}, {0x000261028e2c39f1,0x0000580856a06f10,0x000c3034d34805c2,0x000c9d1b3f930218,0x0000713f457674c0}},
    {{0x000c8821b96672b1,0x000b479d1f5709cf,0x00069a5142759c76,0x000413a6cc7a9822,0x0000bc2015b783b1}, {0x00011781bf4be622,0x00059bf2b0bea43b,0x000591cfdd294197,0x0004951eac3587c4,0x000083169e62e66d}},
    {{0x0004800da0723bca,0x000093c8381d3859,0x0008ca980524452e,0x000e56846dfa0213,0x0000a77a80d82d32}, {0x0003fbc419c86b5a,0x0008570216c28757,0x0002036e6e748680,0x0003d88b7a685ac7,0x00001764627b5fae}},
    {{0x000d0556b1fb1041,0x000441fe146f9ea8,0x00063c4132ff339a,0x00097b3d7ef85bcf,0x0000f0f57c5389a0}, {0x000f83b5bda1160f,0x000e5fea66e792f2,0x000e11651433eea4,0x00043b1f3fff4fca,0x0000a71c3fe5b1c2}},
    {{0x000edc2023cb0df4,0x000e15a245918b52,0x0002a907208773a4,0x00086e0d9a6aaae1,0x0000261f56f9bf55}, {0x000040260a081069,0x0004409cfa60884b,0x000dae4831b39805,0x000cdedf7f55b1d5,0x0000554210f16ef2}},
},
{   /*digit=21 [{1,2,3,..,}]*([2^84]*G)  */
    {{0x0006e859204db305,0x00087aa84cdf064d,0x000476456139bb92,0x000a669413d7ea88,0x0000c554483aa1ff}, {0x00030892ed180808,0x0001514e5daefb86,0x0005f81ca589aaf2,0x000415eee4f96f7b,0x00008d470079bb0b}},
    {{0x00000d355c9bd11b,0x000cb6fc28506bb4,0x000063b3e8402465,0x0000c6a81ba22d65,0x0000ab2dcbd1e1aa}, {0x0003f1abe645e253,0x00037df84be1b5f4,0x000a2eaf46232053,0x00026f14ac708021,0x0000f94646488beb}},
    {{0x0003e9a7a82d20f0,0x000c191011f25f2a,0x0006ac8e6399e015,0x000f96fbec312a88,0x0000dd5140aeda47}, {0x000f31326b47318d,0x0009b6685ec73d4d,0x0008442cde2c9ec7,0x0001cf4df119aecd,0x0000b1ca9564b32a}},
    {{0x0005852126506ccb,0x0007b8b3567cce2c,0x0005a3f24ba94aac,0x0008b36905cdf4c0,0x0000f5f559be547f}, {0x0004e62aade7a1df,0x00070fda3087ae4b,0x00043d89f56b8b9d,0x000047ea3eb4c64c,0x0000b7e537d8c69e}},
    {{0x0009491dfe5f6ab4,0x000e01a9c0af823d,0x0007d2b3542fc362,0x000aeb04170b0112,0x0000f0f17bc44116}, {0x00001dfc9184cf6f,0x0008795ceae6816c,0x0000bff2e914dc87,0x0005db696b2ae839,0x00006ccd629e88af}},
    {{0x0009bb90f88095a6,0x000ff19ce3057ada,0x00078b2667155c28,0x0004f832a01e476d,0x0000da9445a1652c}, {0x00083a6827ea8efa,0x00075db1af2b0317,0x00031dab94d69b7c,0x000ace2874eb38af,0x00000ed99114fd9b}},
    {{0x0002e3a4037f17e3,0x00018f91a4fa4d89,0x0001cf02f81fa984,0x000c7517c7292d96,0x00005af0c0e688bc}, {0x000ec90127a29b07,0x0004ad087444c40b,0x00087c273955714a,0x000da2fd430880a5,0x000015ecd51424df}},
    {{0x000066daafd6cefe,0x000fd8c1decb6ade,0x000b96ecece59c8d,0x00010c3e12a24a77,0x0000e7c32fd24cc7}, {0x0000e4f240e9bb7c,0x00052a63b06db070,0x0009644ee837ada5,0x00051ca58ce980d1,0x0000aa5d14de7e74}},
},
{   /*digit=22 [{1,2,3,..,}]*([2^88]*G)  */
    {{0x000d50cf1edd62f5,0x0000229f48d97a0e,0x00072ae88c3c7ae7,0x000666ff47bf288a,0x000084ddfe5848c6}, {0x00037e936731fdf9,0x000c18d98bc79711,0x000a6be30714bc7d,0x0006a5cea912c10d,0x00001cb844e4e62d}},
    {{0x00093634626e343e,0x0009d4e4c8f9696c,0x000648a06f699957,0x0006e5ce7306f6b8,0x00002775c8d8e799}, {0x000e678bf09d221c,0x000f115c2acdbb47,0x000b48b41f5251e1,0x00074b087f912177,0x000040e7726ab38d}},
    {{0x0008aaae4fdd396c,0x000f9371c3f3cdc1,0x000dfefdef6e8a9e,0x000577c6b58042a5,0x0000cc3bbb7bc4f3}, {0x0003e4adedfdd556,0x0004148c5fb23f58,0x0002d61e09ea4513,0x000b38ca2b322923,0x000042101a910b5c}},
    {{0x000ab3cc064f530b,0x000f8e1758919b7f,0x0004c4e60731153a,0x00013a335e65033d,0x00000876a8b276ce}, {0x00066ee22241ecd1,0x000e111e861c98a5,0x0007dd490b7456b3,0x000c40a9aff4eb17,0x000089b1ed9d8f77}},
    {{0x0006f5a394d7786d,0x000dd7ff0605880d,0x000dbaf4d3e66b3f,0x000f09abeb798da3,0x000055a81a432168}, {0x000e4853cae87841,0x00051aa0e48c3e00,0x000e17bcbf4bf671,0x0005a084ce2b4df4,0x000010852e0a41f1}},
    {{0x000666f50956c896,0x000bf47304e9abf6,0x0001770f44938548,0x000bb75c17622116,0x00005f7c0b74c493}, {0x000e3303459a009a,0x0002d40ab80bc6fb,0x000f5d3096dbed19,0x000e7a5fc682575b,0x0000ba698d48d53c}},
    {{0x000db6a830ae3327,0x0006ec5c4f57bc5b,0x000a40ac4ef38847,0x000d07b5329ba2d7,0x00004b55633b22e2}, {0x000719d1f38f3c87,0x0006dba25c7f63e8,0x000c8bb16e712c08,0x000bbc9fb85a3b64,0x00004ee16f039ef0}},
    {{0x000e6872857a1fc7,0x000c9ff8f504f24d,0x00081bc9abd0a0d9,0x00041beecb4fadc3,0x000023862936a94e}, {0x0003f83e75fc753c,0x000467a5a6be754d,0x000f568dc06afc75,0x0006471ce792eeb2,0x00005faaee47d2f9}},
},
{   /*digit=23 [{1,2,3,..,}]*([2^92]*G)  */
    {{0x000beb0f912b74fe,0x00024e0ceedc375f,0x000233ee745fbe8e,0x00026ef0e1aa68d9,0x000055fc1cf206a6}, {0x000a1b9e08712e7a,0x00065cfd635f80ef,0x000c1edac5fd108b,0x0003f1ea431df6ee,0x0000e1c052234080}},
    {{0x0007fb664bc0f09b,0x00027953cd07f8e9,0x000c3bf000b91399,0x000d8f8385a1b37f,0x00006e74ded609cc}, {0x000f026ec473ea77,0x000ec30766bcfe1d,0x00092052bf2f7fbb,0x00066af18cb47a32,0x0000f8d459301148}},
    {{0x000d957b3086691a,0x000bc6640915a8d6,0x000db59a99946a29,0x0001ba932ca93c43,0x0000a61a0c684fe9}, {0x000e112815bf0033,0x0008f86ba8d36e22,0x00069f434a9ed1b1,0x0007541b5d3c1410,0x0000cd2ebd04cc01}},
    {{0x00007cb8e419e083,0x0007df855eebfb75,0x0008683a5785328d,0x0007e9875db0c77b,0x0000d1bc968c0a59}, {0x000fa1047eeeab4d,0x0004a680ca70ad4a,0x0003650232668dd4,0x0001ccc3210d1f17,0x00005bb2ee4e7fb3}},
    {{0x000156fb22c5f89f,0x000baf786759c0c3,0x000b8ad9fd10ece4,0x000420e270e31780,0x0000e7a6211a0c2b}, {0x000d738125ef6358,0x000741a6f2027091,0x00087d9bbf1f277d,0x00084be2727e7b35,0x00003b209aa33e2b}},
    {{0x000bab750f2b65b6,0x000bbe5d53e3b5b9,0x000529212a7403d4,0x0007672e23e37628,0x0000fe903a2ce050}, {0x00091a16cf570fb7,0x0007ea30b325dc52,0x000c572a94bfb860,0x000c31ec4905f827,0x00002eeb8c97f381}},
    {{0x000502e9c14b6997,0x00067948a290b6b8,0x000efd415f1bcdca,0x000fb573e43a322a,0x0000f52335841e2c}, {0x00051c097d3fa948,0x0008f21296302601,0x00054acf5820c0d5,0x000ac3b8f2e1ed58,0x00006d6646cbc656}},
    {{0x000f6acf96ec2b85,0x0003f961cc16524c,0x00017f0a2d06747c,0x0002d657c7001cbd,0x0000f298db084afe}, {0x0001ef2df12f671a,0x0006fce712fdb1b0,0x000a74776c01c506,0x0006bdac0f403492,0x00003e9934fa8d69}},
},
{   /*digit=24 [{1,2,3,..,}]*([2^96]*G)  */
    {{0x000b8941abd31f02,0x000dba1da7d32599,0x000f0217ddb34198,0x00084ea8b89523a0,0x0000014cc44056b8}, {0x0004f8849efd4ee8,0x0000a87f4adfefb9,0x000fd2debf1b8171,0x000a5389d38a9a99,0x0000179277af2b67}},
    {{0x000ee9e2d3a6e28e,0x0005486d8ca2fd5f,0x0000834918eed56d,0x00045736889a2778,0x0000a1a65569ef20}, {0x000b609a501e2a36,0x000a5b23de2f87e6,0x0002c9a6b1ea0ae2,0x0009615f537d0763,0x00001770d1ffa3db}},
    {{0x000d1fa9047d3c68,0x00041e2d51ce4e21,0x000b10c9c847d157,0x00062380167a634e,0x00008966868f8c07}, {0x0008f2cdc401ce66,0x000ac97d1c838e87,0x00062b7c27f46062,0x00036e04a047da68,0x00008a2cacd5afd6}},
    {{0x00060db7497e8a5a,0x00092c6949a8925c,0x000bd589805d8eab,0x000e3f3169e466c7,0x0000dc06264b92d8}, {0x00068f4d55959fe4,0x0000602dba18dff4,0x000cf84bb97b33ee,0x000176aa0c3fe221,0x00008cdc0af44a8d}},
    {{0x000730ec599b822b,0x000e71db1fe734f3,0x0008091cd821b583,0x000cffa5b97c09f6,0x0000eb36d9557afb}, {0x000e9729ef451b2e,0x000cc72474ce4e71,0x00075c396c20a694,0x000fa4d30f6220dd,0x00000b129e07fa41}},
    {{0x0007a8b81ba9b34a,0x0005d196b5125a9f,0x00076f535e32ba94,0x00063f93a571c824,0x0000fdf2923b8108}, {0x0009a3c16169f605,0x0002eb5c7c3503bc,0x000d93e032a0397f,0x000ef4f1059d5016,0x0000e6e9109888f5}},
    {{0x000a9ddaaa05d08c,0x000b651b5a2480ce,0x0005d54b4d0caffa,0x000009d63010c858,0x0000852d0347e35b}, {0x000e50ef3df425c4,0x00023f86f10c9508,0x0001059ff9e45970,0x000ff4e36cccc208,0x00008d3f15023989}},
    {{0x000c4489c0d40099,0x0007be24dba9c3d8,0x00062e5f1d371461,0x000c8add92e7309b,0x00007b344d82922c}, {0x000009b0bfe3e8fb,0x0005a3c82268916b,0x0006235555687383,0x000e54f82a980fe6,0x0000027ecab0ce68}},
},
{   /*digit=25 [{1,2,3,..,}]*([2^100]*G)  */
    {{0x0002c86fbd613c3f,0x0006b366f179f698,0x0005c2343f4af69d,0x0001168683eed6b8,0x00005bb244b14bc2}, {0x00074bcc9fc77d46,0x0001cf44b54b397a,0x000997e76e202eb9,0x00037e77886412a6,0x0000996c8fb62c88}},
    {{0x000371c902c343de,0x0009ba4fdba0d2e9,0x0007703a1f57b2de,0x00020343f9afa4b6,0x0000afafb42d79fe}, {0x0009dc9f649a4940,0x0009fe378232fec9,0x00084e31e14799ef,0x00087fba3f811471,0x0000abbb815dc0e9}},
    {{0x0009ad6e069de1c1,0x000a8ee09300c258,0x0008ae49b3fe8e67,0x000a905b8818602f,0x000086a1482363a6}, {0x0009b399b35b33a4,0x000993d3411d8607,0x0000b2f996c38d78,0x000d08743c446272,0x0000d903dd769e14}},
    {{0x0005efcb4e31aa48,0x000098b26adf5408,0x000a7400dc760aec,0x00012814c1f78e76,0x00007b8acedb17fe}, {0x000582ecbd85bb42,0x0006a6adc0412433,0x0000d578158f0142,0x00082f3596dd508f,0x0000e7f3b803a31a}},
    {{0x000bd80d6d7878c9,0x000ec4ff7c7505c9,0x000ccd599e1ef20e,0x0004f93fab197ad2,0x0000e480594252ef}, {0x0007fd206ea34109,0x000504fa7dd4d977,0x0003bb5fcb028045,0x0008a8641b6860c4,0x0000f359d5c7cd7b}},
    {{0x0002c379ce084523,0x0009d3a870244ff1,0x00049dcb63dd8dd0,0x0006de61ff0d39b8,0x0000f5eab872efad}, {0x0006886251523f97,0x0002cbe2135b4614,0x000d2c5d445ac1d5,0x000e726350799541,0x0000f19f79a23064}},
    {{0x000044ae1118539e,0x000d3192a0069335,0x0003a2bd4ed6d43f,0x0003a51a8bf622a4,0x0000fec3fb7cfa9f}, {0x0004bbc6d834bde9,0x000940fbc743dd22,0x000ea1652aaebfcb,0x000816383b2bfcc4,0x0000cd26d91051ae}},
    {{0x0002a29161f6475b,0x0009ac8797ea7d83,0x0001b609c435b8d7,0x00000466bc156dd7,0x00003dca799ae0c2}, {0x00047bf02fd92d7b,0x000978b03082945d,0x0009a7c511d1c979,0x00089aca46d98d07,0x000093f286ccafeb}},
},
{   /*digit=26 [{1,2,3,..,}]*([2^104]*G)  */
    {{0x0002d2d4919affec,0x00046009bd158037,0x000a62eb12d4a2ea,0x00012448f1e7f8c1,0x0000e083726187a1}, {0x000261be7ebadd32,0x0006257b93e9c874,0x00039e6ff7ca5c15,0x0005c3e8b381e5fe,0x0000d16b32ff3081}},
    {{0x0000b28ad2e996a9,0x000d2df0fc374fd3,0x000c3976364d4eee,0x000e8e8e049e3ddd,0x0000f55e0cec7ea2}, {0x000ba4e4bf019842,0x000dbd55bc4bd3fc,0x000da895f764d5c3,0x000a6998cb92a1cf,0x00007dfe7957c7bc}},
    {{0x000d127df32d462e,0x00069353d1362a82,0x0001a23472b2d2a5,0x000b450ec57e5916,0x0000f4ff6eae5ff8}, {0x000400ac40a9d454,0x00004596718f82b0,0x0007a0dba9ecfec5,0x000cc066c183470f,0x0000f1aef698d4ca}},
    {{0x000decf23a86e2cd,0x000c0387f711b6df,0x0003509d102ac466,0x000bd1c30a1ac2d6,0x0000391342333aeb}, {0x000789f068ae34fd,0x0002187dcd100c7b,0x000e8a4b4499f2d0,0x00026c68e2a3bca3,0x0000f87ba71e4d2a}},
    {{0x00026848490bfdd6,0x000e35430226bf58,0x0007ae001b81059a,0x000449d5557551b1,0x00009a0e4f06a9c0}, {0x000ffb5aa7f70c1b,0x0000de46ce99fb72,0x000a020f9ac4e4ba,0x000477e56ecf595b,0x000074c5d6609374}},
    {{0x000b99934479e7b9,0x00044026e7800e3a,0x0001bd4299d5f2dc,0x00079a131374fd4f,0x00002e2e7392be13}, {0x0002f80d13bc1116,0x0000e6f81c920cc3,0x00063913a6fbfc35,0x00075c12ca1b3092,0x0000f7da200406ab}},
    {{0x000ea765fe235a8e,0x00004de31523f94b,0x0000ebfbb64be92a,0x0007ec6ed505fa08,0x000003434e32a6db}, {0x0006ebad02efcc64,0x0000d651266ce100,0x00052a6a6f23ba6a,0x0009c596fc0cc05d,0x00008d95322f6ce0}},
    {{0x000f12a19301b163,0x0001ec368a201780,0x000adb344233bc23,0x0005a1d9650892cb,0x00008a0d964dd942}, {0x000bcf24a8d4d7e5,0x00020806ce9dd77a,0x00070d4734ccd16b,0x00078082ff40f075,0x000074914152f130}},
},
{   /*digit=27 [{1,2,3,..,}]*([2^108]*G)  */
    {{0x00041205d8f6fabf,0x000a9bed09c79d8d,0x000acbb1e5e42083,0x0009965120e0794a,0x00007e840f9dc1bc}, {0x000d63b9707c3bb7,0x00091e891a716921,0x000bb22783ab4b8b,0x00091cbe46575673,0x000076ce040c53ee}},
    {{0x000b010fdc7945f2,0x000023750a4bcbad,0x000c85b9d62c9cff,0x000bf975192383a0,0x0000aba7b5336eb0}, {0x000adaaa4c06f9ad,0x00032f8e482bc3d4,0x00091a79f573a86a,0x000ec2109c6fdce7,0x00009ed02cf837ee}},
    {{0x00019d38fc7ea72c,0x00063211ef447211,0x000eda1a2390b4ef,0x000596289f39451f,0x0000ee9cb34205c8}, {0x0009e96971b6897f,0x000409701ea6a110,0x0002c6b2bdf70c17,0x000766a07d0ecda9,0x00008eb97ff99eab}},
    {{0x0008c448b63b669b,0x00071972d2d0d6f1,0x000ff59bc53c6eba,0x000ce52a522d8c8c,0x0000c181d161ed25}, {0x000173d5feb0eca8,0x000e2207bd71113f,0x0001715ae34273f8,0x0004ae41b7572efa,0x0000a8ffea2ff16f}},
    {{0x0005e681e13eaee1,0x000419dafdb94ed7,0x000941fc4bebd474,0x000bc08b46621f69,0x0000fd3c13fa1129}, {0x00048d0b7b9da22f,0x000bc87a47414714,0x0001c38b9d452cce,0x000bfee2f04778f9,0x0000b443a5ead516}},
    {{0x000b4797e8215d87,0x0007023b4b27721a,0x0003d21ef8438468,0x000e1ca93c08fe6a,0x0000bd962489fa6d}, {0x000ecd7ca6de3e08,0x0008c7c9fced3858,0x00008239e466a48c,0x00083323ca9b75c7,0x000060d553e35bbe}},
    {{0x000e02a5022112c4,0x00015461b1c6a66c,0x000247c388415df8,0x0004d6c2546e6aad,0x0000b9788e6da9c7}, {0x000b2e0a22be3e86,0x000c895f76ad3d0c,0x00033767015db086,0x000f549758f99ba2,0x00001ae09bbfab57}},
    {{0x000917a2f8ebcf55,0x000be53f056ca356,0x00084bb486f2c400,0x0008e309d9ac41dd,0x00000dc7a8ef61e9}, {0x000a9d33d3a67762,0x000736de8b3df179,0x0006e2beadda312e,0x000ca062a8b7c3ce,0x0000b00036c845e4}},
},
{   /*digit=28 [{1,2,3,..,}]*([2^112]*G)  */
    {{0x000cbd7ab6cf0b48,0x0005713d1ddf1ad2,0x0006003ba7a1e67f,0x000fcca58f0c7374,0x0000263e889264a8}, {0x000be37be2452f79,0x0006fae81a75c35c,0x0005537019312576,0x000d787d2ed0ab3a,0x00003d7e7e040717}},
    {{0x000013cf9cf03baa,0x00099eee3a77c1bc,0x0007e4c9536223b8,0x0005e486efc9233d,0x0000f3801bf36562}, {0x000a1413f32fd9d0,0x000c4e564acba7bb,0x000edcac170724de,0x00098552587f32b7,0x0000b1cd94cb3969}},
    {{0x000407a661fbdabc,0x000718e52150df08,0x000dfe954c4d7c53,0x000dd1a3765bce63,0x00006829bfc6c2dd}, {0x0003f65dc6e44874,0x0002ff04c9305739,0x000838c0a9ba2942,0x0005cd493c691418,0x00001b137ff8b2f3}},
    {{0x000aa244e1c5e60d,0x0009e3253d50f9e4,0x000babe5354bb528,0x000a64f4a86ab39b,0x0000561feaf3ac0a}, {0x00096ab1911bad71,0x00087433730317a8,0x0001f69289cb22b9,0x000c9ff14262fb16,0x0000661885c69ba6}},
    {{0x000ebd3b82574dbc,0x00034d8af3f58666,0x0009319bfc5e8667,0x0001a8cc64520520,0x0000183c12ef834d}, {0x00073da49eb0f402,0x000c8aca649e333d,0x0009e83613bcab0b,0x000c85a02f4c41e3,0x0000391e7aec89bd}},
    {{0x0007c5e608cbe2f2,0x0007116c22f26806,0x000faf9dccdec82f,0x00085c80aa719af1,0x000061fe95143401}, {0x00013669713e72e6,0x000ecd8a2a466b41,0x000106ce0db1e405,0x000e69ed17475711,0x0000d70cf6f571c0}},
    {{0x0000322cf707c76a,0x000fe0b4b7d71531,0x000a2d26d3a1eb2f,0x0000c0b83259fbb1,0x000083ffb1019972}, {0x00019280bedb326e,0x0001c92717150ecb,0x0002d71a94473e82,0x00056d506e6d202f,0x00007b253b223197}},
    {{0x0009335f576cb3cb,0x00048fb3b78e77e1,0x000da0001e16e457,0x000c5eaf96d78563,0x000038deafea7444}, {0x000b38cc0eb0e287,0x0001efe41b983ca6,0x000965b31a6ca354,0x000bc6feb37b4718,0x000039cc322c97d5}},
},
{   /*digit=29 [{1,2,3,..,}]*([2^116]*G)  */
    {{0x000ac99a211ffd3e,0x00051f1f6bca019f,0x000648244408f942,0x000d671f5b76d1a5,0x0000f3942e975b2b}, {0x000ee7fb538f1d7c,0x0001044b8f845b9d,0x0008ea6a31cb7862,0x00071f9f8ecd63cb,0x0000a111b2f79d3b}},
    {{0x0000e21091e1c4cc,0x0005467ccc747cc0,0x000ebbbe4d500db4,0x000ac0a8e2e84bf5,0x0000326688284279}, {0x000b4de7a1706589,0x0001e1da4a2d9e8f,0x000acee19219c5ec,0x000243da69a3fdee,0x0000d4c6fbdc0462}},
    {{0x0001d166087c5e5f,0x000fb53a8bc4e962,0x000d314cdae49c2c,0x000f18d7868882ca,0x0000de10dc89a57a}, {0x000a60d3800f3973,0x000b688b333c0fa8,0x000fa8129cec8ae7,0x000c32efd8d69285,0x00003d5685bc0776}},
    {{0x000f768680dcbf99,0x0005df0a51df60ac,0x0008df9c55072b82,0x0003323a74751cd8,0x0000d20f989acc1a}, {0x000042b6926c34ad,0x000ed076687f7e90,0x0006e9dcb5c728b1,0x0005aef2e3bfe8f7,0x00009822f0ae5a12}},
    {{0x000eafec58b6d022,0x000373443629441a,0x000823652750cd60,0x000d5ea68af789e4,0x000084d1e24e8d6a}, {0x0003ee3c4d56ddf6,0x00000c18e36243f9,0x000a2fe798365005,0x000df90e409c5b85,0x0000127bfe085cfd}},
    {{0x000ff1d35689ad9f,0x0003932addf1ec56,0x000fdde42e0f2114,0x000f5f4d52297877,0x0000402832dcd838}, {0x000267d915ac8813,0x00003c9963a5fa13,0x0002a42bdcf224e2,0x000c500d44419ac5,0x0000ed2898d4cc0a}},
    {{0x00005799f67b96be,0x000b3f509e955e73,0x00016dc34c6d265e,0x000493e985dceed4,0x0000308208028803}, {0x0004271dc7a39d4f,0x00032b9f5dc3afcb,0x000d33ea6839afda,0x00065a1c08ba2fc7,0x00003ae1c287c591}},
    {{0x000db58f51b14b08,0x0006239a79f03f84,0x0005a1f11df73ccf,0x0004000ce1e5842b,0x000041fa6a3985fc}, {0x0009c682455c32a3,0x000eefa71cc364b0,0x000797929383c9bd,0x000a5db63814861e,0x00003036faf923d0}},
},
{   /*digit=30 [{1,2,3,..,}]*([2^120]*G)  */
    {{0x000cf7c90f17cbaf,0x000520c7c5f351b6,0x000cc7f385d655ff,0x00079ec64f29d54c,0x000028e85325124a}, {0x0008d5167bf1e98c,0x00001d7a33af5efa,0x0009a40a48610028,0x000a0b35fe2bb2cb,0x00005cc1bf203d50}},
    {{0x0002bbfa32106c2a,0x000ade91774fc0ae,0x000853a30ef155b2,0x00005b5567c3c713,0x00006be82918ddb3}, {0x0008c21ade26eecb,0x000cb03c17ec7db5,0x00093f8a2fa3c895,0x0000c696ab0de162,0x0000d2365ed5c371}},
    {{0x0003e73e194c6423,0x0006a89e3c856ab0,0x000dacd55607b710,0x000084952aab024b,0x00001ca3ee251cc6}, {0x0009b2b1c6b93f9e,0x000ccad930f7f314,0x000872630cbc5ef3,0x000fe2ed04984f22,0x0000f5d052e4c4b6}},
    {{0x0008d05570286777,0x000c3e9aabdf6202,0x000d4e5d090eebee,0x000873ab977aee06,0x0000a98c52869361}, {0x0001251b7c2474df,0x00074f3e7b01f49b,0x000e54af1cdaf2a3,0x0006b7638bcaf46f,0x0000ec426250dac0}},
    {{0x0008cf51eafe37b0,0x000430dd7c2bda73,0x000dd77af503eac2,0x000e7cf9b7b7a511,0x0000ade03afe9dcf}, {0x000d34af479e3b5a,0x0003a30a33f2a89b,0x000b64068993ab40,0x000110aef322bf9f,0x000047cc71bae27f}},
    {{0x000f8f8c63b9e759,0x000c9d7d130a519f,0x0008490b743f6b4f,0x00014adba3385d7c,0x00007889df79252c}, {0x000ca86b2f18b9f0,0x000ec3a87422fccf,0x000474838f092ff9,0x000e9ff96dd67567,0x000039e82875bad2}},
    {{0x00009112da32c0af,0x0003a2676ca256a6,0x000614dc6b2e1ac3,0x000965fb74093f17,0x000044939e52f27f}, {0x000a402c922422bc,0x000afff5c56e8656,0x0009aa62ed60a55b,0x000cd20d061b41ab,0x00009ceacff6ca3a}},
    {{0x0001d47515f954cf,0x000c6f470a3f5f58,0x0006feaaf145f925,0x00043bfee6b6b073,0x000090744b01ea57}, {0x0008ceaa2f36f565,0x000f33ed4006fd8e,0x00015e6db4239a6c,0x0003d10906b5bdd5,0x00003622990dac97}},
},
{   /*digit=31 [{1,2,3,..,}]*([2^124]*G)  */
    {{0x000667432efbbce1,0x0003f9639719548d,0x000662e7d64a6c2b,0x00018438c0465730,0x00005d1d7ca452c9}, {0x000630ccc3020cc4,0x000cf09f038f30e8,0x00076a744e4b56c9,0x000988db9cb5edfe,0x0000c85f020a947b}},
    {{0x0004873ec83c9534,0x00037a21ef09f49e,0x000f7d93eb4f59fb,0x000c823872d31440,0x000079e1d0302568}, {0x000dc9a65d43d228,0x00026775efa857e4,0x0006defa6cc068e8,0x000956b78ccae932,0x0000f92b296ada64}},
    {{0x000aaa9c8a3e3ac8,0x000f43979374b572,0x000f271ebf9bc4e1,0x0008468117501ecc,0x0000c636f82980b7}, {0x000ef401522bb338,0x000b1a451df84842,0x000adce528726480,0x000bb68955aa02ed,0x0000e83cf34e78d0}},
    {{0x000f8d5dea227eee,0x000d1dda8b9fd721,0x0003e3520f48c766,0x0008b60583d94be4,0x0000bda36cac1d89}, {0x000286a6627adaac,0x00015938368d5808,0x00050949f19c4c62,0x0006d9e0dbd707f7,0x0000adf4beaccf35}},
    {{0x000cce23329e671b,0x000133ba85f9fa3d,0x000d2f0acbfe89cd,0x000dd5a661b1f182,0x0000ec370f3d49b0}, {0x0004271be20fb25c,0x0003f8f79665eacb,0x0008e416948ffff8,0x000ba1df8d3d2cbf,0x00007a6d9edd03f5}},
    {{0x00053eeb5763ed71,0x00076458542565c0,0x000cd718c4a553fb,0x0004bb3b2736a46c,0x0000c4f9cded6489}, {0x00001a0f71211b78,0x0003f2974258adf0,0x000ff25912c5325f,0x00020be8e172f449,0x00002e960cb21a37}},
    {{0x000c4a93631bfbda,0x000ad77461c62943,0x000958036ce38afd,0x000c48f0ad59d5c1,0x0000e284bfe02556}, {0x0003006d8b01967d,0x000c55a31d662fba,0x000c592b66b2f4ad,0x000018fe6af925e2,0x000030c029c1eb3e}},
    {{0x00021262dc890a77,0x000605aa75a385de,0x000070b3276b7b67,0x00068f475fc1432a,0x0000429a646fe31d}, {0x0009aaa09be3dcab,0x000a5f780ed73c3a,0x000fd96c407e119a,0x0005776212562564,0x0000571495098e80}},
},
{   /*digit=32 [{1,2,3,..,}]*([2^128]*G)  */
    {{0x000561a8a914b50c,0x000f5154d376bb9f,0x0009b4c352bf7130,0x000c566800f69651,0x00009e65041168b4}, {0x0006e006d98a3316,0x00074211ce1dd070,0x000562e5f781a12f,0x0007471fff9e3d40,0x0000356cf46ec166}},
    {{0x0008d63003b40dd2,0x00025951b7ae5a74,0x0004a91b08a68240,0x0003ea41e92dd970,0x0000dfb3eb9a58cd}, {0x000af35f5094667d,0x000d4435aa2cf3c2,0x00062714fffa287d,0x000b0ed03f397974,0x0000b550f67f03e5}},
    {{0x000549dd3341d809,0x0007c1a2a0a44759,0x000164f75079e9fa,0x00018275da56c72a,0x0000313ef5b4eefc}, {0x00065b6bde130ad1,0x0007a841117ffaa3,0x00026466a4426597,0x000404a65373f7aa,0x0000a43bee63e2cf}},
    {{0x000e1b8207eecd99,0x00047c07b47c29da,0x0004292dad3f50d6,0x00075b02b4d90936,0x000019a6df48c359}, {0x000d4aab616452e4,0x000d9cfc6abb741e,0x00089b025e58689c,0x000de5eac325d9f3,0x00005ceb1e6cf255}},
    {{0x0005a9858bf21d97,0x00074beab706075d,0x00032d47700eb684,0x0001c29d714c9f82,0x0000cde2c3f270f9}, {0x000a8cee9871f0c4,0x000b59e8444aa6d0,0x0000cd43a902bc60,0x0002228651ed57ff,0x0000418cc081480d}},
    {{0x000188534a70bfed,0x0008736345c44b2b,0x000322ae9cfa421f,0x0007a02f33f4cc6f,0x0000ac0bb761dabb}, {0x0005536923cea0a8,0x0005ed9cb50c7ba3,0x000812c96c16f73e,0x00042423216dc625,0x00002945e67bd7ab}},
    {{0x000bb350b6da2b61,0x00068b65ee5504ae,0x0000a004d91fef33,0x0001f7db77b57b1a,0x0000c59b62833aef}, {0x0008c893ec88d182,0x000a6fde31f1879c,0x0004e30b652cca38,0x000cbbe2f64a94cf,0x0000b4cdbd757ff1}},
    {{0x000b7fc506f7dcd8,0x0006dd037d68f4e7,0x000c8d374985e854,0x000180ff00a4da1e,0x0000c339ae3d05b4}, {0x000d4f23a5f71c42,0x000f87ac3e9f58bc,0x00065dad12fb4d99,0x0004dc7dd25aa6ee,0x0000fd63fc2d62c3}},
},
{   /*digit=33 [{1,2,3,..,}]*([2^132]*G)  */
    {{0x000671fe43332ef5,0x000b941c2217f3e0,0x00022ba1871c5dd5,0x000b674c1d2c1fe9,0x000058e9c302619c}, {0x000cde01ec51255b,0x00015f824507204a,0x0004c6afe824b374,0x0002e362d1b9de74,0x000099616dc5b0d5}},
    {{0x000c0847f6a1cda6,0x0004e23d634ffec9,0x000bad00768839c1,0x00054ecbbb678b03,0x0000a727255a7888}, {0x000fea2ef5c72941,0x00085875e775b747,0x00061a8937485277,0x0008b1ad7b8e8baa,0x00008ff333550da9}},
    {{0x0006ca48d15f612f,0x000661a8a9100439,0x000e4801edc27609,0x000765b388a29a0d,0x00001786469e2330}, {0x000153bbefdde3b2,0x000c66b8ce1ac63e,0x000313e17ecffc16,0x000fc5ab70c46999,0x000063b28a2fa50f}},
    {{0x0009f4f5529ec802,0x000a8fd146d1851e,0x000300c2c0420274,0x000feabbf1ab668e,0x0000d0b3a9d61653}, {0x000180f23a495b9a,0x0004f415d73a8be2,0x0007ae4fc6ef3c37,0x000f5f1d3e1ec8c6,0x00005839e9d38d31}},
    {{0x000c8b9c3fb67790,0x000ca57ee680c4c8,0x000673efc54fc9c6,0x00079e99003261b7,0x000067670079b117}, {0x0001da6250891c34,0x000b9d785ab3fb15,0x0006759c64720dec,0x00008e872b351ffa,0x0000c7ad29ae4f10}},
    {{0x00014d637d77c019,0x000bd1023c876541,0x0006e1221c2e18a4,0x0008f96fa6c3d39e,0x0000a6cf4e2d10e4}, {0x0001140b181828fb,0x000a28cb78333088,0x000cd236717c6df2,0x000922c1eb8df1a7,0x000078f1c8e7a89f}},
    {{0x000bcacbd862cefb,0x000dbf8f23c2598b,0x00045228f58f4234,0x0003688bce359f81,0x0000605d0f84812c}, {0x000dddfe4018fcda,0x000f9f797960b8b4,0x0005d8257b8139dd,0x0009bf631ee83dd5,0x0000c8b3932c4571}},
    {{0x0004777d0d428874,0x00086b7a2707b25d,0x0003966fe4b48921,0x000bec1b4dbf9b2d,0x0000bac5f4881ae2}, {0x00027331733964e6,0x000fca814a6908db,0x000898348a10c5df,0x0003f484ebdaf0a9,0x00000e46824074da}},
},
{   /*digit=34 [{1,2,3,..,}]*([2^136]*G)  */
    {{0x0002d18f9066d734,0x0003e098b3bfa064,0x000b4954cbe1d2ec,0x0009bbefee860c21,0x0000d7c4e6d67b62}, {0x0001e038e8b81b09,0x000f0fe77eb03d8f,0x000247c734a80168,0x0003564d977591ce,0x0000b30c9f3157e0}},
    {{0x000ead488c06b1c4,0x000089d9d4e8273a,0x0009e86bfea8af42,0x000a56a7b4409acb,0x00009f76f719414a}, {0x000c8018c13857a2,0x0002ee7423844603,0x0006657197c26f1c,0x0000c6042fb2242a,0x0000619f2550175b}},
    {{0x000699444bb5a795,0x000cebd1fdbfb12c,0x000e49191f5928e0,0x000dd3d30b8a973c,0x00002792b8633a05}, {0x00089161d3d69c3b,0x00099d59a28c5da0,0x000a05485931759e,0x000964412148d96c,0x00001517aa0ed6e9}},
    {{0x000bcc7d9b45206a,0x000e8abc463fed6f,0x0000e37d100ab735,0x000718428c701781,0x00004365872c7af5}, {0x00058230a910146d,0x0007dff76703bf19,0x000d6f1c8c13ccdd,0x0001b459d34ad644,0x00003dfa6b3495b6}},
    {{0x0005d0a1685e4603,0x0007455d00b5d0e1,0x0005614566fae8b3,0x000c63277126d8dc,0x000031c02e59bf70}, {0x000da4e515f39b7c,0x0006566c206009b7,0x00001f926b7e0d13,0x00037e9a801457c4,0x0000c560826bfb01}},
    {{0x000ffb56487a5d42,0x00054f53e25f6874,0x0006ba8fcc02a12b,0x0005d638654a5741,0x000026356f22c0b2}, {0x000eaa66030f2ac9,0x00022cea9175a4f2,0x000912104b788baa,0x000e3d66fbe9f74e,0x000082ef71dc9a69}},
    {{0x00090f62369ce91c,0x000a1754d218b653,0x000018afb2dc3763,0x000b66bc5523697c,0x0000a835077f5bf6}, {0x0003e4361d4b0a62,0x000747cf66c541b8,0x00057cbf28f87f59,0x000fb7ace5784093,0x00004834481cbe47}},
    {{0x000c2c96fd8b3094,0x000ae055809f298e,0x00022943c512ea17,0x0003e628cb44e788,0x000034dc70a1eb7d}, {0x00024d11be76434d,0x0004082ff0b0e8b3,0x00005e7267cf24ed,0x000abcda8265fe29,0x000057b3916be6c3}},
},
{   /*digit=35 [{1,2,3,..,}]*([2^140]*G)  */
    {{0x0000095d2a819b58,0x0009c8f2f6537901,0x000afe3665291aaf,0x000e27fa533907f0,0x00008a58ed00e279}, {0x0007127fae130bc9,0x000b88a54c747f07,0x000d82b6aee9ccf1,0x00052438a6783ebe,0x0000a1acb3e7d414}},
    {{0x0003ceed9c12e2aa,0x00021fc1308f44e5,0x0002c2d0f11983fc,0x0007233eb4d84d89,0x00000bfc1cb14499}, {0x00044d90145176bf,0x00015f12e75a8083,0x000a67545bb2988e,0x000989df73ceadad,0x000037069d21bb8f}},
    {{0x00035e69cc17f65b,0x000b39d9abdff24a,0x000c09ae3c49b3e9,0x00058782f403032f,0x0000ffe7d4db02cc}, {0x000f4e6424ef7136,0x00050658f65ff511,0x0008baea2b86bf65,0x000759623388d91c,0x00000664a7193656}},
    {{0x0006198d8447e168,0x0006e62171dc9899,0x00048b8e617195d7,0x00092328cfe6a1f4,0x0000a3c28238658c}, {0x0008d899c35e852f,0x00001b3781561c54,0x0000113b6adf1cd3,0x00096f999e41aff3,0x000087515a68cf46}},
    {{0x0002c559778aa8ee,0x000bb1b8d8b18c33,0x000533883290ae3e,0x000ee23e2bfa0bbf,0x000048e3747fa523}, {0x000f1d550fde3eda,0x000be8710432ad40,0x000241f3fb57e695,0x000abca41012581b,0x00000cabf7bd042c}},
    {{0x00019c7edfea5220,0x0008a400db7b68eb,0x000f03a0868e028b,0x000e366cd97bf7a8,0x00009f4d266f442f}, {0x0007f915d713a1ff,0x00061f58ccb42ac7,0x000ddc47d356e3a3,0x00011531d657f1f8,0x0000ea7aedf80092}},
    {{0x000a1d24ad49f66a,0x000e3d40861a8aeb,0x000a225f516ff2ba,0x000f0b25464f377d,0x00002fe66ccbffc3}, {0x0004d7fac757f415,0x00021d0a2c202407,0x00074b2665c85d3d,0x00004fccda2a05c9,0x0000c2e25121c10a}},
    {{0x0002535510d515f7,0x000cb89e785591ea,0x0000d17bcc861c54,0x000c869bc8485b68,0x00001472c11f19cc}, {0x00094850e9b5d8b0,0x0008d029720da7ef,0x000f50161698c9fe,0x000bf66ce987d161,0x000035f6f329d240}},
},
{   /*digit=36 [{1,2,3,..,}]*([2^144]*G)  */
    {{0x00015879c34971bf,0x0008d76545cefe03,0x000a81bb95829eb0,0x000710b7a3a6ae33,0x0000f42db0039c9f}, {0x000ae85bffb951b7,0x00033e70f324194e,0x0008b1f12815fe3e,0x0000bd636564cb42,0x000022e00511029b}},
    {{0x000578b41aeb39f1,0x000e8dd55c1fcfc9,0x000814075eeda86f,0x00017cd4b8fc54fb,0x00002e32a7843a13}, {0x000cd2b2fd217d16,0x00013bd076388b79,0x000dc7d8b5f5f20c,0x0000e2fc57643a53,0x0000512601550835}},
    {{0x0007479d0058ffac,0x000fd80b0de5705b,0x000a0585fe459ecf,0x000fa0fbe00c088c,0x0000169e23b83dd4}, {0x000009a44026f6ee,0x0003fd96fe5785d9,0x0008ed1e0bbc258c,0x000884d7ed379c32,0x00008b4574503970}},
    {{0x00091e139bb481ab,0x000b49984155263e,0x000d8e622dcdc072,0x0000349fce6e38d2,0x0000f6978b73e8c8}, {0x000e8748c37990a9,0x00089e749b861a1a,0x000dc7c12d1f0e06,0x0002115aa303b1cb,0x0000a78bab059130}},
    {{0x0000e8c48790aacf,0x0009154ad24e5601,0x0002090b8ac7a52d,0x0007dfbca462bd2d,0x0000cd84ef5a2f8d}, {0x00055b07ec8e0744,0x0003ba9b88dbf017,0x0007e09a00e4205e,0x0009130170f7d14d,0x00007f7d48d0e9d8}},
    {{0x0000b8acc130e8b6,0x00003c6f0871db27,0x0000d3f3417f5f79,0x0000319683bd22e5,0x0000d5852afc2699}, {0x00054cd8f15058ac,0x000b74cfe9dcc3d5,0x0009479d624038de,0x00059bb19336ecc8,0x0000aa9ed55b03eb}},
    {{0x000c5c0e0b77ebf3,0x0006d45a471d41ab,0x000e535e9dc41d92,0x000a8528f162333c,0x00005db2f52ebbd0}, {0x0005bf4eaec8559f,0x000702b31f5e4c0e,0x000d337b87be9434,0x000280c2b24a8e89,0x0000564495937b34}},
    {{0x000a910b3e2087b0,0x000344a61a335eeb,0x000cd5c0fbd016dd,0x000e94ffd1f08148,0x000041c6aa02e6a8}, {0x00035c5c4ac3d913,0x0005934767a4b09c,0x00040c2b55829810,0x00089f6120e7cb10,0x00002a661efd7135}},
},
{   /*digit=37 [{1,2,3,..,}]*([2^148]*G)  */
    {{0x0006a90bd74c70ea,0x000e2af672f2ba05,0x0004e9a4844f7d00,0x000069dc25ab68ef,0x0000dd15cc49dfb1}, {0x000fd289f3033bf4,0x000c2bb8b8a771f4,0x000d2861c088a49b,0x000fb5ea485869a8,0x00006dbfdafab977}},
    {{0x000ef4002d0aaff9,0x000dfe679fe21264,0x00088bdcea678c07,0x000db8cff13be7fd,0x0000a8efe8df17ba}, {0x000a815ad5a22f46,0x00015ec398b2b388,0x0004fc2da8f82140,0x0004f385a6a565ff,0x000081f0181e58dd}},
    {{0x000b637f8ec1151c,0x000c6adc8544ee61,0x000d0985a415dd36,0x000f50ed21d17669,0x00004d062b057893}, {0x000ba1a337b81f9d,0x000f87c163a17d93,0x00016e4edb995fe9,0x0008e7447eff3b54,0x00007660300dbf4a}},
    {{0x0008fbc4e933b192,0x000d054ea9692416,0x000acbb56af2db74,0x000d1d36fade13ae,0x00009708665a4e6c}, {0x000f1e1b692df97b,0x00031ae66306bf7f,0x000685f205a68c1a,0x000eec85bc544ce7,0x00003f42e6dbf65e}},
    {{0x000bbad2a08a1dcc,0x000b3f2dba7953f6,0x00064f5a3a7131e4,0x000109751dce4878,0x00005af1b45c8135}, {0x00075f74f08636e0,0x00052e251e483c4d,0x000d988539949b2f,0x000e84d04979779b,0x00009d8e627909b0}},
    {{0x000078177ef7f672,0x00074b6340c9166d,0x0007acf63fefec94,0x000dec7ce3a05609,0x00006538c7ccf306}, {0x000b55e287dc8d19,0x000bd48823adfa8b,0x00070fc519431095,0x0009ac8358087a79,0x00005299959d1350}},
    {{0x000ef0bfb48bd3a8,0x000f4508309e0814,0x000709c101bbbe13,0x0006557ddaf06167,0x00002b67847e436f}, {0x00001c603712e641,0x00024e3f9b2e1a56,0x000184b5dac1f036,0x000149cc7e6a0909,0x0000258b265c4625}},
    {{0x000033a675b47a06,0x0004c542378f9bf7,0x0005ec248cb3669c,0x00034696abb0f712,0x0000d5d2047d95fc}, {0x000c9e88f5cffb67,0x00082ea5ee0936c6,0x0004ffd6fb968f2c,0x000ac82f2ce73584,0x0000931b87797e40}},
},
{   /*digit=38 [{1,2,3,..,}]*([2^152]*G)  */
    {{0x00015ecfe73e6993,0x000c7752648968bb,0x0001dcc6d7533abd,0x0003634b26960749,0x000025ec2a0a7187}, {0x000aa197e9ab8653,0x000af25a9448466f,0x00031b5ba1c105b4,0x0005790b6b896305,0x00002691f115db1a}},
    {{0x0005f7341690d1cd,0x0009c0edac8bdbdf,0x00038cfb00e857a7,0x0001d259f40fcf82,0x0000cb54f68211d4}, {0x0006ac80e6451179,0x000f0af5fdcbaf03,0x0007bab2cdc4e833,0x0002bd67d859b23d,0x00002489b23ef8b3}},
    {{0x00034b4c22eb7ffd,0x000bad66596a89ef,0x000b3f3e1fc26171,0x000de06ce57d2c0e,0x0000e4177dcd587b}, {0x000f7eb6ebf95ffe,0x0004ff55b87342f0,0x0000cbc46efde869,0x000190b699bdb308,0x000032804f430cd4}},
    {{0x000aaf7b9e2f9f82,0x000a2ff419acc412,0x0007bcb900484c1a,0x0008ca9d94498941,0x0000b73dbe41e731}, {0x00071e552dd7b0ad,0x000b0954afeae91b,0x0007e3958d61f8ee,0x000f49aaeab13ca0,0x0000e442032d2a1f}},
    {{0x000f06ac55c0828f,0x0001667e2247abc6,0x000c49d4d62a7430,0x000b34e42b4c8984,0x00007a8dd4742091}, {0x000b96540a8295bd,0x000c39e900eb5ffb,0x00042ae0a36db01c,0x0009ebd9b90987de,0x000051f12e4efc53}},
    {{0x000fbd4a3b4ab0fb,0x0004907bdb60d581,0x000ae79b355d3bb1,0x00024ee65507f786,0x000085fa584e36d8}, {0x0004492bc0d8c261,0x0003a9b3e8d4611d,0x0004029cfbbdbeb6,0x000bf2f201f709e4,0x00008a99397c6748}},
    {{0x00020b3838c4ab94,0x000cb736cae32a95,0x00039f308526b695,0x00017f0f8eab84d2,0x000009b53e4d08c5}, {0x0001bcad169e4b4c,0x000767a467b7d378,0x000cc9436a91f107,0x000ec70e885579f3,0x00000d1f792fe123}},
    {{0x000d96d0b054a0fb,0x000924b90779d292,0x000f1d49fa978af8,0x000ab170bd185bff,0x0000e6d0844b279e}, {0x000fe45b8ed07e9d,0x00029b920e54d8ff,0x0001bb143714824a,0x000bb7cd5c628aaf,0x0000151afce4637d}},
},
{   /*digit=39 [{1,2,3,..,}]*([2^156]*G)  */
    {{0x000bd2e5a26a1d4d,0x000ea1c2d78bd433,0x0001025151148bb1,0x0003844aae419e64,0x000003b993a36489}, {0x00058b1d61a99194,0x00068a0ef3d4a21d,0x000e8c0dd17618c3,0x000a752519020d6f,0x00008d837d640b87}},
    {{0x0003a693f11fc001,0x00019bc8eade4cfd,0x000b9f7ae1f2b5d0,0x0004635160359ba6,0x0000e2601dd0a696}, {0x000c6d2915f60844,0x0009a79176d53f5a,0x00026abee6e38778,0x000d227fb99f4bae,0x0000798a2fcea409}},
    {{0x000342d86b383b5e,0x0000506b01d4e192,0x000cdcb89e85f304,0x000e2a19e1921388,0x000088f19440ce0d}, {0x000f8cfe453aecce,0x00097a67b49f16fc,0x000ece9610dcd10b,0x000b53b93d5b4daf,0x0000232f34ba39d0}},
    {{0x000cd7c64ca2efc0,0x000b4e0bcb6c799a,0x00058a26c3397a15,0x000faab9b10ced03,0x0000a30dbbe4b8dd}, {0x0009712e20f6facb,0x0003811451aff70e,0x000eece8f87c7f73,0x000e2df0c967b1d5,0x0000c62882b5b370}},
    {{0x000ba8516a010bce,0x000bca4f3e8e09c0,0x00070a1e52fd90fb,0x0000048af1837145,0x0000869e8f85cca9}, {0x000afb72dd830199,0x000e8d99b38652c8,0x000adab87b877995,0x00091a1e3efc16f5,0x00003105fe53a3b1}},
    {{0x00065d10a020be77,0x0002666eaf8ac051,0x000d2380e4856041,0x000b115ff898ddff,0x0000da35f08e84b4}, {0x0003e2c38fd05c77,0x0002b7ada3a4e0f5,0x0008995de64b3ee8,0x000605672ae31667,0x000047074614fe96}},
    {{0x000ce8b62a0b0ed7,0x00037abbc9be00cb,0x00069c2d692f5dc3,0x0003e1bb92b7d3f3,0x00000dd90c8e9ef8}, {0x00031537937ab45e,0x0005a054af6d00b3,0x0005ebfc43a8d1f7,0x000d0c35cf7380b0,0x0000fb8dac338c2c}},
    {{0x000cb400c11e65a4,0x0002a8ff2be53722,0x0009f9352c94a7f5,0x000544420085cc8d,0x0000addb9870a4b2}, {0x000eac006264a479,0x000472b48ccbac6c,0x00094fef2ebc01a0,0x000a8ac430e7abea,0x000073bb6f14d94a}},
},
{   /*digit=40 [{1,2,3,..,}]*([2^160]*G)  */
    {{0x0004c2e24424a48f,0x000f27d4471b21cf,0x0007a488b843c73e,0x00061cb3047fc561,0x00002a9170ad3cf8}, {0x00044211c3a60f77,0x0006966791481444,0x000d9404b74787a3,0x000ef0115fbd0653,0x00000fd3365d244c}},
    {{0x0005c9b2b574b7f9,0x00065369b6bde669,0x000108dedcca8040,0x000fce1f4bae99e3,0x0000e715ce37a133}, {0x000205554c2ee1ce,0x0001f680742d80d5,0x000e438b956bab30,0x0007cea409b5f63f,0x00003a8e4d16036f}},
    {{0x000fbfea62e08420,0x000360d426c06d25,0x0003a816cf07a613,0x00059db28fe4774c,0x00007987198b8d12}, {0x00021b150044888d,0x000211a2ad57348c,0x000ba884ad0b1f74,0x000a0385be8dae4d,0x000096bc030d9802}},
    {{0x000ec0f247fdfdf5,0x00079a23d1dc91d7,0x0000fdc41fb9d90e,0x00048c7012eb2c19,0x0000c2bbff72dced}, {0x000426a68cd7febc,0x00032b4854e0ca93,0x00072bbd8b596396,0x00040a8ac72b8ee7,0x000010d24d366b30}},
    {{0x0004b14e735cafe0,0x00044e80373d66ab,0x00095617fb275399,0x000da6bc5bba23f5,0x0000802dcbf70cce}, {0x000ba1cc60401601,0x0004eb5524732bf5,0x000b1a5907e18137,0x0003b1abdeb3cad1,0x00004f0c02531750}},
    {{0x000ef1694d5f3478,0x0000ab04af0a0fdf,0x0002ca633f318949,0x00014a30e3da7a6d,0x0000d002aeac8038}, {0x000311f95a0bfe97,0x000ebb4cc50c515e,0x00034df252891ec7,0x0002890936fed888,0x0000e5d7dbfe8e00}},
    {{0x000b4ae1863c1b58,0x000c296f5659ba49,0x000c2f3cb84af9fb,0x000bbdb45c071ded,0x0000db1c01e276f7}, {0x0009a9ea84ee50fc,0x000b09145b546f3e,0x000692134508e794,0x000adc6acff4f7e9,0x00007c5a5c9155cd}},
    {{0x0002d78fbfcf1b56,0x000c48427d7459a9,0x00066e74e17ce4fa,0x0005e5bae98ffdac,0x0000d548304745bb}, {0x000c6030992abe13,0x000aeefdc5c58f3d,0x000f8efb8318cfbd,0x000ef8bb5fa37d59,0x000047874a07ef5b}},
},
{   /*digit=41 [{1,2,3,..,}]*([2^164]*G)  */
    {{0x000cb614b4558fbf,0x000c0f2545a97f5f,0x000e5e4699602597,0x0006bcfd89ab3fab,0x00001daeea3eb2e1}, {0x000acd73a12940f8,0x000ccd7c73116699,0x0006c8ec624980f6,0x0003dc4a5cf97533,0x0000e180e330c27d}},
    {{0x000ece400e25a956,0x0002dac1732def02,0x000149260ef94740,0x000d51ecdb65ac51,0x0000043aa2a09180}, {0x00092bd852deca02,0x000735237c8ce7fc,0x0004b3f38f333829,0x000f17ecfb0e76e8,0x00001f2f5c58b89a}},
    {{0x0007134ca9bf60f5,0x00000c7da3a4dc68,0x0005fb57e2473ea9,0x000adbf54ef685b4,0x000094e84458383c}, {0x000d3fb4a7df4bbd,0x0008917c2c9211ed,0x0008fcba8a783d98,0x000e4c0d498637cf,0x0000ebd801e0acd6}},
    {{0x000aa5c7fd181e78,0x00004a3ad1eb08ab,0x00094aab5136a0ca,0x0004a5e6e5e6c2f3,0x00004d697d51349e}, {0x000578bf76f4b3be,0x0006f2feeb5ea215,0x000876bc381a1cec,0x0002ca5d336eb73e,0x00008afdcb5e7189}},
    {{0x000bc8cc051e9f61,0x000f5be2d9ca608a,0x000ab534875194e9,0x000490031d69c1d6,0x0000785990e88b0e}, {0x000f125f6c41f8ea,0x000aafbf2fe63825,0x00087161e429924e,0x00015353c044befb,0x00003bbdf1ba651d}},
    {{0x0002085894f7f160,0x0002b5c353fb791b,0x0008db0d442eb80f,0x000ef2377777f7df,0x000023c096334c42}, {0x000eb5ea34cb6d01,0x000e65cd1242aa05,0x000cd9f24ffb8b01,0x0009fceab6ff7d87,0x000075e94c9bb3c0}},
    {{0x00067251454f76ed,0x0005125c87a8a389,0x000efb7d652772de,0x000c11e59e4516c6,0x0000ddb8bf4a76bb}, {0x000ebd9c6fd2066d,0x0005ed7082e94acb,0x00069cea388c3b52,0x0004056a3b3d626d,0x0000bf73dfb5d065}},
    {{0x0002f06978f92cc2,0x0003431967527579,0x000cfcac1b11574d,0x000f67c3249711b8,0x0000061c767ef93a}, {0x0009a1b2f63dbe7c,0x000708091edd2ff0,0x000bba5a9527776b,0x000221f0fa985e19,0x000054f89f426ae3}},
},
{   /*digit=42 [{1,2,3,..,}]*([2^168]*G)  */
    {{0x00062846a436476c,0x0003f5dbb9cafc5a,0x00012ffbf6fcc231,0x000d14a77d2d9f50,0x0000c25e9f50ae4b}, {0x000cfc41a5e40c6e,0x0000df085321f17f,0x0003077c47d716a6,0x000e619dcbc50bee,0x0000bfe953dbb4a6}},
    {{0x0006f2fd3d777d71,0x0004df1a6b09d7e6,0x000f88dcf3519dc6,0x0001050df07bebdb,0x00007b09654bcd4e}, {0x000acd04e70c7833,0x0007c6b9d5779bd7,0x000e52f8ada66e74,0x000c1b6d0488a1e3,0x0000ec0fd119ff71}},
    {{0x0004cb6be4f27824,0x000b81c2c0cd3547,0x00065e29c10ef5e6,0x000608592c6b066a,0x0000d424663112d0}, {0x0000949b1a714fe2,0x000c3199f802d528,0x000a4ff3a52697bc,0x0009cec68ba4f8e6,0x00005a5380f55184}},
    {{0x0007f69573ec6f50,0x000e67bd2e8b3320,0x000fe24207ecc4bb,0x000cdda07acd348f,0x0000a957eb8a13f9}, {0x000f95b9ec9c0c55,0x000cba8578ccbbc7,0x00061923cd82147c,0x000f2507a2e7c59e,0x000091eb06682e83}},
    {{0x0001588957c94fa4,0x0007764911fb6aa6,0x000907b196a2bc70,0x000cc409771450c4,0x0000cc48773d694c}, {0x000216e50c878ace,0x000d4f3031f0bdb6,0x000d0d41e6e89210,0x000751b711dcbfce,0x000039bfe3eefbf9}},
    {{0x0007a45764636b5e,0x0007975d48f238fd,0x000a80177e437ee8,0x0000eae323bb1860,0x0000dc3c8f49c94c}, {0x0001164ec8cb0cf4,0x00096472936d9835,0x000059756ccdd882,0x00084aa8db1b8558,0x0000eda8cf9155c1}},
    {{0x000727d2923b8cb6,0x000d46773d5e7fb5,0x0006411656e793e5,0x0000958ecc901ba0,0x0000077ab2736da5}, {0x0009b0c6b127d9d4,0x0001163e2e1ec066,0x00041b6a28140e4e,0x0007b01ad5b03c96,0x00004299f88dbaed}},
    {{0x000296d1ea4a0569,0x000d677811b98736,0x0002dd74b6f74702,0x0004ab5c92754843,0x0000cc7327277a19}, {0x0005eded6328dca6,0x000988db755daf03,0x000192a4a5292aa3,0x00095cb5488385a0,0x0000e7d2fa93fc68}},
},
{   /*digit=43 [{1,2,3,..,}]*([2^172]*G)  */
    {{0x0002e2a0133903ba,0x00038495ee31871b,0x000991f285b3686f,0x000b8a89bcc9740c,0x0000dd20cced4f93}, {0x0001768680b65b66,0x00090ad41c3fff5a,0x000fb42690c453ab,0x000929d479630fa7,0x00000039d01b2c4e}},
    {{0x0008134bce59c0f4,0x000d159f7f86ae6e,0x0002834573d068b4,0x000bf0afa2753c96,0x000053fe33c5aedc}, {0x00094c8483c0b1ac,0x00041c2ad1edb812,0x000383e0b9e6f513,0x0001422a77b6ce69,0x0000b5a83acba9f0}},
    {{0x0003a2c72aa1c89b,0x000eda4d513df328,0x000d5ea181969613,0x0005fe0d4c0347dd,0x0000bad9ce4f3cee}, {0x00050a857313b49f,0x000def09bf30f8c0,0x0000395cb3b91c3c,0x000befe6e5ab6d61,0x0000c36cde1ceb31}},
    {{0x0005b26c3d8ed981,0x000aaa66a6e50991,0x000dab6a3f451e57,0x000ebb2984360730,0x0000710267c4d1a1}, {0x000cfd4e11d88c05,0x000761ce026a7e4e,0x0001227de12fc278,0x000dae9801cecd69,0x000017a92f3c6ce6}},
    {{0x000cdebb47b16903,0x00003a3866812439,0x00031334f0593b0e,0x000b1e46074e6e4b,0x0000e26a9771cf7c}, {0x000122b7e2ad0ee3,0x000b8e1b1a8ab475,0x0004832eadccc365,0x0004afe9dfaa7c6c,0x000071d9e4ff6790}},
    {{0x000c219e2b4f275e,0x000726d34c98a0c0,0x000d9305c8f7b63c,0x000ad6bdc5d00f11,0x0000fd56e73fd1d4}, {0x0003f94904a1f2ca,0x000a28430c3b8940,0x0000badcc559b8f5,0x000d737be89d20c3,0x0000c788b568b970}},
    {{0x000b800d37be97f4,0x000ccd54501eddee,0x0001ba27f575aed8,0x0006ea907f9efe29,0x0000430900142b1e}, {0x000e3526fcec9dcf,0x0004f01459aea95f,0x00067f611a37d324,0x00039d4ec59125d7,0x0000df685f85fe02}},
    {{0x0000fdf648c48e5b,0x00074f45a432d21b,0x000572855689e6d5,0x000547a5a9dca82e,0x00000f07eb83adfb}, {0x000b166552c8d550,0x0008ce85417148ec,0x000ee9bc0fe3fc26,0x000c80323af5ebee,0x0000666a2a341ae1}},
},
{   /*digit=44 [{1,2,3,..,}]*([2^176]*G)  */
    {{0x00020bc9ff262fb8,0x000e5075868b206d,0x0003fd973cba032f,0x000e027037602694,0x00001c57cbb635c5}, {0x000e700ba871f1bd,0x00053b265f564964,0x000950259f03a8c0,0x000a8bc8ebc9120b,0x00002b0ee317d32c}},
    {{0x000f1ffdeec441ea,0x000c701b21568c88,0x00045cf5cab52096,0x000caa37eee2756c,0x0000070d24ea520e}, {0x0005bd1546b9fd3e,0x00050c96db1b81d1,0x0005b29b73276fb7,0x000254c5c1b041b9,0x000018008dc9d7d3}},
    {{0x000a71dd360d017e,0x000609b0ed7245f5,0x00025a0184c0779b,0x000dd0c662fedc98,0x0000ee8912641d4a}, {0x000814d92163d14f,0x000017370d3b2543,0x000e1af7a79f2377,0x0001f7f80c6963cb,0x00002d521bddb9e4}},
    {{0x0000bf0ae309a0a5,0x0008875b8fbc68eb,0x0004993b7a9f52f5,0x000292b8e4f9481a,0x00000ce578edf73c}, {0x000a4a602e503d65,0x000134c68ea2d437,0x00016f34820cdfc5,0x0000dffec5993b36,0x0000d96b4c610c42}},
    {{0x000e136d3399e1e7,0x00016e2f8b74ee5d,0x00077db29e38bab0,0x00021e736126de3a,0x0000b0d186662aa1}, {0x000e45edecf9cde0,0x000e2318be705545,0x00055b0e59608ebc,0x000ca0e6596006fa,0x0000c8c2f41bc4b6}},
    {{0x000a7d03b64dcd73,0x000c858c9d559fb0,0x000fbc656f4c2f1f,0x000bea110c2db2a0,0x0000cad85cb1f5b6}, {0x000dd0e4e0b12301,0x0007198a2fcd6099,0x0001e7407c769b93,0x000b479209f5501e,0x0000b47255d2ba7c}},
    {{0x0005aa5d562b5f1e,0x000b15dac657dc80,0x000c28e5a7101b9d,0x000d0a5b7f211ddd,0x0000a89f24db3d1c}, {0x0009ef57567c80db,0x000e4a60c5ee0aaa,0x00036cd64e0d1f26,0x000de6c88a044cab,0x00008e03d02cb125}},
    {{0x000699827c7e6ebc,0x00032625bc7e8926,0x000c9cb1584ffa37,0x00084eedec924705,0x0000fad0b914075b}, {0x000d316bc0898d3a,0x000cb1f92524f4be,0x0007e59d702481ee,0x00012919896e1b0d,0x000006adb6d92bb3}},
},
{   /*digit=45 [{1,2,3,..,}]*([2^180]*G)  */
    {{0x0006950fe94629d0,0x00059f860b15c35f,0x0004f8f151cbaa93,0x00045829b4bcd3f2,0x0000ae5b06ad29c8}, {0x000c31d1b6c2df19,0x00016804facc1645,0x0002b33e6640b099,0x0008287a4a7f5912,0x00004bb0b2c0479b}},
    {{0x000aed34397ee7ca,0x000cd6fbc7fe5460,0x000b03dfef249e4c,0x0009f3c42d9da8aa,0x00003d73ce3e35ab}, {0x000dbc33813a3f3c,0x000b779c32a2c6dd,0x0008a2c3f86d5779,0x0002bf7c3d9aff02,0x0000687e71c71add}},
    {{0x000b3d6ce2a7da5c,0x000c86d365094a23,0x0009d79cd7efbfc9,0x000529dddc5f43e4,0x0000642b12101334}, {0x00052b60eb07da3b,0x00084623cceb073d,0x000ccb9c3e0c9a6e,0x00040e65e4f274a8,0x0000c6dacba8214d}},
    {{0x000a56209b3fed36,0x000a95799669e612,0x000960971f296c17,0x000a05a124a36f07,0x0000d03b214980c4}, {0x00046e270f1f268a,0x00003341aea42b07,0x0002f59cccc9b480,0x00015d1b3662d56d,0x00006c65b2e74b1a}},
    {{0x0006d5faba617ca5,0x000b0788f1e74ce6,0x000bd2024f5bb17d,0x000aae03ea09fdff,0x000053dd7097abd4}, {0x000458bc19c4561c,0x000dcb2676dc42c1,0x00074f7de4ecc53b,0x00051b1614610252,0x0000f5fa738c9ebc}},
    {{0x0000f5608a104d47,0x000f2317079a22df,0x00031eaa8fa16cf8,0x000c540425bed530,0x0000f7c45cba44f3}, {0x0004e5f9db182a9f,0x000f49f23a6d6157,0x000b6efa6cae923f,0x0005174b19b78d03,0x0000fa74d30af8c3}},
    {{0x0000568ac0e00ce2,0x000821c05e349afb,0x000a524f0ff4bc59,0x000539a94e0be1f6,0x0000995e87848303}, {0x000f99cde02dc40a,0x00037e00fcad06cb,0x00030a510be18069,0x0007327a71994d91,0x000072b5007a9e07}},
    {{0x000113acccb0a4b8,0x000ab615f016796c,0x000ad2f5b24c26bb,0x000abb52fe115aee,0x00005623d268d7aa}, {0x0001fd031a2564fc,0x000e8d0d59a39079,0x0008b74663659974,0x0007b02cffdb747a,0x0000f6b36e611478}},
},
{   /*digit=46 [{1,2,3,..,}]*([2^184]*G)  */
    {{0x000aa41b6223f04a,0x000f241c3faaed9d,0x0000b42cf803c9c0,0x00019360eee3f9c5,0x0000f4a7a5b17298}, {0x000c2e1bf809ad69,0x0002867c0ff24379,0x000f8e637903ab4b,0x000363c779d7ed90,0x000068b0cc0bcf3d}},
    {{0x000871cb79f82af7,0x00029dab52f5f4ca,0x0008239a731304b0,0x0007361825ab5492,0x000040413b2fe4ad}, {0x000d3fa44071d191,0x00014f0b2da8b5c5,0x0000a198183e438f,0x000ae3fd759448c7,0x00003e0c7ee665eb}},
    {{0x000eaba5568f2420,0x000b029afc1f58f4,0x0004d7dfc83b0c37,0x00053293de2d2799,0x0000d9a6edbb1679}, {0x000427995f085b0f,0x00099299355e4b83,0x0004427f846ebac9,0x000d0e0212e48904,0x00009e4ce3592f37}},
    {{0x000d314ef7750f08,0x0005a2da84d6834d,0x0000d647b2ceaa70,0x0001574561a254fc,0x00001cf09163be01}, {0x0003d4e34b798ebd,0x00065b1c7543847a,0x000194168bb5dd62,0x00010b94fee01bc8,0x0000b4c2600caeb0}},
    {{0x0006baf530c98b7b,0x000c0acf023af1b3,0x000de150304503d7,0x00089f96bc444921,0x0000b8a123082a9c}, {0x00099dfd5d4b133f,0x000cb97d3e5176df,0x000b318d61bb4a13,0x00052edab370f379,0x0000a6c823f8f185}},
    {{0x000b22514fb96241,0x0008da4229d70f09,0x000dc8c192eba4ff,0x00053e5b159dd121,0x0000e1f968fc1aa5}, {0x0005976c7674d527,0x000ceb283500fea2,0x0009468c298e73ad,0x000a627cfce0e1d3,0x0000aad0af978438}},
    {{0x00009f62eb1db212,0x0005b2c3e3e183cd,0x000a43da5be37048,0x00025eeb51fa296a,0x0000c7fa809f7266}, {0x000786ff0ec0e998,0x000388135cbf10c6,0x00004751bd315af3,0x00081ac1b6017215,0x00008674e2d8e287}},
    {{0x0000f771e33b2a39,0x00002f78986f8fee,0x000f05b7ed4bed82,0x00062a6396feea6e,0x0000c5d6a01b640b}, {0x000fec96834bea4e,0x0009c131fec9370c,0x000affb4d68d1672,0x0002564be9c5d600,0x000034a423d79a6f}},
},
{   /*digit=47 [{1,2,3,..,}]*([2^188]*G)  */
    {{0x0002874d8247f131,0x0001f3c11f564dfc,0x000503b97c211a7a,0x000c827512563fa2,0x000024cd9846c007}, {0x000b682491cd2498,0x00042683359ccf6e,0x000302b62af4f70a,0x000f562f1dfe71cc,0x00003c474bc657fb}},
    {{0x0007ab7916a8016d,0x0000232bfb9b73af,0x000174971f93d488,0x0004d4a5f9af3ce2,0x00001b9cf1ffd59b}, {0x000941844f4eb91b,0x000d7226edc49a77,0x000d4bb336a131fa,0x0001fe472ab89780,0x000069687a5df6ca}},
    {{0x000cc72520cd267f,0x000403d37ceb7c99,0x000c45cd39b83c2d,0x0001efc2b56ed68c,0x000061a49ae9d3ff}, {0x0006205a05677aaa,0x0009311b22bc4589,0x000beaef3c87845d,0x00092199ef1336bf,0x0000542906a3b1a9}},
    {{0x0003ca2fabd066a0,0x0008f9c78bfdffa7,0x00055cfef494e03a,0x000784e585a878ff,0x00000770b1fd7053}, {0x000da4a056fe70b0,0x000857bd444fdec4,0x0005df668e37395d,0x000583666250d468,0x0000549569ebe6cc}},
    {{0x000aac0ba9b5ca4d,0x000c4512a151524a,0x0000680f2f556fea,0x00041a6cff93f359,0x000033c25c629212}, {0x0007a1300ee2808d,0x0001896afc72b53f,0x000f030ead83e2c6,0x000f23a0abf470ea,0x00006c675098a456}},
    {{0x0009830ab11639e9,0x000b34488d52f762,0x000f06eb6869dd3b,0x000c3710fe1c0bba,0x00009034839a687a}, {0x00083777f1ffe7b3,0x000c55bd7c570841,0x00008ba673334a74,0x00012dc57cb7ed70,0x000084c12d0f1e4e}},
    {{0x0008690fb57459b5,0x00067b878006d66e,0x0007ea63d14bee76,0x0002bc9b5267dd2c,0x0000e8f2a4c53e01}, {0x000c64aca5e07275,0x00053875bdcccc3f,0x0006194383dd2f10,0x000d012a09337b76,0x00005415071fe1e9}},
    {{0x000dca6db4bdb35e,0x000d54d913a7148c,0x000ed94d56bc23ae,0x0009e78f0ccd9d12,0x00004aabd1366db0}, {0x000f31a1e9483261,0x000c27a479a1fcbf,0x0007686f1cf68c47,0x0006693cced8e2ca,0x00005ed1e995eb62}},
},
{   /*digit=48 [{1,2,3,..,}]*([2^192]*G)  */
    {{0x00092a4202bde39d,0x00050d6bab982b39,0x0007125122549f56,0x000e500b56464287,0x000052442b54fde7}, {0x000fd08a3d3e16e7,0x000b383b29bd36ce,0x0006dec8c5b194f0,0x000c1e6db0edd890,0x0000a09095972570}},
    {{0x00095d0eb10175e2,0x000aed236aa11106,0x000dfff4079aaa6e,0x000063f78539ff3e,0x0000369c51722cd6}, {0x0003ae55c8631ff6,0x0002816a60bd21e4,0x00061a5f9065e821,0x0006fa225cb473e7,0x000095ef8610b6de}},
    {{0x000e6c9f60ee3e5a,0x00004236377f06b9,0x000a4af71b397af8,0x0009fbb7a318ac7d,0x0000e64b613aa9d3}, {0x0006c74902b34119,0x0000ea199e52d6ce,0x0000fb76fea256a7,0x000f9c8dcddd8955,0x0000443b47793e70}},
    {{0x000fe2d952980037,0x00011d8412fbc96c,0x000997dd3caa6655,0x000587f41d021583,0x0000066e356b5534}, {0x0005c3e5b6de0d7f,0x0001becd5f251d5b,0x00052ae508ead45d,0x0000bfe2f24e2cd2,0x000071e5d5071515}},
    {{0x0004735e1d88c25d,0x00026bd66b66d27a,0x000af9942339905e,0x00083ca9bfa0ed62,0x000094dd9e0fe2cb}, {0x0008fdaab28e268b,0x000c01a97517779d,0x00091f33ef28ab69,0x000d64ce9bd2ea96,0x00009e8b2ff24be3}},
    {{0x000c0908b9f8e8c0,0x000024e94ce19274,0x0000f3ec1a375761,0x00026f8f2b1f2c4f,0x00002e53bb23938d}, {0x000da2c701e5ae8c,0x000b6271dcc9d0a3,0x000fb237260c2eac,0x00008ac9c08e3931,0x0000aa3245f78389}},
    {{0x000f3382b02578ba,0x000f04b2c6071100,0x0001611794716339,0x0002a092c923ae5b,0x0000da2e4daadf44}, {0x00090c547f854740,0x0009824e31954d4b,0x00078a0d4a378bf7,0x0009e24469339d24,0x0000972e7880c1e6}},
    {{0x000585b36a1f3a8d,0x0000613ba5f1a9d0,0x0005acf11a3d8f18,0x000e791eaee5d622,0x00004dfd0a2dd32d}, {0x000324b6b3ceff30,0x000cab4478700cec,0x000c759ac3acc6de,0x000938abbf7e6db9,0x0000d5c1f47a5196}},
},
{   /*digit=49 [{1,2,3,..,}]*([2^196]*G)  */
    {{0x000215745e7ea912,0x000dccadfc40581a,0x0002cd3934da3f86,0x0000fcc81d6c7d16,0x0000c38a2a1cd6e6}, {0x00025d6f753479d6,0x000f1dec6024f75b,0x0002d5547c914e08,0x000969f81cea3449,0x0000bbb8bb25b1b6}},
    {{0x000082c1279504c1,0x00023c92ffb70ee8,0x00081c7e2a466abb,0x00033a4118b26a3e,0x0000a76cc510c60e}, {0x0008bc25736d7aeb,0x00096d1ef9928499,0x000bf252520b3955,0x000626d669e2ae5f,0x0000f956ec6b1cc7}},
    {{0x0007029b0ccbaa5e,0x0003079b78a5ee81,0x000f45d8957ef5bd,0x000fd3c92837474d,0x000086b91a90ec4b}, {0x0004c6dfe5659152,0x00069c58a042c5ab,0x00001c4bce657471,0x00013ae141deda63,0x0000f95d561a0845}},
    {{0x0004508eecede3d7,0x0005a86440d06c42,0x000de0d7711889b3,0x0004477b229f9398,0x00003fced8aa00a7}, {0x0001c79e31c8f881,0x000dcb277e4fe75e,0x00087c02c8db20bd,0x000c1a8ded0a702b,0x000066281b55d164}},
    {{0x00056cfeedd8e0c9,0x0000744c012af873,0x000aa3eb68afab38,0x000a570795935fe4,0x0000b9efc0d6a6df}, {0x000f8aaa8ab0840e,0x0004a85616042ff0,0x000db93150f3a4b6,0x0009f82ca911efd5,0x0000f70e5bba8ded}},
    {{0x0009209a6aae58bb,0x0008d74edda2943d,0x000be3c9a3d0798e,0x0002dc5c2d462cc2,0x00005488239f3988}, {0x000bb41977d4de44,0x00005e8245c42391,0x000093dc27fd9104,0x000e121a6d3c713b,0x000023a4e3abb22f}},
    {{0x0006f403a9a04a3f,0x0006197d9afef315,0x000a898509b32c4e,0x0000827e0b401e62,0x0000fbf542f984ef}, {0x000c0e0f990caf53,0x00041c88ea9b077c,0x000f96a510270434,0x000c47846fd46c63,0x00007f5cec019855}},
    {{0x0000bd8e6ad29dc4,0x0000aa04da287d14,0x000e05b337dca4b1,0x000acfa84feafcad,0x00004d031f8b630a}, {0x0002fa6cdee269c2,0x000ba697a40af8af,0x000e5f8261e40571,0x000fe6f71d44adf0,0x0000a47ddf9c434c}},
},
{   /*digit=50 [{1,2,3,..,}]*([2^200]*G)  */
    {{0x00092d346410cb1f,0x0002f3a5a1354b38,0x000de068d72097f2,0x000890db3a1b8098,0x0000b7438e53b1a3}, {0x000d5ea3839d3d99,0x000e84bd8125fa10,0x000800261d9ad034,0x000c5207d108efd4,0x000078d98bb2c5d6}},
    {{0x0002d017375f2deb,0x00093aa152399f94,0x0007e5c4c968a760,0x00040e55dc7da637,0x000075fff53d82b5}, {0x0005c15fd4b69512,0x0007104ddfaedee3,0x0007c87146d1d64f,0x0006fd320f1769af,0x0000b5f86a4682ba}},
    {{0x0001f3bdd857b31a,0x000b69513734201e,0x0009327b892c2263,0x000164562652d558,0x00008edd06636a1c}, {0x0008f9879f8df8df,0x000230847ddd3cbf,0x0007c06223d5cf77,0x000f2a69b08ee459,0x0000ff18c4e7a868}},
    {{0x000d7a99107901be,0x000f8211d1153c6f,0x0001b78a85dc4a41,0x000b6a597e94e7af,0x000072da34e33afc}, {0x0004db774512c248,0x000a32811e913c36,0x0000469b1c26a8fb,0x000535fdd39d7f29,0x00004515392a0612}},
    {{0x000606a4a98f93dc,0x000eb3475d7197ef,0x000e3f8cf41b9190,0x000a4f7ec792db91,0x0000a37ec10e2396}, {0x000c219d0879e176,0x00044ac57d3f90b9,0x000037ea761303af,0x0001ec13293c3be1,0x00001557e050058f}},
    {{0x0007cd15c5d384fe,0x0000d74de832cb99,0x000fb7ce336884af,0x000ef76be21274d8,0x00000bb298f86608}, {0x0001a0cd53bd4269,0x0000feb3293b527c,0x0006fc1ac78035a2,0x000fed0d7689eb2a,0x0000a38274adf2c4}},
    {{0x0001c4eccf60d0bb,0x0004bcab95d81e7f,0x00025a060c7918e1,0x000f357af4761e14,0x0000fa0bf6fa8e80}, {0x000629801e11b3e0,0x0008d92d8a4f88e7,0x0004a9e6f4b7ca48,0x000b1f247db98bcf,0x00008745cd1c9705}},
    {{0x00096a01539cf31c,0x000acded7c6dbfe9,0x00016f6144a3f729,0x00016386f1f29930,0x00003d44e1946cb9}, {0x0004531558fa36c2,0x0005569c89d67698,0x000ee923f58e8bf0,0x000fbc287da114f9,0x0000032e9850c271}},
},
{   /*digit=51 [{1,2,3,..,}]*([2^204]*G)  */
    {{0x000579dd39207ad8,0x00058b1fe91611b8,0x0009e01bf6f62c72,0x0008430f1599acd8,0x0000d9bb86dcd1e5}, {0x00090d4726e38d1e,0x000b32a8c6b8548b,0x000d2f6f4b824a1c,0x00012e984d9309b1,0x0000fa485b8231ec}},
    {{0x000560776ac19252,0x000b5442fc587972,0x000311e74086449d,0x0005618dbab9202e,0x00009dee69b9ea25}, {0x000b6ee19a7cd6c0,0x000c0d0dd5a05a62,0x0006d0ff1ba38cc4,0x000dae779279e516,0x0000eef53ccf48b3}},
    {{0x00078408c7c6d897,0x0008b2c2555f255b,0x0009c3165bfa78bc,0x0001bc8c56ae3da6,0x00002b20e73533bb}, {0x00070b4d1aa6416e,0x000c5db03cdc8868,0x000a0fd40f000040,0x000f1fd25b16a9b0,0x0000b89e93316815}},
    {{0x000393579f34a8a7,0x000fa0046434c9b4,0x00005fdb161acf55,0x0007fff0a23fe63f,0x0000d6baee17c4fa}, {0x00062b6e2daf735f,0x00091948637a353f,0x0004e6206e370ead,0x000ad3da57c16ad8,0x000019ffe09fdd22}},
    {{0x000ed1e4263a5660,0x00041d5e8f55fe64,0x00094342c735bbee,0x0009359ac6191582,0x0000f522e5ad4904}, {0x00083b57c1e11f47,0x000060c237f3bee8,0x0009550860a2ce31,0x0002dbf4a7157b8d,0x0000ec0462e722dc}},
    {{0x000a5c739620daa9,0x000fff7c078f1e65,0x000177db88ef6f93,0x000535b06d52bcb0,0x000015cdd08f8fdf}, {0x000d150c51832222,0x000d9817a2ade070,0x000194f0b2b6495c,0x000dfb3ce476140b,0x0000eec6acf713bf}},
    {{0x000814fd7daf836b,0x0007bd6169217cd2,0x000066012877b72b,0x00059dea73ca1bdb,0x0000e336c7c60d41}, {0x000b07f0f8fcd765,0x000ada5935626993,0x00091ec195fdceab,0x0003c0716595fbf6,0x00001a77f61de68e}},
    {{0x00045a51d63aa7f7,0x000623b32da2680f,0x0007088588d5eba7,0x000c610ef233dfa4,0x00004c3f4f7c2161}, {0x000fe6be6420de40,0x000197dd86d5fa9b,0x000ce233b96c0c50,0x000d6328e6827bcf,0x000035cc9a958e74}},
},
{   /*digit=52 [{1,2,3,..,}]*([2^208]*G)  */
    {{0x000997917a86e187,0x00022e029110b2de,0x000cc5a17e2ac232,0x0003cfbfd3439735,0x0000a93461fc25e1}, {0x000542c5122d6f14,0x000ec33982c79433,0x000c24d2741d2d9d,0x000d58e9f1f29a8e,0x0000ae251f433b99}},
    {{0x000a46047920742a,0x0000545f94cba02d,0x000608dd4b142d6f,0x0004b5c2d613e876,0x00002c06cddfd75d}, {0x0001bc53c564ff4a,0x000c4d1d5ecd0195,0x0002135ade60f126,0x000695a634e76570,0x00005a56a6f2df44}},
    {{0x000482697e839b67,0x000b3f49adaf9986,0x000795531cfdae67,0x000aa4f713da0fb3,0x0000b2f6f6d8d391}, {0x000b8c351b5e7aa9,0x000244f29191734a,0x000692f40fc4a912,0x0008ba8f8e2cdc12,0x0000b0bee740f405}},
    {{0x0008c7a9e2207b45,0x000147ee9f61d34b,0x0008e21b61f724f3,0x0006aefa908ca2c5,0x00005587744f7429}, {0x000913002911ae14,0x0003dd3af02e3dbe,0x0003955a1c207543,0x000d66505b724b0f,0x000080e1a930aece}},
    {{0x000246ba01d1d691,0x00061c28f15519cf,0x000dcd8cb66c23cf,0x0000f0441e71089f,0x0000c22323a9398c}, {0x000ea418a3f400f7,0x00008b3a0959e3ad,0x0003b53b4787d2e1,0x000436e7464f0fbf,0x0000e7cda2bec46e}},
    {{0x000f0871be603736,0x00064f9180e995fe,0x00060416e4dd25ba,0x0005530d3996f9ef,0x00002be886c4b749}, {0x000c5fbb48089d39,0x000e6a2b6d24c533,0x000c20f7f06c8690,0x000dbfdf149e4e00,0x00000f3d7e0794a9}},
    {{0x00015dcfc8176c4d,0x000d68bad0d95505,0x000ec582805f29f5,0x00027312d25fc5ef,0x00002f5fa1bfdd52}, {0x00071e3717366b82,0x0002d2d99b2a09d8,0x0005ed437bda0f49,0x0001592abda54f23,0x0000449feb33935c}},
    {{0x0006128446d9f664,0x00050354b5a1720f,0x000558aacd6e06b1,0x0008fda72d287d63,0x0000819be29ee68a}, {0x000c324205fbdf26,0x0007810927f95024,0x000658f802fca94e,0x00004674798be7be,0x000018e07f24f07c}},
},
{   /*digit=53 [{1,2,3,..,}]*([2^212]*G)  */
    {{0x000a94654b01bbca,0x000da55d4820b47b,0x000575f207c56c36,0x000cf48e93362005,0x0000ec65be9da621}, {0x00096df462879372,0x0003933c67e7620b,0x000cf3e0535cea88,0x00077330366a3a58,0x0000580d5654da39}},
    {{0x00061815832cd6cf,0x0008885e90b9553b,0x00014f686c002e33,0x000d454b33afde64,0x00009ab29ea7511f}, {0x00009726fb9a688c,0x000d3202a1b2467f,0x000a881ab7db6e14,0x0006600c15b6e973,0x00008c324e1bad10}},
    {{0x000d412c9489dcb4,0x0005512d084ba43e,0x0004c7cd2cec053a,0x0007f70fd4fe4266,0x00008ee06f4c2a91}, {0x000197083cd65f5f,0x00094569c42ed5de,0x0008761103a17657,0x000bc4f24508f34f,0x0000350374bfa415}},
    {{0x000108255ade88b5,0x00019b212e84bc89,0x0001362fa0525b50,0x000cac9ede010bb6,0x00002f3d088d81ee}, {0x0007b6ebc6f0ae45,0x00036659701cf995,0x000b76f4525fe726,0x000d4241e9b7f507,0x0000f2ad6650da77}},
    {{0x000518c9bb777fc6,0x0001e24151875571,0x00020284bf369c39,0x0001cc2d7c5dd927,0x0000feab634aeec4}, {0x000d5db24ecd0bef,0x0007f03387353522,0x0001452791fca0d9,0x0009257441610520,0x00004492e1ef496e}},
    {{0x000dac0d193a5260,0x0009e2b2d54f3c44,0x000c67d11d071709,0x000ad865624fb4c4,0x00004aa7033bcced}, {0x0002fac31470c527,0x000aa3b05d539c52,0x000565e5708eb33c,0x000370940e0693b4,0x0000e2fd553ebe56}},
    {{0x000f5d0be4d36ec2,0x000348e952fe8568,0x000ad6b241e9e539,0x000de9768113f9ea,0x0000bc798fcc8fbe}, {0x0007f9baaa9010de,0x000b561834c94c78,0x0002c25d832cbc77,0x0006dd449e55f703,0x0000824a5c0aa621}},
    {{0x000065a848bdc535,0x0004578554dcb366,0x000ff3b4dba2af07,0x000cbb3c755fba19,0x0000ea9337285a22}, {0x000fe021eb3e23bb,0x000b265dede35e55,0x000f445da2626ecc,0x000578187bf09481,0x0000a0110184df30}},
},
{   /*digit=54 [{1,2,3,..,}]*([2^216]*G)  */
    {{0x000ee9a1baea5745,0x000853ae5167cae4,0x0006911240d922f2,0x0007c407df28fdca,0x0000aad2f31ddd45}, {0x000f443137384cac,0x000b2620ea8c20d4,0x00067797ad93d424,0x0005bc21d544d350,0x00008a8cc9a5d8a1}},
    {{0x0000e26941d80a3b,0x000a5d36514db10f,0x000f226013092787,0x0000f6aa2dfd4898,0x0000c5b31b838c8b}, {0x0001f376c841cc81,0x00096a412b84a128,0x0008f210ddae1671,0x0009019ec1f6c882,0x0000935d576f8d92}},
    {{0x0009be8f731e66e3,0x000ff7c9ac6742c8,0x0007788475c65a3b,0x0005a7621746f622,0x0000e38982159449}, {0x0004aab948c94967,0x0008741e79476b0c,0x0005283abdfdec51,0x000bc091420e3a60,0x000099ec46fa4c7d}},
    {{0x0007921af3840f27,0x00034f3fcdfbd724,0x0003961bd348325d,0x000c29ef578508c4,0x0000d5e8ccd8bd98}, {0x000ba10f8a30164d,0x00004cb8c65289cd,0x000056ef40757409,0x000d1bcd7ed73fc3,0x000028e7cc2cb99c}},
    {{0x000c0f95182958d0,0x00075749c24bf1b7,0x000638c77ee0c407,0x000cee32f35fcff3,0x0000a46c52952773}, {0x000d4f7e2fb9042e,0x000a32ce916d9ae3,0x000bf7ae89855249,0x0002b7e48a640b04,0x00003eb60417c9cb}},
    {{0x00074946bb62286f,0x0007d7d87466b8a6,0x00073b6d58d6ef81,0x00001b3529f938f6,0x00005c0ee777bbf1}, {0x000ed6149fdc9493,0x000eff405ee00768,0x00018e51a53b6999,0x000bd7bf0108a017,0x00008e609ec8181e}},
    {{0x00079083a6a2a006,0x0007ee549a6dc288,0x0005facfa82df7fb,0x000de38f1d62b44e,0x00005566a01600ca}, {0x000bcf5b76201357,0x000ddb75df8e1672,0x0002fd615cf00849,0x000a8a8f5d3e0fe1,0x0000fb3f7894f727}},
    {{0x0001640d85951597,0x0006c79a38761205,0x00098a67c30e1c70,0x000d27091154c602,0x00006d9a9c9c1132}, {0x000e8b75c661a4d6,0x00068a6dcbaf841d,0x00014e045f24b5e9,0x000c701ed4cb0cd7,0x000005926a46c187}},
},
{   /*digit=55 [{1,2,3,..,}]*([2^220]*G)  */
    {{0x000e0f2aa1ff4af5,0x0007890503a3c558,0x0004f76f161f4348,0x00032e661647323c,0x00000d0706eee134}, {0x00087caf5eba0fb7,0x000ff0bda2c4ef1a,0x000ae646228a95c0,0x000ba610d693e012,0x00009871341645e6}},
    {{0x000b01264b496679,0x0007ae05f7601dc4,0x00085d27aa4bdafa,0x000747171b28b3f1,0x000087e5163c3425}, {0x000ac4ec3864a656,0x00091f449c121c42,0x0009658322dae1bb,0x0009f4680d974306,0x0000ac1ef01de31d}},
    {{0x00068563958e0555,0x0000adf44aeea780,0x000c18b8dac35ee4,0x0006cd2b47891397,0x0000396824f4a258}, {0x0007b251b23f8c4a,0x000f6decdef982b3,0x000fc39c0f9ced36,0x00032b28c3bee5c2,0x00001731faf0d9db}},
    {{0x0004f74ea3d44467,0x0008b0ad1c7f045d,0x000374e92a439f17,0x000008c95d951051,0x00005870ea000229}, {0x00098c2c54e7e812,0x0009b4b3860b1fec,0x000bfc8f6ef537ee,0x000403139dd83440,0x00000b513642f114}},
    {{0x0006ab6dd13b3c94,0x00072371f872f32f,0x0005712ab70e052f,0x0001000574074212,0x0000239152df3512}, {0x0005eaa80b229154,0x000cf896f6fa5835,0x0002b4c8fd0e263e,0x0005bb9378a8a644,0x00000c2b54736579}},
    {{0x000fe8c284745301,0x0003eb7fec008f80,0x000cb05ca5649a17,0x000c41deed5bf4d9,0x00004b1a3a9e7077}, {0x000d239096883ec3,0x000e74ae671d1c2e,0x000b7362ad550edf,0x0004f2b233e5dcf7,0x00002c158207fd46}},
    {{0x0006a81c61ae9676,0x000cd2a2e1e5c52e,0x000211ef8af11042,0x0005fcb353902a1a,0x000044d16e1299a2}, {0x000d6065b67e48ad,0x000421a0b664937f,0x000e072b8fa57096,0x000727aa661c737e,0x0000e1eb4ffc2e0a}},
    {{0x000bc2afda6a4a95,0x000a5106ae0dbdd9,0x00069a4bbdba0178,0x0007153820c9f549,0x0000031e9fde9fbc}, {0x000030ac193d9428,0x0007c54cbb38e42a,0x0008fa77cdc3d6ab,0x000a95507c17b91c,0x0000465bcc963642}},
},
{   /*digit=56 [{1,2,3,..,}]*([2^224]*G)  */
    {{0x000265bc25dfad35,0x0009993f44b6974e,0x000d6d473d03630b,0x000992b3270892bf,0x0000b2d95436c5ee}, {0x0004537a36f7c5f4,0x000dcab0b81daeb9,0x0008b45e59befc01,0x00048b483cdb0818,0x00004c753b741e46}},
    {{0x000bc87b24116186,0x0003507924c48e43,0x000c9255708754bd,0x0007f4ef2050334a,0x0000e7e4fe74e038}, {0x000e2e276961d0e3,0x000767eac10f21f3,0x000757a882b69d41,0x000d3536d0f45f73,0x00008b967e55b0c7}},
    {{0x0008fc4b31fa7794,0x00054f13036e54ba,0x000d754b78024dc8,0x0009aefda2af6382,0x0000a784242ee9ea}, {0x00014abf9887947d,0x00059d555a0997dd,0x0003a46aa7f2ecfc,0x0004b5b37c4244f6,0x0000032cfc2cf71b}},
    {{0x00084c16b8a6a975,0x000e5b2bca35baef,0x000174d43d2e7f3d,0x000c5b721c6c095b,0x0000719cf32252cc}, {0x00061f03adf95177,0x000a1be20ff4fc73,0x000eacc0e1e26416,0x0005d201f9d99769,0x000021eba6432e63}},
    {{0x000e9c825df8bb5c,0x000f75752d7d8225,0x0003b281d931f721,0x0008be3c4ed4750a,0x0000f9276830a466}, {0x000358e75b7e90c9,0x000e47a29b998b7f,0x00067f2c806e5c24,0x0002d30058967aa1,0x0000f1a6fba34ee6}},
    {{0x0009c4f278291f13,0x000524e64c1d9a89,0x00062916e69a9032,0x0007cc46cc5d428d,0x0000c802e661c100}, {0x000f2aa6219cfbbf,0x000dc10258b1eadc,0x000e142af942870d,0x0007a377264e68a5,0x000025675e2f89cc}},
    {{0x0008a3b7336aa166,0x000e1c5c622bb77e,0x00089e0295a92cc2,0x00057333a35a2c17,0x0000f91306eae4d5}, {0x000a581da0a46f52,0x000d62640bbac5a2,0x0007b3ae4fb532be,0x000a7188ff0f114a,0x0000223e7b6d8ff7}},
    {{0x00031335d21d261c,0x000b8abb1fbcb593,0x0001b3b61a336289,0x000511797db2f363,0x00002cedb2697e6a}, {0x0006f34103553328,0x000add0ae37f3880,0x00017c5c7e5f1fb4,0x000ec357cf26a55d,0x00002e8df47e8c43}},
},
{   /*digit=57 [{1,2,3,..,}]*([2^228]*G)  */
    {{0x0001128ffb5e7ce8,0x00032ecb96c1e0d4,0x0005ca788dbd8b54,0x00038c029ab3dd0b,0x0000b1148a2990eb}, {0x0008db869fb19245,0x0001018391a80904,0x000d311b9cd2149f,0x0009b96bece5b6fe,0x0000edbe9b9effd2}},
    {{0x00093e7532e8d6a4,0x0005302a1ee4ab55,0x0000496c09409290,0x0007c8379b32e820,0x00006fb6e9e760a2}, {0x00077ba620051584,0x00014de3f1914a33,0x0004d21271a3266c,0x0002f3e60fad96c9,0x00001553dd1a4630}},
    {{0x00031a2a6ec0fe46,0x0002959645720704,0x000da5c3949da0b4,0x000e51bb12d1b09d,0x00004170fe1d2d3d}, {0x0002b16a4a2f5d9b,0x00059590be923a8b,0x000b9b0b5de1bad6,0x00067eb7f93581f0,0x0000007f4de9115d}},
    {{0x000d36fe12a94abc,0x000a75ad7c477b0c,0x000768469f364b3b,0x000cc596a7a2a78e,0x0000cc31c7edbbc7}, {0x000d5d0080dbb92c,0x000316fb0f1f270a,0x000d99f57fb201e9,0x000da5dfce7a1e29,0x000012a02b0c6457}},
    {{0x0005482a048530b6,0x00040467f15d9468,0x0001b7d84b4a3120,0x00095db5f8a2605b,0x00001ceef97bf452}, {0x000832a07e7578a7,0x0003d915eb7cc48b,0x000cc58340724963,0x00028995bbad2d0f,0x0000fdeed650da95}},
    {{0x000b56d84457fa16,0x00061e11055dfd9f,0x000d8d3cf1cddb6c,0x000b08d4173a6b13,0x0000e1b2d83761d2}, {0x000efe79a7aed4b6,0x0009fc67b13ce887,0x000a8d47351b67cc,0x000cf5ffd958d4f0,0x00002c566abb452e}},
    {{0x0002367962f3f098,0x000b1784e6f456a0,0x000fc496b5d1b73a,0x000d88b82f0e3c6e,0x00005b2fe37d1f96}, {0x000de1a58c6ee495,0x0003ae7abc0c0aeb,0x000075de7d3903b0,0x00051633f3381ecc,0x00009c9d48206fa7}},
    {{0x0002ba62a80f39c6,0x0001c8cbe0887ea7,0x000bd1cc1cb2174b,0x000ce69c73ec69d6,0x0000a2dbe21520dc}, {0x000150beeaae9da5,0x000dedf630d9d0a5,0x000634cd8c935e85,0x000f022147144fa1,0x0000eccb56c94f3a}},
},
{   /*digit=58 [{1,2,3,..,}]*([2^232]*G)  */
    {{0x00079cfc0e2b70a5,0x000d3e8cbae7a77a,0x000db18fc2569c8b,0x0000ff392a5dbefa,0x00009bc96b48ce6a}, {0x00004f48b5510059,0x0006344b2bd7987f,0x000c447d77efe3aa,0x000dd00e9cb8ed6a,0x0000b4eb10b0783b}},
    {{0x0002acc711923485,0x000f8f17ef5fecc3,0x000e25b0e545401b,0x000ab9e209a493cd,0x0000c11886bb63ab}, {0x00081b128ec7c90b,0x000725b57f5c361a,0x000d9169618b125a,0x0007ff86d1b45afa,0x000031a786e54c3f}},
    {{0x000189659471f1f2,0x000d1630357339d2,0x000bf5a4b2e613de,0x000be5a799579478,0x00000adf6b5df19f}, {0x000c95f1574d34dd,0x0009d9323cea6a48,0x0002df9cf95488f0,0x000500450aee7f55,0x0000f016f7b23557}},
    {{0x0004c6f8d9fceb6f,0x00099b528f3748cf,0x000303b2b11e85f7,0x000605e2896d2552,0x0000929675bdd68c}, {0x000237410c708a9a,0x0007e0d7e5a75bd2,0x00041047f4682ca1,0x0008404242b5c590,0x0000f571053af9c6}},
    {{0x00066978e93edd55,0x000207ea4f453969,0x000d33d8735cdb8e,0x0002d636f8305dfe,0x00007623440b2564}, {0x000b580945dd7d69,0x0006031739bc4fd9,0x0007bf127965ffcb,0x0001c734588e1f63,0x000036c0ba0e39d2}},
    {{0x0006a599a93a5c94,0x000ce8d12f613d87,0x000b2aa43026be75,0x000dade49900ede9,0x00004d6dc80f3a68}, {0x000116b7d23e11bc,0x000376814209396b,0x000c659561279121,0x000fae3e2807cf6c,0x0000c606ca8b405f}},
    {{0x000017dc145a6c70,0x0002968798dab36c,0x0000eff5dcca6438,0x000681d13b63768d,0x00006e39e2d2206e}, {0x000ffa43add517af,0x000900d95fee2d9d,0x000c7c7a8e670e6c,0x0003050ecb51abf1,0x000017dff5264945}},
    {{0x00068f9e5137d20c,0x000acf7e70ac618e,0x000b86b0a79588cb,0x0001feb6d37f5258,0x0000b281c993cc59}, {0x0003fed8fe40e06c,0x0006ad9ca79270e0,0x000d3a3da394ded9,0x000130f1d22cddbc,0x0000b88cb27cc591}},
},
{   /*digit=59 [{1,2,3,..,}]*([2^236]*G)  */
    {{0x000eb34649966a56,0x000f86639e18c8c7,0x000ce0f3897587f4,0x00080a0724cc000b,0x00003578addaae62}, {0x000aa57c7fd6a1af,0x00046b017e3501be,0x000df2ed183b1a53,0x00085201c027e3ef,0x0000373d4ebc2d31}},
    {{0x000546827502203e,0x000538ade3161e8d,0x000687415985039d,0x000774efd373f10a,0x0000fccb79223526}, {0x000d46e0f4497d9a,0x0001b601ab9a4ef8,0x0007b2ad14152df7,0x0001804250cd2fe4,0x00002b63fa69b048}},
    {{0x0004ab81e6799c95,0x00006d148443a72e,0x000a73a1b4c0452b,0x0003dc4f3d6068b1,0x00003d967d92a918}, {0x0006305308773b32,0x000dd107d1c4a6ba,0x0002936f7c5535c5,0x000e7282492b6d5d,0x0000207d5e4da0f0}},
    {{0x000cb6f787d1f1c8,0x0004bd219a6658a6,0x0003146b0427bac9,0x00078151d7d49f38,0x0000164b77ff863d}, {0x000b0842f9631b8b,0x0009349388de6646,0x0008cd383ef5b3aa,0x0003a060536422e5,0x0000079d912a43ea}},
    {{0x000234ea69b16e89,0x000bc1d5e5a6f2c1,0x000b57835cef457b,0x000ddf906b1d3021,0x00008fccf893f260}, {0x000af0d389fa01e6,0x0009e0e60cc9a47b,0x000e5dd23920c8f4,0x0001cdf9674c7ce3,0x00003ba7e5f5ab84}},
    {{0x0003293983884693,0x0006f55208130d55,0x000c8b1b292a9779,0x0008e2c2bb329ebf,0x0000c6f15324e83e}, {0x000d963e4290a26e,0x00017cf40c04de61,0x000e829f7d35af4d,0x000a8efac154d763,0x00001d9debc16dc9}},
    {{0x00063e677bca7881,0x000e37d394580513,0x00024e144be8d0ae,0x00028e4dbde8185b,0x000023188f4e65e5}, {0x0008b9cefe44eb7f,0x00022e76be281a4f,0x00062f74431f9f1a,0x00073701910bc8e4,0x00002e6f9dbd037a}},
    {{0x000c041cb73887ee,0x0009a3ce3a32704a,0x000393e75f878b61,0x00008c57ef73d556,0x00004372d2fb276c}, {0x000c8940924cf58a,0x000c4aa317e25d9b,0x000608da5fa2a4de,0x000960e51edccc79,0x0000dcc68fb2cd4b}},
},
{   /*digit=60 [{1,2,3,..,}]*([2^240]*G)  */
    {{0x0004f09a9e0eeaed,0x000f7b05a6569f15,0x00045b85d2246e6f,0x0004324d7c1c8110,0x0000e99ea38a3bb7}, {0x000818763184ff43,0x00020134bfc2d58f,0x0001203202a22342,0x000e9c1560dbed23,0x00007243c95a6a3d}},
    {{0x0006c8fe256b02b0,0x0003fa5946e09f11,0x00035452a7149569,0x00062eeb9696ffc3,0x00001ca592949711}, {0x0001f50c0f28e720,0x000c70d8df1aee0a,0x0009110f82baac62,0x00016acf65d297f4,0x000041dbb019a45e}},
    {{0x0009223d39e1ee45,0x000c9e3e6c2bd0b1,0x000a45c34c8832a2,0x00091b64a8f43da3,0x00002a05eef71fb2}, {0x000e24ae4b68e385,0x000b3e2d8a3fc0d3,0x0005b7da85289120,0x0004e133836b9842,0x0000bd418f4000c6}},
    {{0x0002241cedc2c975,0x000b7b632640e1a0,0x000fb588ff0f5489,0x0008e7b09091ddcb,0x0000ffd0f38ad947}, {0x00041a1dae35eda9,0x0006f2f0b26b83f1,0x0009dde18d25563a,0x000b3680014b171b,0x0000fcf8f820da49}},
    {{0x000380540096f25a,0x000e8c8201311e99,0x000993f9c900d4bd,0x0000072170cfd32a,0x00000e3d894cdfe1}, {0x0000b5a0e7df1098,0x000ac7fde3dce00d,0x00089816ac904985,0x000b9e15597a84cb,0x0000ac8b02839dfe}},
    {{0x000a4fdf7a2df835,0x000bb4524d444e3e,0x0006aee218b68b26,0x000e1c74caeeab12,0x000090a00a5e15d9}, {0x000a6ab49b90eff5,0x000e7df4fe510ae2,0x000fcb6ed74b4cb1,0x000b300306ed1107,0x000064ebe2ea02f5}},
    {{0x000a0c3c0a9d128d,0x00047ed0d3bce0f7,0x000e778e62adc34d,0x0006ba4ebf577813,0x00003b89bd18b847}, {0x000b52837413953c,0x000d98ba3471209e,0x000a79c09952b705,0x000b2acaa81ade86,0x000008eed3e3e0e7}},
    {{0x000c2bc9a8f42ff5,0x00009a1c0299dea0,0x0004dd41b6297424,0x0002495ee5f5f69e,0x0000b1bba807e110}, {0x000eadb78da80167,0x00008809f79eeac4,0x000f8c0dec297878,0x000ba939d2dbcee3,0x0000fb4b5fc764d3}},
},
{   /*digit=61 [{1,2,3,..,}]*([2^244]*G)  */
    {{0x000179c7f034ff4c,0x0009f781eac1a607,0x000022138efb8fcd,0x000039fa57f8a97b,0x00005bb9f1e16ab6}, {0x0007e24e4d2ab7f7,0x0001e7a9e3648902,0x0007f487d3d67ad7,0x000bd0c579e70c1f,0x0000fefc8949a7e6}},
    {{0x0001662a45cfd31b,0x0003c6f65cfd7cb9,0x000f3de5109dd56d,0x0004fc983e005d14,0x00009dc05b0d10f6}, {0x0000afd885eafe56,0x0003d444bdebc279,0x00087300abd5213d,0x000b76289dca9289,0x00009fb2ac313960}},
    {{0x0008bb43e4e99c48,0x0006f1f5ac02913a,0x00083f958b0c5fed,0x000eb65c5ccabdd7,0x0000d10225585a25}, {0x00075bc2701b5ef5,0x000f34ead28ab53b,0x000d37ba17cdfbb9,0x0007b8a111be6984,0x0000324f41a75991}},
    {{0x00048869ae7540fb,0x00021131e9213327,0x000a360c8d738663,0x0001e02e3d4fd8f2,0x000020a59b6ed9d4}, {0x0007eae99082a34c,0x000e1181946fb2b6,0x000d1d007fad6aa7,0x000ed07c299b9aa2,0x00001f841e14100b}},
    {{0x0008bf21619db767,0x000be5dbcdc6ba04,0x00053cfdca928899,0x00089daaf1e8f8a0,0x0000e49dcc581266}, {0x000001ccbf14e0ef,0x0002592029f13992,0x0002972a8aefbe02,0x000c66a3c0cc8691,0x00008495b3926f9a}},
    {{0x0007d4c43e90ebdf,0x00080fc72b063c1f,0x00094f40258b7810,0x0004b0da8503e1af,0x0000bb724b849f24}, {0x0002186fcd8755a4,0x000ec68482b6efcd,0x0009be3d57407cde,0x00002c4d62f57834,0x0000a0125451cc62}},
    {{0x00018c779f099ea8,0x0009290f6a520a5a,0x00025d678dfefc64,0x000de97c3b4cc277,0x0000d87ef5ce132b}, {0x000ee07a7023e899,0x000f309c8784c042,0x000c1268d9681a7d,0x0002c2fa00007a86,0x0000f76f114b2bf8}},
    {{0x00014d2151ffc085,0x0000c40d6b5568a4,0x000f472abaa79acf,0x000f1deeab0104cd,0x0000014a8c1f3aa5}, {0x000340533f134256,0x0009b7eb54d42c74,0x0008a723b2b776b4,0x00063a3a0cc4ac54,0x00005aae6f4279fe}},
},
{   /*digit=62 [{1,2,3,..,}]*([2^248]*G)  */
    {{0x0007ef9dfa782a41,0x000184cd95006944,0x00038f7626dadc8e,0x000a140574020edc,0x00007596d7ef2ee7}, {0x0005af79e1f8adc5,0x0006f4791da04ef7,0x0007b5d805ac5f21,0x0006cc1583226b7b,0x00009f3f053f21c2}},
    {{0x000abd049c879a59,0x0008347ac42e5e16,0x0009c2326844874a,0x00033bee3f8a203c,0x00009a120556eaed}, {0x000a15b63b333ae3,0x0005cd923fa01814,0x000b1b1efee9f28a,0x0009285b0cd25033,0x0000ccc39b9b346d}},
    {{0x0005e1d161e13e79,0x0001207e7068bb79,0x000522fe70f9abc2,0x00034efb3be61854,0x0000e2d0f37a9381}, {0x0007c36d292c6b0e,0x000da1e77894d8dc,0x0006c55f3bafbf59,0x0000877d0132cd1b,0x0000fa02edad609f}},
    {{0x0009359d93f6e1a6,0x00049d41c11898ea,0x000b641af729005d,0x000e784c2934107c,0x0000b2b4671e95e8}, {0x00051d05958fad35,0x000ec8619fe3da12,0x00011d318b69bc2b,0x000704d74df34cd9,0x0000def837865102}},
    {{0x00058678c673c89c,0x0006c99c7bae39ff,0x000b1e1b64925a04,0x00084f0b3bf59adb,0x00007e9d9f2f0ae0}, {0x00023960fa1776f5,0x000fb24c897b2098,0x0003534d5b2e1b98,0x000f63a9a6407d6c,0x0000e22319bf4dc3}},
    {{0x0006a2e916ef5271,0x0000393dc0853d90,0x00091da3eadeb94d,0x0002eb03a0780114,0x000077dceae1b84d}, {0x000a3c17b691e0c9,0x00086172cea2d1e5,0x000a76bce47d40bd,0x00035f7d0646ad8c,0x00000b030aa564d6}},
    {{0x00037b31f6e396ce,0x000f29a782f2d083,0x000c9b9746166b21,0x000d3d1ac6198b8e,0x0000e2e3446ebb44}, {0x000374035039dd98,0x0005a9f5c6925b28,0x000ddb4667c708f9,0x0003cf8914cce098,0x0000bb1b9f25446f}},
    {{0x00075c2a2c539e41,0x000db756daf9d315,0x000f55a120bac5dc,0x000299e917cecf91,0x0000e96433bf96f6}, {0x000c71c3700d8fb3,0x00060c9b4444bec7,0x00074f19c9a1d296,0x000d6b3d2c6970cf,0x0000b444c48dc5e0}},
},
{   /*digit=63 [{1,2,3,..,}]*([2^252]*G)  */
    {{0x000cefd8ccb854c3,0x000b95b0c45ab563,0x00037f743f5452cd,0x0004abb3c787699c,0x00004e9d192c5d44}, {0x000794652ff26b7c,0x000b5b94d6416934,0x000affb8f70d6ecf,0x000c717d201858fd,0x0000288719e05dcd}},
    {{0x000469d0728a2eb7,0x000f3433d11c5695,0x00006c08e7b46244,0x0000834a8b99baf1,0x0000989794fd3422}, {0x0008867d4fc5696b,0x0008ec79cdb7d221,0x0006d50496b021f2,0x0006285ff7bbeab2,0x000078611cb57261}},
    {{0x000f961531313d77,0x000bd6dcdc9dea75,0x00060e99185a1f4d,0x0007ccae3026b964,0x0000d467bef87ecf}, {0x000bf6705118708a,0x000993b2f1c8ea0d,0x000c0e4e054bfa36,0x00011ba9fc9d5cf2,0x00008c2ad11fe936}},
    {{0x000faf0aa1256bd2,0x0005be4631de1ef1,0x0009c26760f22454,0x000b2469cb9800de,0x00006019816b5782}, {0x000172ca66c0ccdc,0x000674407199d45c,0x0009f681a6c25f63,0x000df4917d5dbaa4,0x00000cad04872dc5}},
    {{0x000cf4c5960ef1c9,0x000e1c6979d5445b,0x0009090d6babcb16,0x0007288e3be750ae,0x0000481d2623c0eb}, {0x00036cd0d6a7d46e,0x0003ff97650066b4,0x000e1064f6eb1a6a,0x000c205984ffa2db,0x00006575fb2d809d}},
    {{0x0006d804d974a81a,0x000037a74be65042,0x00048653161304f1,0x00081a2346ff98a9,0x00001242ccb953d7}, {0x00003df97355f15a,0x00045d6058cea82f,0x000aefe28c607ed3,0x0007e403bc8cd468,0x00006e7de5b25130}},
    {{0x000df0fc6af7d445,0x0000015a9187dc07,0x000e15c2f310b252,0x000313d42661ced3,0x0000198fd906b4d8}, {0x00062cdda8368a13,0x00018e9c25424a60,0x000e37cee1a905d1,0x0004ca1d752b70da,0x0000ed8c1a546bf8}},
    {{0x000fb0feecc2f22b,0x0004198d8e5fa190,0x000f3ce723df210f,0x000fc6cce57d3af5,0x00002fb6223e12b8}, {0x000700571867c84a,0x000d5e139ebdd994,0x000e7944e141cd92,0x000058415efc9e5d,0x0000e9ee919e5821}},
},
{  /* digit=64 [{1,2,3,..,}]*([2^256]*G)  */
    {{0x0001a6a32f9eaf5b,0x00055cfc13dbbf7b,0x000b18adf2c440f9,0x00033f2cf39bc566,0x00009939fe94f015}, {0x0004553383a64506,0x000450102086a31c,0x0001f136016d96ad,0x000c08cbd6fa9550,0x000067d3ea0c5f96}},
    {{0x000c13ba12fdf41d,0x000c5224f5d1fa1f,0x000d5872bd798c04,0x000da822f4594e1d,0x0000ee12df5ebddf}, {0x0003ff0ed83420ad,0x00085daa27f3c647,0x000cefd8af41cf1c,0x00047f2772cd56ae,0x00005ddaf191902b}},
    {{0x0005abf53e86ae11,0x00004850830d88e0,0x0006bc33cc1dc4d9,0x00086fbd7fd806e0,0x0000ac330d6bcf12}, {0x0002303e1588c1e5,0x000b6b7e9c18d8ce,0x0007149f2dc25e54,0x000a2511e51e494b,0x000051b839205c7f}},
    {{0x0005ddf1510a406a,0x000569f0e98c83fc,0x0002843a0475a78f,0x0005a6b6d681c4e7,0x000090af2a4ea00c}, {0x0006d45a34f44127,0x000357f5d70325fc,0x00011092560f9c0e,0x0004d52bc0642bad,0x00009abfc112e24a}},
    {{0x000ee0691cf6cf09,0x0001b6b6bb14f844,0x000f77954e05b5ed,0x000619049c4bbcb7,0x0000d0f82198d94a}, {0x000e53617b8a0fde,0x000a78a163c77369,0x0004efcc52f1c014,0x000f9ea95975cd72,0x0000be1ab00c9aa9}},
    {{0x0000621245e20bef,0x0009134bbfc574fd,0x0007b3b6835a502d,0x0005cd40b56e370b,0x0000ca24ac75641f}, {0x00049d7102ae1815,0x00001fe146bde29a,0x0005146a8d2205d3,0x0009632a432de4b8,0x0000f90d9d766c61}},
    {{0x0004e18f143aa0fa,0x000641cf03d329bd,0x000345f4cf3894c5,0x00089dd25d055813,0x0000da5c0a11d580}, {0x000b9b65ddf3b293,0x0005e8afdfa60988,0x0006ebe1439c3438,0x000d381e3c991790,0x0000c9efd259ca95}},
    {{0x0009ce39b3d6844b,0x00093320f9bee042,0x0007dc2d2af562e9,0x0005ea5fbc2c5d71,0x00006fa79ff0722f}, {0x00070a079eea8d96,0x00019377e5ee65aa,0x000ad14cb624a2b9,0x000ac930ec06eaf7,0x00008d07bdd35640}},
},
};
/* clang-format on */

#endif /* #if (_MBX>=_MBX_K1) */

#endif /* IFMA_ECPRECOMP4_PSM2_H */
