// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SnapshotLoadParams snapshot load params
// swagger:model SnapshotLoadParams
type SnapshotLoadParams struct {

	// Enable support for incremental (diff) snapshots by tracking dirty guest pages.
	EnableDiffSnapshots bool `json:"enable_diff_snapshots,omitempty"`

	// Path to the file that contains the guest memory to be loaded.
	// Required: true
	MemFilePath *string `json:"mem_file_path"`

	// Path to the file that contains the microVM state to be loaded.
	// Required: true
	SnapshotPath *string `json:"snapshot_path"`
}

// Validate validates this snapshot load params
func (m *SnapshotLoadParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMemFilePath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPath(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotLoadParams) validateMemFilePath(formats strfmt.Registry) error {

	if err := validate.Required("mem_file_path", "body", m.MemFilePath); err != nil {
		return err
	}

	return nil
}

func (m *SnapshotLoadParams) validateSnapshotPath(formats strfmt.Registry) error {

	if err := validate.Required("snapshot_path", "body", m.SnapshotPath); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotLoadParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotLoadParams) UnmarshalBinary(b []byte) error {
	var res SnapshotLoadParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
