<!---
#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the Common Development
# and Distribution License Version 1.0 (the "License").
#
# You can obtain a copy of the license at
# http://www.opensource.org/licenses/CDDL-1.0.  See the License for the
# specific language governing permissions and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each file and
# include the License file in a prominent location with the name LICENSE.CDDL.
# If applicable, add the following below this CDDL HEADER, with the fields
# enclosed by brackets "[]" replaced with your own identifying information:
#
# Portions Copyright (c) [yyyy] [name of copyright owner]. All rights reserved.
#
# CDDL HEADER END
#

#
# Copyright (c) 2013--2020, Regents of the University of Minnesota.
# All rights reserved.
#
# Contributors:
#    Ryan S. Elliott
#    Ellad B. Tadmor
#

#
# Release: This file is part of the kim-api.git repository.
#
-->

[![Build Status](https://travis-ci.com/openkim/kim-api.svg?branch=devel)](https://travis-ci.com/openkim/kim-api)
[![Documentation Status](https://readthedocs.org/projects/kim-api/badge/?version=devel)](https://kim-api.readthedocs.io/en/devel/?badge=devel)
[![Coverity Scan](https://scan.coverity.com/projects/16411/badge.svg?flat=1)](https://scan.coverity.com/projects/openkim-kim-api)
[![codecov](https://codecov.io/gh/openkim/kim-api/branch/devel/graph/badge.svg)](https://codecov.io/gh/openkim/kim-api/branch/devel)

<p align="center"><h2>The KIM API package</h2></p>

<a href="https://repology.org/project/kim-api/versions"><img src="https://repology.org/badge/vertical-allrepos/kim-api.svg" alt="Packaging status" align="right" style="padding:5px;"/></a>

The KIM API package is a system-level library that aims to give computer
programmers the ability to write atomistic or molecular simulation programs
that can seamlessly interface with implementations of interatomic models,
regardless of the programming language (C, C++, Fortran, Python, etc.) in which
the codes are written.  It is part of the larger KIM project
(https://openkim.org).


Documentation
-------------

[Full documentation](https://kim-api.readthedocs.io/en/devel) is available online via [readthedocs.org](https://readthedocs.org)


Download
--------

All official release archives of the KIM API package can be downloaded from:

[https://openkim.org/kim-api/previous-versions](https://openkim.org/kim-api/previous-versions)

Release notes are available in the [NEWS](NEWS) file.


Installation
------------

See the [INSTALL](INSTALL) file for instructions on how to build and install
the package and its documentation.


Contributing
------------

Just send us a [pull request](https://help.github.com/articles/using-pull-requests/).
When you send your request, make `devel` the destination branch on the
[kim-api repository](https://github.com/openkim/kim-api).

Please see the [README_GIT](README_GIT) file for some additional details.


Issues, bugs, requests, ideas
-----------------------------

Use the [issues](https://github.com/openkim/kim-api/issues) tracker to report
bugs.


License
-------

The KIM API is distributed under the terms of the Common Development and
Distribution License (CDDL) Version 1.0.

All new contributions must be made under this license.

See [LICENSE.CDDL](LICENSE.CDDL) and
[http://opensource.org/licenses/CDDL-1.0](http://opensource.org/licenses/CDDL-1.0)
for details.


*******************************************************************************

SUPPORT

Support is always available by posting questions with all relevant information
to

<https://matsci.org/openkim>

Members of the OpenKIM development team actively monitor this forum and
will do their best to respond to questions in a timely fashion.

*******************************************************************************
