/*
 * =======================================================================================
 *
 *      Filename:  perfmon_graniterapids_counters.h
 *
 *      Description:  Counter Header File of perfmon module for Intel Granite Rapids.
 *
 *      Version:   5.4.1
 *      Released:  09.12.2024
 *
 *      Author:   Thomas Gruber (tr), thomas.roehl@googlemail.com
 *      Project:  likwid
 *
 *      Copyright (C) 2024 RRZE, University Erlangen-Nuremberg
 *
 *      This program is free software: you can redistribute it and/or modify it under
 *      the terms of the GNU General Public License as published by the Free Software
 *      Foundation, either version 3 of the License, or (at your option) any later
 *      version.
 *
 *      This program is distributed in the hope that it will be useful, but WITHOUT ANY
 *      WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 *      PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along with
 *      this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * =======================================================================================
 */

#include <intel_perfmon_uncore_discovery.h>

#define NUM_COUNTERS_GRANITERAPIDS 1169
#define NUM_COUNTERS_CORE_GRANITERAPIDS 22
#define NUM_COUNTERS_UNCORE_GRANITERAPIDS 5


#define GNR_VALID_OPTIONS_FIXED EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_COUNT_KERNEL_MASK
#define GNR_VALID_OPTIONS_PMC EVENT_OPTION_EDGE_MASK|EVENT_OPTION_COUNT_KERNEL_MASK|EVENT_OPTION_INVERT_MASK| \
            EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_IN_TRANS_MASK|EVENT_OPTION_THRESHOLD_MASK

#define GNR_VALID_OPTIONS_CBOX  EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|\
                                EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_TID_MASK
#define GNR_VALID_OPTIONS_UNCORE EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|\
                                 EVENT_OPTION_THRESHOLD_MASK


static RegisterMap graniterapids_counter_map[NUM_COUNTERS_GRANITERAPIDS] = {
    /* Fixed Counters: instructions retired, cycles unhalted core */
    {"FIXC0", PMC0, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR0, 0, MSR_DEV, GNR_VALID_OPTIONS_FIXED},
    {"FIXC1", PMC1, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR1, 0, MSR_DEV, GNR_VALID_OPTIONS_FIXED},
    {"FIXC2", PMC2, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR2, 0, MSR_DEV, GNR_VALID_OPTIONS_FIXED},
    {"FIXC3", PMC3, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR3, 0, MSR_DEV, GNR_VALID_OPTIONS_FIXED},
    /* PMC Counters: 4 48bit wide */
    {"PMC0", PMC4, PMC, MSR_PERFEVTSEL0, MSR_PMC0, 0, MSR_DEV, GNR_VALID_OPTIONS_PMC},
    {"PMC1", PMC5, PMC, MSR_PERFEVTSEL1, MSR_PMC1, 0, MSR_DEV, GNR_VALID_OPTIONS_PMC},
    {"PMC2", PMC6, PMC, MSR_PERFEVTSEL2, MSR_PMC2, 0, MSR_DEV, GNR_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC3", PMC7, PMC, MSR_PERFEVTSEL3, MSR_PMC3, 0, MSR_DEV, GNR_VALID_OPTIONS_PMC},
    /* Additional PMC Counters if HyperThreading is not active: 4 48bit wide */
    {"PMC4", PMC8, PMC, MSR_PERFEVTSEL4, MSR_PMC4, 0, MSR_DEV, GNR_VALID_OPTIONS_PMC},
    {"PMC5", PMC9, PMC, MSR_PERFEVTSEL5, MSR_PMC5, 0, MSR_DEV, GNR_VALID_OPTIONS_PMC},
    {"PMC6", PMC10, PMC, MSR_PERFEVTSEL6, MSR_PMC6, 0, MSR_DEV, GNR_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC7", PMC11, PMC, MSR_PERFEVTSEL7, MSR_PMC7, 0, MSR_DEV, GNR_VALID_OPTIONS_PMC},
    /* Temperature Sensor*/
    {"TMP0", PMC12, THERMAL, 0, IA32_THERM_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Vcore Status*/
    {"VTG0", PMC13, VOLTAGE, 0, MSR_PERF_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Intel Performance Metrics */
    {"TMA0", PMC14, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA1", PMC15, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA2", PMC16, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA3", PMC17, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA4", PMC18, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA5", PMC19, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA6", PMC20, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA7", PMC21, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    /* RAPL counters */
    {"PWR0", PMC22, POWER, 0, MSR_PKG_ENERGY_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR1", PMC23, POWER, 0, MSR_PP0_ENERGY_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR2", PMC24, POWER, 0, MSR_PP1_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR3", PMC25, POWER, 0, MSR_DRAM_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR4", PMC26, POWER, 0, MSR_PLATFORM_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"CBOX0C0", PMC27, CBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C0, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX0C1", PMC28, CBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C0, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX0C2", PMC29, CBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C0, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX0C3", PMC30, CBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C0, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX1C0", PMC31, CBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C1, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX1C1", PMC32, CBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C1, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX1C2", PMC33, CBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C1, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX1C3", PMC34, CBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C1, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX2C0", PMC35, CBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C2, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX2C1", PMC36, CBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C2, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX2C2", PMC37, CBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C2, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX2C3", PMC38, CBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C2, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX3C0", PMC39, CBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C3, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX3C1", PMC40, CBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C3, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX3C2", PMC41, CBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C3, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX3C3", PMC42, CBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C3, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX4C0", PMC43, CBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C4, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX4C1", PMC44, CBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C4, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX4C2", PMC45, CBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C4, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX4C3", PMC46, CBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C4, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX5C0", PMC47, CBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C5, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX5C1", PMC48, CBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C5, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX5C2", PMC49, CBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C5, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX5C3", PMC50, CBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C5, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX6C0", PMC51, CBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C6, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX6C1", PMC52, CBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C6, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX6C2", PMC53, CBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C6, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX6C3", PMC54, CBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C6, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX7C0", PMC55, CBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C7, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX7C1", PMC56, CBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C7, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX7C2", PMC57, CBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C7, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX7C3", PMC58, CBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C7, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX8C0", PMC59, CBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C8, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX8C1", PMC60, CBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C8, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX8C2", PMC61, CBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C8, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX8C3", PMC62, CBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C8, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX9C0", PMC63, CBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C9, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX9C1", PMC64, CBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C9, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX9C2", PMC65, CBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C9, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX9C3", PMC66, CBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C9, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX10C0", PMC67, CBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C10, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX10C1", PMC68, CBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C10, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX10C2", PMC69, CBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C10, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX10C3", PMC70, CBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C10, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX11C0", PMC71, CBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C11, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX11C1", PMC72, CBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C11, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX11C2", PMC73, CBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C11, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX11C3", PMC74, CBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C11, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX12C0", PMC75, CBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C12, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX12C1", PMC76, CBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C12, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX12C2", PMC77, CBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C12, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX12C3", PMC78, CBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C12, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX13C0", PMC79, CBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C13, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX13C1", PMC80, CBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C13, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX13C2", PMC81, CBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C13, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX13C3", PMC82, CBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C13, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX14C0", PMC83, CBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C14, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX14C1", PMC84, CBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C14, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX14C2", PMC85, CBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C14, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX14C3", PMC86, CBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C14, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX15C0", PMC87, CBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C15, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX15C1", PMC88, CBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C15, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX15C2", PMC89, CBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C15, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX15C3", PMC90, CBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C15, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX16C0", PMC91, CBOX16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C16, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX16C1", PMC92, CBOX16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C16, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX16C2", PMC93, CBOX16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C16, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX16C3", PMC94, CBOX16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C16, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX17C0", PMC95, CBOX17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C17, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX17C1", PMC96, CBOX17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C17, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX17C2", PMC97, CBOX17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C17, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX17C3", PMC98, CBOX17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C17, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX18C0", PMC99, CBOX18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C18, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX18C1", PMC100, CBOX18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C18, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX18C2", PMC101, CBOX18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C18, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX18C3", PMC102, CBOX18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C18, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX19C0", PMC103, CBOX19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C19, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX19C1", PMC104, CBOX19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C19, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX19C2", PMC105, CBOX19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C19, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX19C3", PMC106, CBOX19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C19, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX20C0", PMC107, CBOX20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C20, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX20C1", PMC108, CBOX20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C20, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX20C2", PMC109, CBOX20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C20, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX20C3", PMC110, CBOX20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C20, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX21C0", PMC111, CBOX21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C21, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX21C1", PMC112, CBOX21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C21, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX21C2", PMC113, CBOX21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C21, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX21C3", PMC114, CBOX21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C21, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX22C0", PMC115, CBOX22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C22, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX22C1", PMC116, CBOX22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C22, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX22C2", PMC117, CBOX22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C22, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX22C3", PMC118, CBOX22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C22, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX23C0", PMC119, CBOX23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C23, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX23C1", PMC120, CBOX23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C23, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX23C2", PMC121, CBOX23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C23, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX23C3", PMC122, CBOX23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C23, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX24C0", PMC123, CBOX24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C24, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX24C1", PMC124, CBOX24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C24, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX24C2", PMC125, CBOX24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C24, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX24C3", PMC126, CBOX24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C24, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX25C0", PMC127, CBOX25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C25, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX25C1", PMC128, CBOX25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C25, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX25C2", PMC129, CBOX25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C25, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX25C3", PMC130, CBOX25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C25, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX26C0", PMC131, CBOX26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C26, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX26C1", PMC132, CBOX26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C26, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX26C2", PMC133, CBOX26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C26, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX26C3", PMC134, CBOX26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C26, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX27C0", PMC135, CBOX27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C27, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX27C1", PMC136, CBOX27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C27, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX27C2", PMC137, CBOX27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C27, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX27C3", PMC138, CBOX27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C27, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX28C0", PMC139, CBOX28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C28, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX28C1", PMC140, CBOX28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C28, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX28C2", PMC141, CBOX28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C28, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX28C3", PMC142, CBOX28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C28, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX29C0", PMC143, CBOX29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C29, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX29C1", PMC144, CBOX29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C29, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX29C2", PMC145, CBOX29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C29, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX29C3", PMC146, CBOX29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C29, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX30C0", PMC147, CBOX30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C30, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX30C1", PMC148, CBOX30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C30, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX30C2", PMC149, CBOX30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C30, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX30C3", PMC150, CBOX30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C30, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX31C0", PMC151, CBOX31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C31, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX31C1", PMC152, CBOX31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C31, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX31C2", PMC153, CBOX31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C31, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX31C3", PMC154, CBOX31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C31, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX32C0", PMC155, CBOX32, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C32, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX32C1", PMC156, CBOX32, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C32, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX32C2", PMC157, CBOX32, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C32, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX32C3", PMC158, CBOX32, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C32, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX33C0", PMC159, CBOX33, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C33, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX33C1", PMC160, CBOX33, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C33, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX33C2", PMC161, CBOX33, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C33, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX33C3", PMC162, CBOX33, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C33, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX34C0", PMC163, CBOX34, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C34, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX34C1", PMC164, CBOX34, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C34, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX34C2", PMC165, CBOX34, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C34, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX34C3", PMC166, CBOX34, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C34, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX35C0", PMC167, CBOX35, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C35, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX35C1", PMC168, CBOX35, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C35, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX35C2", PMC169, CBOX35, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C35, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX35C3", PMC170, CBOX35, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C35, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX36C0", PMC171, CBOX36, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C36, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX36C1", PMC172, CBOX36, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C36, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX36C2", PMC173, CBOX36, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C36, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX36C3", PMC174, CBOX36, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C36, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX37C0", PMC175, CBOX37, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C37, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX37C1", PMC176, CBOX37, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C37, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX37C2", PMC177, CBOX37, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C37, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX37C3", PMC178, CBOX37, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C37, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX38C0", PMC179, CBOX38, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C38, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX38C1", PMC180, CBOX38, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C38, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX38C2", PMC181, CBOX38, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C38, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX38C3", PMC182, CBOX38, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C38, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX39C0", PMC183, CBOX39, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C39, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX39C1", PMC184, CBOX39, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C39, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX39C2", PMC185, CBOX39, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C39, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX39C3", PMC186, CBOX39, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C39, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX40C0", PMC187, CBOX40, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C40, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX40C1", PMC188, CBOX40, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C40, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX40C2", PMC189, CBOX40, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C40, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX40C3", PMC190, CBOX40, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C40, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX41C0", PMC191, CBOX41, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C41, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX41C1", PMC192, CBOX41, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C41, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX41C2", PMC193, CBOX41, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C41, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX41C3", PMC194, CBOX41, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C41, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX42C0", PMC195, CBOX42, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C42, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX42C1", PMC196, CBOX42, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C42, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX42C2", PMC197, CBOX42, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C42, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX42C3", PMC198, CBOX42, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C42, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX43C0", PMC199, CBOX43, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C43, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX43C1", PMC200, CBOX43, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C43, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX43C2", PMC201, CBOX43, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C43, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX43C3", PMC202, CBOX43, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C43, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX44C0", PMC203, CBOX44, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C44, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX44C1", PMC204, CBOX44, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C44, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX44C2", PMC205, CBOX44, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C44, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX44C3", PMC206, CBOX44, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C44, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX45C0", PMC207, CBOX45, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C45, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX45C1", PMC208, CBOX45, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C45, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX45C2", PMC209, CBOX45, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C45, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX45C3", PMC210, CBOX45, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C45, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX46C0", PMC211, CBOX46, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C46, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX46C1", PMC212, CBOX46, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C46, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX46C2", PMC213, CBOX46, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C46, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX46C3", PMC214, CBOX46, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C46, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX47C0", PMC215, CBOX47, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C47, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX47C1", PMC216, CBOX47, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C47, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX47C2", PMC217, CBOX47, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C47, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX47C3", PMC218, CBOX47, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C47, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX48C0", PMC219, CBOX48, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C48, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX48C1", PMC220, CBOX48, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C48, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX48C2", PMC221, CBOX48, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C48, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX48C3", PMC222, CBOX48, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C48, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX49C0", PMC223, CBOX49, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C49, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX49C1", PMC224, CBOX49, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C49, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX49C2", PMC225, CBOX49, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C49, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX49C3", PMC226, CBOX49, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C49, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX50C0", PMC227, CBOX50, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C50, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX50C1", PMC228, CBOX50, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C50, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX50C2", PMC229, CBOX50, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C50, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX50C3", PMC230, CBOX50, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C50, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX51C0", PMC231, CBOX51, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C51, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX51C1", PMC232, CBOX51, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C51, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX51C2", PMC233, CBOX51, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C51, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX51C3", PMC234, CBOX51, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C51, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX52C0", PMC235, CBOX52, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C52, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX52C1", PMC236, CBOX52, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C52, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX52C2", PMC237, CBOX52, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C52, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX52C3", PMC238, CBOX52, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C52, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX53C0", PMC239, CBOX53, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C53, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX53C1", PMC240, CBOX53, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C53, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX53C2", PMC241, CBOX53, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C53, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX53C3", PMC242, CBOX53, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C53, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX54C0", PMC243, CBOX54, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C54, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX54C1", PMC244, CBOX54, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C54, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX54C2", PMC245, CBOX54, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C54, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX54C3", PMC246, CBOX54, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C54, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX55C0", PMC247, CBOX55, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C55, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX55C1", PMC248, CBOX55, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C55, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX55C2", PMC249, CBOX55, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C55, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX55C3", PMC250, CBOX55, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C55, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX56C0", PMC251, CBOX56, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C56, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX56C1", PMC252, CBOX56, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C56, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX56C2", PMC253, CBOX56, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C56, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX56C3", PMC254, CBOX56, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C56, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX57C0", PMC255, CBOX57, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C57, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX57C1", PMC256, CBOX57, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C57, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX57C2", PMC257, CBOX57, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C57, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX57C3", PMC258, CBOX57, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C57, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX58C0", PMC259, CBOX58, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C58, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX58C1", PMC260, CBOX58, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C58, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX58C2", PMC261, CBOX58, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C58, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX58C3", PMC262, CBOX58, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C58, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX59C0", PMC263, CBOX59, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C59, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX59C1", PMC264, CBOX59, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C59, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX59C2", PMC265, CBOX59, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C59, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX59C3", PMC266, CBOX59, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C59, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX60C0", PMC267, CBOX60, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C60, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX60C1", PMC268, CBOX60, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C60, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX60C2", PMC269, CBOX60, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C60, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX60C3", PMC270, CBOX60, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C60, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX61C0", PMC271, CBOX61, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C61, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX61C1", PMC272, CBOX61, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C61, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX61C2", PMC273, CBOX61, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C61, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX61C3", PMC274, CBOX61, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C61, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX62C0", PMC275, CBOX62, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C62, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX62C1", PMC276, CBOX62, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C62, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX62C2", PMC277, CBOX62, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C62, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX62C3", PMC278, CBOX62, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C62, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX63C0", PMC279, CBOX63, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C63, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX63C1", PMC280, CBOX63, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C63, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX63C2", PMC281, CBOX63, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C63, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX63C3", PMC282, CBOX63, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C63, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX64C0", PMC283, CBOX64, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C64, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX64C1", PMC284, CBOX64, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C64, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX64C2", PMC285, CBOX64, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C64, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX64C3", PMC286, CBOX64, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C64, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX65C0", PMC287, CBOX65, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C65, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX65C1", PMC288, CBOX65, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C65, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX65C2", PMC289, CBOX65, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C65, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX65C3", PMC290, CBOX65, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C65, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX66C0", PMC291, CBOX66, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C66, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX66C1", PMC292, CBOX66, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C66, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX66C2", PMC293, CBOX66, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C66, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX66C3", PMC294, CBOX66, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C66, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX67C0", PMC295, CBOX67, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C67, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX67C1", PMC296, CBOX67, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C67, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX67C2", PMC297, CBOX67, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C67, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX67C3", PMC298, CBOX67, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C67, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX68C0", PMC299, CBOX68, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C68, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX68C1", PMC300, CBOX68, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C68, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX68C2", PMC301, CBOX68, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C68, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX68C3", PMC302, CBOX68, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C68, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX69C0", PMC303, CBOX69, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C69, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX69C1", PMC304, CBOX69, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C69, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX69C2", PMC305, CBOX69, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C69, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX69C3", PMC306, CBOX69, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C69, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX70C0", PMC307, CBOX70, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C70, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX70C1", PMC308, CBOX70, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C70, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX70C2", PMC309, CBOX70, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C70, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX70C3", PMC310, CBOX70, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C70, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX71C0", PMC311, CBOX71, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C71, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX71C1", PMC312, CBOX71, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C71, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX71C2", PMC313, CBOX71, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C71, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX71C3", PMC314, CBOX71, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C71, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX72C0", PMC315, CBOX72, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C72, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX72C1", PMC316, CBOX72, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C72, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX72C2", PMC317, CBOX72, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C72, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX72C3", PMC318, CBOX72, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C72, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX73C0", PMC319, CBOX73, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C73, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX73C1", PMC320, CBOX73, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C73, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX73C2", PMC321, CBOX73, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C73, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX73C3", PMC322, CBOX73, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C73, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX74C0", PMC323, CBOX74, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C74, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX74C1", PMC324, CBOX74, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C74, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX74C2", PMC325, CBOX74, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C74, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX74C3", PMC326, CBOX74, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C74, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX75C0", PMC327, CBOX75, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C75, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX75C1", PMC328, CBOX75, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C75, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX75C2", PMC329, CBOX75, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C75, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX75C3", PMC330, CBOX75, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C75, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX76C0", PMC331, CBOX76, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C76, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX76C1", PMC332, CBOX76, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C76, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX76C2", PMC333, CBOX76, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C76, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX76C3", PMC334, CBOX76, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C76, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX77C0", PMC335, CBOX77, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C77, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX77C1", PMC336, CBOX77, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C77, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX77C2", PMC337, CBOX77, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C77, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX77C3", PMC338, CBOX77, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C77, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX78C0", PMC339, CBOX78, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C78, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX78C1", PMC340, CBOX78, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C78, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX78C2", PMC341, CBOX78, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C78, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX78C3", PMC342, CBOX78, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C78, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX79C0", PMC343, CBOX79, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C79, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX79C1", PMC344, CBOX79, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C79, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX79C2", PMC345, CBOX79, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C79, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX79C3", PMC346, CBOX79, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C79, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX80C0", PMC347, CBOX80, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C80, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX80C1", PMC348, CBOX80, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C80, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX80C2", PMC349, CBOX80, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C80, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX80C3", PMC350, CBOX80, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C80, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX81C0", PMC351, CBOX81, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C81, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX81C1", PMC352, CBOX81, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C81, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX81C2", PMC353, CBOX81, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C81, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX81C3", PMC354, CBOX81, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C81, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX82C0", PMC355, CBOX82, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C82, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX82C1", PMC356, CBOX82, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C82, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX82C2", PMC357, CBOX82, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C82, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX82C3", PMC358, CBOX82, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C82, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX83C0", PMC359, CBOX83, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C83, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX83C1", PMC360, CBOX83, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C83, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX83C2", PMC361, CBOX83, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C83, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX83C3", PMC362, CBOX83, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C83, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX84C0", PMC363, CBOX84, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C84, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX84C1", PMC364, CBOX84, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C84, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX84C2", PMC365, CBOX84, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C84, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX84C3", PMC366, CBOX84, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C84, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX85C0", PMC367, CBOX85, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C85, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX85C1", PMC368, CBOX85, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C85, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX85C2", PMC369, CBOX85, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C85, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX85C3", PMC370, CBOX85, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C85, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX86C0", PMC371, CBOX86, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C86, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX86C1", PMC372, CBOX86, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C86, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX86C2", PMC373, CBOX86, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C86, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX86C3", PMC374, CBOX86, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C86, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX87C0", PMC375, CBOX87, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C87, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX87C1", PMC376, CBOX87, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C87, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX87C2", PMC377, CBOX87, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C87, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX87C3", PMC378, CBOX87, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C87, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX88C0", PMC379, CBOX88, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C88, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX88C1", PMC380, CBOX88, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C88, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX88C2", PMC381, CBOX88, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C88, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX88C3", PMC382, CBOX88, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C88, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX89C0", PMC383, CBOX89, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C89, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX89C1", PMC384, CBOX89, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C89, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX89C2", PMC385, CBOX89, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C89, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX89C3", PMC386, CBOX89, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C89, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX90C0", PMC387, CBOX90, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C90, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX90C1", PMC388, CBOX90, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C90, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX90C2", PMC389, CBOX90, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C90, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX90C3", PMC390, CBOX90, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C90, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX91C0", PMC391, CBOX91, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C91, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX91C1", PMC392, CBOX91, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C91, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX91C2", PMC393, CBOX91, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C91, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX91C3", PMC394, CBOX91, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C91, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX92C0", PMC395, CBOX92, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C92, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX92C1", PMC396, CBOX92, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C92, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX92C2", PMC397, CBOX92, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C92, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX92C3", PMC398, CBOX92, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C92, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX93C0", PMC399, CBOX93, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C93, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX93C1", PMC400, CBOX93, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C93, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX93C2", PMC401, CBOX93, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C93, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX93C3", PMC402, CBOX93, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C93, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX94C0", PMC403, CBOX94, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C94, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX94C1", PMC404, CBOX94, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C94, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX94C2", PMC405, CBOX94, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C94, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX94C3", PMC406, CBOX94, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C94, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX95C0", PMC407, CBOX95, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C95, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX95C1", PMC408, CBOX95, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C95, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX95C2", PMC409, CBOX95, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C95, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX95C3", PMC410, CBOX95, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C95, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX96C0", PMC411, CBOX96, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C96, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX96C1", PMC412, CBOX96, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C96, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX96C2", PMC413, CBOX96, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C96, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX96C3", PMC414, CBOX96, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C96, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX97C0", PMC415, CBOX97, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C97, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX97C1", PMC416, CBOX97, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C97, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX97C2", PMC417, CBOX97, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C97, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX97C3", PMC418, CBOX97, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C97, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX98C0", PMC419, CBOX98, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C98, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX98C1", PMC420, CBOX98, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C98, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX98C2", PMC421, CBOX98, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C98, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX98C3", PMC422, CBOX98, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C98, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX99C0", PMC423, CBOX99, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C99, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX99C1", PMC424, CBOX99, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C99, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX99C2", PMC425, CBOX99, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C99, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX99C3", PMC426, CBOX99, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C99, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX100C0", PMC427, CBOX100, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C100, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX100C1", PMC428, CBOX100, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C100, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX100C2", PMC429, CBOX100, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C100, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX100C3", PMC430, CBOX100, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C100, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX101C0", PMC431, CBOX101, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C101, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX101C1", PMC432, CBOX101, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C101, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX101C2", PMC433, CBOX101, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C101, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX101C3", PMC434, CBOX101, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C101, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX102C0", PMC435, CBOX102, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C102, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX102C1", PMC436, CBOX102, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C102, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX102C2", PMC437, CBOX102, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C102, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX102C3", PMC438, CBOX102, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C102, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX103C0", PMC439, CBOX103, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C103, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX103C1", PMC440, CBOX103, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C103, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX103C2", PMC441, CBOX103, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C103, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX103C3", PMC442, CBOX103, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C103, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX104C0", PMC443, CBOX104, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C104, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX104C1", PMC444, CBOX104, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C104, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX104C2", PMC445, CBOX104, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C104, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX104C3", PMC446, CBOX104, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C104, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX105C0", PMC447, CBOX105, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C105, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX105C1", PMC448, CBOX105, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C105, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX105C2", PMC449, CBOX105, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C105, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX105C3", PMC450, CBOX105, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C105, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX106C0", PMC451, CBOX106, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C106, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX106C1", PMC452, CBOX106, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C106, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX106C2", PMC453, CBOX106, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C106, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX106C3", PMC454, CBOX106, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C106, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX107C0", PMC455, CBOX107, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C107, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX107C1", PMC456, CBOX107, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C107, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX107C2", PMC457, CBOX107, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C107, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX107C3", PMC458, CBOX107, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C107, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX108C0", PMC459, CBOX108, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C108, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX108C1", PMC460, CBOX108, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C108, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX108C2", PMC461, CBOX108, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C108, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX108C3", PMC462, CBOX108, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C108, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX109C0", PMC463, CBOX109, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C109, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX109C1", PMC464, CBOX109, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C109, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX109C2", PMC465, CBOX109, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C109, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX109C3", PMC466, CBOX109, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C109, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX110C0", PMC467, CBOX110, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C110, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX110C1", PMC468, CBOX110, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C110, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX110C2", PMC469, CBOX110, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C110, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX110C3", PMC470, CBOX110, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C110, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX111C0", PMC471, CBOX111, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C111, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX111C1", PMC472, CBOX111, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C111, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX111C2", PMC473, CBOX111, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C111, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX111C3", PMC474, CBOX111, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C111, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX112C0", PMC475, CBOX112, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C112, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX112C1", PMC476, CBOX112, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C112, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX112C2", PMC477, CBOX112, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C112, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX112C3", PMC478, CBOX112, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C112, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX113C0", PMC479, CBOX113, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C113, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX113C1", PMC480, CBOX113, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C113, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX113C2", PMC481, CBOX113, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C113, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX113C3", PMC482, CBOX113, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C113, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX114C0", PMC483, CBOX114, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C114, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX114C1", PMC484, CBOX114, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C114, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX114C2", PMC485, CBOX114, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C114, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX114C3", PMC486, CBOX114, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C114, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX115C0", PMC487, CBOX115, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C115, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX115C1", PMC488, CBOX115, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C115, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX115C2", PMC489, CBOX115, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C115, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX115C3", PMC490, CBOX115, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C115, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX116C0", PMC491, CBOX116, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C116, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX116C1", PMC492, CBOX116, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C116, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX116C2", PMC493, CBOX116, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C116, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX116C3", PMC494, CBOX116, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C116, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX117C0", PMC495, CBOX117, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C117, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX117C1", PMC496, CBOX117, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C117, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX117C2", PMC497, CBOX117, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C117, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX117C3", PMC498, CBOX117, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C117, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX118C0", PMC499, CBOX118, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C118, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX118C1", PMC500, CBOX118, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C118, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX118C2", PMC501, CBOX118, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C118, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX118C3", PMC502, CBOX118, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C118, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX119C0", PMC503, CBOX119, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C119, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX119C1", PMC504, CBOX119, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C119, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX119C2", PMC505, CBOX119, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C119, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX119C3", PMC506, CBOX119, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C119, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX120C0", PMC507, CBOX120, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C120, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX120C1", PMC508, CBOX120, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C120, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX120C2", PMC509, CBOX120, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C120, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX120C3", PMC510, CBOX120, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C120, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX121C0", PMC511, CBOX121, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C121, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX121C1", PMC512, CBOX121, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C121, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX121C2", PMC513, CBOX121, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C121, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX121C3", PMC514, CBOX121, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C121, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX122C0", PMC515, CBOX122, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C122, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX122C1", PMC516, CBOX122, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C122, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX122C2", PMC517, CBOX122, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C122, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX122C3", PMC518, CBOX122, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C122, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX123C0", PMC519, CBOX123, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C123, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX123C1", PMC520, CBOX123, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C123, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX123C2", PMC521, CBOX123, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C123, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX123C3", PMC522, CBOX123, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C123, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX124C0", PMC523, CBOX124, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C124, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX124C1", PMC524, CBOX124, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C124, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX124C2", PMC525, CBOX124, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C124, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX124C3", PMC526, CBOX124, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C124, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX125C0", PMC527, CBOX125, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C125, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX125C1", PMC528, CBOX125, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C125, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX125C2", PMC529, CBOX125, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C125, GNR_VALID_OPTIONS_UNCORE},
    {"CBOX125C3", PMC530, CBOX125, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C125, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX0C0", PMC531, MBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_0, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX0C1", PMC532, MBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_0, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX0C2", PMC533, MBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_0, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX0C3", PMC534, MBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_0, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX1C0", PMC535, MBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_1, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX1C1", PMC536, MBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_1, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX1C2", PMC537, MBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_1, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX1C3", PMC538, MBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_1, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX2C0", PMC539, MBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_2, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX2C1", PMC540, MBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_2, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX2C2", PMC541, MBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_2, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX2C3", PMC542, MBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_2, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX3C0", PMC543, MBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_3, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX3C1", PMC544, MBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_3, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX3C2", PMC545, MBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_3, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX3C3", PMC546, MBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_3, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX4C0", PMC547, MBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_4, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX4C1", PMC548, MBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_4, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX4C2", PMC549, MBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_4, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX4C3", PMC550, MBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_4, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX5C0", PMC551, MBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_5, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX5C1", PMC552, MBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_5, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX5C2", PMC553, MBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_5, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX5C3", PMC554, MBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_5, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX6C0", PMC555, MBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_6, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX6C1", PMC556, MBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_6, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX6C2", PMC557, MBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_6, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX6C3", PMC558, MBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_6, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX7C0", PMC559, MBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_7, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX7C1", PMC560, MBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_7, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX7C2", PMC561, MBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_7, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX7C3", PMC562, MBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_7, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX8C0", PMC563, MBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_0, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX8C1", PMC564, MBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_0, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX8C2", PMC565, MBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_0, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX8C3", PMC566, MBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_0, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX9C0", PMC567, MBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_1, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX9C1", PMC568, MBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_1, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX9C2", PMC569, MBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_1, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX9C3", PMC570, MBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_1, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX10C0", PMC571, MBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_2, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX10C1", PMC572, MBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_2, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX10C2", PMC573, MBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_2, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX10C3", PMC574, MBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_2, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX11C0", PMC575, MBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_3, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX11C1", PMC576, MBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_3, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX11C2", PMC577, MBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_3, GNR_VALID_OPTIONS_UNCORE},
    {"MBOX11C3", PMC578, MBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_3, GNR_VALID_OPTIONS_UNCORE},
    {"PCU0C0", PMC579, WBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_PCU_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"PCU0C1", PMC580, WBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_PCU_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"PCU0C2", PMC581, WBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_PCU_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"PCU0C3", PMC582, WBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_PCU_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"PCU1C0", PMC583, WBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_PCU_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"PCU1C1", PMC584, WBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_PCU_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"PCU1C2", PMC585, WBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_PCU_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"PCU1C3", PMC586, WBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_PCU_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"PCU2C0", PMC587, WBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_PCU_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"PCU2C1", PMC588, WBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_PCU_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"PCU2C2", PMC589, WBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_PCU_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"PCU2C3", PMC590, WBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_PCU_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"PCU3C0", PMC591, WBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_PCU_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"PCU3C1", PMC592, WBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_PCU_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"PCU3C2", PMC593, WBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_PCU_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"PCU3C3", PMC594, WBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_PCU_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"PCU4C0", PMC595, WBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_PCU_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"PCU4C1", PMC596, WBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_PCU_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"PCU4C2", PMC597, WBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_PCU_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"PCU4C3", PMC598, WBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_PCU_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IRP0C0", PMC599, IRP0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"IRP0C1", PMC600, IRP0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"IRP0C2", PMC601, IRP0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"IRP0C3", PMC602, IRP0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"IRP1C0", PMC603, IRP1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"IRP1C1", PMC604, IRP1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"IRP1C2", PMC605, IRP1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"IRP1C3", PMC606, IRP1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"IRP2C0", PMC607, IRP2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"IRP2C1", PMC608, IRP2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"IRP2C2", PMC609, IRP2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"IRP2C3", PMC610, IRP2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"IRP3C0", PMC611, IRP3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"IRP3C1", PMC612, IRP3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"IRP3C2", PMC613, IRP3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"IRP3C3", PMC614, IRP3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"IRP4C0", PMC615, IRP4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IRP4C1", PMC616, IRP4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IRP4C2", PMC617, IRP4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IRP4C3", PMC618, IRP4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IRP5C0", PMC619, IRP5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"IRP5C1", PMC620, IRP5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"IRP5C2", PMC621, IRP5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"IRP5C3", PMC622, IRP5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"IRP6C0", PMC623, IRP6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"IRP6C1", PMC624, IRP6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"IRP6C2", PMC625, IRP6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"IRP6C3", PMC626, IRP6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"IRP7C0", PMC627, IRP7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"IRP7C1", PMC628, IRP7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"IRP7C2", PMC629, IRP7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"IRP7C3", PMC630, IRP7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"IRP8C0", PMC631, IRP8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"IRP8C1", PMC632, IRP8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"IRP8C2", PMC633, IRP8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"IRP8C3", PMC634, IRP8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"IRP9C0", PMC635, IRP9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"IRP9C1", PMC636, IRP9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"IRP9C2", PMC637, IRP9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"IRP9C3", PMC638, IRP9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"IRP10C0", PMC639, IRP10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"IRP10C1", PMC640, IRP10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"IRP10C2", PMC641, IRP10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"IRP10C3", PMC642, IRP10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"IRP11C0", PMC643, IRP11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"IRP11C1", PMC644, IRP11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"IRP11C2", PMC645, IRP11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"IRP11C3", PMC646, IRP11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"IRP12C0", PMC647, IRP12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"IRP12C1", PMC648, IRP12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"IRP12C2", PMC649, IRP12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"IRP12C3", PMC650, IRP12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"IRP13C0", PMC651, IRP13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"IRP13C1", PMC652, IRP13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"IRP13C2", PMC653, IRP13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"IRP13C3", PMC654, IRP13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"IRP14C0", PMC655, IRP14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"IRP14C1", PMC656, IRP14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"IRP14C2", PMC657, IRP14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"IRP14C3", PMC658, IRP14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"IRP15C0", PMC659, IRP15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"IRP15C1", PMC660, IRP15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"IRP15C2", PMC661, IRP15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IRP_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"IRP15C3", PMC662, IRP15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IRP_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX0C0", PMC663, PBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE0, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX0C1", PMC664, PBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE0, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX0C2", PMC665, PBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE0, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX0C3", PMC666, PBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE0, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX1C0", PMC667, PBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE1, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX1C1", PMC668, PBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE1, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX1C2", PMC669, PBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE1, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX1C3", PMC670, PBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE1, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX2C0", PMC671, PBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE2, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX2C1", PMC672, PBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE2, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX2C2", PMC673, PBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE2, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX2C3", PMC674, PBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE2, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX3C0", PMC675, PBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE3, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX3C1", PMC676, PBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE3, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX3C2", PMC677, PBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE3, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX3C3", PMC678, PBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE3, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX4C0", PMC679, PBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE4, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX4C1", PMC680, PBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE4, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX4C2", PMC681, PBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE4, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX4C3", PMC682, PBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE4, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX5C0", PMC683, PBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE5, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX5C1", PMC684, PBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE5, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX5C2", PMC685, PBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE5, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX5C3", PMC686, PBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE5, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX6C0", PMC687, PBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE6, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX6C1", PMC688, PBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE6, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX6C2", PMC689, PBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE6, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX6C3", PMC690, PBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE6, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX7C0", PMC691, PBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE7, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX7C1", PMC692, PBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE7, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX7C2", PMC693, PBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE7, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX7C3", PMC694, PBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE7, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX8C0", PMC695, PBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE8, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX8C1", PMC696, PBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE8, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX8C2", PMC697, PBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE8, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX8C3", PMC698, PBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE8, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX9C0", PMC699, PBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE9, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX9C1", PMC700, PBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE9, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX9C2", PMC701, PBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE9, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX9C3", PMC702, PBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE9, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX10C0", PMC703, PBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE10, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX10C1", PMC704, PBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE10, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX10C2", PMC705, PBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE10, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX10C3", PMC706, PBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE10, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX11C0", PMC707, PBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE11, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX11C1", PMC708, PBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE11, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX11C2", PMC709, PBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE11, GNR_VALID_OPTIONS_UNCORE},
    {"PBOX11C3", PMC710, PBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE11, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX0C0", PMC711, RBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_0, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX0C1", PMC712, RBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_0, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX0C2", PMC713, RBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_0, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX0C3", PMC714, RBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_0, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX1C0", PMC715, RBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_1, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX1C1", PMC716, RBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_1, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX1C2", PMC717, RBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_1, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX1C3", PMC718, RBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_1, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX2C0", PMC719, RBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_2, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX2C1", PMC720, RBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_2, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX2C2", PMC721, RBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_2, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX2C3", PMC722, RBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_2, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX3C0", PMC723, RBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_3, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX3C1", PMC724, RBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_3, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX3C2", PMC725, RBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_3, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX3C3", PMC726, RBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_3, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX4C0", PMC727, RBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_4, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX4C1", PMC728, RBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_4, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX4C2", PMC729, RBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_4, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX4C3", PMC730, RBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_4, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX5C0", PMC731, RBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_5, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX5C1", PMC732, RBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_5, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX5C2", PMC733, RBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_5, GNR_VALID_OPTIONS_UNCORE},
    {"RBOX5C3", PMC734, RBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_5, GNR_VALID_OPTIONS_UNCORE},
    {"M2M0C0", PMC735, BBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"M2M0C1", PMC736, BBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"M2M0C2", PMC737, BBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"M2M0C3", PMC738, BBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"M2M1C0", PMC739, BBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"M2M1C1", PMC740, BBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"M2M1C2", PMC741, BBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"M2M1C3", PMC742, BBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"M2M2C0", PMC743, BBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"M2M2C1", PMC744, BBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"M2M2C2", PMC745, BBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"M2M2C3", PMC746, BBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"M2M3C0", PMC747, BBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"M2M3C1", PMC748, BBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"M2M3C2", PMC749, BBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"M2M3C3", PMC750, BBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"M2M4C0", PMC751, BBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"M2M4C1", PMC752, BBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"M2M4C2", PMC753, BBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"M2M4C3", PMC754, BBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"M2M5C0", PMC755, BBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"M2M5C1", PMC756, BBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"M2M5C2", PMC757, BBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"M2M5C3", PMC758, BBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"MDF0C0", PMC759, MDF0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"MDF0C1", PMC760, MDF0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"MDF0C2", PMC761, MDF0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"MDF0C3", PMC762, MDF0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"MDF1C0", PMC763, MDF1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"MDF1C1", PMC764, MDF1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"MDF1C2", PMC765, MDF1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"MDF1C3", PMC766, MDF1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"MDF2C0", PMC767, MDF2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"MDF2C1", PMC768, MDF2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"MDF2C2", PMC769, MDF2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"MDF2C3", PMC770, MDF2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"MDF3C0", PMC771, MDF3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"MDF3C1", PMC772, MDF3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"MDF3C2", PMC773, MDF3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"MDF3C3", PMC774, MDF3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"MDF4C0", PMC775, MDF4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"MDF4C1", PMC776, MDF4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"MDF4C2", PMC777, MDF4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"MDF4C3", PMC778, MDF4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"MDF5C0", PMC779, MDF5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"MDF5C1", PMC780, MDF5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"MDF5C2", PMC781, MDF5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"MDF5C3", PMC782, MDF5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"MDF6C0", PMC783, MDF6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"MDF6C1", PMC784, MDF6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"MDF6C2", PMC785, MDF6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"MDF6C3", PMC786, MDF6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"MDF7C0", PMC787, MDF7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"MDF7C1", PMC788, MDF7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"MDF7C2", PMC789, MDF7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"MDF7C3", PMC790, MDF7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"MDF8C0", PMC791, MDF8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"MDF8C1", PMC792, MDF8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"MDF8C2", PMC793, MDF8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"MDF8C3", PMC794, MDF8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"MDF9C0", PMC795, MDF9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"MDF9C1", PMC796, MDF9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"MDF9C2", PMC797, MDF9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"MDF9C3", PMC798, MDF9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"MDF10C0", PMC799, MDF10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"MDF10C1", PMC800, MDF10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"MDF10C2", PMC801, MDF10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"MDF10C3", PMC802, MDF10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"MDF11C0", PMC803, MDF11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"MDF11C1", PMC804, MDF11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"MDF11C2", PMC805, MDF11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"MDF11C3", PMC806, MDF11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"MDF12C0", PMC807, MDF12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"MDF12C1", PMC808, MDF12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"MDF12C2", PMC809, MDF12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"MDF12C3", PMC810, MDF12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"MDF13C0", PMC811, MDF13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"MDF13C1", PMC812, MDF13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"MDF13C2", PMC813, MDF13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"MDF13C3", PMC814, MDF13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"MDF14C0", PMC815, MDF14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"MDF14C1", PMC816, MDF14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"MDF14C2", PMC817, MDF14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"MDF14C3", PMC818, MDF14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"MDF15C0", PMC819, MDF15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"MDF15C1", PMC820, MDF15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"MDF15C2", PMC821, MDF15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"MDF15C3", PMC822, MDF15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"MDF16C0", PMC823, MDF16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_16, GNR_VALID_OPTIONS_UNCORE},
    {"MDF16C1", PMC824, MDF16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_16, GNR_VALID_OPTIONS_UNCORE},
    {"MDF16C2", PMC825, MDF16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_16, GNR_VALID_OPTIONS_UNCORE},
    {"MDF16C3", PMC826, MDF16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_16, GNR_VALID_OPTIONS_UNCORE},
    {"MDF17C0", PMC827, MDF17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_17, GNR_VALID_OPTIONS_UNCORE},
    {"MDF17C1", PMC828, MDF17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_17, GNR_VALID_OPTIONS_UNCORE},
    {"MDF17C2", PMC829, MDF17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_17, GNR_VALID_OPTIONS_UNCORE},
    {"MDF17C3", PMC830, MDF17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_17, GNR_VALID_OPTIONS_UNCORE},
    {"MDF18C0", PMC831, MDF18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_18, GNR_VALID_OPTIONS_UNCORE},
    {"MDF18C1", PMC832, MDF18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_18, GNR_VALID_OPTIONS_UNCORE},
    {"MDF18C2", PMC833, MDF18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_18, GNR_VALID_OPTIONS_UNCORE},
    {"MDF18C3", PMC834, MDF18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_18, GNR_VALID_OPTIONS_UNCORE},
    {"MDF19C0", PMC835, MDF19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_19, GNR_VALID_OPTIONS_UNCORE},
    {"MDF19C1", PMC836, MDF19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_19, GNR_VALID_OPTIONS_UNCORE},
    {"MDF19C2", PMC837, MDF19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_19, GNR_VALID_OPTIONS_UNCORE},
    {"MDF19C3", PMC838, MDF19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_19, GNR_VALID_OPTIONS_UNCORE},
    {"MDF20C0", PMC839, MDF20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_20, GNR_VALID_OPTIONS_UNCORE},
    {"MDF20C1", PMC840, MDF20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_20, GNR_VALID_OPTIONS_UNCORE},
    {"MDF20C2", PMC841, MDF20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_20, GNR_VALID_OPTIONS_UNCORE},
    {"MDF20C3", PMC842, MDF20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_20, GNR_VALID_OPTIONS_UNCORE},
    {"MDF21C0", PMC843, MDF21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_21, GNR_VALID_OPTIONS_UNCORE},
    {"MDF21C1", PMC844, MDF21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_21, GNR_VALID_OPTIONS_UNCORE},
    {"MDF21C2", PMC845, MDF21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_21, GNR_VALID_OPTIONS_UNCORE},
    {"MDF21C3", PMC846, MDF21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_21, GNR_VALID_OPTIONS_UNCORE},
    {"MDF22C0", PMC847, MDF22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_22, GNR_VALID_OPTIONS_UNCORE},
    {"MDF22C1", PMC848, MDF22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_22, GNR_VALID_OPTIONS_UNCORE},
    {"MDF22C2", PMC849, MDF22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_22, GNR_VALID_OPTIONS_UNCORE},
    {"MDF22C3", PMC850, MDF22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_22, GNR_VALID_OPTIONS_UNCORE},
    {"MDF23C0", PMC851, MDF23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_23, GNR_VALID_OPTIONS_UNCORE},
    {"MDF23C1", PMC852, MDF23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_23, GNR_VALID_OPTIONS_UNCORE},
    {"MDF23C2", PMC853, MDF23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_23, GNR_VALID_OPTIONS_UNCORE},
    {"MDF23C3", PMC854, MDF23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_23, GNR_VALID_OPTIONS_UNCORE},
    {"MDF24C0", PMC855, MDF24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_24, GNR_VALID_OPTIONS_UNCORE},
    {"MDF24C1", PMC856, MDF24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_24, GNR_VALID_OPTIONS_UNCORE},
    {"MDF24C2", PMC857, MDF24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_24, GNR_VALID_OPTIONS_UNCORE},
    {"MDF24C3", PMC858, MDF24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_24, GNR_VALID_OPTIONS_UNCORE},
    {"MDF25C0", PMC859, MDF25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_25, GNR_VALID_OPTIONS_UNCORE},
    {"MDF25C1", PMC860, MDF25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_25, GNR_VALID_OPTIONS_UNCORE},
    {"MDF25C2", PMC861, MDF25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_25, GNR_VALID_OPTIONS_UNCORE},
    {"MDF25C3", PMC862, MDF25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_25, GNR_VALID_OPTIONS_UNCORE},
    {"MDF26C0", PMC863, MDF26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_26, GNR_VALID_OPTIONS_UNCORE},
    {"MDF26C1", PMC864, MDF26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_26, GNR_VALID_OPTIONS_UNCORE},
    {"MDF26C2", PMC865, MDF26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_26, GNR_VALID_OPTIONS_UNCORE},
    {"MDF26C3", PMC866, MDF26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_26, GNR_VALID_OPTIONS_UNCORE},
    {"MDF27C0", PMC867, MDF27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_27, GNR_VALID_OPTIONS_UNCORE},
    {"MDF27C1", PMC868, MDF27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_27, GNR_VALID_OPTIONS_UNCORE},
    {"MDF27C2", PMC869, MDF27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_27, GNR_VALID_OPTIONS_UNCORE},
    {"MDF27C3", PMC870, MDF27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_27, GNR_VALID_OPTIONS_UNCORE},
    {"MDF28C0", PMC871, MDF28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_28, GNR_VALID_OPTIONS_UNCORE},
    {"MDF28C1", PMC872, MDF28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_28, GNR_VALID_OPTIONS_UNCORE},
    {"MDF28C2", PMC873, MDF28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_28, GNR_VALID_OPTIONS_UNCORE},
    {"MDF28C3", PMC874, MDF28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_28, GNR_VALID_OPTIONS_UNCORE},
    {"MDF29C0", PMC875, MDF29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_29, GNR_VALID_OPTIONS_UNCORE},
    {"MDF29C1", PMC876, MDF29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_29, GNR_VALID_OPTIONS_UNCORE},
    {"MDF29C2", PMC877, MDF29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_29, GNR_VALID_OPTIONS_UNCORE},
    {"MDF29C3", PMC878, MDF29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_29, GNR_VALID_OPTIONS_UNCORE},
    {"MDF30C0", PMC879, MDF30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_30, GNR_VALID_OPTIONS_UNCORE},
    {"MDF30C1", PMC880, MDF30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_30, GNR_VALID_OPTIONS_UNCORE},
    {"MDF30C2", PMC881, MDF30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_30, GNR_VALID_OPTIONS_UNCORE},
    {"MDF30C3", PMC882, MDF30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_30, GNR_VALID_OPTIONS_UNCORE},
    {"MDF31C0", PMC883, MDF31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_31, GNR_VALID_OPTIONS_UNCORE},
    {"MDF31C1", PMC884, MDF31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_31, GNR_VALID_OPTIONS_UNCORE},
    {"MDF31C2", PMC885, MDF31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_31, GNR_VALID_OPTIONS_UNCORE},
    {"MDF31C3", PMC886, MDF31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_31, GNR_VALID_OPTIONS_UNCORE},
    {"MDF32C0", PMC887, MDF32, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_32, GNR_VALID_OPTIONS_UNCORE},
    {"MDF32C1", PMC888, MDF32, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_32, GNR_VALID_OPTIONS_UNCORE},
    {"MDF32C2", PMC889, MDF32, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_32, GNR_VALID_OPTIONS_UNCORE},
    {"MDF32C3", PMC890, MDF32, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_32, GNR_VALID_OPTIONS_UNCORE},
    {"MDF33C0", PMC891, MDF33, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_33, GNR_VALID_OPTIONS_UNCORE},
    {"MDF33C1", PMC892, MDF33, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_33, GNR_VALID_OPTIONS_UNCORE},
    {"MDF33C2", PMC893, MDF33, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_33, GNR_VALID_OPTIONS_UNCORE},
    {"MDF33C3", PMC894, MDF33, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_33, GNR_VALID_OPTIONS_UNCORE},
    {"MDF34C0", PMC895, MDF34, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_34, GNR_VALID_OPTIONS_UNCORE},
    {"MDF34C1", PMC896, MDF34, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_34, GNR_VALID_OPTIONS_UNCORE},
    {"MDF34C2", PMC897, MDF34, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_34, GNR_VALID_OPTIONS_UNCORE},
    {"MDF34C3", PMC898, MDF34, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_34, GNR_VALID_OPTIONS_UNCORE},
    {"MDF35C0", PMC899, MDF35, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_35, GNR_VALID_OPTIONS_UNCORE},
    {"MDF35C1", PMC900, MDF35, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_35, GNR_VALID_OPTIONS_UNCORE},
    {"MDF35C2", PMC901, MDF35, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_35, GNR_VALID_OPTIONS_UNCORE},
    {"MDF35C3", PMC902, MDF35, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_35, GNR_VALID_OPTIONS_UNCORE},
    {"MDF36C0", PMC903, MDF36, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_36, GNR_VALID_OPTIONS_UNCORE},
    {"MDF36C1", PMC904, MDF36, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_36, GNR_VALID_OPTIONS_UNCORE},
    {"MDF36C2", PMC905, MDF36, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_36, GNR_VALID_OPTIONS_UNCORE},
    {"MDF36C3", PMC906, MDF36, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_36, GNR_VALID_OPTIONS_UNCORE},
    {"MDF37C0", PMC907, MDF37, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_37, GNR_VALID_OPTIONS_UNCORE},
    {"MDF37C1", PMC908, MDF37, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_37, GNR_VALID_OPTIONS_UNCORE},
    {"MDF37C2", PMC909, MDF37, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_37, GNR_VALID_OPTIONS_UNCORE},
    {"MDF37C3", PMC910, MDF37, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_37, GNR_VALID_OPTIONS_UNCORE},
    {"MDF38C0", PMC911, MDF38, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_38, GNR_VALID_OPTIONS_UNCORE},
    {"MDF38C1", PMC912, MDF38, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_38, GNR_VALID_OPTIONS_UNCORE},
    {"MDF38C2", PMC913, MDF38, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_38, GNR_VALID_OPTIONS_UNCORE},
    {"MDF38C3", PMC914, MDF38, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_38, GNR_VALID_OPTIONS_UNCORE},
    {"MDF39C0", PMC915, MDF39, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_39, GNR_VALID_OPTIONS_UNCORE},
    {"MDF39C1", PMC916, MDF39, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_39, GNR_VALID_OPTIONS_UNCORE},
    {"MDF39C2", PMC917, MDF39, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_39, GNR_VALID_OPTIONS_UNCORE},
    {"MDF39C3", PMC918, MDF39, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_39, GNR_VALID_OPTIONS_UNCORE},
    {"MDF40C0", PMC919, MDF40, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_40, GNR_VALID_OPTIONS_UNCORE},
    {"MDF40C1", PMC920, MDF40, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_40, GNR_VALID_OPTIONS_UNCORE},
    {"MDF40C2", PMC921, MDF40, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_40, GNR_VALID_OPTIONS_UNCORE},
    {"MDF40C3", PMC922, MDF40, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_40, GNR_VALID_OPTIONS_UNCORE},
    {"MDF41C0", PMC923, MDF41, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_41, GNR_VALID_OPTIONS_UNCORE},
    {"MDF41C1", PMC924, MDF41, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_41, GNR_VALID_OPTIONS_UNCORE},
    {"MDF41C2", PMC925, MDF41, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_41, GNR_VALID_OPTIONS_UNCORE},
    {"MDF41C3", PMC926, MDF41, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_41, GNR_VALID_OPTIONS_UNCORE},
    {"MDF42C0", PMC927, MDF42, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_42, GNR_VALID_OPTIONS_UNCORE},
    {"MDF42C1", PMC928, MDF42, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_42, GNR_VALID_OPTIONS_UNCORE},
    {"MDF42C2", PMC929, MDF42, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_42, GNR_VALID_OPTIONS_UNCORE},
    {"MDF42C3", PMC930, MDF42, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_42, GNR_VALID_OPTIONS_UNCORE},
    {"MDF43C0", PMC931, MDF43, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_43, GNR_VALID_OPTIONS_UNCORE},
    {"MDF43C1", PMC932, MDF43, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_43, GNR_VALID_OPTIONS_UNCORE},
    {"MDF43C2", PMC933, MDF43, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_43, GNR_VALID_OPTIONS_UNCORE},
    {"MDF43C3", PMC934, MDF43, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_43, GNR_VALID_OPTIONS_UNCORE},
    {"MDF44C0", PMC935, MDF44, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_44, GNR_VALID_OPTIONS_UNCORE},
    {"MDF44C1", PMC936, MDF44, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_44, GNR_VALID_OPTIONS_UNCORE},
    {"MDF44C2", PMC937, MDF44, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_44, GNR_VALID_OPTIONS_UNCORE},
    {"MDF44C3", PMC938, MDF44, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_44, GNR_VALID_OPTIONS_UNCORE},
    {"MDF45C0", PMC939, MDF45, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_45, GNR_VALID_OPTIONS_UNCORE},
    {"MDF45C1", PMC940, MDF45, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_45, GNR_VALID_OPTIONS_UNCORE},
    {"MDF45C2", PMC941, MDF45, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_45, GNR_VALID_OPTIONS_UNCORE},
    {"MDF45C3", PMC942, MDF45, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_45, GNR_VALID_OPTIONS_UNCORE},
    {"MDF46C0", PMC943, MDF46, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_46, GNR_VALID_OPTIONS_UNCORE},
    {"MDF46C1", PMC944, MDF46, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_46, GNR_VALID_OPTIONS_UNCORE},
    {"MDF46C2", PMC945, MDF46, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_46, GNR_VALID_OPTIONS_UNCORE},
    {"MDF46C3", PMC946, MDF46, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_46, GNR_VALID_OPTIONS_UNCORE},
    {"MDF47C0", PMC947, MDF47, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_47, GNR_VALID_OPTIONS_UNCORE},
    {"MDF47C1", PMC948, MDF47, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_47, GNR_VALID_OPTIONS_UNCORE},
    {"MDF47C2", PMC949, MDF47, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_47, GNR_VALID_OPTIONS_UNCORE},
    {"MDF47C3", PMC950, MDF47, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_47, GNR_VALID_OPTIONS_UNCORE},
    {"MDF48C0", PMC951, MDF48, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_48, GNR_VALID_OPTIONS_UNCORE},
    {"MDF48C1", PMC952, MDF48, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_48, GNR_VALID_OPTIONS_UNCORE},
    {"MDF48C2", PMC953, MDF48, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_48, GNR_VALID_OPTIONS_UNCORE},
    {"MDF48C3", PMC954, MDF48, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_48, GNR_VALID_OPTIONS_UNCORE},
    {"MDF49C0", PMC955, MDF49, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_49, GNR_VALID_OPTIONS_UNCORE},
    {"MDF49C1", PMC956, MDF49, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_49, GNR_VALID_OPTIONS_UNCORE},
    {"MDF49C2", PMC957, MDF49, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_49, GNR_VALID_OPTIONS_UNCORE},
    {"MDF49C3", PMC958, MDF49, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_49, GNR_VALID_OPTIONS_UNCORE},
    {"MDF50C0", PMC959, MDF50, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_50, GNR_VALID_OPTIONS_UNCORE},
    {"MDF50C1", PMC960, MDF50, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_50, GNR_VALID_OPTIONS_UNCORE},
    {"MDF50C2", PMC961, MDF50, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_50, GNR_VALID_OPTIONS_UNCORE},
    {"MDF50C3", PMC962, MDF50, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_50, GNR_VALID_OPTIONS_UNCORE},
    {"MDF51C0", PMC963, MDF51, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_51, GNR_VALID_OPTIONS_UNCORE},
    {"MDF51C1", PMC964, MDF51, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_51, GNR_VALID_OPTIONS_UNCORE},
    {"MDF51C2", PMC965, MDF51, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_51, GNR_VALID_OPTIONS_UNCORE},
    {"MDF51C3", PMC966, MDF51, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_51, GNR_VALID_OPTIONS_UNCORE},
    {"MDF52C0", PMC967, MDF52, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_52, GNR_VALID_OPTIONS_UNCORE},
    {"MDF52C1", PMC968, MDF52, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_52, GNR_VALID_OPTIONS_UNCORE},
    {"MDF52C2", PMC969, MDF52, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_52, GNR_VALID_OPTIONS_UNCORE},
    {"MDF52C3", PMC970, MDF52, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_52, GNR_VALID_OPTIONS_UNCORE},
    {"MDF53C0", PMC971, MDF53, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_53, GNR_VALID_OPTIONS_UNCORE},
    {"MDF53C1", PMC972, MDF53, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_53, GNR_VALID_OPTIONS_UNCORE},
    {"MDF53C2", PMC973, MDF53, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_53, GNR_VALID_OPTIONS_UNCORE},
    {"MDF53C3", PMC974, MDF53, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_53, GNR_VALID_OPTIONS_UNCORE},
    {"MDF54C0", PMC975, MDF54, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_54, GNR_VALID_OPTIONS_UNCORE},
    {"MDF54C1", PMC976, MDF54, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_54, GNR_VALID_OPTIONS_UNCORE},
    {"MDF54C2", PMC977, MDF54, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_54, GNR_VALID_OPTIONS_UNCORE},
    {"MDF54C3", PMC978, MDF54, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_54, GNR_VALID_OPTIONS_UNCORE},
    {"MDF55C0", PMC979, MDF55, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_55, GNR_VALID_OPTIONS_UNCORE},
    {"MDF55C1", PMC980, MDF55, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_55, GNR_VALID_OPTIONS_UNCORE},
    {"MDF55C2", PMC981, MDF55, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_55, GNR_VALID_OPTIONS_UNCORE},
    {"MDF55C3", PMC982, MDF55, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_55, GNR_VALID_OPTIONS_UNCORE},
    {"MDF56C0", PMC983, MDF56, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_56, GNR_VALID_OPTIONS_UNCORE},
    {"MDF56C1", PMC984, MDF56, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_56, GNR_VALID_OPTIONS_UNCORE},
    {"MDF56C2", PMC985, MDF56, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_56, GNR_VALID_OPTIONS_UNCORE},
    {"MDF56C3", PMC986, MDF56, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_56, GNR_VALID_OPTIONS_UNCORE},
    {"MDF57C0", PMC987, MDF57, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_57, GNR_VALID_OPTIONS_UNCORE},
    {"MDF57C1", PMC988, MDF57, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_57, GNR_VALID_OPTIONS_UNCORE},
    {"MDF57C2", PMC989, MDF57, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_57, GNR_VALID_OPTIONS_UNCORE},
    {"MDF57C3", PMC990, MDF57, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_57, GNR_VALID_OPTIONS_UNCORE},
    {"MDF58C0", PMC991, MDF58, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_58, GNR_VALID_OPTIONS_UNCORE},
    {"MDF58C1", PMC992, MDF58, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_58, GNR_VALID_OPTIONS_UNCORE},
    {"MDF58C2", PMC993, MDF58, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_58, GNR_VALID_OPTIONS_UNCORE},
    {"MDF58C3", PMC994, MDF58, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_58, GNR_VALID_OPTIONS_UNCORE},
    {"MDF59C0", PMC995, MDF59, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_59, GNR_VALID_OPTIONS_UNCORE},
    {"MDF59C1", PMC996, MDF59, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_59, GNR_VALID_OPTIONS_UNCORE},
    {"MDF59C2", PMC997, MDF59, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_59, GNR_VALID_OPTIONS_UNCORE},
    {"MDF59C3", PMC998, MDF59, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_59, GNR_VALID_OPTIONS_UNCORE},
    {"MDF60C0", PMC999, MDF60, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_60, GNR_VALID_OPTIONS_UNCORE},
    {"MDF60C1", PMC1000, MDF60, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_60, GNR_VALID_OPTIONS_UNCORE},
    {"MDF60C2", PMC1001, MDF60, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_60, GNR_VALID_OPTIONS_UNCORE},
    {"MDF60C3", PMC1002, MDF60, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_60, GNR_VALID_OPTIONS_UNCORE},
    {"MDF61C0", PMC1003, MDF61, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_61, GNR_VALID_OPTIONS_UNCORE},
    {"MDF61C1", PMC1004, MDF61, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_61, GNR_VALID_OPTIONS_UNCORE},
    {"MDF61C2", PMC1005, MDF61, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_61, GNR_VALID_OPTIONS_UNCORE},
    {"MDF61C3", PMC1006, MDF61, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_61, GNR_VALID_OPTIONS_UNCORE},
    {"MDF62C0", PMC1007, MDF62, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_62, GNR_VALID_OPTIONS_UNCORE},
    {"MDF62C1", PMC1008, MDF62, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_62, GNR_VALID_OPTIONS_UNCORE},
    {"MDF62C2", PMC1009, MDF62, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_62, GNR_VALID_OPTIONS_UNCORE},
    {"MDF62C3", PMC1010, MDF62, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_62, GNR_VALID_OPTIONS_UNCORE},
    {"MDF63C0", PMC1011, MDF63, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_63, GNR_VALID_OPTIONS_UNCORE},
    {"MDF63C1", PMC1012, MDF63, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_63, GNR_VALID_OPTIONS_UNCORE},
    {"MDF63C2", PMC1013, MDF63, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_63, GNR_VALID_OPTIONS_UNCORE},
    {"MDF63C3", PMC1014, MDF63, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_63, GNR_VALID_OPTIONS_UNCORE},
    {"MDF64C0", PMC1015, MDF64, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_64, GNR_VALID_OPTIONS_UNCORE},
    {"MDF64C1", PMC1016, MDF64, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_64, GNR_VALID_OPTIONS_UNCORE},
    {"MDF64C2", PMC1017, MDF64, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_64, GNR_VALID_OPTIONS_UNCORE},
    {"MDF64C3", PMC1018, MDF64, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_64, GNR_VALID_OPTIONS_UNCORE},
    {"MDF65C0", PMC1019, MDF65, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_65, GNR_VALID_OPTIONS_UNCORE},
    {"MDF65C1", PMC1020, MDF65, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_65, GNR_VALID_OPTIONS_UNCORE},
    {"MDF65C2", PMC1021, MDF65, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_65, GNR_VALID_OPTIONS_UNCORE},
    {"MDF65C3", PMC1022, MDF65, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_65, GNR_VALID_OPTIONS_UNCORE},
    {"MDF66C0", PMC1023, MDF66, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_66, GNR_VALID_OPTIONS_UNCORE},
    {"MDF66C1", PMC1024, MDF66, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_66, GNR_VALID_OPTIONS_UNCORE},
    {"MDF66C2", PMC1025, MDF66, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_66, GNR_VALID_OPTIONS_UNCORE},
    {"MDF66C3", PMC1026, MDF66, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_66, GNR_VALID_OPTIONS_UNCORE},
    {"MDF67C0", PMC1027, MDF67, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_67, GNR_VALID_OPTIONS_UNCORE},
    {"MDF67C1", PMC1028, MDF67, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_67, GNR_VALID_OPTIONS_UNCORE},
    {"MDF67C2", PMC1029, MDF67, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_67, GNR_VALID_OPTIONS_UNCORE},
    {"MDF67C3", PMC1030, MDF67, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_67, GNR_VALID_OPTIONS_UNCORE},
    {"MDF68C0", PMC1031, MDF68, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_68, GNR_VALID_OPTIONS_UNCORE},
    {"MDF68C1", PMC1032, MDF68, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_68, GNR_VALID_OPTIONS_UNCORE},
    {"MDF68C2", PMC1033, MDF68, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_68, GNR_VALID_OPTIONS_UNCORE},
    {"MDF68C3", PMC1034, MDF68, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_68, GNR_VALID_OPTIONS_UNCORE},
    {"MDF69C0", PMC1035, MDF69, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_69, GNR_VALID_OPTIONS_UNCORE},
    {"MDF69C1", PMC1036, MDF69, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_69, GNR_VALID_OPTIONS_UNCORE},
    {"MDF69C2", PMC1037, MDF69, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_69, GNR_VALID_OPTIONS_UNCORE},
    {"MDF69C3", PMC1038, MDF69, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_69, GNR_VALID_OPTIONS_UNCORE},
    {"MDF70C0", PMC1039, MDF70, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_70, GNR_VALID_OPTIONS_UNCORE},
    {"MDF70C1", PMC1040, MDF70, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_70, GNR_VALID_OPTIONS_UNCORE},
    {"MDF70C2", PMC1041, MDF70, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_70, GNR_VALID_OPTIONS_UNCORE},
    {"MDF70C3", PMC1042, MDF70, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_70, GNR_VALID_OPTIONS_UNCORE},
    {"MDF71C0", PMC1043, MDF71, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_71, GNR_VALID_OPTIONS_UNCORE},
    {"MDF71C1", PMC1044, MDF71, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_71, GNR_VALID_OPTIONS_UNCORE},
    {"MDF71C2", PMC1045, MDF71, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_71, GNR_VALID_OPTIONS_UNCORE},
    {"MDF71C3", PMC1046, MDF71, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_71, GNR_VALID_OPTIONS_UNCORE},
    {"MDF72C0", PMC1047, MDF72, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_72, GNR_VALID_OPTIONS_UNCORE},
    {"MDF72C1", PMC1048, MDF72, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_72, GNR_VALID_OPTIONS_UNCORE},
    {"MDF72C2", PMC1049, MDF72, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_72, GNR_VALID_OPTIONS_UNCORE},
    {"MDF72C3", PMC1050, MDF72, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_72, GNR_VALID_OPTIONS_UNCORE},
    {"MDF73C0", PMC1051, MDF73, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_73, GNR_VALID_OPTIONS_UNCORE},
    {"MDF73C1", PMC1052, MDF73, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_73, GNR_VALID_OPTIONS_UNCORE},
    {"MDF73C2", PMC1053, MDF73, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_73, GNR_VALID_OPTIONS_UNCORE},
    {"MDF73C3", PMC1054, MDF73, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_73, GNR_VALID_OPTIONS_UNCORE},
    {"MDF74C0", PMC1055, MDF74, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_74, GNR_VALID_OPTIONS_UNCORE},
    {"MDF74C1", PMC1056, MDF74, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_74, GNR_VALID_OPTIONS_UNCORE},
    {"MDF74C2", PMC1057, MDF74, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_74, GNR_VALID_OPTIONS_UNCORE},
    {"MDF74C3", PMC1058, MDF74, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_74, GNR_VALID_OPTIONS_UNCORE},
    {"MDF75C0", PMC1059, MDF75, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_75, GNR_VALID_OPTIONS_UNCORE},
    {"MDF75C1", PMC1060, MDF75, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_75, GNR_VALID_OPTIONS_UNCORE},
    {"MDF75C2", PMC1061, MDF75, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_75, GNR_VALID_OPTIONS_UNCORE},
    {"MDF75C3", PMC1062, MDF75, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_75, GNR_VALID_OPTIONS_UNCORE},
    {"MDF76C0", PMC1063, MDF76, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_76, GNR_VALID_OPTIONS_UNCORE},
    {"MDF76C1", PMC1064, MDF76, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_76, GNR_VALID_OPTIONS_UNCORE},
    {"MDF76C2", PMC1065, MDF76, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_76, GNR_VALID_OPTIONS_UNCORE},
    {"MDF76C3", PMC1066, MDF76, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_76, GNR_VALID_OPTIONS_UNCORE},
    {"MDF77C0", PMC1067, MDF77, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_77, GNR_VALID_OPTIONS_UNCORE},
    {"MDF77C1", PMC1068, MDF77, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_77, GNR_VALID_OPTIONS_UNCORE},
    {"MDF77C2", PMC1069, MDF77, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_77, GNR_VALID_OPTIONS_UNCORE},
    {"MDF77C3", PMC1070, MDF77, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_77, GNR_VALID_OPTIONS_UNCORE},
    {"MDF78C0", PMC1071, MDF78, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_78, GNR_VALID_OPTIONS_UNCORE},
    {"MDF78C1", PMC1072, MDF78, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_78, GNR_VALID_OPTIONS_UNCORE},
    {"MDF78C2", PMC1073, MDF78, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_78, GNR_VALID_OPTIONS_UNCORE},
    {"MDF78C3", PMC1074, MDF78, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_78, GNR_VALID_OPTIONS_UNCORE},
    {"MDF79C0", PMC1075, MDF79, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_79, GNR_VALID_OPTIONS_UNCORE},
    {"MDF79C1", PMC1076, MDF79, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_79, GNR_VALID_OPTIONS_UNCORE},
    {"MDF79C2", PMC1077, MDF79, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_79, GNR_VALID_OPTIONS_UNCORE},
    {"MDF79C3", PMC1078, MDF79, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_79, GNR_VALID_OPTIONS_UNCORE},
    {"UPI0C0", PMC1079, QBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_0, GNR_VALID_OPTIONS_UNCORE},
    {"UPI0C1", PMC1080, QBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_0, GNR_VALID_OPTIONS_UNCORE},
    {"UPI0C2", PMC1081, QBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_0, GNR_VALID_OPTIONS_UNCORE},
    {"UPI0C3", PMC1082, QBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_0, GNR_VALID_OPTIONS_UNCORE},
    {"UPI1C0", PMC1083, QBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_1, GNR_VALID_OPTIONS_UNCORE},
    {"UPI1C1", PMC1084, QBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_1, GNR_VALID_OPTIONS_UNCORE},
    {"UPI1C2", PMC1085, QBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_1, GNR_VALID_OPTIONS_UNCORE},
    {"UPI1C3", PMC1086, QBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_1, GNR_VALID_OPTIONS_UNCORE},
    {"UPI2C0", PMC1087, QBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_2, GNR_VALID_OPTIONS_UNCORE},
    {"UPI2C1", PMC1088, QBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_2, GNR_VALID_OPTIONS_UNCORE},
    {"UPI2C2", PMC1089, QBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_2, GNR_VALID_OPTIONS_UNCORE},
    {"UPI2C3", PMC1090, QBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_2, GNR_VALID_OPTIONS_UNCORE},
    {"UPI3C0", PMC1091, QBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_3, GNR_VALID_OPTIONS_UNCORE},
    {"UPI3C1", PMC1092, QBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_3, GNR_VALID_OPTIONS_UNCORE},
    {"UPI3C2", PMC1093, QBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_3, GNR_VALID_OPTIONS_UNCORE},
    {"UPI3C3", PMC1094, QBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_3, GNR_VALID_OPTIONS_UNCORE},
    {"UPI4C0", PMC1095, QBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_4, GNR_VALID_OPTIONS_UNCORE},
    {"UPI4C1", PMC1096, QBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_4, GNR_VALID_OPTIONS_UNCORE},
    {"UPI4C2", PMC1097, QBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_4, GNR_VALID_OPTIONS_UNCORE},
    {"UPI4C3", PMC1098, QBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_4, GNR_VALID_OPTIONS_UNCORE},
    {"UPI5C0", PMC1099, QBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_5, GNR_VALID_OPTIONS_UNCORE},
    {"UPI5C1", PMC1100, QBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_5, GNR_VALID_OPTIONS_UNCORE},
    {"UPI5C2", PMC1101, QBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_5, GNR_VALID_OPTIONS_UNCORE},
    {"UPI5C3", PMC1102, QBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_5, GNR_VALID_OPTIONS_UNCORE},
    {"UBOX0", PMC1103, UBOX, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_UBOX_DEVICE, GNR_VALID_OPTIONS_UNCORE},
    {"UBOX1", PMC1104, UBOX, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_UBOX_DEVICE, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX0C0", PMC1105, IBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX0C1", PMC1106, IBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX0C2", PMC1107, IBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX0C3", PMC1108, IBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_0, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX1C0", PMC1109, IBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX1C1", PMC1110, IBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX1C2", PMC1111, IBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX1C3", PMC1112, IBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_1, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX2C0", PMC1113, IBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX2C1", PMC1114, IBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX2C2", PMC1115, IBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX2C3", PMC1116, IBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_2, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX3C0", PMC1117, IBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX3C1", PMC1118, IBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX3C2", PMC1119, IBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX3C3", PMC1120, IBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_3, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX4C0", PMC1121, IBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX4C1", PMC1122, IBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX4C2", PMC1123, IBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX4C3", PMC1124, IBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_4, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX5C0", PMC1125, IBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX5C1", PMC1126, IBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX5C2", PMC1127, IBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX5C3", PMC1128, IBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_5, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX6C0", PMC1129, IBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX6C1", PMC1130, IBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX6C2", PMC1131, IBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX6C3", PMC1132, IBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_6, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX7C0", PMC1133, IBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX7C1", PMC1134, IBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX7C2", PMC1135, IBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX7C3", PMC1136, IBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_7, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX8C0", PMC1137, IBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX8C1", PMC1138, IBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX8C2", PMC1139, IBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX8C3", PMC1140, IBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_8, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX9C0", PMC1141, IBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX9C1", PMC1142, IBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX9C2", PMC1143, IBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX9C3", PMC1144, IBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_9, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX10C0", PMC1145, IBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX10C1", PMC1146, IBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX10C2", PMC1147, IBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX10C3", PMC1148, IBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_10, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX11C0", PMC1149, IBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX11C1", PMC1150, IBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX11C2", PMC1151, IBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX11C3", PMC1152, IBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_11, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX12C0", PMC1153, IBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX12C1", PMC1154, IBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX12C2", PMC1155, IBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX12C3", PMC1156, IBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_12, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX13C0", PMC1157, IBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX13C1", PMC1158, IBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX13C2", PMC1159, IBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX13C3", PMC1160, IBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_13, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX14C0", PMC1161, IBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX14C1", PMC1162, IBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX14C2", PMC1163, IBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX14C3", PMC1164, IBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_14, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX15C0", PMC1165, IBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX15C1", PMC1166, IBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX15C2", PMC1167, IBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
    {"IBOX15C3", PMC1168, IBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_15, GNR_VALID_OPTIONS_UNCORE},
};


static BoxMap graniterapids_box_map[NUM_UNITS] = {
    [FIXED] =  {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48},
    [PMC] = {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48},
    [THERMAL] = {0, 0, 0, 0, 0, 0, 8},
    [POWER] = {0, 0, 0, 0, 0, 0, 32},
    [VOLTAGE] = {0, 0, 0, 0, 0, 0, 16},
    [METRICS] = {0, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS, 48, 0, 0, 8},
    [CBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C0, 48},
    [CBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C1, 48},
    [CBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C2, 48},
    [CBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C3, 48},
    [CBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C4, 48},
    [CBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C5, 48},
    [CBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C6, 48},
    [CBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C7, 48},
    [CBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C8, 48},
    [CBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C9, 48},
    [CBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C10, 48},
    [CBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C11, 48},
    [CBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C12, 48},
    [CBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C13, 48},
    [CBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C14, 48},
    [CBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C15, 48},
    [CBOX16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C16, 48},
    [CBOX17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C17, 48},
    [CBOX18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C18, 48},
    [CBOX19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C19, 48},
    [CBOX20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C20, 48},
    [CBOX21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C21, 48},
    [CBOX22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C22, 48},
    [CBOX23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C23, 48},
    [CBOX24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C24, 48},
    [CBOX25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C25, 48},
    [CBOX26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C26, 48},
    [CBOX27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C27, 48},
    [CBOX28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C28, 48},
    [CBOX29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C29, 48},
    [CBOX30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C30, 48},
    [CBOX31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C31, 48},
    [CBOX32] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C32, 48},
    [CBOX33] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C33, 48},
    [CBOX34] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C34, 48},
    [CBOX35] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C35, 48},
    [CBOX36] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C36, 48},
    [CBOX37] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C37, 48},
    [CBOX38] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C38, 48},
    [CBOX39] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C39, 48},
    [CBOX40] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C40, 48},
    [CBOX41] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C41, 48},
    [CBOX42] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C42, 48},
    [CBOX43] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C43, 48},
    [CBOX44] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C44, 48},
    [CBOX45] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C45, 48},
    [CBOX46] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C46, 48},
    [CBOX47] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C47, 48},
    [CBOX48] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C48, 48},
    [CBOX49] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C49, 48},
    [CBOX50] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C50, 48},
    [CBOX51] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C51, 48},
    [CBOX52] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C52, 48},
    [CBOX53] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C53, 48},
    [CBOX54] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C54, 48},
    [CBOX55] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C55, 48},
    [CBOX56] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C56, 48},
    [CBOX57] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C57, 48},
    [CBOX58] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C58, 48},
    [CBOX59] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C59, 48},
    [CBOX60] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C60, 48},
    [CBOX61] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C61, 48},
    [CBOX62] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C62, 48},
    [CBOX63] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C63, 48},
    [CBOX64] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C64, 48},
    [CBOX65] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C65, 48},
    [CBOX66] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C66, 48},
    [CBOX67] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C67, 48},
    [CBOX68] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C68, 48},
    [CBOX69] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C69, 48},
    [CBOX70] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C70, 48},
    [CBOX71] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C71, 48},
    [CBOX72] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C72, 48},
    [CBOX73] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C73, 48},
    [CBOX74] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C74, 48},
    [CBOX75] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C75, 48},
    [CBOX76] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C76, 48},
    [CBOX77] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C77, 48},
    [CBOX78] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C78, 48},
    [CBOX79] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C79, 48},
    [CBOX80] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C80, 48},
    [CBOX81] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C81, 48},
    [CBOX82] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C82, 48},
    [CBOX83] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C83, 48},
    [CBOX84] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C84, 48},
    [CBOX85] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C85, 48},
    [CBOX86] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C86, 48},
    [CBOX87] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C87, 48},
    [CBOX88] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C88, 48},
    [CBOX89] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C89, 48},
    [CBOX90] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C90, 48},
    [CBOX91] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C91, 48},
    [CBOX92] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C92, 48},
    [CBOX93] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C93, 48},
    [CBOX94] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C94, 48},
    [CBOX95] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C95, 48},
    [CBOX96] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C96, 48},
    [CBOX97] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C97, 48},
    [CBOX98] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C98, 48},
    [CBOX99] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C99, 48},
    [CBOX100] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C100, 48},
    [CBOX101] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C101, 48},
    [CBOX102] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C102, 48},
    [CBOX103] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C103, 48},
    [CBOX104] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C104, 48},
    [CBOX105] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C105, 48},
    [CBOX106] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C106, 48},
    [CBOX107] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C107, 48},
    [CBOX108] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C108, 48},
    [CBOX109] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C109, 48},
    [CBOX110] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C110, 48},
    [CBOX111] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C111, 48},
    [CBOX112] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C112, 48},
    [CBOX113] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C113, 48},
    [CBOX114] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C114, 48},
    [CBOX115] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C115, 48},
    [CBOX116] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C116, 48},
    [CBOX117] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C117, 48},
    [CBOX118] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C118, 48},
    [CBOX119] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C119, 48},
    [CBOX120] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C120, 48},
    [CBOX121] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C121, 48},
    [CBOX122] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C122, 48},
    [CBOX123] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C123, 48},
    [CBOX124] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C124, 48},
    [CBOX125] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C125, 48},
    [MBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_0, 48},
    [MBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_1, 48},
    [MBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_2, 48},
    [MBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_3, 48},
    [MBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_4, 48},
    [MBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_5, 48},
    [MBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_6, 48},
    [MBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_7, 48},
    [MBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_0, 48},
    [MBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_1, 48},
    [MBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_2, 48},
    [MBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_3, 48},
    [WBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_PCU_DEVICE_0, 48},
    [WBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_PCU_DEVICE_1, 48},
    [WBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_PCU_DEVICE_2, 48},
    [WBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_PCU_DEVICE_3, 48},
    [WBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_PCU_DEVICE_4, 48},
    [IRP0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_0, 48},
    [IRP1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_1, 48},
    [IRP2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_2, 48},
    [IRP3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_3, 48},
    [IRP4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_4, 48},
    [IRP5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_5, 48},
    [IRP6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_6, 48},
    [IRP7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_7, 48},
    [IRP8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_8, 48},
    [IRP9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_9, 48},
    [IRP10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_10, 48},
    [IRP11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_11, 48},
    [IRP12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_12, 48},
    [IRP13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_13, 48},
    [IRP14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_14, 48},
    [IRP15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_15, 48},
    [PBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE0, 48},
    [PBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE1, 48},
    [PBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE2, 48},
    [PBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE3, 48},
    [PBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE4, 48},
    [PBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE5, 48},
    [PBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE6, 48},
    [PBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE7, 48},
    [PBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE8, 48},
    [PBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE9, 48},
    [PBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE10, 48},
    [PBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE11, 48},
    [RBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_0, 48},
    [RBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_1, 48},
    [RBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_2, 48},
    [RBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_3, 48},
    [RBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_4, 48},
    [RBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_5, 48},
    [BBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_0, 48},
    [BBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_1, 48},
    [BBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_2, 48},
    [BBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_3, 48},
    [BBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_4, 48},
    [BBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_5, 48},
    [MDF0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_0, 48},
    [MDF1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_1, 48},
    [MDF2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_2, 48},
    [MDF3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_3, 48},
    [MDF4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_4, 48},
    [MDF5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_5, 48},
    [MDF6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_6, 48},
    [MDF7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_7, 48},
    [MDF8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_8, 48},
    [MDF9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_9, 48},
    [MDF10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_10, 48},
    [MDF11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_11, 48},
    [MDF12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_12, 48},
    [MDF13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_13, 48},
    [MDF14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_14, 48},
    [MDF15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_15, 48},
    [MDF16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_16, 48},
    [MDF17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_17, 48},
    [MDF18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_18, 48},
    [MDF19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_19, 48},
    [MDF20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_20, 48},
    [MDF21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_21, 48},
    [MDF22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_22, 48},
    [MDF23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_23, 48},
    [MDF24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_24, 48},
    [MDF25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_25, 48},
    [MDF26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_26, 48},
    [MDF27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_27, 48},
    [MDF28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_28, 48},
    [MDF29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_29, 48},
    [MDF30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_30, 48},
    [MDF31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_31, 48},
    [MDF32] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_32, 48},
    [MDF33] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_33, 48},
    [MDF34] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_34, 48},
    [MDF35] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_35, 48},
    [MDF36] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_36, 48},
    [MDF37] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_37, 48},
    [MDF38] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_38, 48},
    [MDF39] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_39, 48},
    [MDF40] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_40, 48},
    [MDF41] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_41, 48},
    [MDF42] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_42, 48},
    [MDF43] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_43, 48},
    [MDF44] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_44, 48},
    [MDF45] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_45, 48},
    [MDF46] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_46, 48},
    [MDF47] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_47, 48},
    [MDF48] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_48, 48},
    [MDF49] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_49, 48},
    [MDF50] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_50, 48},
    [MDF51] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_51, 48},
    [MDF52] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_52, 48},
    [MDF53] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_53, 48},
    [MDF54] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_54, 48},
    [MDF55] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_55, 48},
    [MDF56] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_56, 48},
    [MDF57] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_57, 48},
    [MDF58] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_58, 48},
    [MDF59] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_59, 48},
    [MDF60] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_60, 48},
    [MDF61] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_61, 48},
    [MDF62] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_62, 48},
    [MDF63] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_63, 48},
    [MDF64] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_64, 48},
    [MDF65] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_65, 48},
    [MDF66] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_66, 48},
    [MDF67] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_67, 48},
    [MDF68] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_68, 48},
    [MDF69] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_69, 48},
    [MDF70] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_70, 48},
    [MDF71] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_71, 48},
    [MDF72] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_72, 48},
    [MDF73] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_73, 48},
    [MDF74] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_74, 48},
    [MDF75] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_75, 48},
    [MDF76] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_76, 48},
    [MDF77] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_77, 48},
    [MDF78] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_78, 48},
    [MDF79] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_79, 48},
    [QBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_0, 48},
    [QBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_1, 48},
    [QBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_2, 48},
    [QBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_3, 48},
    [QBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_4, 48},
    [QBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_5, 48},
    [UBOX] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_UBOX_DEVICE, 48},
    [IBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_0, 48},
    [IBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_1, 48},
    [IBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_2, 48},
    [IBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_3, 48},
    [IBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_4, 48},
    [IBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_5, 48},
    [IBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_6, 48},
    [IBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_7, 48},
    [IBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_8, 48},
    [IBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_9, 48},
    [IBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_10, 48},
    [IBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_11, 48},
    [IBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_12, 48},
    [IBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_13, 48},
    [IBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_14, 48},
    [IBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_15, 48},
};

static PciDevice graniterapids_pci_devices[MAX_NUM_PCI_DEVICES] = {
    [MSR_DEV] = {NODEVTYPE, "", "MSR", ""},
    [MMIO_IMC_DEVICE_0_CH_0] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX0", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_1] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX1", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_2] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX2", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_3] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX3", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_4] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX4", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_5] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX5", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_6] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX6", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_7] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX7", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_0] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX8", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_1] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX9", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_2] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX10", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_3] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX11", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_4] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX12", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_5] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX13", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_6] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX14", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_7] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX15", 0x3451},
};

static char* graniterapids_translate_types[NUM_UNITS] = {
    [FIXED] = "/sys/bus/event_source/devices/cpu",
    [PMC] = "/sys/bus/event_source/devices/cpu",
    // I don't get it to work, so no TMA metrics with perf_event at the moment
    //[METRICS] = "/sys/bus/event_source/devices/cpu",
    [POWER] = "/sys/bus/event_source/devices/power",
    [CBOX0] = "/sys/bus/event_source/devices/uncore_cha_0 /sys/bus/event_source/devices/uncore_type_0_0",
    [CBOX1] = "/sys/bus/event_source/devices/uncore_cha_1 /sys/bus/event_source/devices/uncore_type_0_1",
    [CBOX2] = "/sys/bus/event_source/devices/uncore_cha_2 /sys/bus/event_source/devices/uncore_type_0_2",
    [CBOX3] = "/sys/bus/event_source/devices/uncore_cha_3 /sys/bus/event_source/devices/uncore_type_0_3",
    [CBOX4] = "/sys/bus/event_source/devices/uncore_cha_4 /sys/bus/event_source/devices/uncore_type_0_4",
    [CBOX5] = "/sys/bus/event_source/devices/uncore_cha_5 /sys/bus/event_source/devices/uncore_type_0_5",
    [CBOX6] = "/sys/bus/event_source/devices/uncore_cha_6 /sys/bus/event_source/devices/uncore_type_0_6",
    [CBOX7] = "/sys/bus/event_source/devices/uncore_cha_7 /sys/bus/event_source/devices/uncore_type_0_7",
    [CBOX8] = "/sys/bus/event_source/devices/uncore_cha_8 /sys/bus/event_source/devices/uncore_type_0_8",
    [CBOX9] = "/sys/bus/event_source/devices/uncore_cha_9 /sys/bus/event_source/devices/uncore_type_0_9",
    [CBOX10] = "/sys/bus/event_source/devices/uncore_cha_10 /sys/bus/event_source/devices/uncore_type_0_10",
    [CBOX11] = "/sys/bus/event_source/devices/uncore_cha_11 /sys/bus/event_source/devices/uncore_type_0_11",
    [CBOX12] = "/sys/bus/event_source/devices/uncore_cha_12 /sys/bus/event_source/devices/uncore_type_0_12",
    [CBOX13] = "/sys/bus/event_source/devices/uncore_cha_13 /sys/bus/event_source/devices/uncore_type_0_13",
    [CBOX14] = "/sys/bus/event_source/devices/uncore_cha_14 /sys/bus/event_source/devices/uncore_type_0_14",
    [CBOX15] = "/sys/bus/event_source/devices/uncore_cha_15 /sys/bus/event_source/devices/uncore_type_0_15",
    [CBOX16] = "/sys/bus/event_source/devices/uncore_cha_16 /sys/bus/event_source/devices/uncore_type_0_16",
    [CBOX17] = "/sys/bus/event_source/devices/uncore_cha_17 /sys/bus/event_source/devices/uncore_type_0_17",
    [CBOX18] = "/sys/bus/event_source/devices/uncore_cha_18 /sys/bus/event_source/devices/uncore_type_0_18",
    [CBOX19] = "/sys/bus/event_source/devices/uncore_cha_19 /sys/bus/event_source/devices/uncore_type_0_19",
    [CBOX20] = "/sys/bus/event_source/devices/uncore_cha_20 /sys/bus/event_source/devices/uncore_type_0_20",
    [CBOX21] = "/sys/bus/event_source/devices/uncore_cha_21 /sys/bus/event_source/devices/uncore_type_0_21",
    [CBOX22] = "/sys/bus/event_source/devices/uncore_cha_22 /sys/bus/event_source/devices/uncore_type_0_22",
    [CBOX23] = "/sys/bus/event_source/devices/uncore_cha_23 /sys/bus/event_source/devices/uncore_type_0_23",
    [CBOX24] = "/sys/bus/event_source/devices/uncore_cha_24 /sys/bus/event_source/devices/uncore_type_0_24",
    [CBOX25] = "/sys/bus/event_source/devices/uncore_cha_25 /sys/bus/event_source/devices/uncore_type_0_25",
    [CBOX26] = "/sys/bus/event_source/devices/uncore_cha_26 /sys/bus/event_source/devices/uncore_type_0_26",
    [CBOX27] = "/sys/bus/event_source/devices/uncore_cha_27 /sys/bus/event_source/devices/uncore_type_0_27",
    [CBOX28] = "/sys/bus/event_source/devices/uncore_cha_28 /sys/bus/event_source/devices/uncore_type_0_28",
    [CBOX29] = "/sys/bus/event_source/devices/uncore_cha_29 /sys/bus/event_source/devices/uncore_type_0_29",
    [CBOX30] = "/sys/bus/event_source/devices/uncore_cha_30 /sys/bus/event_source/devices/uncore_type_0_30",
    [CBOX31] = "/sys/bus/event_source/devices/uncore_cha_31 /sys/bus/event_source/devices/uncore_type_0_31",
    [CBOX32] = "/sys/bus/event_source/devices/uncore_cha_32 /sys/bus/event_source/devices/uncore_type_0_32",
    [CBOX33] = "/sys/bus/event_source/devices/uncore_cha_33 /sys/bus/event_source/devices/uncore_type_0_33",
    [CBOX34] = "/sys/bus/event_source/devices/uncore_cha_34 /sys/bus/event_source/devices/uncore_type_0_34",
    [CBOX35] = "/sys/bus/event_source/devices/uncore_cha_35 /sys/bus/event_source/devices/uncore_type_0_35",
    [CBOX36] = "/sys/bus/event_source/devices/uncore_cha_36 /sys/bus/event_source/devices/uncore_type_0_36",
    [CBOX37] = "/sys/bus/event_source/devices/uncore_cha_37 /sys/bus/event_source/devices/uncore_type_0_37",
    [CBOX38] = "/sys/bus/event_source/devices/uncore_cha_38 /sys/bus/event_source/devices/uncore_type_0_38",
    [CBOX39] = "/sys/bus/event_source/devices/uncore_cha_39 /sys/bus/event_source/devices/uncore_type_0_39",
    [CBOX40] = "/sys/bus/event_source/devices/uncore_cha_40 /sys/bus/event_source/devices/uncore_type_0_40",
    [CBOX41] = "/sys/bus/event_source/devices/uncore_cha_41 /sys/bus/event_source/devices/uncore_type_0_41",
    [CBOX42] = "/sys/bus/event_source/devices/uncore_cha_42 /sys/bus/event_source/devices/uncore_type_0_42",
    [CBOX43] = "/sys/bus/event_source/devices/uncore_cha_43 /sys/bus/event_source/devices/uncore_type_0_43",
    [CBOX44] = "/sys/bus/event_source/devices/uncore_cha_44 /sys/bus/event_source/devices/uncore_type_0_44",
    [CBOX45] = "/sys/bus/event_source/devices/uncore_cha_45 /sys/bus/event_source/devices/uncore_type_0_45",
    [CBOX46] = "/sys/bus/event_source/devices/uncore_cha_46 /sys/bus/event_source/devices/uncore_type_0_46",
    [CBOX47] = "/sys/bus/event_source/devices/uncore_cha_47 /sys/bus/event_source/devices/uncore_type_0_47",
    [CBOX48] = "/sys/bus/event_source/devices/uncore_cha_48 /sys/bus/event_source/devices/uncore_type_0_48",
    [CBOX49] = "/sys/bus/event_source/devices/uncore_cha_49 /sys/bus/event_source/devices/uncore_type_0_49",
    [CBOX50] = "/sys/bus/event_source/devices/uncore_cha_50 /sys/bus/event_source/devices/uncore_type_0_50",
    [CBOX51] = "/sys/bus/event_source/devices/uncore_cha_51 /sys/bus/event_source/devices/uncore_type_0_51",
    [CBOX52] = "/sys/bus/event_source/devices/uncore_cha_52 /sys/bus/event_source/devices/uncore_type_0_52",
    [CBOX53] = "/sys/bus/event_source/devices/uncore_cha_53 /sys/bus/event_source/devices/uncore_type_0_53",
    [CBOX54] = "/sys/bus/event_source/devices/uncore_cha_54 /sys/bus/event_source/devices/uncore_type_0_54",
    [CBOX55] = "/sys/bus/event_source/devices/uncore_cha_55 /sys/bus/event_source/devices/uncore_type_0_55",
    [CBOX56] = "/sys/bus/event_source/devices/uncore_cha_56 /sys/bus/event_source/devices/uncore_type_0_56",
    [CBOX57] = "/sys/bus/event_source/devices/uncore_cha_57 /sys/bus/event_source/devices/uncore_type_0_57",
    [CBOX58] = "/sys/bus/event_source/devices/uncore_cha_58 /sys/bus/event_source/devices/uncore_type_0_58",
    [CBOX59] = "/sys/bus/event_source/devices/uncore_cha_59 /sys/bus/event_source/devices/uncore_type_0_59",
    [CBOX60] = "/sys/bus/event_source/devices/uncore_cha_60 /sys/bus/event_source/devices/uncore_type_0_60",
    [CBOX61] = "/sys/bus/event_source/devices/uncore_cha_61 /sys/bus/event_source/devices/uncore_type_0_61",
    [CBOX62] = "/sys/bus/event_source/devices/uncore_cha_62 /sys/bus/event_source/devices/uncore_type_0_62",
    [CBOX63] = "/sys/bus/event_source/devices/uncore_cha_63 /sys/bus/event_source/devices/uncore_type_0_63",
    [CBOX64] = "/sys/bus/event_source/devices/uncore_cha_64 /sys/bus/event_source/devices/uncore_type_0_64",
    [CBOX65] = "/sys/bus/event_source/devices/uncore_cha_65 /sys/bus/event_source/devices/uncore_type_0_65",
    [CBOX66] = "/sys/bus/event_source/devices/uncore_cha_66 /sys/bus/event_source/devices/uncore_type_0_66",
    [CBOX67] = "/sys/bus/event_source/devices/uncore_cha_67 /sys/bus/event_source/devices/uncore_type_0_67",
    [CBOX68] = "/sys/bus/event_source/devices/uncore_cha_68 /sys/bus/event_source/devices/uncore_type_0_68",
    [CBOX69] = "/sys/bus/event_source/devices/uncore_cha_69 /sys/bus/event_source/devices/uncore_type_0_69",
    [CBOX70] = "/sys/bus/event_source/devices/uncore_cha_70 /sys/bus/event_source/devices/uncore_type_0_70",
    [CBOX71] = "/sys/bus/event_source/devices/uncore_cha_71 /sys/bus/event_source/devices/uncore_type_0_71",
    [CBOX72] = "/sys/bus/event_source/devices/uncore_cha_72 /sys/bus/event_source/devices/uncore_type_0_72",
    [CBOX73] = "/sys/bus/event_source/devices/uncore_cha_73 /sys/bus/event_source/devices/uncore_type_0_73",
    [CBOX74] = "/sys/bus/event_source/devices/uncore_cha_74 /sys/bus/event_source/devices/uncore_type_0_74",
    [CBOX75] = "/sys/bus/event_source/devices/uncore_cha_75 /sys/bus/event_source/devices/uncore_type_0_75",
    [CBOX76] = "/sys/bus/event_source/devices/uncore_cha_76 /sys/bus/event_source/devices/uncore_type_0_76",
    [CBOX77] = "/sys/bus/event_source/devices/uncore_cha_77 /sys/bus/event_source/devices/uncore_type_0_77",
    [CBOX78] = "/sys/bus/event_source/devices/uncore_cha_78 /sys/bus/event_source/devices/uncore_type_0_78",
    [CBOX79] = "/sys/bus/event_source/devices/uncore_cha_79 /sys/bus/event_source/devices/uncore_type_0_79",
    [CBOX80] = "/sys/bus/event_source/devices/uncore_cha_80 /sys/bus/event_source/devices/uncore_type_0_80",
    [CBOX81] = "/sys/bus/event_source/devices/uncore_cha_81 /sys/bus/event_source/devices/uncore_type_0_81",
    [CBOX82] = "/sys/bus/event_source/devices/uncore_cha_82 /sys/bus/event_source/devices/uncore_type_0_82",
    [CBOX83] = "/sys/bus/event_source/devices/uncore_cha_83 /sys/bus/event_source/devices/uncore_type_0_83",
    [CBOX84] = "/sys/bus/event_source/devices/uncore_cha_84 /sys/bus/event_source/devices/uncore_type_0_84",
    [CBOX85] = "/sys/bus/event_source/devices/uncore_cha_85 /sys/bus/event_source/devices/uncore_type_0_85",
    [CBOX86] = "/sys/bus/event_source/devices/uncore_cha_86 /sys/bus/event_source/devices/uncore_type_0_86",
    [CBOX87] = "/sys/bus/event_source/devices/uncore_cha_87 /sys/bus/event_source/devices/uncore_type_0_87",
    [CBOX88] = "/sys/bus/event_source/devices/uncore_cha_88 /sys/bus/event_source/devices/uncore_type_0_88",
    [CBOX89] = "/sys/bus/event_source/devices/uncore_cha_89 /sys/bus/event_source/devices/uncore_type_0_89",
    [CBOX90] = "/sys/bus/event_source/devices/uncore_cha_90 /sys/bus/event_source/devices/uncore_type_0_90",
    [CBOX91] = "/sys/bus/event_source/devices/uncore_cha_91 /sys/bus/event_source/devices/uncore_type_0_91",
    [CBOX92] = "/sys/bus/event_source/devices/uncore_cha_92 /sys/bus/event_source/devices/uncore_type_0_92",
    [CBOX93] = "/sys/bus/event_source/devices/uncore_cha_93 /sys/bus/event_source/devices/uncore_type_0_93",
    [CBOX94] = "/sys/bus/event_source/devices/uncore_cha_94 /sys/bus/event_source/devices/uncore_type_0_94",
    [CBOX95] = "/sys/bus/event_source/devices/uncore_cha_95 /sys/bus/event_source/devices/uncore_type_0_95",
    [CBOX96] = "/sys/bus/event_source/devices/uncore_cha_96 /sys/bus/event_source/devices/uncore_type_0_96",
    [CBOX97] = "/sys/bus/event_source/devices/uncore_cha_97 /sys/bus/event_source/devices/uncore_type_0_97",
    [CBOX98] = "/sys/bus/event_source/devices/uncore_cha_98 /sys/bus/event_source/devices/uncore_type_0_98",
    [CBOX99] = "/sys/bus/event_source/devices/uncore_cha_99 /sys/bus/event_source/devices/uncore_type_0_99",
    [CBOX100] = "/sys/bus/event_source/devices/uncore_cha_100 /sys/bus/event_source/devices/uncore_type_0_100",
    [CBOX101] = "/sys/bus/event_source/devices/uncore_cha_101 /sys/bus/event_source/devices/uncore_type_0_101",
    [CBOX102] = "/sys/bus/event_source/devices/uncore_cha_102 /sys/bus/event_source/devices/uncore_type_0_102",
    [CBOX103] = "/sys/bus/event_source/devices/uncore_cha_103 /sys/bus/event_source/devices/uncore_type_0_103",
    [CBOX104] = "/sys/bus/event_source/devices/uncore_cha_104 /sys/bus/event_source/devices/uncore_type_0_104",
    [CBOX105] = "/sys/bus/event_source/devices/uncore_cha_105 /sys/bus/event_source/devices/uncore_type_0_105",
    [CBOX106] = "/sys/bus/event_source/devices/uncore_cha_106 /sys/bus/event_source/devices/uncore_type_0_106",
    [CBOX107] = "/sys/bus/event_source/devices/uncore_cha_107 /sys/bus/event_source/devices/uncore_type_0_107",
    [CBOX108] = "/sys/bus/event_source/devices/uncore_cha_108 /sys/bus/event_source/devices/uncore_type_0_108",
    [CBOX109] = "/sys/bus/event_source/devices/uncore_cha_109 /sys/bus/event_source/devices/uncore_type_0_109",
    [CBOX110] = "/sys/bus/event_source/devices/uncore_cha_110 /sys/bus/event_source/devices/uncore_type_0_110",
    [CBOX111] = "/sys/bus/event_source/devices/uncore_cha_111 /sys/bus/event_source/devices/uncore_type_0_111",
    [CBOX112] = "/sys/bus/event_source/devices/uncore_cha_112 /sys/bus/event_source/devices/uncore_type_0_112",
    [CBOX113] = "/sys/bus/event_source/devices/uncore_cha_113 /sys/bus/event_source/devices/uncore_type_0_113",
    [CBOX114] = "/sys/bus/event_source/devices/uncore_cha_114 /sys/bus/event_source/devices/uncore_type_0_114",
    [CBOX115] = "/sys/bus/event_source/devices/uncore_cha_115 /sys/bus/event_source/devices/uncore_type_0_115",
    [CBOX116] = "/sys/bus/event_source/devices/uncore_cha_116 /sys/bus/event_source/devices/uncore_type_0_116",
    [CBOX117] = "/sys/bus/event_source/devices/uncore_cha_117 /sys/bus/event_source/devices/uncore_type_0_117",
    [CBOX118] = "/sys/bus/event_source/devices/uncore_cha_118 /sys/bus/event_source/devices/uncore_type_0_118",
    [CBOX119] = "/sys/bus/event_source/devices/uncore_cha_119 /sys/bus/event_source/devices/uncore_type_0_119",
    [CBOX120] = "/sys/bus/event_source/devices/uncore_cha_120 /sys/bus/event_source/devices/uncore_type_0_120",
    [CBOX121] = "/sys/bus/event_source/devices/uncore_cha_121 /sys/bus/event_source/devices/uncore_type_0_121",
    [CBOX122] = "/sys/bus/event_source/devices/uncore_cha_122 /sys/bus/event_source/devices/uncore_type_0_122",
    [CBOX123] = "/sys/bus/event_source/devices/uncore_cha_123 /sys/bus/event_source/devices/uncore_type_0_123",
    [CBOX124] = "/sys/bus/event_source/devices/uncore_cha_124 /sys/bus/event_source/devices/uncore_type_0_124",
    [CBOX125] = "/sys/bus/event_source/devices/uncore_cha_125 /sys/bus/event_source/devices/uncore_type_0_125",
    [MBOX0] = "/sys/bus/event_source/devices/uncore_imc_0 /sys/bus/event_source/devices/uncore_type_6_0",
    [MBOX1] = "/sys/bus/event_source/devices/uncore_imc_1 /sys/bus/event_source/devices/uncore_type_6_1",
    [MBOX2] = "/sys/bus/event_source/devices/uncore_imc_2 /sys/bus/event_source/devices/uncore_type_6_2",
    [MBOX3] = "/sys/bus/event_source/devices/uncore_imc_3 /sys/bus/event_source/devices/uncore_type_6_3",
    [MBOX4] = "/sys/bus/event_source/devices/uncore_imc_4 /sys/bus/event_source/devices/uncore_type_6_4",
    [MBOX5] = "/sys/bus/event_source/devices/uncore_imc_5 /sys/bus/event_source/devices/uncore_type_6_5",
    [MBOX6] = "/sys/bus/event_source/devices/uncore_imc_6 /sys/bus/event_source/devices/uncore_type_6_6",
    [MBOX7] = "/sys/bus/event_source/devices/uncore_imc_7 /sys/bus/event_source/devices/uncore_type_6_7",
    [MBOX8] = "/sys/bus/event_source/devices/uncore_imc_8 /sys/bus/event_source/devices/uncore_type_6_8",
    [MBOX9] = "/sys/bus/event_source/devices/uncore_imc_9 /sys/bus/event_source/devices/uncore_type_6_9",
    [MBOX10] = "/sys/bus/event_source/devices/uncore_imc_10 /sys/bus/event_source/devices/uncore_type_6_10",
    [MBOX11] = "/sys/bus/event_source/devices/uncore_imc_11 /sys/bus/event_source/devices/uncore_type_6_11",
    [WBOX0] = "/sys/bus/event_source/devices/uncore_pcu_0 /sys/bus/event_source/devices/uncore_type_4_0",
    [WBOX1] = "/sys/bus/event_source/devices/uncore_pcu_1 /sys/bus/event_source/devices/uncore_type_4_1",
    [WBOX2] = "/sys/bus/event_source/devices/uncore_pcu_2 /sys/bus/event_source/devices/uncore_type_4_2",
    [WBOX3] = "/sys/bus/event_source/devices/uncore_pcu_3 /sys/bus/event_source/devices/uncore_type_4_3",
    [WBOX4] = "/sys/bus/event_source/devices/uncore_pcu_4 /sys/bus/event_source/devices/uncore_type_4_4",
    [IRP0] = "/sys/bus/event_source/devices/uncore_irp_0 /sys/bus/event_source/devices/uncore_type_2_0",
    [IRP1] = "/sys/bus/event_source/devices/uncore_irp_1 /sys/bus/event_source/devices/uncore_type_2_1",
    [IRP2] = "/sys/bus/event_source/devices/uncore_irp_2 /sys/bus/event_source/devices/uncore_type_2_2",
    [IRP3] = "/sys/bus/event_source/devices/uncore_irp_3 /sys/bus/event_source/devices/uncore_type_2_3",
    [IRP4] = "/sys/bus/event_source/devices/uncore_irp_4 /sys/bus/event_source/devices/uncore_type_2_4",
    [IRP5] = "/sys/bus/event_source/devices/uncore_irp_5 /sys/bus/event_source/devices/uncore_type_2_5",
    [IRP6] = "/sys/bus/event_source/devices/uncore_irp_6 /sys/bus/event_source/devices/uncore_type_2_6",
    [IRP7] = "/sys/bus/event_source/devices/uncore_irp_7 /sys/bus/event_source/devices/uncore_type_2_7",
    [IRP8] = "/sys/bus/event_source/devices/uncore_irp_8 /sys/bus/event_source/devices/uncore_type_2_8",
    [IRP9] = "/sys/bus/event_source/devices/uncore_irp_9 /sys/bus/event_source/devices/uncore_type_2_9",
    [IRP10] = "/sys/bus/event_source/devices/uncore_irp_10 /sys/bus/event_source/devices/uncore_type_2_10",
    [IRP11] = "/sys/bus/event_source/devices/uncore_irp_11 /sys/bus/event_source/devices/uncore_type_2_11",
    [IRP12] = "/sys/bus/event_source/devices/uncore_irp_12 /sys/bus/event_source/devices/uncore_type_2_12",
    [IRP13] = "/sys/bus/event_source/devices/uncore_irp_13 /sys/bus/event_source/devices/uncore_type_2_13",
    [IRP14] = "/sys/bus/event_source/devices/uncore_irp_14 /sys/bus/event_source/devices/uncore_type_2_14",
    [IRP15] = "/sys/bus/event_source/devices/uncore_irp_15 /sys/bus/event_source/devices/uncore_type_2_15",
    [PBOX0] = "/sys/bus/event_source/devices/uncore_b2cxl_0 /sys/bus/event_source/devices/uncore_type_17_0",
    [PBOX1] = "/sys/bus/event_source/devices/uncore_b2cxl_1 /sys/bus/event_source/devices/uncore_type_17_1",
    [PBOX2] = "/sys/bus/event_source/devices/uncore_b2cxl_2 /sys/bus/event_source/devices/uncore_type_17_2",
    [PBOX3] = "/sys/bus/event_source/devices/uncore_b2cxl_3 /sys/bus/event_source/devices/uncore_type_17_3",
    [PBOX4] = "/sys/bus/event_source/devices/uncore_b2cxl_4 /sys/bus/event_source/devices/uncore_type_17_4",
    [PBOX5] = "/sys/bus/event_source/devices/uncore_b2cxl_5 /sys/bus/event_source/devices/uncore_type_17_5",
    [PBOX6] = "/sys/bus/event_source/devices/uncore_b2cxl_6 /sys/bus/event_source/devices/uncore_type_17_6",
    [PBOX7] = "/sys/bus/event_source/devices/uncore_b2cxl_7 /sys/bus/event_source/devices/uncore_type_17_7",
    [PBOX8] = "/sys/bus/event_source/devices/uncore_b2cxl_8 /sys/bus/event_source/devices/uncore_type_17_8",
    [PBOX9] = "/sys/bus/event_source/devices/uncore_b2cxl_9 /sys/bus/event_source/devices/uncore_type_17_9",
    [PBOX10] = "/sys/bus/event_source/devices/uncore_b2cxl_10 /sys/bus/event_source/devices/uncore_type_17_10",
    [PBOX11] = "/sys/bus/event_source/devices/uncore_b2cxl_11 /sys/bus/event_source/devices/uncore_type_17_11",
    [RBOX0] = "/sys/bus/event_source/devices/uncore_b2upi_0 /sys/bus/event_source/devices/uncore_type_18_0",
    [RBOX1] = "/sys/bus/event_source/devices/uncore_b2upi_1 /sys/bus/event_source/devices/uncore_type_18_1",
    [RBOX2] = "/sys/bus/event_source/devices/uncore_b2upi_2 /sys/bus/event_source/devices/uncore_type_18_2",
    [RBOX3] = "/sys/bus/event_source/devices/uncore_b2upi_3 /sys/bus/event_source/devices/uncore_type_18_3",
    [RBOX4] = "/sys/bus/event_source/devices/uncore_b2upi_4 /sys/bus/event_source/devices/uncore_type_18_4",
    [RBOX5] = "/sys/bus/event_source/devices/uncore_b2upi_5 /sys/bus/event_source/devices/uncore_type_18_5",
    [BBOX0] = "/sys/bus/event_source/devices/uncore_b2cmi_0 /sys/bus/event_source/devices/uncore_type_16_0",
    [BBOX1] = "/sys/bus/event_source/devices/uncore_b2cmi_1 /sys/bus/event_source/devices/uncore_type_16_1",
    [BBOX2] = "/sys/bus/event_source/devices/uncore_b2cmi_2 /sys/bus/event_source/devices/uncore_type_16_2",
    [BBOX3] = "/sys/bus/event_source/devices/uncore_b2cmi_3 /sys/bus/event_source/devices/uncore_type_16_3",
    [BBOX4] = "/sys/bus/event_source/devices/uncore_b2cmi_4 /sys/bus/event_source/devices/uncore_type_16_4",
    [BBOX5] = "/sys/bus/event_source/devices/uncore_b2cmi_5 /sys/bus/event_source/devices/uncore_type_16_5",
    [MDF0] = "/sys/bus/event_source/devices/uncore_mdf_sbo_0 /sys/bus/event_source/devices/uncore_type_20_0",
    [MDF1] = "/sys/bus/event_source/devices/uncore_mdf_sbo_1 /sys/bus/event_source/devices/uncore_type_20_1",
    [MDF2] = "/sys/bus/event_source/devices/uncore_mdf_sbo_2 /sys/bus/event_source/devices/uncore_type_20_2",
    [MDF3] = "/sys/bus/event_source/devices/uncore_mdf_sbo_3 /sys/bus/event_source/devices/uncore_type_20_3",
    [MDF4] = "/sys/bus/event_source/devices/uncore_mdf_sbo_4 /sys/bus/event_source/devices/uncore_type_20_4",
    [MDF5] = "/sys/bus/event_source/devices/uncore_mdf_sbo_5 /sys/bus/event_source/devices/uncore_type_20_5",
    [MDF6] = "/sys/bus/event_source/devices/uncore_mdf_sbo_6 /sys/bus/event_source/devices/uncore_type_20_6",
    [MDF7] = "/sys/bus/event_source/devices/uncore_mdf_sbo_7 /sys/bus/event_source/devices/uncore_type_20_7",
    [MDF8] = "/sys/bus/event_source/devices/uncore_mdf_sbo_8 /sys/bus/event_source/devices/uncore_type_20_8",
    [MDF9] = "/sys/bus/event_source/devices/uncore_mdf_sbo_9 /sys/bus/event_source/devices/uncore_type_20_9",
    [MDF10] = "/sys/bus/event_source/devices/uncore_mdf_sbo_10 /sys/bus/event_source/devices/uncore_type_20_10",
    [MDF11] = "/sys/bus/event_source/devices/uncore_mdf_sbo_11 /sys/bus/event_source/devices/uncore_type_20_11",
    [MDF12] = "/sys/bus/event_source/devices/uncore_mdf_sbo_12 /sys/bus/event_source/devices/uncore_type_20_12",
    [MDF13] = "/sys/bus/event_source/devices/uncore_mdf_sbo_13 /sys/bus/event_source/devices/uncore_type_20_13",
    [MDF14] = "/sys/bus/event_source/devices/uncore_mdf_sbo_14 /sys/bus/event_source/devices/uncore_type_20_14",
    [MDF15] = "/sys/bus/event_source/devices/uncore_mdf_sbo_15 /sys/bus/event_source/devices/uncore_type_20_15",
    [MDF16] = "/sys/bus/event_source/devices/uncore_mdf_sbo_16 /sys/bus/event_source/devices/uncore_type_20_16",
    [MDF17] = "/sys/bus/event_source/devices/uncore_mdf_sbo_17 /sys/bus/event_source/devices/uncore_type_20_17",
    [MDF18] = "/sys/bus/event_source/devices/uncore_mdf_sbo_18 /sys/bus/event_source/devices/uncore_type_20_18",
    [MDF19] = "/sys/bus/event_source/devices/uncore_mdf_sbo_19 /sys/bus/event_source/devices/uncore_type_20_19",
    [MDF20] = "/sys/bus/event_source/devices/uncore_mdf_sbo_20 /sys/bus/event_source/devices/uncore_type_20_20",
    [MDF21] = "/sys/bus/event_source/devices/uncore_mdf_sbo_21 /sys/bus/event_source/devices/uncore_type_20_21",
    [MDF22] = "/sys/bus/event_source/devices/uncore_mdf_sbo_22 /sys/bus/event_source/devices/uncore_type_20_22",
    [MDF23] = "/sys/bus/event_source/devices/uncore_mdf_sbo_23 /sys/bus/event_source/devices/uncore_type_20_23",
    [MDF24] = "/sys/bus/event_source/devices/uncore_mdf_sbo_24 /sys/bus/event_source/devices/uncore_type_20_24",
    [MDF25] = "/sys/bus/event_source/devices/uncore_mdf_sbo_25 /sys/bus/event_source/devices/uncore_type_20_25",
    [MDF26] = "/sys/bus/event_source/devices/uncore_mdf_sbo_26 /sys/bus/event_source/devices/uncore_type_20_26",
    [MDF27] = "/sys/bus/event_source/devices/uncore_mdf_sbo_27 /sys/bus/event_source/devices/uncore_type_20_27",
    [MDF28] = "/sys/bus/event_source/devices/uncore_mdf_sbo_28 /sys/bus/event_source/devices/uncore_type_20_28",
    [MDF29] = "/sys/bus/event_source/devices/uncore_mdf_sbo_29 /sys/bus/event_source/devices/uncore_type_20_29",
    [MDF30] = "/sys/bus/event_source/devices/uncore_mdf_sbo_30 /sys/bus/event_source/devices/uncore_type_20_30",
    [MDF31] = "/sys/bus/event_source/devices/uncore_mdf_sbo_31 /sys/bus/event_source/devices/uncore_type_20_31",
    [MDF32] = "/sys/bus/event_source/devices/uncore_mdf_sbo_32 /sys/bus/event_source/devices/uncore_type_20_32",
    [MDF33] = "/sys/bus/event_source/devices/uncore_mdf_sbo_33 /sys/bus/event_source/devices/uncore_type_20_33",
    [MDF34] = "/sys/bus/event_source/devices/uncore_mdf_sbo_34 /sys/bus/event_source/devices/uncore_type_20_34",
    [MDF35] = "/sys/bus/event_source/devices/uncore_mdf_sbo_35 /sys/bus/event_source/devices/uncore_type_20_35",
    [MDF36] = "/sys/bus/event_source/devices/uncore_mdf_sbo_36 /sys/bus/event_source/devices/uncore_type_20_36",
    [MDF37] = "/sys/bus/event_source/devices/uncore_mdf_sbo_37 /sys/bus/event_source/devices/uncore_type_20_37",
    [MDF38] = "/sys/bus/event_source/devices/uncore_mdf_sbo_38 /sys/bus/event_source/devices/uncore_type_20_38",
    [MDF39] = "/sys/bus/event_source/devices/uncore_mdf_sbo_39 /sys/bus/event_source/devices/uncore_type_20_39",
    [MDF40] = "/sys/bus/event_source/devices/uncore_mdf_sbo_40 /sys/bus/event_source/devices/uncore_type_20_40",
    [MDF41] = "/sys/bus/event_source/devices/uncore_mdf_sbo_41 /sys/bus/event_source/devices/uncore_type_20_41",
    [MDF42] = "/sys/bus/event_source/devices/uncore_mdf_sbo_42 /sys/bus/event_source/devices/uncore_type_20_42",
    [MDF43] = "/sys/bus/event_source/devices/uncore_mdf_sbo_43 /sys/bus/event_source/devices/uncore_type_20_43",
    [MDF44] = "/sys/bus/event_source/devices/uncore_mdf_sbo_44 /sys/bus/event_source/devices/uncore_type_20_44",
    [MDF45] = "/sys/bus/event_source/devices/uncore_mdf_sbo_45 /sys/bus/event_source/devices/uncore_type_20_45",
    [MDF46] = "/sys/bus/event_source/devices/uncore_mdf_sbo_46 /sys/bus/event_source/devices/uncore_type_20_46",
    [MDF47] = "/sys/bus/event_source/devices/uncore_mdf_sbo_47 /sys/bus/event_source/devices/uncore_type_20_47",
    [MDF48] = "/sys/bus/event_source/devices/uncore_mdf_sbo_48 /sys/bus/event_source/devices/uncore_type_20_48",
    [MDF49] = "/sys/bus/event_source/devices/uncore_mdf_sbo_49 /sys/bus/event_source/devices/uncore_type_20_49",
    [MDF50] = "/sys/bus/event_source/devices/uncore_mdf_sbo_50 /sys/bus/event_source/devices/uncore_type_20_50",
    [MDF51] = "/sys/bus/event_source/devices/uncore_mdf_sbo_51 /sys/bus/event_source/devices/uncore_type_20_51",
    [MDF52] = "/sys/bus/event_source/devices/uncore_mdf_sbo_52 /sys/bus/event_source/devices/uncore_type_20_52",
    [MDF53] = "/sys/bus/event_source/devices/uncore_mdf_sbo_53 /sys/bus/event_source/devices/uncore_type_20_53",
    [MDF54] = "/sys/bus/event_source/devices/uncore_mdf_sbo_54 /sys/bus/event_source/devices/uncore_type_20_54",
    [MDF55] = "/sys/bus/event_source/devices/uncore_mdf_sbo_55 /sys/bus/event_source/devices/uncore_type_20_55",
    [MDF56] = "/sys/bus/event_source/devices/uncore_mdf_sbo_56 /sys/bus/event_source/devices/uncore_type_20_56",
    [MDF57] = "/sys/bus/event_source/devices/uncore_mdf_sbo_57 /sys/bus/event_source/devices/uncore_type_20_57",
    [MDF58] = "/sys/bus/event_source/devices/uncore_mdf_sbo_58 /sys/bus/event_source/devices/uncore_type_20_58",
    [MDF59] = "/sys/bus/event_source/devices/uncore_mdf_sbo_59 /sys/bus/event_source/devices/uncore_type_20_59",
    [MDF60] = "/sys/bus/event_source/devices/uncore_mdf_sbo_60 /sys/bus/event_source/devices/uncore_type_20_60",
    [MDF61] = "/sys/bus/event_source/devices/uncore_mdf_sbo_61 /sys/bus/event_source/devices/uncore_type_20_61",
    [MDF62] = "/sys/bus/event_source/devices/uncore_mdf_sbo_62 /sys/bus/event_source/devices/uncore_type_20_62",
    [MDF63] = "/sys/bus/event_source/devices/uncore_mdf_sbo_63 /sys/bus/event_source/devices/uncore_type_20_63",
    [MDF64] = "/sys/bus/event_source/devices/uncore_mdf_sbo_64 /sys/bus/event_source/devices/uncore_type_20_64",
    [MDF65] = "/sys/bus/event_source/devices/uncore_mdf_sbo_65 /sys/bus/event_source/devices/uncore_type_20_65",
    [MDF66] = "/sys/bus/event_source/devices/uncore_mdf_sbo_66 /sys/bus/event_source/devices/uncore_type_20_66",
    [MDF67] = "/sys/bus/event_source/devices/uncore_mdf_sbo_67 /sys/bus/event_source/devices/uncore_type_20_67",
    [MDF68] = "/sys/bus/event_source/devices/uncore_mdf_sbo_68 /sys/bus/event_source/devices/uncore_type_20_68",
    [MDF69] = "/sys/bus/event_source/devices/uncore_mdf_sbo_69 /sys/bus/event_source/devices/uncore_type_20_69",
    [MDF70] = "/sys/bus/event_source/devices/uncore_mdf_sbo_70 /sys/bus/event_source/devices/uncore_type_20_70",
    [MDF71] = "/sys/bus/event_source/devices/uncore_mdf_sbo_71 /sys/bus/event_source/devices/uncore_type_20_71",
    [MDF72] = "/sys/bus/event_source/devices/uncore_mdf_sbo_72 /sys/bus/event_source/devices/uncore_type_20_72",
    [MDF73] = "/sys/bus/event_source/devices/uncore_mdf_sbo_73 /sys/bus/event_source/devices/uncore_type_20_73",
    [MDF74] = "/sys/bus/event_source/devices/uncore_mdf_sbo_74 /sys/bus/event_source/devices/uncore_type_20_74",
    [MDF75] = "/sys/bus/event_source/devices/uncore_mdf_sbo_75 /sys/bus/event_source/devices/uncore_type_20_75",
    [MDF76] = "/sys/bus/event_source/devices/uncore_mdf_sbo_76 /sys/bus/event_source/devices/uncore_type_20_76",
    [MDF77] = "/sys/bus/event_source/devices/uncore_mdf_sbo_77 /sys/bus/event_source/devices/uncore_type_20_77",
    [MDF78] = "/sys/bus/event_source/devices/uncore_mdf_sbo_78 /sys/bus/event_source/devices/uncore_type_20_78",
    [MDF79] = "/sys/bus/event_source/devices/uncore_mdf_sbo_79 /sys/bus/event_source/devices/uncore_type_20_79",
    [QBOX0] = "/sys/bus/event_source/devices/uncore_upi_0 /sys/bus/event_source/devices/uncore_type_8_0",
    [QBOX1] = "/sys/bus/event_source/devices/uncore_upi_1 /sys/bus/event_source/devices/uncore_type_8_1",
    [QBOX2] = "/sys/bus/event_source/devices/uncore_upi_2 /sys/bus/event_source/devices/uncore_type_8_2",
    [QBOX3] = "/sys/bus/event_source/devices/uncore_upi_3 /sys/bus/event_source/devices/uncore_type_8_3",
    [QBOX4] = "/sys/bus/event_source/devices/uncore_upi_4 /sys/bus/event_source/devices/uncore_type_8_4",
    [QBOX5] = "/sys/bus/event_source/devices/uncore_upi_5 /sys/bus/event_source/devices/uncore_type_8_5",
    [UBOX] = "/sys/bus/event_source/devices/uncore_ubox /sys/bus/event_source/devices/uncore_type_5_0",
    [IBOX0] = "/sys/bus/event_source/devices/uncore_iio_0 /sys/bus/event_source/devices/uncore_type_1_0",
    [IBOX1] = "/sys/bus/event_source/devices/uncore_iio_1 /sys/bus/event_source/devices/uncore_type_1_1",
    [IBOX2] = "/sys/bus/event_source/devices/uncore_iio_2 /sys/bus/event_source/devices/uncore_type_1_2",
    [IBOX3] = "/sys/bus/event_source/devices/uncore_iio_3 /sys/bus/event_source/devices/uncore_type_1_3",
    [IBOX4] = "/sys/bus/event_source/devices/uncore_iio_4 /sys/bus/event_source/devices/uncore_type_1_4",
    [IBOX5] = "/sys/bus/event_source/devices/uncore_iio_5 /sys/bus/event_source/devices/uncore_type_1_5",
    [IBOX6] = "/sys/bus/event_source/devices/uncore_iio_6 /sys/bus/event_source/devices/uncore_type_1_6",
    [IBOX7] = "/sys/bus/event_source/devices/uncore_iio_7 /sys/bus/event_source/devices/uncore_type_1_7",
    [IBOX8] = "/sys/bus/event_source/devices/uncore_iio_8 /sys/bus/event_source/devices/uncore_type_1_8",
    [IBOX9] = "/sys/bus/event_source/devices/uncore_iio_9 /sys/bus/event_source/devices/uncore_type_1_9",
    [IBOX10] = "/sys/bus/event_source/devices/uncore_iio_10 /sys/bus/event_source/devices/uncore_type_1_10",
    [IBOX11] = "/sys/bus/event_source/devices/uncore_iio_11 /sys/bus/event_source/devices/uncore_type_1_11",
    [IBOX12] = "/sys/bus/event_source/devices/uncore_iio_12 /sys/bus/event_source/devices/uncore_type_1_12",
    [IBOX13] = "/sys/bus/event_source/devices/uncore_iio_13 /sys/bus/event_source/devices/uncore_type_1_13",
    [IBOX14] = "/sys/bus/event_source/devices/uncore_iio_14 /sys/bus/event_source/devices/uncore_type_1_14",
    [IBOX15] = "/sys/bus/event_source/devices/uncore_iio_15 /sys/bus/event_source/devices/uncore_type_1_15",
};

static char* registerTypeNamesGraniteRapids[MAX_UNITS] = {
    [CBOX0] = "Caching home agent 0",
    [CBOX1] = "Caching home agent 1",
    [CBOX2] = "Caching home agent 2",
    [CBOX3] = "Caching home agent 3",
    [CBOX4] = "Caching home agent 4",
    [CBOX5] = "Caching home agent 5",
    [CBOX6] = "Caching home agent 6",
    [CBOX7] = "Caching home agent 7",
    [CBOX8] = "Caching home agent 8",
    [CBOX9] = "Caching home agent 9",
    [CBOX10] = "Caching home agent 10",
    [CBOX11] = "Caching home agent 11",
    [CBOX12] = "Caching home agent 12",
    [CBOX13] = "Caching home agent 13",
    [CBOX14] = "Caching home agent 14",
    [CBOX15] = "Caching home agent 15",
    [CBOX16] = "Caching home agent 16",
    [CBOX17] = "Caching home agent 17",
    [CBOX18] = "Caching home agent 18",
    [CBOX19] = "Caching home agent 19",
    [CBOX20] = "Caching home agent 20",
    [CBOX21] = "Caching home agent 21",
    [CBOX22] = "Caching home agent 22",
    [CBOX23] = "Caching home agent 23",
    [CBOX24] = "Caching home agent 24",
    [CBOX25] = "Caching home agent 25",
    [CBOX26] = "Caching home agent 26",
    [CBOX27] = "Caching home agent 27",
    [CBOX28] = "Caching home agent 28",
    [CBOX29] = "Caching home agent 29",
    [CBOX30] = "Caching home agent 30",
    [CBOX31] = "Caching home agent 31",
    [CBOX32] = "Caching home agent 32",
    [CBOX33] = "Caching home agent 33",
    [CBOX34] = "Caching home agent 34",
    [CBOX35] = "Caching home agent 35",
    [CBOX36] = "Caching home agent 36",
    [CBOX37] = "Caching home agent 37",
    [CBOX38] = "Caching home agent 38",
    [CBOX39] = "Caching home agent 39",
    [CBOX40] = "Caching home agent 40",
    [CBOX41] = "Caching home agent 41",
    [CBOX42] = "Caching home agent 42",
    [CBOX43] = "Caching home agent 43",
    [CBOX44] = "Caching home agent 44",
    [CBOX45] = "Caching home agent 45",
    [CBOX46] = "Caching home agent 46",
    [CBOX47] = "Caching home agent 47",
    [CBOX48] = "Caching home agent 48",
    [CBOX49] = "Caching home agent 49",
    [CBOX50] = "Caching home agent 50",
    [CBOX51] = "Caching home agent 51",
    [CBOX52] = "Caching home agent 52",
    [CBOX53] = "Caching home agent 53",
    [CBOX54] = "Caching home agent 54",
    [CBOX55] = "Caching home agent 55",
    [CBOX56] = "Caching home agent 56",
    [CBOX57] = "Caching home agent 57",
    [CBOX58] = "Caching home agent 58",
    [CBOX59] = "Caching home agent 59",
    [CBOX60] = "Caching home agent 60",
    [CBOX61] = "Caching home agent 61",
    [CBOX62] = "Caching home agent 62",
    [CBOX63] = "Caching home agent 63",
    [CBOX64] = "Caching home agent 64",
    [CBOX65] = "Caching home agent 65",
    [CBOX66] = "Caching home agent 66",
    [CBOX67] = "Caching home agent 67",
    [CBOX68] = "Caching home agent 68",
    [CBOX69] = "Caching home agent 69",
    [CBOX70] = "Caching home agent 70",
    [CBOX71] = "Caching home agent 71",
    [CBOX72] = "Caching home agent 72",
    [CBOX73] = "Caching home agent 73",
    [CBOX74] = "Caching home agent 74",
    [CBOX75] = "Caching home agent 75",
    [CBOX76] = "Caching home agent 76",
    [CBOX77] = "Caching home agent 77",
    [CBOX78] = "Caching home agent 78",
    [CBOX79] = "Caching home agent 79",
    [CBOX80] = "Caching home agent 80",
    [CBOX81] = "Caching home agent 81",
    [CBOX82] = "Caching home agent 82",
    [CBOX83] = "Caching home agent 83",
    [CBOX84] = "Caching home agent 84",
    [CBOX85] = "Caching home agent 85",
    [CBOX86] = "Caching home agent 86",
    [CBOX87] = "Caching home agent 87",
    [CBOX88] = "Caching home agent 88",
    [CBOX89] = "Caching home agent 89",
    [CBOX90] = "Caching home agent 90",
    [CBOX91] = "Caching home agent 91",
    [CBOX92] = "Caching home agent 92",
    [CBOX93] = "Caching home agent 93",
    [CBOX94] = "Caching home agent 94",
    [CBOX95] = "Caching home agent 95",
    [CBOX96] = "Caching home agent 96",
    [CBOX97] = "Caching home agent 97",
    [CBOX98] = "Caching home agent 98",
    [CBOX99] = "Caching home agent 99",
    [CBOX100] = "Caching home agent 100",
    [CBOX101] = "Caching home agent 101",
    [CBOX102] = "Caching home agent 102",
    [CBOX103] = "Caching home agent 103",
    [CBOX104] = "Caching home agent 104",
    [CBOX105] = "Caching home agent 105",
    [CBOX106] = "Caching home agent 106",
    [CBOX107] = "Caching home agent 107",
    [CBOX108] = "Caching home agent 108",
    [CBOX109] = "Caching home agent 109",
    [CBOX110] = "Caching home agent 110",
    [CBOX111] = "Caching home agent 111",
    [CBOX112] = "Caching home agent 112",
    [CBOX113] = "Caching home agent 113",
    [CBOX114] = "Caching home agent 114",
    [CBOX115] = "Caching home agent 115",
    [CBOX116] = "Caching home agent 116",
    [CBOX117] = "Caching home agent 117",
    [CBOX118] = "Caching home agent 118",
    [CBOX119] = "Caching home agent 119",
    [CBOX120] = "Caching home agent 120",
    [CBOX121] = "Caching home agent 121",
    [CBOX122] = "Caching home agent 122",
    [CBOX123] = "Caching home agent 123",
    [CBOX124] = "Caching home agent 124",
    [CBOX125] = "Caching home agent 125",
    [MBOX0] = "Memory Controller Unit 0",
    [MBOX1] = "Memory Controller Unit 1",
    [MBOX2] = "Memory Controller Unit 2",
    [MBOX3] = "Memory Controller Unit 3",
    [MBOX4] = "Memory Controller Unit 4",
    [MBOX5] = "Memory Controller Unit 5",
    [MBOX6] = "Memory Controller Unit 6",
    [MBOX7] = "Memory Controller Unit 7",
    [MBOX8] = "Memory Controller Unit 8",
    [MBOX9] = "Memory Controller Unit 9",
    [MBOX10] = "Memory Controller Unit 10",
    [MBOX11] = "Memory Controller Unit 11",
    [WBOX0] = "Power Control Unit 0",
    [WBOX1] = "Power Control Unit 1",
    [WBOX2] = "Power Control Unit 2",
    [WBOX3] = "Power Control Unit 3",
    [WBOX4] = "Power Control Unit 4",
    [IRP0] = "IIO Ring Port 0",
    [IRP1] = "IIO Ring Port 1",
    [IRP2] = "IIO Ring Port 2",
    [IRP3] = "IIO Ring Port 3",
    [IRP4] = "IIO Ring Port 4",
    [IRP5] = "IIO Ring Port 5",
    [IRP6] = "IIO Ring Port 6",
    [IRP7] = "IIO Ring Port 7",
    [IRP8] = "IIO Ring Port 8",
    [IRP9] = "IIO Ring Port 9",
    [IRP10] = "IIO Ring Port 10",
    [IRP11] = "IIO Ring Port 11",
    [IRP12] = "IIO Ring Port 12",
    [IRP13] = "IIO Ring Port 13",
    [IRP14] = "IIO Ring Port 14",
    [IRP15] = "IIO Ring Port 15",
    [PBOX0] = "B2CXL: interface between mesh and each IIO/CXL stack 0",
    [PBOX1] = "B2CXL: interface between mesh and each IIO/CXL stack 1",
    [PBOX2] = "B2CXL: interface between mesh and each IIO/CXL stack 2",
    [PBOX3] = "B2CXL: interface between mesh and each IIO/CXL stack 3",
    [PBOX4] = "B2CXL: interface between mesh and each IIO/CXL stack 4",
    [PBOX5] = "B2CXL: interface between mesh and each IIO/CXL stack 5",
    [PBOX6] = "B2CXL: interface between mesh and each IIO/CXL stack 6",
    [PBOX7] = "B2CXL: interface between mesh and each IIO/CXL stack 7",
    [PBOX8] = "B2CXL: interface between mesh and each IIO/CXL stack 8",
    [PBOX9] = "B2CXL: interface between mesh and each IIO/CXL stack 9",
    [PBOX10] = "B2CXL: interface between mesh and each IIO/CXL stack 10",
    [PBOX11] = "B2CXL: interface between mesh and each IIO/CXL stack 11",
    [RBOX0] = "B2UPI: mesh to Intel UPI interface 0",
    [RBOX1] = "B2UPI: mesh to Intel UPI interface 1",
    [RBOX2] = "B2UPI: mesh to Intel UPI interface 2",
    [RBOX3] = "B2UPI: mesh to Intel UPI interface 3",
    [RBOX4] = "B2UPI: mesh to Intel UPI interface 4",
    [RBOX5] = "B2UPI: mesh to Intel UPI interface 5",
    [BBOX0] = "B2CMI: gateway between the mesh and the memory channel controllers 0",
    [BBOX1] = "B2CMI: gateway between the mesh and the memory channel controllers 1",
    [BBOX2] = "B2CMI: gateway between the mesh and the memory channel controllers 2",
    [BBOX3] = "B2CMI: gateway between the mesh and the memory channel controllers 3",
    [BBOX4] = "B2CMI: gateway between the mesh and the memory channel controllers 4",
    [BBOX5] = "B2CMI: gateway between the mesh and the memory channel controllers 5",
    [MDF0] = "Embedded Multi-die Interconnect Bridge Interface 0",
    [MDF1] = "Embedded Multi-die Interconnect Bridge Interface 1",
    [MDF2] = "Embedded Multi-die Interconnect Bridge Interface 2",
    [MDF3] = "Embedded Multi-die Interconnect Bridge Interface 3",
    [MDF4] = "Embedded Multi-die Interconnect Bridge Interface 4",
    [MDF5] = "Embedded Multi-die Interconnect Bridge Interface 5",
    [MDF6] = "Embedded Multi-die Interconnect Bridge Interface 6",
    [MDF7] = "Embedded Multi-die Interconnect Bridge Interface 7",
    [MDF8] = "Embedded Multi-die Interconnect Bridge Interface 8",
    [MDF9] = "Embedded Multi-die Interconnect Bridge Interface 9",
    [MDF10] = "Embedded Multi-die Interconnect Bridge Interface 10",
    [MDF11] = "Embedded Multi-die Interconnect Bridge Interface 11",
    [MDF12] = "Embedded Multi-die Interconnect Bridge Interface 12",
    [MDF13] = "Embedded Multi-die Interconnect Bridge Interface 13",
    [MDF14] = "Embedded Multi-die Interconnect Bridge Interface 14",
    [MDF15] = "Embedded Multi-die Interconnect Bridge Interface 15",
    [MDF16] = "Embedded Multi-die Interconnect Bridge Interface 16",
    [MDF17] = "Embedded Multi-die Interconnect Bridge Interface 17",
    [MDF18] = "Embedded Multi-die Interconnect Bridge Interface 18",
    [MDF19] = "Embedded Multi-die Interconnect Bridge Interface 19",
    [MDF20] = "Embedded Multi-die Interconnect Bridge Interface 20",
    [MDF21] = "Embedded Multi-die Interconnect Bridge Interface 21",
    [MDF22] = "Embedded Multi-die Interconnect Bridge Interface 22",
    [MDF23] = "Embedded Multi-die Interconnect Bridge Interface 23",
    [MDF24] = "Embedded Multi-die Interconnect Bridge Interface 24",
    [MDF25] = "Embedded Multi-die Interconnect Bridge Interface 25",
    [MDF26] = "Embedded Multi-die Interconnect Bridge Interface 26",
    [MDF27] = "Embedded Multi-die Interconnect Bridge Interface 27",
    [MDF28] = "Embedded Multi-die Interconnect Bridge Interface 28",
    [MDF29] = "Embedded Multi-die Interconnect Bridge Interface 29",
    [MDF30] = "Embedded Multi-die Interconnect Bridge Interface 30",
    [MDF31] = "Embedded Multi-die Interconnect Bridge Interface 31",
    [MDF32] = "Embedded Multi-die Interconnect Bridge Interface 32",
    [MDF33] = "Embedded Multi-die Interconnect Bridge Interface 33",
    [MDF34] = "Embedded Multi-die Interconnect Bridge Interface 34",
    [MDF35] = "Embedded Multi-die Interconnect Bridge Interface 35",
    [MDF36] = "Embedded Multi-die Interconnect Bridge Interface 36",
    [MDF37] = "Embedded Multi-die Interconnect Bridge Interface 37",
    [MDF38] = "Embedded Multi-die Interconnect Bridge Interface 38",
    [MDF39] = "Embedded Multi-die Interconnect Bridge Interface 39",
    [MDF40] = "Embedded Multi-die Interconnect Bridge Interface 40",
    [MDF41] = "Embedded Multi-die Interconnect Bridge Interface 41",
    [MDF42] = "Embedded Multi-die Interconnect Bridge Interface 42",
    [MDF43] = "Embedded Multi-die Interconnect Bridge Interface 43",
    [MDF44] = "Embedded Multi-die Interconnect Bridge Interface 44",
    [MDF45] = "Embedded Multi-die Interconnect Bridge Interface 45",
    [MDF46] = "Embedded Multi-die Interconnect Bridge Interface 46",
    [MDF47] = "Embedded Multi-die Interconnect Bridge Interface 47",
    [MDF48] = "Embedded Multi-die Interconnect Bridge Interface 48",
    [MDF49] = "Embedded Multi-die Interconnect Bridge Interface 49",
    [MDF50] = "Embedded Multi-die Interconnect Bridge Interface 50",
    [MDF51] = "Embedded Multi-die Interconnect Bridge Interface 51",
    [MDF52] = "Embedded Multi-die Interconnect Bridge Interface 52",
    [MDF53] = "Embedded Multi-die Interconnect Bridge Interface 53",
    [MDF54] = "Embedded Multi-die Interconnect Bridge Interface 54",
    [MDF55] = "Embedded Multi-die Interconnect Bridge Interface 55",
    [MDF56] = "Embedded Multi-die Interconnect Bridge Interface 56",
    [MDF57] = "Embedded Multi-die Interconnect Bridge Interface 57",
    [MDF58] = "Embedded Multi-die Interconnect Bridge Interface 58",
    [MDF59] = "Embedded Multi-die Interconnect Bridge Interface 59",
    [MDF60] = "Embedded Multi-die Interconnect Bridge Interface 60",
    [MDF61] = "Embedded Multi-die Interconnect Bridge Interface 61",
    [MDF62] = "Embedded Multi-die Interconnect Bridge Interface 62",
    [MDF63] = "Embedded Multi-die Interconnect Bridge Interface 63",
    [MDF64] = "Embedded Multi-die Interconnect Bridge Interface 64",
    [MDF65] = "Embedded Multi-die Interconnect Bridge Interface 65",
    [MDF66] = "Embedded Multi-die Interconnect Bridge Interface 66",
    [MDF67] = "Embedded Multi-die Interconnect Bridge Interface 67",
    [MDF68] = "Embedded Multi-die Interconnect Bridge Interface 68",
    [MDF69] = "Embedded Multi-die Interconnect Bridge Interface 69",
    [MDF70] = "Embedded Multi-die Interconnect Bridge Interface 70",
    [MDF71] = "Embedded Multi-die Interconnect Bridge Interface 71",
    [MDF72] = "Embedded Multi-die Interconnect Bridge Interface 72",
    [MDF73] = "Embedded Multi-die Interconnect Bridge Interface 73",
    [MDF74] = "Embedded Multi-die Interconnect Bridge Interface 74",
    [MDF75] = "Embedded Multi-die Interconnect Bridge Interface 75",
    [MDF76] = "Embedded Multi-die Interconnect Bridge Interface 76",
    [MDF77] = "Embedded Multi-die Interconnect Bridge Interface 77",
    [MDF78] = "Embedded Multi-die Interconnect Bridge Interface 78",
    [MDF79] = "Embedded Multi-die Interconnect Bridge Interface 79",
    [QBOX0] = "UPI interconnect unit 0",
    [QBOX1] = "UPI interconnect unit 1",
    [QBOX2] = "UPI interconnect unit 2",
    [QBOX3] = "UPI interconnect unit 3",
    [QBOX4] = "UPI interconnect unit 4",
    [QBOX5] = "UPI interconnect unit 5",
    [UBOX] = "General Uncore Controller",
    [IBOX0] = "IIO stack 0",
    [IBOX1] = "IIO stack 1",
    [IBOX2] = "IIO stack 2",
    [IBOX3] = "IIO stack 3",
    [IBOX4] = "IIO stack 4",
    [IBOX5] = "IIO stack 5",
    [IBOX6] = "IIO stack 6",
    [IBOX7] = "IIO stack 7",
    [IBOX8] = "IIO stack 8",
    [IBOX9] = "IIO stack 9",
    [IBOX10] = "IIO stack 10",
    [IBOX11] = "IIO stack 11",
    [IBOX12] = "IIO stack 12",
    [IBOX13] = "IIO stack 13",
    [IBOX14] = "IIO stack 14",
    [IBOX15] = "IIO stack 15",
};

#define     GNR_DEVICE_ID_CHA 0
#define     GNR_DEVICE_ID_IIO 1
#define     GNR_DEVICE_ID_IRP 2
#define     GNR_DEVICE_ID_iMC 6
#define     GNR_DEVICE_ID_UPI 8
#define     GNR_DEVICE_ID_PCU 4
#define     GNR_DEVICE_ID_UBOX 5
#define     GNR_DEVICE_ID_B2UPI 18
#define     GNR_DEVICE_ID_B2CMI 16
#define     GNR_DEVICE_ID_B2CXL 17
#define     GNR_DEVICE_ID_MDF 20

static PerfmonUncoreDiscovery graniterapids_uncore_discovery_map[] = {
    {"CBOX", GNR_DEVICE_ID_CHA, 126, MSR_CBOX_DEVICE_C0},
    {"MBOX", GNR_DEVICE_ID_iMC, 12, MMIO_IMC_DEVICE_0_CH_0},
    {"UBOX", GNR_DEVICE_ID_UBOX, 1, MSR_UBOX_DEVICE},
    {"WBOX", GNR_DEVICE_ID_PCU, 5, MSR_PCU_DEVICE_0},
    {"IRP", GNR_DEVICE_ID_IRP, 16, MSR_IRP_DEVICE_0},
    {"IIO", GNR_DEVICE_ID_IIO, 16, MSR_IIO_DEVICE_0},
    {"QBOX", GNR_DEVICE_ID_UPI, 6, PCI_QPI_DEVICE_PORT_0},
    {"MDF", GNR_DEVICE_ID_MDF, 80, MSR_MDF_DEVICE_0},
    {"M2M", GNR_DEVICE_ID_B2CMI, 6, PCI_HA_DEVICE_0},
    {"RBOX", GNR_DEVICE_ID_B2UPI, 6, PCI_R3QPI_DEVICE_LINK_0},
    {"PBOX", GNR_DEVICE_ID_B2CXL, 12, PCI_R2PCIE_DEVICE0},
    {"INVALID", -1, 0, MSR_DEV}
};
