; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK-P8-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK-P8-BE

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_0_vector(i64 %ptr) {
; CHECK-LABEL: ld_0_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_0_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_0_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_unalign16_vector(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_unalign16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    lxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_unalign16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addi r3, r3, 1
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_unalign16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addi r3, r3, 1
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_align16_vector(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r4, 8
; CHECK-NEXT:    lxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addi r3, r3, 8
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addi r3, r3, 8
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_unalign32_vector(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_unalign32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1
; CHECK-P9-NEXT:    ori r4, r4, 34463
; CHECK-P9-NEXT:    lxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_unalign32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1
; CHECK-P8-LE-NEXT:    ori r4, r4, 34463
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_unalign32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1
; CHECK-P8-BE-NEXT:    ori r4, r4, 34463
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_align32_vector(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    lxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1525
; CHECK-P8-LE-NEXT:    ori r4, r4, 56600
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1525
; CHECK-P8-BE-NEXT:    ori r4, r4, 56600
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_unalign64_vector(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lxvx v2, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_unalign64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    lxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_unalign64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_unalign64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000001
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_align64_vector(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_align64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_align64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_align64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 3725
; CHECK-P8-BE-NEXT:    ori r4, r4, 19025
; CHECK-P8-BE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_reg_vector(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_reg_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_reg_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_or_vector(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    lxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_or_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    or r3, r4, r3
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_or_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    or r3, r4, r3
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_or2_vector(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or2_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    lxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_or2_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_or2_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %off to i64
  %or = or i64 %and, %conv
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_not_disjoint16_vector(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    lxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    ori r3, r3, 6
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    ori r3, r3, 6
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_disjoint_unalign16_vector(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_unalign16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    li r4, 6
; CHECK-NEXT:    lxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_unalign16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-LE-NEXT:    ori r3, r3, 6
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_unalign16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-BE-NEXT:    ori r3, r3, 6
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 6
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_disjoint_align16_vector(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    li r4, 24
; CHECK-NEXT:    lxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-LE-NEXT:    ori r3, r3, 24
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-BE-NEXT:    ori r3, r3, 24
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_not_disjoint32_vector(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    lxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    ori r3, r3, 34463
; CHECK-P8-LE-NEXT:    oris r3, r3, 1
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    ori r3, r3, 34463
; CHECK-P8-BE-NEXT:    oris r3, r3, 1
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_disjoint_unalign32_vector(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_unalign32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P9-NEXT:    ori r4, r4, 34463
; CHECK-P9-NEXT:    lxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_unalign32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P8-LE-NEXT:    ori r4, r4, 34463
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_unalign32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P8-BE-NEXT:    ori r4, r4, 34463
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1048576
  %or = or i64 %and, 99999
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_disjoint_align32_vector(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    lxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, -15264
; CHECK-P8-LE-NEXT:    lis r5, 15258
; CHECK-P8-LE-NEXT:    and r3, r3, r4
; CHECK-P8-LE-NEXT:    ori r4, r5, 41712
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, -15264
; CHECK-P8-BE-NEXT:    lis r5, 15258
; CHECK-P8-BE-NEXT:    and r3, r3, r4
; CHECK-P8-BE-NEXT:    ori r4, r5, 41712
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_not_disjoint64_vector(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    lxv v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_not_disjoint64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    lxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_not_disjoint64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    or r3, r3, r4
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_not_disjoint64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    or r3, r3, r4
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_disjoint_unalign64_vector(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    lxvx v2, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_unalign64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    lxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_unalign64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_unalign64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 16
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_disjoint_align64_vector(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    lxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    lxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_disjoint_align64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_disjoint_align64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 3725
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    ori r4, r4, 19025
; CHECK-P8-BE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-BE-NEXT:    lxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to <16 x i8>*
  %1 = load <16 x i8>, <16 x i8>* %0, align 4096
  ret <16 x i8> %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_cst_unalign16_vector() {
; CHECK-LABEL: ld_cst_unalign16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 255
; CHECK-NEXT:    lxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_unalign16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 255
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_unalign16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 255
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* inttoptr (i64 255 to <16 x i8>*), align 16
  ret <16 x i8> %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_cst_align16_vector() {
; CHECK-LABEL: ld_cst_align16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxv v2, 4080(0)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 4080
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 4080
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* inttoptr (i64 4080 to <16 x i8>*), align 16
  ret <16 x i8> %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_cst_unalign32_vector() {
; CHECK-P10-LABEL: ld_cst_unalign32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 99999
; CHECK-P10-NEXT:    lxv v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_unalign32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 1
; CHECK-P9-NEXT:    ori r3, r3, 34463
; CHECK-P9-NEXT:    lxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_unalign32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 1
; CHECK-P8-LE-NEXT:    ori r3, r3, 34463
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_unalign32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r3, 1
; CHECK-P8-BE-NEXT:    ori r3, r3, 34463
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* inttoptr (i64 99999 to <16 x i8>*), align 16
  ret <16 x i8> %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_cst_align32_vector() {
; CHECK-P10-LABEL: ld_cst_align32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    lxv v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    lxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 152
; CHECK-P8-LE-NEXT:    ori r3, r3, 38428
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r3, 152
; CHECK-P8-BE-NEXT:    ori r3, r3, 38428
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* inttoptr (i64 9999900 to <16 x i8>*), align 16
  ret <16 x i8> %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_cst_unalign64_vector() {
; CHECK-P10-LABEL: ld_cst_unalign64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 232
; CHECK-P10-NEXT:    pli r4, 3567587329
; CHECK-P10-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-NEXT:    lxv v2, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_unalign64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r3, 29
; CHECK-P9-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-NEXT:    oris r3, r3, 54437
; CHECK-P9-NEXT:    ori r3, r3, 4097
; CHECK-P9-NEXT:    lxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_unalign64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 29
; CHECK-P8-LE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-LE-NEXT:    oris r3, r3, 54437
; CHECK-P8-LE-NEXT:    ori r3, r3, 4097
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_unalign64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4097
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* inttoptr (i64 1000000000001 to <16 x i8>*), align 16
  ret <16 x i8> %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local <16 x i8> @ld_cst_align64_vector() {
; CHECK-P10-LABEL: ld_cst_align64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    lxv v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    lxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: ld_cst_align64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 3725
; CHECK-P8-LE-NEXT:    ori r3, r3, 19025
; CHECK-P8-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: ld_cst_align64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r3, 3725
; CHECK-P8-BE-NEXT:    ori r3, r3, 19025
; CHECK-P8-BE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-BE-NEXT:    lxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* inttoptr (i64 1000000000000 to <16 x i8>*), align 4096
  ret <16 x i8> %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-LABEL: st_0_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_0_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_0_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_unalign16_vector(i8* nocapture %ptr, <16 x i8> %str) {
; CHECK-LABEL: st_unalign16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    stxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_unalign16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addi r3, r3, 1
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_unalign16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addi r3, r3, 1
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16_vector(i8* nocapture %ptr, <16 x i8> %str) {
; CHECK-LABEL: st_align16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r4, 8
; CHECK-NEXT:    stxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_align16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addi r3, r3, 8
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_align16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addi r3, r3, 8
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_unalign32_vector(i8* nocapture %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_unalign32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_unalign32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1
; CHECK-P9-NEXT:    ori r4, r4, 34463
; CHECK-P9-NEXT:    stxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_unalign32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1
; CHECK-P8-LE-NEXT:    ori r4, r4, 34463
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_unalign32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1
; CHECK-P8-BE-NEXT:    ori r4, r4, 34463
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32_vector(i8* nocapture %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_align32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1525
; CHECK-P9-NEXT:    ori r4, r4, 56600
; CHECK-P9-NEXT:    stxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_align32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1525
; CHECK-P8-LE-NEXT:    ori r4, r4, 56600
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_align32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1525
; CHECK-P8-BE-NEXT:    ori r4, r4, 56600
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_unalign64_vector(i8* nocapture %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_unalign64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    stxvx v2, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_unalign64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    stxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_unalign64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_unalign64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000001
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64_vector(i8* nocapture %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_align64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_align64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_align64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_align64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 3725
; CHECK-P8-BE-NEXT:    ori r4, r4, 19025
; CHECK-P8-BE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg_vector(i8* nocapture %ptr, i64 %off, <16 x i8> %str) {
; CHECK-LABEL: st_reg_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_reg_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_reg_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1_vector(i64 %ptr, i8 zeroext %off, <16 x i8> %str) {
; CHECK-LABEL: st_or1_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    stxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_or1_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    or r3, r4, r3
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_or1_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    or r3, r4, r3
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or2_vector(i64 %ptr, i8 zeroext %off, <16 x i8> %str) {
; CHECK-LABEL: st_or2_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    stxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_or2_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_or2_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %off to i64
  %or = or i64 %and, %conv
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-LABEL: st_not_disjoint16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    stxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_not_disjoint16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    ori r3, r3, 6
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_not_disjoint16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    ori r3, r3, 6
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_unalign16_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-LABEL: st_disjoint_unalign16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    li r4, 6
; CHECK-NEXT:    stxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_disjoint_unalign16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-LE-NEXT:    ori r3, r3, 6
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_disjoint_unalign16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-BE-NEXT:    ori r3, r3, 6
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 6
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-LABEL: st_disjoint_align16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    li r4, 24
; CHECK-NEXT:    stxvx v2, r3, r4
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_disjoint_align16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-LE-NEXT:    ori r3, r3, 24
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_disjoint_align16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-BE-NEXT:    ori r3, r3, 24
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-LABEL: st_not_disjoint32_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    stxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_not_disjoint32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    ori r3, r3, 34463
; CHECK-P8-LE-NEXT:    oris r3, r3, 1
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_not_disjoint32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    ori r3, r3, 34463
; CHECK-P8-BE-NEXT:    oris r3, r3, 1
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_unalign32_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_disjoint_unalign32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_unalign32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P9-NEXT:    ori r4, r4, 34463
; CHECK-P9-NEXT:    stxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_disjoint_unalign32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 1
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P8-LE-NEXT:    ori r4, r4, 34463
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_disjoint_unalign32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 1
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P8-BE-NEXT:    ori r4, r4, 34463
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1048576
  %or = or i64 %and, 99999
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_disjoint_align32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    and r3, r3, r4
; CHECK-P10-NEXT:    pli r4, 999990000
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, -15264
; CHECK-P9-NEXT:    and r3, r3, r4
; CHECK-P9-NEXT:    lis r4, 15258
; CHECK-P9-NEXT:    ori r4, r4, 41712
; CHECK-P9-NEXT:    stxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_disjoint_align32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, -15264
; CHECK-P8-LE-NEXT:    lis r5, 15258
; CHECK-P8-LE-NEXT:    and r3, r3, r4
; CHECK-P8-LE-NEXT:    ori r4, r5, 41712
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_disjoint_align32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, -15264
; CHECK-P8-BE-NEXT:    lis r5, 15258
; CHECK-P8-BE-NEXT:    and r3, r3, r4
; CHECK-P8-BE-NEXT:    ori r4, r5, 41712
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_not_disjoint64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r5
; CHECK-P10-NEXT:    stxv v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_not_disjoint64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    or r3, r3, r4
; CHECK-P9-NEXT:    stxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_not_disjoint64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    or r3, r3, r4
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_not_disjoint64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    or r3, r3, r4
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_unalign64_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_disjoint_unalign64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    stxvx v2, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_unalign64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4097
; CHECK-P9-NEXT:    stxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_disjoint_unalign64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r4, 29
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-LE-NEXT:    oris r4, r4, 54437
; CHECK-P8-LE-NEXT:    ori r4, r4, 4097
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_disjoint_unalign64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r4, 29
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-BE-NEXT:    oris r4, r4, 54437
; CHECK-P8-BE-NEXT:    ori r4, r4, 4097
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64_vector(i64 %ptr, <16 x i8> %str) {
; CHECK-P10-LABEL: st_disjoint_align64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    stxvx v2, r3, r4
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r4, r4, 19025
; CHECK-P9-NEXT:    rldic r4, r4, 12, 24
; CHECK-P9-NEXT:    stxvx v2, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_disjoint_align64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r4, 3725
; CHECK-P8-LE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-LE-NEXT:    ori r4, r4, 19025
; CHECK-P8-LE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_disjoint_align64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r4, 3725
; CHECK-P8-BE-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-BE-NEXT:    ori r4, r4, 19025
; CHECK-P8-BE-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-BE-NEXT:    stxvw4x v2, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to <16 x i8>*
  store <16 x i8> %str, <16 x i8>* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_unalign16_vector(<16 x i8> %str) {
; CHECK-LABEL: st_cst_unalign16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 255
; CHECK-NEXT:    stxv v2, 0(r3)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_cst_unalign16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 255
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_cst_unalign16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 255
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  store <16 x i8> %str, <16 x i8>* inttoptr (i64 255 to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16_vector(<16 x i8> %str) {
; CHECK-LABEL: st_cst_align16_vector:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stxv v2, 4080(0)
; CHECK-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_cst_align16_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 4080
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_cst_align16_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 4080
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  store <16 x i8> %str, <16 x i8>* inttoptr (i64 4080 to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_unalign32_vector(<16 x i8> %str) {
; CHECK-P10-LABEL: st_cst_unalign32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 99999
; CHECK-P10-NEXT:    stxv v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_unalign32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 1
; CHECK-P9-NEXT:    ori r3, r3, 34463
; CHECK-P9-NEXT:    stxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_cst_unalign32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 1
; CHECK-P8-LE-NEXT:    ori r3, r3, 34463
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_cst_unalign32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r3, 1
; CHECK-P8-BE-NEXT:    ori r3, r3, 34463
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  store <16 x i8> %str, <16 x i8>* inttoptr (i64 99999 to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32_vector(<16 x i8> %str) {
; CHECK-P10-LABEL: st_cst_align32_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 9999900
; CHECK-P10-NEXT:    stxv v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align32_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 152
; CHECK-P9-NEXT:    ori r3, r3, 38428
; CHECK-P9-NEXT:    stxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_cst_align32_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 152
; CHECK-P8-LE-NEXT:    ori r3, r3, 38428
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_cst_align32_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r3, 152
; CHECK-P8-BE-NEXT:    ori r3, r3, 38428
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  store <16 x i8> %str, <16 x i8>* inttoptr (i64 9999900 to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_unalign64_vector(<16 x i8> %str) {
; CHECK-P10-LABEL: st_cst_unalign64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 232
; CHECK-P10-NEXT:    pli r4, 3567587329
; CHECK-P10-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-NEXT:    stxv v2, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_unalign64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r3, 29
; CHECK-P9-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-NEXT:    oris r3, r3, 54437
; CHECK-P9-NEXT:    ori r3, r3, 4097
; CHECK-P9-NEXT:    stxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_cst_unalign64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    li r3, 29
; CHECK-P8-LE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-LE-NEXT:    oris r3, r3, 54437
; CHECK-P8-LE-NEXT:    ori r3, r3, 4097
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_cst_unalign64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    li r3, 29
; CHECK-P8-BE-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-BE-NEXT:    oris r3, r3, 54437
; CHECK-P8-BE-NEXT:    ori r3, r3, 4097
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  store <16 x i8> %str, <16 x i8>* inttoptr (i64 1000000000001 to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64_vector(<16 x i8> %str) {
; CHECK-P10-LABEL: st_cst_align64_vector:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    stxv v2, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64_vector:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    stxv v2, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: st_cst_align64_vector:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    lis r3, 3725
; CHECK-P8-LE-NEXT:    ori r3, r3, 19025
; CHECK-P8-LE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: st_cst_align64_vector:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    lis r3, 3725
; CHECK-P8-BE-NEXT:    ori r3, r3, 19025
; CHECK-P8-BE-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-BE-NEXT:    stxvw4x v2, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  store <16 x i8> %str, <16 x i8>* inttoptr (i64 1000000000000 to <16 x i8>*), align 4096
  ret void
}
