; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple armv8a-none-linux-gnu -mattr=+dotprod -float-abi=hard < %s | FileCheck %s

define <2 x i32> @test_vdot_u32(<2 x i32> %a, <8 x i8> %b, <8 x i8> %c) #0 {
; CHECK-LABEL: test_vdot_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vudot.u8 d0, d1, d2
; CHECK-NEXT:    bx lr
entry:
  %vdot1.i = call <2 x i32> @llvm.arm.neon.udot.v2i32.v8i8(<2 x i32> %a, <8 x i8> %b, <8 x i8> %c) #2
  ret <2 x i32> %vdot1.i
}

define <4 x i32> @test_vdotq_u32(<4 x i32> %a, <16 x i8> %b, <16 x i8> %c) #0 {
; CHECK-LABEL: test_vdotq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vudot.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %vdot1.i = call <4 x i32> @llvm.arm.neon.udot.v4i32.v16i8(<4 x i32> %a, <16 x i8> %b, <16 x i8> %c) #2
  ret <4 x i32> %vdot1.i
}

define <2 x i32> @test_vdot_s32(<2 x i32> %a, <8 x i8> %b, <8 x i8> %c) #0 {
; CHECK-LABEL: test_vdot_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vsdot.s8 d0, d1, d2
; CHECK-NEXT:    bx lr
entry:
  %vdot1.i = call <2 x i32> @llvm.arm.neon.sdot.v2i32.v8i8(<2 x i32> %a, <8 x i8> %b, <8 x i8> %c) #2
  ret <2 x i32> %vdot1.i
}

define <4 x i32> @test_vdotq_s32(<4 x i32> %a, <16 x i8> %b, <16 x i8> %c) #0 {
; CHECK-LABEL: test_vdotq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vsdot.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %vdot1.i = call <4 x i32> @llvm.arm.neon.sdot.v4i32.v16i8(<4 x i32> %a, <16 x i8> %b, <16 x i8> %c) #2
  ret <4 x i32> %vdot1.i
}

define <2 x i32> @test_vdot_lane_u32(<2 x i32> %a, <8 x i8> %b, <8 x i8> %c) {
; CHECK-LABEL: test_vdot_lane_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vudot.u8 d0, d1, d2[1]
; CHECK-NEXT:    bx lr
entry:
  %.cast = bitcast <8 x i8> %c to <2 x i32>
  %shuffle = shufflevector <2 x i32> %.cast, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %.cast5 = bitcast <2 x i32> %shuffle to <8 x i8>
  %vdot1.i = call <2 x i32> @llvm.arm.neon.udot.v2i32.v8i8(<2 x i32> %a, <8 x i8> %b, <8 x i8> %.cast5) #2
  ret <2 x i32> %vdot1.i
}

define <4 x i32> @test_vdotq_lane_u32(<4 x i32> %a, <16 x i8> %b, <8 x i8> %c) {
; CHECK-LABEL: test_vdotq_lane_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vudot.u8 q0, q1, d4[1]
; CHECK-NEXT:    bx lr
entry:
  %.cast = bitcast <8 x i8> %c to <2 x i32>
  %shuffle = shufflevector <2 x i32> %.cast, <2 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %.cast3 = bitcast <4 x i32> %shuffle to <16 x i8>
  %vdot1.i = call <4 x i32> @llvm.arm.neon.udot.v4i32.v16i8(<4 x i32> %a, <16 x i8> %b, <16 x i8> %.cast3) #2
  ret <4 x i32> %vdot1.i
}

define <2 x i32> @test_vdot_lane_s32(<2 x i32> %a, <8 x i8> %b, <8 x i8> %c) {
; CHECK-LABEL: test_vdot_lane_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vsdot.s8 d0, d1, d2[1]
; CHECK-NEXT:    bx lr
entry:
  %.cast = bitcast <8 x i8> %c to <2 x i32>
  %shuffle = shufflevector <2 x i32> %.cast, <2 x i32> undef, <2 x i32> <i32 1, i32 1>
  %.cast5 = bitcast <2 x i32> %shuffle to <8 x i8>
  %vdot1.i = call <2 x i32> @llvm.arm.neon.sdot.v2i32.v8i8(<2 x i32> %a, <8 x i8> %b, <8 x i8> %.cast5) #2
  ret <2 x i32> %vdot1.i
}

define <4 x i32> @test_vdotq_lane_s32(<4 x i32> %a, <16 x i8> %b, <8 x i8> %c) {
; CHECK-LABEL: test_vdotq_lane_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vsdot.s8 q0, q1, d4[1]
; CHECK-NEXT:    bx lr
entry:
  %.cast = bitcast <8 x i8> %c to <2 x i32>
  %shuffle = shufflevector <2 x i32> %.cast, <2 x i32> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %.cast3 = bitcast <4 x i32> %shuffle to <16 x i8>
  %vdot1.i = call <4 x i32> @llvm.arm.neon.sdot.v4i32.v16i8(<4 x i32> %a, <16 x i8> %b, <16 x i8> %.cast3) #2
  ret <4 x i32> %vdot1.i
}

define <4 x i32> @sdot_multi(<4 x i32> %vacc0x0123, <16 x i8> %va, <16 x i8> %vb) {
; CHECK-LABEL: sdot_multi:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vsdot.s8 q0, q2, d2[0]
; CHECK-NEXT:    vdup.32 q8, d3[0]
; CHECK-NEXT:    vsdot.s8 q0, q2, d2[1]
; CHECK-NEXT:    vdup.32 q9, d3[1]
; CHECK-NEXT:    vsdot.s8 q0, q2, q8
; CHECK-NEXT:    vsdot.s8 q0, q2, q9
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <16 x i8> %va to <4 x i32>
  %lane = shufflevector <4 x i32> %0, <4 x i32> poison, <4 x i32> zeroinitializer
  %1 = bitcast <4 x i32> %lane to <16 x i8>
  %vdot1.i58 = tail call <4 x i32> @llvm.arm.neon.sdot.v4i32.v16i8(<4 x i32> %vacc0x0123, <16 x i8> %vb, <16 x i8> %1)
  %lane13 = shufflevector <4 x i32> %0, <4 x i32> poison, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %2 = bitcast <4 x i32> %lane13 to <16 x i8>
  %vdot1.i57 = tail call <4 x i32> @llvm.arm.neon.sdot.v4i32.v16i8(<4 x i32> %vdot1.i58, <16 x i8> %vb, <16 x i8> %2)
  %3 = bitcast <16 x i8> %va to <4 x i32>
  %lane25 = shufflevector <4 x i32> %3, <4 x i32> poison, <4 x i32> <i32 2, i32 2, i32 2, i32 2>
  %4 = bitcast <4 x i32> %lane25 to <16 x i8>
  %vdot1.i56 = tail call <4 x i32> @llvm.arm.neon.sdot.v4i32.v16i8(<4 x i32> %vdot1.i57, <16 x i8> %vb, <16 x i8> %4)
  %lane37 = shufflevector <4 x i32> %3, <4 x i32> poison, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %5 = bitcast <4 x i32> %lane37 to <16 x i8>
  %vdot1.i = tail call <4 x i32> @llvm.arm.neon.sdot.v4i32.v16i8(<4 x i32> %vdot1.i56, <16 x i8> %vb, <16 x i8> %5)
  ret <4 x i32> %vdot1.i
}

define <4 x i32> @udot_multi(<4 x i32> %vacc0x0123, <16 x i8> %va, <16 x i8> %vb) {
; CHECK-LABEL: udot_multi:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vudot.u8 q0, q2, d2[0]
; CHECK-NEXT:    vdup.32 q8, d3[0]
; CHECK-NEXT:    vudot.u8 q0, q2, d2[1]
; CHECK-NEXT:    vdup.32 q9, d3[1]
; CHECK-NEXT:    vudot.u8 q0, q2, q8
; CHECK-NEXT:    vudot.u8 q0, q2, q9
; CHECK-NEXT:    bx lr
entry:
  %0 = bitcast <16 x i8> %va to <4 x i32>
  %lane = shufflevector <4 x i32> %0, <4 x i32> poison, <4 x i32> zeroinitializer
  %1 = bitcast <4 x i32> %lane to <16 x i8>
  %vdot1.i58 = tail call <4 x i32> @llvm.arm.neon.udot.v4i32.v16i8(<4 x i32> %vacc0x0123, <16 x i8> %vb, <16 x i8> %1)
  %lane13 = shufflevector <4 x i32> %0, <4 x i32> poison, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %2 = bitcast <4 x i32> %lane13 to <16 x i8>
  %vdot1.i57 = tail call <4 x i32> @llvm.arm.neon.udot.v4i32.v16i8(<4 x i32> %vdot1.i58, <16 x i8> %vb, <16 x i8> %2)
  %3 = bitcast <16 x i8> %va to <4 x i32>
  %lane25 = shufflevector <4 x i32> %3, <4 x i32> poison, <4 x i32> <i32 2, i32 2, i32 2, i32 2>
  %4 = bitcast <4 x i32> %lane25 to <16 x i8>
  %vdot1.i56 = tail call <4 x i32> @llvm.arm.neon.udot.v4i32.v16i8(<4 x i32> %vdot1.i57, <16 x i8> %vb, <16 x i8> %4)
  %lane37 = shufflevector <4 x i32> %3, <4 x i32> poison, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  %5 = bitcast <4 x i32> %lane37 to <16 x i8>
  %vdot1.i = tail call <4 x i32> @llvm.arm.neon.udot.v4i32.v16i8(<4 x i32> %vdot1.i56, <16 x i8> %vb, <16 x i8> %5)
  ret <4 x i32> %vdot1.i
}
