; RUN: llc -O0 -mtriple=spirv32-unknown-unknown --spirv-ext=+SPV_KHR_bfloat16 %s -o - | FileCheck %s
; RUN: llc -O0 -mtriple=spirv64-unknown-unknown --spirv-ext=+SPV_KHR_bfloat16 %s -o - | FileCheck %s
; RUN: %if spirv-tools %{ llc -O0 -mtriple=spirv-unknown-unknown --spirv-ext=+SPV_KHR_bfloat16 %s -o - -filetype=obj | spirv-val %}

// TODO: Open bug bfloat16 cannot be stored to.
XFAIL: *

define void @main() {
entry:

; CHECK-DAG: OpCapability Float16
; CHECK-DAG: OpCapability Float64
; CHECK-DAG: OpCapability BFloat16TypeKHR

; CHECK-DAG:     %[[#half:]] = OpTypeFloat 16{{$}}
; CHECK-DAG:   %[[#bfloat:]] = OpTypeFloat 16 0{{$}}
; CHECK-DAG:    %[[#float:]] = OpTypeFloat 32
; CHECK-DAG:   %[[#double:]] = OpTypeFloat 64

; CHECK-DAG:   %[[#v2half:]] = OpTypeVector %[[#half]] 2
; CHECK-DAG:   %[[#v3half:]] = OpTypeVector %[[#half]] 3
; CHECK-DAG:   %[[#v4half:]] = OpTypeVector %[[#half]] 4

; CHECK-DAG:  %[[#v2bfloat:]] = OpTypeVector %[[#bfloat]] 2
; CHECK-DAG:  %[[#v3bfloat:]] = OpTypeVector %[[#bfloat]] 3
; CHECK-DAG:  %[[#v4bfloat:]] = OpTypeVector %[[#bfloat]] 4

; CHECK-DAG:  %[[#v2float:]] = OpTypeVector %[[#float]] 2
; CHECK-DAG:  %[[#v3float:]] = OpTypeVector %[[#float]] 3
; CHECK-DAG:  %[[#v4float:]] = OpTypeVector %[[#float]] 4

; CHECK-DAG: %[[#v2double:]] = OpTypeVector %[[#double]] 2
; CHECK-DAG: %[[#v3double:]] = OpTypeVector %[[#double]] 3
; CHECK-DAG: %[[#v4double:]] = OpTypeVector %[[#double]] 4

; CHECK-DAG:     %[[#ptr_Function_half:]] = OpTypePointer Function %[[#half]]
; CHECK-DAG:    %[[#ptr_Function_bfloat:]] = OpTypePointer Function %[[#bfloat]]
; CHECK-DAG:    %[[#ptr_Function_float:]] = OpTypePointer Function %[[#float]]
; CHECK-DAG:   %[[#ptr_Function_double:]] = OpTypePointer Function %[[#double]]
; CHECK-DAG:   %[[#ptr_Function_v2half:]] = OpTypePointer Function %[[#v2half]]
; CHECK-DAG:   %[[#ptr_Function_v3half:]] = OpTypePointer Function %[[#v3half]]
; CHECK-DAG:   %[[#ptr_Function_v4half:]] = OpTypePointer Function %[[#v4half]]
; CHECK-DAG:  %[[#ptr_Function_v2bfloat:]] = OpTypePointer Function %[[#v2bfloat]]
; CHECK-DAG:  %[[#ptr_Function_v3bfloat:]] = OpTypePointer Function %[[#v3bfloat]]
; CHECK-DAG:  %[[#ptr_Function_v4bfloat:]] = OpTypePointer Function %[[#v4bfloat]]
; CHECK-DAG:  %[[#ptr_Function_v2float:]] = OpTypePointer Function %[[#v2float]]
; CHECK-DAG:  %[[#ptr_Function_v3float:]] = OpTypePointer Function %[[#v3float]]
; CHECK-DAG:  %[[#ptr_Function_v4float:]] = OpTypePointer Function %[[#v4float]]
; CHECK-DAG: %[[#ptr_Function_v2double:]] = OpTypePointer Function %[[#v2double]]
; CHECK-DAG: %[[#ptr_Function_v3double:]] = OpTypePointer Function %[[#v3double]]
; CHECK-DAG: %[[#ptr_Function_v4double:]] = OpTypePointer Function %[[#v4double]]

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_half]] Function
  %half_Val = alloca half, align 2
  store half 0.0, ptr %half_Val, align 2

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_bfloat]] Function
  %bfloat_Val = alloca bfloat, align 2
  store bfloat 0.0, ptr %bfloat_Val, align 2

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_float]] Function
  %float_Val = alloca float, align 4
  store float 0.0, ptr %float_Val, align 4

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_double]] Function
  %double_Val = alloca double, align 8
  store double 0.0, ptr %double_Val, align 8

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v2half]] Function
  %half2_Val = alloca <2 x half>, align 4
  store <2 x half> zeroinitializer, ptr %half2_Val, align 4

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v3half]] Function
  %half3_Val = alloca <3 x half>, align 8
  store <3 x half> zeroinitializer, ptr %half3_Val, align 8

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v4half]] Function
  %half4_Val = alloca <4 x half>, align 8
  store <4 x half> zeroinitializer, ptr %half4_Val, align 8

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v2bfloat]] Function
  %bfloat2_Val = alloca <2 x bfloat>, align 4
  store <2 x bfloat> zeroinitializer, ptr %bfloat2_Val, align 4

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v3bfloat]] Function
  %bfloat3_Val = alloca <3 x bfloat>, align 8
  store <3 x bfloat> zeroinitializer, ptr %bfloat3_Val, align 8

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v4bfloat]] Function
  %bfloat4_Val = alloca <4 x bfloat>, align 8
  store <4 x bfloat> zeroinitializer, ptr %bfloat4_Val, align 8

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v2float]] Function
  %float2_Val = alloca <2 x float>, align 8
  store <2 x float> zeroinitializer, ptr %float2_Val, align 8

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v3float]] Function
  %float3_Val = alloca <3 x float>, align 16
  store <3 x float> zeroinitializer, ptr %float3_Val, align 16

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v4float]] Function
  %float4_Val = alloca <4 x float>, align 16
  store <4 x float> zeroinitializer, ptr %float4_Val, align 16

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v2double]] Function
  %double2_Val = alloca <2 x double>, align 16
  store <2 x double> zeroinitializer, ptr %double2_Val, align 16

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v3double]] Function
  %double3_Val = alloca <3 x double>, align 32
  store <3 x double> zeroinitializer, ptr %double3_Val, align 32

; CHECK: %[[#]] = OpVariable %[[#ptr_Function_v4double]] Function
  %double4_Val = alloca <4 x double>, align 32
  store <4 x double> zeroinitializer, ptr %double4_Val, align 32
  ret void
}
