#line 6 "ncx.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 8
/*
 *  Copyright (C) 2014, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: ncx.m4 2601 2016-11-07 04:54:42Z wkliao $ */

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

#line 22

#line 26


#line 34

#line 41

#line 41
#if HAVE_CONFIG_H
#line 41
#include <config.h>
#line 41
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#line 53

#line 53
#pragma GCC diagnostic ignored "-Wdeprecated"
#line 53
#include "ncx.h"
#line 53
#include "nc3dispatch.h"

#line 72




#ifdef HAVE_INTTYPES_H
#include <inttypes.h> /* uint16_t, uint32_t, uint64_t */
#elif defined(HAVE_STDINT_H)
#include <stdint.h>   /* uint16_t, uint32_t, uint64_t */
#endif

#line 103

#line 121

/*
 * The only error code returned from subroutines in this file is NC_ERANGE,
 * if errors are detected.
 */

/*
 * An external data representation interface.
 */

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONGLONG_MAX
#define LONGLONG_MAX LONG_LONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef LONGLONG_MIN
#define LONGLONG_MIN LONG_LONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#ifndef ULONGLONG_MAX
#define ULONGLONG_MAX ULONG_LONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#ifndef SIZEOF_UCHAR
#ifdef  SIZEOF_UNSIGNED_CHAR
#define SIZEOF_UCHAR SIZEOF_UNSIGNED_CHAR
#else
#error "unknown SIZEOF_UCHAR"
#endif
#endif

#ifndef SIZEOF_USHORT
#ifdef  SIZEOF_UNSIGNED_SHORT_INT
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT_INT
#elif defined(SIZEOF_UNSIGNED_SHORT)
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT
#else
#error "unknown SIZEOF_USHORT"
#endif
#endif

#ifndef SIZEOF_UINT
#ifdef  SIZEOF_UNSIGNED_INT
#define SIZEOF_UINT SIZEOF_UNSIGNED_INT
#else
#error "unknown SIZEOF_UINT"
#endif
#endif

#ifndef SIZEOF_LONGLONG
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_LONGLONG SIZEOF_LONG_LONG
#else
#error "unknown SIZEOF_LONGLONG"
#endif
#endif

#ifndef SIZEOF_INT64
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_INT64 SIZEOF_LONG_LONG
#elif defined(SIZEOF_LONGLONG)
#define SIZEOF_INT64 SIZEOF_LONGLONG
#else
#error "unknown SIZEOF_INT64"
#endif
#endif

#ifndef SIZEOF_ULONGLONG
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_ULONGLONG SIZEOF_UNSIGNED_LONG_LONG
#else
#error "unknown SIZEOF_ULONGLONG"
#endif
#endif

#ifndef SIZEOF_UINT64
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_UINT64 SIZEOF_UNSIGNED_LONG_LONG
#elif defined(SIZEOF_ULONGLONG)
#define SIZEOF_UINT64 SIZEOF_ULONGLONG
#else
#error "unknown SIZEOF_UINT64"
#endif
#endif

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if defined(_SX) && _SX != 0 /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIG ENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressively.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
                   (((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
                  (((a) <<  8) & 0x00ff0000) | \
                  (((a) >>  8) & 0x0000ff00) | \
                  (((a) >> 24) & 0x000000ff) )

#define SWAP8(a) ( (((a) & 0x00000000000000FFULL) << 56) | \
                   (((a) & 0x000000000000FF00ULL) << 40) | \
                   (((a) & 0x0000000000FF0000ULL) << 24) | \
                   (((a) & 0x00000000FF000000ULL) <<  8) | \
                   (((a) & 0x000000FF00000000ULL) >>  8) | \
                   (((a) & 0x0000FF0000000000ULL) >> 24) | \
                   (((a) & 0x00FF000000000000ULL) >> 40) | \
                   (((a) & 0xFF00000000000000ULL) >> 56) )

#if defined(_MSC_VER) && _MSC_VER < 1900
#define inline __inline
#endif

inline static void
swapn2b(void *dst, const void *src, size_t nn)
{
    /* it is OK if dst == src */
    size_t i;
    uint16_t *op = (uint16_t*) dst;
    uint16_t *ip = (uint16_t*) src;
    for (i=0; i<nn; i++) {
        op[i] = ip[i];
        op[i] = (uint16_t)SWAP2(op[i]);
    }
#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *
 *	while (nn-- > 0)
 *	{
 *		*op++ = *(++ip);
 *		*op++ = *(ip++ -1);
 *	}
 */
	while (nn > 3)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		nn -= 4;
	}
	while (nn-- > 0)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
	}
#endif
}

# ifndef vax
inline static void
swap4b(void *dst, const void *src)
{
    /* copy over, make the below swap in-place */
    uint32_t tmp;
    /* use memcpy to avoid type punning */
    memcpy(&tmp, src, sizeof(tmp));
    tmp = SWAP4(tmp);
    memcpy(dst, &tmp, 4);

    /* Codes below will cause "break strict-aliasing rules" in gcc
    uint32_t *op = (uint32_t*)dst;
    *op = *(uint32_t*)src;
    *op = SWAP4(*op);
    */

    /* Below are copied from netCDF-4.
     * See https://bugtracking.unidata.ucar.edu/browse/NCF-338
     * Quote "One issue we are wrestling with is how compilers optimize this
     * code.  For some reason, we are actually needing to add an artificial
     * move to a 4 byte space to get it to work.  I think what is happening is
     * that the optimizer is bit shifting within a double, which is incorrect.
     * The following code actually does work correctly.
     *  This is in Linux land, gcc.
     *
     * However, the above in-place byte-swap does not appear affected by this.
     */
#if 0
    uint32_t *ip = (uint32_t*)src;
    uint32_t tempOut;  /* cannot use pointer when gcc O2 optimizer is used */
    tempOut = SWAP4(*ip);

    *(float *)dst = *(float *)(&tempOut);
#endif

    /* OLD implementation that results in four load and four store CPU
       instructions
    char *op = dst;
    const char *ip = src;
    op[0] = ip[3];
    op[1] = ip[2];
    op[2] = ip[1];
    op[3] = ip[0];
    */

}
# endif /* !vax */

inline static void
swapn4b(void *dst, const void *src, size_t nn)
{
    size_t i;
    uint32_t *op = (uint32_t*) dst;
    uint32_t *ip = (uint32_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        op[i] = ip[i];
        op[i] = SWAP4(op[i]);
    }

#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while (nn-- > 0)
 *	{
 *		op[0] = ip[3];
 *		op[1] = ip[2];
 *		op[2] = ip[1];
 *		op[3] = ip[0];
 *		op += 4;
 *		ip += 4;
 *	}
 */
	while (nn > 3)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op[8] = ip[11];
		op[9] = ip[10];
		op[10] = ip[9];
		op[11] = ip[8];
		op[12] = ip[15];
		op[13] = ip[14];
		op[14] = ip[13];
		op[15] = ip[12];
		op += 16;
		ip += 16;
		nn -= 4;
	}
	while (nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op += 4;
		ip += 4;
	}
#endif
}

# ifndef vax
inline static void
swap8b(void *dst, const void *src)
{
#ifdef FLOAT_WORDS_BIGENDIAN
    /* copy over, make the below swap in-place */
    *(uint64_t*)dst = *(uint64_t*)src;

    uint32_t *op = (uint32_t*)dst;
    *op = SWAP4(*op);
    op = (uint32_t*)((char*)dst+4);
    *op = SWAP4(*op);
#else
    uint64_t tmp;
    /* use memcpy to avoid type punning */
    memcpy(&tmp, src, sizeof(tmp));
    tmp = SWAP8(tmp);
    memcpy(dst, &tmp, 8);

    /* Codes below will cause "break strict-aliasing rules" in gcc
    uint64_t *op = (uint64_t*)dst;
    *op = *(uint64_t*)src;
    *op = SWAP8(*op);
    */
#endif

#if 0
	char *op = dst;
	const char *ip = src;
#  ifndef FLOAT_WORDS_BIGENDIAN
	op[0] = ip[7];
	op[1] = ip[6];
	op[2] = ip[5];
	op[3] = ip[4];
	op[4] = ip[3];
	op[5] = ip[2];
	op[6] = ip[1];
	op[7] = ip[0];
#  else
	op[0] = ip[3];
	op[1] = ip[2];
	op[2] = ip[1];
	op[3] = ip[0];
	op[4] = ip[7];
	op[5] = ip[6];
	op[6] = ip[5];
	op[7] = ip[4];
#endif
#endif
}
# endif /* !vax */

# ifndef vax
inline static void
swapn8b(void *dst, const void *src, size_t nn)
{
#ifdef FLOAT_WORDS_BIGENDIAN
    size_t i;
    uint64_t *dst_p = (uint64_t*) dst;
    uint64_t *src_p = (uint64_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        dst_p[i] = src_p[i];
        uint32_t *op = (uint32_t*)(&dst_p[i]);
        *op = SWAP4(*op);
        op = (uint32_t*)((char*)op+4);
        *op = SWAP4(*op);
    }
#else
    size_t i;
    uint64_t *op = (uint64_t*) dst;
    uint64_t *ip = (uint64_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        op[i] = ip[i];
        op[i] = SWAP8(op[i]);
    }
#endif

#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while (nn-- > 0)
 *	{
 *		op[0] = ip[7];
 *		op[1] = ip[6];
 *		op[2] = ip[5];
 *		op[3] = ip[4];
 *		op[4] = ip[3];
 *		op[5] = ip[2];
 *		op[6] = ip[1];
 *		op[7] = ip[0];
 *		op += 8;
 *		ip += 8;
 *	}
 */
#  ifndef FLOAT_WORDS_BIGENDIAN
	while (nn > 1)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op[8] = ip[15];
		op[9] = ip[14];
		op[10] = ip[13];
		op[11] = ip[12];
		op[12] = ip[11];
		op[13] = ip[10];
		op[14] = ip[9];
		op[15] = ip[8];
		op += 16;
		ip += 16;
		nn -= 2;
	}
	while (nn-- > 0)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op += 8;
		ip += 8;
	}
#  else
	while (nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op += 8;
		ip += 8;
	}
#endif
#endif
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */

#line 634

#line 638

#line 650

#line 665


/*
 * Primitive numeric conversion functions.
 */

#line 693

#line 741

#line 774

#line 820

/* x_schar */
/* x_uchar */

/* We don't implement any x_schar and x_uchar primitives. */


/* external NC_SHORT --------------------------------------------------------*/

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONGLONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_short)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_short)(*ip | *cp);
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 872
ncx_get_short_schar(const void *xp, schar *ip)
#line 872
{
#line 872
    int err=NC_NOERR;
#line 872
    ix_short xx = 0;
#line 872
    get_ix_short(xp, &xx);
#line 872

#line 872
#if IX_SHORT_MAX > SCHAR_MAX
#line 872
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 872
#ifdef ERANGE_FILL
#line 872
        *ip = NC_FILL_BYTE;
#line 872
        return NC_ERANGE;
#line 872
#else
#line 872
        err = NC_ERANGE;
#line 872
#endif
#line 872
    }
#line 872
#endif
#line 872

#line 872

#line 872
    *ip = (schar) xx;
#line 872
    return err;
#line 872
}
#line 872

static int
#line 873
ncx_get_short_short(const void *xp, short *ip)
#line 873
{
#line 873
    int err=NC_NOERR;
#line 873
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 873
    get_ix_short(xp, (ix_short *)ip);
#line 873
#else
#line 873
    ix_short xx = 0;
#line 873
    get_ix_short(xp, &xx);
#line 873

#line 873
#if IX_SHORT_MAX > SHORT_MAX
#line 873
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 873
#ifdef ERANGE_FILL
#line 873
        *ip = NC_FILL_SHORT;
#line 873
        return NC_ERANGE;
#line 873
#else
#line 873
        err = NC_ERANGE;
#line 873
#endif
#line 873
    }
#line 873
#endif
#line 873

#line 873

#line 873
    *ip = (short) xx;
#line 873
#endif
#line 873
    return err;
#line 873
}
#line 873

static int
#line 874
ncx_get_short_int(const void *xp, int *ip)
#line 874
{
#line 874
    int err=NC_NOERR;
#line 874
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 874
    get_ix_short(xp, (ix_short *)ip);
#line 874
#else
#line 874
    ix_short xx = 0;
#line 874
    get_ix_short(xp, &xx);
#line 874

#line 874
#if IX_SHORT_MAX > INT_MAX
#line 874
    if (xx > INT_MAX || xx < INT_MIN) {
#line 874
#ifdef ERANGE_FILL
#line 874
        *ip = NC_FILL_INT;
#line 874
        return NC_ERANGE;
#line 874
#else
#line 874
        err = NC_ERANGE;
#line 874
#endif
#line 874
    }
#line 874
#endif
#line 874

#line 874

#line 874
    *ip = (int) xx;
#line 874
#endif
#line 874
    return err;
#line 874
}
#line 874

static int
#line 875
ncx_get_short_long(const void *xp, long *ip)
#line 875
{
#line 875
    int err=NC_NOERR;
#line 875
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 875
    get_ix_short(xp, (ix_short *)ip);
#line 875
#else
#line 875
    ix_short xx = 0;
#line 875
    get_ix_short(xp, &xx);
#line 875

#line 875
#if IX_SHORT_MAX > LONG_MAX
#line 875
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 875
#ifdef ERANGE_FILL
#line 875
        *ip = NC_FILL_INT;
#line 875
        return NC_ERANGE;
#line 875
#else
#line 875
        err = NC_ERANGE;
#line 875
#endif
#line 875
    }
#line 875
#endif
#line 875

#line 875

#line 875
    *ip = (long) xx;
#line 875
#endif
#line 875
    return err;
#line 875
}
#line 875

static int
#line 876
ncx_get_short_longlong(const void *xp, longlong *ip)
#line 876
{
#line 876
    int err=NC_NOERR;
#line 876
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 876
    get_ix_short(xp, (ix_short *)ip);
#line 876
#else
#line 876
    ix_short xx = 0;
#line 876
    get_ix_short(xp, &xx);
#line 876

#line 876
#if IX_SHORT_MAX > LONGLONG_MAX
#line 876
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 876
#ifdef ERANGE_FILL
#line 876
        *ip = NC_FILL_INT64;
#line 876
        return NC_ERANGE;
#line 876
#else
#line 876
        err = NC_ERANGE;
#line 876
#endif
#line 876
    }
#line 876
#endif
#line 876

#line 876

#line 876
    *ip = (longlong) xx;
#line 876
#endif
#line 876
    return err;
#line 876
}
#line 876

static int
#line 877
ncx_get_short_ushort(const void *xp, ushort *ip)
#line 877
{
#line 877
    int err=NC_NOERR;
#line 877
    ix_short xx = 0;
#line 877
    get_ix_short(xp, &xx);
#line 877

#line 877
#if IX_SHORT_MAX > USHORT_MAX
#line 877
    if (xx > USHORT_MAX) {
#line 877
#ifdef ERANGE_FILL
#line 877
        *ip = NC_FILL_USHORT;
#line 877
        return NC_ERANGE;
#line 877
#else
#line 877
        err = NC_ERANGE;
#line 877
#endif
#line 877
    }
#line 877
#endif
#line 877

#line 877
    if (xx < 0) {
#line 877
#ifdef ERANGE_FILL
#line 877
        *ip = NC_FILL_USHORT;
#line 877
        return NC_ERANGE;
#line 877
#else
#line 877
        err = NC_ERANGE; /* because ip is unsigned */
#line 877
#endif
#line 877
    }
#line 877
    *ip = (ushort) xx;
#line 877
    return err;
#line 877
}
#line 877

static int
#line 878
ncx_get_short_uchar(const void *xp, uchar *ip)
#line 878
{
#line 878
    int err=NC_NOERR;
#line 878
    ix_short xx = 0;
#line 878
    get_ix_short(xp, &xx);
#line 878

#line 878
#if IX_SHORT_MAX > UCHAR_MAX
#line 878
    if (xx > UCHAR_MAX) {
#line 878
#ifdef ERANGE_FILL
#line 878
        *ip = NC_FILL_UBYTE;
#line 878
        return NC_ERANGE;
#line 878
#else
#line 878
        err = NC_ERANGE;
#line 878
#endif
#line 878
    }
#line 878
#endif
#line 878

#line 878
    if (xx < 0) {
#line 878
#ifdef ERANGE_FILL
#line 878
        *ip = NC_FILL_UBYTE;
#line 878
        return NC_ERANGE;
#line 878
#else
#line 878
        err = NC_ERANGE; /* because ip is unsigned */
#line 878
#endif
#line 878
    }
#line 878
    *ip = (uchar) xx;
#line 878
    return err;
#line 878
}
#line 878

static int
#line 879
ncx_get_short_uint(const void *xp, uint *ip)
#line 879
{
#line 879
    int err=NC_NOERR;
#line 879
    ix_short xx = 0;
#line 879
    get_ix_short(xp, &xx);
#line 879

#line 879
#if IX_SHORT_MAX > UINT_MAX
#line 879
    if (xx > UINT_MAX) {
#line 879
#ifdef ERANGE_FILL
#line 879
        *ip = NC_FILL_UINT;
#line 879
        return NC_ERANGE;
#line 879
#else
#line 879
        err = NC_ERANGE;
#line 879
#endif
#line 879
    }
#line 879
#endif
#line 879

#line 879
    if (xx < 0) {
#line 879
#ifdef ERANGE_FILL
#line 879
        *ip = NC_FILL_UINT;
#line 879
        return NC_ERANGE;
#line 879
#else
#line 879
        err = NC_ERANGE; /* because ip is unsigned */
#line 879
#endif
#line 879
    }
#line 879
    *ip = (uint) xx;
#line 879
    return err;
#line 879
}
#line 879

static int
#line 880
ncx_get_short_ulonglong(const void *xp, ulonglong *ip)
#line 880
{
#line 880
    int err=NC_NOERR;
#line 880
    ix_short xx = 0;
#line 880
    get_ix_short(xp, &xx);
#line 880

#line 880
#if IX_SHORT_MAX > ULONGLONG_MAX
#line 880
    if (xx > ULONGLONG_MAX) {
#line 880
#ifdef ERANGE_FILL
#line 880
        *ip = NC_FILL_UINT64;
#line 880
        return NC_ERANGE;
#line 880
#else
#line 880
        err = NC_ERANGE;
#line 880
#endif
#line 880
    }
#line 880
#endif
#line 880

#line 880
    if (xx < 0) {
#line 880
#ifdef ERANGE_FILL
#line 880
        *ip = NC_FILL_UINT64;
#line 880
        return NC_ERANGE;
#line 880
#else
#line 880
        err = NC_ERANGE; /* because ip is unsigned */
#line 880
#endif
#line 880
    }
#line 880
    *ip = (ulonglong) xx;
#line 880
    return err;
#line 880
}
#line 880

static int
#line 881
ncx_get_short_float(const void *xp, float *ip)
#line 881
{
#line 881
	ix_short xx = 0;
#line 881
	get_ix_short(xp, &xx);
#line 881
	*ip = (float)xx;
#line 881
	return NC_NOERR;
#line 881
}
#line 881

static int
#line 882
ncx_get_short_double(const void *xp, double *ip)
#line 882
{
#line 882
	ix_short xx = 0;
#line 882
	get_ix_short(xp, &xx);
#line 882
	*ip = (double)xx;
#line 882
	return NC_NOERR;
#line 882
}
#line 882


static int
ncx_put_short_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_short_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 905
ncx_put_short_short(void *xp, const short *ip, void *fillp)
#line 905
{
#line 905
    int err=NC_NOERR;
#line 905
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 905
    put_ix_short(xp, (const ix_short *)ip);
#line 905
#else
#line 905
    ix_short xx = NC_FILL_SHORT;
#line 905

#line 905
#if IX_SHORT_MAX < SHORT_MAX
#line 905
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 905
        
#line 905
#ifdef ERANGE_FILL
#line 905
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 905
#endif
#line 905
        err = NC_ERANGE;
#line 905
    }
#line 905
#ifdef ERANGE_FILL
#line 905
    else
#line 905
#endif
#line 905
#endif
#line 905
        xx = (ix_short)*ip;
#line 905

#line 905
    put_ix_short(xp, &xx);
#line 905
#endif
#line 905
    return err;
#line 905
}
#line 905

static int
#line 906
ncx_put_short_int(void *xp, const int *ip, void *fillp)
#line 906
{
#line 906
    int err=NC_NOERR;
#line 906
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 906
    put_ix_short(xp, (const ix_short *)ip);
#line 906
#else
#line 906
    ix_short xx = NC_FILL_SHORT;
#line 906

#line 906
#if IX_SHORT_MAX < INT_MAX
#line 906
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 906
        
#line 906
#ifdef ERANGE_FILL
#line 906
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 906
#endif
#line 906
        err = NC_ERANGE;
#line 906
    }
#line 906
#ifdef ERANGE_FILL
#line 906
    else
#line 906
#endif
#line 906
#endif
#line 906
        xx = (ix_short)*ip;
#line 906

#line 906
    put_ix_short(xp, &xx);
#line 906
#endif
#line 906
    return err;
#line 906
}
#line 906

static int
#line 907
ncx_put_short_long(void *xp, const long *ip, void *fillp)
#line 907
{
#line 907
    int err=NC_NOERR;
#line 907
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 907
    put_ix_short(xp, (const ix_short *)ip);
#line 907
#else
#line 907
    ix_short xx = NC_FILL_SHORT;
#line 907

#line 907
#if IX_SHORT_MAX < LONG_MAX
#line 907
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 907
        
#line 907
#ifdef ERANGE_FILL
#line 907
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 907
#endif
#line 907
        err = NC_ERANGE;
#line 907
    }
#line 907
#ifdef ERANGE_FILL
#line 907
    else
#line 907
#endif
#line 907
#endif
#line 907
        xx = (ix_short)*ip;
#line 907

#line 907
    put_ix_short(xp, &xx);
#line 907
#endif
#line 907
    return err;
#line 907
}
#line 907

static int
#line 908
ncx_put_short_longlong(void *xp, const longlong *ip, void *fillp)
#line 908
{
#line 908
    int err=NC_NOERR;
#line 908
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 908
    put_ix_short(xp, (const ix_short *)ip);
#line 908
#else
#line 908
    ix_short xx = NC_FILL_SHORT;
#line 908

#line 908
#if IX_SHORT_MAX < LONGLONG_MAX
#line 908
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 908
        
#line 908
#ifdef ERANGE_FILL
#line 908
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 908
#endif
#line 908
        err = NC_ERANGE;
#line 908
    }
#line 908
#ifdef ERANGE_FILL
#line 908
    else
#line 908
#endif
#line 908
#endif
#line 908
        xx = (ix_short)*ip;
#line 908

#line 908
    put_ix_short(xp, &xx);
#line 908
#endif
#line 908
    return err;
#line 908
}
#line 908

static int
#line 909
ncx_put_short_ushort(void *xp, const ushort *ip, void *fillp)
#line 909
{
#line 909
    int err=NC_NOERR;
#line 909
    ix_short xx = NC_FILL_SHORT;
#line 909

#line 909
#if IX_SHORT_MAX < USHORT_MAX
#line 909
    if (*ip > IX_SHORT_MAX) {
#line 909
        
#line 909
#ifdef ERANGE_FILL
#line 909
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 909
#endif
#line 909
        err = NC_ERANGE;
#line 909
    }
#line 909
#ifdef ERANGE_FILL
#line 909
    else
#line 909
#endif
#line 909
#endif
#line 909
        xx = (ix_short)*ip;
#line 909

#line 909
    put_ix_short(xp, &xx);
#line 909
    return err;
#line 909
}
#line 909

static int
#line 910
ncx_put_short_uint(void *xp, const uint *ip, void *fillp)
#line 910
{
#line 910
    int err=NC_NOERR;
#line 910
    ix_short xx = NC_FILL_SHORT;
#line 910

#line 910
#if IX_SHORT_MAX < UINT_MAX
#line 910
    if (*ip > IX_SHORT_MAX) {
#line 910
        
#line 910
#ifdef ERANGE_FILL
#line 910
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 910
#endif
#line 910
        err = NC_ERANGE;
#line 910
    }
#line 910
#ifdef ERANGE_FILL
#line 910
    else
#line 910
#endif
#line 910
#endif
#line 910
        xx = (ix_short)*ip;
#line 910

#line 910
    put_ix_short(xp, &xx);
#line 910
    return err;
#line 910
}
#line 910

static int
#line 911
ncx_put_short_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 911
{
#line 911
    int err=NC_NOERR;
#line 911
    ix_short xx = NC_FILL_SHORT;
#line 911

#line 911
#if IX_SHORT_MAX < ULONGLONG_MAX
#line 911
    if (*ip > IX_SHORT_MAX) {
#line 911
        
#line 911
#ifdef ERANGE_FILL
#line 911
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 911
#endif
#line 911
        err = NC_ERANGE;
#line 911
    }
#line 911
#ifdef ERANGE_FILL
#line 911
    else
#line 911
#endif
#line 911
#endif
#line 911
        xx = (ix_short)*ip;
#line 911

#line 911
    put_ix_short(xp, &xx);
#line 911
    return err;
#line 911
}
#line 911

static int
#line 912
ncx_put_short_float(void *xp, const float *ip, void *fillp)
#line 912
{
#line 912
    int err=NC_NOERR;
#line 912
    ix_short xx = NC_FILL_SHORT;
#line 912

#line 912
    if (*ip > (double)X_SHORT_MAX || *ip < (double)X_SHORT_MIN) {
#line 912
        
#line 912
#ifdef ERANGE_FILL
#line 912
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 912
#endif
#line 912
        err = NC_ERANGE;
#line 912
    }
#line 912
#ifdef ERANGE_FILL
#line 912
    else
#line 912
#endif
#line 912
        xx = (ix_short)*ip;
#line 912

#line 912
    put_ix_short(xp, &xx);
#line 912
    return err;
#line 912
}
#line 912

static int
#line 913
ncx_put_short_double(void *xp, const double *ip, void *fillp)
#line 913
{
#line 913
    int err=NC_NOERR;
#line 913
    ix_short xx = NC_FILL_SHORT;
#line 913

#line 913
    if (*ip > X_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 913
        
#line 913
#ifdef ERANGE_FILL
#line 913
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 913
#endif
#line 913
        err = NC_ERANGE;
#line 913
    }
#line 913
#ifdef ERANGE_FILL
#line 913
    else
#line 913
#endif
#line 913
        xx = (ix_short)*ip;
#line 913

#line 913
    put_ix_short(xp, &xx);
#line 913
    return err;
#line 913
}
#line 913


/* external NC_USHORT -------------------------------------------------------*/

#if USHORT_MAX == X_USHORT_MAX
typedef unsigned short ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_USHORT
#define IX_USHORT_MAX USHORT_MAX
#elif UINT_MAX >= X_USHORT_MAX
typedef unsigned int ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_UINT
#define IX_USHORT_MAX UINT_MAX
#elif ULONG_MAX >= X_USHORT_MAX
typedef unsigned long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG
#define IX_USHORT_MAX ULONG_MAX
#elif ULLONG_MAX >= X_USHORT_MAX
typedef unsigned long long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONGLONG
#define IX_USHORT_MAX ULLONG_MAX
#else
#error "ix_ushort implementation"
#endif

static void
get_ix_ushort(const void *xp, ix_ushort *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_ushort)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_ushort)(*ip | *cp);
}

static void
put_ix_ushort(void *xp, const ix_ushort *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 960
ncx_get_ushort_schar(const void *xp, schar *ip)
#line 960
{
#line 960
    int err=NC_NOERR;
#line 960
    ix_ushort xx = 0;
#line 960
    get_ix_ushort(xp, &xx);
#line 960

#line 960
#if IX_USHORT_MAX > SCHAR_MAX
#line 960
    if (xx > SCHAR_MAX) {
#line 960
#ifdef ERANGE_FILL
#line 960
        *ip = NC_FILL_BYTE;
#line 960
        return NC_ERANGE;
#line 960
#else
#line 960
        err = NC_ERANGE;
#line 960
#endif
#line 960
    }
#line 960
#endif
#line 960

#line 960

#line 960
    *ip = (schar) xx;
#line 960
    return err;
#line 960
}
#line 960

static int
#line 961
ncx_get_ushort_short(const void *xp, short *ip)
#line 961
{
#line 961
    int err=NC_NOERR;
#line 961
    ix_ushort xx = 0;
#line 961
    get_ix_ushort(xp, &xx);
#line 961

#line 961
#if IX_USHORT_MAX > SHORT_MAX
#line 961
    if (xx > SHORT_MAX) {
#line 961
#ifdef ERANGE_FILL
#line 961
        *ip = NC_FILL_SHORT;
#line 961
        return NC_ERANGE;
#line 961
#else
#line 961
        err = NC_ERANGE;
#line 961
#endif
#line 961
    }
#line 961
#endif
#line 961

#line 961

#line 961
    *ip = (short) xx;
#line 961
    return err;
#line 961
}
#line 961

static int
#line 962
ncx_get_ushort_int(const void *xp, int *ip)
#line 962
{
#line 962
    int err=NC_NOERR;
#line 962
    ix_ushort xx = 0;
#line 962
    get_ix_ushort(xp, &xx);
#line 962

#line 962
#if IX_USHORT_MAX > INT_MAX
#line 962
    if (xx > INT_MAX) {
#line 962
#ifdef ERANGE_FILL
#line 962
        *ip = NC_FILL_INT;
#line 962
        return NC_ERANGE;
#line 962
#else
#line 962
        err = NC_ERANGE;
#line 962
#endif
#line 962
    }
#line 962
#endif
#line 962

#line 962

#line 962
    *ip = (int) xx;
#line 962
    return err;
#line 962
}
#line 962

static int
#line 963
ncx_get_ushort_long(const void *xp, long *ip)
#line 963
{
#line 963
    int err=NC_NOERR;
#line 963
    ix_ushort xx = 0;
#line 963
    get_ix_ushort(xp, &xx);
#line 963

#line 963
#if IX_USHORT_MAX > LONG_MAX
#line 963
    if (xx > LONG_MAX) {
#line 963
#ifdef ERANGE_FILL
#line 963
        *ip = NC_FILL_INT;
#line 963
        return NC_ERANGE;
#line 963
#else
#line 963
        err = NC_ERANGE;
#line 963
#endif
#line 963
    }
#line 963
#endif
#line 963

#line 963

#line 963
    *ip = (long) xx;
#line 963
    return err;
#line 963
}
#line 963

static int
#line 964
ncx_get_ushort_longlong(const void *xp, longlong *ip)
#line 964
{
#line 964
    int err=NC_NOERR;
#line 964
    ix_ushort xx = 0;
#line 964
    get_ix_ushort(xp, &xx);
#line 964

#line 964
#if IX_USHORT_MAX > LONGLONG_MAX
#line 964
    if (xx > LONGLONG_MAX) {
#line 964
#ifdef ERANGE_FILL
#line 964
        *ip = NC_FILL_INT64;
#line 964
        return NC_ERANGE;
#line 964
#else
#line 964
        err = NC_ERANGE;
#line 964
#endif
#line 964
    }
#line 964
#endif
#line 964

#line 964

#line 964
    *ip = (longlong) xx;
#line 964
    return err;
#line 964
}
#line 964

static int
#line 965
ncx_get_ushort_ushort(const void *xp, ushort *ip)
#line 965
{
#line 965
    int err=NC_NOERR;
#line 965
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 965
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 965
#else
#line 965
    ix_ushort xx = 0;
#line 965
    get_ix_ushort(xp, &xx);
#line 965

#line 965
#if IX_USHORT_MAX > USHORT_MAX
#line 965
    if (xx > USHORT_MAX) {
#line 965
#ifdef ERANGE_FILL
#line 965
        *ip = NC_FILL_USHORT;
#line 965
        return NC_ERANGE;
#line 965
#else
#line 965
        err = NC_ERANGE;
#line 965
#endif
#line 965
    }
#line 965
#endif
#line 965

#line 965

#line 965
    *ip = (ushort) xx;
#line 965
#endif
#line 965
    return err;
#line 965
}
#line 965

static int
#line 966
ncx_get_ushort_uchar(const void *xp, uchar *ip)
#line 966
{
#line 966
    int err=NC_NOERR;
#line 966
#if SIZEOF_IX_USHORT == SIZEOF_UCHAR && IX_USHORT_MAX == UCHAR_MAX
#line 966
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 966
#else
#line 966
    ix_ushort xx = 0;
#line 966
    get_ix_ushort(xp, &xx);
#line 966

#line 966
#if IX_USHORT_MAX > UCHAR_MAX
#line 966
    if (xx > UCHAR_MAX) {
#line 966
#ifdef ERANGE_FILL
#line 966
        *ip = NC_FILL_UBYTE;
#line 966
        return NC_ERANGE;
#line 966
#else
#line 966
        err = NC_ERANGE;
#line 966
#endif
#line 966
    }
#line 966
#endif
#line 966

#line 966

#line 966
    *ip = (uchar) xx;
#line 966
#endif
#line 966
    return err;
#line 966
}
#line 966

static int
#line 967
ncx_get_ushort_uint(const void *xp, uint *ip)
#line 967
{
#line 967
    int err=NC_NOERR;
#line 967
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 967
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 967
#else
#line 967
    ix_ushort xx = 0;
#line 967
    get_ix_ushort(xp, &xx);
#line 967

#line 967
#if IX_USHORT_MAX > UINT_MAX
#line 967
    if (xx > UINT_MAX) {
#line 967
#ifdef ERANGE_FILL
#line 967
        *ip = NC_FILL_UINT;
#line 967
        return NC_ERANGE;
#line 967
#else
#line 967
        err = NC_ERANGE;
#line 967
#endif
#line 967
    }
#line 967
#endif
#line 967

#line 967

#line 967
    *ip = (uint) xx;
#line 967
#endif
#line 967
    return err;
#line 967
}
#line 967

static int
#line 968
ncx_get_ushort_ulonglong(const void *xp, ulonglong *ip)
#line 968
{
#line 968
    int err=NC_NOERR;
#line 968
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 968
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 968
#else
#line 968
    ix_ushort xx = 0;
#line 968
    get_ix_ushort(xp, &xx);
#line 968

#line 968
#if IX_USHORT_MAX > ULONGLONG_MAX
#line 968
    if (xx > ULONGLONG_MAX) {
#line 968
#ifdef ERANGE_FILL
#line 968
        *ip = NC_FILL_UINT64;
#line 968
        return NC_ERANGE;
#line 968
#else
#line 968
        err = NC_ERANGE;
#line 968
#endif
#line 968
    }
#line 968
#endif
#line 968

#line 968

#line 968
    *ip = (ulonglong) xx;
#line 968
#endif
#line 968
    return err;
#line 968
}
#line 968

static int
#line 969
ncx_get_ushort_float(const void *xp, float *ip)
#line 969
{
#line 969
	ix_ushort xx = 0;
#line 969
	get_ix_ushort(xp, &xx);
#line 969
	*ip = (float)xx;
#line 969
	return NC_NOERR;
#line 969
}
#line 969

static int
#line 970
ncx_get_ushort_double(const void *xp, double *ip)
#line 970
{
#line 970
	ix_ushort xx = 0;
#line 970
	get_ix_ushort(xp, &xx);
#line 970
	*ip = (double)xx;
#line 970
	return NC_NOERR;
#line 970
}
#line 970


static int
ncx_put_ushort_schar(void *xp, const schar *ip, void *fillp)
{
    int err=NC_NOERR;
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 2);
#ifndef WORDS_BIGENDIAN
        swapn2b(xp, xp, 1);
#endif
        return NC_ERANGE;
#else
        err = NC_ERANGE;
#endif
    }

    cp = (uchar *) xp;
    if (*ip & 0x80)
        *cp++ = 0xff;
    else
        *cp++ = 0;
    *cp = (uchar)*ip;

    return err;
}

static int
ncx_put_ushort_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 1008
ncx_put_ushort_short(void *xp, const short *ip, void *fillp)
#line 1008
{
#line 1008
    int err=NC_NOERR;
#line 1008
    ix_ushort xx = NC_FILL_USHORT;
#line 1008

#line 1008
#if IX_USHORT_MAX < SHORT_MAX
#line 1008
    if (*ip > IX_USHORT_MAX) {
#line 1008
        
#line 1008
#ifdef ERANGE_FILL
#line 1008
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1008
#endif
#line 1008
        err = NC_ERANGE;
#line 1008
    }
#line 1008
#ifdef ERANGE_FILL
#line 1008
    else
#line 1008
#endif
#line 1008
#endif
#line 1008
    if (*ip < 0) {
#line 1008
        
#line 1008
#ifdef ERANGE_FILL
#line 1008
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1008
#endif
#line 1008
        err = NC_ERANGE; /* because xp is unsigned */
#line 1008
    }
#line 1008
#ifdef ERANGE_FILL
#line 1008
    else
#line 1008
#endif
#line 1008
        xx = (ix_ushort)*ip;
#line 1008

#line 1008
    put_ix_ushort(xp, &xx);
#line 1008
    return err;
#line 1008
}
#line 1008

static int
#line 1009
ncx_put_ushort_int(void *xp, const int *ip, void *fillp)
#line 1009
{
#line 1009
    int err=NC_NOERR;
#line 1009
    ix_ushort xx = NC_FILL_USHORT;
#line 1009

#line 1009
#if IX_USHORT_MAX < INT_MAX
#line 1009
    if (*ip > IX_USHORT_MAX) {
#line 1009
        
#line 1009
#ifdef ERANGE_FILL
#line 1009
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1009
#endif
#line 1009
        err = NC_ERANGE;
#line 1009
    }
#line 1009
#ifdef ERANGE_FILL
#line 1009
    else
#line 1009
#endif
#line 1009
#endif
#line 1009
    if (*ip < 0) {
#line 1009
        
#line 1009
#ifdef ERANGE_FILL
#line 1009
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1009
#endif
#line 1009
        err = NC_ERANGE; /* because xp is unsigned */
#line 1009
    }
#line 1009
#ifdef ERANGE_FILL
#line 1009
    else
#line 1009
#endif
#line 1009
        xx = (ix_ushort)*ip;
#line 1009

#line 1009
    put_ix_ushort(xp, &xx);
#line 1009
    return err;
#line 1009
}
#line 1009

static int
#line 1010
ncx_put_ushort_long(void *xp, const long *ip, void *fillp)
#line 1010
{
#line 1010
    int err=NC_NOERR;
#line 1010
    ix_ushort xx = NC_FILL_USHORT;
#line 1010

#line 1010
#if IX_USHORT_MAX < LONG_MAX
#line 1010
    if (*ip > IX_USHORT_MAX) {
#line 1010
        
#line 1010
#ifdef ERANGE_FILL
#line 1010
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1010
#endif
#line 1010
        err = NC_ERANGE;
#line 1010
    }
#line 1010
#ifdef ERANGE_FILL
#line 1010
    else
#line 1010
#endif
#line 1010
#endif
#line 1010
    if (*ip < 0) {
#line 1010
        
#line 1010
#ifdef ERANGE_FILL
#line 1010
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1010
#endif
#line 1010
        err = NC_ERANGE; /* because xp is unsigned */
#line 1010
    }
#line 1010
#ifdef ERANGE_FILL
#line 1010
    else
#line 1010
#endif
#line 1010
        xx = (ix_ushort)*ip;
#line 1010

#line 1010
    put_ix_ushort(xp, &xx);
#line 1010
    return err;
#line 1010
}
#line 1010

static int
#line 1011
ncx_put_ushort_longlong(void *xp, const longlong *ip, void *fillp)
#line 1011
{
#line 1011
    int err=NC_NOERR;
#line 1011
    ix_ushort xx = NC_FILL_USHORT;
#line 1011

#line 1011
#if IX_USHORT_MAX < LONGLONG_MAX
#line 1011
    if (*ip > IX_USHORT_MAX) {
#line 1011
        
#line 1011
#ifdef ERANGE_FILL
#line 1011
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1011
#endif
#line 1011
        err = NC_ERANGE;
#line 1011
    }
#line 1011
#ifdef ERANGE_FILL
#line 1011
    else
#line 1011
#endif
#line 1011
#endif
#line 1011
    if (*ip < 0) {
#line 1011
        
#line 1011
#ifdef ERANGE_FILL
#line 1011
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1011
#endif
#line 1011
        err = NC_ERANGE; /* because xp is unsigned */
#line 1011
    }
#line 1011
#ifdef ERANGE_FILL
#line 1011
    else
#line 1011
#endif
#line 1011
        xx = (ix_ushort)*ip;
#line 1011

#line 1011
    put_ix_ushort(xp, &xx);
#line 1011
    return err;
#line 1011
}
#line 1011

static int
#line 1012
ncx_put_ushort_ushort(void *xp, const ushort *ip, void *fillp)
#line 1012
{
#line 1012
    int err=NC_NOERR;
#line 1012
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 1012
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1012
#else
#line 1012
    ix_ushort xx = NC_FILL_USHORT;
#line 1012

#line 1012
#if IX_USHORT_MAX < USHORT_MAX
#line 1012
    if (*ip > IX_USHORT_MAX) {
#line 1012
        
#line 1012
#ifdef ERANGE_FILL
#line 1012
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1012
#endif
#line 1012
        err = NC_ERANGE;
#line 1012
    }
#line 1012
#ifdef ERANGE_FILL
#line 1012
    else
#line 1012
#endif
#line 1012
#endif
#line 1012
        xx = (ix_ushort)*ip;
#line 1012

#line 1012
    put_ix_ushort(xp, &xx);
#line 1012
#endif
#line 1012
    return err;
#line 1012
}
#line 1012

static int
#line 1013
ncx_put_ushort_uint(void *xp, const uint *ip, void *fillp)
#line 1013
{
#line 1013
    int err=NC_NOERR;
#line 1013
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 1013
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1013
#else
#line 1013
    ix_ushort xx = NC_FILL_USHORT;
#line 1013

#line 1013
#if IX_USHORT_MAX < UINT_MAX
#line 1013
    if (*ip > IX_USHORT_MAX) {
#line 1013
        
#line 1013
#ifdef ERANGE_FILL
#line 1013
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1013
#endif
#line 1013
        err = NC_ERANGE;
#line 1013
    }
#line 1013
#ifdef ERANGE_FILL
#line 1013
    else
#line 1013
#endif
#line 1013
#endif
#line 1013
        xx = (ix_ushort)*ip;
#line 1013

#line 1013
    put_ix_ushort(xp, &xx);
#line 1013
#endif
#line 1013
    return err;
#line 1013
}
#line 1013

static int
#line 1014
ncx_put_ushort_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1014
{
#line 1014
    int err=NC_NOERR;
#line 1014
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 1014
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1014
#else
#line 1014
    ix_ushort xx = NC_FILL_USHORT;
#line 1014

#line 1014
#if IX_USHORT_MAX < ULONGLONG_MAX
#line 1014
    if (*ip > IX_USHORT_MAX) {
#line 1014
        
#line 1014
#ifdef ERANGE_FILL
#line 1014
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1014
#endif
#line 1014
        err = NC_ERANGE;
#line 1014
    }
#line 1014
#ifdef ERANGE_FILL
#line 1014
    else
#line 1014
#endif
#line 1014
#endif
#line 1014
        xx = (ix_ushort)*ip;
#line 1014

#line 1014
    put_ix_ushort(xp, &xx);
#line 1014
#endif
#line 1014
    return err;
#line 1014
}
#line 1014

static int
#line 1015
ncx_put_ushort_float(void *xp, const float *ip, void *fillp)
#line 1015
{
#line 1015
    int err=NC_NOERR;
#line 1015
    ix_ushort xx = NC_FILL_USHORT;
#line 1015

#line 1015
    if (*ip > (double)X_USHORT_MAX || *ip < 0) {
#line 1015
        
#line 1015
#ifdef ERANGE_FILL
#line 1015
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1015
#endif
#line 1015
        err = NC_ERANGE;
#line 1015
    }
#line 1015
#ifdef ERANGE_FILL
#line 1015
    else
#line 1015
#endif
#line 1015
        xx = (ix_ushort)*ip;
#line 1015

#line 1015
    put_ix_ushort(xp, &xx);
#line 1015
    return err;
#line 1015
}
#line 1015

static int
#line 1016
ncx_put_ushort_double(void *xp, const double *ip, void *fillp)
#line 1016
{
#line 1016
    int err=NC_NOERR;
#line 1016
    ix_ushort xx = NC_FILL_USHORT;
#line 1016

#line 1016
    if (*ip > X_USHORT_MAX || *ip < 0) {
#line 1016
        
#line 1016
#ifdef ERANGE_FILL
#line 1016
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1016
#endif
#line 1016
        err = NC_ERANGE;
#line 1016
    }
#line 1016
#ifdef ERANGE_FILL
#line 1016
    else
#line 1016
#endif
#line 1016
        xx = (ix_ushort)*ip;
#line 1016

#line 1016
    put_ix_ushort(xp, &xx);
#line 1016
    return err;
#line 1016
}
#line 1016


/* external NC_INT ----------------------------------------------------------*/

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

#if INT_MAX  >= X_INT_MAX
	*ip = (ix_int)((unsigned)(*cp++) << 24);
#else
	*ip = *cp++ << 24;
#endif
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if (*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)( (*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 1071
ncx_get_int_int(const void *xp, int *ip)
#line 1071
{
#line 1071
    int err=NC_NOERR;
#line 1071
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 1071
    get_ix_int(xp, (ix_int *)ip);
#line 1071
#else
#line 1071
    ix_int xx = 0;
#line 1071
    get_ix_int(xp, &xx);
#line 1071

#line 1071
#if IX_INT_MAX > INT_MAX
#line 1071
    if (xx > INT_MAX || xx < INT_MIN) {
#line 1071
#ifdef ERANGE_FILL
#line 1071
        *ip = NC_FILL_INT;
#line 1071
        return NC_ERANGE;
#line 1071
#else
#line 1071
        err = NC_ERANGE;
#line 1071
#endif
#line 1071
    }
#line 1071
#endif
#line 1071

#line 1071

#line 1071
    *ip = (int) xx;
#line 1071
#endif
#line 1071
    return err;
#line 1071
}
#line 1071

#endif
static int
#line 1073
ncx_get_int_schar(const void *xp, schar *ip)
#line 1073
{
#line 1073
    int err=NC_NOERR;
#line 1073
    ix_int xx = 0;
#line 1073
    get_ix_int(xp, &xx);
#line 1073

#line 1073
#if IX_INT_MAX > SCHAR_MAX
#line 1073
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 1073
#ifdef ERANGE_FILL
#line 1073
        *ip = NC_FILL_BYTE;
#line 1073
        return NC_ERANGE;
#line 1073
#else
#line 1073
        err = NC_ERANGE;
#line 1073
#endif
#line 1073
    }
#line 1073
#endif
#line 1073

#line 1073

#line 1073
    *ip = (schar) xx;
#line 1073
    return err;
#line 1073
}
#line 1073

static int
#line 1074
ncx_get_int_short(const void *xp, short *ip)
#line 1074
{
#line 1074
    int err=NC_NOERR;
#line 1074
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 1074
    get_ix_int(xp, (ix_int *)ip);
#line 1074
#else
#line 1074
    ix_int xx = 0;
#line 1074
    get_ix_int(xp, &xx);
#line 1074

#line 1074
#if IX_INT_MAX > SHORT_MAX
#line 1074
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 1074
#ifdef ERANGE_FILL
#line 1074
        *ip = NC_FILL_SHORT;
#line 1074
        return NC_ERANGE;
#line 1074
#else
#line 1074
        err = NC_ERANGE;
#line 1074
#endif
#line 1074
    }
#line 1074
#endif
#line 1074

#line 1074

#line 1074
    *ip = (short) xx;
#line 1074
#endif
#line 1074
    return err;
#line 1074
}
#line 1074

static int
#line 1075
ncx_get_int_long(const void *xp, long *ip)
#line 1075
{
#line 1075
    int err=NC_NOERR;
#line 1075
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 1075
    get_ix_int(xp, (ix_int *)ip);
#line 1075
#else
#line 1075
    ix_int xx = 0;
#line 1075
    get_ix_int(xp, &xx);
#line 1075

#line 1075
#if IX_INT_MAX > LONG_MAX
#line 1075
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 1075
#ifdef ERANGE_FILL
#line 1075
        *ip = NC_FILL_INT;
#line 1075
        return NC_ERANGE;
#line 1075
#else
#line 1075
        err = NC_ERANGE;
#line 1075
#endif
#line 1075
    }
#line 1075
#endif
#line 1075

#line 1075

#line 1075
    *ip = (long) xx;
#line 1075
#endif
#line 1075
    return err;
#line 1075
}
#line 1075

static int
#line 1076
ncx_get_int_longlong(const void *xp, longlong *ip)
#line 1076
{
#line 1076
    int err=NC_NOERR;
#line 1076
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 1076
    get_ix_int(xp, (ix_int *)ip);
#line 1076
#else
#line 1076
    ix_int xx = 0;
#line 1076
    get_ix_int(xp, &xx);
#line 1076

#line 1076
#if IX_INT_MAX > LONGLONG_MAX
#line 1076
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 1076
#ifdef ERANGE_FILL
#line 1076
        *ip = NC_FILL_INT64;
#line 1076
        return NC_ERANGE;
#line 1076
#else
#line 1076
        err = NC_ERANGE;
#line 1076
#endif
#line 1076
    }
#line 1076
#endif
#line 1076

#line 1076

#line 1076
    *ip = (longlong) xx;
#line 1076
#endif
#line 1076
    return err;
#line 1076
}
#line 1076

static int
#line 1077
ncx_get_int_ushort(const void *xp, ushort *ip)
#line 1077
{
#line 1077
    int err=NC_NOERR;
#line 1077
    ix_int xx = 0;
#line 1077
    get_ix_int(xp, &xx);
#line 1077

#line 1077
#if IX_INT_MAX > USHORT_MAX
#line 1077
    if (xx > USHORT_MAX) {
#line 1077
#ifdef ERANGE_FILL
#line 1077
        *ip = NC_FILL_USHORT;
#line 1077
        return NC_ERANGE;
#line 1077
#else
#line 1077
        err = NC_ERANGE;
#line 1077
#endif
#line 1077
    }
#line 1077
#endif
#line 1077

#line 1077
    if (xx < 0) {
#line 1077
#ifdef ERANGE_FILL
#line 1077
        *ip = NC_FILL_USHORT;
#line 1077
        return NC_ERANGE;
#line 1077
#else
#line 1077
        err = NC_ERANGE; /* because ip is unsigned */
#line 1077
#endif
#line 1077
    }
#line 1077
    *ip = (ushort) xx;
#line 1077
    return err;
#line 1077
}
#line 1077

static int
#line 1078
ncx_get_int_uchar(const void *xp, uchar *ip)
#line 1078
{
#line 1078
    int err=NC_NOERR;
#line 1078
    ix_int xx = 0;
#line 1078
    get_ix_int(xp, &xx);
#line 1078

#line 1078
#if IX_INT_MAX > UCHAR_MAX
#line 1078
    if (xx > UCHAR_MAX) {
#line 1078
#ifdef ERANGE_FILL
#line 1078
        *ip = NC_FILL_UBYTE;
#line 1078
        return NC_ERANGE;
#line 1078
#else
#line 1078
        err = NC_ERANGE;
#line 1078
#endif
#line 1078
    }
#line 1078
#endif
#line 1078

#line 1078
    if (xx < 0) {
#line 1078
#ifdef ERANGE_FILL
#line 1078
        *ip = NC_FILL_UBYTE;
#line 1078
        return NC_ERANGE;
#line 1078
#else
#line 1078
        err = NC_ERANGE; /* because ip is unsigned */
#line 1078
#endif
#line 1078
    }
#line 1078
    *ip = (uchar) xx;
#line 1078
    return err;
#line 1078
}
#line 1078

static int
#line 1079
ncx_get_int_uint(const void *xp, uint *ip)
#line 1079
{
#line 1079
    int err=NC_NOERR;
#line 1079
    ix_int xx = 0;
#line 1079
    get_ix_int(xp, &xx);
#line 1079

#line 1079
#if IX_INT_MAX > UINT_MAX
#line 1079
    if (xx > UINT_MAX) {
#line 1079
#ifdef ERANGE_FILL
#line 1079
        *ip = NC_FILL_UINT;
#line 1079
        return NC_ERANGE;
#line 1079
#else
#line 1079
        err = NC_ERANGE;
#line 1079
#endif
#line 1079
    }
#line 1079
#endif
#line 1079

#line 1079
    if (xx < 0) {
#line 1079
#ifdef ERANGE_FILL
#line 1079
        *ip = NC_FILL_UINT;
#line 1079
        return NC_ERANGE;
#line 1079
#else
#line 1079
        err = NC_ERANGE; /* because ip is unsigned */
#line 1079
#endif
#line 1079
    }
#line 1079
    *ip = (uint) xx;
#line 1079
    return err;
#line 1079
}
#line 1079

static int
#line 1080
ncx_get_int_ulonglong(const void *xp, ulonglong *ip)
#line 1080
{
#line 1080
    int err=NC_NOERR;
#line 1080
    ix_int xx = 0;
#line 1080
    get_ix_int(xp, &xx);
#line 1080

#line 1080
#if IX_INT_MAX > ULONGLONG_MAX
#line 1080
    if (xx > ULONGLONG_MAX) {
#line 1080
#ifdef ERANGE_FILL
#line 1080
        *ip = NC_FILL_UINT64;
#line 1080
        return NC_ERANGE;
#line 1080
#else
#line 1080
        err = NC_ERANGE;
#line 1080
#endif
#line 1080
    }
#line 1080
#endif
#line 1080

#line 1080
    if (xx < 0) {
#line 1080
#ifdef ERANGE_FILL
#line 1080
        *ip = NC_FILL_UINT64;
#line 1080
        return NC_ERANGE;
#line 1080
#else
#line 1080
        err = NC_ERANGE; /* because ip is unsigned */
#line 1080
#endif
#line 1080
    }
#line 1080
    *ip = (ulonglong) xx;
#line 1080
    return err;
#line 1080
}
#line 1080

static int
#line 1081
ncx_get_int_float(const void *xp, float *ip)
#line 1081
{
#line 1081
	ix_int xx = 0;
#line 1081
	get_ix_int(xp, &xx);
#line 1081
	*ip = (float)xx;
#line 1081
	return NC_NOERR;
#line 1081
}
#line 1081

static int
#line 1082
ncx_get_int_double(const void *xp, double *ip)
#line 1082
{
#line 1082
	ix_int xx = 0;
#line 1082
	get_ix_int(xp, &xx);
#line 1082
	*ip = (double)xx;
#line 1082
	return NC_NOERR;
#line 1082
}
#line 1082


static int
ncx_put_int_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_int_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 1116
ncx_put_int_int(void *xp, const int *ip, void *fillp)
#line 1116
{
#line 1116
    int err=NC_NOERR;
#line 1116
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 1116
    put_ix_int(xp, (const ix_int *)ip);
#line 1116
#else
#line 1116
    ix_int xx = NC_FILL_INT;
#line 1116

#line 1116
#if IX_INT_MAX < INT_MAX
#line 1116
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1116
        
#line 1116
#ifdef ERANGE_FILL
#line 1116
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1116
#endif
#line 1116
        err = NC_ERANGE;
#line 1116
    }
#line 1116
#ifdef ERANGE_FILL
#line 1116
    else
#line 1116
#endif
#line 1116
#endif
#line 1116
        xx = (ix_int)*ip;
#line 1116

#line 1116
    put_ix_int(xp, &xx);
#line 1116
#endif
#line 1116
    return err;
#line 1116
}
#line 1116

#endif
static int
#line 1118
ncx_put_int_short(void *xp, const short *ip, void *fillp)
#line 1118
{
#line 1118
    int err=NC_NOERR;
#line 1118
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 1118
    put_ix_int(xp, (const ix_int *)ip);
#line 1118
#else
#line 1118
    ix_int xx = NC_FILL_INT;
#line 1118

#line 1118
#if IX_INT_MAX < SHORT_MAX
#line 1118
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1118
        
#line 1118
#ifdef ERANGE_FILL
#line 1118
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1118
#endif
#line 1118
        err = NC_ERANGE;
#line 1118
    }
#line 1118
#ifdef ERANGE_FILL
#line 1118
    else
#line 1118
#endif
#line 1118
#endif
#line 1118
        xx = (ix_int)*ip;
#line 1118

#line 1118
    put_ix_int(xp, &xx);
#line 1118
#endif
#line 1118
    return err;
#line 1118
}
#line 1118

static int
#line 1119
ncx_put_int_long(void *xp, const long *ip, void *fillp)
#line 1119
{
#line 1119
    int err=NC_NOERR;
#line 1119
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 1119
    put_ix_int(xp, (const ix_int *)ip);
#line 1119
#else
#line 1119
    ix_int xx = NC_FILL_INT;
#line 1119

#line 1119
#if IX_INT_MAX < LONG_MAX
#line 1119
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1119
        
#line 1119
#ifdef ERANGE_FILL
#line 1119
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1119
#endif
#line 1119
        err = NC_ERANGE;
#line 1119
    }
#line 1119
#ifdef ERANGE_FILL
#line 1119
    else
#line 1119
#endif
#line 1119
#endif
#line 1119
        xx = (ix_int)*ip;
#line 1119

#line 1119
    put_ix_int(xp, &xx);
#line 1119
#endif
#line 1119
    return err;
#line 1119
}
#line 1119

static int
#line 1120
ncx_put_int_longlong(void *xp, const longlong *ip, void *fillp)
#line 1120
{
#line 1120
    int err=NC_NOERR;
#line 1120
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 1120
    put_ix_int(xp, (const ix_int *)ip);
#line 1120
#else
#line 1120
    ix_int xx = NC_FILL_INT;
#line 1120

#line 1120
#if IX_INT_MAX < LONGLONG_MAX
#line 1120
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1120
        
#line 1120
#ifdef ERANGE_FILL
#line 1120
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1120
#endif
#line 1120
        err = NC_ERANGE;
#line 1120
    }
#line 1120
#ifdef ERANGE_FILL
#line 1120
    else
#line 1120
#endif
#line 1120
#endif
#line 1120
        xx = (ix_int)*ip;
#line 1120

#line 1120
    put_ix_int(xp, &xx);
#line 1120
#endif
#line 1120
    return err;
#line 1120
}
#line 1120

static int
#line 1121
ncx_put_int_ushort(void *xp, const ushort *ip, void *fillp)
#line 1121
{
#line 1121
    int err=NC_NOERR;
#line 1121
    ix_int xx = NC_FILL_INT;
#line 1121

#line 1121
#if IX_INT_MAX < USHORT_MAX
#line 1121
    if (*ip > IX_INT_MAX) {
#line 1121
        
#line 1121
#ifdef ERANGE_FILL
#line 1121
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1121
#endif
#line 1121
        err = NC_ERANGE;
#line 1121
    }
#line 1121
#ifdef ERANGE_FILL
#line 1121
    else
#line 1121
#endif
#line 1121
#endif
#line 1121
        xx = (ix_int)*ip;
#line 1121

#line 1121
    put_ix_int(xp, &xx);
#line 1121
    return err;
#line 1121
}
#line 1121

static int
#line 1122
ncx_put_int_uint(void *xp, const uint *ip, void *fillp)
#line 1122
{
#line 1122
    int err=NC_NOERR;
#line 1122
    ix_int xx = NC_FILL_INT;
#line 1122

#line 1122
#if IX_INT_MAX < UINT_MAX
#line 1122
    if (*ip > IX_INT_MAX) {
#line 1122
        
#line 1122
#ifdef ERANGE_FILL
#line 1122
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1122
#endif
#line 1122
        err = NC_ERANGE;
#line 1122
    }
#line 1122
#ifdef ERANGE_FILL
#line 1122
    else
#line 1122
#endif
#line 1122
#endif
#line 1122
        xx = (ix_int)*ip;
#line 1122

#line 1122
    put_ix_int(xp, &xx);
#line 1122
    return err;
#line 1122
}
#line 1122

static int
#line 1123
ncx_put_int_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1123
{
#line 1123
    int err=NC_NOERR;
#line 1123
    ix_int xx = NC_FILL_INT;
#line 1123

#line 1123
#if IX_INT_MAX < ULONGLONG_MAX
#line 1123
    if (*ip > IX_INT_MAX) {
#line 1123
        
#line 1123
#ifdef ERANGE_FILL
#line 1123
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1123
#endif
#line 1123
        err = NC_ERANGE;
#line 1123
    }
#line 1123
#ifdef ERANGE_FILL
#line 1123
    else
#line 1123
#endif
#line 1123
#endif
#line 1123
        xx = (ix_int)*ip;
#line 1123

#line 1123
    put_ix_int(xp, &xx);
#line 1123
    return err;
#line 1123
}
#line 1123

static int
#line 1124
ncx_put_int_float(void *xp, const float *ip, void *fillp)
#line 1124
{
#line 1124
    int err=NC_NOERR;
#line 1124
    ix_int xx = NC_FILL_INT;
#line 1124

#line 1124
    if (*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN) {
#line 1124
        
#line 1124
#ifdef ERANGE_FILL
#line 1124
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1124
#endif
#line 1124
        err = NC_ERANGE;
#line 1124
    }
#line 1124
#ifdef ERANGE_FILL
#line 1124
    else
#line 1124
#endif
#line 1124
        xx = (ix_int)*ip;
#line 1124

#line 1124
    put_ix_int(xp, &xx);
#line 1124
    return err;
#line 1124
}
#line 1124

static int
#line 1125
ncx_put_int_double(void *xp, const double *ip, void *fillp)
#line 1125
{
#line 1125
    int err=NC_NOERR;
#line 1125
    ix_int xx = NC_FILL_INT;
#line 1125

#line 1125
    if (*ip > X_INT_MAX || *ip < X_INT_MIN) {
#line 1125
        
#line 1125
#ifdef ERANGE_FILL
#line 1125
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1125
#endif
#line 1125
        err = NC_ERANGE;
#line 1125
    }
#line 1125
#ifdef ERANGE_FILL
#line 1125
    else
#line 1125
#endif
#line 1125
        xx = (ix_int)*ip;
#line 1125

#line 1125
    put_ix_int(xp, &xx);
#line 1125
    return err;
#line 1125
}
#line 1125



/* external NC_UINT ---------------------------------------------------------*/

#if USHORT_MAX == X_UINT_MAX
typedef ushort ix_uint;
#define SIZEOF_IX_UINT SIZEOF_USHORT
#define IX_UINT_MAX USHORT_MAX
#elif UINT_MAX  >= X_UINT_MAX
typedef uint ix_uint;
#define SIZEOF_IX_UINT SIZEOF_UINT
#define IX_UINT_MAX UINT_MAX
#elif ULONG_MAX  >= X_UINT_MAX
typedef ulong ix_uint;
#define SIZEOF_IX_UINT SIZEOF_ULONG
#define IX_UINT_MAX ULONG_MAX
#else
#error "ix_uint implementation"
#endif


static void
get_ix_uint(const void *xp, ix_uint *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = (ix_uint)(*cp++ << 24);
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 16));
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 8));
	*ip = (ix_uint)(*ip | *cp);
}

static void
put_ix_uint(void *xp, const ix_uint *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)((*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 1170
ncx_get_uint_uint(const void *xp, uint *ip)
#line 1170
{
#line 1170
    int err=NC_NOERR;
#line 1170
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 1170
    get_ix_uint(xp, (ix_uint *)ip);
#line 1170
#else
#line 1170
    ix_uint xx = 0;
#line 1170
    get_ix_uint(xp, &xx);
#line 1170

#line 1170
#if IX_UINT_MAX > UINT_MAX
#line 1170
    if (xx > UINT_MAX) {
#line 1170
#ifdef ERANGE_FILL
#line 1170
        *ip = NC_FILL_UINT;
#line 1170
        return NC_ERANGE;
#line 1170
#else
#line 1170
        err = NC_ERANGE;
#line 1170
#endif
#line 1170
    }
#line 1170
#endif
#line 1170

#line 1170

#line 1170
    *ip = (uint) xx;
#line 1170
#endif
#line 1170
    return err;
#line 1170
}
#line 1170

#endif

static int
#line 1173
ncx_get_uint_schar(const void *xp, schar *ip)
#line 1173
{
#line 1173
    int err=NC_NOERR;
#line 1173
    ix_uint xx = 0;
#line 1173
    get_ix_uint(xp, &xx);
#line 1173

#line 1173
#if IX_UINT_MAX > SCHAR_MAX
#line 1173
    if (xx > SCHAR_MAX) {
#line 1173
#ifdef ERANGE_FILL
#line 1173
        *ip = NC_FILL_BYTE;
#line 1173
        return NC_ERANGE;
#line 1173
#else
#line 1173
        err = NC_ERANGE;
#line 1173
#endif
#line 1173
    }
#line 1173
#endif
#line 1173

#line 1173

#line 1173
    *ip = (schar) xx;
#line 1173
    return err;
#line 1173
}
#line 1173

static int
#line 1174
ncx_get_uint_short(const void *xp, short *ip)
#line 1174
{
#line 1174
    int err=NC_NOERR;
#line 1174
    ix_uint xx = 0;
#line 1174
    get_ix_uint(xp, &xx);
#line 1174

#line 1174
#if IX_UINT_MAX > SHORT_MAX
#line 1174
    if (xx > SHORT_MAX) {
#line 1174
#ifdef ERANGE_FILL
#line 1174
        *ip = NC_FILL_SHORT;
#line 1174
        return NC_ERANGE;
#line 1174
#else
#line 1174
        err = NC_ERANGE;
#line 1174
#endif
#line 1174
    }
#line 1174
#endif
#line 1174

#line 1174

#line 1174
    *ip = (short) xx;
#line 1174
    return err;
#line 1174
}
#line 1174

static int
#line 1175
ncx_get_uint_int(const void *xp, int *ip)
#line 1175
{
#line 1175
    int err=NC_NOERR;
#line 1175
    ix_uint xx = 0;
#line 1175
    get_ix_uint(xp, &xx);
#line 1175

#line 1175
#if IX_UINT_MAX > INT_MAX
#line 1175
    if (xx > INT_MAX) {
#line 1175
#ifdef ERANGE_FILL
#line 1175
        *ip = NC_FILL_INT;
#line 1175
        return NC_ERANGE;
#line 1175
#else
#line 1175
        err = NC_ERANGE;
#line 1175
#endif
#line 1175
    }
#line 1175
#endif
#line 1175

#line 1175

#line 1175
    *ip = (int) xx;
#line 1175
    return err;
#line 1175
}
#line 1175

static int
#line 1176
ncx_get_uint_long(const void *xp, long *ip)
#line 1176
{
#line 1176
    int err=NC_NOERR;
#line 1176
    ix_uint xx = 0;
#line 1176
    get_ix_uint(xp, &xx);
#line 1176

#line 1176
#if IX_UINT_MAX > LONG_MAX
#line 1176
    if (xx > LONG_MAX) {
#line 1176
#ifdef ERANGE_FILL
#line 1176
        *ip = NC_FILL_INT;
#line 1176
        return NC_ERANGE;
#line 1176
#else
#line 1176
        err = NC_ERANGE;
#line 1176
#endif
#line 1176
    }
#line 1176
#endif
#line 1176

#line 1176

#line 1176
    *ip = (long) xx;
#line 1176
    return err;
#line 1176
}
#line 1176

static int
#line 1177
ncx_get_uint_longlong(const void *xp, longlong *ip)
#line 1177
{
#line 1177
    int err=NC_NOERR;
#line 1177
    ix_uint xx = 0;
#line 1177
    get_ix_uint(xp, &xx);
#line 1177

#line 1177
#if IX_UINT_MAX > LONGLONG_MAX
#line 1177
    if (xx > LONGLONG_MAX) {
#line 1177
#ifdef ERANGE_FILL
#line 1177
        *ip = NC_FILL_INT64;
#line 1177
        return NC_ERANGE;
#line 1177
#else
#line 1177
        err = NC_ERANGE;
#line 1177
#endif
#line 1177
    }
#line 1177
#endif
#line 1177

#line 1177

#line 1177
    *ip = (longlong) xx;
#line 1177
    return err;
#line 1177
}
#line 1177

static int
#line 1178
ncx_get_uint_ushort(const void *xp, ushort *ip)
#line 1178
{
#line 1178
    int err=NC_NOERR;
#line 1178
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 1178
    get_ix_uint(xp, (ix_uint *)ip);
#line 1178
#else
#line 1178
    ix_uint xx = 0;
#line 1178
    get_ix_uint(xp, &xx);
#line 1178

#line 1178
#if IX_UINT_MAX > USHORT_MAX
#line 1178
    if (xx > USHORT_MAX) {
#line 1178
#ifdef ERANGE_FILL
#line 1178
        *ip = NC_FILL_USHORT;
#line 1178
        return NC_ERANGE;
#line 1178
#else
#line 1178
        err = NC_ERANGE;
#line 1178
#endif
#line 1178
    }
#line 1178
#endif
#line 1178

#line 1178

#line 1178
    *ip = (ushort) xx;
#line 1178
#endif
#line 1178
    return err;
#line 1178
}
#line 1178

static int
#line 1179
ncx_get_uint_uchar(const void *xp, uchar *ip)
#line 1179
{
#line 1179
    int err=NC_NOERR;
#line 1179
#if SIZEOF_IX_UINT == SIZEOF_UCHAR && IX_UINT_MAX == UCHAR_MAX
#line 1179
    get_ix_uint(xp, (ix_uint *)ip);
#line 1179
#else
#line 1179
    ix_uint xx = 0;
#line 1179
    get_ix_uint(xp, &xx);
#line 1179

#line 1179
#if IX_UINT_MAX > UCHAR_MAX
#line 1179
    if (xx > UCHAR_MAX) {
#line 1179
#ifdef ERANGE_FILL
#line 1179
        *ip = NC_FILL_UBYTE;
#line 1179
        return NC_ERANGE;
#line 1179
#else
#line 1179
        err = NC_ERANGE;
#line 1179
#endif
#line 1179
    }
#line 1179
#endif
#line 1179

#line 1179

#line 1179
    *ip = (uchar) xx;
#line 1179
#endif
#line 1179
    return err;
#line 1179
}
#line 1179

static int
#line 1180
ncx_get_uint_ulonglong(const void *xp, ulonglong *ip)
#line 1180
{
#line 1180
    int err=NC_NOERR;
#line 1180
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 1180
    get_ix_uint(xp, (ix_uint *)ip);
#line 1180
#else
#line 1180
    ix_uint xx = 0;
#line 1180
    get_ix_uint(xp, &xx);
#line 1180

#line 1180
#if IX_UINT_MAX > ULONGLONG_MAX
#line 1180
    if (xx > ULONGLONG_MAX) {
#line 1180
#ifdef ERANGE_FILL
#line 1180
        *ip = NC_FILL_UINT64;
#line 1180
        return NC_ERANGE;
#line 1180
#else
#line 1180
        err = NC_ERANGE;
#line 1180
#endif
#line 1180
    }
#line 1180
#endif
#line 1180

#line 1180

#line 1180
    *ip = (ulonglong) xx;
#line 1180
#endif
#line 1180
    return err;
#line 1180
}
#line 1180

static int
#line 1181
ncx_get_uint_float(const void *xp, float *ip)
#line 1181
{
#line 1181
	ix_uint xx = 0;
#line 1181
	get_ix_uint(xp, &xx);
#line 1181
	*ip = (float)xx;
#line 1181
	return NC_NOERR;
#line 1181
}
#line 1181

static int
#line 1182
ncx_get_uint_double(const void *xp, double *ip)
#line 1182
{
#line 1182
	ix_uint xx = 0;
#line 1182
	get_ix_uint(xp, &xx);
#line 1182
	*ip = (double)xx;
#line 1182
	return NC_NOERR;
#line 1182
}
#line 1182


static int
ncx_put_uint_schar(void *xp, const schar *ip, void *fillp)
{
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 4);
#ifndef WORDS_BIGENDIAN
        swapn4b(xp, xp, 1);
#endif
#endif
        return NC_ERANGE;
    }

    cp = (uchar *) xp;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp = (uchar)*ip;

    return NC_NOERR;
}

static int
ncx_put_uint_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 1219
ncx_put_uint_uint(void *xp, const uint *ip, void *fillp)
#line 1219
{
#line 1219
    int err=NC_NOERR;
#line 1219
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 1219
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1219
#else
#line 1219
    ix_uint xx = NC_FILL_UINT;
#line 1219

#line 1219
#if IX_UINT_MAX < UINT_MAX
#line 1219
    if (*ip > IX_UINT_MAX) {
#line 1219
        
#line 1219
#ifdef ERANGE_FILL
#line 1219
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1219
#endif
#line 1219
        err = NC_ERANGE;
#line 1219
    }
#line 1219
#ifdef ERANGE_FILL
#line 1219
    else
#line 1219
#endif
#line 1219
#endif
#line 1219
        xx = (ix_uint)*ip;
#line 1219

#line 1219
    put_ix_uint(xp, &xx);
#line 1219
#endif
#line 1219
    return err;
#line 1219
}
#line 1219

#endif

static int
#line 1222
ncx_put_uint_short(void *xp, const short *ip, void *fillp)
#line 1222
{
#line 1222
    int err=NC_NOERR;
#line 1222
    ix_uint xx = NC_FILL_UINT;
#line 1222

#line 1222
#if IX_UINT_MAX < SHORT_MAX
#line 1222
    if (*ip > IX_UINT_MAX) {
#line 1222
        
#line 1222
#ifdef ERANGE_FILL
#line 1222
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1222
#endif
#line 1222
        err = NC_ERANGE;
#line 1222
    }
#line 1222
#ifdef ERANGE_FILL
#line 1222
    else
#line 1222
#endif
#line 1222
#endif
#line 1222
    if (*ip < 0) {
#line 1222
        
#line 1222
#ifdef ERANGE_FILL
#line 1222
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1222
#endif
#line 1222
        err = NC_ERANGE; /* because xp is unsigned */
#line 1222
    }
#line 1222
#ifdef ERANGE_FILL
#line 1222
    else
#line 1222
#endif
#line 1222
        xx = (ix_uint)*ip;
#line 1222

#line 1222
    put_ix_uint(xp, &xx);
#line 1222
    return err;
#line 1222
}
#line 1222

static int
#line 1223
ncx_put_uint_int(void *xp, const int *ip, void *fillp)
#line 1223
{
#line 1223
    int err=NC_NOERR;
#line 1223
    ix_uint xx = NC_FILL_UINT;
#line 1223

#line 1223
#if IX_UINT_MAX < INT_MAX
#line 1223
    if (*ip > IX_UINT_MAX) {
#line 1223
        
#line 1223
#ifdef ERANGE_FILL
#line 1223
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1223
#endif
#line 1223
        err = NC_ERANGE;
#line 1223
    }
#line 1223
#ifdef ERANGE_FILL
#line 1223
    else
#line 1223
#endif
#line 1223
#endif
#line 1223
    if (*ip < 0) {
#line 1223
        
#line 1223
#ifdef ERANGE_FILL
#line 1223
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1223
#endif
#line 1223
        err = NC_ERANGE; /* because xp is unsigned */
#line 1223
    }
#line 1223
#ifdef ERANGE_FILL
#line 1223
    else
#line 1223
#endif
#line 1223
        xx = (ix_uint)*ip;
#line 1223

#line 1223
    put_ix_uint(xp, &xx);
#line 1223
    return err;
#line 1223
}
#line 1223

static int
#line 1224
ncx_put_uint_long(void *xp, const long *ip, void *fillp)
#line 1224
{
#line 1224
    int err=NC_NOERR;
#line 1224
    ix_uint xx = NC_FILL_UINT;
#line 1224

#line 1224
#if IX_UINT_MAX < LONG_MAX
#line 1224
    if (*ip > IX_UINT_MAX) {
#line 1224
        
#line 1224
#ifdef ERANGE_FILL
#line 1224
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1224
#endif
#line 1224
        err = NC_ERANGE;
#line 1224
    }
#line 1224
#ifdef ERANGE_FILL
#line 1224
    else
#line 1224
#endif
#line 1224
#endif
#line 1224
    if (*ip < 0) {
#line 1224
        
#line 1224
#ifdef ERANGE_FILL
#line 1224
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1224
#endif
#line 1224
        err = NC_ERANGE; /* because xp is unsigned */
#line 1224
    }
#line 1224
#ifdef ERANGE_FILL
#line 1224
    else
#line 1224
#endif
#line 1224
        xx = (ix_uint)*ip;
#line 1224

#line 1224
    put_ix_uint(xp, &xx);
#line 1224
    return err;
#line 1224
}
#line 1224

static int
#line 1225
ncx_put_uint_longlong(void *xp, const longlong *ip, void *fillp)
#line 1225
{
#line 1225
    int err=NC_NOERR;
#line 1225
    ix_uint xx = NC_FILL_UINT;
#line 1225

#line 1225
#if IX_UINT_MAX < LONGLONG_MAX
#line 1225
    if (*ip > IX_UINT_MAX) {
#line 1225
        
#line 1225
#ifdef ERANGE_FILL
#line 1225
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1225
#endif
#line 1225
        err = NC_ERANGE;
#line 1225
    }
#line 1225
#ifdef ERANGE_FILL
#line 1225
    else
#line 1225
#endif
#line 1225
#endif
#line 1225
    if (*ip < 0) {
#line 1225
        
#line 1225
#ifdef ERANGE_FILL
#line 1225
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1225
#endif
#line 1225
        err = NC_ERANGE; /* because xp is unsigned */
#line 1225
    }
#line 1225
#ifdef ERANGE_FILL
#line 1225
    else
#line 1225
#endif
#line 1225
        xx = (ix_uint)*ip;
#line 1225

#line 1225
    put_ix_uint(xp, &xx);
#line 1225
    return err;
#line 1225
}
#line 1225

static int
#line 1226
ncx_put_uint_ushort(void *xp, const ushort *ip, void *fillp)
#line 1226
{
#line 1226
    int err=NC_NOERR;
#line 1226
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 1226
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1226
#else
#line 1226
    ix_uint xx = NC_FILL_UINT;
#line 1226

#line 1226
#if IX_UINT_MAX < USHORT_MAX
#line 1226
    if (*ip > IX_UINT_MAX) {
#line 1226
        
#line 1226
#ifdef ERANGE_FILL
#line 1226
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1226
#endif
#line 1226
        err = NC_ERANGE;
#line 1226
    }
#line 1226
#ifdef ERANGE_FILL
#line 1226
    else
#line 1226
#endif
#line 1226
#endif
#line 1226
        xx = (ix_uint)*ip;
#line 1226

#line 1226
    put_ix_uint(xp, &xx);
#line 1226
#endif
#line 1226
    return err;
#line 1226
}
#line 1226

static int
#line 1227
ncx_put_uint_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1227
{
#line 1227
    int err=NC_NOERR;
#line 1227
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 1227
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1227
#else
#line 1227
    ix_uint xx = NC_FILL_UINT;
#line 1227

#line 1227
#if IX_UINT_MAX < ULONGLONG_MAX
#line 1227
    if (*ip > IX_UINT_MAX) {
#line 1227
        
#line 1227
#ifdef ERANGE_FILL
#line 1227
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1227
#endif
#line 1227
        err = NC_ERANGE;
#line 1227
    }
#line 1227
#ifdef ERANGE_FILL
#line 1227
    else
#line 1227
#endif
#line 1227
#endif
#line 1227
        xx = (ix_uint)*ip;
#line 1227

#line 1227
    put_ix_uint(xp, &xx);
#line 1227
#endif
#line 1227
    return err;
#line 1227
}
#line 1227

static int
#line 1228
ncx_put_uint_float(void *xp, const float *ip, void *fillp)
#line 1228
{
#line 1228
    int err=NC_NOERR;
#line 1228
    ix_uint xx = NC_FILL_UINT;
#line 1228

#line 1228
    if (*ip > (double)X_UINT_MAX || *ip < 0) {
#line 1228
        
#line 1228
#ifdef ERANGE_FILL
#line 1228
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1228
#endif
#line 1228
        err = NC_ERANGE;
#line 1228
    }
#line 1228
#ifdef ERANGE_FILL
#line 1228
    else
#line 1228
#endif
#line 1228
        xx = (ix_uint)*ip;
#line 1228

#line 1228
    put_ix_uint(xp, &xx);
#line 1228
    return err;
#line 1228
}
#line 1228

static int
#line 1229
ncx_put_uint_double(void *xp, const double *ip, void *fillp)
#line 1229
{
#line 1229
    int err=NC_NOERR;
#line 1229
    ix_uint xx = NC_FILL_UINT;
#line 1229

#line 1229
    if (*ip > X_UINT_MAX || *ip < 0) {
#line 1229
        
#line 1229
#ifdef ERANGE_FILL
#line 1229
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1229
#endif
#line 1229
        err = NC_ERANGE;
#line 1229
    }
#line 1229
#ifdef ERANGE_FILL
#line 1229
    else
#line 1229
#endif
#line 1229
        xx = (ix_uint)*ip;
#line 1229

#line 1229
    put_ix_uint(xp, &xx);
#line 1229
    return err;
#line 1229
}
#line 1229



/* external NC_FLOAT --------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

inline static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_FLOAT);
#else
	swap4b(ip, xp);
#endif
}

inline static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

#line 1343
static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 1346
		const struct ieee_single *const isp =
#line 1346
			 (const struct ieee_single *) xp;
#line 1346
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 1346

#line 1346
		switch(exp) {
#line 1346
		case 0 :
#line 1346
			/* ieee subnormal */
#line 1346
			if (isp->mant_hi == min.ieee.mant_hi
#line 1346
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 1346
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 1346
			{
#line 1346
				*vsp = min.s;
#line 1346
			}
#line 1346
			else
#line 1346
			{
#line 1346
				unsigned mantissa = (isp->mant_hi << 16)
#line 1346
					 | isp->mant_lo_hi << 8
#line 1346
					 | isp->mant_lo_lo;
#line 1346
				unsigned tmp = mantissa >> 20;
#line 1346
				if (tmp >= 4) {
#line 1346
					vsp->exp = 2;
#line 1346
				} else if (tmp >= 2) {
#line 1346
					vsp->exp = 1;
#line 1346
				} else {
#line 1346
					*vsp = min.s;
#line 1346
					break;
#line 1346
				} /* else */
#line 1346
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 1346
				tmp <<= 3 - vsp->exp;
#line 1346
				vsp->mantissa2 = tmp;
#line 1346
				vsp->mantissa1 = (tmp >> 16);
#line 1346
			}
#line 1346
			break;
#line 1346
		case 0xfe :
#line 1346
		case 0xff :
#line 1346
			*vsp = max.s;
#line 1346
			break;
#line 1346
		default :
#line 1346
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 1346
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 1346
			vsp->mantissa1 = isp->mant_hi;
#line 1346
		}
#line 1346

#line 1346
		vsp->sign = isp->sign;
#line 1346

}

#line 1400

static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
#line 1404
			 (const struct vax_single *)ip;
#line 1404
		struct ieee_single *const isp = (struct ieee_single *) xp;
#line 1404

#line 1404
		switch(vsp->exp){
#line 1404
		case 0 :
#line 1404
			/* all vax float with zero exponent map to zero */
#line 1404
			*isp = min.ieee;
#line 1404
			break;
#line 1404
		case 2 :
#line 1404
		case 1 :
#line 1404
		{
#line 1404
			/* These will map to subnormals */
#line 1404
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 1404
					 | vsp->mantissa2;
#line 1404
			mantissa >>= 3 - vsp->exp;
#line 1404
			mantissa += (1 << (20 + vsp->exp));
#line 1404
			isp->mant_lo_lo = mantissa;
#line 1404
			isp->mant_lo_hi = mantissa >> 8;
#line 1404
			isp->mant_hi = mantissa >> 16;
#line 1404
			isp->exp_lo = 0;
#line 1404
			isp->exp_hi = 0;
#line 1404
		}
#line 1404
			break;
#line 1404
		case 0xff : /* max.s.exp */
#line 1404
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 1404
			    vsp->mantissa1 == max.s.mantissa1)
#line 1404
			{
#line 1404
				/* map largest vax float to ieee infinity */
#line 1404
				*isp = max.ieee;
#line 1404
				break;
#line 1404
			} /* else, fall thru */
#line 1404
		default :
#line 1404
		{
#line 1404
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 1404
			isp->exp_hi = exp >> 1;
#line 1404
			isp->exp_lo = exp;
#line 1404
			isp->mant_lo_lo = vsp->mantissa2;
#line 1404
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 1404
			isp->mant_hi = vsp->mantissa1;
#line 1404
		}
#line 1404
		}
#line 1404

#line 1404
		isp->sign = vsp->sign;
#line 1404

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very weird YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;

#line 1539

static void
get_ix_float(const void *xp, float *ip)
{

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1547

#line 1547
		if (isp->exp == 0)
#line 1547
		{
#line 1547
			/* ieee subnormal */
#line 1547
			*ip = (double)isp->mant;
#line 1547
			if (isp->mant != 0)
#line 1547
			{
#line 1547
				csp->exp -= (ieee_single_bias + 22);
#line 1547
			}
#line 1547
		}
#line 1547
		else
#line 1547
		{
#line 1547
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1547
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1547
			csp->mant |= (1 << (48 - 1));
#line 1547
		}
#line 1547
		csp->sign = isp->sign;
#line 1547

#line 1547

	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1552

#line 1552
		if (isp->exp == 0)
#line 1552
		{
#line 1552
			/* ieee subnormal */
#line 1552
			*ip = (double)isp->mant;
#line 1552
			if (isp->mant != 0)
#line 1552
			{
#line 1552
				csp->exp -= (ieee_single_bias + 22);
#line 1552
			}
#line 1552
		}
#line 1552
		else
#line 1552
		{
#line 1552
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1552
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1552
			csp->mant |= (1 << (48 - 1));
#line 1552
		}
#line 1552
		csp->sign = isp->sign;
#line 1552

#line 1552

	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1562
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1562

#line 1562
	isp->sign = csp->sign;
#line 1562

#line 1562
	if (ieee_exp >= 0xff)
#line 1562
	{
#line 1562
		/* NC_ERANGE => ieee Inf */
#line 1562
		isp->exp = 0xff;
#line 1562
		isp->mant = 0x0;
#line 1562
	}
#line 1562
	else if (ieee_exp > 0)
#line 1562
	{
#line 1562
		/* normal ieee representation */
#line 1562
		isp->exp  = ieee_exp;
#line 1562
		/* assumes cray rep is in normal form */
#line 1562
		assert(csp->mant & 0x800000000000);
#line 1562
		isp->mant = (((csp->mant << 1) &
#line 1562
				0xffffffffffff) >> (48 - 23));
#line 1562
	}
#line 1562
	else if (ieee_exp > -23)
#line 1562
	{
#line 1562
		/* ieee subnormal, right shift */
#line 1562
		const int rshift = (48 - 23 - ieee_exp);
#line 1562

#line 1562
		isp->mant = csp->mant >> rshift;
#line 1562

#line 1562
#if 0
#line 1562
		if (csp->mant & (1 << (rshift -1)))
#line 1562
		{
#line 1562
			/* round up */
#line 1562
			isp->mant++;
#line 1562
		}
#line 1562
#endif
#line 1562

#line 1562
		isp->exp  = 0;
#line 1562
	}
#line 1562
	else
#line 1562
	{
#line 1562
		/* smaller than ieee can represent */
#line 1562
		isp->exp = 0;
#line 1562
		isp->mant = 0;
#line 1562
	}
#line 1562

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1567
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1567

#line 1567
	isp->sign = csp->sign;
#line 1567

#line 1567
	if (ieee_exp >= 0xff)
#line 1567
	{
#line 1567
		/* NC_ERANGE => ieee Inf */
#line 1567
		isp->exp = 0xff;
#line 1567
		isp->mant = 0x0;
#line 1567
	}
#line 1567
	else if (ieee_exp > 0)
#line 1567
	{
#line 1567
		/* normal ieee representation */
#line 1567
		isp->exp  = ieee_exp;
#line 1567
		/* assumes cray rep is in normal form */
#line 1567
		assert(csp->mant & 0x800000000000);
#line 1567
		isp->mant = (((csp->mant << 1) &
#line 1567
				0xffffffffffff) >> (48 - 23));
#line 1567
	}
#line 1567
	else if (ieee_exp > -23)
#line 1567
	{
#line 1567
		/* ieee subnormal, right shift */
#line 1567
		const int rshift = (48 - 23 - ieee_exp);
#line 1567

#line 1567
		isp->mant = csp->mant >> rshift;
#line 1567

#line 1567
#if 0
#line 1567
		if (csp->mant & (1 << (rshift -1)))
#line 1567
		{
#line 1567
			/* round up */
#line 1567
			isp->mant++;
#line 1567
		}
#line 1567
#endif
#line 1567

#line 1567
		isp->exp  = 0;
#line 1567
	}
#line 1567
	else
#line 1567
	{
#line 1567
		/* smaller than ieee can represent */
#line 1567
		isp->exp = 0;
#line 1567
		isp->mant = 0;
#line 1567
	}
#line 1567

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif

#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_get_float_float(const void *xp, float *ip, void *fillp)
{
	/* TODO */
	get_ix_float(xp, ip);
	return NC_NOERR;
}
#endif

#define ix_float float

static int
#line 1654
ncx_get_float_schar(const void *xp, schar *ip)
#line 1654
{
#line 1654
	ix_float xx = 0;
#line 1654
	get_ix_float(xp, &xx);
#line 1654
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1654
#ifdef ERANGE_FILL
#line 1654
            *ip = NC_FILL_BYTE;
#line 1654
#endif
#line 1654
            return NC_ERANGE;
#line 1654
        }
#line 1654
	*ip = (schar)xx;
#line 1654
	return NC_NOERR;
#line 1654
}
#line 1654

static int
#line 1655
ncx_get_float_short(const void *xp, short *ip)
#line 1655
{
#line 1655
	ix_float xx = 0;
#line 1655
	get_ix_float(xp, &xx);
#line 1655
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1655
#ifdef ERANGE_FILL
#line 1655
            *ip = NC_FILL_SHORT;
#line 1655
#endif
#line 1655
            return NC_ERANGE;
#line 1655
        }
#line 1655
	*ip = (short)xx;
#line 1655
	return NC_NOERR;
#line 1655
}
#line 1655

static int
#line 1656
ncx_get_float_int(const void *xp, int *ip)
#line 1656
{
#line 1656
	ix_float xx = 0;
#line 1656
	get_ix_float(xp, &xx);
#line 1656
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1656
#ifdef ERANGE_FILL
#line 1656
            *ip = NC_FILL_INT;
#line 1656
#endif
#line 1656
            return NC_ERANGE;
#line 1656
        }
#line 1656
	*ip = (int)xx;
#line 1656
	return NC_NOERR;
#line 1656
}
#line 1656

static int
#line 1657
ncx_get_float_long(const void *xp, long *ip)
#line 1657
{
#line 1657
	ix_float xx = 0;
#line 1657
	get_ix_float(xp, &xx);
#line 1657
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1657
#ifdef ERANGE_FILL
#line 1657
            *ip = NC_FILL_INT;
#line 1657
#endif
#line 1657
            return NC_ERANGE;
#line 1657
        }
#line 1657
	*ip = (long)xx;
#line 1657
	return NC_NOERR;
#line 1657
}
#line 1657

static int
#line 1658
ncx_get_float_double(const void *xp, double *ip)
#line 1658
{
#line 1658
	ix_float xx = 0;
#line 1658
	get_ix_float(xp, &xx);
#line 1658
	*ip = (double)xx;
#line 1658
	return NC_NOERR;
#line 1658
}
#line 1658

static int
#line 1659
ncx_get_float_longlong(const void *xp, longlong *ip)
#line 1659
{
#line 1659
	ix_float xx = 0;
#line 1659
	get_ix_float(xp, &xx);
#line 1659
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1659
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1659
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1659
#ifdef ERANGE_FILL
#line 1659
            *ip = NC_FILL_INT64;
#line 1659
#endif
#line 1659
            return NC_ERANGE;
#line 1659
        }
#line 1659
	else *ip = (longlong)xx;
#line 1659
	return NC_NOERR;
#line 1659
}
#line 1659

static int
#line 1660
ncx_get_float_uchar(const void *xp, uchar *ip)
#line 1660
{
#line 1660
	ix_float xx = 0;
#line 1660
	get_ix_float(xp, &xx);
#line 1660
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1660
#ifdef ERANGE_FILL
#line 1660
            *ip = NC_FILL_UBYTE;
#line 1660
#endif
#line 1660
            return NC_ERANGE;
#line 1660
        }
#line 1660
	*ip = (uchar)xx;
#line 1660
	return NC_NOERR;
#line 1660
}
#line 1660

static int
#line 1661
ncx_get_float_ushort(const void *xp, ushort *ip)
#line 1661
{
#line 1661
	ix_float xx = 0;
#line 1661
	get_ix_float(xp, &xx);
#line 1661
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1661
#ifdef ERANGE_FILL
#line 1661
            *ip = NC_FILL_USHORT;
#line 1661
#endif
#line 1661
            return NC_ERANGE;
#line 1661
        }
#line 1661
	*ip = (ushort)xx;
#line 1661
	return NC_NOERR;
#line 1661
}
#line 1661

static int
#line 1662
ncx_get_float_uint(const void *xp, uint *ip)
#line 1662
{
#line 1662
	ix_float xx = 0;
#line 1662
	get_ix_float(xp, &xx);
#line 1662
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1662
#ifdef ERANGE_FILL
#line 1662
            *ip = NC_FILL_UINT;
#line 1662
#endif
#line 1662
            return NC_ERANGE;
#line 1662
        }
#line 1662
	*ip = (uint)xx;
#line 1662
	return NC_NOERR;
#line 1662
}
#line 1662

static int
#line 1663
ncx_get_float_ulonglong(const void *xp, ulonglong *ip)
#line 1663
{
#line 1663
	ix_float xx = 0;
#line 1663
	get_ix_float(xp, &xx);
#line 1663
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1663
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1663
#ifdef ERANGE_FILL
#line 1663
            *ip = NC_FILL_UINT64;
#line 1663
#endif
#line 1663
            return NC_ERANGE;
#line 1663
        }
#line 1663
	else *ip = (ulonglong)xx;
#line 1663
	return NC_NOERR;
#line 1663
}
#line 1663


#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_put_float_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    float *_ip=ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    float tmp;
#endif
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
        
#line 1676
#ifdef ERANGE_FILL
#line 1676
            if (fillp != NULL) memcpy(&tmp, fillp, 4);
#line 1676
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_float(xp, _ip);
    return err;
}
#endif

static int
#line 1688
ncx_put_float_schar(void *xp, const schar *ip, void *fillp)
#line 1688
{
#line 1688
    int err=NC_NOERR;
#line 1688
    ix_float xx = NC_FILL_FLOAT;
#line 1688

#line 1688
    
#line 1688
        xx = (ix_float)*ip;
#line 1688

#line 1688
    put_ix_float(xp, &xx);
#line 1688
    return err;
#line 1688
}
#line 1688

static int
#line 1689
ncx_put_float_short(void *xp, const short *ip, void *fillp)
#line 1689
{
#line 1689
    int err=NC_NOERR;
#line 1689
    ix_float xx = NC_FILL_FLOAT;
#line 1689

#line 1689
    
#line 1689
        xx = (ix_float)*ip;
#line 1689

#line 1689
    put_ix_float(xp, &xx);
#line 1689
    return err;
#line 1689
}
#line 1689

static int
#line 1690
ncx_put_float_int(void *xp, const int *ip, void *fillp)
#line 1690
{
#line 1690
    int err=NC_NOERR;
#line 1690
    ix_float xx = NC_FILL_FLOAT;
#line 1690

#line 1690
    
#line 1690
        xx = (ix_float)*ip;
#line 1690

#line 1690
    put_ix_float(xp, &xx);
#line 1690
    return err;
#line 1690
}
#line 1690

static int
#line 1691
ncx_put_float_long(void *xp, const long *ip, void *fillp)
#line 1691
{
#line 1691
    int err=NC_NOERR;
#line 1691
    ix_float xx = NC_FILL_FLOAT;
#line 1691

#line 1691
    
#line 1691
        xx = (ix_float)*ip;
#line 1691

#line 1691
    put_ix_float(xp, &xx);
#line 1691
    return err;
#line 1691
}
#line 1691

static int
#line 1692
ncx_put_float_double(void *xp, const double *ip, void *fillp)
#line 1692
{
#line 1692
    int err=NC_NOERR;
#line 1692
    ix_float xx = NC_FILL_FLOAT;
#line 1692

#line 1692
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
#line 1692
        
#line 1692
#ifdef ERANGE_FILL
#line 1692
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1692
#endif
#line 1692
        err = NC_ERANGE;
#line 1692
    }
#line 1692
#ifdef ERANGE_FILL
#line 1692
    else
#line 1692
#endif
#line 1692
        xx = (ix_float)*ip;
#line 1692

#line 1692
    put_ix_float(xp, &xx);
#line 1692
    return err;
#line 1692
}
#line 1692

static int
#line 1693
ncx_put_float_longlong(void *xp, const longlong *ip, void *fillp)
#line 1693
{
#line 1693
    int err=NC_NOERR;
#line 1693
    ix_float xx = NC_FILL_FLOAT;
#line 1693

#line 1693
    
#line 1693
        xx = (ix_float)*ip;
#line 1693

#line 1693
    put_ix_float(xp, &xx);
#line 1693
    return err;
#line 1693
}
#line 1693

static int
#line 1694
ncx_put_float_uchar(void *xp, const uchar *ip, void *fillp)
#line 1694
{
#line 1694
    int err=NC_NOERR;
#line 1694
    ix_float xx = NC_FILL_FLOAT;
#line 1694

#line 1694
    
#line 1694
        xx = (ix_float)*ip;
#line 1694

#line 1694
    put_ix_float(xp, &xx);
#line 1694
    return err;
#line 1694
}
#line 1694

static int
#line 1695
ncx_put_float_ushort(void *xp, const ushort *ip, void *fillp)
#line 1695
{
#line 1695
    int err=NC_NOERR;
#line 1695
    ix_float xx = NC_FILL_FLOAT;
#line 1695

#line 1695
    
#line 1695
        xx = (ix_float)*ip;
#line 1695

#line 1695
    put_ix_float(xp, &xx);
#line 1695
    return err;
#line 1695
}
#line 1695

static int
#line 1696
ncx_put_float_uint(void *xp, const uint *ip, void *fillp)
#line 1696
{
#line 1696
    int err=NC_NOERR;
#line 1696
    ix_float xx = NC_FILL_FLOAT;
#line 1696

#line 1696
    
#line 1696
        xx = (ix_float)*ip;
#line 1696

#line 1696
    put_ix_float(xp, &xx);
#line 1696
    return err;
#line 1696
}
#line 1696

static int
#line 1697
ncx_put_float_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1697
{
#line 1697
    int err=NC_NOERR;
#line 1697
    ix_float xx = NC_FILL_FLOAT;
#line 1697

#line 1697
    
#line 1697
        xx = (ix_float)*ip;
#line 1697

#line 1697
    put_ix_float(xp, &xx);
#line 1697
    return err;
#line 1697
}
#line 1697



/* external NC_DOUBLE -------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_DOUBLE);
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


#line 1811
static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
#line 1814
			 (struct vax_double *)ip;
#line 1814
	const struct ieee_double *const idp =
#line 1814
			 (const struct ieee_double *) xp;
#line 1814
	{
#line 1814
		const struct dbl_limits *lim;
#line 1814
		int ii;
#line 1814
		for (ii = 0, lim = dbl_limits;
#line 1814
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 1814
			ii++, lim++)
#line 1814
		{
#line 1814
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 1814
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 1814
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 1814
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 1814
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 1814
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 1814
				)
#line 1814
			{
#line 1814
				*vdp = lim->d;
#line 1814
				goto doneit;
#line 1814
			}
#line 1814
		}
#line 1814
	}
#line 1814
	{
#line 1814
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 1814
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 1814
	}
#line 1814
	{
#line 1814
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 1814
				 | (idp->mant_5 << 8)
#line 1814
				 | idp->mant_4);
#line 1814
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 1814
		vdp->mantissa1 = (mant_hi >> 13);
#line 1814
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 1814
				| (mant_lo >> 29);
#line 1814
		vdp->mantissa3 = (mant_lo >> 13);
#line 1814
		vdp->mantissa4 = (mant_lo << 3);
#line 1814
	}
#line 1814
	doneit:
#line 1814
		vdp->sign = idp->sign;
#line 1814

}


#line 1884
static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp =
#line 1887
			(const struct vax_double *)ip;
#line 1887
	struct ieee_double *const idp =
#line 1887
			 (struct ieee_double *) xp;
#line 1887

#line 1887
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 1887
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 1887
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 1887
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 1887
		(vdp->exp == dbl_limits[0].d.exp))
#line 1887
	{
#line 1887
		*idp = dbl_limits[0].ieee;
#line 1887
		goto shipit;
#line 1887
	}
#line 1887
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 1887
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 1887
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 1887
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 1887
		(vdp->exp == dbl_limits[1].d.exp))
#line 1887
	{
#line 1887
		*idp = dbl_limits[1].ieee;
#line 1887
		goto shipit;
#line 1887
	}
#line 1887

#line 1887
	{
#line 1887
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 1887

#line 1887
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 1887
			(vdp->mantissa3 << 13) |
#line 1887
			((vdp->mantissa4 >> 3) & MASK(13));
#line 1887

#line 1887
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 1887
				 | (vdp->mantissa2 >> 3);
#line 1887

#line 1887
		if ((vdp->mantissa4 & 7) > 4)
#line 1887
		{
#line 1887
			/* round up */
#line 1887
			mant_lo++;
#line 1887
			if (mant_lo == 0)
#line 1887
			{
#line 1887
				mant_hi++;
#line 1887
				if (mant_hi > 0xffffff)
#line 1887
				{
#line 1887
					mant_hi = 0;
#line 1887
					exp++;
#line 1887
				}
#line 1887
			}
#line 1887
		}
#line 1887

#line 1887
		idp->mant_lo = SWAP4(mant_lo);
#line 1887
		idp->mant_6 = mant_hi >> 16;
#line 1887
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 1887
		idp->mant_4 = mant_hi;
#line 1887
		idp->exp_hi = exp >> 4;
#line 1887
		idp->exp_lo = exp;
#line 1887
	}
#line 1887

#line 1887
	shipit:
#line 1887
		idp->sign = vdp->sign;
#line 1887

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if (idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if (idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if (ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if (ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if (ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if (ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if (csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

#define ix_double double

static int
#line 1979
ncx_get_double_schar(const void *xp, schar *ip)
#line 1979
{
#line 1979
	ix_double xx = 0;
#line 1979
	get_ix_double(xp, &xx);
#line 1979
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1979
#ifdef ERANGE_FILL
#line 1979
            *ip = NC_FILL_BYTE;
#line 1979
#endif
#line 1979
            return NC_ERANGE;
#line 1979
        }
#line 1979
	*ip = (schar)xx;
#line 1979
	return NC_NOERR;
#line 1979
}
#line 1979

static int
#line 1980
ncx_get_double_short(const void *xp, short *ip)
#line 1980
{
#line 1980
	ix_double xx = 0;
#line 1980
	get_ix_double(xp, &xx);
#line 1980
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1980
#ifdef ERANGE_FILL
#line 1980
            *ip = NC_FILL_SHORT;
#line 1980
#endif
#line 1980
            return NC_ERANGE;
#line 1980
        }
#line 1980
	*ip = (short)xx;
#line 1980
	return NC_NOERR;
#line 1980
}
#line 1980

static int
#line 1981
ncx_get_double_int(const void *xp, int *ip)
#line 1981
{
#line 1981
	ix_double xx = 0;
#line 1981
	get_ix_double(xp, &xx);
#line 1981
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1981
#ifdef ERANGE_FILL
#line 1981
            *ip = NC_FILL_INT;
#line 1981
#endif
#line 1981
            return NC_ERANGE;
#line 1981
        }
#line 1981
	*ip = (int)xx;
#line 1981
	return NC_NOERR;
#line 1981
}
#line 1981

static int
#line 1982
ncx_get_double_long(const void *xp, long *ip)
#line 1982
{
#line 1982
	ix_double xx = 0;
#line 1982
	get_ix_double(xp, &xx);
#line 1982
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1982
#ifdef ERANGE_FILL
#line 1982
            *ip = NC_FILL_INT;
#line 1982
#endif
#line 1982
            return NC_ERANGE;
#line 1982
        }
#line 1982
	*ip = (long)xx;
#line 1982
	return NC_NOERR;
#line 1982
}
#line 1982

static int
#line 1983
ncx_get_double_longlong(const void *xp, longlong *ip)
#line 1983
{
#line 1983
	ix_double xx = 0;
#line 1983
	get_ix_double(xp, &xx);
#line 1983
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1983
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1983
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1983
#ifdef ERANGE_FILL
#line 1983
            *ip = NC_FILL_INT64;
#line 1983
#endif
#line 1983
            return NC_ERANGE;
#line 1983
        }
#line 1983
	else *ip = (longlong)xx;
#line 1983
	return NC_NOERR;
#line 1983
}
#line 1983

static int
#line 1984
ncx_get_double_uchar(const void *xp, uchar *ip)
#line 1984
{
#line 1984
	ix_double xx = 0;
#line 1984
	get_ix_double(xp, &xx);
#line 1984
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1984
#ifdef ERANGE_FILL
#line 1984
            *ip = NC_FILL_UBYTE;
#line 1984
#endif
#line 1984
            return NC_ERANGE;
#line 1984
        }
#line 1984
	*ip = (uchar)xx;
#line 1984
	return NC_NOERR;
#line 1984
}
#line 1984

static int
#line 1985
ncx_get_double_ushort(const void *xp, ushort *ip)
#line 1985
{
#line 1985
	ix_double xx = 0;
#line 1985
	get_ix_double(xp, &xx);
#line 1985
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1985
#ifdef ERANGE_FILL
#line 1985
            *ip = NC_FILL_USHORT;
#line 1985
#endif
#line 1985
            return NC_ERANGE;
#line 1985
        }
#line 1985
	*ip = (ushort)xx;
#line 1985
	return NC_NOERR;
#line 1985
}
#line 1985

static int
#line 1986
ncx_get_double_uint(const void *xp, uint *ip)
#line 1986
{
#line 1986
	ix_double xx = 0;
#line 1986
	get_ix_double(xp, &xx);
#line 1986
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1986
#ifdef ERANGE_FILL
#line 1986
            *ip = NC_FILL_UINT;
#line 1986
#endif
#line 1986
            return NC_ERANGE;
#line 1986
        }
#line 1986
	*ip = (uint)xx;
#line 1986
	return NC_NOERR;
#line 1986
}
#line 1986

static int
#line 1987
ncx_get_double_ulonglong(const void *xp, ulonglong *ip)
#line 1987
{
#line 1987
	ix_double xx = 0;
#line 1987
	get_ix_double(xp, &xx);
#line 1987
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1987
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1987
#ifdef ERANGE_FILL
#line 1987
            *ip = NC_FILL_UINT64;
#line 1987
#endif
#line 1987
            return NC_ERANGE;
#line 1987
        }
#line 1987
	else *ip = (ulonglong)xx;
#line 1987
	return NC_NOERR;
#line 1987
}
#line 1987


static int
ncx_get_double_float(const void *xp, float *ip)
{
    double xx = 0.0;
    get_ix_double(xp, &xx);
    if (xx > FLT_MAX) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = FLT_MAX;
#endif
        return NC_ERANGE;
    }
    if (xx < (-FLT_MAX)) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = (-FLT_MAX);
#endif
        return NC_ERANGE;
    }
    *ip = (float) xx;
    return NC_NOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_get_double_double(const void *xp, double *ip, void *fillp)
{
	/* TODO */
	get_ix_double(xp, ip);
	return NC_NOERR;
}
#endif

static int
#line 2024
ncx_put_double_schar(void *xp, const schar *ip, void *fillp)
#line 2024
{
#line 2024
    int err=NC_NOERR;
#line 2024
    ix_double xx = NC_FILL_DOUBLE;
#line 2024

#line 2024
    
#line 2024
        xx = (ix_double)*ip;
#line 2024

#line 2024
    put_ix_double(xp, &xx);
#line 2024
    return err;
#line 2024
}
#line 2024

static int
#line 2025
ncx_put_double_uchar(void *xp, const uchar *ip, void *fillp)
#line 2025
{
#line 2025
    int err=NC_NOERR;
#line 2025
    ix_double xx = NC_FILL_DOUBLE;
#line 2025

#line 2025
    
#line 2025
        xx = (ix_double)*ip;
#line 2025

#line 2025
    put_ix_double(xp, &xx);
#line 2025
    return err;
#line 2025
}
#line 2025

static int
#line 2026
ncx_put_double_short(void *xp, const short *ip, void *fillp)
#line 2026
{
#line 2026
    int err=NC_NOERR;
#line 2026
    ix_double xx = NC_FILL_DOUBLE;
#line 2026

#line 2026
    
#line 2026
        xx = (ix_double)*ip;
#line 2026

#line 2026
    put_ix_double(xp, &xx);
#line 2026
    return err;
#line 2026
}
#line 2026

static int
#line 2027
ncx_put_double_ushort(void *xp, const ushort *ip, void *fillp)
#line 2027
{
#line 2027
    int err=NC_NOERR;
#line 2027
    ix_double xx = NC_FILL_DOUBLE;
#line 2027

#line 2027
    
#line 2027
        xx = (ix_double)*ip;
#line 2027

#line 2027
    put_ix_double(xp, &xx);
#line 2027
    return err;
#line 2027
}
#line 2027

static int
#line 2028
ncx_put_double_int(void *xp, const int *ip, void *fillp)
#line 2028
{
#line 2028
    int err=NC_NOERR;
#line 2028
    ix_double xx = NC_FILL_DOUBLE;
#line 2028

#line 2028
    
#line 2028
        xx = (ix_double)*ip;
#line 2028

#line 2028
    put_ix_double(xp, &xx);
#line 2028
    return err;
#line 2028
}
#line 2028

static int
#line 2029
ncx_put_double_long(void *xp, const long *ip, void *fillp)
#line 2029
{
#line 2029
    int err=NC_NOERR;
#line 2029
    ix_double xx = NC_FILL_DOUBLE;
#line 2029

#line 2029
    
#line 2029
        xx = (ix_double)*ip;
#line 2029

#line 2029
    put_ix_double(xp, &xx);
#line 2029
    return err;
#line 2029
}
#line 2029

static int
#line 2030
ncx_put_double_uint(void *xp, const uint *ip, void *fillp)
#line 2030
{
#line 2030
    int err=NC_NOERR;
#line 2030
    ix_double xx = NC_FILL_DOUBLE;
#line 2030

#line 2030
    
#line 2030
        xx = (ix_double)*ip;
#line 2030

#line 2030
    put_ix_double(xp, &xx);
#line 2030
    return err;
#line 2030
}
#line 2030

static int
#line 2031
ncx_put_double_longlong(void *xp, const longlong *ip, void *fillp)
#line 2031
{
#line 2031
    int err=NC_NOERR;
#line 2031
    ix_double xx = NC_FILL_DOUBLE;
#line 2031

#line 2031
    
#line 2031
        xx = (ix_double)*ip;
#line 2031

#line 2031
    put_ix_double(xp, &xx);
#line 2031
    return err;
#line 2031
}
#line 2031

static int
#line 2032
ncx_put_double_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2032
{
#line 2032
    int err=NC_NOERR;
#line 2032
    ix_double xx = NC_FILL_DOUBLE;
#line 2032

#line 2032
    
#line 2032
        xx = (ix_double)*ip;
#line 2032

#line 2032
    put_ix_double(xp, &xx);
#line 2032
    return err;
#line 2032
}
#line 2032


static int
ncx_put_double_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    double xx = NC_FILL_DOUBLE;
#if 1	/* TODO: figure this out (if condition below will never be true)*/
    if ((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN) {
        
#line 2041
#ifdef ERANGE_FILL
#line 2041
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2041
#endif
        err = NC_ERANGE;
    }
#ifdef ERANGE_FILL
    else
#endif
#endif
        xx = (double) *ip;

    put_ix_double(xp, &xx);
    return err;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_put_double_double(void *xp, const double *ip, void *fillp)
{
    int err=NC_NOERR;
    double *_ip = ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    double tmp=NC_FILL_DOUBLE;
#endif
    if (*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN) {
        
#line 2065
#ifdef ERANGE_FILL
#line 2065
            if (fillp != NULL) memcpy(&tmp, fillp, 8);
#line 2065
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_double(xp, _ip);
    return err;
}
#endif


/* external NC_INT64 --------------------------------------------------------*/

#if SHORT_MAX == X_INT64_MAX
typedef short ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_SHORT
#define IX_INT64_MAX SHORT_MAX
#elif LONG_LONG_MAX  >= X_INT64_MAX
typedef longlong ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONGLONG
#define IX_INT64_MAX LONG_LONG_MAX
#elif LONG_MAX  >= X_INT64_MAX
typedef long ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONG
#define IX_INT64_MAX LONG_MAX
#else
#error "ix_int64 implementation"
#endif


static void
get_ix_int64(const void *xp, ix_int64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_int64)(*cp++) << 56);
    *ip |= ((ix_int64)(*cp++) << 48);
    *ip |= ((ix_int64)(*cp++) << 40);
    *ip |= ((ix_int64)(*cp++) << 32);
    *ip |= ((ix_int64)(*cp++) << 24);
    *ip |= ((ix_int64)(*cp++) << 16);
    *ip |= ((ix_int64)(*cp++) <<  8);
    *ip |=  (ix_int64)*cp;
}

static void
put_ix_int64(void *xp, const ix_int64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffLL);
}

#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 2128
ncx_get_longlong_longlong(const void *xp, longlong *ip)
#line 2128
{
#line 2128
    int err=NC_NOERR;
#line 2128
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 2128
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2128
#else
#line 2128
    ix_int64 xx = 0;
#line 2128
    get_ix_int64(xp, &xx);
#line 2128

#line 2128
#if IX_INT64_MAX > LONGLONG_MAX
#line 2128
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 2128
#ifdef ERANGE_FILL
#line 2128
        *ip = NC_FILL_INT64;
#line 2128
        return NC_ERANGE;
#line 2128
#else
#line 2128
        err = NC_ERANGE;
#line 2128
#endif
#line 2128
    }
#line 2128
#endif
#line 2128

#line 2128

#line 2128
    *ip = (longlong) xx;
#line 2128
#endif
#line 2128
    return err;
#line 2128
}
#line 2128

#endif
static int
#line 2130
ncx_get_longlong_schar(const void *xp, schar *ip)
#line 2130
{
#line 2130
    int err=NC_NOERR;
#line 2130
    ix_int64 xx = 0;
#line 2130
    get_ix_int64(xp, &xx);
#line 2130

#line 2130
#if IX_INT64_MAX > SCHAR_MAX
#line 2130
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 2130
#ifdef ERANGE_FILL
#line 2130
        *ip = NC_FILL_BYTE;
#line 2130
        return NC_ERANGE;
#line 2130
#else
#line 2130
        err = NC_ERANGE;
#line 2130
#endif
#line 2130
    }
#line 2130
#endif
#line 2130

#line 2130

#line 2130
    *ip = (schar) xx;
#line 2130
    return err;
#line 2130
}
#line 2130

static int
#line 2131
ncx_get_longlong_short(const void *xp, short *ip)
#line 2131
{
#line 2131
    int err=NC_NOERR;
#line 2131
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 2131
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2131
#else
#line 2131
    ix_int64 xx = 0;
#line 2131
    get_ix_int64(xp, &xx);
#line 2131

#line 2131
#if IX_INT64_MAX > SHORT_MAX
#line 2131
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 2131
#ifdef ERANGE_FILL
#line 2131
        *ip = NC_FILL_SHORT;
#line 2131
        return NC_ERANGE;
#line 2131
#else
#line 2131
        err = NC_ERANGE;
#line 2131
#endif
#line 2131
    }
#line 2131
#endif
#line 2131

#line 2131

#line 2131
    *ip = (short) xx;
#line 2131
#endif
#line 2131
    return err;
#line 2131
}
#line 2131

static int
#line 2132
ncx_get_longlong_int(const void *xp, int *ip)
#line 2132
{
#line 2132
    int err=NC_NOERR;
#line 2132
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 2132
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2132
#else
#line 2132
    ix_int64 xx = 0;
#line 2132
    get_ix_int64(xp, &xx);
#line 2132

#line 2132
#if IX_INT64_MAX > INT_MAX
#line 2132
    if (xx > INT_MAX || xx < INT_MIN) {
#line 2132
#ifdef ERANGE_FILL
#line 2132
        *ip = NC_FILL_INT;
#line 2132
        return NC_ERANGE;
#line 2132
#else
#line 2132
        err = NC_ERANGE;
#line 2132
#endif
#line 2132
    }
#line 2132
#endif
#line 2132

#line 2132

#line 2132
    *ip = (int) xx;
#line 2132
#endif
#line 2132
    return err;
#line 2132
}
#line 2132

static int
#line 2133
ncx_get_longlong_long(const void *xp, long *ip)
#line 2133
{
#line 2133
    int err=NC_NOERR;
#line 2133
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 2133
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2133
#else
#line 2133
    ix_int64 xx = 0;
#line 2133
    get_ix_int64(xp, &xx);
#line 2133

#line 2133
#if IX_INT64_MAX > LONG_MAX
#line 2133
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 2133
#ifdef ERANGE_FILL
#line 2133
        *ip = NC_FILL_INT;
#line 2133
        return NC_ERANGE;
#line 2133
#else
#line 2133
        err = NC_ERANGE;
#line 2133
#endif
#line 2133
    }
#line 2133
#endif
#line 2133

#line 2133

#line 2133
    *ip = (long) xx;
#line 2133
#endif
#line 2133
    return err;
#line 2133
}
#line 2133

static int
#line 2134
ncx_get_longlong_ushort(const void *xp, ushort *ip)
#line 2134
{
#line 2134
    int err=NC_NOERR;
#line 2134
    ix_int64 xx = 0;
#line 2134
    get_ix_int64(xp, &xx);
#line 2134

#line 2134
#if IX_INT64_MAX > USHORT_MAX
#line 2134
    if (xx > USHORT_MAX) {
#line 2134
#ifdef ERANGE_FILL
#line 2134
        *ip = NC_FILL_USHORT;
#line 2134
        return NC_ERANGE;
#line 2134
#else
#line 2134
        err = NC_ERANGE;
#line 2134
#endif
#line 2134
    }
#line 2134
#endif
#line 2134

#line 2134
    if (xx < 0) {
#line 2134
#ifdef ERANGE_FILL
#line 2134
        *ip = NC_FILL_USHORT;
#line 2134
        return NC_ERANGE;
#line 2134
#else
#line 2134
        err = NC_ERANGE; /* because ip is unsigned */
#line 2134
#endif
#line 2134
    }
#line 2134
    *ip = (ushort) xx;
#line 2134
    return err;
#line 2134
}
#line 2134

static int
#line 2135
ncx_get_longlong_uchar(const void *xp, uchar *ip)
#line 2135
{
#line 2135
    int err=NC_NOERR;
#line 2135
    ix_int64 xx = 0;
#line 2135
    get_ix_int64(xp, &xx);
#line 2135

#line 2135
#if IX_INT64_MAX > UCHAR_MAX
#line 2135
    if (xx > UCHAR_MAX) {
#line 2135
#ifdef ERANGE_FILL
#line 2135
        *ip = NC_FILL_UBYTE;
#line 2135
        return NC_ERANGE;
#line 2135
#else
#line 2135
        err = NC_ERANGE;
#line 2135
#endif
#line 2135
    }
#line 2135
#endif
#line 2135

#line 2135
    if (xx < 0) {
#line 2135
#ifdef ERANGE_FILL
#line 2135
        *ip = NC_FILL_UBYTE;
#line 2135
        return NC_ERANGE;
#line 2135
#else
#line 2135
        err = NC_ERANGE; /* because ip is unsigned */
#line 2135
#endif
#line 2135
    }
#line 2135
    *ip = (uchar) xx;
#line 2135
    return err;
#line 2135
}
#line 2135

static int
#line 2136
ncx_get_longlong_uint(const void *xp, uint *ip)
#line 2136
{
#line 2136
    int err=NC_NOERR;
#line 2136
    ix_int64 xx = 0;
#line 2136
    get_ix_int64(xp, &xx);
#line 2136

#line 2136
#if IX_INT64_MAX > UINT_MAX
#line 2136
    if (xx > UINT_MAX) {
#line 2136
#ifdef ERANGE_FILL
#line 2136
        *ip = NC_FILL_UINT;
#line 2136
        return NC_ERANGE;
#line 2136
#else
#line 2136
        err = NC_ERANGE;
#line 2136
#endif
#line 2136
    }
#line 2136
#endif
#line 2136

#line 2136
    if (xx < 0) {
#line 2136
#ifdef ERANGE_FILL
#line 2136
        *ip = NC_FILL_UINT;
#line 2136
        return NC_ERANGE;
#line 2136
#else
#line 2136
        err = NC_ERANGE; /* because ip is unsigned */
#line 2136
#endif
#line 2136
    }
#line 2136
    *ip = (uint) xx;
#line 2136
    return err;
#line 2136
}
#line 2136

static int
#line 2137
ncx_get_longlong_ulonglong(const void *xp, ulonglong *ip)
#line 2137
{
#line 2137
    int err=NC_NOERR;
#line 2137
    ix_int64 xx = 0;
#line 2137
    get_ix_int64(xp, &xx);
#line 2137

#line 2137
#if IX_INT64_MAX > ULONGLONG_MAX
#line 2137
    if (xx > ULONGLONG_MAX) {
#line 2137
#ifdef ERANGE_FILL
#line 2137
        *ip = NC_FILL_UINT64;
#line 2137
        return NC_ERANGE;
#line 2137
#else
#line 2137
        err = NC_ERANGE;
#line 2137
#endif
#line 2137
    }
#line 2137
#endif
#line 2137

#line 2137
    if (xx < 0) {
#line 2137
#ifdef ERANGE_FILL
#line 2137
        *ip = NC_FILL_UINT64;
#line 2137
        return NC_ERANGE;
#line 2137
#else
#line 2137
        err = NC_ERANGE; /* because ip is unsigned */
#line 2137
#endif
#line 2137
    }
#line 2137
    *ip = (ulonglong) xx;
#line 2137
    return err;
#line 2137
}
#line 2137

static int
#line 2138
ncx_get_longlong_float(const void *xp, float *ip)
#line 2138
{
#line 2138
	ix_int64 xx = 0;
#line 2138
	get_ix_int64(xp, &xx);
#line 2138
	*ip = (float)xx;
#line 2138
	return NC_NOERR;
#line 2138
}
#line 2138

static int
#line 2139
ncx_get_longlong_double(const void *xp, double *ip)
#line 2139
{
#line 2139
	ix_int64 xx = 0;
#line 2139
	get_ix_int64(xp, &xx);
#line 2139
	*ip = (double)xx;
#line 2139
	return NC_NOERR;
#line 2139
}
#line 2139


#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 2142
ncx_put_longlong_longlong(void *xp, const longlong *ip, void *fillp)
#line 2142
{
#line 2142
    int err=NC_NOERR;
#line 2142
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 2142
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2142
#else
#line 2142
    ix_int64 xx = NC_FILL_INT64;
#line 2142

#line 2142
#if IX_INT64_MAX < LONGLONG_MAX
#line 2142
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2142
        
#line 2142
#ifdef ERANGE_FILL
#line 2142
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2142
#endif
#line 2142
        err = NC_ERANGE;
#line 2142
    }
#line 2142
#ifdef ERANGE_FILL
#line 2142
    else
#line 2142
#endif
#line 2142
#endif
#line 2142
        xx = (ix_int64)*ip;
#line 2142

#line 2142
    put_ix_int64(xp, &xx);
#line 2142
#endif
#line 2142
    return err;
#line 2142
}
#line 2142

#endif
static int
#line 2144
ncx_put_longlong_schar(void *xp, const schar *ip, void *fillp)
#line 2144
{
#line 2144
    int err=NC_NOERR;
#line 2144
    ix_int64 xx = NC_FILL_INT64;
#line 2144

#line 2144
#if IX_INT64_MAX < SCHAR_MAX
#line 2144
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2144
        
#line 2144
#ifdef ERANGE_FILL
#line 2144
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2144
#endif
#line 2144
        err = NC_ERANGE;
#line 2144
    }
#line 2144
#ifdef ERANGE_FILL
#line 2144
    else
#line 2144
#endif
#line 2144
#endif
#line 2144
        xx = (ix_int64)*ip;
#line 2144

#line 2144
    put_ix_int64(xp, &xx);
#line 2144
    return err;
#line 2144
}
#line 2144

static int
#line 2145
ncx_put_longlong_short(void *xp, const short *ip, void *fillp)
#line 2145
{
#line 2145
    int err=NC_NOERR;
#line 2145
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 2145
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2145
#else
#line 2145
    ix_int64 xx = NC_FILL_INT64;
#line 2145

#line 2145
#if IX_INT64_MAX < SHORT_MAX
#line 2145
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2145
        
#line 2145
#ifdef ERANGE_FILL
#line 2145
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2145
#endif
#line 2145
        err = NC_ERANGE;
#line 2145
    }
#line 2145
#ifdef ERANGE_FILL
#line 2145
    else
#line 2145
#endif
#line 2145
#endif
#line 2145
        xx = (ix_int64)*ip;
#line 2145

#line 2145
    put_ix_int64(xp, &xx);
#line 2145
#endif
#line 2145
    return err;
#line 2145
}
#line 2145

static int
#line 2146
ncx_put_longlong_int(void *xp, const int *ip, void *fillp)
#line 2146
{
#line 2146
    int err=NC_NOERR;
#line 2146
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 2146
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2146
#else
#line 2146
    ix_int64 xx = NC_FILL_INT64;
#line 2146

#line 2146
#if IX_INT64_MAX < INT_MAX
#line 2146
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2146
        
#line 2146
#ifdef ERANGE_FILL
#line 2146
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2146
#endif
#line 2146
        err = NC_ERANGE;
#line 2146
    }
#line 2146
#ifdef ERANGE_FILL
#line 2146
    else
#line 2146
#endif
#line 2146
#endif
#line 2146
        xx = (ix_int64)*ip;
#line 2146

#line 2146
    put_ix_int64(xp, &xx);
#line 2146
#endif
#line 2146
    return err;
#line 2146
}
#line 2146

static int
#line 2147
ncx_put_longlong_long(void *xp, const long *ip, void *fillp)
#line 2147
{
#line 2147
    int err=NC_NOERR;
#line 2147
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 2147
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2147
#else
#line 2147
    ix_int64 xx = NC_FILL_INT64;
#line 2147

#line 2147
#if IX_INT64_MAX < LONG_MAX
#line 2147
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2147
        
#line 2147
#ifdef ERANGE_FILL
#line 2147
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2147
#endif
#line 2147
        err = NC_ERANGE;
#line 2147
    }
#line 2147
#ifdef ERANGE_FILL
#line 2147
    else
#line 2147
#endif
#line 2147
#endif
#line 2147
        xx = (ix_int64)*ip;
#line 2147

#line 2147
    put_ix_int64(xp, &xx);
#line 2147
#endif
#line 2147
    return err;
#line 2147
}
#line 2147

static int
#line 2148
ncx_put_longlong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2148
{
#line 2148
    int err=NC_NOERR;
#line 2148
    ix_int64 xx = NC_FILL_INT64;
#line 2148

#line 2148
#if IX_INT64_MAX < USHORT_MAX
#line 2148
    if (*ip > IX_INT64_MAX) {
#line 2148
        
#line 2148
#ifdef ERANGE_FILL
#line 2148
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2148
#endif
#line 2148
        err = NC_ERANGE;
#line 2148
    }
#line 2148
#ifdef ERANGE_FILL
#line 2148
    else
#line 2148
#endif
#line 2148
#endif
#line 2148
        xx = (ix_int64)*ip;
#line 2148

#line 2148
    put_ix_int64(xp, &xx);
#line 2148
    return err;
#line 2148
}
#line 2148

static int
#line 2149
ncx_put_longlong_uchar(void *xp, const uchar *ip, void *fillp)
#line 2149
{
#line 2149
    int err=NC_NOERR;
#line 2149
    ix_int64 xx = NC_FILL_INT64;
#line 2149

#line 2149
#if IX_INT64_MAX < UCHAR_MAX
#line 2149
    if (*ip > IX_INT64_MAX) {
#line 2149
        
#line 2149
#ifdef ERANGE_FILL
#line 2149
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2149
#endif
#line 2149
        err = NC_ERANGE;
#line 2149
    }
#line 2149
#ifdef ERANGE_FILL
#line 2149
    else
#line 2149
#endif
#line 2149
#endif
#line 2149
        xx = (ix_int64)*ip;
#line 2149

#line 2149
    put_ix_int64(xp, &xx);
#line 2149
    return err;
#line 2149
}
#line 2149

static int
#line 2150
ncx_put_longlong_uint(void *xp, const uint *ip, void *fillp)
#line 2150
{
#line 2150
    int err=NC_NOERR;
#line 2150
    ix_int64 xx = NC_FILL_INT64;
#line 2150

#line 2150
#if IX_INT64_MAX < UINT_MAX
#line 2150
    if (*ip > IX_INT64_MAX) {
#line 2150
        
#line 2150
#ifdef ERANGE_FILL
#line 2150
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2150
#endif
#line 2150
        err = NC_ERANGE;
#line 2150
    }
#line 2150
#ifdef ERANGE_FILL
#line 2150
    else
#line 2150
#endif
#line 2150
#endif
#line 2150
        xx = (ix_int64)*ip;
#line 2150

#line 2150
    put_ix_int64(xp, &xx);
#line 2150
    return err;
#line 2150
}
#line 2150

static int
#line 2151
ncx_put_longlong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2151
{
#line 2151
    int err=NC_NOERR;
#line 2151
    ix_int64 xx = NC_FILL_INT64;
#line 2151

#line 2151
#if IX_INT64_MAX < ULONGLONG_MAX
#line 2151
    if (*ip > IX_INT64_MAX) {
#line 2151
        
#line 2151
#ifdef ERANGE_FILL
#line 2151
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2151
#endif
#line 2151
        err = NC_ERANGE;
#line 2151
    }
#line 2151
#ifdef ERANGE_FILL
#line 2151
    else
#line 2151
#endif
#line 2151
#endif
#line 2151
        xx = (ix_int64)*ip;
#line 2151

#line 2151
    put_ix_int64(xp, &xx);
#line 2151
    return err;
#line 2151
}
#line 2151

static int
#line 2152
ncx_put_longlong_float(void *xp, const float *ip, void *fillp)
#line 2152
{
#line 2152
    int err=NC_NOERR;
#line 2152
    ix_int64 xx = NC_FILL_INT64;
#line 2152

#line 2152
    if (*ip > (double)X_INT64_MAX || *ip < (double)X_INT64_MIN) {
#line 2152
        
#line 2152
#ifdef ERANGE_FILL
#line 2152
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2152
#endif
#line 2152
        err = NC_ERANGE;
#line 2152
    }
#line 2152
#ifdef ERANGE_FILL
#line 2152
    else
#line 2152
#endif
#line 2152
        xx = (ix_int64)*ip;
#line 2152

#line 2152
    put_ix_int64(xp, &xx);
#line 2152
    return err;
#line 2152
}
#line 2152

static int
#line 2153
ncx_put_longlong_double(void *xp, const double *ip, void *fillp)
#line 2153
{
#line 2153
    int err=NC_NOERR;
#line 2153
    ix_int64 xx = NC_FILL_INT64;
#line 2153

#line 2153
    if (*ip > X_INT64_MAX || *ip < X_INT64_MIN) {
#line 2153
        
#line 2153
#ifdef ERANGE_FILL
#line 2153
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2153
#endif
#line 2153
        err = NC_ERANGE;
#line 2153
    }
#line 2153
#ifdef ERANGE_FILL
#line 2153
    else
#line 2153
#endif
#line 2153
        xx = (ix_int64)*ip;
#line 2153

#line 2153
    put_ix_int64(xp, &xx);
#line 2153
    return err;
#line 2153
}
#line 2153



/* external NC_UINT64 -------------------------------------------------------*/

#if USHORT_MAX == X_UINT64_MAX
typedef ushort ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_USHORT
#define IX_UINT64_MAX USHORT_MAX
#elif ULONG_LONG_MAX  >= X_UINT64_MAX
typedef ulonglong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONGLONG
#define IX_UINT64_MAX ULONG_LONG_MAX
#elif ULONG_MAX  >= X_UINT64_MAX
typedef ulong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONG
#define IX_UINT64_MAX ULONG_MAX
#else
#error "ix_uint64 implementation"
#endif


static void
get_ix_uint64(const void *xp, ix_uint64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_uint64)(*cp++) << 56);
    *ip |= ((ix_uint64)(*cp++) << 48);
    *ip |= ((ix_uint64)(*cp++) << 40);
    *ip |= ((ix_uint64)(*cp++) << 32);
    *ip |= ((ix_uint64)(*cp++) << 24);
    *ip |= ((ix_uint64)(*cp++) << 16);
    *ip |= ((ix_uint64)(*cp++) <<  8);
    *ip |=  (ix_uint64)*cp;
}

static void
put_ix_uint64(void *xp, const ix_uint64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000ULL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000ULL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000ULL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000ULL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000ULL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00ULL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffULL);
}

#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 2206
ncx_get_ulonglong_ulonglong(const void *xp, ulonglong *ip)
#line 2206
{
#line 2206
    int err=NC_NOERR;
#line 2206
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 2206
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2206
#else
#line 2206
    ix_uint64 xx = 0;
#line 2206
    get_ix_uint64(xp, &xx);
#line 2206

#line 2206
#if IX_UINT64_MAX > ULONGLONG_MAX
#line 2206
    if (xx > ULONGLONG_MAX) {
#line 2206
#ifdef ERANGE_FILL
#line 2206
        *ip = NC_FILL_UINT64;
#line 2206
        return NC_ERANGE;
#line 2206
#else
#line 2206
        err = NC_ERANGE;
#line 2206
#endif
#line 2206
    }
#line 2206
#endif
#line 2206

#line 2206

#line 2206
    *ip = (ulonglong) xx;
#line 2206
#endif
#line 2206
    return err;
#line 2206
}
#line 2206

#endif
static int
#line 2208
ncx_get_ulonglong_schar(const void *xp, schar *ip)
#line 2208
{
#line 2208
    int err=NC_NOERR;
#line 2208
    ix_uint64 xx = 0;
#line 2208
    get_ix_uint64(xp, &xx);
#line 2208

#line 2208
#if IX_UINT64_MAX > SCHAR_MAX
#line 2208
    if (xx > SCHAR_MAX) {
#line 2208
#ifdef ERANGE_FILL
#line 2208
        *ip = NC_FILL_BYTE;
#line 2208
        return NC_ERANGE;
#line 2208
#else
#line 2208
        err = NC_ERANGE;
#line 2208
#endif
#line 2208
    }
#line 2208
#endif
#line 2208

#line 2208

#line 2208
    *ip = (schar) xx;
#line 2208
    return err;
#line 2208
}
#line 2208

static int
#line 2209
ncx_get_ulonglong_short(const void *xp, short *ip)
#line 2209
{
#line 2209
    int err=NC_NOERR;
#line 2209
    ix_uint64 xx = 0;
#line 2209
    get_ix_uint64(xp, &xx);
#line 2209

#line 2209
#if IX_UINT64_MAX > SHORT_MAX
#line 2209
    if (xx > SHORT_MAX) {
#line 2209
#ifdef ERANGE_FILL
#line 2209
        *ip = NC_FILL_SHORT;
#line 2209
        return NC_ERANGE;
#line 2209
#else
#line 2209
        err = NC_ERANGE;
#line 2209
#endif
#line 2209
    }
#line 2209
#endif
#line 2209

#line 2209

#line 2209
    *ip = (short) xx;
#line 2209
    return err;
#line 2209
}
#line 2209

static int
#line 2210
ncx_get_ulonglong_int(const void *xp, int *ip)
#line 2210
{
#line 2210
    int err=NC_NOERR;
#line 2210
    ix_uint64 xx = 0;
#line 2210
    get_ix_uint64(xp, &xx);
#line 2210

#line 2210
#if IX_UINT64_MAX > INT_MAX
#line 2210
    if (xx > INT_MAX) {
#line 2210
#ifdef ERANGE_FILL
#line 2210
        *ip = NC_FILL_INT;
#line 2210
        return NC_ERANGE;
#line 2210
#else
#line 2210
        err = NC_ERANGE;
#line 2210
#endif
#line 2210
    }
#line 2210
#endif
#line 2210

#line 2210

#line 2210
    *ip = (int) xx;
#line 2210
    return err;
#line 2210
}
#line 2210

static int
#line 2211
ncx_get_ulonglong_long(const void *xp, long *ip)
#line 2211
{
#line 2211
    int err=NC_NOERR;
#line 2211
    ix_uint64 xx = 0;
#line 2211
    get_ix_uint64(xp, &xx);
#line 2211

#line 2211
#if IX_UINT64_MAX > LONG_MAX
#line 2211
    if (xx > LONG_MAX) {
#line 2211
#ifdef ERANGE_FILL
#line 2211
        *ip = NC_FILL_INT;
#line 2211
        return NC_ERANGE;
#line 2211
#else
#line 2211
        err = NC_ERANGE;
#line 2211
#endif
#line 2211
    }
#line 2211
#endif
#line 2211

#line 2211

#line 2211
    *ip = (long) xx;
#line 2211
    return err;
#line 2211
}
#line 2211

static int
#line 2212
ncx_get_ulonglong_longlong(const void *xp, longlong *ip)
#line 2212
{
#line 2212
    int err=NC_NOERR;
#line 2212
    ix_uint64 xx = 0;
#line 2212
    get_ix_uint64(xp, &xx);
#line 2212

#line 2212
#if IX_UINT64_MAX > LONGLONG_MAX
#line 2212
    if (xx > LONGLONG_MAX) {
#line 2212
#ifdef ERANGE_FILL
#line 2212
        *ip = NC_FILL_INT64;
#line 2212
        return NC_ERANGE;
#line 2212
#else
#line 2212
        err = NC_ERANGE;
#line 2212
#endif
#line 2212
    }
#line 2212
#endif
#line 2212

#line 2212

#line 2212
    *ip = (longlong) xx;
#line 2212
    return err;
#line 2212
}
#line 2212

static int
#line 2213
ncx_get_ulonglong_ushort(const void *xp, ushort *ip)
#line 2213
{
#line 2213
    int err=NC_NOERR;
#line 2213
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2213
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2213
#else
#line 2213
    ix_uint64 xx = 0;
#line 2213
    get_ix_uint64(xp, &xx);
#line 2213

#line 2213
#if IX_UINT64_MAX > USHORT_MAX
#line 2213
    if (xx > USHORT_MAX) {
#line 2213
#ifdef ERANGE_FILL
#line 2213
        *ip = NC_FILL_USHORT;
#line 2213
        return NC_ERANGE;
#line 2213
#else
#line 2213
        err = NC_ERANGE;
#line 2213
#endif
#line 2213
    }
#line 2213
#endif
#line 2213

#line 2213

#line 2213
    *ip = (ushort) xx;
#line 2213
#endif
#line 2213
    return err;
#line 2213
}
#line 2213

static int
#line 2214
ncx_get_ulonglong_uchar(const void *xp, uchar *ip)
#line 2214
{
#line 2214
    int err=NC_NOERR;
#line 2214
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 2214
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2214
#else
#line 2214
    ix_uint64 xx = 0;
#line 2214
    get_ix_uint64(xp, &xx);
#line 2214

#line 2214
#if IX_UINT64_MAX > UCHAR_MAX
#line 2214
    if (xx > UCHAR_MAX) {
#line 2214
#ifdef ERANGE_FILL
#line 2214
        *ip = NC_FILL_UBYTE;
#line 2214
        return NC_ERANGE;
#line 2214
#else
#line 2214
        err = NC_ERANGE;
#line 2214
#endif
#line 2214
    }
#line 2214
#endif
#line 2214

#line 2214

#line 2214
    *ip = (uchar) xx;
#line 2214
#endif
#line 2214
    return err;
#line 2214
}
#line 2214

static int
#line 2215
ncx_get_ulonglong_uint(const void *xp, uint *ip)
#line 2215
{
#line 2215
    int err=NC_NOERR;
#line 2215
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2215
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2215
#else
#line 2215
    ix_uint64 xx = 0;
#line 2215
    get_ix_uint64(xp, &xx);
#line 2215

#line 2215
#if IX_UINT64_MAX > UINT_MAX
#line 2215
    if (xx > UINT_MAX) {
#line 2215
#ifdef ERANGE_FILL
#line 2215
        *ip = NC_FILL_UINT;
#line 2215
        return NC_ERANGE;
#line 2215
#else
#line 2215
        err = NC_ERANGE;
#line 2215
#endif
#line 2215
    }
#line 2215
#endif
#line 2215

#line 2215

#line 2215
    *ip = (uint) xx;
#line 2215
#endif
#line 2215
    return err;
#line 2215
}
#line 2215

static int
#line 2216
ncx_get_ulonglong_float(const void *xp, float *ip)
#line 2216
{
#line 2216
	ix_uint64 xx = 0;
#line 2216
	get_ix_uint64(xp, &xx);
#line 2216
	*ip = (float)xx;
#line 2216
	return NC_NOERR;
#line 2216
}
#line 2216

static int
#line 2217
ncx_get_ulonglong_double(const void *xp, double *ip)
#line 2217
{
#line 2217
	ix_uint64 xx = 0;
#line 2217
	get_ix_uint64(xp, &xx);
#line 2217
	*ip = (double)xx;
#line 2217
	return NC_NOERR;
#line 2217
}
#line 2217


#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 2220
ncx_put_ulonglong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2220
{
#line 2220
    int err=NC_NOERR;
#line 2220
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 2220
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2220
#else
#line 2220
    ix_uint64 xx = NC_FILL_UINT64;
#line 2220

#line 2220
#if IX_UINT64_MAX < ULONGLONG_MAX
#line 2220
    if (*ip > IX_UINT64_MAX) {
#line 2220
        
#line 2220
#ifdef ERANGE_FILL
#line 2220
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2220
#endif
#line 2220
        err = NC_ERANGE;
#line 2220
    }
#line 2220
#ifdef ERANGE_FILL
#line 2220
    else
#line 2220
#endif
#line 2220
#endif
#line 2220
        xx = (ix_uint64)*ip;
#line 2220

#line 2220
    put_ix_uint64(xp, &xx);
#line 2220
#endif
#line 2220
    return err;
#line 2220
}
#line 2220

#endif
static int
#line 2222
ncx_put_ulonglong_schar(void *xp, const schar *ip, void *fillp)
#line 2222
{
#line 2222
    int err=NC_NOERR;
#line 2222
    ix_uint64 xx = NC_FILL_UINT64;
#line 2222

#line 2222
#if IX_UINT64_MAX < SCHAR_MAX
#line 2222
    if (*ip > IX_UINT64_MAX) {
#line 2222
        
#line 2222
#ifdef ERANGE_FILL
#line 2222
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2222
#endif
#line 2222
        err = NC_ERANGE;
#line 2222
    }
#line 2222
#ifdef ERANGE_FILL
#line 2222
    else
#line 2222
#endif
#line 2222
#endif
#line 2222
    if (*ip < 0) {
#line 2222
        
#line 2222
#ifdef ERANGE_FILL
#line 2222
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2222
#endif
#line 2222
        err = NC_ERANGE; /* because xp is unsigned */
#line 2222
    }
#line 2222
#ifdef ERANGE_FILL
#line 2222
    else
#line 2222
#endif
#line 2222
        xx = (ix_uint64)*ip;
#line 2222

#line 2222
    put_ix_uint64(xp, &xx);
#line 2222
    return err;
#line 2222
}
#line 2222

static int
#line 2223
ncx_put_ulonglong_short(void *xp, const short *ip, void *fillp)
#line 2223
{
#line 2223
    int err=NC_NOERR;
#line 2223
    ix_uint64 xx = NC_FILL_UINT64;
#line 2223

#line 2223
#if IX_UINT64_MAX < SHORT_MAX
#line 2223
    if (*ip > IX_UINT64_MAX) {
#line 2223
        
#line 2223
#ifdef ERANGE_FILL
#line 2223
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2223
#endif
#line 2223
        err = NC_ERANGE;
#line 2223
    }
#line 2223
#ifdef ERANGE_FILL
#line 2223
    else
#line 2223
#endif
#line 2223
#endif
#line 2223
    if (*ip < 0) {
#line 2223
        
#line 2223
#ifdef ERANGE_FILL
#line 2223
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2223
#endif
#line 2223
        err = NC_ERANGE; /* because xp is unsigned */
#line 2223
    }
#line 2223
#ifdef ERANGE_FILL
#line 2223
    else
#line 2223
#endif
#line 2223
        xx = (ix_uint64)*ip;
#line 2223

#line 2223
    put_ix_uint64(xp, &xx);
#line 2223
    return err;
#line 2223
}
#line 2223

static int
#line 2224
ncx_put_ulonglong_int(void *xp, const int *ip, void *fillp)
#line 2224
{
#line 2224
    int err=NC_NOERR;
#line 2224
    ix_uint64 xx = NC_FILL_UINT64;
#line 2224

#line 2224
#if IX_UINT64_MAX < INT_MAX
#line 2224
    if (*ip > IX_UINT64_MAX) {
#line 2224
        
#line 2224
#ifdef ERANGE_FILL
#line 2224
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2224
#endif
#line 2224
        err = NC_ERANGE;
#line 2224
    }
#line 2224
#ifdef ERANGE_FILL
#line 2224
    else
#line 2224
#endif
#line 2224
#endif
#line 2224
    if (*ip < 0) {
#line 2224
        
#line 2224
#ifdef ERANGE_FILL
#line 2224
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2224
#endif
#line 2224
        err = NC_ERANGE; /* because xp is unsigned */
#line 2224
    }
#line 2224
#ifdef ERANGE_FILL
#line 2224
    else
#line 2224
#endif
#line 2224
        xx = (ix_uint64)*ip;
#line 2224

#line 2224
    put_ix_uint64(xp, &xx);
#line 2224
    return err;
#line 2224
}
#line 2224

static int
#line 2225
ncx_put_ulonglong_long(void *xp, const long *ip, void *fillp)
#line 2225
{
#line 2225
    int err=NC_NOERR;
#line 2225
    ix_uint64 xx = NC_FILL_UINT64;
#line 2225

#line 2225
#if IX_UINT64_MAX < LONG_MAX
#line 2225
    if (*ip > IX_UINT64_MAX) {
#line 2225
        
#line 2225
#ifdef ERANGE_FILL
#line 2225
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2225
#endif
#line 2225
        err = NC_ERANGE;
#line 2225
    }
#line 2225
#ifdef ERANGE_FILL
#line 2225
    else
#line 2225
#endif
#line 2225
#endif
#line 2225
    if (*ip < 0) {
#line 2225
        
#line 2225
#ifdef ERANGE_FILL
#line 2225
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2225
#endif
#line 2225
        err = NC_ERANGE; /* because xp is unsigned */
#line 2225
    }
#line 2225
#ifdef ERANGE_FILL
#line 2225
    else
#line 2225
#endif
#line 2225
        xx = (ix_uint64)*ip;
#line 2225

#line 2225
    put_ix_uint64(xp, &xx);
#line 2225
    return err;
#line 2225
}
#line 2225

static int
#line 2226
ncx_put_ulonglong_longlong(void *xp, const longlong *ip, void *fillp)
#line 2226
{
#line 2226
    int err=NC_NOERR;
#line 2226
    ix_uint64 xx = NC_FILL_UINT64;
#line 2226

#line 2226
#if IX_UINT64_MAX < LONGLONG_MAX
#line 2226
    if (*ip > IX_UINT64_MAX) {
#line 2226
        
#line 2226
#ifdef ERANGE_FILL
#line 2226
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2226
#endif
#line 2226
        err = NC_ERANGE;
#line 2226
    }
#line 2226
#ifdef ERANGE_FILL
#line 2226
    else
#line 2226
#endif
#line 2226
#endif
#line 2226
    if (*ip < 0) {
#line 2226
        
#line 2226
#ifdef ERANGE_FILL
#line 2226
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2226
#endif
#line 2226
        err = NC_ERANGE; /* because xp is unsigned */
#line 2226
    }
#line 2226
#ifdef ERANGE_FILL
#line 2226
    else
#line 2226
#endif
#line 2226
        xx = (ix_uint64)*ip;
#line 2226

#line 2226
    put_ix_uint64(xp, &xx);
#line 2226
    return err;
#line 2226
}
#line 2226

static int
#line 2227
ncx_put_ulonglong_uchar(void *xp, const uchar *ip, void *fillp)
#line 2227
{
#line 2227
    int err=NC_NOERR;
#line 2227
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 2227
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2227
#else
#line 2227
    ix_uint64 xx = NC_FILL_UINT64;
#line 2227

#line 2227
#if IX_UINT64_MAX < UCHAR_MAX
#line 2227
    if (*ip > IX_UINT64_MAX) {
#line 2227
        
#line 2227
#ifdef ERANGE_FILL
#line 2227
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2227
#endif
#line 2227
        err = NC_ERANGE;
#line 2227
    }
#line 2227
#ifdef ERANGE_FILL
#line 2227
    else
#line 2227
#endif
#line 2227
#endif
#line 2227
        xx = (ix_uint64)*ip;
#line 2227

#line 2227
    put_ix_uint64(xp, &xx);
#line 2227
#endif
#line 2227
    return err;
#line 2227
}
#line 2227

static int
#line 2228
ncx_put_ulonglong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2228
{
#line 2228
    int err=NC_NOERR;
#line 2228
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2228
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2228
#else
#line 2228
    ix_uint64 xx = NC_FILL_UINT64;
#line 2228

#line 2228
#if IX_UINT64_MAX < USHORT_MAX
#line 2228
    if (*ip > IX_UINT64_MAX) {
#line 2228
        
#line 2228
#ifdef ERANGE_FILL
#line 2228
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2228
#endif
#line 2228
        err = NC_ERANGE;
#line 2228
    }
#line 2228
#ifdef ERANGE_FILL
#line 2228
    else
#line 2228
#endif
#line 2228
#endif
#line 2228
        xx = (ix_uint64)*ip;
#line 2228

#line 2228
    put_ix_uint64(xp, &xx);
#line 2228
#endif
#line 2228
    return err;
#line 2228
}
#line 2228

static int
#line 2229
ncx_put_ulonglong_uint(void *xp, const uint *ip, void *fillp)
#line 2229
{
#line 2229
    int err=NC_NOERR;
#line 2229
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2229
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2229
#else
#line 2229
    ix_uint64 xx = NC_FILL_UINT64;
#line 2229

#line 2229
#if IX_UINT64_MAX < UINT_MAX
#line 2229
    if (*ip > IX_UINT64_MAX) {
#line 2229
        
#line 2229
#ifdef ERANGE_FILL
#line 2229
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2229
#endif
#line 2229
        err = NC_ERANGE;
#line 2229
    }
#line 2229
#ifdef ERANGE_FILL
#line 2229
    else
#line 2229
#endif
#line 2229
#endif
#line 2229
        xx = (ix_uint64)*ip;
#line 2229

#line 2229
    put_ix_uint64(xp, &xx);
#line 2229
#endif
#line 2229
    return err;
#line 2229
}
#line 2229

static int
#line 2230
ncx_put_ulonglong_float(void *xp, const float *ip, void *fillp)
#line 2230
{
#line 2230
    int err=NC_NOERR;
#line 2230
    ix_uint64 xx = NC_FILL_UINT64;
#line 2230

#line 2230
    if (*ip > (double)X_UINT64_MAX || *ip < 0) {
#line 2230
        
#line 2230
#ifdef ERANGE_FILL
#line 2230
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2230
#endif
#line 2230
        err = NC_ERANGE;
#line 2230
    }
#line 2230
#ifdef ERANGE_FILL
#line 2230
    else
#line 2230
#endif
#line 2230
        xx = (ix_uint64)*ip;
#line 2230

#line 2230
    put_ix_uint64(xp, &xx);
#line 2230
    return err;
#line 2230
}
#line 2230

static int
#line 2231
ncx_put_ulonglong_double(void *xp, const double *ip, void *fillp)
#line 2231
{
#line 2231
    int err=NC_NOERR;
#line 2231
    ix_uint64 xx = NC_FILL_UINT64;
#line 2231

#line 2231
    if (*ip > X_UINT64_MAX || *ip < 0) {
#line 2231
        
#line 2231
#ifdef ERANGE_FILL
#line 2231
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2231
#endif
#line 2231
        err = NC_ERANGE;
#line 2231
    }
#line 2231
#ifdef ERANGE_FILL
#line 2231
    else
#line 2231
#endif
#line 2231
        xx = (ix_uint64)*ip;
#line 2231

#line 2231
    put_ix_uint64(xp, &xx);
#line 2231
    return err;
#line 2231
}
#line 2231



/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp  = (unsigned)(*cp++) << 24;
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp;

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;

	/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return NC_ERANGE;
	}

	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000LL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000LL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000LL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000LL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000LL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00LL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffLL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp;
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return NC_ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return NC_ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

/*----< ncx_get_uint32() >------------------------------------------*/
int
ncx_get_uint32(const void **xpp, uint *ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ip, *xpp, SIZEOF_UINT);
#else
    const uchar *cp = (const uchar *) *xpp;

    *ip = (uint)(*cp++ << 24);
    *ip = (uint)(*ip | (uint)(*cp++ << 16));
    *ip = (uint)(*ip | (uint)(*cp++ <<  8));
    *ip = (uint)(*ip | *cp);
#endif
    /* advance *xpp 4 bytes */
    *xpp = (void *)((const char *)(*xpp) + 4);

    return NC_NOERR;
}

/*----< ncx_get_uint64() >------------------------------------------*/
int
ncx_get_uint64(const void **xpp, unsigned long long *ullp)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ullp, *xpp, SIZEOF_UINT64);
#else
    const uchar *cp = (const uchar *) *xpp;

    /* below is the same as calling swap8b(ullp, *xpp) */
    *ullp = (unsigned long long)(*cp++) << 56;
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 48);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 40);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 32);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 24);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 16);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) <<  8);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp));
#endif
    /* advance *xpp 8 bytes */
    *xpp = (void *)((const char *)(*xpp) + 8);

    return NC_NOERR;
}

/*---< ncx_put_uint32() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 32-bit integer) to xpp in Big Endian
 * form and advance *xpp 4 bytes
 */
int
ncx_put_uint32(void **xpp, const unsigned int ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT);
#else
    /* bitwise shifts below are to produce an integer in Big Endian */
    uchar *cp = (uchar *) *xpp;
    *cp++ = (uchar)((ip & 0xff000000) >> 24);
    *cp++ = (uchar)((ip & 0x00ff0000) >> 16);
    *cp++ = (uchar)((ip & 0x0000ff00) >>  8);
    *cp   = (uchar)( ip & 0x000000ff);
#endif
    /* advance *xpp 4 bytes */
    *xpp  = (void *)((char *)(*xpp) + 4);

    return NC_NOERR;
}

/*---< ncx_put_uint64() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 64-bit integer) to xpp in Big Endian
 * form and advance *xpp 8 bytes
 */
int
ncx_put_uint64(void **xpp, const unsigned long long ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT64);
#else
    uchar *cp = (uchar *) *xpp;
    /* below is the same as calling swap8b(*xpp, &ip) */
    *cp++ = (uchar) (ip                         >> 56);
    *cp++ = (uchar)((ip & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)((ip & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)((ip & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)((ip & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)((ip & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)((ip & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar) (ip & 0x00000000000000ffLL);
#endif
    /* advance *xpp 8 bytes */
    *xpp  = (void *)((char *)(*xpp) + 8);

    return NC_NOERR;
}


/*
 * Aggregate numeric conversion functions.
 */
#line 2487

#line 2890

#line 2896

/* schar ---------------------------------------------------------------------*/

#line 2900
int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2903
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2903
	return NC_NOERR;
#line 2903

}
int
#line 2905
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2905
{
#line 2905
    int status = NC_NOERR;
#line 2905
    schar *xp = (schar *)(*xpp);
#line 2905

#line 2905
    while (nelems-- != 0) {
#line 2905
        
#line 2905
        if (*xp < 0) {
#line 2905
#ifdef ERANGE_FILL
#line 2905
            *tp = NC_FILL_UBYTE;
#line 2905
#endif
#line 2905
            status = NC_ERANGE; /* because tp is unsigned */
#line 2905
            
#line 2905
#ifdef ERANGE_FILL
#line 2905
            xp++; tp++; continue;
#line 2905
#endif
#line 2905
        }
#line 2905
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2905
    }
#line 2905

#line 2905
    *xpp = (const void *)xp;
#line 2905
    return status;
#line 2905
}
#line 2905

int
#line 2906
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2906
{
#line 2906
    int status = NC_NOERR;
#line 2906
    schar *xp = (schar *)(*xpp);
#line 2906

#line 2906
    while (nelems-- != 0) {
#line 2906
        
#line 2906
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2906
    }
#line 2906

#line 2906
    *xpp = (const void *)xp;
#line 2906
    return status;
#line 2906
}
#line 2906

int
#line 2907
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2907
{
#line 2907
    int status = NC_NOERR;
#line 2907
    schar *xp = (schar *)(*xpp);
#line 2907

#line 2907
    while (nelems-- != 0) {
#line 2907
        
#line 2907
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2907
    }
#line 2907

#line 2907
    *xpp = (const void *)xp;
#line 2907
    return status;
#line 2907
}
#line 2907

int
#line 2908
ncx_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2908
{
#line 2908
    int status = NC_NOERR;
#line 2908
    schar *xp = (schar *)(*xpp);
#line 2908

#line 2908
    while (nelems-- != 0) {
#line 2908
        
#line 2908
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2908
    }
#line 2908

#line 2908
    *xpp = (const void *)xp;
#line 2908
    return status;
#line 2908
}
#line 2908

int
#line 2909
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2909
{
#line 2909
    int status = NC_NOERR;
#line 2909
    schar *xp = (schar *)(*xpp);
#line 2909

#line 2909
    while (nelems-- != 0) {
#line 2909
        
#line 2909
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2909
    }
#line 2909

#line 2909
    *xpp = (const void *)xp;
#line 2909
    return status;
#line 2909
}
#line 2909

int
#line 2910
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2910
{
#line 2910
    int status = NC_NOERR;
#line 2910
    schar *xp = (schar *)(*xpp);
#line 2910

#line 2910
    while (nelems-- != 0) {
#line 2910
        
#line 2910
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2910
    }
#line 2910

#line 2910
    *xpp = (const void *)xp;
#line 2910
    return status;
#line 2910
}
#line 2910

int
#line 2911
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2911
{
#line 2911
    int status = NC_NOERR;
#line 2911
    schar *xp = (schar *)(*xpp);
#line 2911

#line 2911
    while (nelems-- != 0) {
#line 2911
        
#line 2911
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2911
    }
#line 2911

#line 2911
    *xpp = (const void *)xp;
#line 2911
    return status;
#line 2911
}
#line 2911

int
#line 2912
ncx_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2912
{
#line 2912
    int status = NC_NOERR;
#line 2912
    schar *xp = (schar *)(*xpp);
#line 2912

#line 2912
    while (nelems-- != 0) {
#line 2912
        
#line 2912
        if (*xp < 0) {
#line 2912
#ifdef ERANGE_FILL
#line 2912
            *tp = NC_FILL_USHORT;
#line 2912
#endif
#line 2912
            status = NC_ERANGE; /* because tp is unsigned */
#line 2912
            
#line 2912
#ifdef ERANGE_FILL
#line 2912
            xp++; tp++; continue;
#line 2912
#endif
#line 2912
        }
#line 2912
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2912
    }
#line 2912

#line 2912
    *xpp = (const void *)xp;
#line 2912
    return status;
#line 2912
}
#line 2912

int
#line 2913
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2913
{
#line 2913
    int status = NC_NOERR;
#line 2913
    schar *xp = (schar *)(*xpp);
#line 2913

#line 2913
    while (nelems-- != 0) {
#line 2913
        
#line 2913
        if (*xp < 0) {
#line 2913
#ifdef ERANGE_FILL
#line 2913
            *tp = NC_FILL_UINT;
#line 2913
#endif
#line 2913
            status = NC_ERANGE; /* because tp is unsigned */
#line 2913
            
#line 2913
#ifdef ERANGE_FILL
#line 2913
            xp++; tp++; continue;
#line 2913
#endif
#line 2913
        }
#line 2913
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2913
    }
#line 2913

#line 2913
    *xpp = (const void *)xp;
#line 2913
    return status;
#line 2913
}
#line 2913

int
#line 2914
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2914
{
#line 2914
    int status = NC_NOERR;
#line 2914
    schar *xp = (schar *)(*xpp);
#line 2914

#line 2914
    while (nelems-- != 0) {
#line 2914
        
#line 2914
        if (*xp < 0) {
#line 2914
#ifdef ERANGE_FILL
#line 2914
            *tp = NC_FILL_UINT64;
#line 2914
#endif
#line 2914
            status = NC_ERANGE; /* because tp is unsigned */
#line 2914
            
#line 2914
#ifdef ERANGE_FILL
#line 2914
            xp++; tp++; continue;
#line 2914
#endif
#line 2914
        }
#line 2914
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2914
    }
#line 2914

#line 2914
    *xpp = (const void *)xp;
#line 2914
    return status;
#line 2914
}
#line 2914


#line 2917
int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2920

#line 2920
	if (rndup)
#line 2920
		rndup = X_ALIGN - rndup;
#line 2920

#line 2920
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2920
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2920

#line 2920
	return NC_NOERR;
#line 2920

}
int
#line 2922
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2922
{
#line 2922
    int status = NC_NOERR;
#line 2922
    size_t rndup = nelems % X_ALIGN;
#line 2922
    schar *xp = (schar *) *xpp;
#line 2922

#line 2922
    if (rndup)
#line 2922
        rndup = X_ALIGN - rndup;
#line 2922

#line 2922
    while (nelems-- != 0) {
#line 2922
        
#line 2922
        if (*xp < 0) {
#line 2922
#ifdef ERANGE_FILL
#line 2922
            *tp = NC_FILL_UBYTE;
#line 2922
#endif
#line 2922
            status = NC_ERANGE; /* because tp is unsigned */
#line 2922
            
#line 2922
#ifdef ERANGE_FILL
#line 2922
            xp++; tp++; continue;
#line 2922
#endif
#line 2922
        }
#line 2922
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2922
    }
#line 2922

#line 2922
    *xpp = (void *)(xp + rndup);
#line 2922
    return status;
#line 2922
}
#line 2922

int
#line 2923
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2923
{
#line 2923
    int status = NC_NOERR;
#line 2923
    size_t rndup = nelems % X_ALIGN;
#line 2923
    schar *xp = (schar *) *xpp;
#line 2923

#line 2923
    if (rndup)
#line 2923
        rndup = X_ALIGN - rndup;
#line 2923

#line 2923
    while (nelems-- != 0) {
#line 2923
        
#line 2923
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2923
    }
#line 2923

#line 2923
    *xpp = (void *)(xp + rndup);
#line 2923
    return status;
#line 2923
}
#line 2923

int
#line 2924
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2924
{
#line 2924
    int status = NC_NOERR;
#line 2924
    size_t rndup = nelems % X_ALIGN;
#line 2924
    schar *xp = (schar *) *xpp;
#line 2924

#line 2924
    if (rndup)
#line 2924
        rndup = X_ALIGN - rndup;
#line 2924

#line 2924
    while (nelems-- != 0) {
#line 2924
        
#line 2924
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2924
    }
#line 2924

#line 2924
    *xpp = (void *)(xp + rndup);
#line 2924
    return status;
#line 2924
}
#line 2924

int
#line 2925
ncx_pad_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2925
{
#line 2925
    int status = NC_NOERR;
#line 2925
    size_t rndup = nelems % X_ALIGN;
#line 2925
    schar *xp = (schar *) *xpp;
#line 2925

#line 2925
    if (rndup)
#line 2925
        rndup = X_ALIGN - rndup;
#line 2925

#line 2925
    while (nelems-- != 0) {
#line 2925
        
#line 2925
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2925
    }
#line 2925

#line 2925
    *xpp = (void *)(xp + rndup);
#line 2925
    return status;
#line 2925
}
#line 2925

int
#line 2926
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2926
{
#line 2926
    int status = NC_NOERR;
#line 2926
    size_t rndup = nelems % X_ALIGN;
#line 2926
    schar *xp = (schar *) *xpp;
#line 2926

#line 2926
    if (rndup)
#line 2926
        rndup = X_ALIGN - rndup;
#line 2926

#line 2926
    while (nelems-- != 0) {
#line 2926
        
#line 2926
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2926
    }
#line 2926

#line 2926
    *xpp = (void *)(xp + rndup);
#line 2926
    return status;
#line 2926
}
#line 2926

int
#line 2927
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2927
{
#line 2927
    int status = NC_NOERR;
#line 2927
    size_t rndup = nelems % X_ALIGN;
#line 2927
    schar *xp = (schar *) *xpp;
#line 2927

#line 2927
    if (rndup)
#line 2927
        rndup = X_ALIGN - rndup;
#line 2927

#line 2927
    while (nelems-- != 0) {
#line 2927
        
#line 2927
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2927
    }
#line 2927

#line 2927
    *xpp = (void *)(xp + rndup);
#line 2927
    return status;
#line 2927
}
#line 2927

int
#line 2928
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2928
{
#line 2928
    int status = NC_NOERR;
#line 2928
    size_t rndup = nelems % X_ALIGN;
#line 2928
    schar *xp = (schar *) *xpp;
#line 2928

#line 2928
    if (rndup)
#line 2928
        rndup = X_ALIGN - rndup;
#line 2928

#line 2928
    while (nelems-- != 0) {
#line 2928
        
#line 2928
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2928
    }
#line 2928

#line 2928
    *xpp = (void *)(xp + rndup);
#line 2928
    return status;
#line 2928
}
#line 2928

int
#line 2929
ncx_pad_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2929
{
#line 2929
    int status = NC_NOERR;
#line 2929
    size_t rndup = nelems % X_ALIGN;
#line 2929
    schar *xp = (schar *) *xpp;
#line 2929

#line 2929
    if (rndup)
#line 2929
        rndup = X_ALIGN - rndup;
#line 2929

#line 2929
    while (nelems-- != 0) {
#line 2929
        
#line 2929
        if (*xp < 0) {
#line 2929
#ifdef ERANGE_FILL
#line 2929
            *tp = NC_FILL_USHORT;
#line 2929
#endif
#line 2929
            status = NC_ERANGE; /* because tp is unsigned */
#line 2929
            
#line 2929
#ifdef ERANGE_FILL
#line 2929
            xp++; tp++; continue;
#line 2929
#endif
#line 2929
        }
#line 2929
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2929
    }
#line 2929

#line 2929
    *xpp = (void *)(xp + rndup);
#line 2929
    return status;
#line 2929
}
#line 2929

int
#line 2930
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2930
{
#line 2930
    int status = NC_NOERR;
#line 2930
    size_t rndup = nelems % X_ALIGN;
#line 2930
    schar *xp = (schar *) *xpp;
#line 2930

#line 2930
    if (rndup)
#line 2930
        rndup = X_ALIGN - rndup;
#line 2930

#line 2930
    while (nelems-- != 0) {
#line 2930
        
#line 2930
        if (*xp < 0) {
#line 2930
#ifdef ERANGE_FILL
#line 2930
            *tp = NC_FILL_UINT;
#line 2930
#endif
#line 2930
            status = NC_ERANGE; /* because tp is unsigned */
#line 2930
            
#line 2930
#ifdef ERANGE_FILL
#line 2930
            xp++; tp++; continue;
#line 2930
#endif
#line 2930
        }
#line 2930
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2930
    }
#line 2930

#line 2930
    *xpp = (void *)(xp + rndup);
#line 2930
    return status;
#line 2930
}
#line 2930

int
#line 2931
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2931
{
#line 2931
    int status = NC_NOERR;
#line 2931
    size_t rndup = nelems % X_ALIGN;
#line 2931
    schar *xp = (schar *) *xpp;
#line 2931

#line 2931
    if (rndup)
#line 2931
        rndup = X_ALIGN - rndup;
#line 2931

#line 2931
    while (nelems-- != 0) {
#line 2931
        
#line 2931
        if (*xp < 0) {
#line 2931
#ifdef ERANGE_FILL
#line 2931
            *tp = NC_FILL_UINT64;
#line 2931
#endif
#line 2931
            status = NC_ERANGE; /* because tp is unsigned */
#line 2931
            
#line 2931
#ifdef ERANGE_FILL
#line 2931
            xp++; tp++; continue;
#line 2931
#endif
#line 2931
        }
#line 2931
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2931
    }
#line 2931

#line 2931
    *xpp = (void *)(xp + rndup);
#line 2931
    return status;
#line 2931
}
#line 2931


#line 2934
int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2937
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2937

#line 2937
	return NC_NOERR;
#line 2937

}
int
#line 2939
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2939
{
#line 2939
    int status = NC_NOERR;
#line 2939
    schar *xp = (schar *) *xpp;
#line 2939

#line 2939
    while (nelems-- != 0) {
#line 2939
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2939
            
#line 2939
#ifdef ERANGE_FILL
#line 2939
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2939
#endif
#line 2939
            status = NC_ERANGE;
#line 2939
            
#line 2939
#ifdef ERANGE_FILL
#line 2939
            xp++; tp++; continue;
#line 2939
#endif
#line 2939
        }
#line 2939
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2939
    }
#line 2939

#line 2939
    *xpp = (void *)xp;
#line 2939
    return status;
#line 2939
}
#line 2939

int
#line 2940
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2940
{
#line 2940
    int status = NC_NOERR;
#line 2940
    schar *xp = (schar *) *xpp;
#line 2940

#line 2940
    while (nelems-- != 0) {
#line 2940
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2940
            
#line 2940
#ifdef ERANGE_FILL
#line 2940
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2940
#endif
#line 2940
            status = NC_ERANGE;
#line 2940
            
#line 2940
#ifdef ERANGE_FILL
#line 2940
            xp++; tp++; continue;
#line 2940
#endif
#line 2940
        }
#line 2940
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2940
    }
#line 2940

#line 2940
    *xpp = (void *)xp;
#line 2940
    return status;
#line 2940
}
#line 2940

int
#line 2941
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2941
{
#line 2941
    int status = NC_NOERR;
#line 2941
    schar *xp = (schar *) *xpp;
#line 2941

#line 2941
    while (nelems-- != 0) {
#line 2941
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2941
            
#line 2941
#ifdef ERANGE_FILL
#line 2941
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2941
#endif
#line 2941
            status = NC_ERANGE;
#line 2941
            
#line 2941
#ifdef ERANGE_FILL
#line 2941
            xp++; tp++; continue;
#line 2941
#endif
#line 2941
        }
#line 2941
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2941
    }
#line 2941

#line 2941
    *xpp = (void *)xp;
#line 2941
    return status;
#line 2941
}
#line 2941

int
#line 2942
ncx_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2942
{
#line 2942
    int status = NC_NOERR;
#line 2942
    schar *xp = (schar *) *xpp;
#line 2942

#line 2942
    while (nelems-- != 0) {
#line 2942
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2942
            
#line 2942
#ifdef ERANGE_FILL
#line 2942
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2942
#endif
#line 2942
            status = NC_ERANGE;
#line 2942
            
#line 2942
#ifdef ERANGE_FILL
#line 2942
            xp++; tp++; continue;
#line 2942
#endif
#line 2942
        }
#line 2942
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2942
    }
#line 2942

#line 2942
    *xpp = (void *)xp;
#line 2942
    return status;
#line 2942
}
#line 2942

int
#line 2943
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2943
{
#line 2943
    int status = NC_NOERR;
#line 2943
    schar *xp = (schar *) *xpp;
#line 2943

#line 2943
    while (nelems-- != 0) {
#line 2943
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2943
            
#line 2943
#ifdef ERANGE_FILL
#line 2943
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2943
#endif
#line 2943
            status = NC_ERANGE;
#line 2943
            
#line 2943
#ifdef ERANGE_FILL
#line 2943
            xp++; tp++; continue;
#line 2943
#endif
#line 2943
        }
#line 2943
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2943
    }
#line 2943

#line 2943
    *xpp = (void *)xp;
#line 2943
    return status;
#line 2943
}
#line 2943

int
#line 2944
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2944
{
#line 2944
    int status = NC_NOERR;
#line 2944
    schar *xp = (schar *) *xpp;
#line 2944

#line 2944
    while (nelems-- != 0) {
#line 2944
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2944
            
#line 2944
#ifdef ERANGE_FILL
#line 2944
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2944
#endif
#line 2944
            status = NC_ERANGE;
#line 2944
            
#line 2944
#ifdef ERANGE_FILL
#line 2944
            xp++; tp++; continue;
#line 2944
#endif
#line 2944
        }
#line 2944
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2944
    }
#line 2944

#line 2944
    *xpp = (void *)xp;
#line 2944
    return status;
#line 2944
}
#line 2944

int
#line 2945
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2945
{
#line 2945
    int status = NC_NOERR;
#line 2945
    schar *xp = (schar *) *xpp;
#line 2945

#line 2945
    while (nelems-- != 0) {
#line 2945
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2945
            
#line 2945
#ifdef ERANGE_FILL
#line 2945
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2945
#endif
#line 2945
            status = NC_ERANGE;
#line 2945
            
#line 2945
#ifdef ERANGE_FILL
#line 2945
            xp++; tp++; continue;
#line 2945
#endif
#line 2945
        }
#line 2945
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2945
    }
#line 2945

#line 2945
    *xpp = (void *)xp;
#line 2945
    return status;
#line 2945
}
#line 2945

int
#line 2946
ncx_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2946
{
#line 2946
    int status = NC_NOERR;
#line 2946
    schar *xp = (schar *) *xpp;
#line 2946

#line 2946
    while (nelems-- != 0) {
#line 2946
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2946
            
#line 2946
#ifdef ERANGE_FILL
#line 2946
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2946
#endif
#line 2946
            status = NC_ERANGE;
#line 2946
            
#line 2946
#ifdef ERANGE_FILL
#line 2946
            xp++; tp++; continue;
#line 2946
#endif
#line 2946
        }
#line 2946
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2946
    }
#line 2946

#line 2946
    *xpp = (void *)xp;
#line 2946
    return status;
#line 2946
}
#line 2946

int
#line 2947
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2947
{
#line 2947
    int status = NC_NOERR;
#line 2947
    schar *xp = (schar *) *xpp;
#line 2947

#line 2947
    while (nelems-- != 0) {
#line 2947
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2947
            
#line 2947
#ifdef ERANGE_FILL
#line 2947
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2947
#endif
#line 2947
            status = NC_ERANGE;
#line 2947
            
#line 2947
#ifdef ERANGE_FILL
#line 2947
            xp++; tp++; continue;
#line 2947
#endif
#line 2947
        }
#line 2947
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2947
    }
#line 2947

#line 2947
    *xpp = (void *)xp;
#line 2947
    return status;
#line 2947
}
#line 2947

int
#line 2948
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2948
{
#line 2948
    int status = NC_NOERR;
#line 2948
    schar *xp = (schar *) *xpp;
#line 2948

#line 2948
    while (nelems-- != 0) {
#line 2948
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2948
            
#line 2948
#ifdef ERANGE_FILL
#line 2948
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2948
#endif
#line 2948
            status = NC_ERANGE;
#line 2948
            
#line 2948
#ifdef ERANGE_FILL
#line 2948
            xp++; tp++; continue;
#line 2948
#endif
#line 2948
        }
#line 2948
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2948
    }
#line 2948

#line 2948
    *xpp = (void *)xp;
#line 2948
    return status;
#line 2948
}
#line 2948


#line 2951
int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2954

#line 2954
	if (rndup)
#line 2954
		rndup = X_ALIGN - rndup;
#line 2954

#line 2954
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2954
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2954

#line 2954
	if (rndup)
#line 2954
	{
#line 2954
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 2954
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2954
	}
#line 2954

#line 2954
	return NC_NOERR;
#line 2954

}
int
#line 2956
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2956
{
#line 2956
    int status = NC_NOERR;
#line 2956
    size_t rndup = nelems % X_ALIGN;
#line 2956
    schar *xp = (schar *) *xpp;
#line 2956

#line 2956
    if (rndup) rndup = X_ALIGN - rndup;
#line 2956

#line 2956
    while (nelems-- != 0) {
#line 2956
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2956
            
#line 2956
#ifdef ERANGE_FILL
#line 2956
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2956
#endif
#line 2956
            status = NC_ERANGE;
#line 2956
            
#line 2956
#ifdef ERANGE_FILL
#line 2956
            xp++; tp++; continue;
#line 2956
#endif
#line 2956
        }
#line 2956
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2956
    }
#line 2956

#line 2956

#line 2956
    if (rndup) {
#line 2956
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2956
        xp += rndup;
#line 2956
    }
#line 2956

#line 2956
    *xpp = (void *)xp;
#line 2956
    return status;
#line 2956
}
#line 2956

int
#line 2957
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2957
{
#line 2957
    int status = NC_NOERR;
#line 2957
    size_t rndup = nelems % X_ALIGN;
#line 2957
    schar *xp = (schar *) *xpp;
#line 2957

#line 2957
    if (rndup) rndup = X_ALIGN - rndup;
#line 2957

#line 2957
    while (nelems-- != 0) {
#line 2957
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2957
            
#line 2957
#ifdef ERANGE_FILL
#line 2957
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2957
#endif
#line 2957
            status = NC_ERANGE;
#line 2957
            
#line 2957
#ifdef ERANGE_FILL
#line 2957
            xp++; tp++; continue;
#line 2957
#endif
#line 2957
        }
#line 2957
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2957
    }
#line 2957

#line 2957

#line 2957
    if (rndup) {
#line 2957
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2957
        xp += rndup;
#line 2957
    }
#line 2957

#line 2957
    *xpp = (void *)xp;
#line 2957
    return status;
#line 2957
}
#line 2957

int
#line 2958
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2958
{
#line 2958
    int status = NC_NOERR;
#line 2958
    size_t rndup = nelems % X_ALIGN;
#line 2958
    schar *xp = (schar *) *xpp;
#line 2958

#line 2958
    if (rndup) rndup = X_ALIGN - rndup;
#line 2958

#line 2958
    while (nelems-- != 0) {
#line 2958
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2958
            
#line 2958
#ifdef ERANGE_FILL
#line 2958
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2958
#endif
#line 2958
            status = NC_ERANGE;
#line 2958
            
#line 2958
#ifdef ERANGE_FILL
#line 2958
            xp++; tp++; continue;
#line 2958
#endif
#line 2958
        }
#line 2958
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2958
    }
#line 2958

#line 2958

#line 2958
    if (rndup) {
#line 2958
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2958
        xp += rndup;
#line 2958
    }
#line 2958

#line 2958
    *xpp = (void *)xp;
#line 2958
    return status;
#line 2958
}
#line 2958

int
#line 2959
ncx_pad_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2959
{
#line 2959
    int status = NC_NOERR;
#line 2959
    size_t rndup = nelems % X_ALIGN;
#line 2959
    schar *xp = (schar *) *xpp;
#line 2959

#line 2959
    if (rndup) rndup = X_ALIGN - rndup;
#line 2959

#line 2959
    while (nelems-- != 0) {
#line 2959
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2959
            
#line 2959
#ifdef ERANGE_FILL
#line 2959
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2959
#endif
#line 2959
            status = NC_ERANGE;
#line 2959
            
#line 2959
#ifdef ERANGE_FILL
#line 2959
            xp++; tp++; continue;
#line 2959
#endif
#line 2959
        }
#line 2959
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2959
    }
#line 2959

#line 2959

#line 2959
    if (rndup) {
#line 2959
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2959
        xp += rndup;
#line 2959
    }
#line 2959

#line 2959
    *xpp = (void *)xp;
#line 2959
    return status;
#line 2959
}
#line 2959

int
#line 2960
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2960
{
#line 2960
    int status = NC_NOERR;
#line 2960
    size_t rndup = nelems % X_ALIGN;
#line 2960
    schar *xp = (schar *) *xpp;
#line 2960

#line 2960
    if (rndup) rndup = X_ALIGN - rndup;
#line 2960

#line 2960
    while (nelems-- != 0) {
#line 2960
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2960
            
#line 2960
#ifdef ERANGE_FILL
#line 2960
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2960
#endif
#line 2960
            status = NC_ERANGE;
#line 2960
            
#line 2960
#ifdef ERANGE_FILL
#line 2960
            xp++; tp++; continue;
#line 2960
#endif
#line 2960
        }
#line 2960
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2960
    }
#line 2960

#line 2960

#line 2960
    if (rndup) {
#line 2960
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2960
        xp += rndup;
#line 2960
    }
#line 2960

#line 2960
    *xpp = (void *)xp;
#line 2960
    return status;
#line 2960
}
#line 2960

int
#line 2961
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2961
{
#line 2961
    int status = NC_NOERR;
#line 2961
    size_t rndup = nelems % X_ALIGN;
#line 2961
    schar *xp = (schar *) *xpp;
#line 2961

#line 2961
    if (rndup) rndup = X_ALIGN - rndup;
#line 2961

#line 2961
    while (nelems-- != 0) {
#line 2961
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2961
            
#line 2961
#ifdef ERANGE_FILL
#line 2961
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2961
#endif
#line 2961
            status = NC_ERANGE;
#line 2961
            
#line 2961
#ifdef ERANGE_FILL
#line 2961
            xp++; tp++; continue;
#line 2961
#endif
#line 2961
        }
#line 2961
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2961
    }
#line 2961

#line 2961

#line 2961
    if (rndup) {
#line 2961
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2961
        xp += rndup;
#line 2961
    }
#line 2961

#line 2961
    *xpp = (void *)xp;
#line 2961
    return status;
#line 2961
}
#line 2961

int
#line 2962
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2962
{
#line 2962
    int status = NC_NOERR;
#line 2962
    size_t rndup = nelems % X_ALIGN;
#line 2962
    schar *xp = (schar *) *xpp;
#line 2962

#line 2962
    if (rndup) rndup = X_ALIGN - rndup;
#line 2962

#line 2962
    while (nelems-- != 0) {
#line 2962
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2962
            
#line 2962
#ifdef ERANGE_FILL
#line 2962
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2962
#endif
#line 2962
            status = NC_ERANGE;
#line 2962
            
#line 2962
#ifdef ERANGE_FILL
#line 2962
            xp++; tp++; continue;
#line 2962
#endif
#line 2962
        }
#line 2962
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2962
    }
#line 2962

#line 2962

#line 2962
    if (rndup) {
#line 2962
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2962
        xp += rndup;
#line 2962
    }
#line 2962

#line 2962
    *xpp = (void *)xp;
#line 2962
    return status;
#line 2962
}
#line 2962

int
#line 2963
ncx_pad_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2963
{
#line 2963
    int status = NC_NOERR;
#line 2963
    size_t rndup = nelems % X_ALIGN;
#line 2963
    schar *xp = (schar *) *xpp;
#line 2963

#line 2963
    if (rndup) rndup = X_ALIGN - rndup;
#line 2963

#line 2963
    while (nelems-- != 0) {
#line 2963
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2963
            
#line 2963
#ifdef ERANGE_FILL
#line 2963
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2963
#endif
#line 2963
            status = NC_ERANGE;
#line 2963
            
#line 2963
#ifdef ERANGE_FILL
#line 2963
            xp++; tp++; continue;
#line 2963
#endif
#line 2963
        }
#line 2963
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2963
    }
#line 2963

#line 2963

#line 2963
    if (rndup) {
#line 2963
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2963
        xp += rndup;
#line 2963
    }
#line 2963

#line 2963
    *xpp = (void *)xp;
#line 2963
    return status;
#line 2963
}
#line 2963

int
#line 2964
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2964
{
#line 2964
    int status = NC_NOERR;
#line 2964
    size_t rndup = nelems % X_ALIGN;
#line 2964
    schar *xp = (schar *) *xpp;
#line 2964

#line 2964
    if (rndup) rndup = X_ALIGN - rndup;
#line 2964

#line 2964
    while (nelems-- != 0) {
#line 2964
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2964
            
#line 2964
#ifdef ERANGE_FILL
#line 2964
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2964
#endif
#line 2964
            status = NC_ERANGE;
#line 2964
            
#line 2964
#ifdef ERANGE_FILL
#line 2964
            xp++; tp++; continue;
#line 2964
#endif
#line 2964
        }
#line 2964
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2964
    }
#line 2964

#line 2964

#line 2964
    if (rndup) {
#line 2964
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2964
        xp += rndup;
#line 2964
    }
#line 2964

#line 2964
    *xpp = (void *)xp;
#line 2964
    return status;
#line 2964
}
#line 2964

int
#line 2965
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2965
{
#line 2965
    int status = NC_NOERR;
#line 2965
    size_t rndup = nelems % X_ALIGN;
#line 2965
    schar *xp = (schar *) *xpp;
#line 2965

#line 2965
    if (rndup) rndup = X_ALIGN - rndup;
#line 2965

#line 2965
    while (nelems-- != 0) {
#line 2965
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2965
            
#line 2965
#ifdef ERANGE_FILL
#line 2965
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2965
#endif
#line 2965
            status = NC_ERANGE;
#line 2965
            
#line 2965
#ifdef ERANGE_FILL
#line 2965
            xp++; tp++; continue;
#line 2965
#endif
#line 2965
        }
#line 2965
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2965
    }
#line 2965

#line 2965

#line 2965
    if (rndup) {
#line 2965
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2965
        xp += rndup;
#line 2965
    }
#line 2965

#line 2965
    *xpp = (void *)xp;
#line 2965
    return status;
#line 2965
}
#line 2965



/* uchar ---------------------------------------------------------------------*/
#line 2971
int
ncx_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *)(*xpp);

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
       	    status = NC_ERANGE;
            
#line 2981
#ifdef ERANGE_FILL
#line 2981
            xp++; tp++; continue;
#line 2981
#endif
        }
	*tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (const void *)xp;
    return status;
}
#line 2990
int
ncx_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2993
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2993
	return NC_NOERR;
#line 2993

}
int
#line 2995
ncx_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2995
{
#line 2995
    int status = NC_NOERR;
#line 2995
    uchar *xp = (uchar *)(*xpp);
#line 2995

#line 2995
    while (nelems-- != 0) {
#line 2995
        
#line 2995
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 2995
    }
#line 2995

#line 2995
    *xpp = (const void *)xp;
#line 2995
    return status;
#line 2995
}
#line 2995

int
#line 2996
ncx_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2996
{
#line 2996
    int status = NC_NOERR;
#line 2996
    uchar *xp = (uchar *)(*xpp);
#line 2996

#line 2996
    while (nelems-- != 0) {
#line 2996
        
#line 2996
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 2996
    }
#line 2996

#line 2996
    *xpp = (const void *)xp;
#line 2996
    return status;
#line 2996
}
#line 2996

int
#line 2997
ncx_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 2997
{
#line 2997
    int status = NC_NOERR;
#line 2997
    uchar *xp = (uchar *)(*xpp);
#line 2997

#line 2997
    while (nelems-- != 0) {
#line 2997
        
#line 2997
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 2997
    }
#line 2997

#line 2997
    *xpp = (const void *)xp;
#line 2997
    return status;
#line 2997
}
#line 2997

int
#line 2998
ncx_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2998
{
#line 2998
    int status = NC_NOERR;
#line 2998
    uchar *xp = (uchar *)(*xpp);
#line 2998

#line 2998
    while (nelems-- != 0) {
#line 2998
        
#line 2998
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 2998
    }
#line 2998

#line 2998
    *xpp = (const void *)xp;
#line 2998
    return status;
#line 2998
}
#line 2998

int
#line 2999
ncx_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2999
{
#line 2999
    int status = NC_NOERR;
#line 2999
    uchar *xp = (uchar *)(*xpp);
#line 2999

#line 2999
    while (nelems-- != 0) {
#line 2999
        
#line 2999
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 2999
    }
#line 2999

#line 2999
    *xpp = (const void *)xp;
#line 2999
    return status;
#line 2999
}
#line 2999

int
#line 3000
ncx_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3000
{
#line 3000
    int status = NC_NOERR;
#line 3000
    uchar *xp = (uchar *)(*xpp);
#line 3000

#line 3000
    while (nelems-- != 0) {
#line 3000
        
#line 3000
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 3000
    }
#line 3000

#line 3000
    *xpp = (const void *)xp;
#line 3000
    return status;
#line 3000
}
#line 3000

int
#line 3001
ncx_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3001
{
#line 3001
    int status = NC_NOERR;
#line 3001
    uchar *xp = (uchar *)(*xpp);
#line 3001

#line 3001
    while (nelems-- != 0) {
#line 3001
        
#line 3001
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 3001
    }
#line 3001

#line 3001
    *xpp = (const void *)xp;
#line 3001
    return status;
#line 3001
}
#line 3001

int
#line 3002
ncx_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 3002
{
#line 3002
    int status = NC_NOERR;
#line 3002
    uchar *xp = (uchar *)(*xpp);
#line 3002

#line 3002
    while (nelems-- != 0) {
#line 3002
        
#line 3002
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 3002
    }
#line 3002

#line 3002
    *xpp = (const void *)xp;
#line 3002
    return status;
#line 3002
}
#line 3002

int
#line 3003
ncx_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3003
{
#line 3003
    int status = NC_NOERR;
#line 3003
    uchar *xp = (uchar *)(*xpp);
#line 3003

#line 3003
    while (nelems-- != 0) {
#line 3003
        
#line 3003
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 3003
    }
#line 3003

#line 3003
    *xpp = (const void *)xp;
#line 3003
    return status;
#line 3003
}
#line 3003


#line 3006
int
ncx_pad_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
            status = NC_ERANGE;
            
#line 3019
#ifdef ERANGE_FILL
#line 3019
            xp++; tp++; continue;
#line 3019
#endif
        }
        *tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (void *)(xp + rndup);
    return status;
}
#line 3028
int
ncx_pad_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 3031

#line 3031
	if (rndup)
#line 3031
		rndup = X_ALIGN - rndup;
#line 3031

#line 3031
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3031
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3031

#line 3031
	return NC_NOERR;
#line 3031

}
int
#line 3033
ncx_pad_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 3033
{
#line 3033
    int status = NC_NOERR;
#line 3033
    size_t rndup = nelems % X_ALIGN;
#line 3033
    uchar *xp = (uchar *) *xpp;
#line 3033

#line 3033
    if (rndup)
#line 3033
        rndup = X_ALIGN - rndup;
#line 3033

#line 3033
    while (nelems-- != 0) {
#line 3033
        
#line 3033
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 3033
    }
#line 3033

#line 3033
    *xpp = (void *)(xp + rndup);
#line 3033
    return status;
#line 3033
}
#line 3033

int
#line 3034
ncx_pad_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 3034
{
#line 3034
    int status = NC_NOERR;
#line 3034
    size_t rndup = nelems % X_ALIGN;
#line 3034
    uchar *xp = (uchar *) *xpp;
#line 3034

#line 3034
    if (rndup)
#line 3034
        rndup = X_ALIGN - rndup;
#line 3034

#line 3034
    while (nelems-- != 0) {
#line 3034
        
#line 3034
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 3034
    }
#line 3034

#line 3034
    *xpp = (void *)(xp + rndup);
#line 3034
    return status;
#line 3034
}
#line 3034

int
#line 3035
ncx_pad_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 3035
{
#line 3035
    int status = NC_NOERR;
#line 3035
    size_t rndup = nelems % X_ALIGN;
#line 3035
    uchar *xp = (uchar *) *xpp;
#line 3035

#line 3035
    if (rndup)
#line 3035
        rndup = X_ALIGN - rndup;
#line 3035

#line 3035
    while (nelems-- != 0) {
#line 3035
        
#line 3035
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 3035
    }
#line 3035

#line 3035
    *xpp = (void *)(xp + rndup);
#line 3035
    return status;
#line 3035
}
#line 3035

int
#line 3036
ncx_pad_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 3036
{
#line 3036
    int status = NC_NOERR;
#line 3036
    size_t rndup = nelems % X_ALIGN;
#line 3036
    uchar *xp = (uchar *) *xpp;
#line 3036

#line 3036
    if (rndup)
#line 3036
        rndup = X_ALIGN - rndup;
#line 3036

#line 3036
    while (nelems-- != 0) {
#line 3036
        
#line 3036
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 3036
    }
#line 3036

#line 3036
    *xpp = (void *)(xp + rndup);
#line 3036
    return status;
#line 3036
}
#line 3036

int
#line 3037
ncx_pad_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 3037
{
#line 3037
    int status = NC_NOERR;
#line 3037
    size_t rndup = nelems % X_ALIGN;
#line 3037
    uchar *xp = (uchar *) *xpp;
#line 3037

#line 3037
    if (rndup)
#line 3037
        rndup = X_ALIGN - rndup;
#line 3037

#line 3037
    while (nelems-- != 0) {
#line 3037
        
#line 3037
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 3037
    }
#line 3037

#line 3037
    *xpp = (void *)(xp + rndup);
#line 3037
    return status;
#line 3037
}
#line 3037

int
#line 3038
ncx_pad_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3038
{
#line 3038
    int status = NC_NOERR;
#line 3038
    size_t rndup = nelems % X_ALIGN;
#line 3038
    uchar *xp = (uchar *) *xpp;
#line 3038

#line 3038
    if (rndup)
#line 3038
        rndup = X_ALIGN - rndup;
#line 3038

#line 3038
    while (nelems-- != 0) {
#line 3038
        
#line 3038
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 3038
    }
#line 3038

#line 3038
    *xpp = (void *)(xp + rndup);
#line 3038
    return status;
#line 3038
}
#line 3038

int
#line 3039
ncx_pad_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3039
{
#line 3039
    int status = NC_NOERR;
#line 3039
    size_t rndup = nelems % X_ALIGN;
#line 3039
    uchar *xp = (uchar *) *xpp;
#line 3039

#line 3039
    if (rndup)
#line 3039
        rndup = X_ALIGN - rndup;
#line 3039

#line 3039
    while (nelems-- != 0) {
#line 3039
        
#line 3039
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 3039
    }
#line 3039

#line 3039
    *xpp = (void *)(xp + rndup);
#line 3039
    return status;
#line 3039
}
#line 3039

int
#line 3040
ncx_pad_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 3040
{
#line 3040
    int status = NC_NOERR;
#line 3040
    size_t rndup = nelems % X_ALIGN;
#line 3040
    uchar *xp = (uchar *) *xpp;
#line 3040

#line 3040
    if (rndup)
#line 3040
        rndup = X_ALIGN - rndup;
#line 3040

#line 3040
    while (nelems-- != 0) {
#line 3040
        
#line 3040
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 3040
    }
#line 3040

#line 3040
    *xpp = (void *)(xp + rndup);
#line 3040
    return status;
#line 3040
}
#line 3040

int
#line 3041
ncx_pad_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3041
{
#line 3041
    int status = NC_NOERR;
#line 3041
    size_t rndup = nelems % X_ALIGN;
#line 3041
    uchar *xp = (uchar *) *xpp;
#line 3041

#line 3041
    if (rndup)
#line 3041
        rndup = X_ALIGN - rndup;
#line 3041

#line 3041
    while (nelems-- != 0) {
#line 3041
        
#line 3041
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 3041
    }
#line 3041

#line 3041
    *xpp = (void *)(xp + rndup);
#line 3041
    return status;
#line 3041
}
#line 3041


#line 3044
int
ncx_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *) *xpp;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 3052
#ifdef ERANGE_FILL
#line 3052
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3052
#endif
            status = NC_ERANGE;
            
#line 3054
#ifdef ERANGE_FILL
#line 3054
            xp++; tp++; continue;
#line 3054
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    *xpp = (void *)xp;
    return status;
}
#line 3063
int
ncx_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3066
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3066

#line 3066
	return NC_NOERR;
#line 3066

}
int
#line 3068
ncx_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3068
{
#line 3068
    int status = NC_NOERR;
#line 3068
    uchar *xp = (uchar *) *xpp;
#line 3068

#line 3068
    while (nelems-- != 0) {
#line 3068
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 3068
            
#line 3068
#ifdef ERANGE_FILL
#line 3068
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3068
#endif
#line 3068
            status = NC_ERANGE;
#line 3068
            
#line 3068
#ifdef ERANGE_FILL
#line 3068
            xp++; tp++; continue;
#line 3068
#endif
#line 3068
        }
#line 3068
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 3068
    }
#line 3068

#line 3068
    *xpp = (void *)xp;
#line 3068
    return status;
#line 3068
}
#line 3068

int
#line 3069
ncx_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3069
{
#line 3069
    int status = NC_NOERR;
#line 3069
    uchar *xp = (uchar *) *xpp;
#line 3069

#line 3069
    while (nelems-- != 0) {
#line 3069
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 3069
            
#line 3069
#ifdef ERANGE_FILL
#line 3069
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3069
#endif
#line 3069
            status = NC_ERANGE;
#line 3069
            
#line 3069
#ifdef ERANGE_FILL
#line 3069
            xp++; tp++; continue;
#line 3069
#endif
#line 3069
        }
#line 3069
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 3069
    }
#line 3069

#line 3069
    *xpp = (void *)xp;
#line 3069
    return status;
#line 3069
}
#line 3069

int
#line 3070
ncx_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3070
{
#line 3070
    int status = NC_NOERR;
#line 3070
    uchar *xp = (uchar *) *xpp;
#line 3070

#line 3070
    while (nelems-- != 0) {
#line 3070
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 3070
            
#line 3070
#ifdef ERANGE_FILL
#line 3070
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3070
#endif
#line 3070
            status = NC_ERANGE;
#line 3070
            
#line 3070
#ifdef ERANGE_FILL
#line 3070
            xp++; tp++; continue;
#line 3070
#endif
#line 3070
        }
#line 3070
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 3070
    }
#line 3070

#line 3070
    *xpp = (void *)xp;
#line 3070
    return status;
#line 3070
}
#line 3070

int
#line 3071
ncx_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3071
{
#line 3071
    int status = NC_NOERR;
#line 3071
    uchar *xp = (uchar *) *xpp;
#line 3071

#line 3071
    while (nelems-- != 0) {
#line 3071
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 3071
            
#line 3071
#ifdef ERANGE_FILL
#line 3071
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3071
#endif
#line 3071
            status = NC_ERANGE;
#line 3071
            
#line 3071
#ifdef ERANGE_FILL
#line 3071
            xp++; tp++; continue;
#line 3071
#endif
#line 3071
        }
#line 3071
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 3071
    }
#line 3071

#line 3071
    *xpp = (void *)xp;
#line 3071
    return status;
#line 3071
}
#line 3071

int
#line 3072
ncx_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3072
{
#line 3072
    int status = NC_NOERR;
#line 3072
    uchar *xp = (uchar *) *xpp;
#line 3072

#line 3072
    while (nelems-- != 0) {
#line 3072
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 3072
            
#line 3072
#ifdef ERANGE_FILL
#line 3072
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3072
#endif
#line 3072
            status = NC_ERANGE;
#line 3072
            
#line 3072
#ifdef ERANGE_FILL
#line 3072
            xp++; tp++; continue;
#line 3072
#endif
#line 3072
        }
#line 3072
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 3072
    }
#line 3072

#line 3072
    *xpp = (void *)xp;
#line 3072
    return status;
#line 3072
}
#line 3072

int
#line 3073
ncx_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3073
{
#line 3073
    int status = NC_NOERR;
#line 3073
    uchar *xp = (uchar *) *xpp;
#line 3073

#line 3073
    while (nelems-- != 0) {
#line 3073
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 3073
            
#line 3073
#ifdef ERANGE_FILL
#line 3073
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3073
#endif
#line 3073
            status = NC_ERANGE;
#line 3073
            
#line 3073
#ifdef ERANGE_FILL
#line 3073
            xp++; tp++; continue;
#line 3073
#endif
#line 3073
        }
#line 3073
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 3073
    }
#line 3073

#line 3073
    *xpp = (void *)xp;
#line 3073
    return status;
#line 3073
}
#line 3073

int
#line 3074
ncx_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3074
{
#line 3074
    int status = NC_NOERR;
#line 3074
    uchar *xp = (uchar *) *xpp;
#line 3074

#line 3074
    while (nelems-- != 0) {
#line 3074
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 3074
            
#line 3074
#ifdef ERANGE_FILL
#line 3074
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3074
#endif
#line 3074
            status = NC_ERANGE;
#line 3074
            
#line 3074
#ifdef ERANGE_FILL
#line 3074
            xp++; tp++; continue;
#line 3074
#endif
#line 3074
        }
#line 3074
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 3074
    }
#line 3074

#line 3074
    *xpp = (void *)xp;
#line 3074
    return status;
#line 3074
}
#line 3074

int
#line 3075
ncx_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3075
{
#line 3075
    int status = NC_NOERR;
#line 3075
    uchar *xp = (uchar *) *xpp;
#line 3075

#line 3075
    while (nelems-- != 0) {
#line 3075
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 3075
            
#line 3075
#ifdef ERANGE_FILL
#line 3075
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3075
#endif
#line 3075
            status = NC_ERANGE;
#line 3075
            
#line 3075
#ifdef ERANGE_FILL
#line 3075
            xp++; tp++; continue;
#line 3075
#endif
#line 3075
        }
#line 3075
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 3075
    }
#line 3075

#line 3075
    *xpp = (void *)xp;
#line 3075
    return status;
#line 3075
}
#line 3075

int
#line 3076
ncx_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3076
{
#line 3076
    int status = NC_NOERR;
#line 3076
    uchar *xp = (uchar *) *xpp;
#line 3076

#line 3076
    while (nelems-- != 0) {
#line 3076
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 3076
            
#line 3076
#ifdef ERANGE_FILL
#line 3076
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3076
#endif
#line 3076
            status = NC_ERANGE;
#line 3076
            
#line 3076
#ifdef ERANGE_FILL
#line 3076
            xp++; tp++; continue;
#line 3076
#endif
#line 3076
        }
#line 3076
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 3076
    }
#line 3076

#line 3076
    *xpp = (void *)xp;
#line 3076
    return status;
#line 3076
}
#line 3076


#line 3079
int
ncx_pad_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 3090
#ifdef ERANGE_FILL
#line 3090
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3090
#endif
            status = NC_ERANGE;
            
#line 3092
#ifdef ERANGE_FILL
#line 3092
            xp++; tp++; continue;
#line 3092
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    if (rndup) {
        (void) memcpy(xp, nada, (size_t)rndup);
        xp += rndup;
    }

    *xpp = (void *)xp;
    return status;
}
#line 3106
int
ncx_pad_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 3109

#line 3109
	if (rndup)
#line 3109
		rndup = X_ALIGN - rndup;
#line 3109

#line 3109
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3109
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3109

#line 3109
	if (rndup)
#line 3109
	{
#line 3109
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3109
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3109
	}
#line 3109

#line 3109
	return NC_NOERR;
#line 3109

}
int
#line 3111
ncx_pad_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3111
{
#line 3111
    int status = NC_NOERR;
#line 3111
    size_t rndup = nelems % X_ALIGN;
#line 3111
    uchar *xp = (uchar *) *xpp;
#line 3111

#line 3111
    if (rndup) rndup = X_ALIGN - rndup;
#line 3111

#line 3111
    while (nelems-- != 0) {
#line 3111
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 3111
            
#line 3111
#ifdef ERANGE_FILL
#line 3111
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3111
#endif
#line 3111
            status = NC_ERANGE;
#line 3111
            
#line 3111
#ifdef ERANGE_FILL
#line 3111
            xp++; tp++; continue;
#line 3111
#endif
#line 3111
        }
#line 3111
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 3111
    }
#line 3111

#line 3111

#line 3111
    if (rndup) {
#line 3111
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3111
        xp += rndup;
#line 3111
    }
#line 3111

#line 3111
    *xpp = (void *)xp;
#line 3111
    return status;
#line 3111
}
#line 3111

int
#line 3112
ncx_pad_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3112
{
#line 3112
    int status = NC_NOERR;
#line 3112
    size_t rndup = nelems % X_ALIGN;
#line 3112
    uchar *xp = (uchar *) *xpp;
#line 3112

#line 3112
    if (rndup) rndup = X_ALIGN - rndup;
#line 3112

#line 3112
    while (nelems-- != 0) {
#line 3112
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 3112
            
#line 3112
#ifdef ERANGE_FILL
#line 3112
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3112
#endif
#line 3112
            status = NC_ERANGE;
#line 3112
            
#line 3112
#ifdef ERANGE_FILL
#line 3112
            xp++; tp++; continue;
#line 3112
#endif
#line 3112
        }
#line 3112
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 3112
    }
#line 3112

#line 3112

#line 3112
    if (rndup) {
#line 3112
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3112
        xp += rndup;
#line 3112
    }
#line 3112

#line 3112
    *xpp = (void *)xp;
#line 3112
    return status;
#line 3112
}
#line 3112

int
#line 3113
ncx_pad_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3113
{
#line 3113
    int status = NC_NOERR;
#line 3113
    size_t rndup = nelems % X_ALIGN;
#line 3113
    uchar *xp = (uchar *) *xpp;
#line 3113

#line 3113
    if (rndup) rndup = X_ALIGN - rndup;
#line 3113

#line 3113
    while (nelems-- != 0) {
#line 3113
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 3113
            
#line 3113
#ifdef ERANGE_FILL
#line 3113
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3113
#endif
#line 3113
            status = NC_ERANGE;
#line 3113
            
#line 3113
#ifdef ERANGE_FILL
#line 3113
            xp++; tp++; continue;
#line 3113
#endif
#line 3113
        }
#line 3113
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 3113
    }
#line 3113

#line 3113

#line 3113
    if (rndup) {
#line 3113
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3113
        xp += rndup;
#line 3113
    }
#line 3113

#line 3113
    *xpp = (void *)xp;
#line 3113
    return status;
#line 3113
}
#line 3113

int
#line 3114
ncx_pad_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3114
{
#line 3114
    int status = NC_NOERR;
#line 3114
    size_t rndup = nelems % X_ALIGN;
#line 3114
    uchar *xp = (uchar *) *xpp;
#line 3114

#line 3114
    if (rndup) rndup = X_ALIGN - rndup;
#line 3114

#line 3114
    while (nelems-- != 0) {
#line 3114
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 3114
            
#line 3114
#ifdef ERANGE_FILL
#line 3114
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3114
#endif
#line 3114
            status = NC_ERANGE;
#line 3114
            
#line 3114
#ifdef ERANGE_FILL
#line 3114
            xp++; tp++; continue;
#line 3114
#endif
#line 3114
        }
#line 3114
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 3114
    }
#line 3114

#line 3114

#line 3114
    if (rndup) {
#line 3114
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3114
        xp += rndup;
#line 3114
    }
#line 3114

#line 3114
    *xpp = (void *)xp;
#line 3114
    return status;
#line 3114
}
#line 3114

int
#line 3115
ncx_pad_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3115
{
#line 3115
    int status = NC_NOERR;
#line 3115
    size_t rndup = nelems % X_ALIGN;
#line 3115
    uchar *xp = (uchar *) *xpp;
#line 3115

#line 3115
    if (rndup) rndup = X_ALIGN - rndup;
#line 3115

#line 3115
    while (nelems-- != 0) {
#line 3115
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 3115
            
#line 3115
#ifdef ERANGE_FILL
#line 3115
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3115
#endif
#line 3115
            status = NC_ERANGE;
#line 3115
            
#line 3115
#ifdef ERANGE_FILL
#line 3115
            xp++; tp++; continue;
#line 3115
#endif
#line 3115
        }
#line 3115
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 3115
    }
#line 3115

#line 3115

#line 3115
    if (rndup) {
#line 3115
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3115
        xp += rndup;
#line 3115
    }
#line 3115

#line 3115
    *xpp = (void *)xp;
#line 3115
    return status;
#line 3115
}
#line 3115

int
#line 3116
ncx_pad_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3116
{
#line 3116
    int status = NC_NOERR;
#line 3116
    size_t rndup = nelems % X_ALIGN;
#line 3116
    uchar *xp = (uchar *) *xpp;
#line 3116

#line 3116
    if (rndup) rndup = X_ALIGN - rndup;
#line 3116

#line 3116
    while (nelems-- != 0) {
#line 3116
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 3116
            
#line 3116
#ifdef ERANGE_FILL
#line 3116
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3116
#endif
#line 3116
            status = NC_ERANGE;
#line 3116
            
#line 3116
#ifdef ERANGE_FILL
#line 3116
            xp++; tp++; continue;
#line 3116
#endif
#line 3116
        }
#line 3116
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 3116
    }
#line 3116

#line 3116

#line 3116
    if (rndup) {
#line 3116
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3116
        xp += rndup;
#line 3116
    }
#line 3116

#line 3116
    *xpp = (void *)xp;
#line 3116
    return status;
#line 3116
}
#line 3116

int
#line 3117
ncx_pad_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3117
{
#line 3117
    int status = NC_NOERR;
#line 3117
    size_t rndup = nelems % X_ALIGN;
#line 3117
    uchar *xp = (uchar *) *xpp;
#line 3117

#line 3117
    if (rndup) rndup = X_ALIGN - rndup;
#line 3117

#line 3117
    while (nelems-- != 0) {
#line 3117
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 3117
            
#line 3117
#ifdef ERANGE_FILL
#line 3117
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3117
#endif
#line 3117
            status = NC_ERANGE;
#line 3117
            
#line 3117
#ifdef ERANGE_FILL
#line 3117
            xp++; tp++; continue;
#line 3117
#endif
#line 3117
        }
#line 3117
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 3117
    }
#line 3117

#line 3117

#line 3117
    if (rndup) {
#line 3117
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3117
        xp += rndup;
#line 3117
    }
#line 3117

#line 3117
    *xpp = (void *)xp;
#line 3117
    return status;
#line 3117
}
#line 3117

int
#line 3118
ncx_pad_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3118
{
#line 3118
    int status = NC_NOERR;
#line 3118
    size_t rndup = nelems % X_ALIGN;
#line 3118
    uchar *xp = (uchar *) *xpp;
#line 3118

#line 3118
    if (rndup) rndup = X_ALIGN - rndup;
#line 3118

#line 3118
    while (nelems-- != 0) {
#line 3118
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 3118
            
#line 3118
#ifdef ERANGE_FILL
#line 3118
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3118
#endif
#line 3118
            status = NC_ERANGE;
#line 3118
            
#line 3118
#ifdef ERANGE_FILL
#line 3118
            xp++; tp++; continue;
#line 3118
#endif
#line 3118
        }
#line 3118
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 3118
    }
#line 3118

#line 3118

#line 3118
    if (rndup) {
#line 3118
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3118
        xp += rndup;
#line 3118
    }
#line 3118

#line 3118
    *xpp = (void *)xp;
#line 3118
    return status;
#line 3118
}
#line 3118

int
#line 3119
ncx_pad_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3119
{
#line 3119
    int status = NC_NOERR;
#line 3119
    size_t rndup = nelems % X_ALIGN;
#line 3119
    uchar *xp = (uchar *) *xpp;
#line 3119

#line 3119
    if (rndup) rndup = X_ALIGN - rndup;
#line 3119

#line 3119
    while (nelems-- != 0) {
#line 3119
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 3119
            
#line 3119
#ifdef ERANGE_FILL
#line 3119
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3119
#endif
#line 3119
            status = NC_ERANGE;
#line 3119
            
#line 3119
#ifdef ERANGE_FILL
#line 3119
            xp++; tp++; continue;
#line 3119
#endif
#line 3119
        }
#line 3119
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 3119
    }
#line 3119

#line 3119

#line 3119
    if (rndup) {
#line 3119
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3119
        xp += rndup;
#line 3119
    }
#line 3119

#line 3119
    *xpp = (void *)xp;
#line 3119
    return status;
#line 3119
}
#line 3119


/* short ---------------------------------------------------------------------*/

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_SHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 3137
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 3137
{
#line 3137
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3137

#line 3137
 /* basic algorithm is:
#line 3137
  *   - ensure sane alignment of input data
#line 3137
  *   - copy (conversion happens automatically) input data
#line 3137
  *     to output
#line 3137
  *   - update xpp to point at next unconverted input, and tp to point
#line 3137
  *     at next location for converted output
#line 3137
  */
#line 3137
  long i, j, ni;
#line 3137
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3137
  short *xp;
#line 3137
  int nrange = 0;         /* number of range errors */
#line 3137
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3137
  long cxp = (long) *((char**)xpp);
#line 3137

#line 3137
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3137
  /* sjl: manually stripmine so we can limit amount of
#line 3137
   * vector work space reserved to LOOPCNT elements. Also
#line 3137
   * makes vectorisation easy */
#line 3137
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3137
    ni=Min(nelems-j,LOOPCNT);
#line 3137
    if (realign) {
#line 3137
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3137
      xp = tmp;
#line 3137
    } else {
#line 3137
      xp = (short *) *xpp;
#line 3137
    }
#line 3137
   /* copy the next block */
#line 3137
#pragma cdir loopcnt=LOOPCNT
#line 3137
#pragma cdir shortloop
#line 3137
    for (i=0; i<ni; i++) {
#line 3137
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3137
     /* test for range errors (not always needed but do it anyway) */
#line 3137
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3137
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3137
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3137
    }
#line 3137
   /* update xpp and tp */
#line 3137
    if (realign) xp = (short *) *xpp;
#line 3137
    xp += ni;
#line 3137
    tp += ni;
#line 3137
    *xpp = (void*)xp;
#line 3137
  }
#line 3137
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3137

#line 3137
#else   /* not SX */
#line 3137
	const char *xp = (const char *) *xpp;
#line 3137
	int status = NC_NOERR;
#line 3137

#line 3137
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3137
	{
#line 3137
		const int lstatus = ncx_get_short_short(xp, tp);
#line 3137
		if (status == NC_NOERR) /* report the first encountered error */
#line 3137
			status = lstatus;
#line 3137
	}
#line 3137

#line 3137
	*xpp = (const void *)xp;
#line 3137
	return status;
#line 3137
#endif
#line 3137
}
#line 3137

#endif
int
#line 3139
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 3139
{
#line 3139
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3139

#line 3139
 /* basic algorithm is:
#line 3139
  *   - ensure sane alignment of input data
#line 3139
  *   - copy (conversion happens automatically) input data
#line 3139
  *     to output
#line 3139
  *   - update xpp to point at next unconverted input, and tp to point
#line 3139
  *     at next location for converted output
#line 3139
  */
#line 3139
  long i, j, ni;
#line 3139
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3139
  short *xp;
#line 3139
  int nrange = 0;         /* number of range errors */
#line 3139
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3139
  long cxp = (long) *((char**)xpp);
#line 3139

#line 3139
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3139
  /* sjl: manually stripmine so we can limit amount of
#line 3139
   * vector work space reserved to LOOPCNT elements. Also
#line 3139
   * makes vectorisation easy */
#line 3139
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3139
    ni=Min(nelems-j,LOOPCNT);
#line 3139
    if (realign) {
#line 3139
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3139
      xp = tmp;
#line 3139
    } else {
#line 3139
      xp = (short *) *xpp;
#line 3139
    }
#line 3139
   /* copy the next block */
#line 3139
#pragma cdir loopcnt=LOOPCNT
#line 3139
#pragma cdir shortloop
#line 3139
    for (i=0; i<ni; i++) {
#line 3139
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3139
     /* test for range errors (not always needed but do it anyway) */
#line 3139
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3139
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3139
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3139
    }
#line 3139
   /* update xpp and tp */
#line 3139
    if (realign) xp = (short *) *xpp;
#line 3139
    xp += ni;
#line 3139
    tp += ni;
#line 3139
    *xpp = (void*)xp;
#line 3139
  }
#line 3139
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3139

#line 3139
#else   /* not SX */
#line 3139
	const char *xp = (const char *) *xpp;
#line 3139
	int status = NC_NOERR;
#line 3139

#line 3139
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3139
	{
#line 3139
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 3139
		if (status == NC_NOERR) /* report the first encountered error */
#line 3139
			status = lstatus;
#line 3139
	}
#line 3139

#line 3139
	*xpp = (const void *)xp;
#line 3139
	return status;
#line 3139
#endif
#line 3139
}
#line 3139

int
#line 3140
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 3140
{
#line 3140
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3140

#line 3140
 /* basic algorithm is:
#line 3140
  *   - ensure sane alignment of input data
#line 3140
  *   - copy (conversion happens automatically) input data
#line 3140
  *     to output
#line 3140
  *   - update xpp to point at next unconverted input, and tp to point
#line 3140
  *     at next location for converted output
#line 3140
  */
#line 3140
  long i, j, ni;
#line 3140
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3140
  short *xp;
#line 3140
  int nrange = 0;         /* number of range errors */
#line 3140
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3140
  long cxp = (long) *((char**)xpp);
#line 3140

#line 3140
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3140
  /* sjl: manually stripmine so we can limit amount of
#line 3140
   * vector work space reserved to LOOPCNT elements. Also
#line 3140
   * makes vectorisation easy */
#line 3140
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3140
    ni=Min(nelems-j,LOOPCNT);
#line 3140
    if (realign) {
#line 3140
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3140
      xp = tmp;
#line 3140
    } else {
#line 3140
      xp = (short *) *xpp;
#line 3140
    }
#line 3140
   /* copy the next block */
#line 3140
#pragma cdir loopcnt=LOOPCNT
#line 3140
#pragma cdir shortloop
#line 3140
    for (i=0; i<ni; i++) {
#line 3140
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3140
     /* test for range errors (not always needed but do it anyway) */
#line 3140
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3140
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3140
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3140
    }
#line 3140
   /* update xpp and tp */
#line 3140
    if (realign) xp = (short *) *xpp;
#line 3140
    xp += ni;
#line 3140
    tp += ni;
#line 3140
    *xpp = (void*)xp;
#line 3140
  }
#line 3140
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3140

#line 3140
#else   /* not SX */
#line 3140
	const char *xp = (const char *) *xpp;
#line 3140
	int status = NC_NOERR;
#line 3140

#line 3140
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3140
	{
#line 3140
		const int lstatus = ncx_get_short_int(xp, tp);
#line 3140
		if (status == NC_NOERR) /* report the first encountered error */
#line 3140
			status = lstatus;
#line 3140
	}
#line 3140

#line 3140
	*xpp = (const void *)xp;
#line 3140
	return status;
#line 3140
#endif
#line 3140
}
#line 3140

int
#line 3141
ncx_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 3141
{
#line 3141
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3141

#line 3141
 /* basic algorithm is:
#line 3141
  *   - ensure sane alignment of input data
#line 3141
  *   - copy (conversion happens automatically) input data
#line 3141
  *     to output
#line 3141
  *   - update xpp to point at next unconverted input, and tp to point
#line 3141
  *     at next location for converted output
#line 3141
  */
#line 3141
  long i, j, ni;
#line 3141
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3141
  short *xp;
#line 3141
  int nrange = 0;         /* number of range errors */
#line 3141
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3141
  long cxp = (long) *((char**)xpp);
#line 3141

#line 3141
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3141
  /* sjl: manually stripmine so we can limit amount of
#line 3141
   * vector work space reserved to LOOPCNT elements. Also
#line 3141
   * makes vectorisation easy */
#line 3141
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3141
    ni=Min(nelems-j,LOOPCNT);
#line 3141
    if (realign) {
#line 3141
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3141
      xp = tmp;
#line 3141
    } else {
#line 3141
      xp = (short *) *xpp;
#line 3141
    }
#line 3141
   /* copy the next block */
#line 3141
#pragma cdir loopcnt=LOOPCNT
#line 3141
#pragma cdir shortloop
#line 3141
    for (i=0; i<ni; i++) {
#line 3141
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3141
     /* test for range errors (not always needed but do it anyway) */
#line 3141
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3141
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3141
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3141
    }
#line 3141
   /* update xpp and tp */
#line 3141
    if (realign) xp = (short *) *xpp;
#line 3141
    xp += ni;
#line 3141
    tp += ni;
#line 3141
    *xpp = (void*)xp;
#line 3141
  }
#line 3141
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3141

#line 3141
#else   /* not SX */
#line 3141
	const char *xp = (const char *) *xpp;
#line 3141
	int status = NC_NOERR;
#line 3141

#line 3141
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3141
	{
#line 3141
		const int lstatus = ncx_get_short_long(xp, tp);
#line 3141
		if (status == NC_NOERR) /* report the first encountered error */
#line 3141
			status = lstatus;
#line 3141
	}
#line 3141

#line 3141
	*xpp = (const void *)xp;
#line 3141
	return status;
#line 3141
#endif
#line 3141
}
#line 3141

int
#line 3142
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 3142
{
#line 3142
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3142

#line 3142
 /* basic algorithm is:
#line 3142
  *   - ensure sane alignment of input data
#line 3142
  *   - copy (conversion happens automatically) input data
#line 3142
  *     to output
#line 3142
  *   - update xpp to point at next unconverted input, and tp to point
#line 3142
  *     at next location for converted output
#line 3142
  */
#line 3142
  long i, j, ni;
#line 3142
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3142
  short *xp;
#line 3142
  int nrange = 0;         /* number of range errors */
#line 3142
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3142
  long cxp = (long) *((char**)xpp);
#line 3142

#line 3142
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3142
  /* sjl: manually stripmine so we can limit amount of
#line 3142
   * vector work space reserved to LOOPCNT elements. Also
#line 3142
   * makes vectorisation easy */
#line 3142
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3142
    ni=Min(nelems-j,LOOPCNT);
#line 3142
    if (realign) {
#line 3142
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3142
      xp = tmp;
#line 3142
    } else {
#line 3142
      xp = (short *) *xpp;
#line 3142
    }
#line 3142
   /* copy the next block */
#line 3142
#pragma cdir loopcnt=LOOPCNT
#line 3142
#pragma cdir shortloop
#line 3142
    for (i=0; i<ni; i++) {
#line 3142
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3142
     /* test for range errors (not always needed but do it anyway) */
#line 3142
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3142
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3142
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3142
    }
#line 3142
   /* update xpp and tp */
#line 3142
    if (realign) xp = (short *) *xpp;
#line 3142
    xp += ni;
#line 3142
    tp += ni;
#line 3142
    *xpp = (void*)xp;
#line 3142
  }
#line 3142
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3142

#line 3142
#else   /* not SX */
#line 3142
	const char *xp = (const char *) *xpp;
#line 3142
	int status = NC_NOERR;
#line 3142

#line 3142
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3142
	{
#line 3142
		const int lstatus = ncx_get_short_float(xp, tp);
#line 3142
		if (status == NC_NOERR) /* report the first encountered error */
#line 3142
			status = lstatus;
#line 3142
	}
#line 3142

#line 3142
	*xpp = (const void *)xp;
#line 3142
	return status;
#line 3142
#endif
#line 3142
}
#line 3142

int
#line 3143
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 3143
{
#line 3143
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3143

#line 3143
 /* basic algorithm is:
#line 3143
  *   - ensure sane alignment of input data
#line 3143
  *   - copy (conversion happens automatically) input data
#line 3143
  *     to output
#line 3143
  *   - update xpp to point at next unconverted input, and tp to point
#line 3143
  *     at next location for converted output
#line 3143
  */
#line 3143
  long i, j, ni;
#line 3143
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3143
  short *xp;
#line 3143
  int nrange = 0;         /* number of range errors */
#line 3143
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3143
  long cxp = (long) *((char**)xpp);
#line 3143

#line 3143
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3143
  /* sjl: manually stripmine so we can limit amount of
#line 3143
   * vector work space reserved to LOOPCNT elements. Also
#line 3143
   * makes vectorisation easy */
#line 3143
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3143
    ni=Min(nelems-j,LOOPCNT);
#line 3143
    if (realign) {
#line 3143
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3143
      xp = tmp;
#line 3143
    } else {
#line 3143
      xp = (short *) *xpp;
#line 3143
    }
#line 3143
   /* copy the next block */
#line 3143
#pragma cdir loopcnt=LOOPCNT
#line 3143
#pragma cdir shortloop
#line 3143
    for (i=0; i<ni; i++) {
#line 3143
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3143
     /* test for range errors (not always needed but do it anyway) */
#line 3143
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3143
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3143
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3143
    }
#line 3143
   /* update xpp and tp */
#line 3143
    if (realign) xp = (short *) *xpp;
#line 3143
    xp += ni;
#line 3143
    tp += ni;
#line 3143
    *xpp = (void*)xp;
#line 3143
  }
#line 3143
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3143

#line 3143
#else   /* not SX */
#line 3143
	const char *xp = (const char *) *xpp;
#line 3143
	int status = NC_NOERR;
#line 3143

#line 3143
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3143
	{
#line 3143
		const int lstatus = ncx_get_short_double(xp, tp);
#line 3143
		if (status == NC_NOERR) /* report the first encountered error */
#line 3143
			status = lstatus;
#line 3143
	}
#line 3143

#line 3143
	*xpp = (const void *)xp;
#line 3143
	return status;
#line 3143
#endif
#line 3143
}
#line 3143

int
#line 3144
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3144
{
#line 3144
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3144

#line 3144
 /* basic algorithm is:
#line 3144
  *   - ensure sane alignment of input data
#line 3144
  *   - copy (conversion happens automatically) input data
#line 3144
  *     to output
#line 3144
  *   - update xpp to point at next unconverted input, and tp to point
#line 3144
  *     at next location for converted output
#line 3144
  */
#line 3144
  long i, j, ni;
#line 3144
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3144
  short *xp;
#line 3144
  int nrange = 0;         /* number of range errors */
#line 3144
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3144
  long cxp = (long) *((char**)xpp);
#line 3144

#line 3144
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3144
  /* sjl: manually stripmine so we can limit amount of
#line 3144
   * vector work space reserved to LOOPCNT elements. Also
#line 3144
   * makes vectorisation easy */
#line 3144
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3144
    ni=Min(nelems-j,LOOPCNT);
#line 3144
    if (realign) {
#line 3144
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3144
      xp = tmp;
#line 3144
    } else {
#line 3144
      xp = (short *) *xpp;
#line 3144
    }
#line 3144
   /* copy the next block */
#line 3144
#pragma cdir loopcnt=LOOPCNT
#line 3144
#pragma cdir shortloop
#line 3144
    for (i=0; i<ni; i++) {
#line 3144
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3144
     /* test for range errors (not always needed but do it anyway) */
#line 3144
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3144
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3144
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3144
    }
#line 3144
   /* update xpp and tp */
#line 3144
    if (realign) xp = (short *) *xpp;
#line 3144
    xp += ni;
#line 3144
    tp += ni;
#line 3144
    *xpp = (void*)xp;
#line 3144
  }
#line 3144
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3144

#line 3144
#else   /* not SX */
#line 3144
	const char *xp = (const char *) *xpp;
#line 3144
	int status = NC_NOERR;
#line 3144

#line 3144
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3144
	{
#line 3144
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 3144
		if (status == NC_NOERR) /* report the first encountered error */
#line 3144
			status = lstatus;
#line 3144
	}
#line 3144

#line 3144
	*xpp = (const void *)xp;
#line 3144
	return status;
#line 3144
#endif
#line 3144
}
#line 3144

int
#line 3145
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3145
{
#line 3145
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3145

#line 3145
 /* basic algorithm is:
#line 3145
  *   - ensure sane alignment of input data
#line 3145
  *   - copy (conversion happens automatically) input data
#line 3145
  *     to output
#line 3145
  *   - update xpp to point at next unconverted input, and tp to point
#line 3145
  *     at next location for converted output
#line 3145
  */
#line 3145
  long i, j, ni;
#line 3145
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3145
  short *xp;
#line 3145
  int nrange = 0;         /* number of range errors */
#line 3145
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3145
  long cxp = (long) *((char**)xpp);
#line 3145

#line 3145
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3145
  /* sjl: manually stripmine so we can limit amount of
#line 3145
   * vector work space reserved to LOOPCNT elements. Also
#line 3145
   * makes vectorisation easy */
#line 3145
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3145
    ni=Min(nelems-j,LOOPCNT);
#line 3145
    if (realign) {
#line 3145
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3145
      xp = tmp;
#line 3145
    } else {
#line 3145
      xp = (short *) *xpp;
#line 3145
    }
#line 3145
   /* copy the next block */
#line 3145
#pragma cdir loopcnt=LOOPCNT
#line 3145
#pragma cdir shortloop
#line 3145
    for (i=0; i<ni; i++) {
#line 3145
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3145
     /* test for range errors (not always needed but do it anyway) */
#line 3145
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3145
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3145
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3145
    }
#line 3145
   /* update xpp and tp */
#line 3145
    if (realign) xp = (short *) *xpp;
#line 3145
    xp += ni;
#line 3145
    tp += ni;
#line 3145
    *xpp = (void*)xp;
#line 3145
  }
#line 3145
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3145

#line 3145
#else   /* not SX */
#line 3145
	const char *xp = (const char *) *xpp;
#line 3145
	int status = NC_NOERR;
#line 3145

#line 3145
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3145
	{
#line 3145
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 3145
		if (status == NC_NOERR) /* report the first encountered error */
#line 3145
			status = lstatus;
#line 3145
	}
#line 3145

#line 3145
	*xpp = (const void *)xp;
#line 3145
	return status;
#line 3145
#endif
#line 3145
}
#line 3145

int
#line 3146
ncx_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3146
{
#line 3146
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3146

#line 3146
 /* basic algorithm is:
#line 3146
  *   - ensure sane alignment of input data
#line 3146
  *   - copy (conversion happens automatically) input data
#line 3146
  *     to output
#line 3146
  *   - update xpp to point at next unconverted input, and tp to point
#line 3146
  *     at next location for converted output
#line 3146
  */
#line 3146
  long i, j, ni;
#line 3146
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3146
  short *xp;
#line 3146
  int nrange = 0;         /* number of range errors */
#line 3146
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3146
  long cxp = (long) *((char**)xpp);
#line 3146

#line 3146
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3146
  /* sjl: manually stripmine so we can limit amount of
#line 3146
   * vector work space reserved to LOOPCNT elements. Also
#line 3146
   * makes vectorisation easy */
#line 3146
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3146
    ni=Min(nelems-j,LOOPCNT);
#line 3146
    if (realign) {
#line 3146
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3146
      xp = tmp;
#line 3146
    } else {
#line 3146
      xp = (short *) *xpp;
#line 3146
    }
#line 3146
   /* copy the next block */
#line 3146
#pragma cdir loopcnt=LOOPCNT
#line 3146
#pragma cdir shortloop
#line 3146
    for (i=0; i<ni; i++) {
#line 3146
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3146
     /* test for range errors (not always needed but do it anyway) */
#line 3146
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3146
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3146
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3146
    }
#line 3146
   /* update xpp and tp */
#line 3146
    if (realign) xp = (short *) *xpp;
#line 3146
    xp += ni;
#line 3146
    tp += ni;
#line 3146
    *xpp = (void*)xp;
#line 3146
  }
#line 3146
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3146

#line 3146
#else   /* not SX */
#line 3146
	const char *xp = (const char *) *xpp;
#line 3146
	int status = NC_NOERR;
#line 3146

#line 3146
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3146
	{
#line 3146
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 3146
		if (status == NC_NOERR) /* report the first encountered error */
#line 3146
			status = lstatus;
#line 3146
	}
#line 3146

#line 3146
	*xpp = (const void *)xp;
#line 3146
	return status;
#line 3146
#endif
#line 3146
}
#line 3146

int
#line 3147
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 3147
{
#line 3147
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3147

#line 3147
 /* basic algorithm is:
#line 3147
  *   - ensure sane alignment of input data
#line 3147
  *   - copy (conversion happens automatically) input data
#line 3147
  *     to output
#line 3147
  *   - update xpp to point at next unconverted input, and tp to point
#line 3147
  *     at next location for converted output
#line 3147
  */
#line 3147
  long i, j, ni;
#line 3147
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3147
  short *xp;
#line 3147
  int nrange = 0;         /* number of range errors */
#line 3147
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3147
  long cxp = (long) *((char**)xpp);
#line 3147

#line 3147
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3147
  /* sjl: manually stripmine so we can limit amount of
#line 3147
   * vector work space reserved to LOOPCNT elements. Also
#line 3147
   * makes vectorisation easy */
#line 3147
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3147
    ni=Min(nelems-j,LOOPCNT);
#line 3147
    if (realign) {
#line 3147
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3147
      xp = tmp;
#line 3147
    } else {
#line 3147
      xp = (short *) *xpp;
#line 3147
    }
#line 3147
   /* copy the next block */
#line 3147
#pragma cdir loopcnt=LOOPCNT
#line 3147
#pragma cdir shortloop
#line 3147
    for (i=0; i<ni; i++) {
#line 3147
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3147
     /* test for range errors (not always needed but do it anyway) */
#line 3147
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3147
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3147
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3147
    }
#line 3147
   /* update xpp and tp */
#line 3147
    if (realign) xp = (short *) *xpp;
#line 3147
    xp += ni;
#line 3147
    tp += ni;
#line 3147
    *xpp = (void*)xp;
#line 3147
  }
#line 3147
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3147

#line 3147
#else   /* not SX */
#line 3147
	const char *xp = (const char *) *xpp;
#line 3147
	int status = NC_NOERR;
#line 3147

#line 3147
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3147
	{
#line 3147
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 3147
		if (status == NC_NOERR) /* report the first encountered error */
#line 3147
			status = lstatus;
#line 3147
	}
#line 3147

#line 3147
	*xpp = (const void *)xp;
#line 3147
	return status;
#line 3147
#endif
#line 3147
}
#line 3147

int
#line 3148
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3148
{
#line 3148
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3148

#line 3148
 /* basic algorithm is:
#line 3148
  *   - ensure sane alignment of input data
#line 3148
  *   - copy (conversion happens automatically) input data
#line 3148
  *     to output
#line 3148
  *   - update xpp to point at next unconverted input, and tp to point
#line 3148
  *     at next location for converted output
#line 3148
  */
#line 3148
  long i, j, ni;
#line 3148
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3148
  short *xp;
#line 3148
  int nrange = 0;         /* number of range errors */
#line 3148
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3148
  long cxp = (long) *((char**)xpp);
#line 3148

#line 3148
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3148
  /* sjl: manually stripmine so we can limit amount of
#line 3148
   * vector work space reserved to LOOPCNT elements. Also
#line 3148
   * makes vectorisation easy */
#line 3148
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3148
    ni=Min(nelems-j,LOOPCNT);
#line 3148
    if (realign) {
#line 3148
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3148
      xp = tmp;
#line 3148
    } else {
#line 3148
      xp = (short *) *xpp;
#line 3148
    }
#line 3148
   /* copy the next block */
#line 3148
#pragma cdir loopcnt=LOOPCNT
#line 3148
#pragma cdir shortloop
#line 3148
    for (i=0; i<ni; i++) {
#line 3148
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3148
     /* test for range errors (not always needed but do it anyway) */
#line 3148
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3148
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3148
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3148
    }
#line 3148
   /* update xpp and tp */
#line 3148
    if (realign) xp = (short *) *xpp;
#line 3148
    xp += ni;
#line 3148
    tp += ni;
#line 3148
    *xpp = (void*)xp;
#line 3148
  }
#line 3148
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3148

#line 3148
#else   /* not SX */
#line 3148
	const char *xp = (const char *) *xpp;
#line 3148
	int status = NC_NOERR;
#line 3148

#line 3148
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3148
	{
#line 3148
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 3148
		if (status == NC_NOERR) /* report the first encountered error */
#line 3148
			status = lstatus;
#line 3148
	}
#line 3148

#line 3148
	*xpp = (const void *)xp;
#line 3148
	return status;
#line 3148
#endif
#line 3148
}
#line 3148


int
#line 3150
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 3150
{
#line 3150
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3150

#line 3150
	const char *xp = (const char *) *xpp;
#line 3150
	int status = NC_NOERR;
#line 3150

#line 3150
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3150
	{
#line 3150
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 3150
		if (status == NC_NOERR) /* report the first encountered error */
#line 3150
			status = lstatus;
#line 3150
	}
#line 3150

#line 3150
	if (rndup != 0)
#line 3150
		xp += X_SIZEOF_SHORT;
#line 3150

#line 3150
	*xpp = (void *)xp;
#line 3150
	return status;
#line 3150
}
#line 3150

int
#line 3151
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3151
{
#line 3151
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3151

#line 3151
	const char *xp = (const char *) *xpp;
#line 3151
	int status = NC_NOERR;
#line 3151

#line 3151
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3151
	{
#line 3151
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 3151
		if (status == NC_NOERR) /* report the first encountered error */
#line 3151
			status = lstatus;
#line 3151
	}
#line 3151

#line 3151
	if (rndup != 0)
#line 3151
		xp += X_SIZEOF_SHORT;
#line 3151

#line 3151
	*xpp = (void *)xp;
#line 3151
	return status;
#line 3151
}
#line 3151

int
#line 3152
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 3152
{
#line 3152
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3152

#line 3152
	const char *xp = (const char *) *xpp;
#line 3152
	int status = NC_NOERR;
#line 3152

#line 3152
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3152
	{
#line 3152
		const int lstatus = ncx_get_short_short(xp, tp);
#line 3152
		if (status == NC_NOERR) /* report the first encountered error */
#line 3152
			status = lstatus;
#line 3152
	}
#line 3152

#line 3152
	if (rndup != 0)
#line 3152
		xp += X_SIZEOF_SHORT;
#line 3152

#line 3152
	*xpp = (void *)xp;
#line 3152
	return status;
#line 3152
}
#line 3152

int
#line 3153
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 3153
{
#line 3153
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3153

#line 3153
	const char *xp = (const char *) *xpp;
#line 3153
	int status = NC_NOERR;
#line 3153

#line 3153
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3153
	{
#line 3153
		const int lstatus = ncx_get_short_int(xp, tp);
#line 3153
		if (status == NC_NOERR) /* report the first encountered error */
#line 3153
			status = lstatus;
#line 3153
	}
#line 3153

#line 3153
	if (rndup != 0)
#line 3153
		xp += X_SIZEOF_SHORT;
#line 3153

#line 3153
	*xpp = (void *)xp;
#line 3153
	return status;
#line 3153
}
#line 3153

int
#line 3154
ncx_pad_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 3154
{
#line 3154
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3154

#line 3154
	const char *xp = (const char *) *xpp;
#line 3154
	int status = NC_NOERR;
#line 3154

#line 3154
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3154
	{
#line 3154
		const int lstatus = ncx_get_short_long(xp, tp);
#line 3154
		if (status == NC_NOERR) /* report the first encountered error */
#line 3154
			status = lstatus;
#line 3154
	}
#line 3154

#line 3154
	if (rndup != 0)
#line 3154
		xp += X_SIZEOF_SHORT;
#line 3154

#line 3154
	*xpp = (void *)xp;
#line 3154
	return status;
#line 3154
}
#line 3154

int
#line 3155
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 3155
{
#line 3155
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3155

#line 3155
	const char *xp = (const char *) *xpp;
#line 3155
	int status = NC_NOERR;
#line 3155

#line 3155
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3155
	{
#line 3155
		const int lstatus = ncx_get_short_float(xp, tp);
#line 3155
		if (status == NC_NOERR) /* report the first encountered error */
#line 3155
			status = lstatus;
#line 3155
	}
#line 3155

#line 3155
	if (rndup != 0)
#line 3155
		xp += X_SIZEOF_SHORT;
#line 3155

#line 3155
	*xpp = (void *)xp;
#line 3155
	return status;
#line 3155
}
#line 3155

int
#line 3156
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 3156
{
#line 3156
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3156

#line 3156
	const char *xp = (const char *) *xpp;
#line 3156
	int status = NC_NOERR;
#line 3156

#line 3156
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3156
	{
#line 3156
		const int lstatus = ncx_get_short_double(xp, tp);
#line 3156
		if (status == NC_NOERR) /* report the first encountered error */
#line 3156
			status = lstatus;
#line 3156
	}
#line 3156

#line 3156
	if (rndup != 0)
#line 3156
		xp += X_SIZEOF_SHORT;
#line 3156

#line 3156
	*xpp = (void *)xp;
#line 3156
	return status;
#line 3156
}
#line 3156

int
#line 3157
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 3157
{
#line 3157
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3157

#line 3157
	const char *xp = (const char *) *xpp;
#line 3157
	int status = NC_NOERR;
#line 3157

#line 3157
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3157
	{
#line 3157
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 3157
		if (status == NC_NOERR) /* report the first encountered error */
#line 3157
			status = lstatus;
#line 3157
	}
#line 3157

#line 3157
	if (rndup != 0)
#line 3157
		xp += X_SIZEOF_SHORT;
#line 3157

#line 3157
	*xpp = (void *)xp;
#line 3157
	return status;
#line 3157
}
#line 3157

int
#line 3158
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3158
{
#line 3158
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3158

#line 3158
	const char *xp = (const char *) *xpp;
#line 3158
	int status = NC_NOERR;
#line 3158

#line 3158
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3158
	{
#line 3158
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 3158
		if (status == NC_NOERR) /* report the first encountered error */
#line 3158
			status = lstatus;
#line 3158
	}
#line 3158

#line 3158
	if (rndup != 0)
#line 3158
		xp += X_SIZEOF_SHORT;
#line 3158

#line 3158
	*xpp = (void *)xp;
#line 3158
	return status;
#line 3158
}
#line 3158

int
#line 3159
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3159
{
#line 3159
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3159

#line 3159
	const char *xp = (const char *) *xpp;
#line 3159
	int status = NC_NOERR;
#line 3159

#line 3159
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3159
	{
#line 3159
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 3159
		if (status == NC_NOERR) /* report the first encountered error */
#line 3159
			status = lstatus;
#line 3159
	}
#line 3159

#line 3159
	if (rndup != 0)
#line 3159
		xp += X_SIZEOF_SHORT;
#line 3159

#line 3159
	*xpp = (void *)xp;
#line 3159
	return status;
#line 3159
}
#line 3159

int
#line 3160
ncx_pad_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3160
{
#line 3160
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3160

#line 3160
	const char *xp = (const char *) *xpp;
#line 3160
	int status = NC_NOERR;
#line 3160

#line 3160
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3160
	{
#line 3160
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 3160
		if (status == NC_NOERR) /* report the first encountered error */
#line 3160
			status = lstatus;
#line 3160
	}
#line 3160

#line 3160
	if (rndup != 0)
#line 3160
		xp += X_SIZEOF_SHORT;
#line 3160

#line 3160
	*xpp = (void *)xp;
#line 3160
	return status;
#line 3160
}
#line 3160


#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 3176
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3176
{
#line 3176
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3176

#line 3176
 /* basic algorithm is:
#line 3176
  *   - ensure sane alignment of output data
#line 3176
  *   - copy (conversion happens automatically) input data
#line 3176
  *     to output
#line 3176
  *   - update tp to point at next unconverted input, and xpp to point
#line 3176
  *     at next location for converted output
#line 3176
  */
#line 3176
  long i, j, ni;
#line 3176
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3176
  short *xp;
#line 3176
  int nrange = 0;         /* number of range errors */
#line 3176
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3176
  long cxp = (long) *((char**)xpp);
#line 3176

#line 3176
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3176
  /* sjl: manually stripmine so we can limit amount of
#line 3176
   * vector work space reserved to LOOPCNT elements. Also
#line 3176
   * makes vectorisation easy */
#line 3176
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3176
    ni=Min(nelems-j,LOOPCNT);
#line 3176
    if (realign) {
#line 3176
      xp = tmp;
#line 3176
    } else {
#line 3176
      xp = (short *) *xpp;
#line 3176
    }
#line 3176
   /* copy the next block */
#line 3176
#pragma cdir loopcnt=LOOPCNT
#line 3176
#pragma cdir shortloop
#line 3176
    for (i=0; i<ni; i++) {
#line 3176
      /* the normal case: */
#line 3176
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3176
     /* test for range errors (not always needed but do it anyway) */
#line 3176
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3176
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3176
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3176
    }
#line 3176
   /* copy workspace back if necessary */
#line 3176
    if (realign) {
#line 3176
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3176
      xp = (short *) *xpp;
#line 3176
    }
#line 3176
   /* update xpp and tp */
#line 3176
    xp += ni;
#line 3176
    tp += ni;
#line 3176
    *xpp = (void*)xp;
#line 3176
  }
#line 3176
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3176

#line 3176
#else   /* not SX */
#line 3176

#line 3176
	char *xp = (char *) *xpp;
#line 3176
	int status = NC_NOERR;
#line 3176

#line 3176
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3176
	{
#line 3176
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 3176
		if (status == NC_NOERR) /* report the first encountered error */
#line 3176
			status = lstatus;
#line 3176
	}
#line 3176

#line 3176
	*xpp = (void *)xp;
#line 3176
	return status;
#line 3176
#endif
#line 3176
}
#line 3176

#endif
int
#line 3178
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3178
{
#line 3178
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3178

#line 3178
 /* basic algorithm is:
#line 3178
  *   - ensure sane alignment of output data
#line 3178
  *   - copy (conversion happens automatically) input data
#line 3178
  *     to output
#line 3178
  *   - update tp to point at next unconverted input, and xpp to point
#line 3178
  *     at next location for converted output
#line 3178
  */
#line 3178
  long i, j, ni;
#line 3178
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3178
  short *xp;
#line 3178
  int nrange = 0;         /* number of range errors */
#line 3178
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3178
  long cxp = (long) *((char**)xpp);
#line 3178

#line 3178
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3178
  /* sjl: manually stripmine so we can limit amount of
#line 3178
   * vector work space reserved to LOOPCNT elements. Also
#line 3178
   * makes vectorisation easy */
#line 3178
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3178
    ni=Min(nelems-j,LOOPCNT);
#line 3178
    if (realign) {
#line 3178
      xp = tmp;
#line 3178
    } else {
#line 3178
      xp = (short *) *xpp;
#line 3178
    }
#line 3178
   /* copy the next block */
#line 3178
#pragma cdir loopcnt=LOOPCNT
#line 3178
#pragma cdir shortloop
#line 3178
    for (i=0; i<ni; i++) {
#line 3178
      /* the normal case: */
#line 3178
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3178
     /* test for range errors (not always needed but do it anyway) */
#line 3178
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3178
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3178
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3178
    }
#line 3178
   /* copy workspace back if necessary */
#line 3178
    if (realign) {
#line 3178
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3178
      xp = (short *) *xpp;
#line 3178
    }
#line 3178
   /* update xpp and tp */
#line 3178
    xp += ni;
#line 3178
    tp += ni;
#line 3178
    *xpp = (void*)xp;
#line 3178
  }
#line 3178
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3178

#line 3178
#else   /* not SX */
#line 3178

#line 3178
	char *xp = (char *) *xpp;
#line 3178
	int status = NC_NOERR;
#line 3178

#line 3178
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3178
	{
#line 3178
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 3178
		if (status == NC_NOERR) /* report the first encountered error */
#line 3178
			status = lstatus;
#line 3178
	}
#line 3178

#line 3178
	*xpp = (void *)xp;
#line 3178
	return status;
#line 3178
#endif
#line 3178
}
#line 3178

int
#line 3179
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3179
{
#line 3179
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3179

#line 3179
 /* basic algorithm is:
#line 3179
  *   - ensure sane alignment of output data
#line 3179
  *   - copy (conversion happens automatically) input data
#line 3179
  *     to output
#line 3179
  *   - update tp to point at next unconverted input, and xpp to point
#line 3179
  *     at next location for converted output
#line 3179
  */
#line 3179
  long i, j, ni;
#line 3179
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3179
  short *xp;
#line 3179
  int nrange = 0;         /* number of range errors */
#line 3179
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3179
  long cxp = (long) *((char**)xpp);
#line 3179

#line 3179
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3179
  /* sjl: manually stripmine so we can limit amount of
#line 3179
   * vector work space reserved to LOOPCNT elements. Also
#line 3179
   * makes vectorisation easy */
#line 3179
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3179
    ni=Min(nelems-j,LOOPCNT);
#line 3179
    if (realign) {
#line 3179
      xp = tmp;
#line 3179
    } else {
#line 3179
      xp = (short *) *xpp;
#line 3179
    }
#line 3179
   /* copy the next block */
#line 3179
#pragma cdir loopcnt=LOOPCNT
#line 3179
#pragma cdir shortloop
#line 3179
    for (i=0; i<ni; i++) {
#line 3179
      /* the normal case: */
#line 3179
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3179
     /* test for range errors (not always needed but do it anyway) */
#line 3179
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3179
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3179
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3179
    }
#line 3179
   /* copy workspace back if necessary */
#line 3179
    if (realign) {
#line 3179
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3179
      xp = (short *) *xpp;
#line 3179
    }
#line 3179
   /* update xpp and tp */
#line 3179
    xp += ni;
#line 3179
    tp += ni;
#line 3179
    *xpp = (void*)xp;
#line 3179
  }
#line 3179
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3179

#line 3179
#else   /* not SX */
#line 3179

#line 3179
	char *xp = (char *) *xpp;
#line 3179
	int status = NC_NOERR;
#line 3179

#line 3179
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3179
	{
#line 3179
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 3179
		if (status == NC_NOERR) /* report the first encountered error */
#line 3179
			status = lstatus;
#line 3179
	}
#line 3179

#line 3179
	*xpp = (void *)xp;
#line 3179
	return status;
#line 3179
#endif
#line 3179
}
#line 3179

int
#line 3180
ncx_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3180
{
#line 3180
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3180

#line 3180
 /* basic algorithm is:
#line 3180
  *   - ensure sane alignment of output data
#line 3180
  *   - copy (conversion happens automatically) input data
#line 3180
  *     to output
#line 3180
  *   - update tp to point at next unconverted input, and xpp to point
#line 3180
  *     at next location for converted output
#line 3180
  */
#line 3180
  long i, j, ni;
#line 3180
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3180
  short *xp;
#line 3180
  int nrange = 0;         /* number of range errors */
#line 3180
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3180
  long cxp = (long) *((char**)xpp);
#line 3180

#line 3180
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3180
  /* sjl: manually stripmine so we can limit amount of
#line 3180
   * vector work space reserved to LOOPCNT elements. Also
#line 3180
   * makes vectorisation easy */
#line 3180
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3180
    ni=Min(nelems-j,LOOPCNT);
#line 3180
    if (realign) {
#line 3180
      xp = tmp;
#line 3180
    } else {
#line 3180
      xp = (short *) *xpp;
#line 3180
    }
#line 3180
   /* copy the next block */
#line 3180
#pragma cdir loopcnt=LOOPCNT
#line 3180
#pragma cdir shortloop
#line 3180
    for (i=0; i<ni; i++) {
#line 3180
      /* the normal case: */
#line 3180
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3180
     /* test for range errors (not always needed but do it anyway) */
#line 3180
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3180
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3180
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3180
    }
#line 3180
   /* copy workspace back if necessary */
#line 3180
    if (realign) {
#line 3180
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3180
      xp = (short *) *xpp;
#line 3180
    }
#line 3180
   /* update xpp and tp */
#line 3180
    xp += ni;
#line 3180
    tp += ni;
#line 3180
    *xpp = (void*)xp;
#line 3180
  }
#line 3180
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3180

#line 3180
#else   /* not SX */
#line 3180

#line 3180
	char *xp = (char *) *xpp;
#line 3180
	int status = NC_NOERR;
#line 3180

#line 3180
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3180
	{
#line 3180
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 3180
		if (status == NC_NOERR) /* report the first encountered error */
#line 3180
			status = lstatus;
#line 3180
	}
#line 3180

#line 3180
	*xpp = (void *)xp;
#line 3180
	return status;
#line 3180
#endif
#line 3180
}
#line 3180

int
#line 3181
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3181
{
#line 3181
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3181

#line 3181
 /* basic algorithm is:
#line 3181
  *   - ensure sane alignment of output data
#line 3181
  *   - copy (conversion happens automatically) input data
#line 3181
  *     to output
#line 3181
  *   - update tp to point at next unconverted input, and xpp to point
#line 3181
  *     at next location for converted output
#line 3181
  */
#line 3181
  long i, j, ni;
#line 3181
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3181
  short *xp;
#line 3181
  int nrange = 0;         /* number of range errors */
#line 3181
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3181
  long cxp = (long) *((char**)xpp);
#line 3181

#line 3181
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3181
  /* sjl: manually stripmine so we can limit amount of
#line 3181
   * vector work space reserved to LOOPCNT elements. Also
#line 3181
   * makes vectorisation easy */
#line 3181
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3181
    ni=Min(nelems-j,LOOPCNT);
#line 3181
    if (realign) {
#line 3181
      xp = tmp;
#line 3181
    } else {
#line 3181
      xp = (short *) *xpp;
#line 3181
    }
#line 3181
   /* copy the next block */
#line 3181
#pragma cdir loopcnt=LOOPCNT
#line 3181
#pragma cdir shortloop
#line 3181
    for (i=0; i<ni; i++) {
#line 3181
      /* the normal case: */
#line 3181
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3181
     /* test for range errors (not always needed but do it anyway) */
#line 3181
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3181
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3181
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3181
    }
#line 3181
   /* copy workspace back if necessary */
#line 3181
    if (realign) {
#line 3181
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3181
      xp = (short *) *xpp;
#line 3181
    }
#line 3181
   /* update xpp and tp */
#line 3181
    xp += ni;
#line 3181
    tp += ni;
#line 3181
    *xpp = (void*)xp;
#line 3181
  }
#line 3181
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3181

#line 3181
#else   /* not SX */
#line 3181

#line 3181
	char *xp = (char *) *xpp;
#line 3181
	int status = NC_NOERR;
#line 3181

#line 3181
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3181
	{
#line 3181
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 3181
		if (status == NC_NOERR) /* report the first encountered error */
#line 3181
			status = lstatus;
#line 3181
	}
#line 3181

#line 3181
	*xpp = (void *)xp;
#line 3181
	return status;
#line 3181
#endif
#line 3181
}
#line 3181

int
#line 3182
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3182
{
#line 3182
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3182

#line 3182
 /* basic algorithm is:
#line 3182
  *   - ensure sane alignment of output data
#line 3182
  *   - copy (conversion happens automatically) input data
#line 3182
  *     to output
#line 3182
  *   - update tp to point at next unconverted input, and xpp to point
#line 3182
  *     at next location for converted output
#line 3182
  */
#line 3182
  long i, j, ni;
#line 3182
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3182
  short *xp;
#line 3182
  int nrange = 0;         /* number of range errors */
#line 3182
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3182
  long cxp = (long) *((char**)xpp);
#line 3182

#line 3182
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3182
  /* sjl: manually stripmine so we can limit amount of
#line 3182
   * vector work space reserved to LOOPCNT elements. Also
#line 3182
   * makes vectorisation easy */
#line 3182
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3182
    ni=Min(nelems-j,LOOPCNT);
#line 3182
    if (realign) {
#line 3182
      xp = tmp;
#line 3182
    } else {
#line 3182
      xp = (short *) *xpp;
#line 3182
    }
#line 3182
   /* copy the next block */
#line 3182
#pragma cdir loopcnt=LOOPCNT
#line 3182
#pragma cdir shortloop
#line 3182
    for (i=0; i<ni; i++) {
#line 3182
      /* the normal case: */
#line 3182
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3182
     /* test for range errors (not always needed but do it anyway) */
#line 3182
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3182
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3182
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3182
    }
#line 3182
   /* copy workspace back if necessary */
#line 3182
    if (realign) {
#line 3182
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3182
      xp = (short *) *xpp;
#line 3182
    }
#line 3182
   /* update xpp and tp */
#line 3182
    xp += ni;
#line 3182
    tp += ni;
#line 3182
    *xpp = (void*)xp;
#line 3182
  }
#line 3182
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3182

#line 3182
#else   /* not SX */
#line 3182

#line 3182
	char *xp = (char *) *xpp;
#line 3182
	int status = NC_NOERR;
#line 3182

#line 3182
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3182
	{
#line 3182
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 3182
		if (status == NC_NOERR) /* report the first encountered error */
#line 3182
			status = lstatus;
#line 3182
	}
#line 3182

#line 3182
	*xpp = (void *)xp;
#line 3182
	return status;
#line 3182
#endif
#line 3182
}
#line 3182

int
#line 3183
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3183
{
#line 3183
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3183

#line 3183
 /* basic algorithm is:
#line 3183
  *   - ensure sane alignment of output data
#line 3183
  *   - copy (conversion happens automatically) input data
#line 3183
  *     to output
#line 3183
  *   - update tp to point at next unconverted input, and xpp to point
#line 3183
  *     at next location for converted output
#line 3183
  */
#line 3183
  long i, j, ni;
#line 3183
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3183
  short *xp;
#line 3183
  int nrange = 0;         /* number of range errors */
#line 3183
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3183
  long cxp = (long) *((char**)xpp);
#line 3183

#line 3183
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3183
  /* sjl: manually stripmine so we can limit amount of
#line 3183
   * vector work space reserved to LOOPCNT elements. Also
#line 3183
   * makes vectorisation easy */
#line 3183
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3183
    ni=Min(nelems-j,LOOPCNT);
#line 3183
    if (realign) {
#line 3183
      xp = tmp;
#line 3183
    } else {
#line 3183
      xp = (short *) *xpp;
#line 3183
    }
#line 3183
   /* copy the next block */
#line 3183
#pragma cdir loopcnt=LOOPCNT
#line 3183
#pragma cdir shortloop
#line 3183
    for (i=0; i<ni; i++) {
#line 3183
      /* the normal case: */
#line 3183
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3183
     /* test for range errors (not always needed but do it anyway) */
#line 3183
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3183
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3183
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3183
    }
#line 3183
   /* copy workspace back if necessary */
#line 3183
    if (realign) {
#line 3183
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3183
      xp = (short *) *xpp;
#line 3183
    }
#line 3183
   /* update xpp and tp */
#line 3183
    xp += ni;
#line 3183
    tp += ni;
#line 3183
    *xpp = (void*)xp;
#line 3183
  }
#line 3183
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3183

#line 3183
#else   /* not SX */
#line 3183

#line 3183
	char *xp = (char *) *xpp;
#line 3183
	int status = NC_NOERR;
#line 3183

#line 3183
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3183
	{
#line 3183
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 3183
		if (status == NC_NOERR) /* report the first encountered error */
#line 3183
			status = lstatus;
#line 3183
	}
#line 3183

#line 3183
	*xpp = (void *)xp;
#line 3183
	return status;
#line 3183
#endif
#line 3183
}
#line 3183

int
#line 3184
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3184
{
#line 3184
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3184

#line 3184
 /* basic algorithm is:
#line 3184
  *   - ensure sane alignment of output data
#line 3184
  *   - copy (conversion happens automatically) input data
#line 3184
  *     to output
#line 3184
  *   - update tp to point at next unconverted input, and xpp to point
#line 3184
  *     at next location for converted output
#line 3184
  */
#line 3184
  long i, j, ni;
#line 3184
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3184
  short *xp;
#line 3184
  int nrange = 0;         /* number of range errors */
#line 3184
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3184
  long cxp = (long) *((char**)xpp);
#line 3184

#line 3184
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3184
  /* sjl: manually stripmine so we can limit amount of
#line 3184
   * vector work space reserved to LOOPCNT elements. Also
#line 3184
   * makes vectorisation easy */
#line 3184
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3184
    ni=Min(nelems-j,LOOPCNT);
#line 3184
    if (realign) {
#line 3184
      xp = tmp;
#line 3184
    } else {
#line 3184
      xp = (short *) *xpp;
#line 3184
    }
#line 3184
   /* copy the next block */
#line 3184
#pragma cdir loopcnt=LOOPCNT
#line 3184
#pragma cdir shortloop
#line 3184
    for (i=0; i<ni; i++) {
#line 3184
      /* the normal case: */
#line 3184
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3184
     /* test for range errors (not always needed but do it anyway) */
#line 3184
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3184
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3184
      nrange += tp[i] > X_SHORT_MAX ;
#line 3184
    }
#line 3184
   /* copy workspace back if necessary */
#line 3184
    if (realign) {
#line 3184
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3184
      xp = (short *) *xpp;
#line 3184
    }
#line 3184
   /* update xpp and tp */
#line 3184
    xp += ni;
#line 3184
    tp += ni;
#line 3184
    *xpp = (void*)xp;
#line 3184
  }
#line 3184
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3184

#line 3184
#else   /* not SX */
#line 3184

#line 3184
	char *xp = (char *) *xpp;
#line 3184
	int status = NC_NOERR;
#line 3184

#line 3184
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3184
	{
#line 3184
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 3184
		if (status == NC_NOERR) /* report the first encountered error */
#line 3184
			status = lstatus;
#line 3184
	}
#line 3184

#line 3184
	*xpp = (void *)xp;
#line 3184
	return status;
#line 3184
#endif
#line 3184
}
#line 3184

int
#line 3185
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3185
{
#line 3185
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3185

#line 3185
 /* basic algorithm is:
#line 3185
  *   - ensure sane alignment of output data
#line 3185
  *   - copy (conversion happens automatically) input data
#line 3185
  *     to output
#line 3185
  *   - update tp to point at next unconverted input, and xpp to point
#line 3185
  *     at next location for converted output
#line 3185
  */
#line 3185
  long i, j, ni;
#line 3185
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3185
  short *xp;
#line 3185
  int nrange = 0;         /* number of range errors */
#line 3185
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3185
  long cxp = (long) *((char**)xpp);
#line 3185

#line 3185
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3185
  /* sjl: manually stripmine so we can limit amount of
#line 3185
   * vector work space reserved to LOOPCNT elements. Also
#line 3185
   * makes vectorisation easy */
#line 3185
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3185
    ni=Min(nelems-j,LOOPCNT);
#line 3185
    if (realign) {
#line 3185
      xp = tmp;
#line 3185
    } else {
#line 3185
      xp = (short *) *xpp;
#line 3185
    }
#line 3185
   /* copy the next block */
#line 3185
#pragma cdir loopcnt=LOOPCNT
#line 3185
#pragma cdir shortloop
#line 3185
    for (i=0; i<ni; i++) {
#line 3185
      /* the normal case: */
#line 3185
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3185
     /* test for range errors (not always needed but do it anyway) */
#line 3185
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3185
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3185
      nrange += tp[i] > X_SHORT_MAX ;
#line 3185
    }
#line 3185
   /* copy workspace back if necessary */
#line 3185
    if (realign) {
#line 3185
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3185
      xp = (short *) *xpp;
#line 3185
    }
#line 3185
   /* update xpp and tp */
#line 3185
    xp += ni;
#line 3185
    tp += ni;
#line 3185
    *xpp = (void*)xp;
#line 3185
  }
#line 3185
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3185

#line 3185
#else   /* not SX */
#line 3185

#line 3185
	char *xp = (char *) *xpp;
#line 3185
	int status = NC_NOERR;
#line 3185

#line 3185
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3185
	{
#line 3185
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 3185
		if (status == NC_NOERR) /* report the first encountered error */
#line 3185
			status = lstatus;
#line 3185
	}
#line 3185

#line 3185
	*xpp = (void *)xp;
#line 3185
	return status;
#line 3185
#endif
#line 3185
}
#line 3185

int
#line 3186
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3186
{
#line 3186
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3186

#line 3186
 /* basic algorithm is:
#line 3186
  *   - ensure sane alignment of output data
#line 3186
  *   - copy (conversion happens automatically) input data
#line 3186
  *     to output
#line 3186
  *   - update tp to point at next unconverted input, and xpp to point
#line 3186
  *     at next location for converted output
#line 3186
  */
#line 3186
  long i, j, ni;
#line 3186
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3186
  short *xp;
#line 3186
  int nrange = 0;         /* number of range errors */
#line 3186
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3186
  long cxp = (long) *((char**)xpp);
#line 3186

#line 3186
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3186
  /* sjl: manually stripmine so we can limit amount of
#line 3186
   * vector work space reserved to LOOPCNT elements. Also
#line 3186
   * makes vectorisation easy */
#line 3186
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3186
    ni=Min(nelems-j,LOOPCNT);
#line 3186
    if (realign) {
#line 3186
      xp = tmp;
#line 3186
    } else {
#line 3186
      xp = (short *) *xpp;
#line 3186
    }
#line 3186
   /* copy the next block */
#line 3186
#pragma cdir loopcnt=LOOPCNT
#line 3186
#pragma cdir shortloop
#line 3186
    for (i=0; i<ni; i++) {
#line 3186
      /* the normal case: */
#line 3186
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3186
     /* test for range errors (not always needed but do it anyway) */
#line 3186
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3186
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3186
      nrange += tp[i] > X_SHORT_MAX ;
#line 3186
    }
#line 3186
   /* copy workspace back if necessary */
#line 3186
    if (realign) {
#line 3186
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3186
      xp = (short *) *xpp;
#line 3186
    }
#line 3186
   /* update xpp and tp */
#line 3186
    xp += ni;
#line 3186
    tp += ni;
#line 3186
    *xpp = (void*)xp;
#line 3186
  }
#line 3186
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3186

#line 3186
#else   /* not SX */
#line 3186

#line 3186
	char *xp = (char *) *xpp;
#line 3186
	int status = NC_NOERR;
#line 3186

#line 3186
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3186
	{
#line 3186
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 3186
		if (status == NC_NOERR) /* report the first encountered error */
#line 3186
			status = lstatus;
#line 3186
	}
#line 3186

#line 3186
	*xpp = (void *)xp;
#line 3186
	return status;
#line 3186
#endif
#line 3186
}
#line 3186

int
#line 3187
ncx_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3187
{
#line 3187
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3187

#line 3187
 /* basic algorithm is:
#line 3187
  *   - ensure sane alignment of output data
#line 3187
  *   - copy (conversion happens automatically) input data
#line 3187
  *     to output
#line 3187
  *   - update tp to point at next unconverted input, and xpp to point
#line 3187
  *     at next location for converted output
#line 3187
  */
#line 3187
  long i, j, ni;
#line 3187
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3187
  short *xp;
#line 3187
  int nrange = 0;         /* number of range errors */
#line 3187
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3187
  long cxp = (long) *((char**)xpp);
#line 3187

#line 3187
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3187
  /* sjl: manually stripmine so we can limit amount of
#line 3187
   * vector work space reserved to LOOPCNT elements. Also
#line 3187
   * makes vectorisation easy */
#line 3187
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3187
    ni=Min(nelems-j,LOOPCNT);
#line 3187
    if (realign) {
#line 3187
      xp = tmp;
#line 3187
    } else {
#line 3187
      xp = (short *) *xpp;
#line 3187
    }
#line 3187
   /* copy the next block */
#line 3187
#pragma cdir loopcnt=LOOPCNT
#line 3187
#pragma cdir shortloop
#line 3187
    for (i=0; i<ni; i++) {
#line 3187
      /* the normal case: */
#line 3187
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3187
     /* test for range errors (not always needed but do it anyway) */
#line 3187
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3187
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3187
      nrange += tp[i] > X_SHORT_MAX ;
#line 3187
    }
#line 3187
   /* copy workspace back if necessary */
#line 3187
    if (realign) {
#line 3187
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3187
      xp = (short *) *xpp;
#line 3187
    }
#line 3187
   /* update xpp and tp */
#line 3187
    xp += ni;
#line 3187
    tp += ni;
#line 3187
    *xpp = (void*)xp;
#line 3187
  }
#line 3187
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3187

#line 3187
#else   /* not SX */
#line 3187

#line 3187
	char *xp = (char *) *xpp;
#line 3187
	int status = NC_NOERR;
#line 3187

#line 3187
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3187
	{
#line 3187
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 3187
		if (status == NC_NOERR) /* report the first encountered error */
#line 3187
			status = lstatus;
#line 3187
	}
#line 3187

#line 3187
	*xpp = (void *)xp;
#line 3187
	return status;
#line 3187
#endif
#line 3187
}
#line 3187


int
#line 3189
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3189
{
#line 3189
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3189

#line 3189
	char *xp = (char *) *xpp;
#line 3189
	int status = NC_NOERR;
#line 3189

#line 3189
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3189
	{
#line 3189
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 3189
		if (status == NC_NOERR) /* report the first encountered error */
#line 3189
			status = lstatus;
#line 3189
	}
#line 3189

#line 3189
	if (rndup != 0)
#line 3189
	{
#line 3189
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3189
		xp += X_SIZEOF_SHORT;
#line 3189
	}
#line 3189

#line 3189
	*xpp = (void *)xp;
#line 3189
	return status;
#line 3189
}
#line 3189

int
#line 3190
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3190
{
#line 3190
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3190

#line 3190
	char *xp = (char *) *xpp;
#line 3190
	int status = NC_NOERR;
#line 3190

#line 3190
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3190
	{
#line 3190
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 3190
		if (status == NC_NOERR) /* report the first encountered error */
#line 3190
			status = lstatus;
#line 3190
	}
#line 3190

#line 3190
	if (rndup != 0)
#line 3190
	{
#line 3190
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3190
		xp += X_SIZEOF_SHORT;
#line 3190
	}
#line 3190

#line 3190
	*xpp = (void *)xp;
#line 3190
	return status;
#line 3190
}
#line 3190

int
#line 3191
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3191
{
#line 3191
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3191

#line 3191
	char *xp = (char *) *xpp;
#line 3191
	int status = NC_NOERR;
#line 3191

#line 3191
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3191
	{
#line 3191
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 3191
		if (status == NC_NOERR) /* report the first encountered error */
#line 3191
			status = lstatus;
#line 3191
	}
#line 3191

#line 3191
	if (rndup != 0)
#line 3191
	{
#line 3191
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3191
		xp += X_SIZEOF_SHORT;
#line 3191
	}
#line 3191

#line 3191
	*xpp = (void *)xp;
#line 3191
	return status;
#line 3191
}
#line 3191

int
#line 3192
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3192
{
#line 3192
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3192

#line 3192
	char *xp = (char *) *xpp;
#line 3192
	int status = NC_NOERR;
#line 3192

#line 3192
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3192
	{
#line 3192
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 3192
		if (status == NC_NOERR) /* report the first encountered error */
#line 3192
			status = lstatus;
#line 3192
	}
#line 3192

#line 3192
	if (rndup != 0)
#line 3192
	{
#line 3192
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3192
		xp += X_SIZEOF_SHORT;
#line 3192
	}
#line 3192

#line 3192
	*xpp = (void *)xp;
#line 3192
	return status;
#line 3192
}
#line 3192

int
#line 3193
ncx_pad_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3193
{
#line 3193
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3193

#line 3193
	char *xp = (char *) *xpp;
#line 3193
	int status = NC_NOERR;
#line 3193

#line 3193
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3193
	{
#line 3193
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 3193
		if (status == NC_NOERR) /* report the first encountered error */
#line 3193
			status = lstatus;
#line 3193
	}
#line 3193

#line 3193
	if (rndup != 0)
#line 3193
	{
#line 3193
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3193
		xp += X_SIZEOF_SHORT;
#line 3193
	}
#line 3193

#line 3193
	*xpp = (void *)xp;
#line 3193
	return status;
#line 3193
}
#line 3193

int
#line 3194
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3194
{
#line 3194
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3194

#line 3194
	char *xp = (char *) *xpp;
#line 3194
	int status = NC_NOERR;
#line 3194

#line 3194
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3194
	{
#line 3194
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 3194
		if (status == NC_NOERR) /* report the first encountered error */
#line 3194
			status = lstatus;
#line 3194
	}
#line 3194

#line 3194
	if (rndup != 0)
#line 3194
	{
#line 3194
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3194
		xp += X_SIZEOF_SHORT;
#line 3194
	}
#line 3194

#line 3194
	*xpp = (void *)xp;
#line 3194
	return status;
#line 3194
}
#line 3194

int
#line 3195
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3195
{
#line 3195
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3195

#line 3195
	char *xp = (char *) *xpp;
#line 3195
	int status = NC_NOERR;
#line 3195

#line 3195
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3195
	{
#line 3195
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 3195
		if (status == NC_NOERR) /* report the first encountered error */
#line 3195
			status = lstatus;
#line 3195
	}
#line 3195

#line 3195
	if (rndup != 0)
#line 3195
	{
#line 3195
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3195
		xp += X_SIZEOF_SHORT;
#line 3195
	}
#line 3195

#line 3195
	*xpp = (void *)xp;
#line 3195
	return status;
#line 3195
}
#line 3195

int
#line 3196
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3196
{
#line 3196
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3196

#line 3196
	char *xp = (char *) *xpp;
#line 3196
	int status = NC_NOERR;
#line 3196

#line 3196
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3196
	{
#line 3196
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 3196
		if (status == NC_NOERR) /* report the first encountered error */
#line 3196
			status = lstatus;
#line 3196
	}
#line 3196

#line 3196
	if (rndup != 0)
#line 3196
	{
#line 3196
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3196
		xp += X_SIZEOF_SHORT;
#line 3196
	}
#line 3196

#line 3196
	*xpp = (void *)xp;
#line 3196
	return status;
#line 3196
}
#line 3196

int
#line 3197
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3197
{
#line 3197
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3197

#line 3197
	char *xp = (char *) *xpp;
#line 3197
	int status = NC_NOERR;
#line 3197

#line 3197
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3197
	{
#line 3197
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 3197
		if (status == NC_NOERR) /* report the first encountered error */
#line 3197
			status = lstatus;
#line 3197
	}
#line 3197

#line 3197
	if (rndup != 0)
#line 3197
	{
#line 3197
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3197
		xp += X_SIZEOF_SHORT;
#line 3197
	}
#line 3197

#line 3197
	*xpp = (void *)xp;
#line 3197
	return status;
#line 3197
}
#line 3197

int
#line 3198
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3198
{
#line 3198
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3198

#line 3198
	char *xp = (char *) *xpp;
#line 3198
	int status = NC_NOERR;
#line 3198

#line 3198
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3198
	{
#line 3198
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 3198
		if (status == NC_NOERR) /* report the first encountered error */
#line 3198
			status = lstatus;
#line 3198
	}
#line 3198

#line 3198
	if (rndup != 0)
#line 3198
	{
#line 3198
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3198
		xp += X_SIZEOF_SHORT;
#line 3198
	}
#line 3198

#line 3198
	*xpp = (void *)xp;
#line 3198
	return status;
#line 3198
}
#line 3198

int
#line 3199
ncx_pad_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3199
{
#line 3199
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3199

#line 3199
	char *xp = (char *) *xpp;
#line 3199
	int status = NC_NOERR;
#line 3199

#line 3199
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3199
	{
#line 3199
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 3199
		if (status == NC_NOERR) /* report the first encountered error */
#line 3199
			status = lstatus;
#line 3199
	}
#line 3199

#line 3199
	if (rndup != 0)
#line 3199
	{
#line 3199
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3199
		xp += X_SIZEOF_SHORT;
#line 3199
	}
#line 3199

#line 3199
	*xpp = (void *)xp;
#line 3199
	return status;
#line 3199
}
#line 3199



/* ushort --------------------------------------------------------------------*/

#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_USHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3218
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3218
{
#line 3218
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3218

#line 3218
 /* basic algorithm is:
#line 3218
  *   - ensure sane alignment of input data
#line 3218
  *   - copy (conversion happens automatically) input data
#line 3218
  *     to output
#line 3218
  *   - update xpp to point at next unconverted input, and tp to point
#line 3218
  *     at next location for converted output
#line 3218
  */
#line 3218
  long i, j, ni;
#line 3218
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3218
  ushort *xp;
#line 3218
  int nrange = 0;         /* number of range errors */
#line 3218
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3218
  long cxp = (long) *((char**)xpp);
#line 3218

#line 3218
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3218
  /* sjl: manually stripmine so we can limit amount of
#line 3218
   * vector work space reserved to LOOPCNT elements. Also
#line 3218
   * makes vectorisation easy */
#line 3218
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3218
    ni=Min(nelems-j,LOOPCNT);
#line 3218
    if (realign) {
#line 3218
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3218
      xp = tmp;
#line 3218
    } else {
#line 3218
      xp = (ushort *) *xpp;
#line 3218
    }
#line 3218
   /* copy the next block */
#line 3218
#pragma cdir loopcnt=LOOPCNT
#line 3218
#pragma cdir shortloop
#line 3218
    for (i=0; i<ni; i++) {
#line 3218
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3218
     /* test for range errors (not always needed but do it anyway) */
#line 3218
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3218
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3218
      nrange += xp[i] > USHORT_MAX ;
#line 3218
    }
#line 3218
   /* update xpp and tp */
#line 3218
    if (realign) xp = (ushort *) *xpp;
#line 3218
    xp += ni;
#line 3218
    tp += ni;
#line 3218
    *xpp = (void*)xp;
#line 3218
  }
#line 3218
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3218

#line 3218
#else   /* not SX */
#line 3218
	const char *xp = (const char *) *xpp;
#line 3218
	int status = NC_NOERR;
#line 3218

#line 3218
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3218
	{
#line 3218
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3218
		if (status == NC_NOERR) /* report the first encountered error */
#line 3218
			status = lstatus;
#line 3218
	}
#line 3218

#line 3218
	*xpp = (const void *)xp;
#line 3218
	return status;
#line 3218
#endif
#line 3218
}
#line 3218

#endif
int
#line 3220
ncx_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3220
{
#line 3220
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3220

#line 3220
 /* basic algorithm is:
#line 3220
  *   - ensure sane alignment of input data
#line 3220
  *   - copy (conversion happens automatically) input data
#line 3220
  *     to output
#line 3220
  *   - update xpp to point at next unconverted input, and tp to point
#line 3220
  *     at next location for converted output
#line 3220
  */
#line 3220
  long i, j, ni;
#line 3220
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3220
  ushort *xp;
#line 3220
  int nrange = 0;         /* number of range errors */
#line 3220
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3220
  long cxp = (long) *((char**)xpp);
#line 3220

#line 3220
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3220
  /* sjl: manually stripmine so we can limit amount of
#line 3220
   * vector work space reserved to LOOPCNT elements. Also
#line 3220
   * makes vectorisation easy */
#line 3220
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3220
    ni=Min(nelems-j,LOOPCNT);
#line 3220
    if (realign) {
#line 3220
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3220
      xp = tmp;
#line 3220
    } else {
#line 3220
      xp = (ushort *) *xpp;
#line 3220
    }
#line 3220
   /* copy the next block */
#line 3220
#pragma cdir loopcnt=LOOPCNT
#line 3220
#pragma cdir shortloop
#line 3220
    for (i=0; i<ni; i++) {
#line 3220
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3220
     /* test for range errors (not always needed but do it anyway) */
#line 3220
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3220
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3220
      nrange += xp[i] > SCHAR_MAX ;
#line 3220
    }
#line 3220
   /* update xpp and tp */
#line 3220
    if (realign) xp = (ushort *) *xpp;
#line 3220
    xp += ni;
#line 3220
    tp += ni;
#line 3220
    *xpp = (void*)xp;
#line 3220
  }
#line 3220
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3220

#line 3220
#else   /* not SX */
#line 3220
	const char *xp = (const char *) *xpp;
#line 3220
	int status = NC_NOERR;
#line 3220

#line 3220
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3220
	{
#line 3220
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3220
		if (status == NC_NOERR) /* report the first encountered error */
#line 3220
			status = lstatus;
#line 3220
	}
#line 3220

#line 3220
	*xpp = (const void *)xp;
#line 3220
	return status;
#line 3220
#endif
#line 3220
}
#line 3220

int
#line 3221
ncx_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3221
{
#line 3221
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3221

#line 3221
 /* basic algorithm is:
#line 3221
  *   - ensure sane alignment of input data
#line 3221
  *   - copy (conversion happens automatically) input data
#line 3221
  *     to output
#line 3221
  *   - update xpp to point at next unconverted input, and tp to point
#line 3221
  *     at next location for converted output
#line 3221
  */
#line 3221
  long i, j, ni;
#line 3221
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3221
  ushort *xp;
#line 3221
  int nrange = 0;         /* number of range errors */
#line 3221
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3221
  long cxp = (long) *((char**)xpp);
#line 3221

#line 3221
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3221
  /* sjl: manually stripmine so we can limit amount of
#line 3221
   * vector work space reserved to LOOPCNT elements. Also
#line 3221
   * makes vectorisation easy */
#line 3221
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3221
    ni=Min(nelems-j,LOOPCNT);
#line 3221
    if (realign) {
#line 3221
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3221
      xp = tmp;
#line 3221
    } else {
#line 3221
      xp = (ushort *) *xpp;
#line 3221
    }
#line 3221
   /* copy the next block */
#line 3221
#pragma cdir loopcnt=LOOPCNT
#line 3221
#pragma cdir shortloop
#line 3221
    for (i=0; i<ni; i++) {
#line 3221
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3221
     /* test for range errors (not always needed but do it anyway) */
#line 3221
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3221
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3221
      nrange += xp[i] > SHORT_MAX ;
#line 3221
    }
#line 3221
   /* update xpp and tp */
#line 3221
    if (realign) xp = (ushort *) *xpp;
#line 3221
    xp += ni;
#line 3221
    tp += ni;
#line 3221
    *xpp = (void*)xp;
#line 3221
  }
#line 3221
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3221

#line 3221
#else   /* not SX */
#line 3221
	const char *xp = (const char *) *xpp;
#line 3221
	int status = NC_NOERR;
#line 3221

#line 3221
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3221
	{
#line 3221
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3221
		if (status == NC_NOERR) /* report the first encountered error */
#line 3221
			status = lstatus;
#line 3221
	}
#line 3221

#line 3221
	*xpp = (const void *)xp;
#line 3221
	return status;
#line 3221
#endif
#line 3221
}
#line 3221

int
#line 3222
ncx_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3222
{
#line 3222
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3222

#line 3222
 /* basic algorithm is:
#line 3222
  *   - ensure sane alignment of input data
#line 3222
  *   - copy (conversion happens automatically) input data
#line 3222
  *     to output
#line 3222
  *   - update xpp to point at next unconverted input, and tp to point
#line 3222
  *     at next location for converted output
#line 3222
  */
#line 3222
  long i, j, ni;
#line 3222
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3222
  ushort *xp;
#line 3222
  int nrange = 0;         /* number of range errors */
#line 3222
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3222
  long cxp = (long) *((char**)xpp);
#line 3222

#line 3222
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3222
  /* sjl: manually stripmine so we can limit amount of
#line 3222
   * vector work space reserved to LOOPCNT elements. Also
#line 3222
   * makes vectorisation easy */
#line 3222
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3222
    ni=Min(nelems-j,LOOPCNT);
#line 3222
    if (realign) {
#line 3222
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3222
      xp = tmp;
#line 3222
    } else {
#line 3222
      xp = (ushort *) *xpp;
#line 3222
    }
#line 3222
   /* copy the next block */
#line 3222
#pragma cdir loopcnt=LOOPCNT
#line 3222
#pragma cdir shortloop
#line 3222
    for (i=0; i<ni; i++) {
#line 3222
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3222
     /* test for range errors (not always needed but do it anyway) */
#line 3222
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3222
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3222
      nrange += xp[i] > INT_MAX ;
#line 3222
    }
#line 3222
   /* update xpp and tp */
#line 3222
    if (realign) xp = (ushort *) *xpp;
#line 3222
    xp += ni;
#line 3222
    tp += ni;
#line 3222
    *xpp = (void*)xp;
#line 3222
  }
#line 3222
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3222

#line 3222
#else   /* not SX */
#line 3222
	const char *xp = (const char *) *xpp;
#line 3222
	int status = NC_NOERR;
#line 3222

#line 3222
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3222
	{
#line 3222
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3222
		if (status == NC_NOERR) /* report the first encountered error */
#line 3222
			status = lstatus;
#line 3222
	}
#line 3222

#line 3222
	*xpp = (const void *)xp;
#line 3222
	return status;
#line 3222
#endif
#line 3222
}
#line 3222

int
#line 3223
ncx_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3223
{
#line 3223
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3223

#line 3223
 /* basic algorithm is:
#line 3223
  *   - ensure sane alignment of input data
#line 3223
  *   - copy (conversion happens automatically) input data
#line 3223
  *     to output
#line 3223
  *   - update xpp to point at next unconverted input, and tp to point
#line 3223
  *     at next location for converted output
#line 3223
  */
#line 3223
  long i, j, ni;
#line 3223
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3223
  ushort *xp;
#line 3223
  int nrange = 0;         /* number of range errors */
#line 3223
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3223
  long cxp = (long) *((char**)xpp);
#line 3223

#line 3223
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3223
  /* sjl: manually stripmine so we can limit amount of
#line 3223
   * vector work space reserved to LOOPCNT elements. Also
#line 3223
   * makes vectorisation easy */
#line 3223
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3223
    ni=Min(nelems-j,LOOPCNT);
#line 3223
    if (realign) {
#line 3223
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3223
      xp = tmp;
#line 3223
    } else {
#line 3223
      xp = (ushort *) *xpp;
#line 3223
    }
#line 3223
   /* copy the next block */
#line 3223
#pragma cdir loopcnt=LOOPCNT
#line 3223
#pragma cdir shortloop
#line 3223
    for (i=0; i<ni; i++) {
#line 3223
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3223
     /* test for range errors (not always needed but do it anyway) */
#line 3223
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3223
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3223
      nrange += xp[i] > LONG_MAX ;
#line 3223
    }
#line 3223
   /* update xpp and tp */
#line 3223
    if (realign) xp = (ushort *) *xpp;
#line 3223
    xp += ni;
#line 3223
    tp += ni;
#line 3223
    *xpp = (void*)xp;
#line 3223
  }
#line 3223
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3223

#line 3223
#else   /* not SX */
#line 3223
	const char *xp = (const char *) *xpp;
#line 3223
	int status = NC_NOERR;
#line 3223

#line 3223
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3223
	{
#line 3223
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3223
		if (status == NC_NOERR) /* report the first encountered error */
#line 3223
			status = lstatus;
#line 3223
	}
#line 3223

#line 3223
	*xpp = (const void *)xp;
#line 3223
	return status;
#line 3223
#endif
#line 3223
}
#line 3223

int
#line 3224
ncx_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3224
{
#line 3224
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3224

#line 3224
 /* basic algorithm is:
#line 3224
  *   - ensure sane alignment of input data
#line 3224
  *   - copy (conversion happens automatically) input data
#line 3224
  *     to output
#line 3224
  *   - update xpp to point at next unconverted input, and tp to point
#line 3224
  *     at next location for converted output
#line 3224
  */
#line 3224
  long i, j, ni;
#line 3224
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3224
  ushort *xp;
#line 3224
  int nrange = 0;         /* number of range errors */
#line 3224
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3224
  long cxp = (long) *((char**)xpp);
#line 3224

#line 3224
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3224
  /* sjl: manually stripmine so we can limit amount of
#line 3224
   * vector work space reserved to LOOPCNT elements. Also
#line 3224
   * makes vectorisation easy */
#line 3224
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3224
    ni=Min(nelems-j,LOOPCNT);
#line 3224
    if (realign) {
#line 3224
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3224
      xp = tmp;
#line 3224
    } else {
#line 3224
      xp = (ushort *) *xpp;
#line 3224
    }
#line 3224
   /* copy the next block */
#line 3224
#pragma cdir loopcnt=LOOPCNT
#line 3224
#pragma cdir shortloop
#line 3224
    for (i=0; i<ni; i++) {
#line 3224
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3224
     /* test for range errors (not always needed but do it anyway) */
#line 3224
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3224
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3224
      nrange += xp[i] > FLOAT_MAX ;
#line 3224
    }
#line 3224
   /* update xpp and tp */
#line 3224
    if (realign) xp = (ushort *) *xpp;
#line 3224
    xp += ni;
#line 3224
    tp += ni;
#line 3224
    *xpp = (void*)xp;
#line 3224
  }
#line 3224
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3224

#line 3224
#else   /* not SX */
#line 3224
	const char *xp = (const char *) *xpp;
#line 3224
	int status = NC_NOERR;
#line 3224

#line 3224
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3224
	{
#line 3224
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3224
		if (status == NC_NOERR) /* report the first encountered error */
#line 3224
			status = lstatus;
#line 3224
	}
#line 3224

#line 3224
	*xpp = (const void *)xp;
#line 3224
	return status;
#line 3224
#endif
#line 3224
}
#line 3224

int
#line 3225
ncx_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3225
{
#line 3225
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3225

#line 3225
 /* basic algorithm is:
#line 3225
  *   - ensure sane alignment of input data
#line 3225
  *   - copy (conversion happens automatically) input data
#line 3225
  *     to output
#line 3225
  *   - update xpp to point at next unconverted input, and tp to point
#line 3225
  *     at next location for converted output
#line 3225
  */
#line 3225
  long i, j, ni;
#line 3225
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3225
  ushort *xp;
#line 3225
  int nrange = 0;         /* number of range errors */
#line 3225
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3225
  long cxp = (long) *((char**)xpp);
#line 3225

#line 3225
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3225
  /* sjl: manually stripmine so we can limit amount of
#line 3225
   * vector work space reserved to LOOPCNT elements. Also
#line 3225
   * makes vectorisation easy */
#line 3225
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3225
    ni=Min(nelems-j,LOOPCNT);
#line 3225
    if (realign) {
#line 3225
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3225
      xp = tmp;
#line 3225
    } else {
#line 3225
      xp = (ushort *) *xpp;
#line 3225
    }
#line 3225
   /* copy the next block */
#line 3225
#pragma cdir loopcnt=LOOPCNT
#line 3225
#pragma cdir shortloop
#line 3225
    for (i=0; i<ni; i++) {
#line 3225
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3225
     /* test for range errors (not always needed but do it anyway) */
#line 3225
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3225
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3225
      nrange += xp[i] > DOUBLE_MAX ;
#line 3225
    }
#line 3225
   /* update xpp and tp */
#line 3225
    if (realign) xp = (ushort *) *xpp;
#line 3225
    xp += ni;
#line 3225
    tp += ni;
#line 3225
    *xpp = (void*)xp;
#line 3225
  }
#line 3225
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3225

#line 3225
#else   /* not SX */
#line 3225
	const char *xp = (const char *) *xpp;
#line 3225
	int status = NC_NOERR;
#line 3225

#line 3225
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3225
	{
#line 3225
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3225
		if (status == NC_NOERR) /* report the first encountered error */
#line 3225
			status = lstatus;
#line 3225
	}
#line 3225

#line 3225
	*xpp = (const void *)xp;
#line 3225
	return status;
#line 3225
#endif
#line 3225
}
#line 3225

int
#line 3226
ncx_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3226
{
#line 3226
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3226

#line 3226
 /* basic algorithm is:
#line 3226
  *   - ensure sane alignment of input data
#line 3226
  *   - copy (conversion happens automatically) input data
#line 3226
  *     to output
#line 3226
  *   - update xpp to point at next unconverted input, and tp to point
#line 3226
  *     at next location for converted output
#line 3226
  */
#line 3226
  long i, j, ni;
#line 3226
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3226
  ushort *xp;
#line 3226
  int nrange = 0;         /* number of range errors */
#line 3226
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3226
  long cxp = (long) *((char**)xpp);
#line 3226

#line 3226
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3226
  /* sjl: manually stripmine so we can limit amount of
#line 3226
   * vector work space reserved to LOOPCNT elements. Also
#line 3226
   * makes vectorisation easy */
#line 3226
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3226
    ni=Min(nelems-j,LOOPCNT);
#line 3226
    if (realign) {
#line 3226
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3226
      xp = tmp;
#line 3226
    } else {
#line 3226
      xp = (ushort *) *xpp;
#line 3226
    }
#line 3226
   /* copy the next block */
#line 3226
#pragma cdir loopcnt=LOOPCNT
#line 3226
#pragma cdir shortloop
#line 3226
    for (i=0; i<ni; i++) {
#line 3226
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3226
     /* test for range errors (not always needed but do it anyway) */
#line 3226
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3226
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3226
      nrange += xp[i] > LONGLONG_MAX ;
#line 3226
    }
#line 3226
   /* update xpp and tp */
#line 3226
    if (realign) xp = (ushort *) *xpp;
#line 3226
    xp += ni;
#line 3226
    tp += ni;
#line 3226
    *xpp = (void*)xp;
#line 3226
  }
#line 3226
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3226

#line 3226
#else   /* not SX */
#line 3226
	const char *xp = (const char *) *xpp;
#line 3226
	int status = NC_NOERR;
#line 3226

#line 3226
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3226
	{
#line 3226
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3226
		if (status == NC_NOERR) /* report the first encountered error */
#line 3226
			status = lstatus;
#line 3226
	}
#line 3226

#line 3226
	*xpp = (const void *)xp;
#line 3226
	return status;
#line 3226
#endif
#line 3226
}
#line 3226

int
#line 3227
ncx_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3227
{
#line 3227
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3227

#line 3227
 /* basic algorithm is:
#line 3227
  *   - ensure sane alignment of input data
#line 3227
  *   - copy (conversion happens automatically) input data
#line 3227
  *     to output
#line 3227
  *   - update xpp to point at next unconverted input, and tp to point
#line 3227
  *     at next location for converted output
#line 3227
  */
#line 3227
  long i, j, ni;
#line 3227
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3227
  ushort *xp;
#line 3227
  int nrange = 0;         /* number of range errors */
#line 3227
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3227
  long cxp = (long) *((char**)xpp);
#line 3227

#line 3227
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3227
  /* sjl: manually stripmine so we can limit amount of
#line 3227
   * vector work space reserved to LOOPCNT elements. Also
#line 3227
   * makes vectorisation easy */
#line 3227
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3227
    ni=Min(nelems-j,LOOPCNT);
#line 3227
    if (realign) {
#line 3227
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3227
      xp = tmp;
#line 3227
    } else {
#line 3227
      xp = (ushort *) *xpp;
#line 3227
    }
#line 3227
   /* copy the next block */
#line 3227
#pragma cdir loopcnt=LOOPCNT
#line 3227
#pragma cdir shortloop
#line 3227
    for (i=0; i<ni; i++) {
#line 3227
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3227
     /* test for range errors (not always needed but do it anyway) */
#line 3227
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3227
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3227
      nrange += xp[i] > UCHAR_MAX ;
#line 3227
    }
#line 3227
   /* update xpp and tp */
#line 3227
    if (realign) xp = (ushort *) *xpp;
#line 3227
    xp += ni;
#line 3227
    tp += ni;
#line 3227
    *xpp = (void*)xp;
#line 3227
  }
#line 3227
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3227

#line 3227
#else   /* not SX */
#line 3227
	const char *xp = (const char *) *xpp;
#line 3227
	int status = NC_NOERR;
#line 3227

#line 3227
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3227
	{
#line 3227
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3227
		if (status == NC_NOERR) /* report the first encountered error */
#line 3227
			status = lstatus;
#line 3227
	}
#line 3227

#line 3227
	*xpp = (const void *)xp;
#line 3227
	return status;
#line 3227
#endif
#line 3227
}
#line 3227

int
#line 3228
ncx_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3228
{
#line 3228
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3228

#line 3228
 /* basic algorithm is:
#line 3228
  *   - ensure sane alignment of input data
#line 3228
  *   - copy (conversion happens automatically) input data
#line 3228
  *     to output
#line 3228
  *   - update xpp to point at next unconverted input, and tp to point
#line 3228
  *     at next location for converted output
#line 3228
  */
#line 3228
  long i, j, ni;
#line 3228
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3228
  ushort *xp;
#line 3228
  int nrange = 0;         /* number of range errors */
#line 3228
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3228
  long cxp = (long) *((char**)xpp);
#line 3228

#line 3228
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3228
  /* sjl: manually stripmine so we can limit amount of
#line 3228
   * vector work space reserved to LOOPCNT elements. Also
#line 3228
   * makes vectorisation easy */
#line 3228
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3228
    ni=Min(nelems-j,LOOPCNT);
#line 3228
    if (realign) {
#line 3228
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3228
      xp = tmp;
#line 3228
    } else {
#line 3228
      xp = (ushort *) *xpp;
#line 3228
    }
#line 3228
   /* copy the next block */
#line 3228
#pragma cdir loopcnt=LOOPCNT
#line 3228
#pragma cdir shortloop
#line 3228
    for (i=0; i<ni; i++) {
#line 3228
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3228
     /* test for range errors (not always needed but do it anyway) */
#line 3228
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3228
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3228
      nrange += xp[i] > UINT_MAX ;
#line 3228
    }
#line 3228
   /* update xpp and tp */
#line 3228
    if (realign) xp = (ushort *) *xpp;
#line 3228
    xp += ni;
#line 3228
    tp += ni;
#line 3228
    *xpp = (void*)xp;
#line 3228
  }
#line 3228
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3228

#line 3228
#else   /* not SX */
#line 3228
	const char *xp = (const char *) *xpp;
#line 3228
	int status = NC_NOERR;
#line 3228

#line 3228
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3228
	{
#line 3228
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3228
		if (status == NC_NOERR) /* report the first encountered error */
#line 3228
			status = lstatus;
#line 3228
	}
#line 3228

#line 3228
	*xpp = (const void *)xp;
#line 3228
	return status;
#line 3228
#endif
#line 3228
}
#line 3228

int
#line 3229
ncx_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3229
{
#line 3229
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3229

#line 3229
 /* basic algorithm is:
#line 3229
  *   - ensure sane alignment of input data
#line 3229
  *   - copy (conversion happens automatically) input data
#line 3229
  *     to output
#line 3229
  *   - update xpp to point at next unconverted input, and tp to point
#line 3229
  *     at next location for converted output
#line 3229
  */
#line 3229
  long i, j, ni;
#line 3229
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3229
  ushort *xp;
#line 3229
  int nrange = 0;         /* number of range errors */
#line 3229
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3229
  long cxp = (long) *((char**)xpp);
#line 3229

#line 3229
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3229
  /* sjl: manually stripmine so we can limit amount of
#line 3229
   * vector work space reserved to LOOPCNT elements. Also
#line 3229
   * makes vectorisation easy */
#line 3229
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3229
    ni=Min(nelems-j,LOOPCNT);
#line 3229
    if (realign) {
#line 3229
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3229
      xp = tmp;
#line 3229
    } else {
#line 3229
      xp = (ushort *) *xpp;
#line 3229
    }
#line 3229
   /* copy the next block */
#line 3229
#pragma cdir loopcnt=LOOPCNT
#line 3229
#pragma cdir shortloop
#line 3229
    for (i=0; i<ni; i++) {
#line 3229
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3229
     /* test for range errors (not always needed but do it anyway) */
#line 3229
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3229
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3229
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3229
    }
#line 3229
   /* update xpp and tp */
#line 3229
    if (realign) xp = (ushort *) *xpp;
#line 3229
    xp += ni;
#line 3229
    tp += ni;
#line 3229
    *xpp = (void*)xp;
#line 3229
  }
#line 3229
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3229

#line 3229
#else   /* not SX */
#line 3229
	const char *xp = (const char *) *xpp;
#line 3229
	int status = NC_NOERR;
#line 3229

#line 3229
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3229
	{
#line 3229
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3229
		if (status == NC_NOERR) /* report the first encountered error */
#line 3229
			status = lstatus;
#line 3229
	}
#line 3229

#line 3229
	*xpp = (const void *)xp;
#line 3229
	return status;
#line 3229
#endif
#line 3229
}
#line 3229


int
#line 3231
ncx_pad_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3231
{
#line 3231
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3231

#line 3231
	const char *xp = (const char *) *xpp;
#line 3231
	int status = NC_NOERR;
#line 3231

#line 3231
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3231
	{
#line 3231
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3231
		if (status == NC_NOERR) /* report the first encountered error */
#line 3231
			status = lstatus;
#line 3231
	}
#line 3231

#line 3231
	if (rndup != 0)
#line 3231
		xp += X_SIZEOF_USHORT;
#line 3231

#line 3231
	*xpp = (void *)xp;
#line 3231
	return status;
#line 3231
}
#line 3231

int
#line 3232
ncx_pad_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3232
{
#line 3232
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3232

#line 3232
	const char *xp = (const char *) *xpp;
#line 3232
	int status = NC_NOERR;
#line 3232

#line 3232
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3232
	{
#line 3232
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3232
		if (status == NC_NOERR) /* report the first encountered error */
#line 3232
			status = lstatus;
#line 3232
	}
#line 3232

#line 3232
	if (rndup != 0)
#line 3232
		xp += X_SIZEOF_USHORT;
#line 3232

#line 3232
	*xpp = (void *)xp;
#line 3232
	return status;
#line 3232
}
#line 3232

int
#line 3233
ncx_pad_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3233
{
#line 3233
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3233

#line 3233
	const char *xp = (const char *) *xpp;
#line 3233
	int status = NC_NOERR;
#line 3233

#line 3233
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3233
	{
#line 3233
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3233
		if (status == NC_NOERR) /* report the first encountered error */
#line 3233
			status = lstatus;
#line 3233
	}
#line 3233

#line 3233
	if (rndup != 0)
#line 3233
		xp += X_SIZEOF_USHORT;
#line 3233

#line 3233
	*xpp = (void *)xp;
#line 3233
	return status;
#line 3233
}
#line 3233

int
#line 3234
ncx_pad_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3234
{
#line 3234
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3234

#line 3234
	const char *xp = (const char *) *xpp;
#line 3234
	int status = NC_NOERR;
#line 3234

#line 3234
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3234
	{
#line 3234
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3234
		if (status == NC_NOERR) /* report the first encountered error */
#line 3234
			status = lstatus;
#line 3234
	}
#line 3234

#line 3234
	if (rndup != 0)
#line 3234
		xp += X_SIZEOF_USHORT;
#line 3234

#line 3234
	*xpp = (void *)xp;
#line 3234
	return status;
#line 3234
}
#line 3234

int
#line 3235
ncx_pad_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3235
{
#line 3235
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3235

#line 3235
	const char *xp = (const char *) *xpp;
#line 3235
	int status = NC_NOERR;
#line 3235

#line 3235
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3235
	{
#line 3235
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3235
		if (status == NC_NOERR) /* report the first encountered error */
#line 3235
			status = lstatus;
#line 3235
	}
#line 3235

#line 3235
	if (rndup != 0)
#line 3235
		xp += X_SIZEOF_USHORT;
#line 3235

#line 3235
	*xpp = (void *)xp;
#line 3235
	return status;
#line 3235
}
#line 3235

int
#line 3236
ncx_pad_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3236
{
#line 3236
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3236

#line 3236
	const char *xp = (const char *) *xpp;
#line 3236
	int status = NC_NOERR;
#line 3236

#line 3236
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3236
	{
#line 3236
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3236
		if (status == NC_NOERR) /* report the first encountered error */
#line 3236
			status = lstatus;
#line 3236
	}
#line 3236

#line 3236
	if (rndup != 0)
#line 3236
		xp += X_SIZEOF_USHORT;
#line 3236

#line 3236
	*xpp = (void *)xp;
#line 3236
	return status;
#line 3236
}
#line 3236

int
#line 3237
ncx_pad_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3237
{
#line 3237
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3237

#line 3237
	const char *xp = (const char *) *xpp;
#line 3237
	int status = NC_NOERR;
#line 3237

#line 3237
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3237
	{
#line 3237
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3237
		if (status == NC_NOERR) /* report the first encountered error */
#line 3237
			status = lstatus;
#line 3237
	}
#line 3237

#line 3237
	if (rndup != 0)
#line 3237
		xp += X_SIZEOF_USHORT;
#line 3237

#line 3237
	*xpp = (void *)xp;
#line 3237
	return status;
#line 3237
}
#line 3237

int
#line 3238
ncx_pad_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3238
{
#line 3238
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3238

#line 3238
	const char *xp = (const char *) *xpp;
#line 3238
	int status = NC_NOERR;
#line 3238

#line 3238
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3238
	{
#line 3238
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3238
		if (status == NC_NOERR) /* report the first encountered error */
#line 3238
			status = lstatus;
#line 3238
	}
#line 3238

#line 3238
	if (rndup != 0)
#line 3238
		xp += X_SIZEOF_USHORT;
#line 3238

#line 3238
	*xpp = (void *)xp;
#line 3238
	return status;
#line 3238
}
#line 3238

int
#line 3239
ncx_pad_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3239
{
#line 3239
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3239

#line 3239
	const char *xp = (const char *) *xpp;
#line 3239
	int status = NC_NOERR;
#line 3239

#line 3239
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3239
	{
#line 3239
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3239
		if (status == NC_NOERR) /* report the first encountered error */
#line 3239
			status = lstatus;
#line 3239
	}
#line 3239

#line 3239
	if (rndup != 0)
#line 3239
		xp += X_SIZEOF_USHORT;
#line 3239

#line 3239
	*xpp = (void *)xp;
#line 3239
	return status;
#line 3239
}
#line 3239

int
#line 3240
ncx_pad_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3240
{
#line 3240
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3240

#line 3240
	const char *xp = (const char *) *xpp;
#line 3240
	int status = NC_NOERR;
#line 3240

#line 3240
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3240
	{
#line 3240
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3240
		if (status == NC_NOERR) /* report the first encountered error */
#line 3240
			status = lstatus;
#line 3240
	}
#line 3240

#line 3240
	if (rndup != 0)
#line 3240
		xp += X_SIZEOF_USHORT;
#line 3240

#line 3240
	*xpp = (void *)xp;
#line 3240
	return status;
#line 3240
}
#line 3240

int
#line 3241
ncx_pad_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3241
{
#line 3241
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3241

#line 3241
	const char *xp = (const char *) *xpp;
#line 3241
	int status = NC_NOERR;
#line 3241

#line 3241
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3241
	{
#line 3241
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3241
		if (status == NC_NOERR) /* report the first encountered error */
#line 3241
			status = lstatus;
#line 3241
	}
#line 3241

#line 3241
	if (rndup != 0)
#line 3241
		xp += X_SIZEOF_USHORT;
#line 3241

#line 3241
	*xpp = (void *)xp;
#line 3241
	return status;
#line 3241
}
#line 3241


#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const unsigned short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_USHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3257
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3257
{
#line 3257
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3257

#line 3257
 /* basic algorithm is:
#line 3257
  *   - ensure sane alignment of output data
#line 3257
  *   - copy (conversion happens automatically) input data
#line 3257
  *     to output
#line 3257
  *   - update tp to point at next unconverted input, and xpp to point
#line 3257
  *     at next location for converted output
#line 3257
  */
#line 3257
  long i, j, ni;
#line 3257
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3257
  ushort *xp;
#line 3257
  int nrange = 0;         /* number of range errors */
#line 3257
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3257
  long cxp = (long) *((char**)xpp);
#line 3257

#line 3257
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3257
  /* sjl: manually stripmine so we can limit amount of
#line 3257
   * vector work space reserved to LOOPCNT elements. Also
#line 3257
   * makes vectorisation easy */
#line 3257
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3257
    ni=Min(nelems-j,LOOPCNT);
#line 3257
    if (realign) {
#line 3257
      xp = tmp;
#line 3257
    } else {
#line 3257
      xp = (ushort *) *xpp;
#line 3257
    }
#line 3257
   /* copy the next block */
#line 3257
#pragma cdir loopcnt=LOOPCNT
#line 3257
#pragma cdir shortloop
#line 3257
    for (i=0; i<ni; i++) {
#line 3257
      /* the normal case: */
#line 3257
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3257
     /* test for range errors (not always needed but do it anyway) */
#line 3257
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3257
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3257
      nrange += tp[i] > X_USHORT_MAX ;
#line 3257
    }
#line 3257
   /* copy workspace back if necessary */
#line 3257
    if (realign) {
#line 3257
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3257
      xp = (ushort *) *xpp;
#line 3257
    }
#line 3257
   /* update xpp and tp */
#line 3257
    xp += ni;
#line 3257
    tp += ni;
#line 3257
    *xpp = (void*)xp;
#line 3257
  }
#line 3257
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3257

#line 3257
#else   /* not SX */
#line 3257

#line 3257
	char *xp = (char *) *xpp;
#line 3257
	int status = NC_NOERR;
#line 3257

#line 3257
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3257
	{
#line 3257
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3257
		if (status == NC_NOERR) /* report the first encountered error */
#line 3257
			status = lstatus;
#line 3257
	}
#line 3257

#line 3257
	*xpp = (void *)xp;
#line 3257
	return status;
#line 3257
#endif
#line 3257
}
#line 3257

#endif
int
#line 3259
ncx_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3259
{
#line 3259
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3259

#line 3259
 /* basic algorithm is:
#line 3259
  *   - ensure sane alignment of output data
#line 3259
  *   - copy (conversion happens automatically) input data
#line 3259
  *     to output
#line 3259
  *   - update tp to point at next unconverted input, and xpp to point
#line 3259
  *     at next location for converted output
#line 3259
  */
#line 3259
  long i, j, ni;
#line 3259
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3259
  ushort *xp;
#line 3259
  int nrange = 0;         /* number of range errors */
#line 3259
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3259
  long cxp = (long) *((char**)xpp);
#line 3259

#line 3259
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3259
  /* sjl: manually stripmine so we can limit amount of
#line 3259
   * vector work space reserved to LOOPCNT elements. Also
#line 3259
   * makes vectorisation easy */
#line 3259
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3259
    ni=Min(nelems-j,LOOPCNT);
#line 3259
    if (realign) {
#line 3259
      xp = tmp;
#line 3259
    } else {
#line 3259
      xp = (ushort *) *xpp;
#line 3259
    }
#line 3259
   /* copy the next block */
#line 3259
#pragma cdir loopcnt=LOOPCNT
#line 3259
#pragma cdir shortloop
#line 3259
    for (i=0; i<ni; i++) {
#line 3259
      /* the normal case: */
#line 3259
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3259
     /* test for range errors (not always needed but do it anyway) */
#line 3259
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3259
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3259
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3259
    }
#line 3259
   /* copy workspace back if necessary */
#line 3259
    if (realign) {
#line 3259
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3259
      xp = (ushort *) *xpp;
#line 3259
    }
#line 3259
   /* update xpp and tp */
#line 3259
    xp += ni;
#line 3259
    tp += ni;
#line 3259
    *xpp = (void*)xp;
#line 3259
  }
#line 3259
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3259

#line 3259
#else   /* not SX */
#line 3259

#line 3259
	char *xp = (char *) *xpp;
#line 3259
	int status = NC_NOERR;
#line 3259

#line 3259
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3259
	{
#line 3259
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3259
		if (status == NC_NOERR) /* report the first encountered error */
#line 3259
			status = lstatus;
#line 3259
	}
#line 3259

#line 3259
	*xpp = (void *)xp;
#line 3259
	return status;
#line 3259
#endif
#line 3259
}
#line 3259

int
#line 3260
ncx_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3260
{
#line 3260
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3260

#line 3260
 /* basic algorithm is:
#line 3260
  *   - ensure sane alignment of output data
#line 3260
  *   - copy (conversion happens automatically) input data
#line 3260
  *     to output
#line 3260
  *   - update tp to point at next unconverted input, and xpp to point
#line 3260
  *     at next location for converted output
#line 3260
  */
#line 3260
  long i, j, ni;
#line 3260
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3260
  ushort *xp;
#line 3260
  int nrange = 0;         /* number of range errors */
#line 3260
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3260
  long cxp = (long) *((char**)xpp);
#line 3260

#line 3260
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3260
  /* sjl: manually stripmine so we can limit amount of
#line 3260
   * vector work space reserved to LOOPCNT elements. Also
#line 3260
   * makes vectorisation easy */
#line 3260
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3260
    ni=Min(nelems-j,LOOPCNT);
#line 3260
    if (realign) {
#line 3260
      xp = tmp;
#line 3260
    } else {
#line 3260
      xp = (ushort *) *xpp;
#line 3260
    }
#line 3260
   /* copy the next block */
#line 3260
#pragma cdir loopcnt=LOOPCNT
#line 3260
#pragma cdir shortloop
#line 3260
    for (i=0; i<ni; i++) {
#line 3260
      /* the normal case: */
#line 3260
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3260
     /* test for range errors (not always needed but do it anyway) */
#line 3260
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3260
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3260
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3260
    }
#line 3260
   /* copy workspace back if necessary */
#line 3260
    if (realign) {
#line 3260
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3260
      xp = (ushort *) *xpp;
#line 3260
    }
#line 3260
   /* update xpp and tp */
#line 3260
    xp += ni;
#line 3260
    tp += ni;
#line 3260
    *xpp = (void*)xp;
#line 3260
  }
#line 3260
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3260

#line 3260
#else   /* not SX */
#line 3260

#line 3260
	char *xp = (char *) *xpp;
#line 3260
	int status = NC_NOERR;
#line 3260

#line 3260
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3260
	{
#line 3260
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3260
		if (status == NC_NOERR) /* report the first encountered error */
#line 3260
			status = lstatus;
#line 3260
	}
#line 3260

#line 3260
	*xpp = (void *)xp;
#line 3260
	return status;
#line 3260
#endif
#line 3260
}
#line 3260

int
#line 3261
ncx_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3261
{
#line 3261
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3261

#line 3261
 /* basic algorithm is:
#line 3261
  *   - ensure sane alignment of output data
#line 3261
  *   - copy (conversion happens automatically) input data
#line 3261
  *     to output
#line 3261
  *   - update tp to point at next unconverted input, and xpp to point
#line 3261
  *     at next location for converted output
#line 3261
  */
#line 3261
  long i, j, ni;
#line 3261
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3261
  ushort *xp;
#line 3261
  int nrange = 0;         /* number of range errors */
#line 3261
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3261
  long cxp = (long) *((char**)xpp);
#line 3261

#line 3261
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3261
  /* sjl: manually stripmine so we can limit amount of
#line 3261
   * vector work space reserved to LOOPCNT elements. Also
#line 3261
   * makes vectorisation easy */
#line 3261
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3261
    ni=Min(nelems-j,LOOPCNT);
#line 3261
    if (realign) {
#line 3261
      xp = tmp;
#line 3261
    } else {
#line 3261
      xp = (ushort *) *xpp;
#line 3261
    }
#line 3261
   /* copy the next block */
#line 3261
#pragma cdir loopcnt=LOOPCNT
#line 3261
#pragma cdir shortloop
#line 3261
    for (i=0; i<ni; i++) {
#line 3261
      /* the normal case: */
#line 3261
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3261
     /* test for range errors (not always needed but do it anyway) */
#line 3261
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3261
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3261
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3261
    }
#line 3261
   /* copy workspace back if necessary */
#line 3261
    if (realign) {
#line 3261
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3261
      xp = (ushort *) *xpp;
#line 3261
    }
#line 3261
   /* update xpp and tp */
#line 3261
    xp += ni;
#line 3261
    tp += ni;
#line 3261
    *xpp = (void*)xp;
#line 3261
  }
#line 3261
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3261

#line 3261
#else   /* not SX */
#line 3261

#line 3261
	char *xp = (char *) *xpp;
#line 3261
	int status = NC_NOERR;
#line 3261

#line 3261
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3261
	{
#line 3261
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3261
		if (status == NC_NOERR) /* report the first encountered error */
#line 3261
			status = lstatus;
#line 3261
	}
#line 3261

#line 3261
	*xpp = (void *)xp;
#line 3261
	return status;
#line 3261
#endif
#line 3261
}
#line 3261

int
#line 3262
ncx_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3262
{
#line 3262
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3262

#line 3262
 /* basic algorithm is:
#line 3262
  *   - ensure sane alignment of output data
#line 3262
  *   - copy (conversion happens automatically) input data
#line 3262
  *     to output
#line 3262
  *   - update tp to point at next unconverted input, and xpp to point
#line 3262
  *     at next location for converted output
#line 3262
  */
#line 3262
  long i, j, ni;
#line 3262
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3262
  ushort *xp;
#line 3262
  int nrange = 0;         /* number of range errors */
#line 3262
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3262
  long cxp = (long) *((char**)xpp);
#line 3262

#line 3262
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3262
  /* sjl: manually stripmine so we can limit amount of
#line 3262
   * vector work space reserved to LOOPCNT elements. Also
#line 3262
   * makes vectorisation easy */
#line 3262
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3262
    ni=Min(nelems-j,LOOPCNT);
#line 3262
    if (realign) {
#line 3262
      xp = tmp;
#line 3262
    } else {
#line 3262
      xp = (ushort *) *xpp;
#line 3262
    }
#line 3262
   /* copy the next block */
#line 3262
#pragma cdir loopcnt=LOOPCNT
#line 3262
#pragma cdir shortloop
#line 3262
    for (i=0; i<ni; i++) {
#line 3262
      /* the normal case: */
#line 3262
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3262
     /* test for range errors (not always needed but do it anyway) */
#line 3262
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3262
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3262
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3262
    }
#line 3262
   /* copy workspace back if necessary */
#line 3262
    if (realign) {
#line 3262
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3262
      xp = (ushort *) *xpp;
#line 3262
    }
#line 3262
   /* update xpp and tp */
#line 3262
    xp += ni;
#line 3262
    tp += ni;
#line 3262
    *xpp = (void*)xp;
#line 3262
  }
#line 3262
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3262

#line 3262
#else   /* not SX */
#line 3262

#line 3262
	char *xp = (char *) *xpp;
#line 3262
	int status = NC_NOERR;
#line 3262

#line 3262
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3262
	{
#line 3262
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3262
		if (status == NC_NOERR) /* report the first encountered error */
#line 3262
			status = lstatus;
#line 3262
	}
#line 3262

#line 3262
	*xpp = (void *)xp;
#line 3262
	return status;
#line 3262
#endif
#line 3262
}
#line 3262

int
#line 3263
ncx_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3263
{
#line 3263
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3263

#line 3263
 /* basic algorithm is:
#line 3263
  *   - ensure sane alignment of output data
#line 3263
  *   - copy (conversion happens automatically) input data
#line 3263
  *     to output
#line 3263
  *   - update tp to point at next unconverted input, and xpp to point
#line 3263
  *     at next location for converted output
#line 3263
  */
#line 3263
  long i, j, ni;
#line 3263
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3263
  ushort *xp;
#line 3263
  int nrange = 0;         /* number of range errors */
#line 3263
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3263
  long cxp = (long) *((char**)xpp);
#line 3263

#line 3263
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3263
  /* sjl: manually stripmine so we can limit amount of
#line 3263
   * vector work space reserved to LOOPCNT elements. Also
#line 3263
   * makes vectorisation easy */
#line 3263
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3263
    ni=Min(nelems-j,LOOPCNT);
#line 3263
    if (realign) {
#line 3263
      xp = tmp;
#line 3263
    } else {
#line 3263
      xp = (ushort *) *xpp;
#line 3263
    }
#line 3263
   /* copy the next block */
#line 3263
#pragma cdir loopcnt=LOOPCNT
#line 3263
#pragma cdir shortloop
#line 3263
    for (i=0; i<ni; i++) {
#line 3263
      /* the normal case: */
#line 3263
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3263
     /* test for range errors (not always needed but do it anyway) */
#line 3263
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3263
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3263
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3263
    }
#line 3263
   /* copy workspace back if necessary */
#line 3263
    if (realign) {
#line 3263
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3263
      xp = (ushort *) *xpp;
#line 3263
    }
#line 3263
   /* update xpp and tp */
#line 3263
    xp += ni;
#line 3263
    tp += ni;
#line 3263
    *xpp = (void*)xp;
#line 3263
  }
#line 3263
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3263

#line 3263
#else   /* not SX */
#line 3263

#line 3263
	char *xp = (char *) *xpp;
#line 3263
	int status = NC_NOERR;
#line 3263

#line 3263
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3263
	{
#line 3263
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3263
		if (status == NC_NOERR) /* report the first encountered error */
#line 3263
			status = lstatus;
#line 3263
	}
#line 3263

#line 3263
	*xpp = (void *)xp;
#line 3263
	return status;
#line 3263
#endif
#line 3263
}
#line 3263

int
#line 3264
ncx_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3264
{
#line 3264
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3264

#line 3264
 /* basic algorithm is:
#line 3264
  *   - ensure sane alignment of output data
#line 3264
  *   - copy (conversion happens automatically) input data
#line 3264
  *     to output
#line 3264
  *   - update tp to point at next unconverted input, and xpp to point
#line 3264
  *     at next location for converted output
#line 3264
  */
#line 3264
  long i, j, ni;
#line 3264
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3264
  ushort *xp;
#line 3264
  int nrange = 0;         /* number of range errors */
#line 3264
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3264
  long cxp = (long) *((char**)xpp);
#line 3264

#line 3264
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3264
  /* sjl: manually stripmine so we can limit amount of
#line 3264
   * vector work space reserved to LOOPCNT elements. Also
#line 3264
   * makes vectorisation easy */
#line 3264
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3264
    ni=Min(nelems-j,LOOPCNT);
#line 3264
    if (realign) {
#line 3264
      xp = tmp;
#line 3264
    } else {
#line 3264
      xp = (ushort *) *xpp;
#line 3264
    }
#line 3264
   /* copy the next block */
#line 3264
#pragma cdir loopcnt=LOOPCNT
#line 3264
#pragma cdir shortloop
#line 3264
    for (i=0; i<ni; i++) {
#line 3264
      /* the normal case: */
#line 3264
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3264
     /* test for range errors (not always needed but do it anyway) */
#line 3264
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3264
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3264
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3264
    }
#line 3264
   /* copy workspace back if necessary */
#line 3264
    if (realign) {
#line 3264
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3264
      xp = (ushort *) *xpp;
#line 3264
    }
#line 3264
   /* update xpp and tp */
#line 3264
    xp += ni;
#line 3264
    tp += ni;
#line 3264
    *xpp = (void*)xp;
#line 3264
  }
#line 3264
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3264

#line 3264
#else   /* not SX */
#line 3264

#line 3264
	char *xp = (char *) *xpp;
#line 3264
	int status = NC_NOERR;
#line 3264

#line 3264
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3264
	{
#line 3264
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3264
		if (status == NC_NOERR) /* report the first encountered error */
#line 3264
			status = lstatus;
#line 3264
	}
#line 3264

#line 3264
	*xpp = (void *)xp;
#line 3264
	return status;
#line 3264
#endif
#line 3264
}
#line 3264

int
#line 3265
ncx_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3265
{
#line 3265
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3265

#line 3265
 /* basic algorithm is:
#line 3265
  *   - ensure sane alignment of output data
#line 3265
  *   - copy (conversion happens automatically) input data
#line 3265
  *     to output
#line 3265
  *   - update tp to point at next unconverted input, and xpp to point
#line 3265
  *     at next location for converted output
#line 3265
  */
#line 3265
  long i, j, ni;
#line 3265
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3265
  ushort *xp;
#line 3265
  int nrange = 0;         /* number of range errors */
#line 3265
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3265
  long cxp = (long) *((char**)xpp);
#line 3265

#line 3265
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3265
  /* sjl: manually stripmine so we can limit amount of
#line 3265
   * vector work space reserved to LOOPCNT elements. Also
#line 3265
   * makes vectorisation easy */
#line 3265
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3265
    ni=Min(nelems-j,LOOPCNT);
#line 3265
    if (realign) {
#line 3265
      xp = tmp;
#line 3265
    } else {
#line 3265
      xp = (ushort *) *xpp;
#line 3265
    }
#line 3265
   /* copy the next block */
#line 3265
#pragma cdir loopcnt=LOOPCNT
#line 3265
#pragma cdir shortloop
#line 3265
    for (i=0; i<ni; i++) {
#line 3265
      /* the normal case: */
#line 3265
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3265
     /* test for range errors (not always needed but do it anyway) */
#line 3265
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3265
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3265
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3265
    }
#line 3265
   /* copy workspace back if necessary */
#line 3265
    if (realign) {
#line 3265
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3265
      xp = (ushort *) *xpp;
#line 3265
    }
#line 3265
   /* update xpp and tp */
#line 3265
    xp += ni;
#line 3265
    tp += ni;
#line 3265
    *xpp = (void*)xp;
#line 3265
  }
#line 3265
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3265

#line 3265
#else   /* not SX */
#line 3265

#line 3265
	char *xp = (char *) *xpp;
#line 3265
	int status = NC_NOERR;
#line 3265

#line 3265
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3265
	{
#line 3265
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3265
		if (status == NC_NOERR) /* report the first encountered error */
#line 3265
			status = lstatus;
#line 3265
	}
#line 3265

#line 3265
	*xpp = (void *)xp;
#line 3265
	return status;
#line 3265
#endif
#line 3265
}
#line 3265

int
#line 3266
ncx_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3266
{
#line 3266
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3266

#line 3266
 /* basic algorithm is:
#line 3266
  *   - ensure sane alignment of output data
#line 3266
  *   - copy (conversion happens automatically) input data
#line 3266
  *     to output
#line 3266
  *   - update tp to point at next unconverted input, and xpp to point
#line 3266
  *     at next location for converted output
#line 3266
  */
#line 3266
  long i, j, ni;
#line 3266
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3266
  ushort *xp;
#line 3266
  int nrange = 0;         /* number of range errors */
#line 3266
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3266
  long cxp = (long) *((char**)xpp);
#line 3266

#line 3266
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3266
  /* sjl: manually stripmine so we can limit amount of
#line 3266
   * vector work space reserved to LOOPCNT elements. Also
#line 3266
   * makes vectorisation easy */
#line 3266
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3266
    ni=Min(nelems-j,LOOPCNT);
#line 3266
    if (realign) {
#line 3266
      xp = tmp;
#line 3266
    } else {
#line 3266
      xp = (ushort *) *xpp;
#line 3266
    }
#line 3266
   /* copy the next block */
#line 3266
#pragma cdir loopcnt=LOOPCNT
#line 3266
#pragma cdir shortloop
#line 3266
    for (i=0; i<ni; i++) {
#line 3266
      /* the normal case: */
#line 3266
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3266
     /* test for range errors (not always needed but do it anyway) */
#line 3266
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3266
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3266
      nrange += tp[i] > X_USHORT_MAX ;
#line 3266
    }
#line 3266
   /* copy workspace back if necessary */
#line 3266
    if (realign) {
#line 3266
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3266
      xp = (ushort *) *xpp;
#line 3266
    }
#line 3266
   /* update xpp and tp */
#line 3266
    xp += ni;
#line 3266
    tp += ni;
#line 3266
    *xpp = (void*)xp;
#line 3266
  }
#line 3266
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3266

#line 3266
#else   /* not SX */
#line 3266

#line 3266
	char *xp = (char *) *xpp;
#line 3266
	int status = NC_NOERR;
#line 3266

#line 3266
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3266
	{
#line 3266
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3266
		if (status == NC_NOERR) /* report the first encountered error */
#line 3266
			status = lstatus;
#line 3266
	}
#line 3266

#line 3266
	*xpp = (void *)xp;
#line 3266
	return status;
#line 3266
#endif
#line 3266
}
#line 3266

int
#line 3267
ncx_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3267
{
#line 3267
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3267

#line 3267
 /* basic algorithm is:
#line 3267
  *   - ensure sane alignment of output data
#line 3267
  *   - copy (conversion happens automatically) input data
#line 3267
  *     to output
#line 3267
  *   - update tp to point at next unconverted input, and xpp to point
#line 3267
  *     at next location for converted output
#line 3267
  */
#line 3267
  long i, j, ni;
#line 3267
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3267
  ushort *xp;
#line 3267
  int nrange = 0;         /* number of range errors */
#line 3267
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3267
  long cxp = (long) *((char**)xpp);
#line 3267

#line 3267
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3267
  /* sjl: manually stripmine so we can limit amount of
#line 3267
   * vector work space reserved to LOOPCNT elements. Also
#line 3267
   * makes vectorisation easy */
#line 3267
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3267
    ni=Min(nelems-j,LOOPCNT);
#line 3267
    if (realign) {
#line 3267
      xp = tmp;
#line 3267
    } else {
#line 3267
      xp = (ushort *) *xpp;
#line 3267
    }
#line 3267
   /* copy the next block */
#line 3267
#pragma cdir loopcnt=LOOPCNT
#line 3267
#pragma cdir shortloop
#line 3267
    for (i=0; i<ni; i++) {
#line 3267
      /* the normal case: */
#line 3267
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3267
     /* test for range errors (not always needed but do it anyway) */
#line 3267
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3267
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3267
      nrange += tp[i] > X_USHORT_MAX ;
#line 3267
    }
#line 3267
   /* copy workspace back if necessary */
#line 3267
    if (realign) {
#line 3267
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3267
      xp = (ushort *) *xpp;
#line 3267
    }
#line 3267
   /* update xpp and tp */
#line 3267
    xp += ni;
#line 3267
    tp += ni;
#line 3267
    *xpp = (void*)xp;
#line 3267
  }
#line 3267
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3267

#line 3267
#else   /* not SX */
#line 3267

#line 3267
	char *xp = (char *) *xpp;
#line 3267
	int status = NC_NOERR;
#line 3267

#line 3267
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3267
	{
#line 3267
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3267
		if (status == NC_NOERR) /* report the first encountered error */
#line 3267
			status = lstatus;
#line 3267
	}
#line 3267

#line 3267
	*xpp = (void *)xp;
#line 3267
	return status;
#line 3267
#endif
#line 3267
}
#line 3267

int
#line 3268
ncx_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3268
{
#line 3268
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3268

#line 3268
 /* basic algorithm is:
#line 3268
  *   - ensure sane alignment of output data
#line 3268
  *   - copy (conversion happens automatically) input data
#line 3268
  *     to output
#line 3268
  *   - update tp to point at next unconverted input, and xpp to point
#line 3268
  *     at next location for converted output
#line 3268
  */
#line 3268
  long i, j, ni;
#line 3268
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3268
  ushort *xp;
#line 3268
  int nrange = 0;         /* number of range errors */
#line 3268
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3268
  long cxp = (long) *((char**)xpp);
#line 3268

#line 3268
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3268
  /* sjl: manually stripmine so we can limit amount of
#line 3268
   * vector work space reserved to LOOPCNT elements. Also
#line 3268
   * makes vectorisation easy */
#line 3268
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3268
    ni=Min(nelems-j,LOOPCNT);
#line 3268
    if (realign) {
#line 3268
      xp = tmp;
#line 3268
    } else {
#line 3268
      xp = (ushort *) *xpp;
#line 3268
    }
#line 3268
   /* copy the next block */
#line 3268
#pragma cdir loopcnt=LOOPCNT
#line 3268
#pragma cdir shortloop
#line 3268
    for (i=0; i<ni; i++) {
#line 3268
      /* the normal case: */
#line 3268
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3268
     /* test for range errors (not always needed but do it anyway) */
#line 3268
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3268
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3268
      nrange += tp[i] > X_USHORT_MAX ;
#line 3268
    }
#line 3268
   /* copy workspace back if necessary */
#line 3268
    if (realign) {
#line 3268
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3268
      xp = (ushort *) *xpp;
#line 3268
    }
#line 3268
   /* update xpp and tp */
#line 3268
    xp += ni;
#line 3268
    tp += ni;
#line 3268
    *xpp = (void*)xp;
#line 3268
  }
#line 3268
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3268

#line 3268
#else   /* not SX */
#line 3268

#line 3268
	char *xp = (char *) *xpp;
#line 3268
	int status = NC_NOERR;
#line 3268

#line 3268
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3268
	{
#line 3268
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3268
		if (status == NC_NOERR) /* report the first encountered error */
#line 3268
			status = lstatus;
#line 3268
	}
#line 3268

#line 3268
	*xpp = (void *)xp;
#line 3268
	return status;
#line 3268
#endif
#line 3268
}
#line 3268


int
#line 3270
ncx_pad_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3270
{
#line 3270
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3270

#line 3270
	char *xp = (char *) *xpp;
#line 3270
	int status = NC_NOERR;
#line 3270

#line 3270
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3270
	{
#line 3270
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3270
		if (status == NC_NOERR) /* report the first encountered error */
#line 3270
			status = lstatus;
#line 3270
	}
#line 3270

#line 3270
	if (rndup != 0)
#line 3270
	{
#line 3270
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3270
		xp += X_SIZEOF_USHORT;
#line 3270
	}
#line 3270

#line 3270
	*xpp = (void *)xp;
#line 3270
	return status;
#line 3270
}
#line 3270

int
#line 3271
ncx_pad_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3271
{
#line 3271
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3271

#line 3271
	char *xp = (char *) *xpp;
#line 3271
	int status = NC_NOERR;
#line 3271

#line 3271
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3271
	{
#line 3271
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3271
		if (status == NC_NOERR) /* report the first encountered error */
#line 3271
			status = lstatus;
#line 3271
	}
#line 3271

#line 3271
	if (rndup != 0)
#line 3271
	{
#line 3271
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3271
		xp += X_SIZEOF_USHORT;
#line 3271
	}
#line 3271

#line 3271
	*xpp = (void *)xp;
#line 3271
	return status;
#line 3271
}
#line 3271

int
#line 3272
ncx_pad_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3272
{
#line 3272
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3272

#line 3272
	char *xp = (char *) *xpp;
#line 3272
	int status = NC_NOERR;
#line 3272

#line 3272
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3272
	{
#line 3272
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3272
		if (status == NC_NOERR) /* report the first encountered error */
#line 3272
			status = lstatus;
#line 3272
	}
#line 3272

#line 3272
	if (rndup != 0)
#line 3272
	{
#line 3272
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3272
		xp += X_SIZEOF_USHORT;
#line 3272
	}
#line 3272

#line 3272
	*xpp = (void *)xp;
#line 3272
	return status;
#line 3272
}
#line 3272

int
#line 3273
ncx_pad_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3273
{
#line 3273
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3273

#line 3273
	char *xp = (char *) *xpp;
#line 3273
	int status = NC_NOERR;
#line 3273

#line 3273
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3273
	{
#line 3273
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3273
		if (status == NC_NOERR) /* report the first encountered error */
#line 3273
			status = lstatus;
#line 3273
	}
#line 3273

#line 3273
	if (rndup != 0)
#line 3273
	{
#line 3273
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3273
		xp += X_SIZEOF_USHORT;
#line 3273
	}
#line 3273

#line 3273
	*xpp = (void *)xp;
#line 3273
	return status;
#line 3273
}
#line 3273

int
#line 3274
ncx_pad_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3274
{
#line 3274
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3274

#line 3274
	char *xp = (char *) *xpp;
#line 3274
	int status = NC_NOERR;
#line 3274

#line 3274
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3274
	{
#line 3274
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3274
		if (status == NC_NOERR) /* report the first encountered error */
#line 3274
			status = lstatus;
#line 3274
	}
#line 3274

#line 3274
	if (rndup != 0)
#line 3274
	{
#line 3274
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3274
		xp += X_SIZEOF_USHORT;
#line 3274
	}
#line 3274

#line 3274
	*xpp = (void *)xp;
#line 3274
	return status;
#line 3274
}
#line 3274

int
#line 3275
ncx_pad_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3275
{
#line 3275
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3275

#line 3275
	char *xp = (char *) *xpp;
#line 3275
	int status = NC_NOERR;
#line 3275

#line 3275
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3275
	{
#line 3275
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3275
		if (status == NC_NOERR) /* report the first encountered error */
#line 3275
			status = lstatus;
#line 3275
	}
#line 3275

#line 3275
	if (rndup != 0)
#line 3275
	{
#line 3275
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3275
		xp += X_SIZEOF_USHORT;
#line 3275
	}
#line 3275

#line 3275
	*xpp = (void *)xp;
#line 3275
	return status;
#line 3275
}
#line 3275

int
#line 3276
ncx_pad_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3276
{
#line 3276
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3276

#line 3276
	char *xp = (char *) *xpp;
#line 3276
	int status = NC_NOERR;
#line 3276

#line 3276
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3276
	{
#line 3276
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3276
		if (status == NC_NOERR) /* report the first encountered error */
#line 3276
			status = lstatus;
#line 3276
	}
#line 3276

#line 3276
	if (rndup != 0)
#line 3276
	{
#line 3276
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3276
		xp += X_SIZEOF_USHORT;
#line 3276
	}
#line 3276

#line 3276
	*xpp = (void *)xp;
#line 3276
	return status;
#line 3276
}
#line 3276

int
#line 3277
ncx_pad_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3277
{
#line 3277
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3277

#line 3277
	char *xp = (char *) *xpp;
#line 3277
	int status = NC_NOERR;
#line 3277

#line 3277
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3277
	{
#line 3277
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3277
		if (status == NC_NOERR) /* report the first encountered error */
#line 3277
			status = lstatus;
#line 3277
	}
#line 3277

#line 3277
	if (rndup != 0)
#line 3277
	{
#line 3277
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3277
		xp += X_SIZEOF_USHORT;
#line 3277
	}
#line 3277

#line 3277
	*xpp = (void *)xp;
#line 3277
	return status;
#line 3277
}
#line 3277

int
#line 3278
ncx_pad_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3278
{
#line 3278
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3278

#line 3278
	char *xp = (char *) *xpp;
#line 3278
	int status = NC_NOERR;
#line 3278

#line 3278
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3278
	{
#line 3278
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3278
		if (status == NC_NOERR) /* report the first encountered error */
#line 3278
			status = lstatus;
#line 3278
	}
#line 3278

#line 3278
	if (rndup != 0)
#line 3278
	{
#line 3278
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3278
		xp += X_SIZEOF_USHORT;
#line 3278
	}
#line 3278

#line 3278
	*xpp = (void *)xp;
#line 3278
	return status;
#line 3278
}
#line 3278

int
#line 3279
ncx_pad_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3279
{
#line 3279
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3279

#line 3279
	char *xp = (char *) *xpp;
#line 3279
	int status = NC_NOERR;
#line 3279

#line 3279
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3279
	{
#line 3279
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3279
		if (status == NC_NOERR) /* report the first encountered error */
#line 3279
			status = lstatus;
#line 3279
	}
#line 3279

#line 3279
	if (rndup != 0)
#line 3279
	{
#line 3279
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3279
		xp += X_SIZEOF_USHORT;
#line 3279
	}
#line 3279

#line 3279
	*xpp = (void *)xp;
#line 3279
	return status;
#line 3279
}
#line 3279

int
#line 3280
ncx_pad_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3280
{
#line 3280
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3280

#line 3280
	char *xp = (char *) *xpp;
#line 3280
	int status = NC_NOERR;
#line 3280

#line 3280
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3280
	{
#line 3280
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3280
		if (status == NC_NOERR) /* report the first encountered error */
#line 3280
			status = lstatus;
#line 3280
	}
#line 3280

#line 3280
	if (rndup != 0)
#line 3280
	{
#line 3280
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3280
		xp += X_SIZEOF_USHORT;
#line 3280
	}
#line 3280

#line 3280
	*xpp = (void *)xp;
#line 3280
	return status;
#line 3280
}
#line 3280



/* int -----------------------------------------------------------------------*/

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_INT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3299
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
#line 3299
{
#line 3299
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3299

#line 3299
 /* basic algorithm is:
#line 3299
  *   - ensure sane alignment of input data
#line 3299
  *   - copy (conversion happens automatically) input data
#line 3299
  *     to output
#line 3299
  *   - update xpp to point at next unconverted input, and tp to point
#line 3299
  *     at next location for converted output
#line 3299
  */
#line 3299
  long i, j, ni;
#line 3299
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3299
  int *xp;
#line 3299
  int nrange = 0;         /* number of range errors */
#line 3299
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3299
  long cxp = (long) *((char**)xpp);
#line 3299

#line 3299
  realign = (cxp & 7) % SIZEOF_INT;
#line 3299
  /* sjl: manually stripmine so we can limit amount of
#line 3299
   * vector work space reserved to LOOPCNT elements. Also
#line 3299
   * makes vectorisation easy */
#line 3299
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3299
    ni=Min(nelems-j,LOOPCNT);
#line 3299
    if (realign) {
#line 3299
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3299
      xp = tmp;
#line 3299
    } else {
#line 3299
      xp = (int *) *xpp;
#line 3299
    }
#line 3299
   /* copy the next block */
#line 3299
#pragma cdir loopcnt=LOOPCNT
#line 3299
#pragma cdir shortloop
#line 3299
    for (i=0; i<ni; i++) {
#line 3299
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3299
     /* test for range errors (not always needed but do it anyway) */
#line 3299
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3299
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3299
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3299
    }
#line 3299
   /* update xpp and tp */
#line 3299
    if (realign) xp = (int *) *xpp;
#line 3299
    xp += ni;
#line 3299
    tp += ni;
#line 3299
    *xpp = (void*)xp;
#line 3299
  }
#line 3299
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3299

#line 3299
#else   /* not SX */
#line 3299
	const char *xp = (const char *) *xpp;
#line 3299
	int status = NC_NOERR;
#line 3299

#line 3299
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3299
	{
#line 3299
		const int lstatus = ncx_get_int_int(xp, tp);
#line 3299
		if (status == NC_NOERR) /* report the first encountered error */
#line 3299
			status = lstatus;
#line 3299
	}
#line 3299

#line 3299
	*xpp = (const void *)xp;
#line 3299
	return status;
#line 3299
#endif
#line 3299
}
#line 3299

#endif
int
#line 3301
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
#line 3301
{
#line 3301
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3301

#line 3301
 /* basic algorithm is:
#line 3301
  *   - ensure sane alignment of input data
#line 3301
  *   - copy (conversion happens automatically) input data
#line 3301
  *     to output
#line 3301
  *   - update xpp to point at next unconverted input, and tp to point
#line 3301
  *     at next location for converted output
#line 3301
  */
#line 3301
  long i, j, ni;
#line 3301
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3301
  int *xp;
#line 3301
  int nrange = 0;         /* number of range errors */
#line 3301
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3301
  long cxp = (long) *((char**)xpp);
#line 3301

#line 3301
  realign = (cxp & 7) % SIZEOF_INT;
#line 3301
  /* sjl: manually stripmine so we can limit amount of
#line 3301
   * vector work space reserved to LOOPCNT elements. Also
#line 3301
   * makes vectorisation easy */
#line 3301
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3301
    ni=Min(nelems-j,LOOPCNT);
#line 3301
    if (realign) {
#line 3301
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3301
      xp = tmp;
#line 3301
    } else {
#line 3301
      xp = (int *) *xpp;
#line 3301
    }
#line 3301
   /* copy the next block */
#line 3301
#pragma cdir loopcnt=LOOPCNT
#line 3301
#pragma cdir shortloop
#line 3301
    for (i=0; i<ni; i++) {
#line 3301
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3301
     /* test for range errors (not always needed but do it anyway) */
#line 3301
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3301
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3301
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3301
    }
#line 3301
   /* update xpp and tp */
#line 3301
    if (realign) xp = (int *) *xpp;
#line 3301
    xp += ni;
#line 3301
    tp += ni;
#line 3301
    *xpp = (void*)xp;
#line 3301
  }
#line 3301
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3301

#line 3301
#else   /* not SX */
#line 3301
	const char *xp = (const char *) *xpp;
#line 3301
	int status = NC_NOERR;
#line 3301

#line 3301
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3301
	{
#line 3301
		const int lstatus = ncx_get_int_schar(xp, tp);
#line 3301
		if (status == NC_NOERR) /* report the first encountered error */
#line 3301
			status = lstatus;
#line 3301
	}
#line 3301

#line 3301
	*xpp = (const void *)xp;
#line 3301
	return status;
#line 3301
#endif
#line 3301
}
#line 3301

int
#line 3302
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
#line 3302
{
#line 3302
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3302

#line 3302
 /* basic algorithm is:
#line 3302
  *   - ensure sane alignment of input data
#line 3302
  *   - copy (conversion happens automatically) input data
#line 3302
  *     to output
#line 3302
  *   - update xpp to point at next unconverted input, and tp to point
#line 3302
  *     at next location for converted output
#line 3302
  */
#line 3302
  long i, j, ni;
#line 3302
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3302
  int *xp;
#line 3302
  int nrange = 0;         /* number of range errors */
#line 3302
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3302
  long cxp = (long) *((char**)xpp);
#line 3302

#line 3302
  realign = (cxp & 7) % SIZEOF_INT;
#line 3302
  /* sjl: manually stripmine so we can limit amount of
#line 3302
   * vector work space reserved to LOOPCNT elements. Also
#line 3302
   * makes vectorisation easy */
#line 3302
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3302
    ni=Min(nelems-j,LOOPCNT);
#line 3302
    if (realign) {
#line 3302
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3302
      xp = tmp;
#line 3302
    } else {
#line 3302
      xp = (int *) *xpp;
#line 3302
    }
#line 3302
   /* copy the next block */
#line 3302
#pragma cdir loopcnt=LOOPCNT
#line 3302
#pragma cdir shortloop
#line 3302
    for (i=0; i<ni; i++) {
#line 3302
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3302
     /* test for range errors (not always needed but do it anyway) */
#line 3302
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3302
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3302
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3302
    }
#line 3302
   /* update xpp and tp */
#line 3302
    if (realign) xp = (int *) *xpp;
#line 3302
    xp += ni;
#line 3302
    tp += ni;
#line 3302
    *xpp = (void*)xp;
#line 3302
  }
#line 3302
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3302

#line 3302
#else   /* not SX */
#line 3302
	const char *xp = (const char *) *xpp;
#line 3302
	int status = NC_NOERR;
#line 3302

#line 3302
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3302
	{
#line 3302
		const int lstatus = ncx_get_int_short(xp, tp);
#line 3302
		if (status == NC_NOERR) /* report the first encountered error */
#line 3302
			status = lstatus;
#line 3302
	}
#line 3302

#line 3302
	*xpp = (const void *)xp;
#line 3302
	return status;
#line 3302
#endif
#line 3302
}
#line 3302

int
#line 3303
ncx_getn_int_long(const void **xpp, size_t nelems, long *tp)
#line 3303
{
#line 3303
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3303

#line 3303
 /* basic algorithm is:
#line 3303
  *   - ensure sane alignment of input data
#line 3303
  *   - copy (conversion happens automatically) input data
#line 3303
  *     to output
#line 3303
  *   - update xpp to point at next unconverted input, and tp to point
#line 3303
  *     at next location for converted output
#line 3303
  */
#line 3303
  long i, j, ni;
#line 3303
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3303
  int *xp;
#line 3303
  int nrange = 0;         /* number of range errors */
#line 3303
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3303
  long cxp = (long) *((char**)xpp);
#line 3303

#line 3303
  realign = (cxp & 7) % SIZEOF_INT;
#line 3303
  /* sjl: manually stripmine so we can limit amount of
#line 3303
   * vector work space reserved to LOOPCNT elements. Also
#line 3303
   * makes vectorisation easy */
#line 3303
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3303
    ni=Min(nelems-j,LOOPCNT);
#line 3303
    if (realign) {
#line 3303
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3303
      xp = tmp;
#line 3303
    } else {
#line 3303
      xp = (int *) *xpp;
#line 3303
    }
#line 3303
   /* copy the next block */
#line 3303
#pragma cdir loopcnt=LOOPCNT
#line 3303
#pragma cdir shortloop
#line 3303
    for (i=0; i<ni; i++) {
#line 3303
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3303
     /* test for range errors (not always needed but do it anyway) */
#line 3303
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3303
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3303
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3303
    }
#line 3303
   /* update xpp and tp */
#line 3303
    if (realign) xp = (int *) *xpp;
#line 3303
    xp += ni;
#line 3303
    tp += ni;
#line 3303
    *xpp = (void*)xp;
#line 3303
  }
#line 3303
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3303

#line 3303
#else   /* not SX */
#line 3303
	const char *xp = (const char *) *xpp;
#line 3303
	int status = NC_NOERR;
#line 3303

#line 3303
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3303
	{
#line 3303
		const int lstatus = ncx_get_int_long(xp, tp);
#line 3303
		if (status == NC_NOERR) /* report the first encountered error */
#line 3303
			status = lstatus;
#line 3303
	}
#line 3303

#line 3303
	*xpp = (const void *)xp;
#line 3303
	return status;
#line 3303
#endif
#line 3303
}
#line 3303

int
#line 3304
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
#line 3304
{
#line 3304
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3304

#line 3304
 /* basic algorithm is:
#line 3304
  *   - ensure sane alignment of input data
#line 3304
  *   - copy (conversion happens automatically) input data
#line 3304
  *     to output
#line 3304
  *   - update xpp to point at next unconverted input, and tp to point
#line 3304
  *     at next location for converted output
#line 3304
  */
#line 3304
  long i, j, ni;
#line 3304
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3304
  int *xp;
#line 3304
  int nrange = 0;         /* number of range errors */
#line 3304
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3304
  long cxp = (long) *((char**)xpp);
#line 3304

#line 3304
  realign = (cxp & 7) % SIZEOF_INT;
#line 3304
  /* sjl: manually stripmine so we can limit amount of
#line 3304
   * vector work space reserved to LOOPCNT elements. Also
#line 3304
   * makes vectorisation easy */
#line 3304
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3304
    ni=Min(nelems-j,LOOPCNT);
#line 3304
    if (realign) {
#line 3304
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3304
      xp = tmp;
#line 3304
    } else {
#line 3304
      xp = (int *) *xpp;
#line 3304
    }
#line 3304
   /* copy the next block */
#line 3304
#pragma cdir loopcnt=LOOPCNT
#line 3304
#pragma cdir shortloop
#line 3304
    for (i=0; i<ni; i++) {
#line 3304
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3304
     /* test for range errors (not always needed but do it anyway) */
#line 3304
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3304
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3304
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3304
    }
#line 3304
   /* update xpp and tp */
#line 3304
    if (realign) xp = (int *) *xpp;
#line 3304
    xp += ni;
#line 3304
    tp += ni;
#line 3304
    *xpp = (void*)xp;
#line 3304
  }
#line 3304
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3304

#line 3304
#else   /* not SX */
#line 3304
	const char *xp = (const char *) *xpp;
#line 3304
	int status = NC_NOERR;
#line 3304

#line 3304
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3304
	{
#line 3304
		const int lstatus = ncx_get_int_float(xp, tp);
#line 3304
		if (status == NC_NOERR) /* report the first encountered error */
#line 3304
			status = lstatus;
#line 3304
	}
#line 3304

#line 3304
	*xpp = (const void *)xp;
#line 3304
	return status;
#line 3304
#endif
#line 3304
}
#line 3304

int
#line 3305
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
#line 3305
{
#line 3305
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3305

#line 3305
 /* basic algorithm is:
#line 3305
  *   - ensure sane alignment of input data
#line 3305
  *   - copy (conversion happens automatically) input data
#line 3305
  *     to output
#line 3305
  *   - update xpp to point at next unconverted input, and tp to point
#line 3305
  *     at next location for converted output
#line 3305
  */
#line 3305
  long i, j, ni;
#line 3305
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3305
  int *xp;
#line 3305
  int nrange = 0;         /* number of range errors */
#line 3305
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3305
  long cxp = (long) *((char**)xpp);
#line 3305

#line 3305
  realign = (cxp & 7) % SIZEOF_INT;
#line 3305
  /* sjl: manually stripmine so we can limit amount of
#line 3305
   * vector work space reserved to LOOPCNT elements. Also
#line 3305
   * makes vectorisation easy */
#line 3305
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3305
    ni=Min(nelems-j,LOOPCNT);
#line 3305
    if (realign) {
#line 3305
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3305
      xp = tmp;
#line 3305
    } else {
#line 3305
      xp = (int *) *xpp;
#line 3305
    }
#line 3305
   /* copy the next block */
#line 3305
#pragma cdir loopcnt=LOOPCNT
#line 3305
#pragma cdir shortloop
#line 3305
    for (i=0; i<ni; i++) {
#line 3305
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3305
     /* test for range errors (not always needed but do it anyway) */
#line 3305
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3305
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3305
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3305
    }
#line 3305
   /* update xpp and tp */
#line 3305
    if (realign) xp = (int *) *xpp;
#line 3305
    xp += ni;
#line 3305
    tp += ni;
#line 3305
    *xpp = (void*)xp;
#line 3305
  }
#line 3305
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3305

#line 3305
#else   /* not SX */
#line 3305
	const char *xp = (const char *) *xpp;
#line 3305
	int status = NC_NOERR;
#line 3305

#line 3305
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3305
	{
#line 3305
		const int lstatus = ncx_get_int_double(xp, tp);
#line 3305
		if (status == NC_NOERR) /* report the first encountered error */
#line 3305
			status = lstatus;
#line 3305
	}
#line 3305

#line 3305
	*xpp = (const void *)xp;
#line 3305
	return status;
#line 3305
#endif
#line 3305
}
#line 3305

int
#line 3306
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3306
{
#line 3306
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3306

#line 3306
 /* basic algorithm is:
#line 3306
  *   - ensure sane alignment of input data
#line 3306
  *   - copy (conversion happens automatically) input data
#line 3306
  *     to output
#line 3306
  *   - update xpp to point at next unconverted input, and tp to point
#line 3306
  *     at next location for converted output
#line 3306
  */
#line 3306
  long i, j, ni;
#line 3306
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3306
  int *xp;
#line 3306
  int nrange = 0;         /* number of range errors */
#line 3306
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3306
  long cxp = (long) *((char**)xpp);
#line 3306

#line 3306
  realign = (cxp & 7) % SIZEOF_INT;
#line 3306
  /* sjl: manually stripmine so we can limit amount of
#line 3306
   * vector work space reserved to LOOPCNT elements. Also
#line 3306
   * makes vectorisation easy */
#line 3306
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3306
    ni=Min(nelems-j,LOOPCNT);
#line 3306
    if (realign) {
#line 3306
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3306
      xp = tmp;
#line 3306
    } else {
#line 3306
      xp = (int *) *xpp;
#line 3306
    }
#line 3306
   /* copy the next block */
#line 3306
#pragma cdir loopcnt=LOOPCNT
#line 3306
#pragma cdir shortloop
#line 3306
    for (i=0; i<ni; i++) {
#line 3306
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3306
     /* test for range errors (not always needed but do it anyway) */
#line 3306
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3306
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3306
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3306
    }
#line 3306
   /* update xpp and tp */
#line 3306
    if (realign) xp = (int *) *xpp;
#line 3306
    xp += ni;
#line 3306
    tp += ni;
#line 3306
    *xpp = (void*)xp;
#line 3306
  }
#line 3306
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3306

#line 3306
#else   /* not SX */
#line 3306
	const char *xp = (const char *) *xpp;
#line 3306
	int status = NC_NOERR;
#line 3306

#line 3306
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3306
	{
#line 3306
		const int lstatus = ncx_get_int_longlong(xp, tp);
#line 3306
		if (status == NC_NOERR) /* report the first encountered error */
#line 3306
			status = lstatus;
#line 3306
	}
#line 3306

#line 3306
	*xpp = (const void *)xp;
#line 3306
	return status;
#line 3306
#endif
#line 3306
}
#line 3306

int
#line 3307
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3307
{
#line 3307
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3307

#line 3307
 /* basic algorithm is:
#line 3307
  *   - ensure sane alignment of input data
#line 3307
  *   - copy (conversion happens automatically) input data
#line 3307
  *     to output
#line 3307
  *   - update xpp to point at next unconverted input, and tp to point
#line 3307
  *     at next location for converted output
#line 3307
  */
#line 3307
  long i, j, ni;
#line 3307
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3307
  int *xp;
#line 3307
  int nrange = 0;         /* number of range errors */
#line 3307
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3307
  long cxp = (long) *((char**)xpp);
#line 3307

#line 3307
  realign = (cxp & 7) % SIZEOF_INT;
#line 3307
  /* sjl: manually stripmine so we can limit amount of
#line 3307
   * vector work space reserved to LOOPCNT elements. Also
#line 3307
   * makes vectorisation easy */
#line 3307
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3307
    ni=Min(nelems-j,LOOPCNT);
#line 3307
    if (realign) {
#line 3307
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3307
      xp = tmp;
#line 3307
    } else {
#line 3307
      xp = (int *) *xpp;
#line 3307
    }
#line 3307
   /* copy the next block */
#line 3307
#pragma cdir loopcnt=LOOPCNT
#line 3307
#pragma cdir shortloop
#line 3307
    for (i=0; i<ni; i++) {
#line 3307
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3307
     /* test for range errors (not always needed but do it anyway) */
#line 3307
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3307
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3307
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3307
    }
#line 3307
   /* update xpp and tp */
#line 3307
    if (realign) xp = (int *) *xpp;
#line 3307
    xp += ni;
#line 3307
    tp += ni;
#line 3307
    *xpp = (void*)xp;
#line 3307
  }
#line 3307
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3307

#line 3307
#else   /* not SX */
#line 3307
	const char *xp = (const char *) *xpp;
#line 3307
	int status = NC_NOERR;
#line 3307

#line 3307
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3307
	{
#line 3307
		const int lstatus = ncx_get_int_uchar(xp, tp);
#line 3307
		if (status == NC_NOERR) /* report the first encountered error */
#line 3307
			status = lstatus;
#line 3307
	}
#line 3307

#line 3307
	*xpp = (const void *)xp;
#line 3307
	return status;
#line 3307
#endif
#line 3307
}
#line 3307

int
#line 3308
ncx_getn_int_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3308
{
#line 3308
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3308

#line 3308
 /* basic algorithm is:
#line 3308
  *   - ensure sane alignment of input data
#line 3308
  *   - copy (conversion happens automatically) input data
#line 3308
  *     to output
#line 3308
  *   - update xpp to point at next unconverted input, and tp to point
#line 3308
  *     at next location for converted output
#line 3308
  */
#line 3308
  long i, j, ni;
#line 3308
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3308
  int *xp;
#line 3308
  int nrange = 0;         /* number of range errors */
#line 3308
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3308
  long cxp = (long) *((char**)xpp);
#line 3308

#line 3308
  realign = (cxp & 7) % SIZEOF_INT;
#line 3308
  /* sjl: manually stripmine so we can limit amount of
#line 3308
   * vector work space reserved to LOOPCNT elements. Also
#line 3308
   * makes vectorisation easy */
#line 3308
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3308
    ni=Min(nelems-j,LOOPCNT);
#line 3308
    if (realign) {
#line 3308
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3308
      xp = tmp;
#line 3308
    } else {
#line 3308
      xp = (int *) *xpp;
#line 3308
    }
#line 3308
   /* copy the next block */
#line 3308
#pragma cdir loopcnt=LOOPCNT
#line 3308
#pragma cdir shortloop
#line 3308
    for (i=0; i<ni; i++) {
#line 3308
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3308
     /* test for range errors (not always needed but do it anyway) */
#line 3308
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3308
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3308
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3308
    }
#line 3308
   /* update xpp and tp */
#line 3308
    if (realign) xp = (int *) *xpp;
#line 3308
    xp += ni;
#line 3308
    tp += ni;
#line 3308
    *xpp = (void*)xp;
#line 3308
  }
#line 3308
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3308

#line 3308
#else   /* not SX */
#line 3308
	const char *xp = (const char *) *xpp;
#line 3308
	int status = NC_NOERR;
#line 3308

#line 3308
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3308
	{
#line 3308
		const int lstatus = ncx_get_int_ushort(xp, tp);
#line 3308
		if (status == NC_NOERR) /* report the first encountered error */
#line 3308
			status = lstatus;
#line 3308
	}
#line 3308

#line 3308
	*xpp = (const void *)xp;
#line 3308
	return status;
#line 3308
#endif
#line 3308
}
#line 3308

int
#line 3309
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
#line 3309
{
#line 3309
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3309

#line 3309
 /* basic algorithm is:
#line 3309
  *   - ensure sane alignment of input data
#line 3309
  *   - copy (conversion happens automatically) input data
#line 3309
  *     to output
#line 3309
  *   - update xpp to point at next unconverted input, and tp to point
#line 3309
  *     at next location for converted output
#line 3309
  */
#line 3309
  long i, j, ni;
#line 3309
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3309
  int *xp;
#line 3309
  int nrange = 0;         /* number of range errors */
#line 3309
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3309
  long cxp = (long) *((char**)xpp);
#line 3309

#line 3309
  realign = (cxp & 7) % SIZEOF_INT;
#line 3309
  /* sjl: manually stripmine so we can limit amount of
#line 3309
   * vector work space reserved to LOOPCNT elements. Also
#line 3309
   * makes vectorisation easy */
#line 3309
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3309
    ni=Min(nelems-j,LOOPCNT);
#line 3309
    if (realign) {
#line 3309
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3309
      xp = tmp;
#line 3309
    } else {
#line 3309
      xp = (int *) *xpp;
#line 3309
    }
#line 3309
   /* copy the next block */
#line 3309
#pragma cdir loopcnt=LOOPCNT
#line 3309
#pragma cdir shortloop
#line 3309
    for (i=0; i<ni; i++) {
#line 3309
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3309
     /* test for range errors (not always needed but do it anyway) */
#line 3309
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3309
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3309
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3309
    }
#line 3309
   /* update xpp and tp */
#line 3309
    if (realign) xp = (int *) *xpp;
#line 3309
    xp += ni;
#line 3309
    tp += ni;
#line 3309
    *xpp = (void*)xp;
#line 3309
  }
#line 3309
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3309

#line 3309
#else   /* not SX */
#line 3309
	const char *xp = (const char *) *xpp;
#line 3309
	int status = NC_NOERR;
#line 3309

#line 3309
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3309
	{
#line 3309
		const int lstatus = ncx_get_int_uint(xp, tp);
#line 3309
		if (status == NC_NOERR) /* report the first encountered error */
#line 3309
			status = lstatus;
#line 3309
	}
#line 3309

#line 3309
	*xpp = (const void *)xp;
#line 3309
	return status;
#line 3309
#endif
#line 3309
}
#line 3309

int
#line 3310
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3310
{
#line 3310
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3310

#line 3310
 /* basic algorithm is:
#line 3310
  *   - ensure sane alignment of input data
#line 3310
  *   - copy (conversion happens automatically) input data
#line 3310
  *     to output
#line 3310
  *   - update xpp to point at next unconverted input, and tp to point
#line 3310
  *     at next location for converted output
#line 3310
  */
#line 3310
  long i, j, ni;
#line 3310
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3310
  int *xp;
#line 3310
  int nrange = 0;         /* number of range errors */
#line 3310
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3310
  long cxp = (long) *((char**)xpp);
#line 3310

#line 3310
  realign = (cxp & 7) % SIZEOF_INT;
#line 3310
  /* sjl: manually stripmine so we can limit amount of
#line 3310
   * vector work space reserved to LOOPCNT elements. Also
#line 3310
   * makes vectorisation easy */
#line 3310
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3310
    ni=Min(nelems-j,LOOPCNT);
#line 3310
    if (realign) {
#line 3310
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3310
      xp = tmp;
#line 3310
    } else {
#line 3310
      xp = (int *) *xpp;
#line 3310
    }
#line 3310
   /* copy the next block */
#line 3310
#pragma cdir loopcnt=LOOPCNT
#line 3310
#pragma cdir shortloop
#line 3310
    for (i=0; i<ni; i++) {
#line 3310
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3310
     /* test for range errors (not always needed but do it anyway) */
#line 3310
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3310
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3310
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3310
    }
#line 3310
   /* update xpp and tp */
#line 3310
    if (realign) xp = (int *) *xpp;
#line 3310
    xp += ni;
#line 3310
    tp += ni;
#line 3310
    *xpp = (void*)xp;
#line 3310
  }
#line 3310
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3310

#line 3310
#else   /* not SX */
#line 3310
	const char *xp = (const char *) *xpp;
#line 3310
	int status = NC_NOERR;
#line 3310

#line 3310
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3310
	{
#line 3310
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
#line 3310
		if (status == NC_NOERR) /* report the first encountered error */
#line 3310
			status = lstatus;
#line 3310
	}
#line 3310

#line 3310
	*xpp = (const void *)xp;
#line 3310
	return status;
#line 3310
#endif
#line 3310
}
#line 3310


#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3326
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3326
{
#line 3326
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3326

#line 3326
 /* basic algorithm is:
#line 3326
  *   - ensure sane alignment of output data
#line 3326
  *   - copy (conversion happens automatically) input data
#line 3326
  *     to output
#line 3326
  *   - update tp to point at next unconverted input, and xpp to point
#line 3326
  *     at next location for converted output
#line 3326
  */
#line 3326
  long i, j, ni;
#line 3326
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3326
  int *xp;
#line 3326
  int nrange = 0;         /* number of range errors */
#line 3326
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3326
  long cxp = (long) *((char**)xpp);
#line 3326

#line 3326
  realign = (cxp & 7) % SIZEOF_INT;
#line 3326
  /* sjl: manually stripmine so we can limit amount of
#line 3326
   * vector work space reserved to LOOPCNT elements. Also
#line 3326
   * makes vectorisation easy */
#line 3326
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3326
    ni=Min(nelems-j,LOOPCNT);
#line 3326
    if (realign) {
#line 3326
      xp = tmp;
#line 3326
    } else {
#line 3326
      xp = (int *) *xpp;
#line 3326
    }
#line 3326
   /* copy the next block */
#line 3326
#pragma cdir loopcnt=LOOPCNT
#line 3326
#pragma cdir shortloop
#line 3326
    for (i=0; i<ni; i++) {
#line 3326
      /* the normal case: */
#line 3326
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3326
     /* test for range errors (not always needed but do it anyway) */
#line 3326
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3326
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3326
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3326
    }
#line 3326
   /* copy workspace back if necessary */
#line 3326
    if (realign) {
#line 3326
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3326
      xp = (int *) *xpp;
#line 3326
    }
#line 3326
   /* update xpp and tp */
#line 3326
    xp += ni;
#line 3326
    tp += ni;
#line 3326
    *xpp = (void*)xp;
#line 3326
  }
#line 3326
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3326

#line 3326
#else   /* not SX */
#line 3326

#line 3326
	char *xp = (char *) *xpp;
#line 3326
	int status = NC_NOERR;
#line 3326

#line 3326
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3326
	{
#line 3326
		int lstatus = ncx_put_int_int(xp, tp, fillp);
#line 3326
		if (status == NC_NOERR) /* report the first encountered error */
#line 3326
			status = lstatus;
#line 3326
	}
#line 3326

#line 3326
	*xpp = (void *)xp;
#line 3326
	return status;
#line 3326
#endif
#line 3326
}
#line 3326

#endif
int
#line 3328
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3328
{
#line 3328
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3328

#line 3328
 /* basic algorithm is:
#line 3328
  *   - ensure sane alignment of output data
#line 3328
  *   - copy (conversion happens automatically) input data
#line 3328
  *     to output
#line 3328
  *   - update tp to point at next unconverted input, and xpp to point
#line 3328
  *     at next location for converted output
#line 3328
  */
#line 3328
  long i, j, ni;
#line 3328
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3328
  int *xp;
#line 3328
  int nrange = 0;         /* number of range errors */
#line 3328
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3328
  long cxp = (long) *((char**)xpp);
#line 3328

#line 3328
  realign = (cxp & 7) % SIZEOF_INT;
#line 3328
  /* sjl: manually stripmine so we can limit amount of
#line 3328
   * vector work space reserved to LOOPCNT elements. Also
#line 3328
   * makes vectorisation easy */
#line 3328
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3328
    ni=Min(nelems-j,LOOPCNT);
#line 3328
    if (realign) {
#line 3328
      xp = tmp;
#line 3328
    } else {
#line 3328
      xp = (int *) *xpp;
#line 3328
    }
#line 3328
   /* copy the next block */
#line 3328
#pragma cdir loopcnt=LOOPCNT
#line 3328
#pragma cdir shortloop
#line 3328
    for (i=0; i<ni; i++) {
#line 3328
      /* the normal case: */
#line 3328
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3328
     /* test for range errors (not always needed but do it anyway) */
#line 3328
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3328
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3328
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3328
    }
#line 3328
   /* copy workspace back if necessary */
#line 3328
    if (realign) {
#line 3328
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3328
      xp = (int *) *xpp;
#line 3328
    }
#line 3328
   /* update xpp and tp */
#line 3328
    xp += ni;
#line 3328
    tp += ni;
#line 3328
    *xpp = (void*)xp;
#line 3328
  }
#line 3328
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3328

#line 3328
#else   /* not SX */
#line 3328

#line 3328
	char *xp = (char *) *xpp;
#line 3328
	int status = NC_NOERR;
#line 3328

#line 3328
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3328
	{
#line 3328
		int lstatus = ncx_put_int_schar(xp, tp, fillp);
#line 3328
		if (status == NC_NOERR) /* report the first encountered error */
#line 3328
			status = lstatus;
#line 3328
	}
#line 3328

#line 3328
	*xpp = (void *)xp;
#line 3328
	return status;
#line 3328
#endif
#line 3328
}
#line 3328

int
#line 3329
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3329
{
#line 3329
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3329

#line 3329
 /* basic algorithm is:
#line 3329
  *   - ensure sane alignment of output data
#line 3329
  *   - copy (conversion happens automatically) input data
#line 3329
  *     to output
#line 3329
  *   - update tp to point at next unconverted input, and xpp to point
#line 3329
  *     at next location for converted output
#line 3329
  */
#line 3329
  long i, j, ni;
#line 3329
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3329
  int *xp;
#line 3329
  int nrange = 0;         /* number of range errors */
#line 3329
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3329
  long cxp = (long) *((char**)xpp);
#line 3329

#line 3329
  realign = (cxp & 7) % SIZEOF_INT;
#line 3329
  /* sjl: manually stripmine so we can limit amount of
#line 3329
   * vector work space reserved to LOOPCNT elements. Also
#line 3329
   * makes vectorisation easy */
#line 3329
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3329
    ni=Min(nelems-j,LOOPCNT);
#line 3329
    if (realign) {
#line 3329
      xp = tmp;
#line 3329
    } else {
#line 3329
      xp = (int *) *xpp;
#line 3329
    }
#line 3329
   /* copy the next block */
#line 3329
#pragma cdir loopcnt=LOOPCNT
#line 3329
#pragma cdir shortloop
#line 3329
    for (i=0; i<ni; i++) {
#line 3329
      /* the normal case: */
#line 3329
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3329
     /* test for range errors (not always needed but do it anyway) */
#line 3329
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3329
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3329
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3329
    }
#line 3329
   /* copy workspace back if necessary */
#line 3329
    if (realign) {
#line 3329
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3329
      xp = (int *) *xpp;
#line 3329
    }
#line 3329
   /* update xpp and tp */
#line 3329
    xp += ni;
#line 3329
    tp += ni;
#line 3329
    *xpp = (void*)xp;
#line 3329
  }
#line 3329
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3329

#line 3329
#else   /* not SX */
#line 3329

#line 3329
	char *xp = (char *) *xpp;
#line 3329
	int status = NC_NOERR;
#line 3329

#line 3329
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3329
	{
#line 3329
		int lstatus = ncx_put_int_short(xp, tp, fillp);
#line 3329
		if (status == NC_NOERR) /* report the first encountered error */
#line 3329
			status = lstatus;
#line 3329
	}
#line 3329

#line 3329
	*xpp = (void *)xp;
#line 3329
	return status;
#line 3329
#endif
#line 3329
}
#line 3329

int
#line 3330
ncx_putn_int_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3330
{
#line 3330
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3330

#line 3330
 /* basic algorithm is:
#line 3330
  *   - ensure sane alignment of output data
#line 3330
  *   - copy (conversion happens automatically) input data
#line 3330
  *     to output
#line 3330
  *   - update tp to point at next unconverted input, and xpp to point
#line 3330
  *     at next location for converted output
#line 3330
  */
#line 3330
  long i, j, ni;
#line 3330
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3330
  int *xp;
#line 3330
  int nrange = 0;         /* number of range errors */
#line 3330
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3330
  long cxp = (long) *((char**)xpp);
#line 3330

#line 3330
  realign = (cxp & 7) % SIZEOF_INT;
#line 3330
  /* sjl: manually stripmine so we can limit amount of
#line 3330
   * vector work space reserved to LOOPCNT elements. Also
#line 3330
   * makes vectorisation easy */
#line 3330
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3330
    ni=Min(nelems-j,LOOPCNT);
#line 3330
    if (realign) {
#line 3330
      xp = tmp;
#line 3330
    } else {
#line 3330
      xp = (int *) *xpp;
#line 3330
    }
#line 3330
   /* copy the next block */
#line 3330
#pragma cdir loopcnt=LOOPCNT
#line 3330
#pragma cdir shortloop
#line 3330
    for (i=0; i<ni; i++) {
#line 3330
      /* the normal case: */
#line 3330
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3330
     /* test for range errors (not always needed but do it anyway) */
#line 3330
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3330
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3330
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3330
    }
#line 3330
   /* copy workspace back if necessary */
#line 3330
    if (realign) {
#line 3330
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3330
      xp = (int *) *xpp;
#line 3330
    }
#line 3330
   /* update xpp and tp */
#line 3330
    xp += ni;
#line 3330
    tp += ni;
#line 3330
    *xpp = (void*)xp;
#line 3330
  }
#line 3330
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3330

#line 3330
#else   /* not SX */
#line 3330

#line 3330
	char *xp = (char *) *xpp;
#line 3330
	int status = NC_NOERR;
#line 3330

#line 3330
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3330
	{
#line 3330
		int lstatus = ncx_put_int_long(xp, tp, fillp);
#line 3330
		if (status == NC_NOERR) /* report the first encountered error */
#line 3330
			status = lstatus;
#line 3330
	}
#line 3330

#line 3330
	*xpp = (void *)xp;
#line 3330
	return status;
#line 3330
#endif
#line 3330
}
#line 3330

int
#line 3331
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3331
{
#line 3331
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3331

#line 3331
 /* basic algorithm is:
#line 3331
  *   - ensure sane alignment of output data
#line 3331
  *   - copy (conversion happens automatically) input data
#line 3331
  *     to output
#line 3331
  *   - update tp to point at next unconverted input, and xpp to point
#line 3331
  *     at next location for converted output
#line 3331
  */
#line 3331
  long i, j, ni;
#line 3331
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3331
  int *xp;
#line 3331
  double d;               /* special case for ncx_putn_int_float */
#line 3331
  int nrange = 0;         /* number of range errors */
#line 3331
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3331
  long cxp = (long) *((char**)xpp);
#line 3331

#line 3331
  realign = (cxp & 7) % SIZEOF_INT;
#line 3331
  /* sjl: manually stripmine so we can limit amount of
#line 3331
   * vector work space reserved to LOOPCNT elements. Also
#line 3331
   * makes vectorisation easy */
#line 3331
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3331
    ni=Min(nelems-j,LOOPCNT);
#line 3331
    if (realign) {
#line 3331
      xp = tmp;
#line 3331
    } else {
#line 3331
      xp = (int *) *xpp;
#line 3331
    }
#line 3331
   /* copy the next block */
#line 3331
#pragma cdir loopcnt=LOOPCNT
#line 3331
#pragma cdir shortloop
#line 3331
    for (i=0; i<ni; i++) {
#line 3331
      /* for some reason int to float, for putn, requires a special case */
#line 3331
      d = tp[i];
#line 3331
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
#line 3331
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3331
    }
#line 3331
   /* copy workspace back if necessary */
#line 3331
    if (realign) {
#line 3331
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3331
      xp = (int *) *xpp;
#line 3331
    }
#line 3331
   /* update xpp and tp */
#line 3331
    xp += ni;
#line 3331
    tp += ni;
#line 3331
    *xpp = (void*)xp;
#line 3331
  }
#line 3331
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3331

#line 3331
#else   /* not SX */
#line 3331

#line 3331
	char *xp = (char *) *xpp;
#line 3331
	int status = NC_NOERR;
#line 3331

#line 3331
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3331
	{
#line 3331
		int lstatus = ncx_put_int_float(xp, tp, fillp);
#line 3331
		if (status == NC_NOERR) /* report the first encountered error */
#line 3331
			status = lstatus;
#line 3331
	}
#line 3331

#line 3331
	*xpp = (void *)xp;
#line 3331
	return status;
#line 3331
#endif
#line 3331
}
#line 3331

int
#line 3332
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3332
{
#line 3332
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3332

#line 3332
 /* basic algorithm is:
#line 3332
  *   - ensure sane alignment of output data
#line 3332
  *   - copy (conversion happens automatically) input data
#line 3332
  *     to output
#line 3332
  *   - update tp to point at next unconverted input, and xpp to point
#line 3332
  *     at next location for converted output
#line 3332
  */
#line 3332
  long i, j, ni;
#line 3332
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3332
  int *xp;
#line 3332
  int nrange = 0;         /* number of range errors */
#line 3332
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3332
  long cxp = (long) *((char**)xpp);
#line 3332

#line 3332
  realign = (cxp & 7) % SIZEOF_INT;
#line 3332
  /* sjl: manually stripmine so we can limit amount of
#line 3332
   * vector work space reserved to LOOPCNT elements. Also
#line 3332
   * makes vectorisation easy */
#line 3332
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3332
    ni=Min(nelems-j,LOOPCNT);
#line 3332
    if (realign) {
#line 3332
      xp = tmp;
#line 3332
    } else {
#line 3332
      xp = (int *) *xpp;
#line 3332
    }
#line 3332
   /* copy the next block */
#line 3332
#pragma cdir loopcnt=LOOPCNT
#line 3332
#pragma cdir shortloop
#line 3332
    for (i=0; i<ni; i++) {
#line 3332
      /* the normal case: */
#line 3332
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3332
     /* test for range errors (not always needed but do it anyway) */
#line 3332
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3332
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3332
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3332
    }
#line 3332
   /* copy workspace back if necessary */
#line 3332
    if (realign) {
#line 3332
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3332
      xp = (int *) *xpp;
#line 3332
    }
#line 3332
   /* update xpp and tp */
#line 3332
    xp += ni;
#line 3332
    tp += ni;
#line 3332
    *xpp = (void*)xp;
#line 3332
  }
#line 3332
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3332

#line 3332
#else   /* not SX */
#line 3332

#line 3332
	char *xp = (char *) *xpp;
#line 3332
	int status = NC_NOERR;
#line 3332

#line 3332
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3332
	{
#line 3332
		int lstatus = ncx_put_int_double(xp, tp, fillp);
#line 3332
		if (status == NC_NOERR) /* report the first encountered error */
#line 3332
			status = lstatus;
#line 3332
	}
#line 3332

#line 3332
	*xpp = (void *)xp;
#line 3332
	return status;
#line 3332
#endif
#line 3332
}
#line 3332

int
#line 3333
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3333
{
#line 3333
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3333

#line 3333
 /* basic algorithm is:
#line 3333
  *   - ensure sane alignment of output data
#line 3333
  *   - copy (conversion happens automatically) input data
#line 3333
  *     to output
#line 3333
  *   - update tp to point at next unconverted input, and xpp to point
#line 3333
  *     at next location for converted output
#line 3333
  */
#line 3333
  long i, j, ni;
#line 3333
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3333
  int *xp;
#line 3333
  int nrange = 0;         /* number of range errors */
#line 3333
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3333
  long cxp = (long) *((char**)xpp);
#line 3333

#line 3333
  realign = (cxp & 7) % SIZEOF_INT;
#line 3333
  /* sjl: manually stripmine so we can limit amount of
#line 3333
   * vector work space reserved to LOOPCNT elements. Also
#line 3333
   * makes vectorisation easy */
#line 3333
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3333
    ni=Min(nelems-j,LOOPCNT);
#line 3333
    if (realign) {
#line 3333
      xp = tmp;
#line 3333
    } else {
#line 3333
      xp = (int *) *xpp;
#line 3333
    }
#line 3333
   /* copy the next block */
#line 3333
#pragma cdir loopcnt=LOOPCNT
#line 3333
#pragma cdir shortloop
#line 3333
    for (i=0; i<ni; i++) {
#line 3333
      /* the normal case: */
#line 3333
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3333
     /* test for range errors (not always needed but do it anyway) */
#line 3333
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3333
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3333
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3333
    }
#line 3333
   /* copy workspace back if necessary */
#line 3333
    if (realign) {
#line 3333
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3333
      xp = (int *) *xpp;
#line 3333
    }
#line 3333
   /* update xpp and tp */
#line 3333
    xp += ni;
#line 3333
    tp += ni;
#line 3333
    *xpp = (void*)xp;
#line 3333
  }
#line 3333
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3333

#line 3333
#else   /* not SX */
#line 3333

#line 3333
	char *xp = (char *) *xpp;
#line 3333
	int status = NC_NOERR;
#line 3333

#line 3333
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3333
	{
#line 3333
		int lstatus = ncx_put_int_longlong(xp, tp, fillp);
#line 3333
		if (status == NC_NOERR) /* report the first encountered error */
#line 3333
			status = lstatus;
#line 3333
	}
#line 3333

#line 3333
	*xpp = (void *)xp;
#line 3333
	return status;
#line 3333
#endif
#line 3333
}
#line 3333

int
#line 3334
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3334
{
#line 3334
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3334

#line 3334
 /* basic algorithm is:
#line 3334
  *   - ensure sane alignment of output data
#line 3334
  *   - copy (conversion happens automatically) input data
#line 3334
  *     to output
#line 3334
  *   - update tp to point at next unconverted input, and xpp to point
#line 3334
  *     at next location for converted output
#line 3334
  */
#line 3334
  long i, j, ni;
#line 3334
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3334
  int *xp;
#line 3334
  int nrange = 0;         /* number of range errors */
#line 3334
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3334
  long cxp = (long) *((char**)xpp);
#line 3334

#line 3334
  realign = (cxp & 7) % SIZEOF_INT;
#line 3334
  /* sjl: manually stripmine so we can limit amount of
#line 3334
   * vector work space reserved to LOOPCNT elements. Also
#line 3334
   * makes vectorisation easy */
#line 3334
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3334
    ni=Min(nelems-j,LOOPCNT);
#line 3334
    if (realign) {
#line 3334
      xp = tmp;
#line 3334
    } else {
#line 3334
      xp = (int *) *xpp;
#line 3334
    }
#line 3334
   /* copy the next block */
#line 3334
#pragma cdir loopcnt=LOOPCNT
#line 3334
#pragma cdir shortloop
#line 3334
    for (i=0; i<ni; i++) {
#line 3334
      /* the normal case: */
#line 3334
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3334
     /* test for range errors (not always needed but do it anyway) */
#line 3334
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3334
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3334
      nrange += tp[i] > X_INT_MAX ;
#line 3334
    }
#line 3334
   /* copy workspace back if necessary */
#line 3334
    if (realign) {
#line 3334
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3334
      xp = (int *) *xpp;
#line 3334
    }
#line 3334
   /* update xpp and tp */
#line 3334
    xp += ni;
#line 3334
    tp += ni;
#line 3334
    *xpp = (void*)xp;
#line 3334
  }
#line 3334
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3334

#line 3334
#else   /* not SX */
#line 3334

#line 3334
	char *xp = (char *) *xpp;
#line 3334
	int status = NC_NOERR;
#line 3334

#line 3334
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3334
	{
#line 3334
		int lstatus = ncx_put_int_uchar(xp, tp, fillp);
#line 3334
		if (status == NC_NOERR) /* report the first encountered error */
#line 3334
			status = lstatus;
#line 3334
	}
#line 3334

#line 3334
	*xpp = (void *)xp;
#line 3334
	return status;
#line 3334
#endif
#line 3334
}
#line 3334

int
#line 3335
ncx_putn_int_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3335
{
#line 3335
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3335

#line 3335
 /* basic algorithm is:
#line 3335
  *   - ensure sane alignment of output data
#line 3335
  *   - copy (conversion happens automatically) input data
#line 3335
  *     to output
#line 3335
  *   - update tp to point at next unconverted input, and xpp to point
#line 3335
  *     at next location for converted output
#line 3335
  */
#line 3335
  long i, j, ni;
#line 3335
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3335
  int *xp;
#line 3335
  int nrange = 0;         /* number of range errors */
#line 3335
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3335
  long cxp = (long) *((char**)xpp);
#line 3335

#line 3335
  realign = (cxp & 7) % SIZEOF_INT;
#line 3335
  /* sjl: manually stripmine so we can limit amount of
#line 3335
   * vector work space reserved to LOOPCNT elements. Also
#line 3335
   * makes vectorisation easy */
#line 3335
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3335
    ni=Min(nelems-j,LOOPCNT);
#line 3335
    if (realign) {
#line 3335
      xp = tmp;
#line 3335
    } else {
#line 3335
      xp = (int *) *xpp;
#line 3335
    }
#line 3335
   /* copy the next block */
#line 3335
#pragma cdir loopcnt=LOOPCNT
#line 3335
#pragma cdir shortloop
#line 3335
    for (i=0; i<ni; i++) {
#line 3335
      /* the normal case: */
#line 3335
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3335
     /* test for range errors (not always needed but do it anyway) */
#line 3335
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3335
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3335
      nrange += tp[i] > X_INT_MAX ;
#line 3335
    }
#line 3335
   /* copy workspace back if necessary */
#line 3335
    if (realign) {
#line 3335
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3335
      xp = (int *) *xpp;
#line 3335
    }
#line 3335
   /* update xpp and tp */
#line 3335
    xp += ni;
#line 3335
    tp += ni;
#line 3335
    *xpp = (void*)xp;
#line 3335
  }
#line 3335
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3335

#line 3335
#else   /* not SX */
#line 3335

#line 3335
	char *xp = (char *) *xpp;
#line 3335
	int status = NC_NOERR;
#line 3335

#line 3335
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3335
	{
#line 3335
		int lstatus = ncx_put_int_ushort(xp, tp, fillp);
#line 3335
		if (status == NC_NOERR) /* report the first encountered error */
#line 3335
			status = lstatus;
#line 3335
	}
#line 3335

#line 3335
	*xpp = (void *)xp;
#line 3335
	return status;
#line 3335
#endif
#line 3335
}
#line 3335

int
#line 3336
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3336
{
#line 3336
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3336

#line 3336
 /* basic algorithm is:
#line 3336
  *   - ensure sane alignment of output data
#line 3336
  *   - copy (conversion happens automatically) input data
#line 3336
  *     to output
#line 3336
  *   - update tp to point at next unconverted input, and xpp to point
#line 3336
  *     at next location for converted output
#line 3336
  */
#line 3336
  long i, j, ni;
#line 3336
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3336
  int *xp;
#line 3336
  int nrange = 0;         /* number of range errors */
#line 3336
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3336
  long cxp = (long) *((char**)xpp);
#line 3336

#line 3336
  realign = (cxp & 7) % SIZEOF_INT;
#line 3336
  /* sjl: manually stripmine so we can limit amount of
#line 3336
   * vector work space reserved to LOOPCNT elements. Also
#line 3336
   * makes vectorisation easy */
#line 3336
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3336
    ni=Min(nelems-j,LOOPCNT);
#line 3336
    if (realign) {
#line 3336
      xp = tmp;
#line 3336
    } else {
#line 3336
      xp = (int *) *xpp;
#line 3336
    }
#line 3336
   /* copy the next block */
#line 3336
#pragma cdir loopcnt=LOOPCNT
#line 3336
#pragma cdir shortloop
#line 3336
    for (i=0; i<ni; i++) {
#line 3336
      /* the normal case: */
#line 3336
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3336
     /* test for range errors (not always needed but do it anyway) */
#line 3336
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3336
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3336
      nrange += tp[i] > X_INT_MAX ;
#line 3336
    }
#line 3336
   /* copy workspace back if necessary */
#line 3336
    if (realign) {
#line 3336
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3336
      xp = (int *) *xpp;
#line 3336
    }
#line 3336
   /* update xpp and tp */
#line 3336
    xp += ni;
#line 3336
    tp += ni;
#line 3336
    *xpp = (void*)xp;
#line 3336
  }
#line 3336
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3336

#line 3336
#else   /* not SX */
#line 3336

#line 3336
	char *xp = (char *) *xpp;
#line 3336
	int status = NC_NOERR;
#line 3336

#line 3336
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3336
	{
#line 3336
		int lstatus = ncx_put_int_uint(xp, tp, fillp);
#line 3336
		if (status == NC_NOERR) /* report the first encountered error */
#line 3336
			status = lstatus;
#line 3336
	}
#line 3336

#line 3336
	*xpp = (void *)xp;
#line 3336
	return status;
#line 3336
#endif
#line 3336
}
#line 3336

int
#line 3337
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3337
{
#line 3337
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3337

#line 3337
 /* basic algorithm is:
#line 3337
  *   - ensure sane alignment of output data
#line 3337
  *   - copy (conversion happens automatically) input data
#line 3337
  *     to output
#line 3337
  *   - update tp to point at next unconverted input, and xpp to point
#line 3337
  *     at next location for converted output
#line 3337
  */
#line 3337
  long i, j, ni;
#line 3337
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3337
  int *xp;
#line 3337
  int nrange = 0;         /* number of range errors */
#line 3337
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3337
  long cxp = (long) *((char**)xpp);
#line 3337

#line 3337
  realign = (cxp & 7) % SIZEOF_INT;
#line 3337
  /* sjl: manually stripmine so we can limit amount of
#line 3337
   * vector work space reserved to LOOPCNT elements. Also
#line 3337
   * makes vectorisation easy */
#line 3337
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3337
    ni=Min(nelems-j,LOOPCNT);
#line 3337
    if (realign) {
#line 3337
      xp = tmp;
#line 3337
    } else {
#line 3337
      xp = (int *) *xpp;
#line 3337
    }
#line 3337
   /* copy the next block */
#line 3337
#pragma cdir loopcnt=LOOPCNT
#line 3337
#pragma cdir shortloop
#line 3337
    for (i=0; i<ni; i++) {
#line 3337
      /* the normal case: */
#line 3337
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3337
     /* test for range errors (not always needed but do it anyway) */
#line 3337
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3337
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3337
      nrange += tp[i] > X_INT_MAX ;
#line 3337
    }
#line 3337
   /* copy workspace back if necessary */
#line 3337
    if (realign) {
#line 3337
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3337
      xp = (int *) *xpp;
#line 3337
    }
#line 3337
   /* update xpp and tp */
#line 3337
    xp += ni;
#line 3337
    tp += ni;
#line 3337
    *xpp = (void*)xp;
#line 3337
  }
#line 3337
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3337

#line 3337
#else   /* not SX */
#line 3337

#line 3337
	char *xp = (char *) *xpp;
#line 3337
	int status = NC_NOERR;
#line 3337

#line 3337
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3337
	{
#line 3337
		int lstatus = ncx_put_int_ulonglong(xp, tp, fillp);
#line 3337
		if (status == NC_NOERR) /* report the first encountered error */
#line 3337
			status = lstatus;
#line 3337
	}
#line 3337

#line 3337
	*xpp = (void *)xp;
#line 3337
	return status;
#line 3337
#endif
#line 3337
}
#line 3337


/* uint ----------------------------------------------------------------------*/

#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UINT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3355
ncx_getn_uint_uint(const void **xpp, size_t nelems, uint *tp)
#line 3355
{
#line 3355
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3355

#line 3355
 /* basic algorithm is:
#line 3355
  *   - ensure sane alignment of input data
#line 3355
  *   - copy (conversion happens automatically) input data
#line 3355
  *     to output
#line 3355
  *   - update xpp to point at next unconverted input, and tp to point
#line 3355
  *     at next location for converted output
#line 3355
  */
#line 3355
  long i, j, ni;
#line 3355
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3355
  uint *xp;
#line 3355
  int nrange = 0;         /* number of range errors */
#line 3355
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3355
  long cxp = (long) *((char**)xpp);
#line 3355

#line 3355
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3355
  /* sjl: manually stripmine so we can limit amount of
#line 3355
   * vector work space reserved to LOOPCNT elements. Also
#line 3355
   * makes vectorisation easy */
#line 3355
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3355
    ni=Min(nelems-j,LOOPCNT);
#line 3355
    if (realign) {
#line 3355
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3355
      xp = tmp;
#line 3355
    } else {
#line 3355
      xp = (uint *) *xpp;
#line 3355
    }
#line 3355
   /* copy the next block */
#line 3355
#pragma cdir loopcnt=LOOPCNT
#line 3355
#pragma cdir shortloop
#line 3355
    for (i=0; i<ni; i++) {
#line 3355
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3355
     /* test for range errors (not always needed but do it anyway) */
#line 3355
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3355
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3355
      nrange += xp[i] > UINT_MAX ;
#line 3355
    }
#line 3355
   /* update xpp and tp */
#line 3355
    if (realign) xp = (uint *) *xpp;
#line 3355
    xp += ni;
#line 3355
    tp += ni;
#line 3355
    *xpp = (void*)xp;
#line 3355
  }
#line 3355
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3355

#line 3355
#else   /* not SX */
#line 3355
	const char *xp = (const char *) *xpp;
#line 3355
	int status = NC_NOERR;
#line 3355

#line 3355
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3355
	{
#line 3355
		const int lstatus = ncx_get_uint_uint(xp, tp);
#line 3355
		if (status == NC_NOERR) /* report the first encountered error */
#line 3355
			status = lstatus;
#line 3355
	}
#line 3355

#line 3355
	*xpp = (const void *)xp;
#line 3355
	return status;
#line 3355
#endif
#line 3355
}
#line 3355

#endif
int
#line 3357
ncx_getn_uint_schar(const void **xpp, size_t nelems, schar *tp)
#line 3357
{
#line 3357
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3357

#line 3357
 /* basic algorithm is:
#line 3357
  *   - ensure sane alignment of input data
#line 3357
  *   - copy (conversion happens automatically) input data
#line 3357
  *     to output
#line 3357
  *   - update xpp to point at next unconverted input, and tp to point
#line 3357
  *     at next location for converted output
#line 3357
  */
#line 3357
  long i, j, ni;
#line 3357
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3357
  uint *xp;
#line 3357
  int nrange = 0;         /* number of range errors */
#line 3357
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3357
  long cxp = (long) *((char**)xpp);
#line 3357

#line 3357
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3357
  /* sjl: manually stripmine so we can limit amount of
#line 3357
   * vector work space reserved to LOOPCNT elements. Also
#line 3357
   * makes vectorisation easy */
#line 3357
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3357
    ni=Min(nelems-j,LOOPCNT);
#line 3357
    if (realign) {
#line 3357
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3357
      xp = tmp;
#line 3357
    } else {
#line 3357
      xp = (uint *) *xpp;
#line 3357
    }
#line 3357
   /* copy the next block */
#line 3357
#pragma cdir loopcnt=LOOPCNT
#line 3357
#pragma cdir shortloop
#line 3357
    for (i=0; i<ni; i++) {
#line 3357
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3357
     /* test for range errors (not always needed but do it anyway) */
#line 3357
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3357
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3357
      nrange += xp[i] > SCHAR_MAX ;
#line 3357
    }
#line 3357
   /* update xpp and tp */
#line 3357
    if (realign) xp = (uint *) *xpp;
#line 3357
    xp += ni;
#line 3357
    tp += ni;
#line 3357
    *xpp = (void*)xp;
#line 3357
  }
#line 3357
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3357

#line 3357
#else   /* not SX */
#line 3357
	const char *xp = (const char *) *xpp;
#line 3357
	int status = NC_NOERR;
#line 3357

#line 3357
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3357
	{
#line 3357
		const int lstatus = ncx_get_uint_schar(xp, tp);
#line 3357
		if (status == NC_NOERR) /* report the first encountered error */
#line 3357
			status = lstatus;
#line 3357
	}
#line 3357

#line 3357
	*xpp = (const void *)xp;
#line 3357
	return status;
#line 3357
#endif
#line 3357
}
#line 3357

int
#line 3358
ncx_getn_uint_short(const void **xpp, size_t nelems, short *tp)
#line 3358
{
#line 3358
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3358

#line 3358
 /* basic algorithm is:
#line 3358
  *   - ensure sane alignment of input data
#line 3358
  *   - copy (conversion happens automatically) input data
#line 3358
  *     to output
#line 3358
  *   - update xpp to point at next unconverted input, and tp to point
#line 3358
  *     at next location for converted output
#line 3358
  */
#line 3358
  long i, j, ni;
#line 3358
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3358
  uint *xp;
#line 3358
  int nrange = 0;         /* number of range errors */
#line 3358
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3358
  long cxp = (long) *((char**)xpp);
#line 3358

#line 3358
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3358
  /* sjl: manually stripmine so we can limit amount of
#line 3358
   * vector work space reserved to LOOPCNT elements. Also
#line 3358
   * makes vectorisation easy */
#line 3358
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3358
    ni=Min(nelems-j,LOOPCNT);
#line 3358
    if (realign) {
#line 3358
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3358
      xp = tmp;
#line 3358
    } else {
#line 3358
      xp = (uint *) *xpp;
#line 3358
    }
#line 3358
   /* copy the next block */
#line 3358
#pragma cdir loopcnt=LOOPCNT
#line 3358
#pragma cdir shortloop
#line 3358
    for (i=0; i<ni; i++) {
#line 3358
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3358
     /* test for range errors (not always needed but do it anyway) */
#line 3358
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3358
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3358
      nrange += xp[i] > SHORT_MAX ;
#line 3358
    }
#line 3358
   /* update xpp and tp */
#line 3358
    if (realign) xp = (uint *) *xpp;
#line 3358
    xp += ni;
#line 3358
    tp += ni;
#line 3358
    *xpp = (void*)xp;
#line 3358
  }
#line 3358
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3358

#line 3358
#else   /* not SX */
#line 3358
	const char *xp = (const char *) *xpp;
#line 3358
	int status = NC_NOERR;
#line 3358

#line 3358
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3358
	{
#line 3358
		const int lstatus = ncx_get_uint_short(xp, tp);
#line 3358
		if (status == NC_NOERR) /* report the first encountered error */
#line 3358
			status = lstatus;
#line 3358
	}
#line 3358

#line 3358
	*xpp = (const void *)xp;
#line 3358
	return status;
#line 3358
#endif
#line 3358
}
#line 3358

int
#line 3359
ncx_getn_uint_int(const void **xpp, size_t nelems, int *tp)
#line 3359
{
#line 3359
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3359

#line 3359
 /* basic algorithm is:
#line 3359
  *   - ensure sane alignment of input data
#line 3359
  *   - copy (conversion happens automatically) input data
#line 3359
  *     to output
#line 3359
  *   - update xpp to point at next unconverted input, and tp to point
#line 3359
  *     at next location for converted output
#line 3359
  */
#line 3359
  long i, j, ni;
#line 3359
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3359
  uint *xp;
#line 3359
  int nrange = 0;         /* number of range errors */
#line 3359
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3359
  long cxp = (long) *((char**)xpp);
#line 3359

#line 3359
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3359
  /* sjl: manually stripmine so we can limit amount of
#line 3359
   * vector work space reserved to LOOPCNT elements. Also
#line 3359
   * makes vectorisation easy */
#line 3359
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3359
    ni=Min(nelems-j,LOOPCNT);
#line 3359
    if (realign) {
#line 3359
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3359
      xp = tmp;
#line 3359
    } else {
#line 3359
      xp = (uint *) *xpp;
#line 3359
    }
#line 3359
   /* copy the next block */
#line 3359
#pragma cdir loopcnt=LOOPCNT
#line 3359
#pragma cdir shortloop
#line 3359
    for (i=0; i<ni; i++) {
#line 3359
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3359
     /* test for range errors (not always needed but do it anyway) */
#line 3359
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3359
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3359
      nrange += xp[i] > INT_MAX ;
#line 3359
    }
#line 3359
   /* update xpp and tp */
#line 3359
    if (realign) xp = (uint *) *xpp;
#line 3359
    xp += ni;
#line 3359
    tp += ni;
#line 3359
    *xpp = (void*)xp;
#line 3359
  }
#line 3359
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3359

#line 3359
#else   /* not SX */
#line 3359
	const char *xp = (const char *) *xpp;
#line 3359
	int status = NC_NOERR;
#line 3359

#line 3359
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3359
	{
#line 3359
		const int lstatus = ncx_get_uint_int(xp, tp);
#line 3359
		if (status == NC_NOERR) /* report the first encountered error */
#line 3359
			status = lstatus;
#line 3359
	}
#line 3359

#line 3359
	*xpp = (const void *)xp;
#line 3359
	return status;
#line 3359
#endif
#line 3359
}
#line 3359

int
#line 3360
ncx_getn_uint_long(const void **xpp, size_t nelems, long *tp)
#line 3360
{
#line 3360
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3360

#line 3360
 /* basic algorithm is:
#line 3360
  *   - ensure sane alignment of input data
#line 3360
  *   - copy (conversion happens automatically) input data
#line 3360
  *     to output
#line 3360
  *   - update xpp to point at next unconverted input, and tp to point
#line 3360
  *     at next location for converted output
#line 3360
  */
#line 3360
  long i, j, ni;
#line 3360
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3360
  uint *xp;
#line 3360
  int nrange = 0;         /* number of range errors */
#line 3360
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3360
  long cxp = (long) *((char**)xpp);
#line 3360

#line 3360
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3360
  /* sjl: manually stripmine so we can limit amount of
#line 3360
   * vector work space reserved to LOOPCNT elements. Also
#line 3360
   * makes vectorisation easy */
#line 3360
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3360
    ni=Min(nelems-j,LOOPCNT);
#line 3360
    if (realign) {
#line 3360
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3360
      xp = tmp;
#line 3360
    } else {
#line 3360
      xp = (uint *) *xpp;
#line 3360
    }
#line 3360
   /* copy the next block */
#line 3360
#pragma cdir loopcnt=LOOPCNT
#line 3360
#pragma cdir shortloop
#line 3360
    for (i=0; i<ni; i++) {
#line 3360
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3360
     /* test for range errors (not always needed but do it anyway) */
#line 3360
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3360
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3360
      nrange += xp[i] > LONG_MAX ;
#line 3360
    }
#line 3360
   /* update xpp and tp */
#line 3360
    if (realign) xp = (uint *) *xpp;
#line 3360
    xp += ni;
#line 3360
    tp += ni;
#line 3360
    *xpp = (void*)xp;
#line 3360
  }
#line 3360
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3360

#line 3360
#else   /* not SX */
#line 3360
	const char *xp = (const char *) *xpp;
#line 3360
	int status = NC_NOERR;
#line 3360

#line 3360
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3360
	{
#line 3360
		const int lstatus = ncx_get_uint_long(xp, tp);
#line 3360
		if (status == NC_NOERR) /* report the first encountered error */
#line 3360
			status = lstatus;
#line 3360
	}
#line 3360

#line 3360
	*xpp = (const void *)xp;
#line 3360
	return status;
#line 3360
#endif
#line 3360
}
#line 3360

int
#line 3361
ncx_getn_uint_float(const void **xpp, size_t nelems, float *tp)
#line 3361
{
#line 3361
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3361

#line 3361
 /* basic algorithm is:
#line 3361
  *   - ensure sane alignment of input data
#line 3361
  *   - copy (conversion happens automatically) input data
#line 3361
  *     to output
#line 3361
  *   - update xpp to point at next unconverted input, and tp to point
#line 3361
  *     at next location for converted output
#line 3361
  */
#line 3361
  long i, j, ni;
#line 3361
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3361
  uint *xp;
#line 3361
  int nrange = 0;         /* number of range errors */
#line 3361
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3361
  long cxp = (long) *((char**)xpp);
#line 3361

#line 3361
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3361
  /* sjl: manually stripmine so we can limit amount of
#line 3361
   * vector work space reserved to LOOPCNT elements. Also
#line 3361
   * makes vectorisation easy */
#line 3361
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3361
    ni=Min(nelems-j,LOOPCNT);
#line 3361
    if (realign) {
#line 3361
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3361
      xp = tmp;
#line 3361
    } else {
#line 3361
      xp = (uint *) *xpp;
#line 3361
    }
#line 3361
   /* copy the next block */
#line 3361
#pragma cdir loopcnt=LOOPCNT
#line 3361
#pragma cdir shortloop
#line 3361
    for (i=0; i<ni; i++) {
#line 3361
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3361
     /* test for range errors (not always needed but do it anyway) */
#line 3361
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3361
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3361
      nrange += xp[i] > FLOAT_MAX ;
#line 3361
    }
#line 3361
   /* update xpp and tp */
#line 3361
    if (realign) xp = (uint *) *xpp;
#line 3361
    xp += ni;
#line 3361
    tp += ni;
#line 3361
    *xpp = (void*)xp;
#line 3361
  }
#line 3361
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3361

#line 3361
#else   /* not SX */
#line 3361
	const char *xp = (const char *) *xpp;
#line 3361
	int status = NC_NOERR;
#line 3361

#line 3361
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3361
	{
#line 3361
		const int lstatus = ncx_get_uint_float(xp, tp);
#line 3361
		if (status == NC_NOERR) /* report the first encountered error */
#line 3361
			status = lstatus;
#line 3361
	}
#line 3361

#line 3361
	*xpp = (const void *)xp;
#line 3361
	return status;
#line 3361
#endif
#line 3361
}
#line 3361

int
#line 3362
ncx_getn_uint_double(const void **xpp, size_t nelems, double *tp)
#line 3362
{
#line 3362
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3362

#line 3362
 /* basic algorithm is:
#line 3362
  *   - ensure sane alignment of input data
#line 3362
  *   - copy (conversion happens automatically) input data
#line 3362
  *     to output
#line 3362
  *   - update xpp to point at next unconverted input, and tp to point
#line 3362
  *     at next location for converted output
#line 3362
  */
#line 3362
  long i, j, ni;
#line 3362
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3362
  uint *xp;
#line 3362
  int nrange = 0;         /* number of range errors */
#line 3362
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3362
  long cxp = (long) *((char**)xpp);
#line 3362

#line 3362
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3362
  /* sjl: manually stripmine so we can limit amount of
#line 3362
   * vector work space reserved to LOOPCNT elements. Also
#line 3362
   * makes vectorisation easy */
#line 3362
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3362
    ni=Min(nelems-j,LOOPCNT);
#line 3362
    if (realign) {
#line 3362
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3362
      xp = tmp;
#line 3362
    } else {
#line 3362
      xp = (uint *) *xpp;
#line 3362
    }
#line 3362
   /* copy the next block */
#line 3362
#pragma cdir loopcnt=LOOPCNT
#line 3362
#pragma cdir shortloop
#line 3362
    for (i=0; i<ni; i++) {
#line 3362
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3362
     /* test for range errors (not always needed but do it anyway) */
#line 3362
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3362
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3362
      nrange += xp[i] > DOUBLE_MAX ;
#line 3362
    }
#line 3362
   /* update xpp and tp */
#line 3362
    if (realign) xp = (uint *) *xpp;
#line 3362
    xp += ni;
#line 3362
    tp += ni;
#line 3362
    *xpp = (void*)xp;
#line 3362
  }
#line 3362
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3362

#line 3362
#else   /* not SX */
#line 3362
	const char *xp = (const char *) *xpp;
#line 3362
	int status = NC_NOERR;
#line 3362

#line 3362
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3362
	{
#line 3362
		const int lstatus = ncx_get_uint_double(xp, tp);
#line 3362
		if (status == NC_NOERR) /* report the first encountered error */
#line 3362
			status = lstatus;
#line 3362
	}
#line 3362

#line 3362
	*xpp = (const void *)xp;
#line 3362
	return status;
#line 3362
#endif
#line 3362
}
#line 3362

int
#line 3363
ncx_getn_uint_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3363
{
#line 3363
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3363

#line 3363
 /* basic algorithm is:
#line 3363
  *   - ensure sane alignment of input data
#line 3363
  *   - copy (conversion happens automatically) input data
#line 3363
  *     to output
#line 3363
  *   - update xpp to point at next unconverted input, and tp to point
#line 3363
  *     at next location for converted output
#line 3363
  */
#line 3363
  long i, j, ni;
#line 3363
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3363
  uint *xp;
#line 3363
  int nrange = 0;         /* number of range errors */
#line 3363
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3363
  long cxp = (long) *((char**)xpp);
#line 3363

#line 3363
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3363
  /* sjl: manually stripmine so we can limit amount of
#line 3363
   * vector work space reserved to LOOPCNT elements. Also
#line 3363
   * makes vectorisation easy */
#line 3363
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3363
    ni=Min(nelems-j,LOOPCNT);
#line 3363
    if (realign) {
#line 3363
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3363
      xp = tmp;
#line 3363
    } else {
#line 3363
      xp = (uint *) *xpp;
#line 3363
    }
#line 3363
   /* copy the next block */
#line 3363
#pragma cdir loopcnt=LOOPCNT
#line 3363
#pragma cdir shortloop
#line 3363
    for (i=0; i<ni; i++) {
#line 3363
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3363
     /* test for range errors (not always needed but do it anyway) */
#line 3363
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3363
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3363
      nrange += xp[i] > LONGLONG_MAX ;
#line 3363
    }
#line 3363
   /* update xpp and tp */
#line 3363
    if (realign) xp = (uint *) *xpp;
#line 3363
    xp += ni;
#line 3363
    tp += ni;
#line 3363
    *xpp = (void*)xp;
#line 3363
  }
#line 3363
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3363

#line 3363
#else   /* not SX */
#line 3363
	const char *xp = (const char *) *xpp;
#line 3363
	int status = NC_NOERR;
#line 3363

#line 3363
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3363
	{
#line 3363
		const int lstatus = ncx_get_uint_longlong(xp, tp);
#line 3363
		if (status == NC_NOERR) /* report the first encountered error */
#line 3363
			status = lstatus;
#line 3363
	}
#line 3363

#line 3363
	*xpp = (const void *)xp;
#line 3363
	return status;
#line 3363
#endif
#line 3363
}
#line 3363

int
#line 3364
ncx_getn_uint_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3364
{
#line 3364
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3364

#line 3364
 /* basic algorithm is:
#line 3364
  *   - ensure sane alignment of input data
#line 3364
  *   - copy (conversion happens automatically) input data
#line 3364
  *     to output
#line 3364
  *   - update xpp to point at next unconverted input, and tp to point
#line 3364
  *     at next location for converted output
#line 3364
  */
#line 3364
  long i, j, ni;
#line 3364
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3364
  uint *xp;
#line 3364
  int nrange = 0;         /* number of range errors */
#line 3364
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3364
  long cxp = (long) *((char**)xpp);
#line 3364

#line 3364
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3364
  /* sjl: manually stripmine so we can limit amount of
#line 3364
   * vector work space reserved to LOOPCNT elements. Also
#line 3364
   * makes vectorisation easy */
#line 3364
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3364
    ni=Min(nelems-j,LOOPCNT);
#line 3364
    if (realign) {
#line 3364
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3364
      xp = tmp;
#line 3364
    } else {
#line 3364
      xp = (uint *) *xpp;
#line 3364
    }
#line 3364
   /* copy the next block */
#line 3364
#pragma cdir loopcnt=LOOPCNT
#line 3364
#pragma cdir shortloop
#line 3364
    for (i=0; i<ni; i++) {
#line 3364
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3364
     /* test for range errors (not always needed but do it anyway) */
#line 3364
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3364
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3364
      nrange += xp[i] > UCHAR_MAX ;
#line 3364
    }
#line 3364
   /* update xpp and tp */
#line 3364
    if (realign) xp = (uint *) *xpp;
#line 3364
    xp += ni;
#line 3364
    tp += ni;
#line 3364
    *xpp = (void*)xp;
#line 3364
  }
#line 3364
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3364

#line 3364
#else   /* not SX */
#line 3364
	const char *xp = (const char *) *xpp;
#line 3364
	int status = NC_NOERR;
#line 3364

#line 3364
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3364
	{
#line 3364
		const int lstatus = ncx_get_uint_uchar(xp, tp);
#line 3364
		if (status == NC_NOERR) /* report the first encountered error */
#line 3364
			status = lstatus;
#line 3364
	}
#line 3364

#line 3364
	*xpp = (const void *)xp;
#line 3364
	return status;
#line 3364
#endif
#line 3364
}
#line 3364

int
#line 3365
ncx_getn_uint_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3365
{
#line 3365
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3365

#line 3365
 /* basic algorithm is:
#line 3365
  *   - ensure sane alignment of input data
#line 3365
  *   - copy (conversion happens automatically) input data
#line 3365
  *     to output
#line 3365
  *   - update xpp to point at next unconverted input, and tp to point
#line 3365
  *     at next location for converted output
#line 3365
  */
#line 3365
  long i, j, ni;
#line 3365
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3365
  uint *xp;
#line 3365
  int nrange = 0;         /* number of range errors */
#line 3365
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3365
  long cxp = (long) *((char**)xpp);
#line 3365

#line 3365
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3365
  /* sjl: manually stripmine so we can limit amount of
#line 3365
   * vector work space reserved to LOOPCNT elements. Also
#line 3365
   * makes vectorisation easy */
#line 3365
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3365
    ni=Min(nelems-j,LOOPCNT);
#line 3365
    if (realign) {
#line 3365
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3365
      xp = tmp;
#line 3365
    } else {
#line 3365
      xp = (uint *) *xpp;
#line 3365
    }
#line 3365
   /* copy the next block */
#line 3365
#pragma cdir loopcnt=LOOPCNT
#line 3365
#pragma cdir shortloop
#line 3365
    for (i=0; i<ni; i++) {
#line 3365
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3365
     /* test for range errors (not always needed but do it anyway) */
#line 3365
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3365
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3365
      nrange += xp[i] > USHORT_MAX ;
#line 3365
    }
#line 3365
   /* update xpp and tp */
#line 3365
    if (realign) xp = (uint *) *xpp;
#line 3365
    xp += ni;
#line 3365
    tp += ni;
#line 3365
    *xpp = (void*)xp;
#line 3365
  }
#line 3365
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3365

#line 3365
#else   /* not SX */
#line 3365
	const char *xp = (const char *) *xpp;
#line 3365
	int status = NC_NOERR;
#line 3365

#line 3365
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3365
	{
#line 3365
		const int lstatus = ncx_get_uint_ushort(xp, tp);
#line 3365
		if (status == NC_NOERR) /* report the first encountered error */
#line 3365
			status = lstatus;
#line 3365
	}
#line 3365

#line 3365
	*xpp = (const void *)xp;
#line 3365
	return status;
#line 3365
#endif
#line 3365
}
#line 3365

int
#line 3366
ncx_getn_uint_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3366
{
#line 3366
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3366

#line 3366
 /* basic algorithm is:
#line 3366
  *   - ensure sane alignment of input data
#line 3366
  *   - copy (conversion happens automatically) input data
#line 3366
  *     to output
#line 3366
  *   - update xpp to point at next unconverted input, and tp to point
#line 3366
  *     at next location for converted output
#line 3366
  */
#line 3366
  long i, j, ni;
#line 3366
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3366
  uint *xp;
#line 3366
  int nrange = 0;         /* number of range errors */
#line 3366
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3366
  long cxp = (long) *((char**)xpp);
#line 3366

#line 3366
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3366
  /* sjl: manually stripmine so we can limit amount of
#line 3366
   * vector work space reserved to LOOPCNT elements. Also
#line 3366
   * makes vectorisation easy */
#line 3366
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3366
    ni=Min(nelems-j,LOOPCNT);
#line 3366
    if (realign) {
#line 3366
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3366
      xp = tmp;
#line 3366
    } else {
#line 3366
      xp = (uint *) *xpp;
#line 3366
    }
#line 3366
   /* copy the next block */
#line 3366
#pragma cdir loopcnt=LOOPCNT
#line 3366
#pragma cdir shortloop
#line 3366
    for (i=0; i<ni; i++) {
#line 3366
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3366
     /* test for range errors (not always needed but do it anyway) */
#line 3366
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3366
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3366
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3366
    }
#line 3366
   /* update xpp and tp */
#line 3366
    if (realign) xp = (uint *) *xpp;
#line 3366
    xp += ni;
#line 3366
    tp += ni;
#line 3366
    *xpp = (void*)xp;
#line 3366
  }
#line 3366
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3366

#line 3366
#else   /* not SX */
#line 3366
	const char *xp = (const char *) *xpp;
#line 3366
	int status = NC_NOERR;
#line 3366

#line 3366
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3366
	{
#line 3366
		const int lstatus = ncx_get_uint_ulonglong(xp, tp);
#line 3366
		if (status == NC_NOERR) /* report the first encountered error */
#line 3366
			status = lstatus;
#line 3366
	}
#line 3366

#line 3366
	*xpp = (const void *)xp;
#line 3366
	return status;
#line 3366
#endif
#line 3366
}
#line 3366


#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const unsigned int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3382
ncx_putn_uint_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3382
{
#line 3382
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3382

#line 3382
 /* basic algorithm is:
#line 3382
  *   - ensure sane alignment of output data
#line 3382
  *   - copy (conversion happens automatically) input data
#line 3382
  *     to output
#line 3382
  *   - update tp to point at next unconverted input, and xpp to point
#line 3382
  *     at next location for converted output
#line 3382
  */
#line 3382
  long i, j, ni;
#line 3382
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3382
  uint *xp;
#line 3382
  int nrange = 0;         /* number of range errors */
#line 3382
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3382
  long cxp = (long) *((char**)xpp);
#line 3382

#line 3382
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3382
  /* sjl: manually stripmine so we can limit amount of
#line 3382
   * vector work space reserved to LOOPCNT elements. Also
#line 3382
   * makes vectorisation easy */
#line 3382
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3382
    ni=Min(nelems-j,LOOPCNT);
#line 3382
    if (realign) {
#line 3382
      xp = tmp;
#line 3382
    } else {
#line 3382
      xp = (uint *) *xpp;
#line 3382
    }
#line 3382
   /* copy the next block */
#line 3382
#pragma cdir loopcnt=LOOPCNT
#line 3382
#pragma cdir shortloop
#line 3382
    for (i=0; i<ni; i++) {
#line 3382
      /* the normal case: */
#line 3382
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3382
     /* test for range errors (not always needed but do it anyway) */
#line 3382
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3382
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3382
      nrange += tp[i] > X_UINT_MAX ;
#line 3382
    }
#line 3382
   /* copy workspace back if necessary */
#line 3382
    if (realign) {
#line 3382
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3382
      xp = (uint *) *xpp;
#line 3382
    }
#line 3382
   /* update xpp and tp */
#line 3382
    xp += ni;
#line 3382
    tp += ni;
#line 3382
    *xpp = (void*)xp;
#line 3382
  }
#line 3382
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3382

#line 3382
#else   /* not SX */
#line 3382

#line 3382
	char *xp = (char *) *xpp;
#line 3382
	int status = NC_NOERR;
#line 3382

#line 3382
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3382
	{
#line 3382
		int lstatus = ncx_put_uint_uint(xp, tp, fillp);
#line 3382
		if (status == NC_NOERR) /* report the first encountered error */
#line 3382
			status = lstatus;
#line 3382
	}
#line 3382

#line 3382
	*xpp = (void *)xp;
#line 3382
	return status;
#line 3382
#endif
#line 3382
}
#line 3382

#endif
int
#line 3384
ncx_putn_uint_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3384
{
#line 3384
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3384

#line 3384
 /* basic algorithm is:
#line 3384
  *   - ensure sane alignment of output data
#line 3384
  *   - copy (conversion happens automatically) input data
#line 3384
  *     to output
#line 3384
  *   - update tp to point at next unconverted input, and xpp to point
#line 3384
  *     at next location for converted output
#line 3384
  */
#line 3384
  long i, j, ni;
#line 3384
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3384
  uint *xp;
#line 3384
  int nrange = 0;         /* number of range errors */
#line 3384
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3384
  long cxp = (long) *((char**)xpp);
#line 3384

#line 3384
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3384
  /* sjl: manually stripmine so we can limit amount of
#line 3384
   * vector work space reserved to LOOPCNT elements. Also
#line 3384
   * makes vectorisation easy */
#line 3384
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3384
    ni=Min(nelems-j,LOOPCNT);
#line 3384
    if (realign) {
#line 3384
      xp = tmp;
#line 3384
    } else {
#line 3384
      xp = (uint *) *xpp;
#line 3384
    }
#line 3384
   /* copy the next block */
#line 3384
#pragma cdir loopcnt=LOOPCNT
#line 3384
#pragma cdir shortloop
#line 3384
    for (i=0; i<ni; i++) {
#line 3384
      /* the normal case: */
#line 3384
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3384
     /* test for range errors (not always needed but do it anyway) */
#line 3384
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3384
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3384
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3384
    }
#line 3384
   /* copy workspace back if necessary */
#line 3384
    if (realign) {
#line 3384
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3384
      xp = (uint *) *xpp;
#line 3384
    }
#line 3384
   /* update xpp and tp */
#line 3384
    xp += ni;
#line 3384
    tp += ni;
#line 3384
    *xpp = (void*)xp;
#line 3384
  }
#line 3384
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3384

#line 3384
#else   /* not SX */
#line 3384

#line 3384
	char *xp = (char *) *xpp;
#line 3384
	int status = NC_NOERR;
#line 3384

#line 3384
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3384
	{
#line 3384
		int lstatus = ncx_put_uint_schar(xp, tp, fillp);
#line 3384
		if (status == NC_NOERR) /* report the first encountered error */
#line 3384
			status = lstatus;
#line 3384
	}
#line 3384

#line 3384
	*xpp = (void *)xp;
#line 3384
	return status;
#line 3384
#endif
#line 3384
}
#line 3384

int
#line 3385
ncx_putn_uint_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3385
{
#line 3385
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3385

#line 3385
 /* basic algorithm is:
#line 3385
  *   - ensure sane alignment of output data
#line 3385
  *   - copy (conversion happens automatically) input data
#line 3385
  *     to output
#line 3385
  *   - update tp to point at next unconverted input, and xpp to point
#line 3385
  *     at next location for converted output
#line 3385
  */
#line 3385
  long i, j, ni;
#line 3385
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3385
  uint *xp;
#line 3385
  int nrange = 0;         /* number of range errors */
#line 3385
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3385
  long cxp = (long) *((char**)xpp);
#line 3385

#line 3385
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3385
  /* sjl: manually stripmine so we can limit amount of
#line 3385
   * vector work space reserved to LOOPCNT elements. Also
#line 3385
   * makes vectorisation easy */
#line 3385
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3385
    ni=Min(nelems-j,LOOPCNT);
#line 3385
    if (realign) {
#line 3385
      xp = tmp;
#line 3385
    } else {
#line 3385
      xp = (uint *) *xpp;
#line 3385
    }
#line 3385
   /* copy the next block */
#line 3385
#pragma cdir loopcnt=LOOPCNT
#line 3385
#pragma cdir shortloop
#line 3385
    for (i=0; i<ni; i++) {
#line 3385
      /* the normal case: */
#line 3385
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3385
     /* test for range errors (not always needed but do it anyway) */
#line 3385
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3385
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3385
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3385
    }
#line 3385
   /* copy workspace back if necessary */
#line 3385
    if (realign) {
#line 3385
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3385
      xp = (uint *) *xpp;
#line 3385
    }
#line 3385
   /* update xpp and tp */
#line 3385
    xp += ni;
#line 3385
    tp += ni;
#line 3385
    *xpp = (void*)xp;
#line 3385
  }
#line 3385
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3385

#line 3385
#else   /* not SX */
#line 3385

#line 3385
	char *xp = (char *) *xpp;
#line 3385
	int status = NC_NOERR;
#line 3385

#line 3385
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3385
	{
#line 3385
		int lstatus = ncx_put_uint_short(xp, tp, fillp);
#line 3385
		if (status == NC_NOERR) /* report the first encountered error */
#line 3385
			status = lstatus;
#line 3385
	}
#line 3385

#line 3385
	*xpp = (void *)xp;
#line 3385
	return status;
#line 3385
#endif
#line 3385
}
#line 3385

int
#line 3386
ncx_putn_uint_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3386
{
#line 3386
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3386

#line 3386
 /* basic algorithm is:
#line 3386
  *   - ensure sane alignment of output data
#line 3386
  *   - copy (conversion happens automatically) input data
#line 3386
  *     to output
#line 3386
  *   - update tp to point at next unconverted input, and xpp to point
#line 3386
  *     at next location for converted output
#line 3386
  */
#line 3386
  long i, j, ni;
#line 3386
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3386
  uint *xp;
#line 3386
  int nrange = 0;         /* number of range errors */
#line 3386
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3386
  long cxp = (long) *((char**)xpp);
#line 3386

#line 3386
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3386
  /* sjl: manually stripmine so we can limit amount of
#line 3386
   * vector work space reserved to LOOPCNT elements. Also
#line 3386
   * makes vectorisation easy */
#line 3386
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3386
    ni=Min(nelems-j,LOOPCNT);
#line 3386
    if (realign) {
#line 3386
      xp = tmp;
#line 3386
    } else {
#line 3386
      xp = (uint *) *xpp;
#line 3386
    }
#line 3386
   /* copy the next block */
#line 3386
#pragma cdir loopcnt=LOOPCNT
#line 3386
#pragma cdir shortloop
#line 3386
    for (i=0; i<ni; i++) {
#line 3386
      /* the normal case: */
#line 3386
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3386
     /* test for range errors (not always needed but do it anyway) */
#line 3386
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3386
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3386
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3386
    }
#line 3386
   /* copy workspace back if necessary */
#line 3386
    if (realign) {
#line 3386
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3386
      xp = (uint *) *xpp;
#line 3386
    }
#line 3386
   /* update xpp and tp */
#line 3386
    xp += ni;
#line 3386
    tp += ni;
#line 3386
    *xpp = (void*)xp;
#line 3386
  }
#line 3386
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3386

#line 3386
#else   /* not SX */
#line 3386

#line 3386
	char *xp = (char *) *xpp;
#line 3386
	int status = NC_NOERR;
#line 3386

#line 3386
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3386
	{
#line 3386
		int lstatus = ncx_put_uint_int(xp, tp, fillp);
#line 3386
		if (status == NC_NOERR) /* report the first encountered error */
#line 3386
			status = lstatus;
#line 3386
	}
#line 3386

#line 3386
	*xpp = (void *)xp;
#line 3386
	return status;
#line 3386
#endif
#line 3386
}
#line 3386

int
#line 3387
ncx_putn_uint_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3387
{
#line 3387
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3387

#line 3387
 /* basic algorithm is:
#line 3387
  *   - ensure sane alignment of output data
#line 3387
  *   - copy (conversion happens automatically) input data
#line 3387
  *     to output
#line 3387
  *   - update tp to point at next unconverted input, and xpp to point
#line 3387
  *     at next location for converted output
#line 3387
  */
#line 3387
  long i, j, ni;
#line 3387
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3387
  uint *xp;
#line 3387
  int nrange = 0;         /* number of range errors */
#line 3387
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3387
  long cxp = (long) *((char**)xpp);
#line 3387

#line 3387
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3387
  /* sjl: manually stripmine so we can limit amount of
#line 3387
   * vector work space reserved to LOOPCNT elements. Also
#line 3387
   * makes vectorisation easy */
#line 3387
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3387
    ni=Min(nelems-j,LOOPCNT);
#line 3387
    if (realign) {
#line 3387
      xp = tmp;
#line 3387
    } else {
#line 3387
      xp = (uint *) *xpp;
#line 3387
    }
#line 3387
   /* copy the next block */
#line 3387
#pragma cdir loopcnt=LOOPCNT
#line 3387
#pragma cdir shortloop
#line 3387
    for (i=0; i<ni; i++) {
#line 3387
      /* the normal case: */
#line 3387
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3387
     /* test for range errors (not always needed but do it anyway) */
#line 3387
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3387
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3387
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3387
    }
#line 3387
   /* copy workspace back if necessary */
#line 3387
    if (realign) {
#line 3387
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3387
      xp = (uint *) *xpp;
#line 3387
    }
#line 3387
   /* update xpp and tp */
#line 3387
    xp += ni;
#line 3387
    tp += ni;
#line 3387
    *xpp = (void*)xp;
#line 3387
  }
#line 3387
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3387

#line 3387
#else   /* not SX */
#line 3387

#line 3387
	char *xp = (char *) *xpp;
#line 3387
	int status = NC_NOERR;
#line 3387

#line 3387
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3387
	{
#line 3387
		int lstatus = ncx_put_uint_long(xp, tp, fillp);
#line 3387
		if (status == NC_NOERR) /* report the first encountered error */
#line 3387
			status = lstatus;
#line 3387
	}
#line 3387

#line 3387
	*xpp = (void *)xp;
#line 3387
	return status;
#line 3387
#endif
#line 3387
}
#line 3387

int
#line 3388
ncx_putn_uint_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3388
{
#line 3388
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3388

#line 3388
 /* basic algorithm is:
#line 3388
  *   - ensure sane alignment of output data
#line 3388
  *   - copy (conversion happens automatically) input data
#line 3388
  *     to output
#line 3388
  *   - update tp to point at next unconverted input, and xpp to point
#line 3388
  *     at next location for converted output
#line 3388
  */
#line 3388
  long i, j, ni;
#line 3388
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3388
  uint *xp;
#line 3388
  int nrange = 0;         /* number of range errors */
#line 3388
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3388
  long cxp = (long) *((char**)xpp);
#line 3388

#line 3388
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3388
  /* sjl: manually stripmine so we can limit amount of
#line 3388
   * vector work space reserved to LOOPCNT elements. Also
#line 3388
   * makes vectorisation easy */
#line 3388
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3388
    ni=Min(nelems-j,LOOPCNT);
#line 3388
    if (realign) {
#line 3388
      xp = tmp;
#line 3388
    } else {
#line 3388
      xp = (uint *) *xpp;
#line 3388
    }
#line 3388
   /* copy the next block */
#line 3388
#pragma cdir loopcnt=LOOPCNT
#line 3388
#pragma cdir shortloop
#line 3388
    for (i=0; i<ni; i++) {
#line 3388
      /* the normal case: */
#line 3388
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3388
     /* test for range errors (not always needed but do it anyway) */
#line 3388
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3388
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3388
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3388
    }
#line 3388
   /* copy workspace back if necessary */
#line 3388
    if (realign) {
#line 3388
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3388
      xp = (uint *) *xpp;
#line 3388
    }
#line 3388
   /* update xpp and tp */
#line 3388
    xp += ni;
#line 3388
    tp += ni;
#line 3388
    *xpp = (void*)xp;
#line 3388
  }
#line 3388
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3388

#line 3388
#else   /* not SX */
#line 3388

#line 3388
	char *xp = (char *) *xpp;
#line 3388
	int status = NC_NOERR;
#line 3388

#line 3388
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3388
	{
#line 3388
		int lstatus = ncx_put_uint_float(xp, tp, fillp);
#line 3388
		if (status == NC_NOERR) /* report the first encountered error */
#line 3388
			status = lstatus;
#line 3388
	}
#line 3388

#line 3388
	*xpp = (void *)xp;
#line 3388
	return status;
#line 3388
#endif
#line 3388
}
#line 3388

int
#line 3389
ncx_putn_uint_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3389
{
#line 3389
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3389

#line 3389
 /* basic algorithm is:
#line 3389
  *   - ensure sane alignment of output data
#line 3389
  *   - copy (conversion happens automatically) input data
#line 3389
  *     to output
#line 3389
  *   - update tp to point at next unconverted input, and xpp to point
#line 3389
  *     at next location for converted output
#line 3389
  */
#line 3389
  long i, j, ni;
#line 3389
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3389
  uint *xp;
#line 3389
  int nrange = 0;         /* number of range errors */
#line 3389
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3389
  long cxp = (long) *((char**)xpp);
#line 3389

#line 3389
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3389
  /* sjl: manually stripmine so we can limit amount of
#line 3389
   * vector work space reserved to LOOPCNT elements. Also
#line 3389
   * makes vectorisation easy */
#line 3389
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3389
    ni=Min(nelems-j,LOOPCNT);
#line 3389
    if (realign) {
#line 3389
      xp = tmp;
#line 3389
    } else {
#line 3389
      xp = (uint *) *xpp;
#line 3389
    }
#line 3389
   /* copy the next block */
#line 3389
#pragma cdir loopcnt=LOOPCNT
#line 3389
#pragma cdir shortloop
#line 3389
    for (i=0; i<ni; i++) {
#line 3389
      /* the normal case: */
#line 3389
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3389
     /* test for range errors (not always needed but do it anyway) */
#line 3389
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3389
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3389
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3389
    }
#line 3389
   /* copy workspace back if necessary */
#line 3389
    if (realign) {
#line 3389
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3389
      xp = (uint *) *xpp;
#line 3389
    }
#line 3389
   /* update xpp and tp */
#line 3389
    xp += ni;
#line 3389
    tp += ni;
#line 3389
    *xpp = (void*)xp;
#line 3389
  }
#line 3389
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3389

#line 3389
#else   /* not SX */
#line 3389

#line 3389
	char *xp = (char *) *xpp;
#line 3389
	int status = NC_NOERR;
#line 3389

#line 3389
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3389
	{
#line 3389
		int lstatus = ncx_put_uint_double(xp, tp, fillp);
#line 3389
		if (status == NC_NOERR) /* report the first encountered error */
#line 3389
			status = lstatus;
#line 3389
	}
#line 3389

#line 3389
	*xpp = (void *)xp;
#line 3389
	return status;
#line 3389
#endif
#line 3389
}
#line 3389

int
#line 3390
ncx_putn_uint_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3390
{
#line 3390
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3390

#line 3390
 /* basic algorithm is:
#line 3390
  *   - ensure sane alignment of output data
#line 3390
  *   - copy (conversion happens automatically) input data
#line 3390
  *     to output
#line 3390
  *   - update tp to point at next unconverted input, and xpp to point
#line 3390
  *     at next location for converted output
#line 3390
  */
#line 3390
  long i, j, ni;
#line 3390
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3390
  uint *xp;
#line 3390
  int nrange = 0;         /* number of range errors */
#line 3390
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3390
  long cxp = (long) *((char**)xpp);
#line 3390

#line 3390
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3390
  /* sjl: manually stripmine so we can limit amount of
#line 3390
   * vector work space reserved to LOOPCNT elements. Also
#line 3390
   * makes vectorisation easy */
#line 3390
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3390
    ni=Min(nelems-j,LOOPCNT);
#line 3390
    if (realign) {
#line 3390
      xp = tmp;
#line 3390
    } else {
#line 3390
      xp = (uint *) *xpp;
#line 3390
    }
#line 3390
   /* copy the next block */
#line 3390
#pragma cdir loopcnt=LOOPCNT
#line 3390
#pragma cdir shortloop
#line 3390
    for (i=0; i<ni; i++) {
#line 3390
      /* the normal case: */
#line 3390
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3390
     /* test for range errors (not always needed but do it anyway) */
#line 3390
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3390
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3390
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3390
    }
#line 3390
   /* copy workspace back if necessary */
#line 3390
    if (realign) {
#line 3390
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3390
      xp = (uint *) *xpp;
#line 3390
    }
#line 3390
   /* update xpp and tp */
#line 3390
    xp += ni;
#line 3390
    tp += ni;
#line 3390
    *xpp = (void*)xp;
#line 3390
  }
#line 3390
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3390

#line 3390
#else   /* not SX */
#line 3390

#line 3390
	char *xp = (char *) *xpp;
#line 3390
	int status = NC_NOERR;
#line 3390

#line 3390
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3390
	{
#line 3390
		int lstatus = ncx_put_uint_longlong(xp, tp, fillp);
#line 3390
		if (status == NC_NOERR) /* report the first encountered error */
#line 3390
			status = lstatus;
#line 3390
	}
#line 3390

#line 3390
	*xpp = (void *)xp;
#line 3390
	return status;
#line 3390
#endif
#line 3390
}
#line 3390

int
#line 3391
ncx_putn_uint_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3391
{
#line 3391
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3391

#line 3391
 /* basic algorithm is:
#line 3391
  *   - ensure sane alignment of output data
#line 3391
  *   - copy (conversion happens automatically) input data
#line 3391
  *     to output
#line 3391
  *   - update tp to point at next unconverted input, and xpp to point
#line 3391
  *     at next location for converted output
#line 3391
  */
#line 3391
  long i, j, ni;
#line 3391
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3391
  uint *xp;
#line 3391
  int nrange = 0;         /* number of range errors */
#line 3391
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3391
  long cxp = (long) *((char**)xpp);
#line 3391

#line 3391
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3391
  /* sjl: manually stripmine so we can limit amount of
#line 3391
   * vector work space reserved to LOOPCNT elements. Also
#line 3391
   * makes vectorisation easy */
#line 3391
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3391
    ni=Min(nelems-j,LOOPCNT);
#line 3391
    if (realign) {
#line 3391
      xp = tmp;
#line 3391
    } else {
#line 3391
      xp = (uint *) *xpp;
#line 3391
    }
#line 3391
   /* copy the next block */
#line 3391
#pragma cdir loopcnt=LOOPCNT
#line 3391
#pragma cdir shortloop
#line 3391
    for (i=0; i<ni; i++) {
#line 3391
      /* the normal case: */
#line 3391
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3391
     /* test for range errors (not always needed but do it anyway) */
#line 3391
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3391
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3391
      nrange += tp[i] > X_UINT_MAX ;
#line 3391
    }
#line 3391
   /* copy workspace back if necessary */
#line 3391
    if (realign) {
#line 3391
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3391
      xp = (uint *) *xpp;
#line 3391
    }
#line 3391
   /* update xpp and tp */
#line 3391
    xp += ni;
#line 3391
    tp += ni;
#line 3391
    *xpp = (void*)xp;
#line 3391
  }
#line 3391
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3391

#line 3391
#else   /* not SX */
#line 3391

#line 3391
	char *xp = (char *) *xpp;
#line 3391
	int status = NC_NOERR;
#line 3391

#line 3391
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3391
	{
#line 3391
		int lstatus = ncx_put_uint_uchar(xp, tp, fillp);
#line 3391
		if (status == NC_NOERR) /* report the first encountered error */
#line 3391
			status = lstatus;
#line 3391
	}
#line 3391

#line 3391
	*xpp = (void *)xp;
#line 3391
	return status;
#line 3391
#endif
#line 3391
}
#line 3391

int
#line 3392
ncx_putn_uint_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3392
{
#line 3392
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3392

#line 3392
 /* basic algorithm is:
#line 3392
  *   - ensure sane alignment of output data
#line 3392
  *   - copy (conversion happens automatically) input data
#line 3392
  *     to output
#line 3392
  *   - update tp to point at next unconverted input, and xpp to point
#line 3392
  *     at next location for converted output
#line 3392
  */
#line 3392
  long i, j, ni;
#line 3392
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3392
  uint *xp;
#line 3392
  int nrange = 0;         /* number of range errors */
#line 3392
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3392
  long cxp = (long) *((char**)xpp);
#line 3392

#line 3392
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3392
  /* sjl: manually stripmine so we can limit amount of
#line 3392
   * vector work space reserved to LOOPCNT elements. Also
#line 3392
   * makes vectorisation easy */
#line 3392
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3392
    ni=Min(nelems-j,LOOPCNT);
#line 3392
    if (realign) {
#line 3392
      xp = tmp;
#line 3392
    } else {
#line 3392
      xp = (uint *) *xpp;
#line 3392
    }
#line 3392
   /* copy the next block */
#line 3392
#pragma cdir loopcnt=LOOPCNT
#line 3392
#pragma cdir shortloop
#line 3392
    for (i=0; i<ni; i++) {
#line 3392
      /* the normal case: */
#line 3392
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3392
     /* test for range errors (not always needed but do it anyway) */
#line 3392
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3392
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3392
      nrange += tp[i] > X_UINT_MAX ;
#line 3392
    }
#line 3392
   /* copy workspace back if necessary */
#line 3392
    if (realign) {
#line 3392
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3392
      xp = (uint *) *xpp;
#line 3392
    }
#line 3392
   /* update xpp and tp */
#line 3392
    xp += ni;
#line 3392
    tp += ni;
#line 3392
    *xpp = (void*)xp;
#line 3392
  }
#line 3392
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3392

#line 3392
#else   /* not SX */
#line 3392

#line 3392
	char *xp = (char *) *xpp;
#line 3392
	int status = NC_NOERR;
#line 3392

#line 3392
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3392
	{
#line 3392
		int lstatus = ncx_put_uint_ushort(xp, tp, fillp);
#line 3392
		if (status == NC_NOERR) /* report the first encountered error */
#line 3392
			status = lstatus;
#line 3392
	}
#line 3392

#line 3392
	*xpp = (void *)xp;
#line 3392
	return status;
#line 3392
#endif
#line 3392
}
#line 3392

int
#line 3393
ncx_putn_uint_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3393
{
#line 3393
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3393

#line 3393
 /* basic algorithm is:
#line 3393
  *   - ensure sane alignment of output data
#line 3393
  *   - copy (conversion happens automatically) input data
#line 3393
  *     to output
#line 3393
  *   - update tp to point at next unconverted input, and xpp to point
#line 3393
  *     at next location for converted output
#line 3393
  */
#line 3393
  long i, j, ni;
#line 3393
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3393
  uint *xp;
#line 3393
  int nrange = 0;         /* number of range errors */
#line 3393
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3393
  long cxp = (long) *((char**)xpp);
#line 3393

#line 3393
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3393
  /* sjl: manually stripmine so we can limit amount of
#line 3393
   * vector work space reserved to LOOPCNT elements. Also
#line 3393
   * makes vectorisation easy */
#line 3393
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3393
    ni=Min(nelems-j,LOOPCNT);
#line 3393
    if (realign) {
#line 3393
      xp = tmp;
#line 3393
    } else {
#line 3393
      xp = (uint *) *xpp;
#line 3393
    }
#line 3393
   /* copy the next block */
#line 3393
#pragma cdir loopcnt=LOOPCNT
#line 3393
#pragma cdir shortloop
#line 3393
    for (i=0; i<ni; i++) {
#line 3393
      /* the normal case: */
#line 3393
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3393
     /* test for range errors (not always needed but do it anyway) */
#line 3393
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3393
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3393
      nrange += tp[i] > X_UINT_MAX ;
#line 3393
    }
#line 3393
   /* copy workspace back if necessary */
#line 3393
    if (realign) {
#line 3393
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3393
      xp = (uint *) *xpp;
#line 3393
    }
#line 3393
   /* update xpp and tp */
#line 3393
    xp += ni;
#line 3393
    tp += ni;
#line 3393
    *xpp = (void*)xp;
#line 3393
  }
#line 3393
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3393

#line 3393
#else   /* not SX */
#line 3393

#line 3393
	char *xp = (char *) *xpp;
#line 3393
	int status = NC_NOERR;
#line 3393

#line 3393
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3393
	{
#line 3393
		int lstatus = ncx_put_uint_ulonglong(xp, tp, fillp);
#line 3393
		if (status == NC_NOERR) /* report the first encountered error */
#line 3393
			status = lstatus;
#line 3393
	}
#line 3393

#line 3393
	*xpp = (void *)xp;
#line 3393
	return status;
#line 3393
#endif
#line 3393
}
#line 3393



/* float ---------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_FLOAT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while (ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 3419
		const struct ieee_single *const isp =
#line 3419
			 (const struct ieee_single *) (*xpp);
#line 3419
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 3419

#line 3419
		switch(exp) {
#line 3419
		case 0 :
#line 3419
			/* ieee subnormal */
#line 3419
			if (isp->mant_hi == min.ieee.mant_hi
#line 3419
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 3419
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 3419
			{
#line 3419
				*vsp = min.s;
#line 3419
			}
#line 3419
			else
#line 3419
			{
#line 3419
				unsigned mantissa = (isp->mant_hi << 16)
#line 3419
					 | isp->mant_lo_hi << 8
#line 3419
					 | isp->mant_lo_lo;
#line 3419
				unsigned tmp = mantissa >> 20;
#line 3419
				if (tmp >= 4) {
#line 3419
					vsp->exp = 2;
#line 3419
				} else if (tmp >= 2) {
#line 3419
					vsp->exp = 1;
#line 3419
				} else {
#line 3419
					*vsp = min.s;
#line 3419
					break;
#line 3419
				} /* else */
#line 3419
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 3419
				tmp <<= 3 - vsp->exp;
#line 3419
				vsp->mantissa2 = tmp;
#line 3419
				vsp->mantissa1 = (tmp >> 16);
#line 3419
			}
#line 3419
			break;
#line 3419
		case 0xfe :
#line 3419
		case 0xff :
#line 3419
			*vsp = max.s;
#line 3419
			break;
#line 3419
		default :
#line 3419
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 3419
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 3419
			vsp->mantissa1 = isp->mant_hi;
#line 3419
		}
#line 3419

#line 3419
		vsp->sign = isp->sign;
#line 3419


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
#line 3445
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
#line 3445
{
#line 3445
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3445

#line 3445
 /* basic algorithm is:
#line 3445
  *   - ensure sane alignment of input data
#line 3445
  *   - copy (conversion happens automatically) input data
#line 3445
  *     to output
#line 3445
  *   - update xpp to point at next unconverted input, and tp to point
#line 3445
  *     at next location for converted output
#line 3445
  */
#line 3445
  long i, j, ni;
#line 3445
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3445
  float *xp;
#line 3445
  int nrange = 0;         /* number of range errors */
#line 3445
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3445
  long cxp = (long) *((char**)xpp);
#line 3445

#line 3445
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3445
  /* sjl: manually stripmine so we can limit amount of
#line 3445
   * vector work space reserved to LOOPCNT elements. Also
#line 3445
   * makes vectorisation easy */
#line 3445
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3445
    ni=Min(nelems-j,LOOPCNT);
#line 3445
    if (realign) {
#line 3445
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3445
      xp = tmp;
#line 3445
    } else {
#line 3445
      xp = (float *) *xpp;
#line 3445
    }
#line 3445
   /* copy the next block */
#line 3445
#pragma cdir loopcnt=LOOPCNT
#line 3445
#pragma cdir shortloop
#line 3445
    for (i=0; i<ni; i++) {
#line 3445
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3445
     /* test for range errors (not always needed but do it anyway) */
#line 3445
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3445
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3445
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3445
    }
#line 3445
   /* update xpp and tp */
#line 3445
    if (realign) xp = (float *) *xpp;
#line 3445
    xp += ni;
#line 3445
    tp += ni;
#line 3445
    *xpp = (void*)xp;
#line 3445
  }
#line 3445
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3445

#line 3445
#else   /* not SX */
#line 3445
	const char *xp = (const char *) *xpp;
#line 3445
	int status = NC_NOERR;
#line 3445

#line 3445
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3445
	{
#line 3445
		const int lstatus = ncx_get_float_schar(xp, tp);
#line 3445
		if (status == NC_NOERR) /* report the first encountered error */
#line 3445
			status = lstatus;
#line 3445
	}
#line 3445

#line 3445
	*xpp = (const void *)xp;
#line 3445
	return status;
#line 3445
#endif
#line 3445
}
#line 3445

int
#line 3446
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
#line 3446
{
#line 3446
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3446

#line 3446
 /* basic algorithm is:
#line 3446
  *   - ensure sane alignment of input data
#line 3446
  *   - copy (conversion happens automatically) input data
#line 3446
  *     to output
#line 3446
  *   - update xpp to point at next unconverted input, and tp to point
#line 3446
  *     at next location for converted output
#line 3446
  */
#line 3446
  long i, j, ni;
#line 3446
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3446
  float *xp;
#line 3446
  int nrange = 0;         /* number of range errors */
#line 3446
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3446
  long cxp = (long) *((char**)xpp);
#line 3446

#line 3446
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3446
  /* sjl: manually stripmine so we can limit amount of
#line 3446
   * vector work space reserved to LOOPCNT elements. Also
#line 3446
   * makes vectorisation easy */
#line 3446
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3446
    ni=Min(nelems-j,LOOPCNT);
#line 3446
    if (realign) {
#line 3446
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3446
      xp = tmp;
#line 3446
    } else {
#line 3446
      xp = (float *) *xpp;
#line 3446
    }
#line 3446
   /* copy the next block */
#line 3446
#pragma cdir loopcnt=LOOPCNT
#line 3446
#pragma cdir shortloop
#line 3446
    for (i=0; i<ni; i++) {
#line 3446
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3446
     /* test for range errors (not always needed but do it anyway) */
#line 3446
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3446
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3446
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3446
    }
#line 3446
   /* update xpp and tp */
#line 3446
    if (realign) xp = (float *) *xpp;
#line 3446
    xp += ni;
#line 3446
    tp += ni;
#line 3446
    *xpp = (void*)xp;
#line 3446
  }
#line 3446
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3446

#line 3446
#else   /* not SX */
#line 3446
	const char *xp = (const char *) *xpp;
#line 3446
	int status = NC_NOERR;
#line 3446

#line 3446
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3446
	{
#line 3446
		const int lstatus = ncx_get_float_short(xp, tp);
#line 3446
		if (status == NC_NOERR) /* report the first encountered error */
#line 3446
			status = lstatus;
#line 3446
	}
#line 3446

#line 3446
	*xpp = (const void *)xp;
#line 3446
	return status;
#line 3446
#endif
#line 3446
}
#line 3446

int
#line 3447
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
#line 3447
{
#line 3447
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3447

#line 3447
 /* basic algorithm is:
#line 3447
  *   - ensure sane alignment of input data
#line 3447
  *   - copy (conversion happens automatically) input data
#line 3447
  *     to output
#line 3447
  *   - update xpp to point at next unconverted input, and tp to point
#line 3447
  *     at next location for converted output
#line 3447
  */
#line 3447
  long i, j, ni;
#line 3447
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3447
  float *xp;
#line 3447
  int nrange = 0;         /* number of range errors */
#line 3447
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3447
  long cxp = (long) *((char**)xpp);
#line 3447

#line 3447
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3447
  /* sjl: manually stripmine so we can limit amount of
#line 3447
   * vector work space reserved to LOOPCNT elements. Also
#line 3447
   * makes vectorisation easy */
#line 3447
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3447
    ni=Min(nelems-j,LOOPCNT);
#line 3447
    if (realign) {
#line 3447
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3447
      xp = tmp;
#line 3447
    } else {
#line 3447
      xp = (float *) *xpp;
#line 3447
    }
#line 3447
   /* copy the next block */
#line 3447
#pragma cdir loopcnt=LOOPCNT
#line 3447
#pragma cdir shortloop
#line 3447
    for (i=0; i<ni; i++) {
#line 3447
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3447
     /* test for range errors (not always needed but do it anyway) */
#line 3447
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3447
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3447
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3447
    }
#line 3447
   /* update xpp and tp */
#line 3447
    if (realign) xp = (float *) *xpp;
#line 3447
    xp += ni;
#line 3447
    tp += ni;
#line 3447
    *xpp = (void*)xp;
#line 3447
  }
#line 3447
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3447

#line 3447
#else   /* not SX */
#line 3447
	const char *xp = (const char *) *xpp;
#line 3447
	int status = NC_NOERR;
#line 3447

#line 3447
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3447
	{
#line 3447
		const int lstatus = ncx_get_float_int(xp, tp);
#line 3447
		if (status == NC_NOERR) /* report the first encountered error */
#line 3447
			status = lstatus;
#line 3447
	}
#line 3447

#line 3447
	*xpp = (const void *)xp;
#line 3447
	return status;
#line 3447
#endif
#line 3447
}
#line 3447

int
#line 3448
ncx_getn_float_long(const void **xpp, size_t nelems, long *tp)
#line 3448
{
#line 3448
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3448

#line 3448
 /* basic algorithm is:
#line 3448
  *   - ensure sane alignment of input data
#line 3448
  *   - copy (conversion happens automatically) input data
#line 3448
  *     to output
#line 3448
  *   - update xpp to point at next unconverted input, and tp to point
#line 3448
  *     at next location for converted output
#line 3448
  */
#line 3448
  long i, j, ni;
#line 3448
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3448
  float *xp;
#line 3448
  int nrange = 0;         /* number of range errors */
#line 3448
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3448
  long cxp = (long) *((char**)xpp);
#line 3448

#line 3448
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3448
  /* sjl: manually stripmine so we can limit amount of
#line 3448
   * vector work space reserved to LOOPCNT elements. Also
#line 3448
   * makes vectorisation easy */
#line 3448
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3448
    ni=Min(nelems-j,LOOPCNT);
#line 3448
    if (realign) {
#line 3448
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3448
      xp = tmp;
#line 3448
    } else {
#line 3448
      xp = (float *) *xpp;
#line 3448
    }
#line 3448
   /* copy the next block */
#line 3448
#pragma cdir loopcnt=LOOPCNT
#line 3448
#pragma cdir shortloop
#line 3448
    for (i=0; i<ni; i++) {
#line 3448
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3448
     /* test for range errors (not always needed but do it anyway) */
#line 3448
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3448
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3448
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3448
    }
#line 3448
   /* update xpp and tp */
#line 3448
    if (realign) xp = (float *) *xpp;
#line 3448
    xp += ni;
#line 3448
    tp += ni;
#line 3448
    *xpp = (void*)xp;
#line 3448
  }
#line 3448
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3448

#line 3448
#else   /* not SX */
#line 3448
	const char *xp = (const char *) *xpp;
#line 3448
	int status = NC_NOERR;
#line 3448

#line 3448
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3448
	{
#line 3448
		const int lstatus = ncx_get_float_long(xp, tp);
#line 3448
		if (status == NC_NOERR) /* report the first encountered error */
#line 3448
			status = lstatus;
#line 3448
	}
#line 3448

#line 3448
	*xpp = (const void *)xp;
#line 3448
	return status;
#line 3448
#endif
#line 3448
}
#line 3448

int
#line 3449
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
#line 3449
{
#line 3449
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3449

#line 3449
 /* basic algorithm is:
#line 3449
  *   - ensure sane alignment of input data
#line 3449
  *   - copy (conversion happens automatically) input data
#line 3449
  *     to output
#line 3449
  *   - update xpp to point at next unconverted input, and tp to point
#line 3449
  *     at next location for converted output
#line 3449
  */
#line 3449
  long i, j, ni;
#line 3449
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3449
  float *xp;
#line 3449
  int nrange = 0;         /* number of range errors */
#line 3449
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3449
  long cxp = (long) *((char**)xpp);
#line 3449

#line 3449
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3449
  /* sjl: manually stripmine so we can limit amount of
#line 3449
   * vector work space reserved to LOOPCNT elements. Also
#line 3449
   * makes vectorisation easy */
#line 3449
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3449
    ni=Min(nelems-j,LOOPCNT);
#line 3449
    if (realign) {
#line 3449
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3449
      xp = tmp;
#line 3449
    } else {
#line 3449
      xp = (float *) *xpp;
#line 3449
    }
#line 3449
   /* copy the next block */
#line 3449
#pragma cdir loopcnt=LOOPCNT
#line 3449
#pragma cdir shortloop
#line 3449
    for (i=0; i<ni; i++) {
#line 3449
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3449
     /* test for range errors (not always needed but do it anyway) */
#line 3449
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3449
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3449
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3449
    }
#line 3449
   /* update xpp and tp */
#line 3449
    if (realign) xp = (float *) *xpp;
#line 3449
    xp += ni;
#line 3449
    tp += ni;
#line 3449
    *xpp = (void*)xp;
#line 3449
  }
#line 3449
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3449

#line 3449
#else   /* not SX */
#line 3449
	const char *xp = (const char *) *xpp;
#line 3449
	int status = NC_NOERR;
#line 3449

#line 3449
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3449
	{
#line 3449
		const int lstatus = ncx_get_float_double(xp, tp);
#line 3449
		if (status == NC_NOERR) /* report the first encountered error */
#line 3449
			status = lstatus;
#line 3449
	}
#line 3449

#line 3449
	*xpp = (const void *)xp;
#line 3449
	return status;
#line 3449
#endif
#line 3449
}
#line 3449

int
#line 3450
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3450
{
#line 3450
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3450

#line 3450
 /* basic algorithm is:
#line 3450
  *   - ensure sane alignment of input data
#line 3450
  *   - copy (conversion happens automatically) input data
#line 3450
  *     to output
#line 3450
  *   - update xpp to point at next unconverted input, and tp to point
#line 3450
  *     at next location for converted output
#line 3450
  */
#line 3450
  long i, j, ni;
#line 3450
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3450
  float *xp;
#line 3450
  int nrange = 0;         /* number of range errors */
#line 3450
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3450
  long cxp = (long) *((char**)xpp);
#line 3450

#line 3450
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3450
  /* sjl: manually stripmine so we can limit amount of
#line 3450
   * vector work space reserved to LOOPCNT elements. Also
#line 3450
   * makes vectorisation easy */
#line 3450
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3450
    ni=Min(nelems-j,LOOPCNT);
#line 3450
    if (realign) {
#line 3450
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3450
      xp = tmp;
#line 3450
    } else {
#line 3450
      xp = (float *) *xpp;
#line 3450
    }
#line 3450
   /* copy the next block */
#line 3450
#pragma cdir loopcnt=LOOPCNT
#line 3450
#pragma cdir shortloop
#line 3450
    for (i=0; i<ni; i++) {
#line 3450
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3450
     /* test for range errors (not always needed but do it anyway) */
#line 3450
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3450
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3450
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3450
    }
#line 3450
   /* update xpp and tp */
#line 3450
    if (realign) xp = (float *) *xpp;
#line 3450
    xp += ni;
#line 3450
    tp += ni;
#line 3450
    *xpp = (void*)xp;
#line 3450
  }
#line 3450
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3450

#line 3450
#else   /* not SX */
#line 3450
	const char *xp = (const char *) *xpp;
#line 3450
	int status = NC_NOERR;
#line 3450

#line 3450
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3450
	{
#line 3450
		const int lstatus = ncx_get_float_longlong(xp, tp);
#line 3450
		if (status == NC_NOERR) /* report the first encountered error */
#line 3450
			status = lstatus;
#line 3450
	}
#line 3450

#line 3450
	*xpp = (const void *)xp;
#line 3450
	return status;
#line 3450
#endif
#line 3450
}
#line 3450

int
#line 3451
ncx_getn_float_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3451
{
#line 3451
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3451

#line 3451
 /* basic algorithm is:
#line 3451
  *   - ensure sane alignment of input data
#line 3451
  *   - copy (conversion happens automatically) input data
#line 3451
  *     to output
#line 3451
  *   - update xpp to point at next unconverted input, and tp to point
#line 3451
  *     at next location for converted output
#line 3451
  */
#line 3451
  long i, j, ni;
#line 3451
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3451
  float *xp;
#line 3451
  int nrange = 0;         /* number of range errors */
#line 3451
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3451
  long cxp = (long) *((char**)xpp);
#line 3451

#line 3451
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3451
  /* sjl: manually stripmine so we can limit amount of
#line 3451
   * vector work space reserved to LOOPCNT elements. Also
#line 3451
   * makes vectorisation easy */
#line 3451
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3451
    ni=Min(nelems-j,LOOPCNT);
#line 3451
    if (realign) {
#line 3451
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3451
      xp = tmp;
#line 3451
    } else {
#line 3451
      xp = (float *) *xpp;
#line 3451
    }
#line 3451
   /* copy the next block */
#line 3451
#pragma cdir loopcnt=LOOPCNT
#line 3451
#pragma cdir shortloop
#line 3451
    for (i=0; i<ni; i++) {
#line 3451
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3451
     /* test for range errors (not always needed but do it anyway) */
#line 3451
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3451
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3451
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3451
    }
#line 3451
   /* update xpp and tp */
#line 3451
    if (realign) xp = (float *) *xpp;
#line 3451
    xp += ni;
#line 3451
    tp += ni;
#line 3451
    *xpp = (void*)xp;
#line 3451
  }
#line 3451
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3451

#line 3451
#else   /* not SX */
#line 3451
	const char *xp = (const char *) *xpp;
#line 3451
	int status = NC_NOERR;
#line 3451

#line 3451
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3451
	{
#line 3451
		const int lstatus = ncx_get_float_ushort(xp, tp);
#line 3451
		if (status == NC_NOERR) /* report the first encountered error */
#line 3451
			status = lstatus;
#line 3451
	}
#line 3451

#line 3451
	*xpp = (const void *)xp;
#line 3451
	return status;
#line 3451
#endif
#line 3451
}
#line 3451

int
#line 3452
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3452
{
#line 3452
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3452

#line 3452
 /* basic algorithm is:
#line 3452
  *   - ensure sane alignment of input data
#line 3452
  *   - copy (conversion happens automatically) input data
#line 3452
  *     to output
#line 3452
  *   - update xpp to point at next unconverted input, and tp to point
#line 3452
  *     at next location for converted output
#line 3452
  */
#line 3452
  long i, j, ni;
#line 3452
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3452
  float *xp;
#line 3452
  int nrange = 0;         /* number of range errors */
#line 3452
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3452
  long cxp = (long) *((char**)xpp);
#line 3452

#line 3452
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3452
  /* sjl: manually stripmine so we can limit amount of
#line 3452
   * vector work space reserved to LOOPCNT elements. Also
#line 3452
   * makes vectorisation easy */
#line 3452
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3452
    ni=Min(nelems-j,LOOPCNT);
#line 3452
    if (realign) {
#line 3452
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3452
      xp = tmp;
#line 3452
    } else {
#line 3452
      xp = (float *) *xpp;
#line 3452
    }
#line 3452
   /* copy the next block */
#line 3452
#pragma cdir loopcnt=LOOPCNT
#line 3452
#pragma cdir shortloop
#line 3452
    for (i=0; i<ni; i++) {
#line 3452
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3452
     /* test for range errors (not always needed but do it anyway) */
#line 3452
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3452
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3452
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3452
    }
#line 3452
   /* update xpp and tp */
#line 3452
    if (realign) xp = (float *) *xpp;
#line 3452
    xp += ni;
#line 3452
    tp += ni;
#line 3452
    *xpp = (void*)xp;
#line 3452
  }
#line 3452
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3452

#line 3452
#else   /* not SX */
#line 3452
	const char *xp = (const char *) *xpp;
#line 3452
	int status = NC_NOERR;
#line 3452

#line 3452
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3452
	{
#line 3452
		const int lstatus = ncx_get_float_uchar(xp, tp);
#line 3452
		if (status == NC_NOERR) /* report the first encountered error */
#line 3452
			status = lstatus;
#line 3452
	}
#line 3452

#line 3452
	*xpp = (const void *)xp;
#line 3452
	return status;
#line 3452
#endif
#line 3452
}
#line 3452

int
#line 3453
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
#line 3453
{
#line 3453
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3453

#line 3453
 /* basic algorithm is:
#line 3453
  *   - ensure sane alignment of input data
#line 3453
  *   - copy (conversion happens automatically) input data
#line 3453
  *     to output
#line 3453
  *   - update xpp to point at next unconverted input, and tp to point
#line 3453
  *     at next location for converted output
#line 3453
  */
#line 3453
  long i, j, ni;
#line 3453
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3453
  float *xp;
#line 3453
  int nrange = 0;         /* number of range errors */
#line 3453
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3453
  long cxp = (long) *((char**)xpp);
#line 3453

#line 3453
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3453
  /* sjl: manually stripmine so we can limit amount of
#line 3453
   * vector work space reserved to LOOPCNT elements. Also
#line 3453
   * makes vectorisation easy */
#line 3453
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3453
    ni=Min(nelems-j,LOOPCNT);
#line 3453
    if (realign) {
#line 3453
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3453
      xp = tmp;
#line 3453
    } else {
#line 3453
      xp = (float *) *xpp;
#line 3453
    }
#line 3453
   /* copy the next block */
#line 3453
#pragma cdir loopcnt=LOOPCNT
#line 3453
#pragma cdir shortloop
#line 3453
    for (i=0; i<ni; i++) {
#line 3453
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3453
     /* test for range errors (not always needed but do it anyway) */
#line 3453
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3453
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3453
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3453
    }
#line 3453
   /* update xpp and tp */
#line 3453
    if (realign) xp = (float *) *xpp;
#line 3453
    xp += ni;
#line 3453
    tp += ni;
#line 3453
    *xpp = (void*)xp;
#line 3453
  }
#line 3453
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3453

#line 3453
#else   /* not SX */
#line 3453
	const char *xp = (const char *) *xpp;
#line 3453
	int status = NC_NOERR;
#line 3453

#line 3453
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3453
	{
#line 3453
		const int lstatus = ncx_get_float_uint(xp, tp);
#line 3453
		if (status == NC_NOERR) /* report the first encountered error */
#line 3453
			status = lstatus;
#line 3453
	}
#line 3453

#line 3453
	*xpp = (const void *)xp;
#line 3453
	return status;
#line 3453
#endif
#line 3453
}
#line 3453

int
#line 3454
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3454
{
#line 3454
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3454

#line 3454
 /* basic algorithm is:
#line 3454
  *   - ensure sane alignment of input data
#line 3454
  *   - copy (conversion happens automatically) input data
#line 3454
  *     to output
#line 3454
  *   - update xpp to point at next unconverted input, and tp to point
#line 3454
  *     at next location for converted output
#line 3454
  */
#line 3454
  long i, j, ni;
#line 3454
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3454
  float *xp;
#line 3454
  int nrange = 0;         /* number of range errors */
#line 3454
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3454
  long cxp = (long) *((char**)xpp);
#line 3454

#line 3454
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3454
  /* sjl: manually stripmine so we can limit amount of
#line 3454
   * vector work space reserved to LOOPCNT elements. Also
#line 3454
   * makes vectorisation easy */
#line 3454
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3454
    ni=Min(nelems-j,LOOPCNT);
#line 3454
    if (realign) {
#line 3454
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3454
      xp = tmp;
#line 3454
    } else {
#line 3454
      xp = (float *) *xpp;
#line 3454
    }
#line 3454
   /* copy the next block */
#line 3454
#pragma cdir loopcnt=LOOPCNT
#line 3454
#pragma cdir shortloop
#line 3454
    for (i=0; i<ni; i++) {
#line 3454
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3454
     /* test for range errors (not always needed but do it anyway) */
#line 3454
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3454
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3454
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3454
    }
#line 3454
   /* update xpp and tp */
#line 3454
    if (realign) xp = (float *) *xpp;
#line 3454
    xp += ni;
#line 3454
    tp += ni;
#line 3454
    *xpp = (void*)xp;
#line 3454
  }
#line 3454
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3454

#line 3454
#else   /* not SX */
#line 3454
	const char *xp = (const char *) *xpp;
#line 3454
	int status = NC_NOERR;
#line 3454

#line 3454
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3454
	{
#line 3454
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
#line 3454
		if (status == NC_NOERR) /* report the first encountered error */
#line 3454
			status = lstatus;
#line 3454
	}
#line 3454

#line 3454
	*xpp = (const void *)xp;
#line 3454
	return status;
#line 3454
#endif
#line 3454
}
#line 3454


int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
{
	const float *const end = tp + nelems;

	while (tp < end) {
				const struct vax_single *const vsp =
#line 3474
			 (const struct vax_single *)ip;
#line 3474
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);
#line 3474

#line 3474
		switch(vsp->exp){
#line 3474
		case 0 :
#line 3474
			/* all vax float with zero exponent map to zero */
#line 3474
			*isp = min.ieee;
#line 3474
			break;
#line 3474
		case 2 :
#line 3474
		case 1 :
#line 3474
		{
#line 3474
			/* These will map to subnormals */
#line 3474
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 3474
					 | vsp->mantissa2;
#line 3474
			mantissa >>= 3 - vsp->exp;
#line 3474
			mantissa += (1 << (20 + vsp->exp));
#line 3474
			isp->mant_lo_lo = mantissa;
#line 3474
			isp->mant_lo_hi = mantissa >> 8;
#line 3474
			isp->mant_hi = mantissa >> 16;
#line 3474
			isp->exp_lo = 0;
#line 3474
			isp->exp_hi = 0;
#line 3474
		}
#line 3474
			break;
#line 3474
		case 0xff : /* max.s.exp */
#line 3474
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 3474
			    vsp->mantissa1 == max.s.mantissa1)
#line 3474
			{
#line 3474
				/* map largest vax float to ieee infinity */
#line 3474
				*isp = max.ieee;
#line 3474
				break;
#line 3474
			} /* else, fall thru */
#line 3474
		default :
#line 3474
		{
#line 3474
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 3474
			isp->exp_hi = exp >> 1;
#line 3474
			isp->exp_lo = exp;
#line 3474
			isp->mant_lo_lo = vsp->mantissa2;
#line 3474
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 3474
			isp->mant_hi = vsp->mantissa1;
#line 3474
		}
#line 3474
		}
#line 3474

#line 3474
		isp->sign = vsp->sign;
#line 3474

		tp++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++) {
		int lstatus = ncx_put_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3495
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3495
{
#line 3495
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3495

#line 3495
 /* basic algorithm is:
#line 3495
  *   - ensure sane alignment of output data
#line 3495
  *   - copy (conversion happens automatically) input data
#line 3495
  *     to output
#line 3495
  *   - update tp to point at next unconverted input, and xpp to point
#line 3495
  *     at next location for converted output
#line 3495
  */
#line 3495
  long i, j, ni;
#line 3495
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3495
  float *xp;
#line 3495
  int nrange = 0;         /* number of range errors */
#line 3495
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3495
  long cxp = (long) *((char**)xpp);
#line 3495

#line 3495
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3495
  /* sjl: manually stripmine so we can limit amount of
#line 3495
   * vector work space reserved to LOOPCNT elements. Also
#line 3495
   * makes vectorisation easy */
#line 3495
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3495
    ni=Min(nelems-j,LOOPCNT);
#line 3495
    if (realign) {
#line 3495
      xp = tmp;
#line 3495
    } else {
#line 3495
      xp = (float *) *xpp;
#line 3495
    }
#line 3495
   /* copy the next block */
#line 3495
#pragma cdir loopcnt=LOOPCNT
#line 3495
#pragma cdir shortloop
#line 3495
    for (i=0; i<ni; i++) {
#line 3495
      /* the normal case: */
#line 3495
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3495
     /* test for range errors (not always needed but do it anyway) */
#line 3495
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3495
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3495
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3495
    }
#line 3495
   /* copy workspace back if necessary */
#line 3495
    if (realign) {
#line 3495
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3495
      xp = (float *) *xpp;
#line 3495
    }
#line 3495
   /* update xpp and tp */
#line 3495
    xp += ni;
#line 3495
    tp += ni;
#line 3495
    *xpp = (void*)xp;
#line 3495
  }
#line 3495
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3495

#line 3495
#else   /* not SX */
#line 3495

#line 3495
	char *xp = (char *) *xpp;
#line 3495
	int status = NC_NOERR;
#line 3495

#line 3495
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3495
	{
#line 3495
		int lstatus = ncx_put_float_schar(xp, tp, fillp);
#line 3495
		if (status == NC_NOERR) /* report the first encountered error */
#line 3495
			status = lstatus;
#line 3495
	}
#line 3495

#line 3495
	*xpp = (void *)xp;
#line 3495
	return status;
#line 3495
#endif
#line 3495
}
#line 3495

int
#line 3496
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3496
{
#line 3496
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3496

#line 3496
 /* basic algorithm is:
#line 3496
  *   - ensure sane alignment of output data
#line 3496
  *   - copy (conversion happens automatically) input data
#line 3496
  *     to output
#line 3496
  *   - update tp to point at next unconverted input, and xpp to point
#line 3496
  *     at next location for converted output
#line 3496
  */
#line 3496
  long i, j, ni;
#line 3496
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3496
  float *xp;
#line 3496
  int nrange = 0;         /* number of range errors */
#line 3496
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3496
  long cxp = (long) *((char**)xpp);
#line 3496

#line 3496
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3496
  /* sjl: manually stripmine so we can limit amount of
#line 3496
   * vector work space reserved to LOOPCNT elements. Also
#line 3496
   * makes vectorisation easy */
#line 3496
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3496
    ni=Min(nelems-j,LOOPCNT);
#line 3496
    if (realign) {
#line 3496
      xp = tmp;
#line 3496
    } else {
#line 3496
      xp = (float *) *xpp;
#line 3496
    }
#line 3496
   /* copy the next block */
#line 3496
#pragma cdir loopcnt=LOOPCNT
#line 3496
#pragma cdir shortloop
#line 3496
    for (i=0; i<ni; i++) {
#line 3496
      /* the normal case: */
#line 3496
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3496
     /* test for range errors (not always needed but do it anyway) */
#line 3496
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3496
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3496
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3496
    }
#line 3496
   /* copy workspace back if necessary */
#line 3496
    if (realign) {
#line 3496
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3496
      xp = (float *) *xpp;
#line 3496
    }
#line 3496
   /* update xpp and tp */
#line 3496
    xp += ni;
#line 3496
    tp += ni;
#line 3496
    *xpp = (void*)xp;
#line 3496
  }
#line 3496
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3496

#line 3496
#else   /* not SX */
#line 3496

#line 3496
	char *xp = (char *) *xpp;
#line 3496
	int status = NC_NOERR;
#line 3496

#line 3496
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3496
	{
#line 3496
		int lstatus = ncx_put_float_short(xp, tp, fillp);
#line 3496
		if (status == NC_NOERR) /* report the first encountered error */
#line 3496
			status = lstatus;
#line 3496
	}
#line 3496

#line 3496
	*xpp = (void *)xp;
#line 3496
	return status;
#line 3496
#endif
#line 3496
}
#line 3496

int
#line 3497
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3497
{
#line 3497
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3497

#line 3497
 /* basic algorithm is:
#line 3497
  *   - ensure sane alignment of output data
#line 3497
  *   - copy (conversion happens automatically) input data
#line 3497
  *     to output
#line 3497
  *   - update tp to point at next unconverted input, and xpp to point
#line 3497
  *     at next location for converted output
#line 3497
  */
#line 3497
  long i, j, ni;
#line 3497
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3497
  float *xp;
#line 3497
  int nrange = 0;         /* number of range errors */
#line 3497
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3497
  long cxp = (long) *((char**)xpp);
#line 3497

#line 3497
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3497
  /* sjl: manually stripmine so we can limit amount of
#line 3497
   * vector work space reserved to LOOPCNT elements. Also
#line 3497
   * makes vectorisation easy */
#line 3497
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3497
    ni=Min(nelems-j,LOOPCNT);
#line 3497
    if (realign) {
#line 3497
      xp = tmp;
#line 3497
    } else {
#line 3497
      xp = (float *) *xpp;
#line 3497
    }
#line 3497
   /* copy the next block */
#line 3497
#pragma cdir loopcnt=LOOPCNT
#line 3497
#pragma cdir shortloop
#line 3497
    for (i=0; i<ni; i++) {
#line 3497
      /* the normal case: */
#line 3497
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3497
     /* test for range errors (not always needed but do it anyway) */
#line 3497
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3497
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3497
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3497
    }
#line 3497
   /* copy workspace back if necessary */
#line 3497
    if (realign) {
#line 3497
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3497
      xp = (float *) *xpp;
#line 3497
    }
#line 3497
   /* update xpp and tp */
#line 3497
    xp += ni;
#line 3497
    tp += ni;
#line 3497
    *xpp = (void*)xp;
#line 3497
  }
#line 3497
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3497

#line 3497
#else   /* not SX */
#line 3497

#line 3497
	char *xp = (char *) *xpp;
#line 3497
	int status = NC_NOERR;
#line 3497

#line 3497
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3497
	{
#line 3497
		int lstatus = ncx_put_float_int(xp, tp, fillp);
#line 3497
		if (status == NC_NOERR) /* report the first encountered error */
#line 3497
			status = lstatus;
#line 3497
	}
#line 3497

#line 3497
	*xpp = (void *)xp;
#line 3497
	return status;
#line 3497
#endif
#line 3497
}
#line 3497

int
#line 3498
ncx_putn_float_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3498
{
#line 3498
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3498

#line 3498
 /* basic algorithm is:
#line 3498
  *   - ensure sane alignment of output data
#line 3498
  *   - copy (conversion happens automatically) input data
#line 3498
  *     to output
#line 3498
  *   - update tp to point at next unconverted input, and xpp to point
#line 3498
  *     at next location for converted output
#line 3498
  */
#line 3498
  long i, j, ni;
#line 3498
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3498
  float *xp;
#line 3498
  int nrange = 0;         /* number of range errors */
#line 3498
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3498
  long cxp = (long) *((char**)xpp);
#line 3498

#line 3498
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3498
  /* sjl: manually stripmine so we can limit amount of
#line 3498
   * vector work space reserved to LOOPCNT elements. Also
#line 3498
   * makes vectorisation easy */
#line 3498
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3498
    ni=Min(nelems-j,LOOPCNT);
#line 3498
    if (realign) {
#line 3498
      xp = tmp;
#line 3498
    } else {
#line 3498
      xp = (float *) *xpp;
#line 3498
    }
#line 3498
   /* copy the next block */
#line 3498
#pragma cdir loopcnt=LOOPCNT
#line 3498
#pragma cdir shortloop
#line 3498
    for (i=0; i<ni; i++) {
#line 3498
      /* the normal case: */
#line 3498
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3498
     /* test for range errors (not always needed but do it anyway) */
#line 3498
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3498
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3498
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3498
    }
#line 3498
   /* copy workspace back if necessary */
#line 3498
    if (realign) {
#line 3498
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3498
      xp = (float *) *xpp;
#line 3498
    }
#line 3498
   /* update xpp and tp */
#line 3498
    xp += ni;
#line 3498
    tp += ni;
#line 3498
    *xpp = (void*)xp;
#line 3498
  }
#line 3498
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3498

#line 3498
#else   /* not SX */
#line 3498

#line 3498
	char *xp = (char *) *xpp;
#line 3498
	int status = NC_NOERR;
#line 3498

#line 3498
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3498
	{
#line 3498
		int lstatus = ncx_put_float_long(xp, tp, fillp);
#line 3498
		if (status == NC_NOERR) /* report the first encountered error */
#line 3498
			status = lstatus;
#line 3498
	}
#line 3498

#line 3498
	*xpp = (void *)xp;
#line 3498
	return status;
#line 3498
#endif
#line 3498
}
#line 3498

int
#line 3499
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3499
{
#line 3499
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3499

#line 3499
 /* basic algorithm is:
#line 3499
  *   - ensure sane alignment of output data
#line 3499
  *   - copy (conversion happens automatically) input data
#line 3499
  *     to output
#line 3499
  *   - update tp to point at next unconverted input, and xpp to point
#line 3499
  *     at next location for converted output
#line 3499
  */
#line 3499
  long i, j, ni;
#line 3499
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3499
  float *xp;
#line 3499
  int nrange = 0;         /* number of range errors */
#line 3499
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3499
  long cxp = (long) *((char**)xpp);
#line 3499

#line 3499
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3499
  /* sjl: manually stripmine so we can limit amount of
#line 3499
   * vector work space reserved to LOOPCNT elements. Also
#line 3499
   * makes vectorisation easy */
#line 3499
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3499
    ni=Min(nelems-j,LOOPCNT);
#line 3499
    if (realign) {
#line 3499
      xp = tmp;
#line 3499
    } else {
#line 3499
      xp = (float *) *xpp;
#line 3499
    }
#line 3499
   /* copy the next block */
#line 3499
#pragma cdir loopcnt=LOOPCNT
#line 3499
#pragma cdir shortloop
#line 3499
    for (i=0; i<ni; i++) {
#line 3499
      /* the normal case: */
#line 3499
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3499
     /* test for range errors (not always needed but do it anyway) */
#line 3499
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3499
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3499
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3499
    }
#line 3499
   /* copy workspace back if necessary */
#line 3499
    if (realign) {
#line 3499
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3499
      xp = (float *) *xpp;
#line 3499
    }
#line 3499
   /* update xpp and tp */
#line 3499
    xp += ni;
#line 3499
    tp += ni;
#line 3499
    *xpp = (void*)xp;
#line 3499
  }
#line 3499
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3499

#line 3499
#else   /* not SX */
#line 3499

#line 3499
	char *xp = (char *) *xpp;
#line 3499
	int status = NC_NOERR;
#line 3499

#line 3499
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3499
	{
#line 3499
		int lstatus = ncx_put_float_double(xp, tp, fillp);
#line 3499
		if (status == NC_NOERR) /* report the first encountered error */
#line 3499
			status = lstatus;
#line 3499
	}
#line 3499

#line 3499
	*xpp = (void *)xp;
#line 3499
	return status;
#line 3499
#endif
#line 3499
}
#line 3499

int
#line 3500
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3500
{
#line 3500
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3500

#line 3500
 /* basic algorithm is:
#line 3500
  *   - ensure sane alignment of output data
#line 3500
  *   - copy (conversion happens automatically) input data
#line 3500
  *     to output
#line 3500
  *   - update tp to point at next unconverted input, and xpp to point
#line 3500
  *     at next location for converted output
#line 3500
  */
#line 3500
  long i, j, ni;
#line 3500
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3500
  float *xp;
#line 3500
  int nrange = 0;         /* number of range errors */
#line 3500
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3500
  long cxp = (long) *((char**)xpp);
#line 3500

#line 3500
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3500
  /* sjl: manually stripmine so we can limit amount of
#line 3500
   * vector work space reserved to LOOPCNT elements. Also
#line 3500
   * makes vectorisation easy */
#line 3500
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3500
    ni=Min(nelems-j,LOOPCNT);
#line 3500
    if (realign) {
#line 3500
      xp = tmp;
#line 3500
    } else {
#line 3500
      xp = (float *) *xpp;
#line 3500
    }
#line 3500
   /* copy the next block */
#line 3500
#pragma cdir loopcnt=LOOPCNT
#line 3500
#pragma cdir shortloop
#line 3500
    for (i=0; i<ni; i++) {
#line 3500
      /* the normal case: */
#line 3500
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3500
     /* test for range errors (not always needed but do it anyway) */
#line 3500
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3500
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3500
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3500
    }
#line 3500
   /* copy workspace back if necessary */
#line 3500
    if (realign) {
#line 3500
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3500
      xp = (float *) *xpp;
#line 3500
    }
#line 3500
   /* update xpp and tp */
#line 3500
    xp += ni;
#line 3500
    tp += ni;
#line 3500
    *xpp = (void*)xp;
#line 3500
  }
#line 3500
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3500

#line 3500
#else   /* not SX */
#line 3500

#line 3500
	char *xp = (char *) *xpp;
#line 3500
	int status = NC_NOERR;
#line 3500

#line 3500
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3500
	{
#line 3500
		int lstatus = ncx_put_float_longlong(xp, tp, fillp);
#line 3500
		if (status == NC_NOERR) /* report the first encountered error */
#line 3500
			status = lstatus;
#line 3500
	}
#line 3500

#line 3500
	*xpp = (void *)xp;
#line 3500
	return status;
#line 3500
#endif
#line 3500
}
#line 3500

int
#line 3501
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3501
{
#line 3501
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3501

#line 3501
 /* basic algorithm is:
#line 3501
  *   - ensure sane alignment of output data
#line 3501
  *   - copy (conversion happens automatically) input data
#line 3501
  *     to output
#line 3501
  *   - update tp to point at next unconverted input, and xpp to point
#line 3501
  *     at next location for converted output
#line 3501
  */
#line 3501
  long i, j, ni;
#line 3501
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3501
  float *xp;
#line 3501
  int nrange = 0;         /* number of range errors */
#line 3501
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3501
  long cxp = (long) *((char**)xpp);
#line 3501

#line 3501
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3501
  /* sjl: manually stripmine so we can limit amount of
#line 3501
   * vector work space reserved to LOOPCNT elements. Also
#line 3501
   * makes vectorisation easy */
#line 3501
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3501
    ni=Min(nelems-j,LOOPCNT);
#line 3501
    if (realign) {
#line 3501
      xp = tmp;
#line 3501
    } else {
#line 3501
      xp = (float *) *xpp;
#line 3501
    }
#line 3501
   /* copy the next block */
#line 3501
#pragma cdir loopcnt=LOOPCNT
#line 3501
#pragma cdir shortloop
#line 3501
    for (i=0; i<ni; i++) {
#line 3501
      /* the normal case: */
#line 3501
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3501
     /* test for range errors (not always needed but do it anyway) */
#line 3501
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3501
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3501
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3501
    }
#line 3501
   /* copy workspace back if necessary */
#line 3501
    if (realign) {
#line 3501
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3501
      xp = (float *) *xpp;
#line 3501
    }
#line 3501
   /* update xpp and tp */
#line 3501
    xp += ni;
#line 3501
    tp += ni;
#line 3501
    *xpp = (void*)xp;
#line 3501
  }
#line 3501
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3501

#line 3501
#else   /* not SX */
#line 3501

#line 3501
	char *xp = (char *) *xpp;
#line 3501
	int status = NC_NOERR;
#line 3501

#line 3501
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3501
	{
#line 3501
		int lstatus = ncx_put_float_uchar(xp, tp, fillp);
#line 3501
		if (status == NC_NOERR) /* report the first encountered error */
#line 3501
			status = lstatus;
#line 3501
	}
#line 3501

#line 3501
	*xpp = (void *)xp;
#line 3501
	return status;
#line 3501
#endif
#line 3501
}
#line 3501

int
#line 3502
ncx_putn_float_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3502
{
#line 3502
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3502

#line 3502
 /* basic algorithm is:
#line 3502
  *   - ensure sane alignment of output data
#line 3502
  *   - copy (conversion happens automatically) input data
#line 3502
  *     to output
#line 3502
  *   - update tp to point at next unconverted input, and xpp to point
#line 3502
  *     at next location for converted output
#line 3502
  */
#line 3502
  long i, j, ni;
#line 3502
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3502
  float *xp;
#line 3502
  int nrange = 0;         /* number of range errors */
#line 3502
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3502
  long cxp = (long) *((char**)xpp);
#line 3502

#line 3502
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3502
  /* sjl: manually stripmine so we can limit amount of
#line 3502
   * vector work space reserved to LOOPCNT elements. Also
#line 3502
   * makes vectorisation easy */
#line 3502
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3502
    ni=Min(nelems-j,LOOPCNT);
#line 3502
    if (realign) {
#line 3502
      xp = tmp;
#line 3502
    } else {
#line 3502
      xp = (float *) *xpp;
#line 3502
    }
#line 3502
   /* copy the next block */
#line 3502
#pragma cdir loopcnt=LOOPCNT
#line 3502
#pragma cdir shortloop
#line 3502
    for (i=0; i<ni; i++) {
#line 3502
      /* the normal case: */
#line 3502
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3502
     /* test for range errors (not always needed but do it anyway) */
#line 3502
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3502
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3502
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3502
    }
#line 3502
   /* copy workspace back if necessary */
#line 3502
    if (realign) {
#line 3502
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3502
      xp = (float *) *xpp;
#line 3502
    }
#line 3502
   /* update xpp and tp */
#line 3502
    xp += ni;
#line 3502
    tp += ni;
#line 3502
    *xpp = (void*)xp;
#line 3502
  }
#line 3502
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3502

#line 3502
#else   /* not SX */
#line 3502

#line 3502
	char *xp = (char *) *xpp;
#line 3502
	int status = NC_NOERR;
#line 3502

#line 3502
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3502
	{
#line 3502
		int lstatus = ncx_put_float_ushort(xp, tp, fillp);
#line 3502
		if (status == NC_NOERR) /* report the first encountered error */
#line 3502
			status = lstatus;
#line 3502
	}
#line 3502

#line 3502
	*xpp = (void *)xp;
#line 3502
	return status;
#line 3502
#endif
#line 3502
}
#line 3502

int
#line 3503
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3503
{
#line 3503
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3503

#line 3503
 /* basic algorithm is:
#line 3503
  *   - ensure sane alignment of output data
#line 3503
  *   - copy (conversion happens automatically) input data
#line 3503
  *     to output
#line 3503
  *   - update tp to point at next unconverted input, and xpp to point
#line 3503
  *     at next location for converted output
#line 3503
  */
#line 3503
  long i, j, ni;
#line 3503
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3503
  float *xp;
#line 3503
  int nrange = 0;         /* number of range errors */
#line 3503
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3503
  long cxp = (long) *((char**)xpp);
#line 3503

#line 3503
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3503
  /* sjl: manually stripmine so we can limit amount of
#line 3503
   * vector work space reserved to LOOPCNT elements. Also
#line 3503
   * makes vectorisation easy */
#line 3503
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3503
    ni=Min(nelems-j,LOOPCNT);
#line 3503
    if (realign) {
#line 3503
      xp = tmp;
#line 3503
    } else {
#line 3503
      xp = (float *) *xpp;
#line 3503
    }
#line 3503
   /* copy the next block */
#line 3503
#pragma cdir loopcnt=LOOPCNT
#line 3503
#pragma cdir shortloop
#line 3503
    for (i=0; i<ni; i++) {
#line 3503
      /* the normal case: */
#line 3503
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3503
     /* test for range errors (not always needed but do it anyway) */
#line 3503
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3503
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3503
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3503
    }
#line 3503
   /* copy workspace back if necessary */
#line 3503
    if (realign) {
#line 3503
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3503
      xp = (float *) *xpp;
#line 3503
    }
#line 3503
   /* update xpp and tp */
#line 3503
    xp += ni;
#line 3503
    tp += ni;
#line 3503
    *xpp = (void*)xp;
#line 3503
  }
#line 3503
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3503

#line 3503
#else   /* not SX */
#line 3503

#line 3503
	char *xp = (char *) *xpp;
#line 3503
	int status = NC_NOERR;
#line 3503

#line 3503
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3503
	{
#line 3503
		int lstatus = ncx_put_float_uint(xp, tp, fillp);
#line 3503
		if (status == NC_NOERR) /* report the first encountered error */
#line 3503
			status = lstatus;
#line 3503
	}
#line 3503

#line 3503
	*xpp = (void *)xp;
#line 3503
	return status;
#line 3503
#endif
#line 3503
}
#line 3503

int
#line 3504
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3504
{
#line 3504
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3504

#line 3504
 /* basic algorithm is:
#line 3504
  *   - ensure sane alignment of output data
#line 3504
  *   - copy (conversion happens automatically) input data
#line 3504
  *     to output
#line 3504
  *   - update tp to point at next unconverted input, and xpp to point
#line 3504
  *     at next location for converted output
#line 3504
  */
#line 3504
  long i, j, ni;
#line 3504
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3504
  float *xp;
#line 3504
  int nrange = 0;         /* number of range errors */
#line 3504
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3504
  long cxp = (long) *((char**)xpp);
#line 3504

#line 3504
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3504
  /* sjl: manually stripmine so we can limit amount of
#line 3504
   * vector work space reserved to LOOPCNT elements. Also
#line 3504
   * makes vectorisation easy */
#line 3504
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3504
    ni=Min(nelems-j,LOOPCNT);
#line 3504
    if (realign) {
#line 3504
      xp = tmp;
#line 3504
    } else {
#line 3504
      xp = (float *) *xpp;
#line 3504
    }
#line 3504
   /* copy the next block */
#line 3504
#pragma cdir loopcnt=LOOPCNT
#line 3504
#pragma cdir shortloop
#line 3504
    for (i=0; i<ni; i++) {
#line 3504
      /* the normal case: */
#line 3504
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3504
     /* test for range errors (not always needed but do it anyway) */
#line 3504
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3504
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3504
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3504
    }
#line 3504
   /* copy workspace back if necessary */
#line 3504
    if (realign) {
#line 3504
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3504
      xp = (float *) *xpp;
#line 3504
    }
#line 3504
   /* update xpp and tp */
#line 3504
    xp += ni;
#line 3504
    tp += ni;
#line 3504
    *xpp = (void*)xp;
#line 3504
  }
#line 3504
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3504

#line 3504
#else   /* not SX */
#line 3504

#line 3504
	char *xp = (char *) *xpp;
#line 3504
	int status = NC_NOERR;
#line 3504

#line 3504
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3504
	{
#line 3504
		int lstatus = ncx_put_float_ulonglong(xp, tp, fillp);
#line 3504
		if (status == NC_NOERR) /* report the first encountered error */
#line 3504
			status = lstatus;
#line 3504
	}
#line 3504

#line 3504
	*xpp = (void *)xp;
#line 3504
	return status;
#line 3504
#endif
#line 3504
}
#line 3504


/* double --------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_DOUBLE);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while (ip < end)
	{
	struct vax_double *const vdp =
#line 3529
			 (struct vax_double *)ip;
#line 3529
	const struct ieee_double *const idp =
#line 3529
			 (const struct ieee_double *) (*xpp);
#line 3529
	{
#line 3529
		const struct dbl_limits *lim;
#line 3529
		int ii;
#line 3529
		for (ii = 0, lim = dbl_limits;
#line 3529
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 3529
			ii++, lim++)
#line 3529
		{
#line 3529
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 3529
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 3529
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 3529
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 3529
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 3529
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 3529
				)
#line 3529
			{
#line 3529
				*vdp = lim->d;
#line 3529
				goto doneit;
#line 3529
			}
#line 3529
		}
#line 3529
	}
#line 3529
	{
#line 3529
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 3529
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 3529
	}
#line 3529
	{
#line 3529
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 3529
				 | (idp->mant_5 << 8)
#line 3529
				 | idp->mant_4);
#line 3529
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 3529
		vdp->mantissa1 = (mant_hi >> 13);
#line 3529
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 3529
				| (mant_lo >> 29);
#line 3529
		vdp->mantissa3 = (mant_lo >> 13);
#line 3529
		vdp->mantissa4 = (mant_lo << 3);
#line 3529
	}
#line 3529
	doneit:
#line 3529
		vdp->sign = idp->sign;
#line 3529

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}
#endif
int
#line 3554
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
#line 3554
{
#line 3554
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3554

#line 3554
 /* basic algorithm is:
#line 3554
  *   - ensure sane alignment of input data
#line 3554
  *   - copy (conversion happens automatically) input data
#line 3554
  *     to output
#line 3554
  *   - update xpp to point at next unconverted input, and tp to point
#line 3554
  *     at next location for converted output
#line 3554
  */
#line 3554
  long i, j, ni;
#line 3554
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3554
  double *xp;
#line 3554
  int nrange = 0;         /* number of range errors */
#line 3554
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3554
  long cxp = (long) *((char**)xpp);
#line 3554

#line 3554
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3554
  /* sjl: manually stripmine so we can limit amount of
#line 3554
   * vector work space reserved to LOOPCNT elements. Also
#line 3554
   * makes vectorisation easy */
#line 3554
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3554
    ni=Min(nelems-j,LOOPCNT);
#line 3554
    if (realign) {
#line 3554
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3554
      xp = tmp;
#line 3554
    } else {
#line 3554
      xp = (double *) *xpp;
#line 3554
    }
#line 3554
   /* copy the next block */
#line 3554
#pragma cdir loopcnt=LOOPCNT
#line 3554
#pragma cdir shortloop
#line 3554
    for (i=0; i<ni; i++) {
#line 3554
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3554
     /* test for range errors (not always needed but do it anyway) */
#line 3554
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3554
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3554
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3554
    }
#line 3554
   /* update xpp and tp */
#line 3554
    if (realign) xp = (double *) *xpp;
#line 3554
    xp += ni;
#line 3554
    tp += ni;
#line 3554
    *xpp = (void*)xp;
#line 3554
  }
#line 3554
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3554

#line 3554
#else   /* not SX */
#line 3554
	const char *xp = (const char *) *xpp;
#line 3554
	int status = NC_NOERR;
#line 3554

#line 3554
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3554
	{
#line 3554
		const int lstatus = ncx_get_double_schar(xp, tp);
#line 3554
		if (status == NC_NOERR) /* report the first encountered error */
#line 3554
			status = lstatus;
#line 3554
	}
#line 3554

#line 3554
	*xpp = (const void *)xp;
#line 3554
	return status;
#line 3554
#endif
#line 3554
}
#line 3554

int
#line 3555
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
#line 3555
{
#line 3555
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3555

#line 3555
 /* basic algorithm is:
#line 3555
  *   - ensure sane alignment of input data
#line 3555
  *   - copy (conversion happens automatically) input data
#line 3555
  *     to output
#line 3555
  *   - update xpp to point at next unconverted input, and tp to point
#line 3555
  *     at next location for converted output
#line 3555
  */
#line 3555
  long i, j, ni;
#line 3555
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3555
  double *xp;
#line 3555
  int nrange = 0;         /* number of range errors */
#line 3555
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3555
  long cxp = (long) *((char**)xpp);
#line 3555

#line 3555
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3555
  /* sjl: manually stripmine so we can limit amount of
#line 3555
   * vector work space reserved to LOOPCNT elements. Also
#line 3555
   * makes vectorisation easy */
#line 3555
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3555
    ni=Min(nelems-j,LOOPCNT);
#line 3555
    if (realign) {
#line 3555
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3555
      xp = tmp;
#line 3555
    } else {
#line 3555
      xp = (double *) *xpp;
#line 3555
    }
#line 3555
   /* copy the next block */
#line 3555
#pragma cdir loopcnt=LOOPCNT
#line 3555
#pragma cdir shortloop
#line 3555
    for (i=0; i<ni; i++) {
#line 3555
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3555
     /* test for range errors (not always needed but do it anyway) */
#line 3555
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3555
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3555
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3555
    }
#line 3555
   /* update xpp and tp */
#line 3555
    if (realign) xp = (double *) *xpp;
#line 3555
    xp += ni;
#line 3555
    tp += ni;
#line 3555
    *xpp = (void*)xp;
#line 3555
  }
#line 3555
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3555

#line 3555
#else   /* not SX */
#line 3555
	const char *xp = (const char *) *xpp;
#line 3555
	int status = NC_NOERR;
#line 3555

#line 3555
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3555
	{
#line 3555
		const int lstatus = ncx_get_double_short(xp, tp);
#line 3555
		if (status == NC_NOERR) /* report the first encountered error */
#line 3555
			status = lstatus;
#line 3555
	}
#line 3555

#line 3555
	*xpp = (const void *)xp;
#line 3555
	return status;
#line 3555
#endif
#line 3555
}
#line 3555

int
#line 3556
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
#line 3556
{
#line 3556
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3556

#line 3556
 /* basic algorithm is:
#line 3556
  *   - ensure sane alignment of input data
#line 3556
  *   - copy (conversion happens automatically) input data
#line 3556
  *     to output
#line 3556
  *   - update xpp to point at next unconverted input, and tp to point
#line 3556
  *     at next location for converted output
#line 3556
  */
#line 3556
  long i, j, ni;
#line 3556
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3556
  double *xp;
#line 3556
  int nrange = 0;         /* number of range errors */
#line 3556
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3556
  long cxp = (long) *((char**)xpp);
#line 3556

#line 3556
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3556
  /* sjl: manually stripmine so we can limit amount of
#line 3556
   * vector work space reserved to LOOPCNT elements. Also
#line 3556
   * makes vectorisation easy */
#line 3556
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3556
    ni=Min(nelems-j,LOOPCNT);
#line 3556
    if (realign) {
#line 3556
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3556
      xp = tmp;
#line 3556
    } else {
#line 3556
      xp = (double *) *xpp;
#line 3556
    }
#line 3556
   /* copy the next block */
#line 3556
#pragma cdir loopcnt=LOOPCNT
#line 3556
#pragma cdir shortloop
#line 3556
    for (i=0; i<ni; i++) {
#line 3556
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3556
     /* test for range errors (not always needed but do it anyway) */
#line 3556
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3556
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3556
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3556
    }
#line 3556
   /* update xpp and tp */
#line 3556
    if (realign) xp = (double *) *xpp;
#line 3556
    xp += ni;
#line 3556
    tp += ni;
#line 3556
    *xpp = (void*)xp;
#line 3556
  }
#line 3556
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3556

#line 3556
#else   /* not SX */
#line 3556
	const char *xp = (const char *) *xpp;
#line 3556
	int status = NC_NOERR;
#line 3556

#line 3556
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3556
	{
#line 3556
		const int lstatus = ncx_get_double_int(xp, tp);
#line 3556
		if (status == NC_NOERR) /* report the first encountered error */
#line 3556
			status = lstatus;
#line 3556
	}
#line 3556

#line 3556
	*xpp = (const void *)xp;
#line 3556
	return status;
#line 3556
#endif
#line 3556
}
#line 3556

int
#line 3557
ncx_getn_double_long(const void **xpp, size_t nelems, long *tp)
#line 3557
{
#line 3557
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3557

#line 3557
 /* basic algorithm is:
#line 3557
  *   - ensure sane alignment of input data
#line 3557
  *   - copy (conversion happens automatically) input data
#line 3557
  *     to output
#line 3557
  *   - update xpp to point at next unconverted input, and tp to point
#line 3557
  *     at next location for converted output
#line 3557
  */
#line 3557
  long i, j, ni;
#line 3557
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3557
  double *xp;
#line 3557
  int nrange = 0;         /* number of range errors */
#line 3557
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3557
  long cxp = (long) *((char**)xpp);
#line 3557

#line 3557
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3557
  /* sjl: manually stripmine so we can limit amount of
#line 3557
   * vector work space reserved to LOOPCNT elements. Also
#line 3557
   * makes vectorisation easy */
#line 3557
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3557
    ni=Min(nelems-j,LOOPCNT);
#line 3557
    if (realign) {
#line 3557
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3557
      xp = tmp;
#line 3557
    } else {
#line 3557
      xp = (double *) *xpp;
#line 3557
    }
#line 3557
   /* copy the next block */
#line 3557
#pragma cdir loopcnt=LOOPCNT
#line 3557
#pragma cdir shortloop
#line 3557
    for (i=0; i<ni; i++) {
#line 3557
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3557
     /* test for range errors (not always needed but do it anyway) */
#line 3557
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3557
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3557
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3557
    }
#line 3557
   /* update xpp and tp */
#line 3557
    if (realign) xp = (double *) *xpp;
#line 3557
    xp += ni;
#line 3557
    tp += ni;
#line 3557
    *xpp = (void*)xp;
#line 3557
  }
#line 3557
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3557

#line 3557
#else   /* not SX */
#line 3557
	const char *xp = (const char *) *xpp;
#line 3557
	int status = NC_NOERR;
#line 3557

#line 3557
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3557
	{
#line 3557
		const int lstatus = ncx_get_double_long(xp, tp);
#line 3557
		if (status == NC_NOERR) /* report the first encountered error */
#line 3557
			status = lstatus;
#line 3557
	}
#line 3557

#line 3557
	*xpp = (const void *)xp;
#line 3557
	return status;
#line 3557
#endif
#line 3557
}
#line 3557

int
#line 3558
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
#line 3558
{
#line 3558
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3558

#line 3558
 /* basic algorithm is:
#line 3558
  *   - ensure sane alignment of input data
#line 3558
  *   - copy (conversion happens automatically) input data
#line 3558
  *     to output
#line 3558
  *   - update xpp to point at next unconverted input, and tp to point
#line 3558
  *     at next location for converted output
#line 3558
  */
#line 3558
  long i, j, ni;
#line 3558
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3558
  double *xp;
#line 3558
  int nrange = 0;         /* number of range errors */
#line 3558
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3558
  long cxp = (long) *((char**)xpp);
#line 3558

#line 3558
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3558
  /* sjl: manually stripmine so we can limit amount of
#line 3558
   * vector work space reserved to LOOPCNT elements. Also
#line 3558
   * makes vectorisation easy */
#line 3558
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3558
    ni=Min(nelems-j,LOOPCNT);
#line 3558
    if (realign) {
#line 3558
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3558
      xp = tmp;
#line 3558
    } else {
#line 3558
      xp = (double *) *xpp;
#line 3558
    }
#line 3558
   /* copy the next block */
#line 3558
#pragma cdir loopcnt=LOOPCNT
#line 3558
#pragma cdir shortloop
#line 3558
    for (i=0; i<ni; i++) {
#line 3558
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3558
     /* test for range errors (not always needed but do it anyway) */
#line 3558
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3558
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3558
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3558
    }
#line 3558
   /* update xpp and tp */
#line 3558
    if (realign) xp = (double *) *xpp;
#line 3558
    xp += ni;
#line 3558
    tp += ni;
#line 3558
    *xpp = (void*)xp;
#line 3558
  }
#line 3558
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3558

#line 3558
#else   /* not SX */
#line 3558
	const char *xp = (const char *) *xpp;
#line 3558
	int status = NC_NOERR;
#line 3558

#line 3558
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3558
	{
#line 3558
		const int lstatus = ncx_get_double_float(xp, tp);
#line 3558
		if (status == NC_NOERR) /* report the first encountered error */
#line 3558
			status = lstatus;
#line 3558
	}
#line 3558

#line 3558
	*xpp = (const void *)xp;
#line 3558
	return status;
#line 3558
#endif
#line 3558
}
#line 3558

int
#line 3559
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3559
{
#line 3559
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3559

#line 3559
 /* basic algorithm is:
#line 3559
  *   - ensure sane alignment of input data
#line 3559
  *   - copy (conversion happens automatically) input data
#line 3559
  *     to output
#line 3559
  *   - update xpp to point at next unconverted input, and tp to point
#line 3559
  *     at next location for converted output
#line 3559
  */
#line 3559
  long i, j, ni;
#line 3559
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3559
  double *xp;
#line 3559
  int nrange = 0;         /* number of range errors */
#line 3559
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3559
  long cxp = (long) *((char**)xpp);
#line 3559

#line 3559
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3559
  /* sjl: manually stripmine so we can limit amount of
#line 3559
   * vector work space reserved to LOOPCNT elements. Also
#line 3559
   * makes vectorisation easy */
#line 3559
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3559
    ni=Min(nelems-j,LOOPCNT);
#line 3559
    if (realign) {
#line 3559
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3559
      xp = tmp;
#line 3559
    } else {
#line 3559
      xp = (double *) *xpp;
#line 3559
    }
#line 3559
   /* copy the next block */
#line 3559
#pragma cdir loopcnt=LOOPCNT
#line 3559
#pragma cdir shortloop
#line 3559
    for (i=0; i<ni; i++) {
#line 3559
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3559
     /* test for range errors (not always needed but do it anyway) */
#line 3559
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3559
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3559
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3559
    }
#line 3559
   /* update xpp and tp */
#line 3559
    if (realign) xp = (double *) *xpp;
#line 3559
    xp += ni;
#line 3559
    tp += ni;
#line 3559
    *xpp = (void*)xp;
#line 3559
  }
#line 3559
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3559

#line 3559
#else   /* not SX */
#line 3559
	const char *xp = (const char *) *xpp;
#line 3559
	int status = NC_NOERR;
#line 3559

#line 3559
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3559
	{
#line 3559
		const int lstatus = ncx_get_double_longlong(xp, tp);
#line 3559
		if (status == NC_NOERR) /* report the first encountered error */
#line 3559
			status = lstatus;
#line 3559
	}
#line 3559

#line 3559
	*xpp = (const void *)xp;
#line 3559
	return status;
#line 3559
#endif
#line 3559
}
#line 3559

int
#line 3560
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3560
{
#line 3560
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3560

#line 3560
 /* basic algorithm is:
#line 3560
  *   - ensure sane alignment of input data
#line 3560
  *   - copy (conversion happens automatically) input data
#line 3560
  *     to output
#line 3560
  *   - update xpp to point at next unconverted input, and tp to point
#line 3560
  *     at next location for converted output
#line 3560
  */
#line 3560
  long i, j, ni;
#line 3560
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3560
  double *xp;
#line 3560
  int nrange = 0;         /* number of range errors */
#line 3560
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3560
  long cxp = (long) *((char**)xpp);
#line 3560

#line 3560
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3560
  /* sjl: manually stripmine so we can limit amount of
#line 3560
   * vector work space reserved to LOOPCNT elements. Also
#line 3560
   * makes vectorisation easy */
#line 3560
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3560
    ni=Min(nelems-j,LOOPCNT);
#line 3560
    if (realign) {
#line 3560
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3560
      xp = tmp;
#line 3560
    } else {
#line 3560
      xp = (double *) *xpp;
#line 3560
    }
#line 3560
   /* copy the next block */
#line 3560
#pragma cdir loopcnt=LOOPCNT
#line 3560
#pragma cdir shortloop
#line 3560
    for (i=0; i<ni; i++) {
#line 3560
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3560
     /* test for range errors (not always needed but do it anyway) */
#line 3560
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3560
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3560
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3560
    }
#line 3560
   /* update xpp and tp */
#line 3560
    if (realign) xp = (double *) *xpp;
#line 3560
    xp += ni;
#line 3560
    tp += ni;
#line 3560
    *xpp = (void*)xp;
#line 3560
  }
#line 3560
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3560

#line 3560
#else   /* not SX */
#line 3560
	const char *xp = (const char *) *xpp;
#line 3560
	int status = NC_NOERR;
#line 3560

#line 3560
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3560
	{
#line 3560
		const int lstatus = ncx_get_double_uchar(xp, tp);
#line 3560
		if (status == NC_NOERR) /* report the first encountered error */
#line 3560
			status = lstatus;
#line 3560
	}
#line 3560

#line 3560
	*xpp = (const void *)xp;
#line 3560
	return status;
#line 3560
#endif
#line 3560
}
#line 3560

int
#line 3561
ncx_getn_double_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3561
{
#line 3561
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3561

#line 3561
 /* basic algorithm is:
#line 3561
  *   - ensure sane alignment of input data
#line 3561
  *   - copy (conversion happens automatically) input data
#line 3561
  *     to output
#line 3561
  *   - update xpp to point at next unconverted input, and tp to point
#line 3561
  *     at next location for converted output
#line 3561
  */
#line 3561
  long i, j, ni;
#line 3561
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3561
  double *xp;
#line 3561
  int nrange = 0;         /* number of range errors */
#line 3561
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3561
  long cxp = (long) *((char**)xpp);
#line 3561

#line 3561
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3561
  /* sjl: manually stripmine so we can limit amount of
#line 3561
   * vector work space reserved to LOOPCNT elements. Also
#line 3561
   * makes vectorisation easy */
#line 3561
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3561
    ni=Min(nelems-j,LOOPCNT);
#line 3561
    if (realign) {
#line 3561
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3561
      xp = tmp;
#line 3561
    } else {
#line 3561
      xp = (double *) *xpp;
#line 3561
    }
#line 3561
   /* copy the next block */
#line 3561
#pragma cdir loopcnt=LOOPCNT
#line 3561
#pragma cdir shortloop
#line 3561
    for (i=0; i<ni; i++) {
#line 3561
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3561
     /* test for range errors (not always needed but do it anyway) */
#line 3561
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3561
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3561
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3561
    }
#line 3561
   /* update xpp and tp */
#line 3561
    if (realign) xp = (double *) *xpp;
#line 3561
    xp += ni;
#line 3561
    tp += ni;
#line 3561
    *xpp = (void*)xp;
#line 3561
  }
#line 3561
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3561

#line 3561
#else   /* not SX */
#line 3561
	const char *xp = (const char *) *xpp;
#line 3561
	int status = NC_NOERR;
#line 3561

#line 3561
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3561
	{
#line 3561
		const int lstatus = ncx_get_double_ushort(xp, tp);
#line 3561
		if (status == NC_NOERR) /* report the first encountered error */
#line 3561
			status = lstatus;
#line 3561
	}
#line 3561

#line 3561
	*xpp = (const void *)xp;
#line 3561
	return status;
#line 3561
#endif
#line 3561
}
#line 3561

int
#line 3562
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
#line 3562
{
#line 3562
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3562

#line 3562
 /* basic algorithm is:
#line 3562
  *   - ensure sane alignment of input data
#line 3562
  *   - copy (conversion happens automatically) input data
#line 3562
  *     to output
#line 3562
  *   - update xpp to point at next unconverted input, and tp to point
#line 3562
  *     at next location for converted output
#line 3562
  */
#line 3562
  long i, j, ni;
#line 3562
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3562
  double *xp;
#line 3562
  int nrange = 0;         /* number of range errors */
#line 3562
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3562
  long cxp = (long) *((char**)xpp);
#line 3562

#line 3562
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3562
  /* sjl: manually stripmine so we can limit amount of
#line 3562
   * vector work space reserved to LOOPCNT elements. Also
#line 3562
   * makes vectorisation easy */
#line 3562
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3562
    ni=Min(nelems-j,LOOPCNT);
#line 3562
    if (realign) {
#line 3562
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3562
      xp = tmp;
#line 3562
    } else {
#line 3562
      xp = (double *) *xpp;
#line 3562
    }
#line 3562
   /* copy the next block */
#line 3562
#pragma cdir loopcnt=LOOPCNT
#line 3562
#pragma cdir shortloop
#line 3562
    for (i=0; i<ni; i++) {
#line 3562
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3562
     /* test for range errors (not always needed but do it anyway) */
#line 3562
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3562
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3562
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3562
    }
#line 3562
   /* update xpp and tp */
#line 3562
    if (realign) xp = (double *) *xpp;
#line 3562
    xp += ni;
#line 3562
    tp += ni;
#line 3562
    *xpp = (void*)xp;
#line 3562
  }
#line 3562
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3562

#line 3562
#else   /* not SX */
#line 3562
	const char *xp = (const char *) *xpp;
#line 3562
	int status = NC_NOERR;
#line 3562

#line 3562
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3562
	{
#line 3562
		const int lstatus = ncx_get_double_uint(xp, tp);
#line 3562
		if (status == NC_NOERR) /* report the first encountered error */
#line 3562
			status = lstatus;
#line 3562
	}
#line 3562

#line 3562
	*xpp = (const void *)xp;
#line 3562
	return status;
#line 3562
#endif
#line 3562
}
#line 3562

int
#line 3563
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3563
{
#line 3563
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3563

#line 3563
 /* basic algorithm is:
#line 3563
  *   - ensure sane alignment of input data
#line 3563
  *   - copy (conversion happens automatically) input data
#line 3563
  *     to output
#line 3563
  *   - update xpp to point at next unconverted input, and tp to point
#line 3563
  *     at next location for converted output
#line 3563
  */
#line 3563
  long i, j, ni;
#line 3563
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3563
  double *xp;
#line 3563
  int nrange = 0;         /* number of range errors */
#line 3563
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3563
  long cxp = (long) *((char**)xpp);
#line 3563

#line 3563
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3563
  /* sjl: manually stripmine so we can limit amount of
#line 3563
   * vector work space reserved to LOOPCNT elements. Also
#line 3563
   * makes vectorisation easy */
#line 3563
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3563
    ni=Min(nelems-j,LOOPCNT);
#line 3563
    if (realign) {
#line 3563
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3563
      xp = tmp;
#line 3563
    } else {
#line 3563
      xp = (double *) *xpp;
#line 3563
    }
#line 3563
   /* copy the next block */
#line 3563
#pragma cdir loopcnt=LOOPCNT
#line 3563
#pragma cdir shortloop
#line 3563
    for (i=0; i<ni; i++) {
#line 3563
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3563
     /* test for range errors (not always needed but do it anyway) */
#line 3563
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3563
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3563
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3563
    }
#line 3563
   /* update xpp and tp */
#line 3563
    if (realign) xp = (double *) *xpp;
#line 3563
    xp += ni;
#line 3563
    tp += ni;
#line 3563
    *xpp = (void*)xp;
#line 3563
  }
#line 3563
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3563

#line 3563
#else   /* not SX */
#line 3563
	const char *xp = (const char *) *xpp;
#line 3563
	int status = NC_NOERR;
#line 3563

#line 3563
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3563
	{
#line 3563
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
#line 3563
		if (status == NC_NOERR) /* report the first encountered error */
#line 3563
			status = lstatus;
#line 3563
	}
#line 3563

#line 3563
	*xpp = (const void *)xp;
#line 3563
	return status;
#line 3563
#endif
#line 3563
}
#line 3563


#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip, void *fillp)
{
	const double *const end = ip + ndoubles;

	while (ip < end)
	{
	const struct vax_double *const vdp =
#line 3586
			(const struct vax_double *)ip;
#line 3586
	struct ieee_double *const idp =
#line 3586
			 (struct ieee_double *) (*xpp);
#line 3586

#line 3586
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 3586
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 3586
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 3586
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 3586
		(vdp->exp == dbl_limits[0].d.exp))
#line 3586
	{
#line 3586
		*idp = dbl_limits[0].ieee;
#line 3586
		goto shipit;
#line 3586
	}
#line 3586
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 3586
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 3586
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 3586
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 3586
		(vdp->exp == dbl_limits[1].d.exp))
#line 3586
	{
#line 3586
		*idp = dbl_limits[1].ieee;
#line 3586
		goto shipit;
#line 3586
	}
#line 3586

#line 3586
	{
#line 3586
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 3586

#line 3586
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 3586
			(vdp->mantissa3 << 13) |
#line 3586
			((vdp->mantissa4 >> 3) & MASK(13));
#line 3586

#line 3586
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 3586
				 | (vdp->mantissa2 >> 3);
#line 3586

#line 3586
		if ((vdp->mantissa4 & 7) > 4)
#line 3586
		{
#line 3586
			/* round up */
#line 3586
			mant_lo++;
#line 3586
			if (mant_lo == 0)
#line 3586
			{
#line 3586
				mant_hi++;
#line 3586
				if (mant_hi > 0xffffff)
#line 3586
				{
#line 3586
					mant_hi = 0;
#line 3586
					exp++;
#line 3586
				}
#line 3586
			}
#line 3586
		}
#line 3586

#line 3586
		idp->mant_lo = SWAP4(mant_lo);
#line 3586
		idp->mant_6 = mant_hi >> 16;
#line 3586
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 3586
		idp->mant_4 = mant_hi;
#line 3586
		idp->exp_hi = exp >> 4;
#line 3586
		idp->exp_lo = exp;
#line 3586
	}
#line 3586

#line 3586
	shipit:
#line 3586
		idp->sign = vdp->sign;
#line 3586

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3611
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3611
{
#line 3611
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3611

#line 3611
 /* basic algorithm is:
#line 3611
  *   - ensure sane alignment of output data
#line 3611
  *   - copy (conversion happens automatically) input data
#line 3611
  *     to output
#line 3611
  *   - update tp to point at next unconverted input, and xpp to point
#line 3611
  *     at next location for converted output
#line 3611
  */
#line 3611
  long i, j, ni;
#line 3611
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3611
  double *xp;
#line 3611
  int nrange = 0;         /* number of range errors */
#line 3611
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3611
  long cxp = (long) *((char**)xpp);
#line 3611

#line 3611
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3611
  /* sjl: manually stripmine so we can limit amount of
#line 3611
   * vector work space reserved to LOOPCNT elements. Also
#line 3611
   * makes vectorisation easy */
#line 3611
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3611
    ni=Min(nelems-j,LOOPCNT);
#line 3611
    if (realign) {
#line 3611
      xp = tmp;
#line 3611
    } else {
#line 3611
      xp = (double *) *xpp;
#line 3611
    }
#line 3611
   /* copy the next block */
#line 3611
#pragma cdir loopcnt=LOOPCNT
#line 3611
#pragma cdir shortloop
#line 3611
    for (i=0; i<ni; i++) {
#line 3611
      /* the normal case: */
#line 3611
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3611
     /* test for range errors (not always needed but do it anyway) */
#line 3611
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3611
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3611
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3611
    }
#line 3611
   /* copy workspace back if necessary */
#line 3611
    if (realign) {
#line 3611
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3611
      xp = (double *) *xpp;
#line 3611
    }
#line 3611
   /* update xpp and tp */
#line 3611
    xp += ni;
#line 3611
    tp += ni;
#line 3611
    *xpp = (void*)xp;
#line 3611
  }
#line 3611
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3611

#line 3611
#else   /* not SX */
#line 3611

#line 3611
	char *xp = (char *) *xpp;
#line 3611
	int status = NC_NOERR;
#line 3611

#line 3611
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3611
	{
#line 3611
		int lstatus = ncx_put_double_schar(xp, tp, fillp);
#line 3611
		if (status == NC_NOERR) /* report the first encountered error */
#line 3611
			status = lstatus;
#line 3611
	}
#line 3611

#line 3611
	*xpp = (void *)xp;
#line 3611
	return status;
#line 3611
#endif
#line 3611
}
#line 3611

int
#line 3612
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3612
{
#line 3612
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3612

#line 3612
 /* basic algorithm is:
#line 3612
  *   - ensure sane alignment of output data
#line 3612
  *   - copy (conversion happens automatically) input data
#line 3612
  *     to output
#line 3612
  *   - update tp to point at next unconverted input, and xpp to point
#line 3612
  *     at next location for converted output
#line 3612
  */
#line 3612
  long i, j, ni;
#line 3612
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3612
  double *xp;
#line 3612
  int nrange = 0;         /* number of range errors */
#line 3612
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3612
  long cxp = (long) *((char**)xpp);
#line 3612

#line 3612
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3612
  /* sjl: manually stripmine so we can limit amount of
#line 3612
   * vector work space reserved to LOOPCNT elements. Also
#line 3612
   * makes vectorisation easy */
#line 3612
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3612
    ni=Min(nelems-j,LOOPCNT);
#line 3612
    if (realign) {
#line 3612
      xp = tmp;
#line 3612
    } else {
#line 3612
      xp = (double *) *xpp;
#line 3612
    }
#line 3612
   /* copy the next block */
#line 3612
#pragma cdir loopcnt=LOOPCNT
#line 3612
#pragma cdir shortloop
#line 3612
    for (i=0; i<ni; i++) {
#line 3612
      /* the normal case: */
#line 3612
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3612
     /* test for range errors (not always needed but do it anyway) */
#line 3612
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3612
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3612
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3612
    }
#line 3612
   /* copy workspace back if necessary */
#line 3612
    if (realign) {
#line 3612
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3612
      xp = (double *) *xpp;
#line 3612
    }
#line 3612
   /* update xpp and tp */
#line 3612
    xp += ni;
#line 3612
    tp += ni;
#line 3612
    *xpp = (void*)xp;
#line 3612
  }
#line 3612
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3612

#line 3612
#else   /* not SX */
#line 3612

#line 3612
	char *xp = (char *) *xpp;
#line 3612
	int status = NC_NOERR;
#line 3612

#line 3612
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3612
	{
#line 3612
		int lstatus = ncx_put_double_short(xp, tp, fillp);
#line 3612
		if (status == NC_NOERR) /* report the first encountered error */
#line 3612
			status = lstatus;
#line 3612
	}
#line 3612

#line 3612
	*xpp = (void *)xp;
#line 3612
	return status;
#line 3612
#endif
#line 3612
}
#line 3612

int
#line 3613
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3613
{
#line 3613
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3613

#line 3613
 /* basic algorithm is:
#line 3613
  *   - ensure sane alignment of output data
#line 3613
  *   - copy (conversion happens automatically) input data
#line 3613
  *     to output
#line 3613
  *   - update tp to point at next unconverted input, and xpp to point
#line 3613
  *     at next location for converted output
#line 3613
  */
#line 3613
  long i, j, ni;
#line 3613
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3613
  double *xp;
#line 3613
  int nrange = 0;         /* number of range errors */
#line 3613
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3613
  long cxp = (long) *((char**)xpp);
#line 3613

#line 3613
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3613
  /* sjl: manually stripmine so we can limit amount of
#line 3613
   * vector work space reserved to LOOPCNT elements. Also
#line 3613
   * makes vectorisation easy */
#line 3613
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3613
    ni=Min(nelems-j,LOOPCNT);
#line 3613
    if (realign) {
#line 3613
      xp = tmp;
#line 3613
    } else {
#line 3613
      xp = (double *) *xpp;
#line 3613
    }
#line 3613
   /* copy the next block */
#line 3613
#pragma cdir loopcnt=LOOPCNT
#line 3613
#pragma cdir shortloop
#line 3613
    for (i=0; i<ni; i++) {
#line 3613
      /* the normal case: */
#line 3613
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3613
     /* test for range errors (not always needed but do it anyway) */
#line 3613
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3613
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3613
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3613
    }
#line 3613
   /* copy workspace back if necessary */
#line 3613
    if (realign) {
#line 3613
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3613
      xp = (double *) *xpp;
#line 3613
    }
#line 3613
   /* update xpp and tp */
#line 3613
    xp += ni;
#line 3613
    tp += ni;
#line 3613
    *xpp = (void*)xp;
#line 3613
  }
#line 3613
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3613

#line 3613
#else   /* not SX */
#line 3613

#line 3613
	char *xp = (char *) *xpp;
#line 3613
	int status = NC_NOERR;
#line 3613

#line 3613
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3613
	{
#line 3613
		int lstatus = ncx_put_double_int(xp, tp, fillp);
#line 3613
		if (status == NC_NOERR) /* report the first encountered error */
#line 3613
			status = lstatus;
#line 3613
	}
#line 3613

#line 3613
	*xpp = (void *)xp;
#line 3613
	return status;
#line 3613
#endif
#line 3613
}
#line 3613

int
#line 3614
ncx_putn_double_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3614
{
#line 3614
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3614

#line 3614
 /* basic algorithm is:
#line 3614
  *   - ensure sane alignment of output data
#line 3614
  *   - copy (conversion happens automatically) input data
#line 3614
  *     to output
#line 3614
  *   - update tp to point at next unconverted input, and xpp to point
#line 3614
  *     at next location for converted output
#line 3614
  */
#line 3614
  long i, j, ni;
#line 3614
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3614
  double *xp;
#line 3614
  int nrange = 0;         /* number of range errors */
#line 3614
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3614
  long cxp = (long) *((char**)xpp);
#line 3614

#line 3614
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3614
  /* sjl: manually stripmine so we can limit amount of
#line 3614
   * vector work space reserved to LOOPCNT elements. Also
#line 3614
   * makes vectorisation easy */
#line 3614
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3614
    ni=Min(nelems-j,LOOPCNT);
#line 3614
    if (realign) {
#line 3614
      xp = tmp;
#line 3614
    } else {
#line 3614
      xp = (double *) *xpp;
#line 3614
    }
#line 3614
   /* copy the next block */
#line 3614
#pragma cdir loopcnt=LOOPCNT
#line 3614
#pragma cdir shortloop
#line 3614
    for (i=0; i<ni; i++) {
#line 3614
      /* the normal case: */
#line 3614
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3614
     /* test for range errors (not always needed but do it anyway) */
#line 3614
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3614
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3614
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3614
    }
#line 3614
   /* copy workspace back if necessary */
#line 3614
    if (realign) {
#line 3614
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3614
      xp = (double *) *xpp;
#line 3614
    }
#line 3614
   /* update xpp and tp */
#line 3614
    xp += ni;
#line 3614
    tp += ni;
#line 3614
    *xpp = (void*)xp;
#line 3614
  }
#line 3614
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3614

#line 3614
#else   /* not SX */
#line 3614

#line 3614
	char *xp = (char *) *xpp;
#line 3614
	int status = NC_NOERR;
#line 3614

#line 3614
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3614
	{
#line 3614
		int lstatus = ncx_put_double_long(xp, tp, fillp);
#line 3614
		if (status == NC_NOERR) /* report the first encountered error */
#line 3614
			status = lstatus;
#line 3614
	}
#line 3614

#line 3614
	*xpp = (void *)xp;
#line 3614
	return status;
#line 3614
#endif
#line 3614
}
#line 3614

int
#line 3615
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3615
{
#line 3615
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3615

#line 3615
 /* basic algorithm is:
#line 3615
  *   - ensure sane alignment of output data
#line 3615
  *   - copy (conversion happens automatically) input data
#line 3615
  *     to output
#line 3615
  *   - update tp to point at next unconverted input, and xpp to point
#line 3615
  *     at next location for converted output
#line 3615
  */
#line 3615
  long i, j, ni;
#line 3615
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3615
  double *xp;
#line 3615
  int nrange = 0;         /* number of range errors */
#line 3615
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3615
  long cxp = (long) *((char**)xpp);
#line 3615

#line 3615
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3615
  /* sjl: manually stripmine so we can limit amount of
#line 3615
   * vector work space reserved to LOOPCNT elements. Also
#line 3615
   * makes vectorisation easy */
#line 3615
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3615
    ni=Min(nelems-j,LOOPCNT);
#line 3615
    if (realign) {
#line 3615
      xp = tmp;
#line 3615
    } else {
#line 3615
      xp = (double *) *xpp;
#line 3615
    }
#line 3615
   /* copy the next block */
#line 3615
#pragma cdir loopcnt=LOOPCNT
#line 3615
#pragma cdir shortloop
#line 3615
    for (i=0; i<ni; i++) {
#line 3615
      /* the normal case: */
#line 3615
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3615
     /* test for range errors (not always needed but do it anyway) */
#line 3615
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3615
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3615
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3615
    }
#line 3615
   /* copy workspace back if necessary */
#line 3615
    if (realign) {
#line 3615
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3615
      xp = (double *) *xpp;
#line 3615
    }
#line 3615
   /* update xpp and tp */
#line 3615
    xp += ni;
#line 3615
    tp += ni;
#line 3615
    *xpp = (void*)xp;
#line 3615
  }
#line 3615
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3615

#line 3615
#else   /* not SX */
#line 3615

#line 3615
	char *xp = (char *) *xpp;
#line 3615
	int status = NC_NOERR;
#line 3615

#line 3615
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3615
	{
#line 3615
		int lstatus = ncx_put_double_float(xp, tp, fillp);
#line 3615
		if (status == NC_NOERR) /* report the first encountered error */
#line 3615
			status = lstatus;
#line 3615
	}
#line 3615

#line 3615
	*xpp = (void *)xp;
#line 3615
	return status;
#line 3615
#endif
#line 3615
}
#line 3615

int
#line 3616
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3616
{
#line 3616
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3616

#line 3616
 /* basic algorithm is:
#line 3616
  *   - ensure sane alignment of output data
#line 3616
  *   - copy (conversion happens automatically) input data
#line 3616
  *     to output
#line 3616
  *   - update tp to point at next unconverted input, and xpp to point
#line 3616
  *     at next location for converted output
#line 3616
  */
#line 3616
  long i, j, ni;
#line 3616
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3616
  double *xp;
#line 3616
  int nrange = 0;         /* number of range errors */
#line 3616
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3616
  long cxp = (long) *((char**)xpp);
#line 3616

#line 3616
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3616
  /* sjl: manually stripmine so we can limit amount of
#line 3616
   * vector work space reserved to LOOPCNT elements. Also
#line 3616
   * makes vectorisation easy */
#line 3616
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3616
    ni=Min(nelems-j,LOOPCNT);
#line 3616
    if (realign) {
#line 3616
      xp = tmp;
#line 3616
    } else {
#line 3616
      xp = (double *) *xpp;
#line 3616
    }
#line 3616
   /* copy the next block */
#line 3616
#pragma cdir loopcnt=LOOPCNT
#line 3616
#pragma cdir shortloop
#line 3616
    for (i=0; i<ni; i++) {
#line 3616
      /* the normal case: */
#line 3616
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3616
     /* test for range errors (not always needed but do it anyway) */
#line 3616
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3616
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3616
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3616
    }
#line 3616
   /* copy workspace back if necessary */
#line 3616
    if (realign) {
#line 3616
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3616
      xp = (double *) *xpp;
#line 3616
    }
#line 3616
   /* update xpp and tp */
#line 3616
    xp += ni;
#line 3616
    tp += ni;
#line 3616
    *xpp = (void*)xp;
#line 3616
  }
#line 3616
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3616

#line 3616
#else   /* not SX */
#line 3616

#line 3616
	char *xp = (char *) *xpp;
#line 3616
	int status = NC_NOERR;
#line 3616

#line 3616
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3616
	{
#line 3616
		int lstatus = ncx_put_double_longlong(xp, tp, fillp);
#line 3616
		if (status == NC_NOERR) /* report the first encountered error */
#line 3616
			status = lstatus;
#line 3616
	}
#line 3616

#line 3616
	*xpp = (void *)xp;
#line 3616
	return status;
#line 3616
#endif
#line 3616
}
#line 3616

int
#line 3617
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3617
{
#line 3617
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3617

#line 3617
 /* basic algorithm is:
#line 3617
  *   - ensure sane alignment of output data
#line 3617
  *   - copy (conversion happens automatically) input data
#line 3617
  *     to output
#line 3617
  *   - update tp to point at next unconverted input, and xpp to point
#line 3617
  *     at next location for converted output
#line 3617
  */
#line 3617
  long i, j, ni;
#line 3617
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3617
  double *xp;
#line 3617
  int nrange = 0;         /* number of range errors */
#line 3617
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3617
  long cxp = (long) *((char**)xpp);
#line 3617

#line 3617
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3617
  /* sjl: manually stripmine so we can limit amount of
#line 3617
   * vector work space reserved to LOOPCNT elements. Also
#line 3617
   * makes vectorisation easy */
#line 3617
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3617
    ni=Min(nelems-j,LOOPCNT);
#line 3617
    if (realign) {
#line 3617
      xp = tmp;
#line 3617
    } else {
#line 3617
      xp = (double *) *xpp;
#line 3617
    }
#line 3617
   /* copy the next block */
#line 3617
#pragma cdir loopcnt=LOOPCNT
#line 3617
#pragma cdir shortloop
#line 3617
    for (i=0; i<ni; i++) {
#line 3617
      /* the normal case: */
#line 3617
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3617
     /* test for range errors (not always needed but do it anyway) */
#line 3617
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3617
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3617
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3617
    }
#line 3617
   /* copy workspace back if necessary */
#line 3617
    if (realign) {
#line 3617
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3617
      xp = (double *) *xpp;
#line 3617
    }
#line 3617
   /* update xpp and tp */
#line 3617
    xp += ni;
#line 3617
    tp += ni;
#line 3617
    *xpp = (void*)xp;
#line 3617
  }
#line 3617
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3617

#line 3617
#else   /* not SX */
#line 3617

#line 3617
	char *xp = (char *) *xpp;
#line 3617
	int status = NC_NOERR;
#line 3617

#line 3617
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3617
	{
#line 3617
		int lstatus = ncx_put_double_uchar(xp, tp, fillp);
#line 3617
		if (status == NC_NOERR) /* report the first encountered error */
#line 3617
			status = lstatus;
#line 3617
	}
#line 3617

#line 3617
	*xpp = (void *)xp;
#line 3617
	return status;
#line 3617
#endif
#line 3617
}
#line 3617

int
#line 3618
ncx_putn_double_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3618
{
#line 3618
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3618

#line 3618
 /* basic algorithm is:
#line 3618
  *   - ensure sane alignment of output data
#line 3618
  *   - copy (conversion happens automatically) input data
#line 3618
  *     to output
#line 3618
  *   - update tp to point at next unconverted input, and xpp to point
#line 3618
  *     at next location for converted output
#line 3618
  */
#line 3618
  long i, j, ni;
#line 3618
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3618
  double *xp;
#line 3618
  int nrange = 0;         /* number of range errors */
#line 3618
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3618
  long cxp = (long) *((char**)xpp);
#line 3618

#line 3618
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3618
  /* sjl: manually stripmine so we can limit amount of
#line 3618
   * vector work space reserved to LOOPCNT elements. Also
#line 3618
   * makes vectorisation easy */
#line 3618
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3618
    ni=Min(nelems-j,LOOPCNT);
#line 3618
    if (realign) {
#line 3618
      xp = tmp;
#line 3618
    } else {
#line 3618
      xp = (double *) *xpp;
#line 3618
    }
#line 3618
   /* copy the next block */
#line 3618
#pragma cdir loopcnt=LOOPCNT
#line 3618
#pragma cdir shortloop
#line 3618
    for (i=0; i<ni; i++) {
#line 3618
      /* the normal case: */
#line 3618
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3618
     /* test for range errors (not always needed but do it anyway) */
#line 3618
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3618
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3618
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3618
    }
#line 3618
   /* copy workspace back if necessary */
#line 3618
    if (realign) {
#line 3618
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3618
      xp = (double *) *xpp;
#line 3618
    }
#line 3618
   /* update xpp and tp */
#line 3618
    xp += ni;
#line 3618
    tp += ni;
#line 3618
    *xpp = (void*)xp;
#line 3618
  }
#line 3618
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3618

#line 3618
#else   /* not SX */
#line 3618

#line 3618
	char *xp = (char *) *xpp;
#line 3618
	int status = NC_NOERR;
#line 3618

#line 3618
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3618
	{
#line 3618
		int lstatus = ncx_put_double_ushort(xp, tp, fillp);
#line 3618
		if (status == NC_NOERR) /* report the first encountered error */
#line 3618
			status = lstatus;
#line 3618
	}
#line 3618

#line 3618
	*xpp = (void *)xp;
#line 3618
	return status;
#line 3618
#endif
#line 3618
}
#line 3618

int
#line 3619
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3619
{
#line 3619
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3619

#line 3619
 /* basic algorithm is:
#line 3619
  *   - ensure sane alignment of output data
#line 3619
  *   - copy (conversion happens automatically) input data
#line 3619
  *     to output
#line 3619
  *   - update tp to point at next unconverted input, and xpp to point
#line 3619
  *     at next location for converted output
#line 3619
  */
#line 3619
  long i, j, ni;
#line 3619
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3619
  double *xp;
#line 3619
  int nrange = 0;         /* number of range errors */
#line 3619
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3619
  long cxp = (long) *((char**)xpp);
#line 3619

#line 3619
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3619
  /* sjl: manually stripmine so we can limit amount of
#line 3619
   * vector work space reserved to LOOPCNT elements. Also
#line 3619
   * makes vectorisation easy */
#line 3619
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3619
    ni=Min(nelems-j,LOOPCNT);
#line 3619
    if (realign) {
#line 3619
      xp = tmp;
#line 3619
    } else {
#line 3619
      xp = (double *) *xpp;
#line 3619
    }
#line 3619
   /* copy the next block */
#line 3619
#pragma cdir loopcnt=LOOPCNT
#line 3619
#pragma cdir shortloop
#line 3619
    for (i=0; i<ni; i++) {
#line 3619
      /* the normal case: */
#line 3619
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3619
     /* test for range errors (not always needed but do it anyway) */
#line 3619
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3619
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3619
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3619
    }
#line 3619
   /* copy workspace back if necessary */
#line 3619
    if (realign) {
#line 3619
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3619
      xp = (double *) *xpp;
#line 3619
    }
#line 3619
   /* update xpp and tp */
#line 3619
    xp += ni;
#line 3619
    tp += ni;
#line 3619
    *xpp = (void*)xp;
#line 3619
  }
#line 3619
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3619

#line 3619
#else   /* not SX */
#line 3619

#line 3619
	char *xp = (char *) *xpp;
#line 3619
	int status = NC_NOERR;
#line 3619

#line 3619
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3619
	{
#line 3619
		int lstatus = ncx_put_double_uint(xp, tp, fillp);
#line 3619
		if (status == NC_NOERR) /* report the first encountered error */
#line 3619
			status = lstatus;
#line 3619
	}
#line 3619

#line 3619
	*xpp = (void *)xp;
#line 3619
	return status;
#line 3619
#endif
#line 3619
}
#line 3619

int
#line 3620
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3620
{
#line 3620
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3620

#line 3620
 /* basic algorithm is:
#line 3620
  *   - ensure sane alignment of output data
#line 3620
  *   - copy (conversion happens automatically) input data
#line 3620
  *     to output
#line 3620
  *   - update tp to point at next unconverted input, and xpp to point
#line 3620
  *     at next location for converted output
#line 3620
  */
#line 3620
  long i, j, ni;
#line 3620
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3620
  double *xp;
#line 3620
  int nrange = 0;         /* number of range errors */
#line 3620
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3620
  long cxp = (long) *((char**)xpp);
#line 3620

#line 3620
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3620
  /* sjl: manually stripmine so we can limit amount of
#line 3620
   * vector work space reserved to LOOPCNT elements. Also
#line 3620
   * makes vectorisation easy */
#line 3620
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3620
    ni=Min(nelems-j,LOOPCNT);
#line 3620
    if (realign) {
#line 3620
      xp = tmp;
#line 3620
    } else {
#line 3620
      xp = (double *) *xpp;
#line 3620
    }
#line 3620
   /* copy the next block */
#line 3620
#pragma cdir loopcnt=LOOPCNT
#line 3620
#pragma cdir shortloop
#line 3620
    for (i=0; i<ni; i++) {
#line 3620
      /* the normal case: */
#line 3620
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3620
     /* test for range errors (not always needed but do it anyway) */
#line 3620
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3620
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3620
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3620
    }
#line 3620
   /* copy workspace back if necessary */
#line 3620
    if (realign) {
#line 3620
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3620
      xp = (double *) *xpp;
#line 3620
    }
#line 3620
   /* update xpp and tp */
#line 3620
    xp += ni;
#line 3620
    tp += ni;
#line 3620
    *xpp = (void*)xp;
#line 3620
  }
#line 3620
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3620

#line 3620
#else   /* not SX */
#line 3620

#line 3620
	char *xp = (char *) *xpp;
#line 3620
	int status = NC_NOERR;
#line 3620

#line 3620
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3620
	{
#line 3620
		int lstatus = ncx_put_double_ulonglong(xp, tp, fillp);
#line 3620
		if (status == NC_NOERR) /* report the first encountered error */
#line 3620
			status = lstatus;
#line 3620
	}
#line 3620

#line 3620
	*xpp = (void *)xp;
#line 3620
	return status;
#line 3620
#endif
#line 3620
}
#line 3620



/* longlong ------------------------------------------------------------------*/

#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3639
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3639
{
#line 3639
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3639

#line 3639
 /* basic algorithm is:
#line 3639
  *   - ensure sane alignment of input data
#line 3639
  *   - copy (conversion happens automatically) input data
#line 3639
  *     to output
#line 3639
  *   - update xpp to point at next unconverted input, and tp to point
#line 3639
  *     at next location for converted output
#line 3639
  */
#line 3639
  long i, j, ni;
#line 3639
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3639
  int64 *xp;
#line 3639
  int nrange = 0;         /* number of range errors */
#line 3639
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3639
  long cxp = (long) *((char**)xpp);
#line 3639

#line 3639
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3639
  /* sjl: manually stripmine so we can limit amount of
#line 3639
   * vector work space reserved to LOOPCNT elements. Also
#line 3639
   * makes vectorisation easy */
#line 3639
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3639
    ni=Min(nelems-j,LOOPCNT);
#line 3639
    if (realign) {
#line 3639
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3639
      xp = tmp;
#line 3639
    } else {
#line 3639
      xp = (int64 *) *xpp;
#line 3639
    }
#line 3639
   /* copy the next block */
#line 3639
#pragma cdir loopcnt=LOOPCNT
#line 3639
#pragma cdir shortloop
#line 3639
    for (i=0; i<ni; i++) {
#line 3639
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3639
     /* test for range errors (not always needed but do it anyway) */
#line 3639
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3639
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3639
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3639
    }
#line 3639
   /* update xpp and tp */
#line 3639
    if (realign) xp = (int64 *) *xpp;
#line 3639
    xp += ni;
#line 3639
    tp += ni;
#line 3639
    *xpp = (void*)xp;
#line 3639
  }
#line 3639
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3639

#line 3639
#else   /* not SX */
#line 3639
	const char *xp = (const char *) *xpp;
#line 3639
	int status = NC_NOERR;
#line 3639

#line 3639
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3639
	{
#line 3639
		const int lstatus = ncx_get_longlong_longlong(xp, tp);
#line 3639
		if (status == NC_NOERR) /* report the first encountered error */
#line 3639
			status = lstatus;
#line 3639
	}
#line 3639

#line 3639
	*xpp = (const void *)xp;
#line 3639
	return status;
#line 3639
#endif
#line 3639
}
#line 3639

#endif
int
#line 3641
ncx_getn_longlong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3641
{
#line 3641
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3641

#line 3641
 /* basic algorithm is:
#line 3641
  *   - ensure sane alignment of input data
#line 3641
  *   - copy (conversion happens automatically) input data
#line 3641
  *     to output
#line 3641
  *   - update xpp to point at next unconverted input, and tp to point
#line 3641
  *     at next location for converted output
#line 3641
  */
#line 3641
  long i, j, ni;
#line 3641
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3641
  int64 *xp;
#line 3641
  int nrange = 0;         /* number of range errors */
#line 3641
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3641
  long cxp = (long) *((char**)xpp);
#line 3641

#line 3641
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3641
  /* sjl: manually stripmine so we can limit amount of
#line 3641
   * vector work space reserved to LOOPCNT elements. Also
#line 3641
   * makes vectorisation easy */
#line 3641
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3641
    ni=Min(nelems-j,LOOPCNT);
#line 3641
    if (realign) {
#line 3641
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3641
      xp = tmp;
#line 3641
    } else {
#line 3641
      xp = (int64 *) *xpp;
#line 3641
    }
#line 3641
   /* copy the next block */
#line 3641
#pragma cdir loopcnt=LOOPCNT
#line 3641
#pragma cdir shortloop
#line 3641
    for (i=0; i<ni; i++) {
#line 3641
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3641
     /* test for range errors (not always needed but do it anyway) */
#line 3641
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3641
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3641
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3641
    }
#line 3641
   /* update xpp and tp */
#line 3641
    if (realign) xp = (int64 *) *xpp;
#line 3641
    xp += ni;
#line 3641
    tp += ni;
#line 3641
    *xpp = (void*)xp;
#line 3641
  }
#line 3641
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3641

#line 3641
#else   /* not SX */
#line 3641
	const char *xp = (const char *) *xpp;
#line 3641
	int status = NC_NOERR;
#line 3641

#line 3641
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3641
	{
#line 3641
		const int lstatus = ncx_get_longlong_schar(xp, tp);
#line 3641
		if (status == NC_NOERR) /* report the first encountered error */
#line 3641
			status = lstatus;
#line 3641
	}
#line 3641

#line 3641
	*xpp = (const void *)xp;
#line 3641
	return status;
#line 3641
#endif
#line 3641
}
#line 3641

int
#line 3642
ncx_getn_longlong_short(const void **xpp, size_t nelems, short *tp)
#line 3642
{
#line 3642
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3642

#line 3642
 /* basic algorithm is:
#line 3642
  *   - ensure sane alignment of input data
#line 3642
  *   - copy (conversion happens automatically) input data
#line 3642
  *     to output
#line 3642
  *   - update xpp to point at next unconverted input, and tp to point
#line 3642
  *     at next location for converted output
#line 3642
  */
#line 3642
  long i, j, ni;
#line 3642
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3642
  int64 *xp;
#line 3642
  int nrange = 0;         /* number of range errors */
#line 3642
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3642
  long cxp = (long) *((char**)xpp);
#line 3642

#line 3642
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3642
  /* sjl: manually stripmine so we can limit amount of
#line 3642
   * vector work space reserved to LOOPCNT elements. Also
#line 3642
   * makes vectorisation easy */
#line 3642
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3642
    ni=Min(nelems-j,LOOPCNT);
#line 3642
    if (realign) {
#line 3642
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3642
      xp = tmp;
#line 3642
    } else {
#line 3642
      xp = (int64 *) *xpp;
#line 3642
    }
#line 3642
   /* copy the next block */
#line 3642
#pragma cdir loopcnt=LOOPCNT
#line 3642
#pragma cdir shortloop
#line 3642
    for (i=0; i<ni; i++) {
#line 3642
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3642
     /* test for range errors (not always needed but do it anyway) */
#line 3642
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3642
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3642
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3642
    }
#line 3642
   /* update xpp and tp */
#line 3642
    if (realign) xp = (int64 *) *xpp;
#line 3642
    xp += ni;
#line 3642
    tp += ni;
#line 3642
    *xpp = (void*)xp;
#line 3642
  }
#line 3642
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3642

#line 3642
#else   /* not SX */
#line 3642
	const char *xp = (const char *) *xpp;
#line 3642
	int status = NC_NOERR;
#line 3642

#line 3642
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3642
	{
#line 3642
		const int lstatus = ncx_get_longlong_short(xp, tp);
#line 3642
		if (status == NC_NOERR) /* report the first encountered error */
#line 3642
			status = lstatus;
#line 3642
	}
#line 3642

#line 3642
	*xpp = (const void *)xp;
#line 3642
	return status;
#line 3642
#endif
#line 3642
}
#line 3642

int
#line 3643
ncx_getn_longlong_int(const void **xpp, size_t nelems, int *tp)
#line 3643
{
#line 3643
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3643

#line 3643
 /* basic algorithm is:
#line 3643
  *   - ensure sane alignment of input data
#line 3643
  *   - copy (conversion happens automatically) input data
#line 3643
  *     to output
#line 3643
  *   - update xpp to point at next unconverted input, and tp to point
#line 3643
  *     at next location for converted output
#line 3643
  */
#line 3643
  long i, j, ni;
#line 3643
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3643
  int64 *xp;
#line 3643
  int nrange = 0;         /* number of range errors */
#line 3643
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3643
  long cxp = (long) *((char**)xpp);
#line 3643

#line 3643
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3643
  /* sjl: manually stripmine so we can limit amount of
#line 3643
   * vector work space reserved to LOOPCNT elements. Also
#line 3643
   * makes vectorisation easy */
#line 3643
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3643
    ni=Min(nelems-j,LOOPCNT);
#line 3643
    if (realign) {
#line 3643
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3643
      xp = tmp;
#line 3643
    } else {
#line 3643
      xp = (int64 *) *xpp;
#line 3643
    }
#line 3643
   /* copy the next block */
#line 3643
#pragma cdir loopcnt=LOOPCNT
#line 3643
#pragma cdir shortloop
#line 3643
    for (i=0; i<ni; i++) {
#line 3643
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3643
     /* test for range errors (not always needed but do it anyway) */
#line 3643
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3643
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3643
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3643
    }
#line 3643
   /* update xpp and tp */
#line 3643
    if (realign) xp = (int64 *) *xpp;
#line 3643
    xp += ni;
#line 3643
    tp += ni;
#line 3643
    *xpp = (void*)xp;
#line 3643
  }
#line 3643
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3643

#line 3643
#else   /* not SX */
#line 3643
	const char *xp = (const char *) *xpp;
#line 3643
	int status = NC_NOERR;
#line 3643

#line 3643
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3643
	{
#line 3643
		const int lstatus = ncx_get_longlong_int(xp, tp);
#line 3643
		if (status == NC_NOERR) /* report the first encountered error */
#line 3643
			status = lstatus;
#line 3643
	}
#line 3643

#line 3643
	*xpp = (const void *)xp;
#line 3643
	return status;
#line 3643
#endif
#line 3643
}
#line 3643

int
#line 3644
ncx_getn_longlong_long(const void **xpp, size_t nelems, long *tp)
#line 3644
{
#line 3644
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3644

#line 3644
 /* basic algorithm is:
#line 3644
  *   - ensure sane alignment of input data
#line 3644
  *   - copy (conversion happens automatically) input data
#line 3644
  *     to output
#line 3644
  *   - update xpp to point at next unconverted input, and tp to point
#line 3644
  *     at next location for converted output
#line 3644
  */
#line 3644
  long i, j, ni;
#line 3644
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3644
  int64 *xp;
#line 3644
  int nrange = 0;         /* number of range errors */
#line 3644
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3644
  long cxp = (long) *((char**)xpp);
#line 3644

#line 3644
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3644
  /* sjl: manually stripmine so we can limit amount of
#line 3644
   * vector work space reserved to LOOPCNT elements. Also
#line 3644
   * makes vectorisation easy */
#line 3644
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3644
    ni=Min(nelems-j,LOOPCNT);
#line 3644
    if (realign) {
#line 3644
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3644
      xp = tmp;
#line 3644
    } else {
#line 3644
      xp = (int64 *) *xpp;
#line 3644
    }
#line 3644
   /* copy the next block */
#line 3644
#pragma cdir loopcnt=LOOPCNT
#line 3644
#pragma cdir shortloop
#line 3644
    for (i=0; i<ni; i++) {
#line 3644
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3644
     /* test for range errors (not always needed but do it anyway) */
#line 3644
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3644
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3644
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3644
    }
#line 3644
   /* update xpp and tp */
#line 3644
    if (realign) xp = (int64 *) *xpp;
#line 3644
    xp += ni;
#line 3644
    tp += ni;
#line 3644
    *xpp = (void*)xp;
#line 3644
  }
#line 3644
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3644

#line 3644
#else   /* not SX */
#line 3644
	const char *xp = (const char *) *xpp;
#line 3644
	int status = NC_NOERR;
#line 3644

#line 3644
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3644
	{
#line 3644
		const int lstatus = ncx_get_longlong_long(xp, tp);
#line 3644
		if (status == NC_NOERR) /* report the first encountered error */
#line 3644
			status = lstatus;
#line 3644
	}
#line 3644

#line 3644
	*xpp = (const void *)xp;
#line 3644
	return status;
#line 3644
#endif
#line 3644
}
#line 3644

int
#line 3645
ncx_getn_longlong_float(const void **xpp, size_t nelems, float *tp)
#line 3645
{
#line 3645
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3645

#line 3645
 /* basic algorithm is:
#line 3645
  *   - ensure sane alignment of input data
#line 3645
  *   - copy (conversion happens automatically) input data
#line 3645
  *     to output
#line 3645
  *   - update xpp to point at next unconverted input, and tp to point
#line 3645
  *     at next location for converted output
#line 3645
  */
#line 3645
  long i, j, ni;
#line 3645
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3645
  int64 *xp;
#line 3645
  int nrange = 0;         /* number of range errors */
#line 3645
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3645
  long cxp = (long) *((char**)xpp);
#line 3645

#line 3645
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3645
  /* sjl: manually stripmine so we can limit amount of
#line 3645
   * vector work space reserved to LOOPCNT elements. Also
#line 3645
   * makes vectorisation easy */
#line 3645
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3645
    ni=Min(nelems-j,LOOPCNT);
#line 3645
    if (realign) {
#line 3645
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3645
      xp = tmp;
#line 3645
    } else {
#line 3645
      xp = (int64 *) *xpp;
#line 3645
    }
#line 3645
   /* copy the next block */
#line 3645
#pragma cdir loopcnt=LOOPCNT
#line 3645
#pragma cdir shortloop
#line 3645
    for (i=0; i<ni; i++) {
#line 3645
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3645
     /* test for range errors (not always needed but do it anyway) */
#line 3645
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3645
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3645
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3645
    }
#line 3645
   /* update xpp and tp */
#line 3645
    if (realign) xp = (int64 *) *xpp;
#line 3645
    xp += ni;
#line 3645
    tp += ni;
#line 3645
    *xpp = (void*)xp;
#line 3645
  }
#line 3645
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3645

#line 3645
#else   /* not SX */
#line 3645
	const char *xp = (const char *) *xpp;
#line 3645
	int status = NC_NOERR;
#line 3645

#line 3645
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3645
	{
#line 3645
		const int lstatus = ncx_get_longlong_float(xp, tp);
#line 3645
		if (status == NC_NOERR) /* report the first encountered error */
#line 3645
			status = lstatus;
#line 3645
	}
#line 3645

#line 3645
	*xpp = (const void *)xp;
#line 3645
	return status;
#line 3645
#endif
#line 3645
}
#line 3645

int
#line 3646
ncx_getn_longlong_double(const void **xpp, size_t nelems, double *tp)
#line 3646
{
#line 3646
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3646

#line 3646
 /* basic algorithm is:
#line 3646
  *   - ensure sane alignment of input data
#line 3646
  *   - copy (conversion happens automatically) input data
#line 3646
  *     to output
#line 3646
  *   - update xpp to point at next unconverted input, and tp to point
#line 3646
  *     at next location for converted output
#line 3646
  */
#line 3646
  long i, j, ni;
#line 3646
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3646
  int64 *xp;
#line 3646
  int nrange = 0;         /* number of range errors */
#line 3646
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3646
  long cxp = (long) *((char**)xpp);
#line 3646

#line 3646
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3646
  /* sjl: manually stripmine so we can limit amount of
#line 3646
   * vector work space reserved to LOOPCNT elements. Also
#line 3646
   * makes vectorisation easy */
#line 3646
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3646
    ni=Min(nelems-j,LOOPCNT);
#line 3646
    if (realign) {
#line 3646
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3646
      xp = tmp;
#line 3646
    } else {
#line 3646
      xp = (int64 *) *xpp;
#line 3646
    }
#line 3646
   /* copy the next block */
#line 3646
#pragma cdir loopcnt=LOOPCNT
#line 3646
#pragma cdir shortloop
#line 3646
    for (i=0; i<ni; i++) {
#line 3646
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3646
     /* test for range errors (not always needed but do it anyway) */
#line 3646
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3646
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3646
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3646
    }
#line 3646
   /* update xpp and tp */
#line 3646
    if (realign) xp = (int64 *) *xpp;
#line 3646
    xp += ni;
#line 3646
    tp += ni;
#line 3646
    *xpp = (void*)xp;
#line 3646
  }
#line 3646
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3646

#line 3646
#else   /* not SX */
#line 3646
	const char *xp = (const char *) *xpp;
#line 3646
	int status = NC_NOERR;
#line 3646

#line 3646
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3646
	{
#line 3646
		const int lstatus = ncx_get_longlong_double(xp, tp);
#line 3646
		if (status == NC_NOERR) /* report the first encountered error */
#line 3646
			status = lstatus;
#line 3646
	}
#line 3646

#line 3646
	*xpp = (const void *)xp;
#line 3646
	return status;
#line 3646
#endif
#line 3646
}
#line 3646

int
#line 3647
ncx_getn_longlong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3647
{
#line 3647
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3647

#line 3647
 /* basic algorithm is:
#line 3647
  *   - ensure sane alignment of input data
#line 3647
  *   - copy (conversion happens automatically) input data
#line 3647
  *     to output
#line 3647
  *   - update xpp to point at next unconverted input, and tp to point
#line 3647
  *     at next location for converted output
#line 3647
  */
#line 3647
  long i, j, ni;
#line 3647
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3647
  int64 *xp;
#line 3647
  int nrange = 0;         /* number of range errors */
#line 3647
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3647
  long cxp = (long) *((char**)xpp);
#line 3647

#line 3647
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3647
  /* sjl: manually stripmine so we can limit amount of
#line 3647
   * vector work space reserved to LOOPCNT elements. Also
#line 3647
   * makes vectorisation easy */
#line 3647
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3647
    ni=Min(nelems-j,LOOPCNT);
#line 3647
    if (realign) {
#line 3647
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3647
      xp = tmp;
#line 3647
    } else {
#line 3647
      xp = (int64 *) *xpp;
#line 3647
    }
#line 3647
   /* copy the next block */
#line 3647
#pragma cdir loopcnt=LOOPCNT
#line 3647
#pragma cdir shortloop
#line 3647
    for (i=0; i<ni; i++) {
#line 3647
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3647
     /* test for range errors (not always needed but do it anyway) */
#line 3647
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3647
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3647
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3647
    }
#line 3647
   /* update xpp and tp */
#line 3647
    if (realign) xp = (int64 *) *xpp;
#line 3647
    xp += ni;
#line 3647
    tp += ni;
#line 3647
    *xpp = (void*)xp;
#line 3647
  }
#line 3647
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3647

#line 3647
#else   /* not SX */
#line 3647
	const char *xp = (const char *) *xpp;
#line 3647
	int status = NC_NOERR;
#line 3647

#line 3647
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3647
	{
#line 3647
		const int lstatus = ncx_get_longlong_uchar(xp, tp);
#line 3647
		if (status == NC_NOERR) /* report the first encountered error */
#line 3647
			status = lstatus;
#line 3647
	}
#line 3647

#line 3647
	*xpp = (const void *)xp;
#line 3647
	return status;
#line 3647
#endif
#line 3647
}
#line 3647

int
#line 3648
ncx_getn_longlong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3648
{
#line 3648
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3648

#line 3648
 /* basic algorithm is:
#line 3648
  *   - ensure sane alignment of input data
#line 3648
  *   - copy (conversion happens automatically) input data
#line 3648
  *     to output
#line 3648
  *   - update xpp to point at next unconverted input, and tp to point
#line 3648
  *     at next location for converted output
#line 3648
  */
#line 3648
  long i, j, ni;
#line 3648
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3648
  int64 *xp;
#line 3648
  int nrange = 0;         /* number of range errors */
#line 3648
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3648
  long cxp = (long) *((char**)xpp);
#line 3648

#line 3648
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3648
  /* sjl: manually stripmine so we can limit amount of
#line 3648
   * vector work space reserved to LOOPCNT elements. Also
#line 3648
   * makes vectorisation easy */
#line 3648
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3648
    ni=Min(nelems-j,LOOPCNT);
#line 3648
    if (realign) {
#line 3648
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3648
      xp = tmp;
#line 3648
    } else {
#line 3648
      xp = (int64 *) *xpp;
#line 3648
    }
#line 3648
   /* copy the next block */
#line 3648
#pragma cdir loopcnt=LOOPCNT
#line 3648
#pragma cdir shortloop
#line 3648
    for (i=0; i<ni; i++) {
#line 3648
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3648
     /* test for range errors (not always needed but do it anyway) */
#line 3648
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3648
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3648
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3648
    }
#line 3648
   /* update xpp and tp */
#line 3648
    if (realign) xp = (int64 *) *xpp;
#line 3648
    xp += ni;
#line 3648
    tp += ni;
#line 3648
    *xpp = (void*)xp;
#line 3648
  }
#line 3648
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3648

#line 3648
#else   /* not SX */
#line 3648
	const char *xp = (const char *) *xpp;
#line 3648
	int status = NC_NOERR;
#line 3648

#line 3648
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3648
	{
#line 3648
		const int lstatus = ncx_get_longlong_ushort(xp, tp);
#line 3648
		if (status == NC_NOERR) /* report the first encountered error */
#line 3648
			status = lstatus;
#line 3648
	}
#line 3648

#line 3648
	*xpp = (const void *)xp;
#line 3648
	return status;
#line 3648
#endif
#line 3648
}
#line 3648

int
#line 3649
ncx_getn_longlong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3649
{
#line 3649
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3649

#line 3649
 /* basic algorithm is:
#line 3649
  *   - ensure sane alignment of input data
#line 3649
  *   - copy (conversion happens automatically) input data
#line 3649
  *     to output
#line 3649
  *   - update xpp to point at next unconverted input, and tp to point
#line 3649
  *     at next location for converted output
#line 3649
  */
#line 3649
  long i, j, ni;
#line 3649
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3649
  int64 *xp;
#line 3649
  int nrange = 0;         /* number of range errors */
#line 3649
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3649
  long cxp = (long) *((char**)xpp);
#line 3649

#line 3649
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3649
  /* sjl: manually stripmine so we can limit amount of
#line 3649
   * vector work space reserved to LOOPCNT elements. Also
#line 3649
   * makes vectorisation easy */
#line 3649
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3649
    ni=Min(nelems-j,LOOPCNT);
#line 3649
    if (realign) {
#line 3649
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3649
      xp = tmp;
#line 3649
    } else {
#line 3649
      xp = (int64 *) *xpp;
#line 3649
    }
#line 3649
   /* copy the next block */
#line 3649
#pragma cdir loopcnt=LOOPCNT
#line 3649
#pragma cdir shortloop
#line 3649
    for (i=0; i<ni; i++) {
#line 3649
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3649
     /* test for range errors (not always needed but do it anyway) */
#line 3649
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3649
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3649
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3649
    }
#line 3649
   /* update xpp and tp */
#line 3649
    if (realign) xp = (int64 *) *xpp;
#line 3649
    xp += ni;
#line 3649
    tp += ni;
#line 3649
    *xpp = (void*)xp;
#line 3649
  }
#line 3649
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3649

#line 3649
#else   /* not SX */
#line 3649
	const char *xp = (const char *) *xpp;
#line 3649
	int status = NC_NOERR;
#line 3649

#line 3649
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3649
	{
#line 3649
		const int lstatus = ncx_get_longlong_uint(xp, tp);
#line 3649
		if (status == NC_NOERR) /* report the first encountered error */
#line 3649
			status = lstatus;
#line 3649
	}
#line 3649

#line 3649
	*xpp = (const void *)xp;
#line 3649
	return status;
#line 3649
#endif
#line 3649
}
#line 3649

int
#line 3650
ncx_getn_longlong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3650
{
#line 3650
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3650

#line 3650
 /* basic algorithm is:
#line 3650
  *   - ensure sane alignment of input data
#line 3650
  *   - copy (conversion happens automatically) input data
#line 3650
  *     to output
#line 3650
  *   - update xpp to point at next unconverted input, and tp to point
#line 3650
  *     at next location for converted output
#line 3650
  */
#line 3650
  long i, j, ni;
#line 3650
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3650
  int64 *xp;
#line 3650
  int nrange = 0;         /* number of range errors */
#line 3650
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3650
  long cxp = (long) *((char**)xpp);
#line 3650

#line 3650
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3650
  /* sjl: manually stripmine so we can limit amount of
#line 3650
   * vector work space reserved to LOOPCNT elements. Also
#line 3650
   * makes vectorisation easy */
#line 3650
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3650
    ni=Min(nelems-j,LOOPCNT);
#line 3650
    if (realign) {
#line 3650
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3650
      xp = tmp;
#line 3650
    } else {
#line 3650
      xp = (int64 *) *xpp;
#line 3650
    }
#line 3650
   /* copy the next block */
#line 3650
#pragma cdir loopcnt=LOOPCNT
#line 3650
#pragma cdir shortloop
#line 3650
    for (i=0; i<ni; i++) {
#line 3650
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3650
     /* test for range errors (not always needed but do it anyway) */
#line 3650
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3650
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3650
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3650
    }
#line 3650
   /* update xpp and tp */
#line 3650
    if (realign) xp = (int64 *) *xpp;
#line 3650
    xp += ni;
#line 3650
    tp += ni;
#line 3650
    *xpp = (void*)xp;
#line 3650
  }
#line 3650
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3650

#line 3650
#else   /* not SX */
#line 3650
	const char *xp = (const char *) *xpp;
#line 3650
	int status = NC_NOERR;
#line 3650

#line 3650
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3650
	{
#line 3650
		const int lstatus = ncx_get_longlong_ulonglong(xp, tp);
#line 3650
		if (status == NC_NOERR) /* report the first encountered error */
#line 3650
			status = lstatus;
#line 3650
	}
#line 3650

#line 3650
	*xpp = (const void *)xp;
#line 3650
	return status;
#line 3650
#endif
#line 3650
}
#line 3650


#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3666
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3666
{
#line 3666
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3666

#line 3666
 /* basic algorithm is:
#line 3666
  *   - ensure sane alignment of output data
#line 3666
  *   - copy (conversion happens automatically) input data
#line 3666
  *     to output
#line 3666
  *   - update tp to point at next unconverted input, and xpp to point
#line 3666
  *     at next location for converted output
#line 3666
  */
#line 3666
  long i, j, ni;
#line 3666
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3666
  int64 *xp;
#line 3666
  int nrange = 0;         /* number of range errors */
#line 3666
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3666
  long cxp = (long) *((char**)xpp);
#line 3666

#line 3666
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3666
  /* sjl: manually stripmine so we can limit amount of
#line 3666
   * vector work space reserved to LOOPCNT elements. Also
#line 3666
   * makes vectorisation easy */
#line 3666
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3666
    ni=Min(nelems-j,LOOPCNT);
#line 3666
    if (realign) {
#line 3666
      xp = tmp;
#line 3666
    } else {
#line 3666
      xp = (int64 *) *xpp;
#line 3666
    }
#line 3666
   /* copy the next block */
#line 3666
#pragma cdir loopcnt=LOOPCNT
#line 3666
#pragma cdir shortloop
#line 3666
    for (i=0; i<ni; i++) {
#line 3666
      /* the normal case: */
#line 3666
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3666
     /* test for range errors (not always needed but do it anyway) */
#line 3666
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3666
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3666
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3666
    }
#line 3666
   /* copy workspace back if necessary */
#line 3666
    if (realign) {
#line 3666
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3666
      xp = (int64 *) *xpp;
#line 3666
    }
#line 3666
   /* update xpp and tp */
#line 3666
    xp += ni;
#line 3666
    tp += ni;
#line 3666
    *xpp = (void*)xp;
#line 3666
  }
#line 3666
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3666

#line 3666
#else   /* not SX */
#line 3666

#line 3666
	char *xp = (char *) *xpp;
#line 3666
	int status = NC_NOERR;
#line 3666

#line 3666
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3666
	{
#line 3666
		int lstatus = ncx_put_longlong_longlong(xp, tp, fillp);
#line 3666
		if (status == NC_NOERR) /* report the first encountered error */
#line 3666
			status = lstatus;
#line 3666
	}
#line 3666

#line 3666
	*xpp = (void *)xp;
#line 3666
	return status;
#line 3666
#endif
#line 3666
}
#line 3666

#endif
int
#line 3668
ncx_putn_longlong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3668
{
#line 3668
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3668

#line 3668
 /* basic algorithm is:
#line 3668
  *   - ensure sane alignment of output data
#line 3668
  *   - copy (conversion happens automatically) input data
#line 3668
  *     to output
#line 3668
  *   - update tp to point at next unconverted input, and xpp to point
#line 3668
  *     at next location for converted output
#line 3668
  */
#line 3668
  long i, j, ni;
#line 3668
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3668
  int64 *xp;
#line 3668
  int nrange = 0;         /* number of range errors */
#line 3668
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3668
  long cxp = (long) *((char**)xpp);
#line 3668

#line 3668
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3668
  /* sjl: manually stripmine so we can limit amount of
#line 3668
   * vector work space reserved to LOOPCNT elements. Also
#line 3668
   * makes vectorisation easy */
#line 3668
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3668
    ni=Min(nelems-j,LOOPCNT);
#line 3668
    if (realign) {
#line 3668
      xp = tmp;
#line 3668
    } else {
#line 3668
      xp = (int64 *) *xpp;
#line 3668
    }
#line 3668
   /* copy the next block */
#line 3668
#pragma cdir loopcnt=LOOPCNT
#line 3668
#pragma cdir shortloop
#line 3668
    for (i=0; i<ni; i++) {
#line 3668
      /* the normal case: */
#line 3668
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3668
     /* test for range errors (not always needed but do it anyway) */
#line 3668
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3668
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3668
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3668
    }
#line 3668
   /* copy workspace back if necessary */
#line 3668
    if (realign) {
#line 3668
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3668
      xp = (int64 *) *xpp;
#line 3668
    }
#line 3668
   /* update xpp and tp */
#line 3668
    xp += ni;
#line 3668
    tp += ni;
#line 3668
    *xpp = (void*)xp;
#line 3668
  }
#line 3668
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3668

#line 3668
#else   /* not SX */
#line 3668

#line 3668
	char *xp = (char *) *xpp;
#line 3668
	int status = NC_NOERR;
#line 3668

#line 3668
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3668
	{
#line 3668
		int lstatus = ncx_put_longlong_schar(xp, tp, fillp);
#line 3668
		if (status == NC_NOERR) /* report the first encountered error */
#line 3668
			status = lstatus;
#line 3668
	}
#line 3668

#line 3668
	*xpp = (void *)xp;
#line 3668
	return status;
#line 3668
#endif
#line 3668
}
#line 3668

int
#line 3669
ncx_putn_longlong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3669
{
#line 3669
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3669

#line 3669
 /* basic algorithm is:
#line 3669
  *   - ensure sane alignment of output data
#line 3669
  *   - copy (conversion happens automatically) input data
#line 3669
  *     to output
#line 3669
  *   - update tp to point at next unconverted input, and xpp to point
#line 3669
  *     at next location for converted output
#line 3669
  */
#line 3669
  long i, j, ni;
#line 3669
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3669
  int64 *xp;
#line 3669
  int nrange = 0;         /* number of range errors */
#line 3669
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3669
  long cxp = (long) *((char**)xpp);
#line 3669

#line 3669
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3669
  /* sjl: manually stripmine so we can limit amount of
#line 3669
   * vector work space reserved to LOOPCNT elements. Also
#line 3669
   * makes vectorisation easy */
#line 3669
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3669
    ni=Min(nelems-j,LOOPCNT);
#line 3669
    if (realign) {
#line 3669
      xp = tmp;
#line 3669
    } else {
#line 3669
      xp = (int64 *) *xpp;
#line 3669
    }
#line 3669
   /* copy the next block */
#line 3669
#pragma cdir loopcnt=LOOPCNT
#line 3669
#pragma cdir shortloop
#line 3669
    for (i=0; i<ni; i++) {
#line 3669
      /* the normal case: */
#line 3669
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3669
     /* test for range errors (not always needed but do it anyway) */
#line 3669
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3669
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3669
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3669
    }
#line 3669
   /* copy workspace back if necessary */
#line 3669
    if (realign) {
#line 3669
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3669
      xp = (int64 *) *xpp;
#line 3669
    }
#line 3669
   /* update xpp and tp */
#line 3669
    xp += ni;
#line 3669
    tp += ni;
#line 3669
    *xpp = (void*)xp;
#line 3669
  }
#line 3669
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3669

#line 3669
#else   /* not SX */
#line 3669

#line 3669
	char *xp = (char *) *xpp;
#line 3669
	int status = NC_NOERR;
#line 3669

#line 3669
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3669
	{
#line 3669
		int lstatus = ncx_put_longlong_short(xp, tp, fillp);
#line 3669
		if (status == NC_NOERR) /* report the first encountered error */
#line 3669
			status = lstatus;
#line 3669
	}
#line 3669

#line 3669
	*xpp = (void *)xp;
#line 3669
	return status;
#line 3669
#endif
#line 3669
}
#line 3669

int
#line 3670
ncx_putn_longlong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3670
{
#line 3670
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3670

#line 3670
 /* basic algorithm is:
#line 3670
  *   - ensure sane alignment of output data
#line 3670
  *   - copy (conversion happens automatically) input data
#line 3670
  *     to output
#line 3670
  *   - update tp to point at next unconverted input, and xpp to point
#line 3670
  *     at next location for converted output
#line 3670
  */
#line 3670
  long i, j, ni;
#line 3670
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3670
  int64 *xp;
#line 3670
  int nrange = 0;         /* number of range errors */
#line 3670
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3670
  long cxp = (long) *((char**)xpp);
#line 3670

#line 3670
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3670
  /* sjl: manually stripmine so we can limit amount of
#line 3670
   * vector work space reserved to LOOPCNT elements. Also
#line 3670
   * makes vectorisation easy */
#line 3670
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3670
    ni=Min(nelems-j,LOOPCNT);
#line 3670
    if (realign) {
#line 3670
      xp = tmp;
#line 3670
    } else {
#line 3670
      xp = (int64 *) *xpp;
#line 3670
    }
#line 3670
   /* copy the next block */
#line 3670
#pragma cdir loopcnt=LOOPCNT
#line 3670
#pragma cdir shortloop
#line 3670
    for (i=0; i<ni; i++) {
#line 3670
      /* the normal case: */
#line 3670
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3670
     /* test for range errors (not always needed but do it anyway) */
#line 3670
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3670
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3670
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3670
    }
#line 3670
   /* copy workspace back if necessary */
#line 3670
    if (realign) {
#line 3670
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3670
      xp = (int64 *) *xpp;
#line 3670
    }
#line 3670
   /* update xpp and tp */
#line 3670
    xp += ni;
#line 3670
    tp += ni;
#line 3670
    *xpp = (void*)xp;
#line 3670
  }
#line 3670
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3670

#line 3670
#else   /* not SX */
#line 3670

#line 3670
	char *xp = (char *) *xpp;
#line 3670
	int status = NC_NOERR;
#line 3670

#line 3670
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3670
	{
#line 3670
		int lstatus = ncx_put_longlong_int(xp, tp, fillp);
#line 3670
		if (status == NC_NOERR) /* report the first encountered error */
#line 3670
			status = lstatus;
#line 3670
	}
#line 3670

#line 3670
	*xpp = (void *)xp;
#line 3670
	return status;
#line 3670
#endif
#line 3670
}
#line 3670

int
#line 3671
ncx_putn_longlong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3671
{
#line 3671
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3671

#line 3671
 /* basic algorithm is:
#line 3671
  *   - ensure sane alignment of output data
#line 3671
  *   - copy (conversion happens automatically) input data
#line 3671
  *     to output
#line 3671
  *   - update tp to point at next unconverted input, and xpp to point
#line 3671
  *     at next location for converted output
#line 3671
  */
#line 3671
  long i, j, ni;
#line 3671
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3671
  int64 *xp;
#line 3671
  int nrange = 0;         /* number of range errors */
#line 3671
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3671
  long cxp = (long) *((char**)xpp);
#line 3671

#line 3671
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3671
  /* sjl: manually stripmine so we can limit amount of
#line 3671
   * vector work space reserved to LOOPCNT elements. Also
#line 3671
   * makes vectorisation easy */
#line 3671
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3671
    ni=Min(nelems-j,LOOPCNT);
#line 3671
    if (realign) {
#line 3671
      xp = tmp;
#line 3671
    } else {
#line 3671
      xp = (int64 *) *xpp;
#line 3671
    }
#line 3671
   /* copy the next block */
#line 3671
#pragma cdir loopcnt=LOOPCNT
#line 3671
#pragma cdir shortloop
#line 3671
    for (i=0; i<ni; i++) {
#line 3671
      /* the normal case: */
#line 3671
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3671
     /* test for range errors (not always needed but do it anyway) */
#line 3671
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3671
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3671
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3671
    }
#line 3671
   /* copy workspace back if necessary */
#line 3671
    if (realign) {
#line 3671
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3671
      xp = (int64 *) *xpp;
#line 3671
    }
#line 3671
   /* update xpp and tp */
#line 3671
    xp += ni;
#line 3671
    tp += ni;
#line 3671
    *xpp = (void*)xp;
#line 3671
  }
#line 3671
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3671

#line 3671
#else   /* not SX */
#line 3671

#line 3671
	char *xp = (char *) *xpp;
#line 3671
	int status = NC_NOERR;
#line 3671

#line 3671
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3671
	{
#line 3671
		int lstatus = ncx_put_longlong_long(xp, tp, fillp);
#line 3671
		if (status == NC_NOERR) /* report the first encountered error */
#line 3671
			status = lstatus;
#line 3671
	}
#line 3671

#line 3671
	*xpp = (void *)xp;
#line 3671
	return status;
#line 3671
#endif
#line 3671
}
#line 3671

int
#line 3672
ncx_putn_longlong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3672
{
#line 3672
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3672

#line 3672
 /* basic algorithm is:
#line 3672
  *   - ensure sane alignment of output data
#line 3672
  *   - copy (conversion happens automatically) input data
#line 3672
  *     to output
#line 3672
  *   - update tp to point at next unconverted input, and xpp to point
#line 3672
  *     at next location for converted output
#line 3672
  */
#line 3672
  long i, j, ni;
#line 3672
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3672
  int64 *xp;
#line 3672
  int nrange = 0;         /* number of range errors */
#line 3672
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3672
  long cxp = (long) *((char**)xpp);
#line 3672

#line 3672
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3672
  /* sjl: manually stripmine so we can limit amount of
#line 3672
   * vector work space reserved to LOOPCNT elements. Also
#line 3672
   * makes vectorisation easy */
#line 3672
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3672
    ni=Min(nelems-j,LOOPCNT);
#line 3672
    if (realign) {
#line 3672
      xp = tmp;
#line 3672
    } else {
#line 3672
      xp = (int64 *) *xpp;
#line 3672
    }
#line 3672
   /* copy the next block */
#line 3672
#pragma cdir loopcnt=LOOPCNT
#line 3672
#pragma cdir shortloop
#line 3672
    for (i=0; i<ni; i++) {
#line 3672
      /* the normal case: */
#line 3672
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3672
     /* test for range errors (not always needed but do it anyway) */
#line 3672
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3672
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3672
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3672
    }
#line 3672
   /* copy workspace back if necessary */
#line 3672
    if (realign) {
#line 3672
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3672
      xp = (int64 *) *xpp;
#line 3672
    }
#line 3672
   /* update xpp and tp */
#line 3672
    xp += ni;
#line 3672
    tp += ni;
#line 3672
    *xpp = (void*)xp;
#line 3672
  }
#line 3672
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3672

#line 3672
#else   /* not SX */
#line 3672

#line 3672
	char *xp = (char *) *xpp;
#line 3672
	int status = NC_NOERR;
#line 3672

#line 3672
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3672
	{
#line 3672
		int lstatus = ncx_put_longlong_float(xp, tp, fillp);
#line 3672
		if (status == NC_NOERR) /* report the first encountered error */
#line 3672
			status = lstatus;
#line 3672
	}
#line 3672

#line 3672
	*xpp = (void *)xp;
#line 3672
	return status;
#line 3672
#endif
#line 3672
}
#line 3672

int
#line 3673
ncx_putn_longlong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3673
{
#line 3673
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3673

#line 3673
 /* basic algorithm is:
#line 3673
  *   - ensure sane alignment of output data
#line 3673
  *   - copy (conversion happens automatically) input data
#line 3673
  *     to output
#line 3673
  *   - update tp to point at next unconverted input, and xpp to point
#line 3673
  *     at next location for converted output
#line 3673
  */
#line 3673
  long i, j, ni;
#line 3673
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3673
  int64 *xp;
#line 3673
  int nrange = 0;         /* number of range errors */
#line 3673
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3673
  long cxp = (long) *((char**)xpp);
#line 3673

#line 3673
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3673
  /* sjl: manually stripmine so we can limit amount of
#line 3673
   * vector work space reserved to LOOPCNT elements. Also
#line 3673
   * makes vectorisation easy */
#line 3673
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3673
    ni=Min(nelems-j,LOOPCNT);
#line 3673
    if (realign) {
#line 3673
      xp = tmp;
#line 3673
    } else {
#line 3673
      xp = (int64 *) *xpp;
#line 3673
    }
#line 3673
   /* copy the next block */
#line 3673
#pragma cdir loopcnt=LOOPCNT
#line 3673
#pragma cdir shortloop
#line 3673
    for (i=0; i<ni; i++) {
#line 3673
      /* the normal case: */
#line 3673
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3673
     /* test for range errors (not always needed but do it anyway) */
#line 3673
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3673
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3673
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3673
    }
#line 3673
   /* copy workspace back if necessary */
#line 3673
    if (realign) {
#line 3673
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3673
      xp = (int64 *) *xpp;
#line 3673
    }
#line 3673
   /* update xpp and tp */
#line 3673
    xp += ni;
#line 3673
    tp += ni;
#line 3673
    *xpp = (void*)xp;
#line 3673
  }
#line 3673
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3673

#line 3673
#else   /* not SX */
#line 3673

#line 3673
	char *xp = (char *) *xpp;
#line 3673
	int status = NC_NOERR;
#line 3673

#line 3673
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3673
	{
#line 3673
		int lstatus = ncx_put_longlong_double(xp, tp, fillp);
#line 3673
		if (status == NC_NOERR) /* report the first encountered error */
#line 3673
			status = lstatus;
#line 3673
	}
#line 3673

#line 3673
	*xpp = (void *)xp;
#line 3673
	return status;
#line 3673
#endif
#line 3673
}
#line 3673

int
#line 3674
ncx_putn_longlong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3674
{
#line 3674
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3674

#line 3674
 /* basic algorithm is:
#line 3674
  *   - ensure sane alignment of output data
#line 3674
  *   - copy (conversion happens automatically) input data
#line 3674
  *     to output
#line 3674
  *   - update tp to point at next unconverted input, and xpp to point
#line 3674
  *     at next location for converted output
#line 3674
  */
#line 3674
  long i, j, ni;
#line 3674
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3674
  int64 *xp;
#line 3674
  int nrange = 0;         /* number of range errors */
#line 3674
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3674
  long cxp = (long) *((char**)xpp);
#line 3674

#line 3674
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3674
  /* sjl: manually stripmine so we can limit amount of
#line 3674
   * vector work space reserved to LOOPCNT elements. Also
#line 3674
   * makes vectorisation easy */
#line 3674
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3674
    ni=Min(nelems-j,LOOPCNT);
#line 3674
    if (realign) {
#line 3674
      xp = tmp;
#line 3674
    } else {
#line 3674
      xp = (int64 *) *xpp;
#line 3674
    }
#line 3674
   /* copy the next block */
#line 3674
#pragma cdir loopcnt=LOOPCNT
#line 3674
#pragma cdir shortloop
#line 3674
    for (i=0; i<ni; i++) {
#line 3674
      /* the normal case: */
#line 3674
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3674
     /* test for range errors (not always needed but do it anyway) */
#line 3674
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3674
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3674
      nrange += tp[i] > X_INT64_MAX ;
#line 3674
    }
#line 3674
   /* copy workspace back if necessary */
#line 3674
    if (realign) {
#line 3674
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3674
      xp = (int64 *) *xpp;
#line 3674
    }
#line 3674
   /* update xpp and tp */
#line 3674
    xp += ni;
#line 3674
    tp += ni;
#line 3674
    *xpp = (void*)xp;
#line 3674
  }
#line 3674
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3674

#line 3674
#else   /* not SX */
#line 3674

#line 3674
	char *xp = (char *) *xpp;
#line 3674
	int status = NC_NOERR;
#line 3674

#line 3674
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3674
	{
#line 3674
		int lstatus = ncx_put_longlong_uchar(xp, tp, fillp);
#line 3674
		if (status == NC_NOERR) /* report the first encountered error */
#line 3674
			status = lstatus;
#line 3674
	}
#line 3674

#line 3674
	*xpp = (void *)xp;
#line 3674
	return status;
#line 3674
#endif
#line 3674
}
#line 3674

int
#line 3675
ncx_putn_longlong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3675
{
#line 3675
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3675

#line 3675
 /* basic algorithm is:
#line 3675
  *   - ensure sane alignment of output data
#line 3675
  *   - copy (conversion happens automatically) input data
#line 3675
  *     to output
#line 3675
  *   - update tp to point at next unconverted input, and xpp to point
#line 3675
  *     at next location for converted output
#line 3675
  */
#line 3675
  long i, j, ni;
#line 3675
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3675
  int64 *xp;
#line 3675
  int nrange = 0;         /* number of range errors */
#line 3675
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3675
  long cxp = (long) *((char**)xpp);
#line 3675

#line 3675
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3675
  /* sjl: manually stripmine so we can limit amount of
#line 3675
   * vector work space reserved to LOOPCNT elements. Also
#line 3675
   * makes vectorisation easy */
#line 3675
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3675
    ni=Min(nelems-j,LOOPCNT);
#line 3675
    if (realign) {
#line 3675
      xp = tmp;
#line 3675
    } else {
#line 3675
      xp = (int64 *) *xpp;
#line 3675
    }
#line 3675
   /* copy the next block */
#line 3675
#pragma cdir loopcnt=LOOPCNT
#line 3675
#pragma cdir shortloop
#line 3675
    for (i=0; i<ni; i++) {
#line 3675
      /* the normal case: */
#line 3675
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3675
     /* test for range errors (not always needed but do it anyway) */
#line 3675
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3675
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3675
      nrange += tp[i] > X_INT64_MAX ;
#line 3675
    }
#line 3675
   /* copy workspace back if necessary */
#line 3675
    if (realign) {
#line 3675
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3675
      xp = (int64 *) *xpp;
#line 3675
    }
#line 3675
   /* update xpp and tp */
#line 3675
    xp += ni;
#line 3675
    tp += ni;
#line 3675
    *xpp = (void*)xp;
#line 3675
  }
#line 3675
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3675

#line 3675
#else   /* not SX */
#line 3675

#line 3675
	char *xp = (char *) *xpp;
#line 3675
	int status = NC_NOERR;
#line 3675

#line 3675
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3675
	{
#line 3675
		int lstatus = ncx_put_longlong_ushort(xp, tp, fillp);
#line 3675
		if (status == NC_NOERR) /* report the first encountered error */
#line 3675
			status = lstatus;
#line 3675
	}
#line 3675

#line 3675
	*xpp = (void *)xp;
#line 3675
	return status;
#line 3675
#endif
#line 3675
}
#line 3675

int
#line 3676
ncx_putn_longlong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3676
{
#line 3676
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3676

#line 3676
 /* basic algorithm is:
#line 3676
  *   - ensure sane alignment of output data
#line 3676
  *   - copy (conversion happens automatically) input data
#line 3676
  *     to output
#line 3676
  *   - update tp to point at next unconverted input, and xpp to point
#line 3676
  *     at next location for converted output
#line 3676
  */
#line 3676
  long i, j, ni;
#line 3676
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3676
  int64 *xp;
#line 3676
  int nrange = 0;         /* number of range errors */
#line 3676
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3676
  long cxp = (long) *((char**)xpp);
#line 3676

#line 3676
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3676
  /* sjl: manually stripmine so we can limit amount of
#line 3676
   * vector work space reserved to LOOPCNT elements. Also
#line 3676
   * makes vectorisation easy */
#line 3676
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3676
    ni=Min(nelems-j,LOOPCNT);
#line 3676
    if (realign) {
#line 3676
      xp = tmp;
#line 3676
    } else {
#line 3676
      xp = (int64 *) *xpp;
#line 3676
    }
#line 3676
   /* copy the next block */
#line 3676
#pragma cdir loopcnt=LOOPCNT
#line 3676
#pragma cdir shortloop
#line 3676
    for (i=0; i<ni; i++) {
#line 3676
      /* the normal case: */
#line 3676
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3676
     /* test for range errors (not always needed but do it anyway) */
#line 3676
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3676
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3676
      nrange += tp[i] > X_INT64_MAX ;
#line 3676
    }
#line 3676
   /* copy workspace back if necessary */
#line 3676
    if (realign) {
#line 3676
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3676
      xp = (int64 *) *xpp;
#line 3676
    }
#line 3676
   /* update xpp and tp */
#line 3676
    xp += ni;
#line 3676
    tp += ni;
#line 3676
    *xpp = (void*)xp;
#line 3676
  }
#line 3676
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3676

#line 3676
#else   /* not SX */
#line 3676

#line 3676
	char *xp = (char *) *xpp;
#line 3676
	int status = NC_NOERR;
#line 3676

#line 3676
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3676
	{
#line 3676
		int lstatus = ncx_put_longlong_uint(xp, tp, fillp);
#line 3676
		if (status == NC_NOERR) /* report the first encountered error */
#line 3676
			status = lstatus;
#line 3676
	}
#line 3676

#line 3676
	*xpp = (void *)xp;
#line 3676
	return status;
#line 3676
#endif
#line 3676
}
#line 3676

int
#line 3677
ncx_putn_longlong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3677
{
#line 3677
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3677

#line 3677
 /* basic algorithm is:
#line 3677
  *   - ensure sane alignment of output data
#line 3677
  *   - copy (conversion happens automatically) input data
#line 3677
  *     to output
#line 3677
  *   - update tp to point at next unconverted input, and xpp to point
#line 3677
  *     at next location for converted output
#line 3677
  */
#line 3677
  long i, j, ni;
#line 3677
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3677
  int64 *xp;
#line 3677
  int nrange = 0;         /* number of range errors */
#line 3677
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3677
  long cxp = (long) *((char**)xpp);
#line 3677

#line 3677
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3677
  /* sjl: manually stripmine so we can limit amount of
#line 3677
   * vector work space reserved to LOOPCNT elements. Also
#line 3677
   * makes vectorisation easy */
#line 3677
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3677
    ni=Min(nelems-j,LOOPCNT);
#line 3677
    if (realign) {
#line 3677
      xp = tmp;
#line 3677
    } else {
#line 3677
      xp = (int64 *) *xpp;
#line 3677
    }
#line 3677
   /* copy the next block */
#line 3677
#pragma cdir loopcnt=LOOPCNT
#line 3677
#pragma cdir shortloop
#line 3677
    for (i=0; i<ni; i++) {
#line 3677
      /* the normal case: */
#line 3677
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3677
     /* test for range errors (not always needed but do it anyway) */
#line 3677
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3677
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3677
      nrange += tp[i] > X_INT64_MAX ;
#line 3677
    }
#line 3677
   /* copy workspace back if necessary */
#line 3677
    if (realign) {
#line 3677
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3677
      xp = (int64 *) *xpp;
#line 3677
    }
#line 3677
   /* update xpp and tp */
#line 3677
    xp += ni;
#line 3677
    tp += ni;
#line 3677
    *xpp = (void*)xp;
#line 3677
  }
#line 3677
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3677

#line 3677
#else   /* not SX */
#line 3677

#line 3677
	char *xp = (char *) *xpp;
#line 3677
	int status = NC_NOERR;
#line 3677

#line 3677
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3677
	{
#line 3677
		int lstatus = ncx_put_longlong_ulonglong(xp, tp, fillp);
#line 3677
		if (status == NC_NOERR) /* report the first encountered error */
#line 3677
			status = lstatus;
#line 3677
	}
#line 3677

#line 3677
	*xpp = (void *)xp;
#line 3677
	return status;
#line 3677
#endif
#line 3677
}
#line 3677


/* uint64 --------------------------------------------------------------------*/

#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UNSIGNED_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3695
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3695
{
#line 3695
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3695

#line 3695
 /* basic algorithm is:
#line 3695
  *   - ensure sane alignment of input data
#line 3695
  *   - copy (conversion happens automatically) input data
#line 3695
  *     to output
#line 3695
  *   - update xpp to point at next unconverted input, and tp to point
#line 3695
  *     at next location for converted output
#line 3695
  */
#line 3695
  long i, j, ni;
#line 3695
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3695
  uint64 *xp;
#line 3695
  int nrange = 0;         /* number of range errors */
#line 3695
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3695
  long cxp = (long) *((char**)xpp);
#line 3695

#line 3695
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3695
  /* sjl: manually stripmine so we can limit amount of
#line 3695
   * vector work space reserved to LOOPCNT elements. Also
#line 3695
   * makes vectorisation easy */
#line 3695
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3695
    ni=Min(nelems-j,LOOPCNT);
#line 3695
    if (realign) {
#line 3695
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3695
      xp = tmp;
#line 3695
    } else {
#line 3695
      xp = (uint64 *) *xpp;
#line 3695
    }
#line 3695
   /* copy the next block */
#line 3695
#pragma cdir loopcnt=LOOPCNT
#line 3695
#pragma cdir shortloop
#line 3695
    for (i=0; i<ni; i++) {
#line 3695
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3695
     /* test for range errors (not always needed but do it anyway) */
#line 3695
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3695
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3695
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3695
    }
#line 3695
   /* update xpp and tp */
#line 3695
    if (realign) xp = (uint64 *) *xpp;
#line 3695
    xp += ni;
#line 3695
    tp += ni;
#line 3695
    *xpp = (void*)xp;
#line 3695
  }
#line 3695
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3695

#line 3695
#else   /* not SX */
#line 3695
	const char *xp = (const char *) *xpp;
#line 3695
	int status = NC_NOERR;
#line 3695

#line 3695
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3695
	{
#line 3695
		const int lstatus = ncx_get_ulonglong_ulonglong(xp, tp);
#line 3695
		if (status == NC_NOERR) /* report the first encountered error */
#line 3695
			status = lstatus;
#line 3695
	}
#line 3695

#line 3695
	*xpp = (const void *)xp;
#line 3695
	return status;
#line 3695
#endif
#line 3695
}
#line 3695

#endif
int
#line 3697
ncx_getn_ulonglong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3697
{
#line 3697
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3697

#line 3697
 /* basic algorithm is:
#line 3697
  *   - ensure sane alignment of input data
#line 3697
  *   - copy (conversion happens automatically) input data
#line 3697
  *     to output
#line 3697
  *   - update xpp to point at next unconverted input, and tp to point
#line 3697
  *     at next location for converted output
#line 3697
  */
#line 3697
  long i, j, ni;
#line 3697
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3697
  uint64 *xp;
#line 3697
  int nrange = 0;         /* number of range errors */
#line 3697
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3697
  long cxp = (long) *((char**)xpp);
#line 3697

#line 3697
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3697
  /* sjl: manually stripmine so we can limit amount of
#line 3697
   * vector work space reserved to LOOPCNT elements. Also
#line 3697
   * makes vectorisation easy */
#line 3697
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3697
    ni=Min(nelems-j,LOOPCNT);
#line 3697
    if (realign) {
#line 3697
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3697
      xp = tmp;
#line 3697
    } else {
#line 3697
      xp = (uint64 *) *xpp;
#line 3697
    }
#line 3697
   /* copy the next block */
#line 3697
#pragma cdir loopcnt=LOOPCNT
#line 3697
#pragma cdir shortloop
#line 3697
    for (i=0; i<ni; i++) {
#line 3697
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3697
     /* test for range errors (not always needed but do it anyway) */
#line 3697
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3697
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3697
      nrange += xp[i] > SCHAR_MAX ;
#line 3697
    }
#line 3697
   /* update xpp and tp */
#line 3697
    if (realign) xp = (uint64 *) *xpp;
#line 3697
    xp += ni;
#line 3697
    tp += ni;
#line 3697
    *xpp = (void*)xp;
#line 3697
  }
#line 3697
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3697

#line 3697
#else   /* not SX */
#line 3697
	const char *xp = (const char *) *xpp;
#line 3697
	int status = NC_NOERR;
#line 3697

#line 3697
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3697
	{
#line 3697
		const int lstatus = ncx_get_ulonglong_schar(xp, tp);
#line 3697
		if (status == NC_NOERR) /* report the first encountered error */
#line 3697
			status = lstatus;
#line 3697
	}
#line 3697

#line 3697
	*xpp = (const void *)xp;
#line 3697
	return status;
#line 3697
#endif
#line 3697
}
#line 3697

int
#line 3698
ncx_getn_ulonglong_short(const void **xpp, size_t nelems, short *tp)
#line 3698
{
#line 3698
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3698

#line 3698
 /* basic algorithm is:
#line 3698
  *   - ensure sane alignment of input data
#line 3698
  *   - copy (conversion happens automatically) input data
#line 3698
  *     to output
#line 3698
  *   - update xpp to point at next unconverted input, and tp to point
#line 3698
  *     at next location for converted output
#line 3698
  */
#line 3698
  long i, j, ni;
#line 3698
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3698
  uint64 *xp;
#line 3698
  int nrange = 0;         /* number of range errors */
#line 3698
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3698
  long cxp = (long) *((char**)xpp);
#line 3698

#line 3698
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3698
  /* sjl: manually stripmine so we can limit amount of
#line 3698
   * vector work space reserved to LOOPCNT elements. Also
#line 3698
   * makes vectorisation easy */
#line 3698
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3698
    ni=Min(nelems-j,LOOPCNT);
#line 3698
    if (realign) {
#line 3698
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3698
      xp = tmp;
#line 3698
    } else {
#line 3698
      xp = (uint64 *) *xpp;
#line 3698
    }
#line 3698
   /* copy the next block */
#line 3698
#pragma cdir loopcnt=LOOPCNT
#line 3698
#pragma cdir shortloop
#line 3698
    for (i=0; i<ni; i++) {
#line 3698
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3698
     /* test for range errors (not always needed but do it anyway) */
#line 3698
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3698
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3698
      nrange += xp[i] > SHORT_MAX ;
#line 3698
    }
#line 3698
   /* update xpp and tp */
#line 3698
    if (realign) xp = (uint64 *) *xpp;
#line 3698
    xp += ni;
#line 3698
    tp += ni;
#line 3698
    *xpp = (void*)xp;
#line 3698
  }
#line 3698
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3698

#line 3698
#else   /* not SX */
#line 3698
	const char *xp = (const char *) *xpp;
#line 3698
	int status = NC_NOERR;
#line 3698

#line 3698
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3698
	{
#line 3698
		const int lstatus = ncx_get_ulonglong_short(xp, tp);
#line 3698
		if (status == NC_NOERR) /* report the first encountered error */
#line 3698
			status = lstatus;
#line 3698
	}
#line 3698

#line 3698
	*xpp = (const void *)xp;
#line 3698
	return status;
#line 3698
#endif
#line 3698
}
#line 3698

int
#line 3699
ncx_getn_ulonglong_int(const void **xpp, size_t nelems, int *tp)
#line 3699
{
#line 3699
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3699

#line 3699
 /* basic algorithm is:
#line 3699
  *   - ensure sane alignment of input data
#line 3699
  *   - copy (conversion happens automatically) input data
#line 3699
  *     to output
#line 3699
  *   - update xpp to point at next unconverted input, and tp to point
#line 3699
  *     at next location for converted output
#line 3699
  */
#line 3699
  long i, j, ni;
#line 3699
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3699
  uint64 *xp;
#line 3699
  int nrange = 0;         /* number of range errors */
#line 3699
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3699
  long cxp = (long) *((char**)xpp);
#line 3699

#line 3699
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3699
  /* sjl: manually stripmine so we can limit amount of
#line 3699
   * vector work space reserved to LOOPCNT elements. Also
#line 3699
   * makes vectorisation easy */
#line 3699
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3699
    ni=Min(nelems-j,LOOPCNT);
#line 3699
    if (realign) {
#line 3699
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3699
      xp = tmp;
#line 3699
    } else {
#line 3699
      xp = (uint64 *) *xpp;
#line 3699
    }
#line 3699
   /* copy the next block */
#line 3699
#pragma cdir loopcnt=LOOPCNT
#line 3699
#pragma cdir shortloop
#line 3699
    for (i=0; i<ni; i++) {
#line 3699
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3699
     /* test for range errors (not always needed but do it anyway) */
#line 3699
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3699
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3699
      nrange += xp[i] > INT_MAX ;
#line 3699
    }
#line 3699
   /* update xpp and tp */
#line 3699
    if (realign) xp = (uint64 *) *xpp;
#line 3699
    xp += ni;
#line 3699
    tp += ni;
#line 3699
    *xpp = (void*)xp;
#line 3699
  }
#line 3699
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3699

#line 3699
#else   /* not SX */
#line 3699
	const char *xp = (const char *) *xpp;
#line 3699
	int status = NC_NOERR;
#line 3699

#line 3699
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3699
	{
#line 3699
		const int lstatus = ncx_get_ulonglong_int(xp, tp);
#line 3699
		if (status == NC_NOERR) /* report the first encountered error */
#line 3699
			status = lstatus;
#line 3699
	}
#line 3699

#line 3699
	*xpp = (const void *)xp;
#line 3699
	return status;
#line 3699
#endif
#line 3699
}
#line 3699

int
#line 3700
ncx_getn_ulonglong_long(const void **xpp, size_t nelems, long *tp)
#line 3700
{
#line 3700
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3700

#line 3700
 /* basic algorithm is:
#line 3700
  *   - ensure sane alignment of input data
#line 3700
  *   - copy (conversion happens automatically) input data
#line 3700
  *     to output
#line 3700
  *   - update xpp to point at next unconverted input, and tp to point
#line 3700
  *     at next location for converted output
#line 3700
  */
#line 3700
  long i, j, ni;
#line 3700
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3700
  uint64 *xp;
#line 3700
  int nrange = 0;         /* number of range errors */
#line 3700
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3700
  long cxp = (long) *((char**)xpp);
#line 3700

#line 3700
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3700
  /* sjl: manually stripmine so we can limit amount of
#line 3700
   * vector work space reserved to LOOPCNT elements. Also
#line 3700
   * makes vectorisation easy */
#line 3700
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3700
    ni=Min(nelems-j,LOOPCNT);
#line 3700
    if (realign) {
#line 3700
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3700
      xp = tmp;
#line 3700
    } else {
#line 3700
      xp = (uint64 *) *xpp;
#line 3700
    }
#line 3700
   /* copy the next block */
#line 3700
#pragma cdir loopcnt=LOOPCNT
#line 3700
#pragma cdir shortloop
#line 3700
    for (i=0; i<ni; i++) {
#line 3700
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3700
     /* test for range errors (not always needed but do it anyway) */
#line 3700
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3700
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3700
      nrange += xp[i] > LONG_MAX ;
#line 3700
    }
#line 3700
   /* update xpp and tp */
#line 3700
    if (realign) xp = (uint64 *) *xpp;
#line 3700
    xp += ni;
#line 3700
    tp += ni;
#line 3700
    *xpp = (void*)xp;
#line 3700
  }
#line 3700
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3700

#line 3700
#else   /* not SX */
#line 3700
	const char *xp = (const char *) *xpp;
#line 3700
	int status = NC_NOERR;
#line 3700

#line 3700
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3700
	{
#line 3700
		const int lstatus = ncx_get_ulonglong_long(xp, tp);
#line 3700
		if (status == NC_NOERR) /* report the first encountered error */
#line 3700
			status = lstatus;
#line 3700
	}
#line 3700

#line 3700
	*xpp = (const void *)xp;
#line 3700
	return status;
#line 3700
#endif
#line 3700
}
#line 3700

int
#line 3701
ncx_getn_ulonglong_float(const void **xpp, size_t nelems, float *tp)
#line 3701
{
#line 3701
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3701

#line 3701
 /* basic algorithm is:
#line 3701
  *   - ensure sane alignment of input data
#line 3701
  *   - copy (conversion happens automatically) input data
#line 3701
  *     to output
#line 3701
  *   - update xpp to point at next unconverted input, and tp to point
#line 3701
  *     at next location for converted output
#line 3701
  */
#line 3701
  long i, j, ni;
#line 3701
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3701
  uint64 *xp;
#line 3701
  int nrange = 0;         /* number of range errors */
#line 3701
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3701
  long cxp = (long) *((char**)xpp);
#line 3701

#line 3701
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3701
  /* sjl: manually stripmine so we can limit amount of
#line 3701
   * vector work space reserved to LOOPCNT elements. Also
#line 3701
   * makes vectorisation easy */
#line 3701
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3701
    ni=Min(nelems-j,LOOPCNT);
#line 3701
    if (realign) {
#line 3701
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3701
      xp = tmp;
#line 3701
    } else {
#line 3701
      xp = (uint64 *) *xpp;
#line 3701
    }
#line 3701
   /* copy the next block */
#line 3701
#pragma cdir loopcnt=LOOPCNT
#line 3701
#pragma cdir shortloop
#line 3701
    for (i=0; i<ni; i++) {
#line 3701
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3701
     /* test for range errors (not always needed but do it anyway) */
#line 3701
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3701
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3701
      nrange += xp[i] > FLOAT_MAX ;
#line 3701
    }
#line 3701
   /* update xpp and tp */
#line 3701
    if (realign) xp = (uint64 *) *xpp;
#line 3701
    xp += ni;
#line 3701
    tp += ni;
#line 3701
    *xpp = (void*)xp;
#line 3701
  }
#line 3701
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3701

#line 3701
#else   /* not SX */
#line 3701
	const char *xp = (const char *) *xpp;
#line 3701
	int status = NC_NOERR;
#line 3701

#line 3701
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3701
	{
#line 3701
		const int lstatus = ncx_get_ulonglong_float(xp, tp);
#line 3701
		if (status == NC_NOERR) /* report the first encountered error */
#line 3701
			status = lstatus;
#line 3701
	}
#line 3701

#line 3701
	*xpp = (const void *)xp;
#line 3701
	return status;
#line 3701
#endif
#line 3701
}
#line 3701

int
#line 3702
ncx_getn_ulonglong_double(const void **xpp, size_t nelems, double *tp)
#line 3702
{
#line 3702
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3702

#line 3702
 /* basic algorithm is:
#line 3702
  *   - ensure sane alignment of input data
#line 3702
  *   - copy (conversion happens automatically) input data
#line 3702
  *     to output
#line 3702
  *   - update xpp to point at next unconverted input, and tp to point
#line 3702
  *     at next location for converted output
#line 3702
  */
#line 3702
  long i, j, ni;
#line 3702
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3702
  uint64 *xp;
#line 3702
  int nrange = 0;         /* number of range errors */
#line 3702
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3702
  long cxp = (long) *((char**)xpp);
#line 3702

#line 3702
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3702
  /* sjl: manually stripmine so we can limit amount of
#line 3702
   * vector work space reserved to LOOPCNT elements. Also
#line 3702
   * makes vectorisation easy */
#line 3702
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3702
    ni=Min(nelems-j,LOOPCNT);
#line 3702
    if (realign) {
#line 3702
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3702
      xp = tmp;
#line 3702
    } else {
#line 3702
      xp = (uint64 *) *xpp;
#line 3702
    }
#line 3702
   /* copy the next block */
#line 3702
#pragma cdir loopcnt=LOOPCNT
#line 3702
#pragma cdir shortloop
#line 3702
    for (i=0; i<ni; i++) {
#line 3702
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3702
     /* test for range errors (not always needed but do it anyway) */
#line 3702
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3702
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3702
      nrange += xp[i] > DOUBLE_MAX ;
#line 3702
    }
#line 3702
   /* update xpp and tp */
#line 3702
    if (realign) xp = (uint64 *) *xpp;
#line 3702
    xp += ni;
#line 3702
    tp += ni;
#line 3702
    *xpp = (void*)xp;
#line 3702
  }
#line 3702
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3702

#line 3702
#else   /* not SX */
#line 3702
	const char *xp = (const char *) *xpp;
#line 3702
	int status = NC_NOERR;
#line 3702

#line 3702
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3702
	{
#line 3702
		const int lstatus = ncx_get_ulonglong_double(xp, tp);
#line 3702
		if (status == NC_NOERR) /* report the first encountered error */
#line 3702
			status = lstatus;
#line 3702
	}
#line 3702

#line 3702
	*xpp = (const void *)xp;
#line 3702
	return status;
#line 3702
#endif
#line 3702
}
#line 3702

int
#line 3703
ncx_getn_ulonglong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3703
{
#line 3703
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3703

#line 3703
 /* basic algorithm is:
#line 3703
  *   - ensure sane alignment of input data
#line 3703
  *   - copy (conversion happens automatically) input data
#line 3703
  *     to output
#line 3703
  *   - update xpp to point at next unconverted input, and tp to point
#line 3703
  *     at next location for converted output
#line 3703
  */
#line 3703
  long i, j, ni;
#line 3703
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3703
  uint64 *xp;
#line 3703
  int nrange = 0;         /* number of range errors */
#line 3703
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3703
  long cxp = (long) *((char**)xpp);
#line 3703

#line 3703
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3703
  /* sjl: manually stripmine so we can limit amount of
#line 3703
   * vector work space reserved to LOOPCNT elements. Also
#line 3703
   * makes vectorisation easy */
#line 3703
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3703
    ni=Min(nelems-j,LOOPCNT);
#line 3703
    if (realign) {
#line 3703
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3703
      xp = tmp;
#line 3703
    } else {
#line 3703
      xp = (uint64 *) *xpp;
#line 3703
    }
#line 3703
   /* copy the next block */
#line 3703
#pragma cdir loopcnt=LOOPCNT
#line 3703
#pragma cdir shortloop
#line 3703
    for (i=0; i<ni; i++) {
#line 3703
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3703
     /* test for range errors (not always needed but do it anyway) */
#line 3703
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3703
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3703
      nrange += xp[i] > LONGLONG_MAX ;
#line 3703
    }
#line 3703
   /* update xpp and tp */
#line 3703
    if (realign) xp = (uint64 *) *xpp;
#line 3703
    xp += ni;
#line 3703
    tp += ni;
#line 3703
    *xpp = (void*)xp;
#line 3703
  }
#line 3703
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3703

#line 3703
#else   /* not SX */
#line 3703
	const char *xp = (const char *) *xpp;
#line 3703
	int status = NC_NOERR;
#line 3703

#line 3703
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3703
	{
#line 3703
		const int lstatus = ncx_get_ulonglong_longlong(xp, tp);
#line 3703
		if (status == NC_NOERR) /* report the first encountered error */
#line 3703
			status = lstatus;
#line 3703
	}
#line 3703

#line 3703
	*xpp = (const void *)xp;
#line 3703
	return status;
#line 3703
#endif
#line 3703
}
#line 3703

int
#line 3704
ncx_getn_ulonglong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3704
{
#line 3704
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3704

#line 3704
 /* basic algorithm is:
#line 3704
  *   - ensure sane alignment of input data
#line 3704
  *   - copy (conversion happens automatically) input data
#line 3704
  *     to output
#line 3704
  *   - update xpp to point at next unconverted input, and tp to point
#line 3704
  *     at next location for converted output
#line 3704
  */
#line 3704
  long i, j, ni;
#line 3704
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3704
  uint64 *xp;
#line 3704
  int nrange = 0;         /* number of range errors */
#line 3704
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3704
  long cxp = (long) *((char**)xpp);
#line 3704

#line 3704
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3704
  /* sjl: manually stripmine so we can limit amount of
#line 3704
   * vector work space reserved to LOOPCNT elements. Also
#line 3704
   * makes vectorisation easy */
#line 3704
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3704
    ni=Min(nelems-j,LOOPCNT);
#line 3704
    if (realign) {
#line 3704
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3704
      xp = tmp;
#line 3704
    } else {
#line 3704
      xp = (uint64 *) *xpp;
#line 3704
    }
#line 3704
   /* copy the next block */
#line 3704
#pragma cdir loopcnt=LOOPCNT
#line 3704
#pragma cdir shortloop
#line 3704
    for (i=0; i<ni; i++) {
#line 3704
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3704
     /* test for range errors (not always needed but do it anyway) */
#line 3704
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3704
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3704
      nrange += xp[i] > UCHAR_MAX ;
#line 3704
    }
#line 3704
   /* update xpp and tp */
#line 3704
    if (realign) xp = (uint64 *) *xpp;
#line 3704
    xp += ni;
#line 3704
    tp += ni;
#line 3704
    *xpp = (void*)xp;
#line 3704
  }
#line 3704
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3704

#line 3704
#else   /* not SX */
#line 3704
	const char *xp = (const char *) *xpp;
#line 3704
	int status = NC_NOERR;
#line 3704

#line 3704
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3704
	{
#line 3704
		const int lstatus = ncx_get_ulonglong_uchar(xp, tp);
#line 3704
		if (status == NC_NOERR) /* report the first encountered error */
#line 3704
			status = lstatus;
#line 3704
	}
#line 3704

#line 3704
	*xpp = (const void *)xp;
#line 3704
	return status;
#line 3704
#endif
#line 3704
}
#line 3704

int
#line 3705
ncx_getn_ulonglong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3705
{
#line 3705
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3705

#line 3705
 /* basic algorithm is:
#line 3705
  *   - ensure sane alignment of input data
#line 3705
  *   - copy (conversion happens automatically) input data
#line 3705
  *     to output
#line 3705
  *   - update xpp to point at next unconverted input, and tp to point
#line 3705
  *     at next location for converted output
#line 3705
  */
#line 3705
  long i, j, ni;
#line 3705
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3705
  uint64 *xp;
#line 3705
  int nrange = 0;         /* number of range errors */
#line 3705
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3705
  long cxp = (long) *((char**)xpp);
#line 3705

#line 3705
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3705
  /* sjl: manually stripmine so we can limit amount of
#line 3705
   * vector work space reserved to LOOPCNT elements. Also
#line 3705
   * makes vectorisation easy */
#line 3705
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3705
    ni=Min(nelems-j,LOOPCNT);
#line 3705
    if (realign) {
#line 3705
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3705
      xp = tmp;
#line 3705
    } else {
#line 3705
      xp = (uint64 *) *xpp;
#line 3705
    }
#line 3705
   /* copy the next block */
#line 3705
#pragma cdir loopcnt=LOOPCNT
#line 3705
#pragma cdir shortloop
#line 3705
    for (i=0; i<ni; i++) {
#line 3705
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3705
     /* test for range errors (not always needed but do it anyway) */
#line 3705
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3705
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3705
      nrange += xp[i] > USHORT_MAX ;
#line 3705
    }
#line 3705
   /* update xpp and tp */
#line 3705
    if (realign) xp = (uint64 *) *xpp;
#line 3705
    xp += ni;
#line 3705
    tp += ni;
#line 3705
    *xpp = (void*)xp;
#line 3705
  }
#line 3705
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3705

#line 3705
#else   /* not SX */
#line 3705
	const char *xp = (const char *) *xpp;
#line 3705
	int status = NC_NOERR;
#line 3705

#line 3705
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3705
	{
#line 3705
		const int lstatus = ncx_get_ulonglong_ushort(xp, tp);
#line 3705
		if (status == NC_NOERR) /* report the first encountered error */
#line 3705
			status = lstatus;
#line 3705
	}
#line 3705

#line 3705
	*xpp = (const void *)xp;
#line 3705
	return status;
#line 3705
#endif
#line 3705
}
#line 3705

int
#line 3706
ncx_getn_ulonglong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3706
{
#line 3706
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3706

#line 3706
 /* basic algorithm is:
#line 3706
  *   - ensure sane alignment of input data
#line 3706
  *   - copy (conversion happens automatically) input data
#line 3706
  *     to output
#line 3706
  *   - update xpp to point at next unconverted input, and tp to point
#line 3706
  *     at next location for converted output
#line 3706
  */
#line 3706
  long i, j, ni;
#line 3706
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3706
  uint64 *xp;
#line 3706
  int nrange = 0;         /* number of range errors */
#line 3706
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3706
  long cxp = (long) *((char**)xpp);
#line 3706

#line 3706
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3706
  /* sjl: manually stripmine so we can limit amount of
#line 3706
   * vector work space reserved to LOOPCNT elements. Also
#line 3706
   * makes vectorisation easy */
#line 3706
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3706
    ni=Min(nelems-j,LOOPCNT);
#line 3706
    if (realign) {
#line 3706
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3706
      xp = tmp;
#line 3706
    } else {
#line 3706
      xp = (uint64 *) *xpp;
#line 3706
    }
#line 3706
   /* copy the next block */
#line 3706
#pragma cdir loopcnt=LOOPCNT
#line 3706
#pragma cdir shortloop
#line 3706
    for (i=0; i<ni; i++) {
#line 3706
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3706
     /* test for range errors (not always needed but do it anyway) */
#line 3706
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3706
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3706
      nrange += xp[i] > UINT_MAX ;
#line 3706
    }
#line 3706
   /* update xpp and tp */
#line 3706
    if (realign) xp = (uint64 *) *xpp;
#line 3706
    xp += ni;
#line 3706
    tp += ni;
#line 3706
    *xpp = (void*)xp;
#line 3706
  }
#line 3706
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3706

#line 3706
#else   /* not SX */
#line 3706
	const char *xp = (const char *) *xpp;
#line 3706
	int status = NC_NOERR;
#line 3706

#line 3706
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3706
	{
#line 3706
		const int lstatus = ncx_get_ulonglong_uint(xp, tp);
#line 3706
		if (status == NC_NOERR) /* report the first encountered error */
#line 3706
			status = lstatus;
#line 3706
	}
#line 3706

#line 3706
	*xpp = (const void *)xp;
#line 3706
	return status;
#line 3706
#endif
#line 3706
}
#line 3706


#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const unsigned long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3722
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3722
{
#line 3722
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3722

#line 3722
 /* basic algorithm is:
#line 3722
  *   - ensure sane alignment of output data
#line 3722
  *   - copy (conversion happens automatically) input data
#line 3722
  *     to output
#line 3722
  *   - update tp to point at next unconverted input, and xpp to point
#line 3722
  *     at next location for converted output
#line 3722
  */
#line 3722
  long i, j, ni;
#line 3722
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3722
  uint64 *xp;
#line 3722
  int nrange = 0;         /* number of range errors */
#line 3722
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3722
  long cxp = (long) *((char**)xpp);
#line 3722

#line 3722
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3722
  /* sjl: manually stripmine so we can limit amount of
#line 3722
   * vector work space reserved to LOOPCNT elements. Also
#line 3722
   * makes vectorisation easy */
#line 3722
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3722
    ni=Min(nelems-j,LOOPCNT);
#line 3722
    if (realign) {
#line 3722
      xp = tmp;
#line 3722
    } else {
#line 3722
      xp = (uint64 *) *xpp;
#line 3722
    }
#line 3722
   /* copy the next block */
#line 3722
#pragma cdir loopcnt=LOOPCNT
#line 3722
#pragma cdir shortloop
#line 3722
    for (i=0; i<ni; i++) {
#line 3722
      /* the normal case: */
#line 3722
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3722
     /* test for range errors (not always needed but do it anyway) */
#line 3722
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3722
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3722
      nrange += tp[i] > X_UINT64_MAX ;
#line 3722
    }
#line 3722
   /* copy workspace back if necessary */
#line 3722
    if (realign) {
#line 3722
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3722
      xp = (uint64 *) *xpp;
#line 3722
    }
#line 3722
   /* update xpp and tp */
#line 3722
    xp += ni;
#line 3722
    tp += ni;
#line 3722
    *xpp = (void*)xp;
#line 3722
  }
#line 3722
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3722

#line 3722
#else   /* not SX */
#line 3722

#line 3722
	char *xp = (char *) *xpp;
#line 3722
	int status = NC_NOERR;
#line 3722

#line 3722
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3722
	{
#line 3722
		int lstatus = ncx_put_ulonglong_ulonglong(xp, tp, fillp);
#line 3722
		if (status == NC_NOERR) /* report the first encountered error */
#line 3722
			status = lstatus;
#line 3722
	}
#line 3722

#line 3722
	*xpp = (void *)xp;
#line 3722
	return status;
#line 3722
#endif
#line 3722
}
#line 3722

#endif
int
#line 3724
ncx_putn_ulonglong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3724
{
#line 3724
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3724

#line 3724
 /* basic algorithm is:
#line 3724
  *   - ensure sane alignment of output data
#line 3724
  *   - copy (conversion happens automatically) input data
#line 3724
  *     to output
#line 3724
  *   - update tp to point at next unconverted input, and xpp to point
#line 3724
  *     at next location for converted output
#line 3724
  */
#line 3724
  long i, j, ni;
#line 3724
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3724
  uint64 *xp;
#line 3724
  int nrange = 0;         /* number of range errors */
#line 3724
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3724
  long cxp = (long) *((char**)xpp);
#line 3724

#line 3724
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3724
  /* sjl: manually stripmine so we can limit amount of
#line 3724
   * vector work space reserved to LOOPCNT elements. Also
#line 3724
   * makes vectorisation easy */
#line 3724
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3724
    ni=Min(nelems-j,LOOPCNT);
#line 3724
    if (realign) {
#line 3724
      xp = tmp;
#line 3724
    } else {
#line 3724
      xp = (uint64 *) *xpp;
#line 3724
    }
#line 3724
   /* copy the next block */
#line 3724
#pragma cdir loopcnt=LOOPCNT
#line 3724
#pragma cdir shortloop
#line 3724
    for (i=0; i<ni; i++) {
#line 3724
      /* the normal case: */
#line 3724
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3724
     /* test for range errors (not always needed but do it anyway) */
#line 3724
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3724
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3724
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3724
    }
#line 3724
   /* copy workspace back if necessary */
#line 3724
    if (realign) {
#line 3724
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3724
      xp = (uint64 *) *xpp;
#line 3724
    }
#line 3724
   /* update xpp and tp */
#line 3724
    xp += ni;
#line 3724
    tp += ni;
#line 3724
    *xpp = (void*)xp;
#line 3724
  }
#line 3724
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3724

#line 3724
#else   /* not SX */
#line 3724

#line 3724
	char *xp = (char *) *xpp;
#line 3724
	int status = NC_NOERR;
#line 3724

#line 3724
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3724
	{
#line 3724
		int lstatus = ncx_put_ulonglong_schar(xp, tp, fillp);
#line 3724
		if (status == NC_NOERR) /* report the first encountered error */
#line 3724
			status = lstatus;
#line 3724
	}
#line 3724

#line 3724
	*xpp = (void *)xp;
#line 3724
	return status;
#line 3724
#endif
#line 3724
}
#line 3724

int
#line 3725
ncx_putn_ulonglong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3725
{
#line 3725
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3725

#line 3725
 /* basic algorithm is:
#line 3725
  *   - ensure sane alignment of output data
#line 3725
  *   - copy (conversion happens automatically) input data
#line 3725
  *     to output
#line 3725
  *   - update tp to point at next unconverted input, and xpp to point
#line 3725
  *     at next location for converted output
#line 3725
  */
#line 3725
  long i, j, ni;
#line 3725
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3725
  uint64 *xp;
#line 3725
  int nrange = 0;         /* number of range errors */
#line 3725
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3725
  long cxp = (long) *((char**)xpp);
#line 3725

#line 3725
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3725
  /* sjl: manually stripmine so we can limit amount of
#line 3725
   * vector work space reserved to LOOPCNT elements. Also
#line 3725
   * makes vectorisation easy */
#line 3725
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3725
    ni=Min(nelems-j,LOOPCNT);
#line 3725
    if (realign) {
#line 3725
      xp = tmp;
#line 3725
    } else {
#line 3725
      xp = (uint64 *) *xpp;
#line 3725
    }
#line 3725
   /* copy the next block */
#line 3725
#pragma cdir loopcnt=LOOPCNT
#line 3725
#pragma cdir shortloop
#line 3725
    for (i=0; i<ni; i++) {
#line 3725
      /* the normal case: */
#line 3725
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3725
     /* test for range errors (not always needed but do it anyway) */
#line 3725
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3725
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3725
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3725
    }
#line 3725
   /* copy workspace back if necessary */
#line 3725
    if (realign) {
#line 3725
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3725
      xp = (uint64 *) *xpp;
#line 3725
    }
#line 3725
   /* update xpp and tp */
#line 3725
    xp += ni;
#line 3725
    tp += ni;
#line 3725
    *xpp = (void*)xp;
#line 3725
  }
#line 3725
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3725

#line 3725
#else   /* not SX */
#line 3725

#line 3725
	char *xp = (char *) *xpp;
#line 3725
	int status = NC_NOERR;
#line 3725

#line 3725
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3725
	{
#line 3725
		int lstatus = ncx_put_ulonglong_short(xp, tp, fillp);
#line 3725
		if (status == NC_NOERR) /* report the first encountered error */
#line 3725
			status = lstatus;
#line 3725
	}
#line 3725

#line 3725
	*xpp = (void *)xp;
#line 3725
	return status;
#line 3725
#endif
#line 3725
}
#line 3725

int
#line 3726
ncx_putn_ulonglong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3726
{
#line 3726
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3726

#line 3726
 /* basic algorithm is:
#line 3726
  *   - ensure sane alignment of output data
#line 3726
  *   - copy (conversion happens automatically) input data
#line 3726
  *     to output
#line 3726
  *   - update tp to point at next unconverted input, and xpp to point
#line 3726
  *     at next location for converted output
#line 3726
  */
#line 3726
  long i, j, ni;
#line 3726
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3726
  uint64 *xp;
#line 3726
  int nrange = 0;         /* number of range errors */
#line 3726
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3726
  long cxp = (long) *((char**)xpp);
#line 3726

#line 3726
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3726
  /* sjl: manually stripmine so we can limit amount of
#line 3726
   * vector work space reserved to LOOPCNT elements. Also
#line 3726
   * makes vectorisation easy */
#line 3726
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3726
    ni=Min(nelems-j,LOOPCNT);
#line 3726
    if (realign) {
#line 3726
      xp = tmp;
#line 3726
    } else {
#line 3726
      xp = (uint64 *) *xpp;
#line 3726
    }
#line 3726
   /* copy the next block */
#line 3726
#pragma cdir loopcnt=LOOPCNT
#line 3726
#pragma cdir shortloop
#line 3726
    for (i=0; i<ni; i++) {
#line 3726
      /* the normal case: */
#line 3726
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3726
     /* test for range errors (not always needed but do it anyway) */
#line 3726
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3726
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3726
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3726
    }
#line 3726
   /* copy workspace back if necessary */
#line 3726
    if (realign) {
#line 3726
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3726
      xp = (uint64 *) *xpp;
#line 3726
    }
#line 3726
   /* update xpp and tp */
#line 3726
    xp += ni;
#line 3726
    tp += ni;
#line 3726
    *xpp = (void*)xp;
#line 3726
  }
#line 3726
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3726

#line 3726
#else   /* not SX */
#line 3726

#line 3726
	char *xp = (char *) *xpp;
#line 3726
	int status = NC_NOERR;
#line 3726

#line 3726
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3726
	{
#line 3726
		int lstatus = ncx_put_ulonglong_int(xp, tp, fillp);
#line 3726
		if (status == NC_NOERR) /* report the first encountered error */
#line 3726
			status = lstatus;
#line 3726
	}
#line 3726

#line 3726
	*xpp = (void *)xp;
#line 3726
	return status;
#line 3726
#endif
#line 3726
}
#line 3726

int
#line 3727
ncx_putn_ulonglong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3727
{
#line 3727
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3727

#line 3727
 /* basic algorithm is:
#line 3727
  *   - ensure sane alignment of output data
#line 3727
  *   - copy (conversion happens automatically) input data
#line 3727
  *     to output
#line 3727
  *   - update tp to point at next unconverted input, and xpp to point
#line 3727
  *     at next location for converted output
#line 3727
  */
#line 3727
  long i, j, ni;
#line 3727
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3727
  uint64 *xp;
#line 3727
  int nrange = 0;         /* number of range errors */
#line 3727
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3727
  long cxp = (long) *((char**)xpp);
#line 3727

#line 3727
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3727
  /* sjl: manually stripmine so we can limit amount of
#line 3727
   * vector work space reserved to LOOPCNT elements. Also
#line 3727
   * makes vectorisation easy */
#line 3727
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3727
    ni=Min(nelems-j,LOOPCNT);
#line 3727
    if (realign) {
#line 3727
      xp = tmp;
#line 3727
    } else {
#line 3727
      xp = (uint64 *) *xpp;
#line 3727
    }
#line 3727
   /* copy the next block */
#line 3727
#pragma cdir loopcnt=LOOPCNT
#line 3727
#pragma cdir shortloop
#line 3727
    for (i=0; i<ni; i++) {
#line 3727
      /* the normal case: */
#line 3727
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3727
     /* test for range errors (not always needed but do it anyway) */
#line 3727
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3727
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3727
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3727
    }
#line 3727
   /* copy workspace back if necessary */
#line 3727
    if (realign) {
#line 3727
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3727
      xp = (uint64 *) *xpp;
#line 3727
    }
#line 3727
   /* update xpp and tp */
#line 3727
    xp += ni;
#line 3727
    tp += ni;
#line 3727
    *xpp = (void*)xp;
#line 3727
  }
#line 3727
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3727

#line 3727
#else   /* not SX */
#line 3727

#line 3727
	char *xp = (char *) *xpp;
#line 3727
	int status = NC_NOERR;
#line 3727

#line 3727
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3727
	{
#line 3727
		int lstatus = ncx_put_ulonglong_long(xp, tp, fillp);
#line 3727
		if (status == NC_NOERR) /* report the first encountered error */
#line 3727
			status = lstatus;
#line 3727
	}
#line 3727

#line 3727
	*xpp = (void *)xp;
#line 3727
	return status;
#line 3727
#endif
#line 3727
}
#line 3727

int
#line 3728
ncx_putn_ulonglong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3728
{
#line 3728
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3728

#line 3728
 /* basic algorithm is:
#line 3728
  *   - ensure sane alignment of output data
#line 3728
  *   - copy (conversion happens automatically) input data
#line 3728
  *     to output
#line 3728
  *   - update tp to point at next unconverted input, and xpp to point
#line 3728
  *     at next location for converted output
#line 3728
  */
#line 3728
  long i, j, ni;
#line 3728
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3728
  uint64 *xp;
#line 3728
  int nrange = 0;         /* number of range errors */
#line 3728
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3728
  long cxp = (long) *((char**)xpp);
#line 3728

#line 3728
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3728
  /* sjl: manually stripmine so we can limit amount of
#line 3728
   * vector work space reserved to LOOPCNT elements. Also
#line 3728
   * makes vectorisation easy */
#line 3728
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3728
    ni=Min(nelems-j,LOOPCNT);
#line 3728
    if (realign) {
#line 3728
      xp = tmp;
#line 3728
    } else {
#line 3728
      xp = (uint64 *) *xpp;
#line 3728
    }
#line 3728
   /* copy the next block */
#line 3728
#pragma cdir loopcnt=LOOPCNT
#line 3728
#pragma cdir shortloop
#line 3728
    for (i=0; i<ni; i++) {
#line 3728
      /* the normal case: */
#line 3728
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3728
     /* test for range errors (not always needed but do it anyway) */
#line 3728
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3728
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3728
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3728
    }
#line 3728
   /* copy workspace back if necessary */
#line 3728
    if (realign) {
#line 3728
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3728
      xp = (uint64 *) *xpp;
#line 3728
    }
#line 3728
   /* update xpp and tp */
#line 3728
    xp += ni;
#line 3728
    tp += ni;
#line 3728
    *xpp = (void*)xp;
#line 3728
  }
#line 3728
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3728

#line 3728
#else   /* not SX */
#line 3728

#line 3728
	char *xp = (char *) *xpp;
#line 3728
	int status = NC_NOERR;
#line 3728

#line 3728
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3728
	{
#line 3728
		int lstatus = ncx_put_ulonglong_float(xp, tp, fillp);
#line 3728
		if (status == NC_NOERR) /* report the first encountered error */
#line 3728
			status = lstatus;
#line 3728
	}
#line 3728

#line 3728
	*xpp = (void *)xp;
#line 3728
	return status;
#line 3728
#endif
#line 3728
}
#line 3728

int
#line 3729
ncx_putn_ulonglong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3729
{
#line 3729
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3729

#line 3729
 /* basic algorithm is:
#line 3729
  *   - ensure sane alignment of output data
#line 3729
  *   - copy (conversion happens automatically) input data
#line 3729
  *     to output
#line 3729
  *   - update tp to point at next unconverted input, and xpp to point
#line 3729
  *     at next location for converted output
#line 3729
  */
#line 3729
  long i, j, ni;
#line 3729
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3729
  uint64 *xp;
#line 3729
  int nrange = 0;         /* number of range errors */
#line 3729
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3729
  long cxp = (long) *((char**)xpp);
#line 3729

#line 3729
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3729
  /* sjl: manually stripmine so we can limit amount of
#line 3729
   * vector work space reserved to LOOPCNT elements. Also
#line 3729
   * makes vectorisation easy */
#line 3729
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3729
    ni=Min(nelems-j,LOOPCNT);
#line 3729
    if (realign) {
#line 3729
      xp = tmp;
#line 3729
    } else {
#line 3729
      xp = (uint64 *) *xpp;
#line 3729
    }
#line 3729
   /* copy the next block */
#line 3729
#pragma cdir loopcnt=LOOPCNT
#line 3729
#pragma cdir shortloop
#line 3729
    for (i=0; i<ni; i++) {
#line 3729
      /* the normal case: */
#line 3729
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3729
     /* test for range errors (not always needed but do it anyway) */
#line 3729
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3729
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3729
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3729
    }
#line 3729
   /* copy workspace back if necessary */
#line 3729
    if (realign) {
#line 3729
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3729
      xp = (uint64 *) *xpp;
#line 3729
    }
#line 3729
   /* update xpp and tp */
#line 3729
    xp += ni;
#line 3729
    tp += ni;
#line 3729
    *xpp = (void*)xp;
#line 3729
  }
#line 3729
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3729

#line 3729
#else   /* not SX */
#line 3729

#line 3729
	char *xp = (char *) *xpp;
#line 3729
	int status = NC_NOERR;
#line 3729

#line 3729
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3729
	{
#line 3729
		int lstatus = ncx_put_ulonglong_double(xp, tp, fillp);
#line 3729
		if (status == NC_NOERR) /* report the first encountered error */
#line 3729
			status = lstatus;
#line 3729
	}
#line 3729

#line 3729
	*xpp = (void *)xp;
#line 3729
	return status;
#line 3729
#endif
#line 3729
}
#line 3729

int
#line 3730
ncx_putn_ulonglong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3730
{
#line 3730
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3730

#line 3730
 /* basic algorithm is:
#line 3730
  *   - ensure sane alignment of output data
#line 3730
  *   - copy (conversion happens automatically) input data
#line 3730
  *     to output
#line 3730
  *   - update tp to point at next unconverted input, and xpp to point
#line 3730
  *     at next location for converted output
#line 3730
  */
#line 3730
  long i, j, ni;
#line 3730
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3730
  uint64 *xp;
#line 3730
  int nrange = 0;         /* number of range errors */
#line 3730
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3730
  long cxp = (long) *((char**)xpp);
#line 3730

#line 3730
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3730
  /* sjl: manually stripmine so we can limit amount of
#line 3730
   * vector work space reserved to LOOPCNT elements. Also
#line 3730
   * makes vectorisation easy */
#line 3730
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3730
    ni=Min(nelems-j,LOOPCNT);
#line 3730
    if (realign) {
#line 3730
      xp = tmp;
#line 3730
    } else {
#line 3730
      xp = (uint64 *) *xpp;
#line 3730
    }
#line 3730
   /* copy the next block */
#line 3730
#pragma cdir loopcnt=LOOPCNT
#line 3730
#pragma cdir shortloop
#line 3730
    for (i=0; i<ni; i++) {
#line 3730
      /* the normal case: */
#line 3730
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3730
     /* test for range errors (not always needed but do it anyway) */
#line 3730
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3730
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3730
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3730
    }
#line 3730
   /* copy workspace back if necessary */
#line 3730
    if (realign) {
#line 3730
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3730
      xp = (uint64 *) *xpp;
#line 3730
    }
#line 3730
   /* update xpp and tp */
#line 3730
    xp += ni;
#line 3730
    tp += ni;
#line 3730
    *xpp = (void*)xp;
#line 3730
  }
#line 3730
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3730

#line 3730
#else   /* not SX */
#line 3730

#line 3730
	char *xp = (char *) *xpp;
#line 3730
	int status = NC_NOERR;
#line 3730

#line 3730
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3730
	{
#line 3730
		int lstatus = ncx_put_ulonglong_longlong(xp, tp, fillp);
#line 3730
		if (status == NC_NOERR) /* report the first encountered error */
#line 3730
			status = lstatus;
#line 3730
	}
#line 3730

#line 3730
	*xpp = (void *)xp;
#line 3730
	return status;
#line 3730
#endif
#line 3730
}
#line 3730

int
#line 3731
ncx_putn_ulonglong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3731
{
#line 3731
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3731

#line 3731
 /* basic algorithm is:
#line 3731
  *   - ensure sane alignment of output data
#line 3731
  *   - copy (conversion happens automatically) input data
#line 3731
  *     to output
#line 3731
  *   - update tp to point at next unconverted input, and xpp to point
#line 3731
  *     at next location for converted output
#line 3731
  */
#line 3731
  long i, j, ni;
#line 3731
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3731
  uint64 *xp;
#line 3731
  int nrange = 0;         /* number of range errors */
#line 3731
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3731
  long cxp = (long) *((char**)xpp);
#line 3731

#line 3731
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3731
  /* sjl: manually stripmine so we can limit amount of
#line 3731
   * vector work space reserved to LOOPCNT elements. Also
#line 3731
   * makes vectorisation easy */
#line 3731
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3731
    ni=Min(nelems-j,LOOPCNT);
#line 3731
    if (realign) {
#line 3731
      xp = tmp;
#line 3731
    } else {
#line 3731
      xp = (uint64 *) *xpp;
#line 3731
    }
#line 3731
   /* copy the next block */
#line 3731
#pragma cdir loopcnt=LOOPCNT
#line 3731
#pragma cdir shortloop
#line 3731
    for (i=0; i<ni; i++) {
#line 3731
      /* the normal case: */
#line 3731
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3731
     /* test for range errors (not always needed but do it anyway) */
#line 3731
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3731
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3731
      nrange += tp[i] > X_UINT64_MAX ;
#line 3731
    }
#line 3731
   /* copy workspace back if necessary */
#line 3731
    if (realign) {
#line 3731
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3731
      xp = (uint64 *) *xpp;
#line 3731
    }
#line 3731
   /* update xpp and tp */
#line 3731
    xp += ni;
#line 3731
    tp += ni;
#line 3731
    *xpp = (void*)xp;
#line 3731
  }
#line 3731
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3731

#line 3731
#else   /* not SX */
#line 3731

#line 3731
	char *xp = (char *) *xpp;
#line 3731
	int status = NC_NOERR;
#line 3731

#line 3731
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3731
	{
#line 3731
		int lstatus = ncx_put_ulonglong_uchar(xp, tp, fillp);
#line 3731
		if (status == NC_NOERR) /* report the first encountered error */
#line 3731
			status = lstatus;
#line 3731
	}
#line 3731

#line 3731
	*xpp = (void *)xp;
#line 3731
	return status;
#line 3731
#endif
#line 3731
}
#line 3731

int
#line 3732
ncx_putn_ulonglong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3732
{
#line 3732
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3732

#line 3732
 /* basic algorithm is:
#line 3732
  *   - ensure sane alignment of output data
#line 3732
  *   - copy (conversion happens automatically) input data
#line 3732
  *     to output
#line 3732
  *   - update tp to point at next unconverted input, and xpp to point
#line 3732
  *     at next location for converted output
#line 3732
  */
#line 3732
  long i, j, ni;
#line 3732
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3732
  uint64 *xp;
#line 3732
  int nrange = 0;         /* number of range errors */
#line 3732
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3732
  long cxp = (long) *((char**)xpp);
#line 3732

#line 3732
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3732
  /* sjl: manually stripmine so we can limit amount of
#line 3732
   * vector work space reserved to LOOPCNT elements. Also
#line 3732
   * makes vectorisation easy */
#line 3732
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3732
    ni=Min(nelems-j,LOOPCNT);
#line 3732
    if (realign) {
#line 3732
      xp = tmp;
#line 3732
    } else {
#line 3732
      xp = (uint64 *) *xpp;
#line 3732
    }
#line 3732
   /* copy the next block */
#line 3732
#pragma cdir loopcnt=LOOPCNT
#line 3732
#pragma cdir shortloop
#line 3732
    for (i=0; i<ni; i++) {
#line 3732
      /* the normal case: */
#line 3732
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3732
     /* test for range errors (not always needed but do it anyway) */
#line 3732
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3732
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3732
      nrange += tp[i] > X_UINT64_MAX ;
#line 3732
    }
#line 3732
   /* copy workspace back if necessary */
#line 3732
    if (realign) {
#line 3732
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3732
      xp = (uint64 *) *xpp;
#line 3732
    }
#line 3732
   /* update xpp and tp */
#line 3732
    xp += ni;
#line 3732
    tp += ni;
#line 3732
    *xpp = (void*)xp;
#line 3732
  }
#line 3732
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3732

#line 3732
#else   /* not SX */
#line 3732

#line 3732
	char *xp = (char *) *xpp;
#line 3732
	int status = NC_NOERR;
#line 3732

#line 3732
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3732
	{
#line 3732
		int lstatus = ncx_put_ulonglong_ushort(xp, tp, fillp);
#line 3732
		if (status == NC_NOERR) /* report the first encountered error */
#line 3732
			status = lstatus;
#line 3732
	}
#line 3732

#line 3732
	*xpp = (void *)xp;
#line 3732
	return status;
#line 3732
#endif
#line 3732
}
#line 3732

int
#line 3733
ncx_putn_ulonglong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3733
{
#line 3733
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3733

#line 3733
 /* basic algorithm is:
#line 3733
  *   - ensure sane alignment of output data
#line 3733
  *   - copy (conversion happens automatically) input data
#line 3733
  *     to output
#line 3733
  *   - update tp to point at next unconverted input, and xpp to point
#line 3733
  *     at next location for converted output
#line 3733
  */
#line 3733
  long i, j, ni;
#line 3733
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3733
  uint64 *xp;
#line 3733
  int nrange = 0;         /* number of range errors */
#line 3733
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3733
  long cxp = (long) *((char**)xpp);
#line 3733

#line 3733
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3733
  /* sjl: manually stripmine so we can limit amount of
#line 3733
   * vector work space reserved to LOOPCNT elements. Also
#line 3733
   * makes vectorisation easy */
#line 3733
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3733
    ni=Min(nelems-j,LOOPCNT);
#line 3733
    if (realign) {
#line 3733
      xp = tmp;
#line 3733
    } else {
#line 3733
      xp = (uint64 *) *xpp;
#line 3733
    }
#line 3733
   /* copy the next block */
#line 3733
#pragma cdir loopcnt=LOOPCNT
#line 3733
#pragma cdir shortloop
#line 3733
    for (i=0; i<ni; i++) {
#line 3733
      /* the normal case: */
#line 3733
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3733
     /* test for range errors (not always needed but do it anyway) */
#line 3733
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3733
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3733
      nrange += tp[i] > X_UINT64_MAX ;
#line 3733
    }
#line 3733
   /* copy workspace back if necessary */
#line 3733
    if (realign) {
#line 3733
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3733
      xp = (uint64 *) *xpp;
#line 3733
    }
#line 3733
   /* update xpp and tp */
#line 3733
    xp += ni;
#line 3733
    tp += ni;
#line 3733
    *xpp = (void*)xp;
#line 3733
  }
#line 3733
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3733

#line 3733
#else   /* not SX */
#line 3733

#line 3733
	char *xp = (char *) *xpp;
#line 3733
	int status = NC_NOERR;
#line 3733

#line 3733
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3733
	{
#line 3733
		int lstatus = ncx_put_ulonglong_uint(xp, tp, fillp);
#line 3733
		if (status == NC_NOERR) /* report the first encountered error */
#line 3733
			status = lstatus;
#line 3733
	}
#line 3733

#line 3733
	*xpp = (void *)xp;
#line 3733
	return status;
#line 3733
#endif
#line 3733
}
#line 3733



/*
 * Other aggregate conversion functions.
 */

/* text */

int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3745
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3745
	return NC_NOERR;
#line 3745

}

int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3751

#line 3751
	if (rndup)
#line 3751
		rndup = X_ALIGN - rndup;
#line 3751

#line 3751
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3751
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3751

#line 3751
	return NC_NOERR;
#line 3751

}

int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3757
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3757

#line 3757
	return NC_NOERR;
#line 3757

}

int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3763

#line 3763
	if (rndup)
#line 3763
		rndup = X_ALIGN - rndup;
#line 3763

#line 3763
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3763
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3763

#line 3763
	if (rndup)
#line 3763
	{
#line 3763
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3763
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3763
	}
#line 3763

#line 3763
	return NC_NOERR;
#line 3763

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3772
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3772
	return NC_NOERR;
#line 3772

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3778

#line 3778
	if (rndup)
#line 3778
		rndup = X_ALIGN - rndup;
#line 3778

#line 3778
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3778
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3778

#line 3778
	return NC_NOERR;
#line 3778

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3784
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3784

#line 3784
	return NC_NOERR;
#line 3784

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3790

#line 3790
	if (rndup)
#line 3790
		rndup = X_ALIGN - rndup;
#line 3790

#line 3790
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3790
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3790

#line 3790
	if (rndup)
#line 3790
	{
#line 3790
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3790
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3790
	}
#line 3790

#line 3790
	return NC_NOERR;
#line 3790

}
