// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.19.4
// source: proto/signer.proto

package proto

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// KeyManagementClient is the client API for KeyManagement service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type KeyManagementClient interface {
	// CreateKey creates as asymmetric key pair and returns the PublicKey
	CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*PublicKey, error)
	// DeleteKey deletes the key associated with a KeyID
	DeleteKey(ctx context.Context, in *KeyID, opts ...grpc.CallOption) (*Void, error)
	// GetKeyInfo returns the PublicKey associated with a KeyID
	GetKeyInfo(ctx context.Context, in *KeyID, opts ...grpc.CallOption) (*GetKeyInfoResponse, error)
}

type keyManagementClient struct {
	cc grpc.ClientConnInterface
}

func NewKeyManagementClient(cc grpc.ClientConnInterface) KeyManagementClient {
	return &keyManagementClient{cc}
}

func (c *keyManagementClient) CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*PublicKey, error) {
	out := new(PublicKey)
	err := c.cc.Invoke(ctx, "/proto.KeyManagement/CreateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementClient) DeleteKey(ctx context.Context, in *KeyID, opts ...grpc.CallOption) (*Void, error) {
	out := new(Void)
	err := c.cc.Invoke(ctx, "/proto.KeyManagement/DeleteKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementClient) GetKeyInfo(ctx context.Context, in *KeyID, opts ...grpc.CallOption) (*GetKeyInfoResponse, error) {
	out := new(GetKeyInfoResponse)
	err := c.cc.Invoke(ctx, "/proto.KeyManagement/GetKeyInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyManagementServer is the server API for KeyManagement service.
// All implementations must embed UnimplementedKeyManagementServer
// for forward compatibility
type KeyManagementServer interface {
	// CreateKey creates as asymmetric key pair and returns the PublicKey
	CreateKey(context.Context, *CreateKeyRequest) (*PublicKey, error)
	// DeleteKey deletes the key associated with a KeyID
	DeleteKey(context.Context, *KeyID) (*Void, error)
	// GetKeyInfo returns the PublicKey associated with a KeyID
	GetKeyInfo(context.Context, *KeyID) (*GetKeyInfoResponse, error)
	mustEmbedUnimplementedKeyManagementServer()
}

// UnimplementedKeyManagementServer must be embedded to have forward compatible implementations.
type UnimplementedKeyManagementServer struct {
}

func (UnimplementedKeyManagementServer) CreateKey(context.Context, *CreateKeyRequest) (*PublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKey not implemented")
}
func (UnimplementedKeyManagementServer) DeleteKey(context.Context, *KeyID) (*Void, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKey not implemented")
}
func (UnimplementedKeyManagementServer) GetKeyInfo(context.Context, *KeyID) (*GetKeyInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKeyInfo not implemented")
}
func (UnimplementedKeyManagementServer) mustEmbedUnimplementedKeyManagementServer() {}

// UnsafeKeyManagementServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to KeyManagementServer will
// result in compilation errors.
type UnsafeKeyManagementServer interface {
	mustEmbedUnimplementedKeyManagementServer()
}

func RegisterKeyManagementServer(s grpc.ServiceRegistrar, srv KeyManagementServer) {
	s.RegisterService(&KeyManagement_ServiceDesc, srv)
}

func _KeyManagement_CreateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServer).CreateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.KeyManagement/CreateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServer).CreateKey(ctx, req.(*CreateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagement_DeleteKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KeyID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServer).DeleteKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.KeyManagement/DeleteKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServer).DeleteKey(ctx, req.(*KeyID))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagement_GetKeyInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(KeyID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServer).GetKeyInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.KeyManagement/GetKeyInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServer).GetKeyInfo(ctx, req.(*KeyID))
	}
	return interceptor(ctx, in, info, handler)
}

// KeyManagement_ServiceDesc is the grpc.ServiceDesc for KeyManagement service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var KeyManagement_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "proto.KeyManagement",
	HandlerType: (*KeyManagementServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateKey",
			Handler:    _KeyManagement_CreateKey_Handler,
		},
		{
			MethodName: "DeleteKey",
			Handler:    _KeyManagement_DeleteKey_Handler,
		},
		{
			MethodName: "GetKeyInfo",
			Handler:    _KeyManagement_GetKeyInfo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "proto/signer.proto",
}

// SignerClient is the client API for Signer service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SignerClient interface {
	// Sign calculates a cryptographic signature using the Key associated with a KeyID and returns the signature
	Sign(ctx context.Context, in *SignatureRequest, opts ...grpc.CallOption) (*Signature, error)
}

type signerClient struct {
	cc grpc.ClientConnInterface
}

func NewSignerClient(cc grpc.ClientConnInterface) SignerClient {
	return &signerClient{cc}
}

func (c *signerClient) Sign(ctx context.Context, in *SignatureRequest, opts ...grpc.CallOption) (*Signature, error) {
	out := new(Signature)
	err := c.cc.Invoke(ctx, "/proto.Signer/Sign", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SignerServer is the server API for Signer service.
// All implementations must embed UnimplementedSignerServer
// for forward compatibility
type SignerServer interface {
	// Sign calculates a cryptographic signature using the Key associated with a KeyID and returns the signature
	Sign(context.Context, *SignatureRequest) (*Signature, error)
	mustEmbedUnimplementedSignerServer()
}

// UnimplementedSignerServer must be embedded to have forward compatible implementations.
type UnimplementedSignerServer struct {
}

func (UnimplementedSignerServer) Sign(context.Context, *SignatureRequest) (*Signature, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Sign not implemented")
}
func (UnimplementedSignerServer) mustEmbedUnimplementedSignerServer() {}

// UnsafeSignerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SignerServer will
// result in compilation errors.
type UnsafeSignerServer interface {
	mustEmbedUnimplementedSignerServer()
}

func RegisterSignerServer(s grpc.ServiceRegistrar, srv SignerServer) {
	s.RegisterService(&Signer_ServiceDesc, srv)
}

func _Signer_Sign_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SignerServer).Sign(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.Signer/Sign",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SignerServer).Sign(ctx, req.(*SignatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Signer_ServiceDesc is the grpc.ServiceDesc for Signer service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Signer_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "proto.Signer",
	HandlerType: (*SignerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Sign",
			Handler:    _Signer_Sign_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "proto/signer.proto",
}
