/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.security.jaas;

import com.sourceforge.knecs.security.jaas.CMCSPrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.net.PasswordAuthentication;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PasswordLoginModule
implements LoginModule {
    private Vector mDefaultPA = null;
    private Subject mSubject = null;
    private CallbackHandler mCallbackHandler = null;
    private Map mSharedState = null;
    private Map mOptions = null;
    private Principal mUserPrincipal = null;
    private boolean mDebug = false;
    private boolean mSucceeded = false;
    private boolean mCommitSucceeded = false;
    private PasswordAuthentication mPasswordAuth = null;

    public void initialize(Subject subject, CallbackHandler cbHandler, Map sharedState, Map options) {
        if (this.mDefaultPA == null) {
            this.loadDefaults();
        }
        this.mSubject = subject;
        this.mCallbackHandler = cbHandler;
        this.mSharedState = sharedState;
        this.mOptions = options;
    }

    public boolean abort() throws LoginException {
        boolean ret = true;
        if (!this.mSucceeded) {
            ret = false;
        } else if (this.mSucceeded && !this.mCommitSucceeded) {
            this.mSucceeded = false;
            this.mUserPrincipal = null;
            this.clearPassword(this.mPasswordAuth.getPassword());
            this.mPasswordAuth = null;
        } else {
            this.logout();
        }
        return ret;
    }

    public boolean commit() throws LoginException {
        boolean ret = true;
        if (!this.mSucceeded) {
            ret = false;
        } else {
            this.mUserPrincipal = new CMCSPrincipal(this.mPasswordAuth.getUserName());
            Set<Principal> principals = this.mSubject.getPrincipals();
            if (!principals.contains(this.mUserPrincipal)) {
                principals.add(this.mUserPrincipal);
            }
            this.mSubject.getPrivateCredentials().add(new PasswordAuthentication(this.mPasswordAuth.getUserName(), this.mPasswordAuth.getPassword()));
            if (this.mDebug) {
                System.out.println("Added CMCSPrincipal for " + this.mPasswordAuth.getUserName());
            }
            this.clearPassword(this.mPasswordAuth.getPassword());
            this.mPasswordAuth = null;
            this.mCommitSucceeded = true;
        }
        return ret;
    }

    public boolean login() throws LoginException {
        boolean ret = false;
        this.mSucceeded = false;
        if (this.mCallbackHandler == null) {
            throw new LoginException("Error - no callback handler to get user/credentials");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Name: "), new PasswordCallback("Password: ", false)};
        try {
            this.mCallbackHandler.handle(callbacks);
            String user = ((NameCallback)callbacks[0]).getName();
            if (!this.getConfiguredID(user)) {
                char[] tmppasswd = ((PasswordCallback)callbacks[1]).getPassword();
                if (tmppasswd == null) {
                    tmppasswd = new char[]{};
                }
                this.mPasswordAuth = new PasswordAuthentication(user, tmppasswd);
                this.clearPassword(tmppasswd);
                ((PasswordCallback)callbacks[1]).clearPassword();
                this.mSucceeded = ret = this.verify();
            } else {
                ret = true;
                this.mSucceeded = true;
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + "not available to get authentication information");
        }
        if (this.mDebug) {
            System.out.println("Got username/password for " + this.mSubject.toString());
        }
        return ret;
    }

    public boolean logout() throws LoginException {
        this.mSucceeded = false;
        this.mCommitSucceeded = false;
        this.mSubject.getPrincipals().remove(this.mUserPrincipal);
        this.mUserPrincipal = null;
        return true;
    }

    private boolean verify() throws LoginException {
        return true;
    }

    private boolean getConfiguredID(String name) {
        boolean ret = false;
        for (int idx = 0; idx < this.mDefaultPA.size(); ++idx) {
            PasswordAuthentication pa = (PasswordAuthentication)this.mDefaultPA.elementAt(idx);
            if (!name.equals(pa.getUserName())) continue;
            this.mPasswordAuth = new PasswordAuthentication(pa.getUserName(), pa.getPassword());
            ret = true;
            break;
        }
        return ret;
    }

    private void loadDefaults() {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("CMCSLogin.xml");
            System.out.println("getting stream for CMCSLogin.xml" + is);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            Element account = null;
            String user = null;
            String password = null;
            this.mDefaultPA = new Vector();
            NodeList accounts = doc.getElementsByTagName("account");
            if (accounts.getLength() > 0) {
                for (int adx = 0; adx < accounts.getLength(); ++adx) {
                    account = (Element)accounts.item(adx);
                    NodeList users = account.getElementsByTagName("user");
                    NodeList passwds = account.getElementsByTagName("password");
                    if (users.getLength() <= 0 || passwds.getLength() <= 0) continue;
                    user = this.getText((Element)users.item(0));
                    password = this.getText((Element)passwds.item(0));
                    char[] passwdarray = password.toCharArray();
                    this.mDefaultPA.addElement(new PasswordAuthentication(user, passwdarray));
                    this.clearPassword(passwdarray);
                }
            }
        }
        catch (ParserConfigurationException pce) {
            System.out.println("Parser Configuration: " + pce.getMessage());
        }
        catch (SAXException sex) {
            System.out.println("SAX Error : " + sex.getMessage());
        }
        catch (IOException iox) {
            System.out.println("IOException: " + iox.getMessage());
        }
    }

    private String getText(Node node) {
        String ret = null;
        NodeList nodes = node.getChildNodes();
        for (int idx = nodes.getLength() - 1; idx >= 0; --idx) {
            Node tmp = nodes.item(idx);
            if (tmp.getNodeType() != 3) continue;
            ret = tmp.getNodeValue();
            break;
        }
        return ret;
    }

    private void clearPassword(char[] password) {
        if (password != null) {
            for (int idx = 0; idx < password.length; ++idx) {
                password[idx] = 32;
            }
            password = null;
        }
    }
}

