#!/usr/bin/python
# coding=UTF-8
# ex:ts=4:sw=4:et=on

# Copyright (c) 2013, Mathijs Dumon
# All rights reserved.
# Complete license can be found in the LICENSE file.

import unittest

from io import BytesIO
from test.test_generic.test_io.test_file_parsers import BaseTestParsers

from pyxrd.file_parsers.xrd_parsers import RDParser

__all__ = [
    'TestRDParser',
]

class TestRDParser(BaseTestParsers.BaseTestParser):

    parser_class = RDParser
    file_data = [
        BytesIO(r"V3RDPC-APD, Diffraction software\00\00\00\00\00\00\00\00\00\00\00\00PC-APD, Diffraction software\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00(\00\00J{\83/L\A6\F8?\A0O\E4Iҵ\F8?\00\00\00\00\00\00\E0?\00\00\B6\E2VA\00X\B8\00r\00622M001912-644 clay form\00\00\00\00\B6\E2V\00\9A\99\99\99\99\99\C9?\00\00\00\00\00\00\F0?\00\00\00\00\00\00\00@\00\00\00\00\00\00\E8?\00\00\00\00\00\00\00\00\00{\AEG\E1z\94?\00\00\00\00\00\00@\00\00\00\00\00\00.@\00\00\00\00\00\00\00\00\00\00\00\00`\00n\00j\00r\00d\00b\00b\00i\00c\00j\00g\00n\00e\00f\00e\00e\00p\00n\00Y\00c\00c\00`\00a\00f\00g\00q\00l\00f\00d\00b\00[\00`\00e\00i\00a\00c\00^\00_\00h\00_\00h\00`\00e\00Z\00^\00U\00[\00]\00S\00\\00\\00e\00]\00_\00\\00_\00V\00`\00V\00^\00W\00_\00[\00T\00[\00[\00c\00[\00Z\00\\00R\00b\00^\00h\00[\00X\00]\00V\00U\00`\00W\00W\00P\00W\00[\00]\00\\00T\00W\00\\00Y\00[\00`\00Q\00\\00T\00T\00Y\00\\00a\00R\00]\00Y\00Q\00T\00[\00T\00W\00\\00[\00\\00Y\00Y\00W\00\\00T\00W\00U\00W\00X\00R\00W\00W\00T\00V\00Y\00U\00X\00R\00M\00X\00R\00\\00R\00W\00P\00Q\00S\00W\00N\00J\00Y\00U\00[\00X\00U\00P\00Q\00V\00K\00E\00O\00S\00S\00Q\00O\00N\00R\00U\00Q\00T\00Q\00K\00P\00Q\00W\00Q\00U\00O\00L\00S\00[\00Q\00U\00\\00L\00S\00J\00M\00K\00T\00R\00R\00M\00I\00J\00S\00H\00J\00R\00G\00P\00R\00E\00M\00F\00M\00T\00K\00N\00R\00P\00H\00K\00U\00Q\00U\00M\00N\00G\00B\00G\00O\00M\00N\00[\00I\00M\00F\00G\00L\00Q\00O\00I\00E\00[\00F\00L\00G\00J\00I\00M\00P\00I\00Q\00N\00O\00H\00J\00Q\00B\00O\00B\00J\00M\00B\00E\00F\00N\00K\00G\00@\00J\00L\00O\00L\00C\00K\00B\00C\00J\00P\00G\00G\00G\00E\00A\00O\00H\00F\00N\00I\00K\00G\00D\00N\00I\00;\00D\00G\00E\00A\00K\00F\00K\00B\00I\00B\00B\00G\00K\00G\00I\00E\00I\00J\00E\00E\00<\00E\00M\00F\00H\00H\00N\00K\00>\007\00A\00I\00B\00<\00J\00G\00D\00J\00E\00E\00E\00L\00B\00F\00F\00E\00B\00D\008\00A\00;\00C\00G\00I\00E\00F\00E\00;\00J\00E\00D\00D\00D\00I\00?\00R\00;\00H\00;\00>\00B\00I\00@\00G\00<\00@\00D\00;\00>\00C\00I\00G\00:\00I\00A\00E\00B\00G\00L\00A\00I\00C\00J\00G\00B\00B\00E\00A\00B\00>\00A\00?\00<\00E\00>\00@\00:\00A\00@\00B\00<\00F\00H\00:\00>\00<\00B\00A\00E\00:\00K\00C\00?\007\00B\00A\00>\00B\00G\00C\00B\00B\007\00?\00I\00E\00B\00E\00>\00:\00M\00L\00?\00A\00B\00E\003\009\009\00B\00>\00A\009\00>\00?\00=\00B\00>\00G\006\00D\00?\006\00E\009\00G\00>\00;\00:\00?\00<\00E\009\00@\00B\00?\00=\00=\00@\009\00@\00D\00E\00A\00;\00=\00;\002\00<\00=\00G\00>\00B\00@\00=\00G\00;\00>\00=\00B\001\006\008\00<\00D\00=\009\00J\006\00;\009\009\00;\00>\00E\009\00=\001\009\00A\00?\00:\00>\00>\00A\009\00E\008\006\00:\009\00=\00<\00?\009\00?\00B\006\00=\00=\00@\008\00:\00;\00=\00@\004\00=\004\006\00;\00B\009\007\00A\009\005\005\00I\00@\00A\00<\009\00A\007\00:\005\00/\007\004\005\00C\009\00>\008\002\00/\009\009\005\00.\007\00B\00/\009\00?\00/\002\00B\00>\00<\009\005\00,\009\003\00;\00/\00.\00:\00>\00>\004\00:\00;\00<\00:\00<\003\009\006\00H\008\005\008\009\006\000\005\004\000\00;\00".encode())
    , ]

    pass # end of class
