% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emm-list.R
\name{emm_list}
\alias{emm_list}
\title{The \code{emm_list} class}
\description{
An \code{emm_list} object is simply a list of
\code{\link[=emmGrid-class]{emmGrid}} objects. Such a list is returned,
for example, by \code{\link{emmeans}} with a two-sided formula or a list as its
\code{specs} argument.
}
\details{
Methods for \code{emm_list} objects include \code{summary}, 
\code{coef}, \code{confint}, \code{contrast}, \code{pairs}, \code{plot},
\code{print}, and
\code{test}. These are all the same as those methods for \code{emmGrid}
objects, with an additional \code{which} argument (integer) to specify which 
members of the list to use. The default is \code{which = seq_along(object)};
i.e., the method is applied to every member of the \code{emm_list} object.
The exception is \code{plot}, where only the \code{which[1]}th element is 
plotted.

As an example,
to summarize a single member -- say the second one -- of an \code{emm_list}, 
one may use \code{summary(object, which = 2)}, but it is probably preferable 
to directly summarize it using \code{summary(object[[2]])}.
}
