% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition-states.R
\name{transition_states}
\alias{transition_states}
\title{Transition between several distinct stages of the data}
\usage{
transition_states(states, transition_length = 1, state_length = 1, wrap = TRUE)
}
\arguments{
\item{states}{The unquoted name of the column holding the state levels in the
data.}

\item{transition_length}{The relative length of the transition. Will be
recycled to match the number of states in the data}

\item{state_length}{The relative length of the pause at the states. Will be
recycled to match the number of states in the data}

\item{wrap}{Should the animation \emph{wrap-around}? If \code{TRUE} the last state will
be transitioned into the first.}
}
\description{
This transition splits your data into multiple states based on the levels in
a given column, much like \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} splits up the data in
multiple panels. It then tweens between the defined states and pauses at each
state. Layers with data without the specified column will be kept constant
during the animation (again, mimicking \code{facet_wrap}).
}
\section{Label variables}{

\code{transition_states} makes the following variables available for string
literal interpretation, in addition to the general ones provided by
\code{\link[=animate]{animate()}}:
\itemize{
\item \strong{transitioning} is a boolean indicating whether the frame is part of the
transitioning phase
\item \strong{previous_state} The name of the last state the animation was at
\item \strong{closest_state} The name of the state closest to this frame
\item \strong{next_state} The name of the next state the animation will be part of
}
}

\section{Object permanence}{

\code{transition_states} uses the group aesthetic of each layer to identify
which rows in the input data correspond to the same graphic element and will
therefore define which elements will turn into each other between states.
The group aesthetic, if not set, will be calculated from the interaction of all
discrete aesthetics in the layer (excluding \code{label}), so it is often better
to set it explicetly when animating, to make sure your data is interpreted in
the right way. If the group aesthetic is not set, and no discrete aesthetics
exists then all rows will have the same group. If the group aesthetic is not
unique in each state, then rows will be matched first by group and then by
index. Unmatched rows will appear/disappear, potentially using an enter or
exit function.
}

\section{Computed Variables}{

It is possible to use variables calculated by the statistic to define the
transition. Simply inclose the variable in \code{stat()} in the same way as when
using computed variables in aesthetics.
}

\examples{
anim <- ggplot(iris, aes(Sepal.Width, Petal.Width)) +
  geom_point() +
  labs(title = "{closest_state}") +
  transition_states(Species, transition_length = 3, state_length = 1)

# Use a unique group to avoid matching graphic elements
iris$group <- seq_len(nrow(iris))
anim1 <- ggplot(iris, aes(Sepal.Width, Petal.Width, group = group)) +
  geom_point() +
  labs(title = "{closest_state}") +
  transition_states(Species, transition_length = 3, state_length = 1) +
  enter_fade() +
  exit_fade()

# Set `wrap = FALSE` to avoid transitioning the last state to the first
anim2 <- ggplot(iris, aes(Sepal.Width, Petal.Width)) +
  geom_point() +
  labs(title = "{closest_state}") +
  transition_states(Species, transition_length = 3, state_length = 1,
                    wrap = FALSE)

}
\seealso{
Other transitions: 
\code{\link{transition_components}()},
\code{\link{transition_events}()},
\code{\link{transition_filter}()},
\code{\link{transition_layers}()},
\code{\link{transition_manual}()},
\code{\link{transition_null}()},
\code{\link{transition_reveal}()},
\code{\link{transition_time}()}
}
\concept{transitions}
