% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-client.R
\name{oauth_client_req_auth}
\alias{oauth_client_req_auth}
\alias{oauth_client_req_auth_header}
\alias{oauth_client_req_auth_body}
\alias{oauth_client_req_auth_jwt_sig}
\title{OAuth client authentication}
\usage{
oauth_client_req_auth(req, client)

oauth_client_req_auth_header(req, client)

oauth_client_req_auth_body(req, client)

oauth_client_req_auth_jwt_sig(req, client, claim, size = 256, header = list())
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \link{oauth_client}.}

\item{claim}{Claim set produced by \code{\link[=jwt_claim]{jwt_claim()}}.}

\item{size}{Size, in bits, of sha2 signature, i.e. 256, 384 or 512.
Only for HMAC/RSA, not applicable for ECDSA keys.}

\item{header}{A named list giving additional fields to include in the
JWT header.}
}
\value{
A modified HTTP \link{request}.
}
\description{
\code{oauth_client_req_auth()} authenticates a request using the authentication
strategy defined by the \code{auth} and \code{auth_param} arguments to \code{\link[=oauth_client]{oauth_client()}}.
This used to authenticate the client as part of the OAuth flow, \strong{not}
to authenticate a request on behalf of a user.

There are three built-in strategies:
\itemize{
\item \code{oauth_client_req_body()} adds the client id and (optionally) the secret
to the request body, as described in
\href{https://datatracker.ietf.org/doc/html/rfc6749#section-2.3.1}{rfc6749},
Section 2.3.1.
\item \code{oauth_client_req_header()} adds the client id and secret using HTTP
basic authentication with the \code{Authorization} header, as described in
\href{https://datatracker.ietf.org/doc/html/rfc6749#section-2.3.1}{rfc6749},
Section 2.3.1.
\item \code{oauth_client_jwt_rs256()} adds a client assertion to the body using a
JWT signed with \code{jwt_sign_rs256()} using a private key, as described in
\href{https://datatracker.ietf.org/doc/html/rfc7523#section-2.2}{rfc7523},
Section 2.2.
}

You will generally not call these functions directly but will instead
specify them through the \code{auth} argument to \code{\link[=oauth_client]{oauth_client()}}. The \code{req} and
\code{client} parameters are automatically filled in; other parameters come from
the \code{auth_params} argument.
}
\examples{
# Show what the various forms of client authentication look like
req <- request("https://example.com/whoami")

client1 <- oauth_client(
  id = "12345",
  secret = "56789",
  token_url = "https://example.com/oauth/access_token",
  name = "oauth-example",
  auth = "body" # the default
)
# calls oauth_client_req_auth_body()
req_dry_run(oauth_client_req_auth(req, client1))

client2 <- oauth_client(
  id = "12345",
  secret = "56789",
  token_url = "https://example.com/oauth/access_token",
  name = "oauth-example",
  auth = "header"
)
# calls oauth_client_req_auth_header()
req_dry_run(oauth_client_req_auth(req, client2))

client3 <- oauth_client(
  id = "12345",
  key = openssl::rsa_keygen(),
  token_url = "https://example.com/oauth/access_token",
  name = "oauth-example",
  auth = "jwt_sig",
  auth_params = list(claim = jwt_claim())
)
# calls oauth_client_req_auth_header_jwt_sig()
req_dry_run(oauth_client_req_auth(req, client3))
}
