% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops-m+.r
\name{\%m+\%}
\alias{\%m+\%}
\alias{m+}
\alias{m-}
\alias{\%m-\%}
\alias{\%m+\%,ANY,ANY-method}
\alias{\%m-\%,ANY,ANY-method}
\alias{\%m+\%,Period,ANY-method}
\alias{\%m+\%,ANY,Period-method}
\alias{\%m-\%,Period,ANY-method}
\alias{\%m-\%,ANY,Period-method}
\alias{\%m+\%,Duration,ANY-method}
\alias{\%m+\%,ANY,Duration-method}
\alias{\%m-\%,Duration,ANY-method}
\alias{\%m-\%,ANY,Duration-method}
\alias{\%m+\%,Interval,ANY-method}
\alias{\%m+\%,ANY,Interval-method}
\alias{\%m-\%,Interval,ANY-method}
\alias{\%m-\%,ANY,Interval-method}
\alias{add_with_rollback}
\title{Add and subtract months to a date without exceeding the last day of the new month}
\usage{
e1 \%m+\% e2

add_with_rollback(e1, e2, roll_to_first = FALSE, preserve_hms = TRUE)
}
\arguments{
\item{e1}{A period or a date-time object of class \link{POSIXlt}, \link{POSIXct}
or \link{Date}.}

\item{e2}{A period or a date-time object of class \link{POSIXlt}, \link{POSIXct}
or \link{Date}. Note that one of e1 and e2 must be a period and the other a
date-time object.}

\item{roll_to_first}{rollback to the first day of the month instead of the
last day of the previous month (passed to \code{\link[=rollback]{rollback()}})}

\item{preserve_hms}{retains the same hour, minute, and second information? If
FALSE, the new date will be at 00:00:00 (passed to \code{\link[=rollback]{rollback()}})}
}
\value{
A date-time object of class POSIXlt, POSIXct or Date
}
\description{
Adding months frustrates basic arithmetic because consecutive months have
different lengths. With other elements, it is helpful for arithmetic to
perform automatic roll over. For example, 12:00:00 + 61 seconds becomes
12:01:01. However, people often prefer that this behavior NOT occur with
months. For example, we sometimes want January 31 + 1 month = February 28 and
not March 3. \code{\%m+\%} performs this type of arithmetic. Date \code{\%m+\%} months(n)
always returns a date in the nth month after Date. If the new date would
usually spill over into the n + 1th month, \code{\%m+\%} will return the last day of
the nth month (\code{\link[=rollback]{rollback()}}). Date \code{\%m-\%} months(n) always returns a
date in the nth month before Date.
}
\details{
\code{\%m+\%} and \code{\%m-\%} handle periods with components less than a month by first
adding/subtracting months and then performing usual arithmetics with smaller
units.

\code{\%m+\%} and \code{\%m-\%} should be used with caution as they are not one-to-one
operations and results for either will be sensitive to the order of
operations.
}
\examples{
jan <- ymd_hms("2010-01-31 03:04:05")
jan + months(1:3) # Feb 31 and April 31 returned as NA
# NA "2010-03-31 03:04:05 UTC" NA
jan \%m+\% months(1:3) # No rollover

leap <- ymd("2012-02-29")
"2012-02-29 UTC"
leap \%m+\% years(1)
leap \%m+\% years(-1)
leap \%m-\% years(1)

x <- ymd_hms("2019-01-29 01:02:03")
add_with_rollback(x, months(1))
add_with_rollback(x, months(1), preserve_hms = FALSE)
add_with_rollback(x, months(1), roll_to_first = TRUE)
add_with_rollback(x, months(1), roll_to_first = TRUE, preserve_hms = FALSE)
}
