% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_group_sequential.R
\name{getPowerAndAverageSampleNumber}
\alias{getPowerAndAverageSampleNumber}
\title{Get Power And Average Sample Number}
\usage{
getPowerAndAverageSampleNumber(design, theta = seq(-1, 1, 0.02), nMax = 100)
}
\arguments{
\item{design}{The trial design.}

\item{theta}{A vector of standardized effect sizes (theta values), default is a sequence from -1 to 1.}

\item{nMax}{The maximum sample size. Must be a positive integer of length 1.}
}
\value{
Returns a \code{\link{PowerAndAverageSampleNumberResult}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.ParameterSet]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.PowerAndAverageSampleNumberResult]{as.data.frame()}}
to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the power and average sample number of the specified design.
}
\details{
This function returns the power and average sample number (ASN) of the specified
design for the prototype case which is testing H0: mu = mu0 in a one-sample design.
\code{theta} represents the standardized effect \code{(mu - mu0) / sigma} and power and ASN
is calculated for maximum sample size \code{nMax}.
For other designs than the one-sample test of a mean the standardized effect needs to be adjusted accordingly.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
# Calculate power, stopping probabilities, and expected sample 
# size for the default design with specified theta and nMax  
getPowerAndAverageSampleNumber(
    getDesignGroupSequential(), 
    theta = seq(-1, 1, 0.5), nMax = 100)

}
\seealso{
Other design functions: 
\code{\link{getDesignCharacteristics}()},
\code{\link{getDesignConditionalDunnett}()},
\code{\link{getDesignFisher}()},
\code{\link{getDesignGroupSequential}()},
\code{\link{getDesignInverseNormal}()},
\code{\link{getGroupSequentialProbabilities}()}
}
\concept{design functions}
