# Announce: Rakudo Perl 6 compiler, Release #101 (2016.07)

On behalf of the Rakudo development team, I’m very happy to announce the
July 2016 release of Rakudo Perl 6 #101. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2016.07:
 + Fixes:
   + Mu can now be the result of a Promise
   + samewith() now also works on none-multi's
   + Many fixes in the area of pre-compilation and installing modules
   + count-only and bool-only now are optional methods in Iterators
     (only to be implemented if they can work without generating anything)
   + IO::ArgFiles.slurp / IO::ArgFiles.eof are fixed
   + REPL whitespace and error handling
   + CompUnit::Repository::Installation no longer considers `bin/xxx` and
     `resources/bin/xxx` the same content address
   + min/max on Failures throw instead of returning ±Inf
   + NativeCall's is mangled trait no longer ignored for CPPStruct
 + Additions:
   + Support for new leap-second at 31-12-2016 added
   + The "is required" trait on Attributes can now take a Bool or a Str
   + IO::[Path,Handle] gained a .mode method which returns the POSIX file permissions
   + Distribution is now a role interface that enables encapsulating IO
     used for distribution installation
   + CompUnit::Repository::Installation now uses the new Distribution interface
   + Custom repository implementations now supported, including precompilation
 + Efficiency:
   + The MMD cache accepts candidates with named parameters if it can.
     (This made adverbed slices about 18x as fast)
   + Str.samemark is 50x faster
   + Str.contains is 6x faster
   + Baggy.pick(N)/pick()/roll()/grab() are 6x faster
   + Array.List is 5x faster
   + List.elems is 4.5x faster
   + for/map with 2 arguments is 4x faster (e.g. for @a.kv -> $i, $v { })
   + Str.substr-eq is 4x faster
   + List.Bool is 4x faster
   + Map eqv Map is 3x faster
   + Make "for List.pairs {}" 2.5x faster
   + Array.pop is 2.5x faster
   + List.AT-POS/EXISTS-POS are 2.5x faster
   + Creating arrays with [] is 2.5x faster
   + Array.AT-POS/ASSIGN-POS/BIND-POS at least 2x faster for unreified elements
   + Array.DELETE-POS is 7x faster
   + Str.starts-with is 2x faster
   + Array.shift is 2x faster
   + Blob/Buf.AT-POS is 2x faster (underlying method of e.g. "$buf[2]")
   + List.STORE is 2x faster (e.g. "my ($a,$b,$c) = (1,2,3)")
   + Make "for List.kv {}" 1.8x faster
   + Array.push/append is 40% faster
   + Str.comb 30% faster
   + Map/Hash initializations are now 30% faster
   + A slurpy taking a list is 30% faster ("sub a(*@a) { }; a(1,2,3,4)")
   + Pair.new is 10% faster
   + {}|[]:adverb is 2.5x faster

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The following people contributed to this release:

Elizabeth Mattijsen, Zoffix Znet, Jan-Olof Hendig, Stefan Seifert, Tom Browder, Wenzel P. P. Peppmeyer, Pepe Schwarz, Brock Wilcox, Jonathan Worthington, Aleks-Daniel Jakimenko-Aleksejev, Pawel Murias, Will "Coke" Coleda, Daniel Green, Josh Soref, Nick Logan, Christian Bartolomäus, Salvador Ortiz, Altai-man, Jonathan Stowe, Timo Paulssen, Brad Gilbert, Moritz Lenz, Steve Mynott, David H. Adler, neuron, ianmcb, Tobias Leich, Matt Oates, Rob Hoelz, Altai-ch, LLFourn

as well as

Bart Wiegmans, Brian S. Julin, Daniel Perrett, David Warring, Dominique Dumont, Itsuki Toyota, thundergnat

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#102), is tentatively scheduled for 2016-08-20.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.
