// file automatically generated by: ../../../rheolef/fem/lib/make_basis_list_cxx.sh
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/basis.h"
#include "rheolef/basis_get.h"
#include "basis_fem_Pk_lagrange.h"
#include "basis_fem_Pk_bernstein.h"
#include "basis_fem_Pk_sherwin.h"
#include "basis_fem_RTk.h"
#include "basis_fem_trace_n.h"
#include "basis_fem_vector.h"
#include "basis_fem_tensor.h"
#include "basis_fem_empty.h"
#include "P0.h"
#include "P1.h"
#include "bubble.h"
#include "P1qd.h"
namespace rheolef {
using namespace std;

template<class T>
bool
basis_rep<T>::have_index_parameter (std::string name) {
  if (name == "bubble") return false;
  if (name == "P1qd") return false;
  return true;
}
template<class T>
bool
basis_rep<T>::have_continuous_feature (std::string name) {
  if (name == "P0") return false;
  if (name == "bubble") return false;
  if (name == "P1qd") return false;
  return true;
}
template<class T>
basis_rep<T>*
basis_rep<T>::make_ptr (const std::string& name)
{
  family_index_option_type fio;
  basis_parse_from_string (name, fio);

  if (fio.family == "") return 0;
  if (fio.option.valued_tag() != space_constant::scalar) {
    basis_option sopt2 = fio.option;
    sopt2.set_valued_tag (space_constant::scalar);
    std::string name2 = basis_rep<T>::standard_naming (fio.family, fio.index, sopt2);
    // recursively call make_ptr without the vector/tensor option:
    basis_basic<T> scalar_basis;
    scalar_basis.basis_basic<T>::base::operator= (basis_rep<T>::make_ptr(name2));
    switch (fio.option.valued_tag()) {
      case space_constant::vector:
	  return new_macro(basis_fem_vector<T>(scalar_basis,fio.option));
      case space_constant::tensor:
	  return new_macro(basis_fem_tensor<T>(scalar_basis,fio.option));
      default:
          check_macro (fio.option.valued_tag() == space_constant::scalar,
	    fio.option.valued()<<"-valued basis not yet supported, sorry");
    }
  }
  if (fio.option.is_trace_n()) {
    basis_option sopt2 = fio.option;
    sopt2.set_trace_n(false);
    std::string name2 = basis_rep<T>::standard_naming (fio.family, fio.index, sopt2);
    // recursively call make_ptr without the trace_n option:
    basis_basic<T> tr_basis;
    tr_basis.basis_basic<T>::base::operator= (basis_rep<T>::make_ptr(name2));
    return new_macro(basis_fem_trace_n<T>(tr_basis));
  }
  if (fio.family == "P" && fio.index == 0) return new_macro(basis_P0<T>());
  if (fio.family == "P" && fio.index == 1) return new_macro(basis_P1<T>(fio.option));
  if (fio.family == "bubble") return new_macro(basis_bubble<T>);
  if (fio.family == "P1qd") return new_macro(basis_P1qd<T>);
  if (fio.family == "P")  return new_macro(basis_fem_Pk_lagrange<T> (fio.index, fio.option));
  if (fio.family == "B")  return new_macro(basis_fem_Pk_bernstein<T>(fio.index, fio.option));
  if (fio.family == "S")  return new_macro(basis_fem_Pk_sherwin<T>  (fio.index, fio.option));
  if (fio.family == "RT") return new_macro(basis_fem_RTk<T>         (fio.index, fio.option));
  if (fio.family == "empty")  return new_macro(basis_fem_empty<T>());
  error_macro ("undefined basis `" << fio.family << "'");
  return 0;
}
// instanciation in library:
template basis_rep<Float>* basis_rep<Float>::make_ptr (const std::string&);
template bool              basis_rep<Float>::have_index_parameter   (std::string family_name);
template bool              basis_rep<Float>::have_continuous_feature (std::string family_name);

} // namespace rheolef
