/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2020      Evan Nemerson <evan@nemerson.com>
 *   2020      Christopher Moore <moore@free.fr>
 */

#define SIMDE_TEST_X86_AVX512_INSN cmpgt

#include <test/x86/avx512/test-avx512.h>
#include <simde/x86/avx512/set.h>
#include <simde/x86/avx512/cmpgt.h>

static int
test_simde_mm512_cmpgt_epi8_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C(-121), INT8_C( 120), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C( -63), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -26), INT8_C(  89),
                           INT8_C( -13), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C(  68), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C( -13), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C( -43),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C( 115), INT8_C(  54), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C( -85),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104),
                           INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4)),
      UINT64_C(0x969d5243643621ad) },
    { simde_mm512_set_epi8(INT8_C(  16), INT8_C(  41), INT8_C( 102), INT8_C( -95),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(  62), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(  31), INT8_C(  24),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -27), INT8_C(   3),
                           INT8_C( -21), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(-108), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C( -37), INT8_C( -99), INT8_C( -56),
                           INT8_C(-119), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C( 115), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C(  38), INT8_C( -84), INT8_C( -53),
                           INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56)),
      simde_mm512_set_epi8(INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127)),
      UINT64_C(0xc46ac5246043f080) },
    { simde_mm512_set_epi8(INT8_C(  50), INT8_C(  43), INT8_C( -68), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C( -56), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C(-116), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C(  61),
                           INT8_C(-127), INT8_C(  -4), INT8_C(  48), INT8_C( -68),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  87), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8),
                           INT8_C(  63), INT8_C( -51), INT8_C(  -4), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65)),
      UINT64_C(0x5491482be6d6192d) },
    { simde_mm512_set_epi8(INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  32), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C( 122), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C( -80),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C(   8), INT8_C(  52), INT8_C( 117), INT8_C( 123),
                           INT8_C( -63), INT8_C(  45), INT8_C(  95), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25)),
      UINT64_C(0x4754f60c42869257) },
    { simde_mm512_set_epi8(INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C( 125), INT8_C( -42), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( -53), INT8_C(  34), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C(  65), INT8_C(   8), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C(  90),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C( -54), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -88),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21)),
      simde_mm512_set_epi8(INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64)),
      UINT64_C(0x9f8a170a1a071547) },
    { simde_mm512_set_epi8(INT8_C(  33), INT8_C( 121), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(   9), INT8_C( -42), INT8_C( 118),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(   3),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  66), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -75), INT8_C( -34), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110)),
      UINT64_C(0x390a6cac5bf669f6) },
    { simde_mm512_set_epi8(INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C( -28), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(-119), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C(  67), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70)),
      simde_mm512_set_epi8(INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4)),
      UINT64_C(0xd167f84855174f33) },
    { simde_mm512_set_epi8(INT8_C(  18), INT8_C(  13), INT8_C(  14), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( -34), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -21),
                           INT8_C( -41), INT8_C(  22), INT8_C(  45), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C(  10), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76)),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      UINT64_C(0x48a450990f8b8607) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpgt_epi8_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_equal_mmask64(r, test_vec[i].r);
   }

  return 0;
}

static int
test_simde_mm512_cmpgt_epu8_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 92), UINT8_C(135), UINT8_C(120), UINT8_C(237),
                             UINT8_C(183), UINT8_C( 22), UINT8_C(190), UINT8_C(227),
                             UINT8_C( 55), UINT8_C(193), UINT8_C(211), UINT8_C(137),
                             UINT8_C( 30), UINT8_C(227), UINT8_C(230), UINT8_C( 89),
                             UINT8_C(243), UINT8_C(119), UINT8_C(168), UINT8_C(109),
                             UINT8_C( 68), UINT8_C(246), UINT8_C(  0), UINT8_C(238),
                             UINT8_C(  1), UINT8_C(116), UINT8_C(243), UINT8_C(183),
                             UINT8_C(134), UINT8_C(  0), UINT8_C(111), UINT8_C( 95),
                             UINT8_C(236), UINT8_C(  3), UINT8_C(122), UINT8_C(213),
                             UINT8_C( 13), UINT8_C( 25), UINT8_C(221), UINT8_C(129),
                             UINT8_C( 82), UINT8_C( 90), UINT8_C( 53), UINT8_C(123),
                             UINT8_C( 73), UINT8_C(108), UINT8_C(238), UINT8_C( 15),
                             UINT8_C(115), UINT8_C( 54), UINT8_C(102), UINT8_C(118),
                             UINT8_C( 39), UINT8_C(179), UINT8_C( 45), UINT8_C( 81),
                             UINT8_C(239), UINT8_C(228), UINT8_C( 67), UINT8_C(171),
                             UINT8_C( 79), UINT8_C(143), UINT8_C(134), UINT8_C(124)),
      simde_x_mm512_set_epu8(UINT8_C(  9), UINT8_C(135), UINT8_C(120), UINT8_C(220),
                             UINT8_C( 36), UINT8_C(153), UINT8_C(152), UINT8_C( 25),
                             UINT8_C(145), UINT8_C(193), UINT8_C(221), UINT8_C(136),
                             UINT8_C( 28), UINT8_C(212), UINT8_C(230), UINT8_C(170),
                             UINT8_C(243), UINT8_C( 53), UINT8_C(168), UINT8_C(149),
                             UINT8_C( 68), UINT8_C( 42), UINT8_C(138), UINT8_C(111),
                             UINT8_C( 54), UINT8_C(198), UINT8_C(243), UINT8_C( 27),
                             UINT8_C( 23), UINT8_C( 41), UINT8_C(137), UINT8_C( 44),
                             UINT8_C(  7), UINT8_C(136), UINT8_C( 32), UINT8_C(213),
                             UINT8_C(114), UINT8_C(184), UINT8_C( 73), UINT8_C(160),
                             UINT8_C( 96), UINT8_C(110), UINT8_C(175), UINT8_C(180),
                             UINT8_C(103), UINT8_C(156), UINT8_C(234), UINT8_C( 18),
                             UINT8_C(115), UINT8_C( 54), UINT8_C(216), UINT8_C(125),
                             UINT8_C(110), UINT8_C( 31), UINT8_C( 51), UINT8_C(152),
                             UINT8_C(141), UINT8_C(229), UINT8_C( 62), UINT8_C(171),
                             UINT8_C( 49), UINT8_C(141), UINT8_C( 38), UINT8_C(  4)),
      UINT64_C(0x9b1c4519a20204af) },
    { simde_x_mm512_set_epu8(UINT8_C( 16), UINT8_C( 41), UINT8_C(102), UINT8_C(161),
                             UINT8_C( 17), UINT8_C( 42), UINT8_C(170), UINT8_C( 38),
                             UINT8_C( 62), UINT8_C(200), UINT8_C( 60), UINT8_C( 19),
                             UINT8_C(156), UINT8_C(149), UINT8_C(105), UINT8_C(180),
                             UINT8_C( 10), UINT8_C(247), UINT8_C(244), UINT8_C(200),
                             UINT8_C(185), UINT8_C( 96), UINT8_C( 31), UINT8_C( 24),
                             UINT8_C( 68), UINT8_C(249), UINT8_C(229), UINT8_C(  3),
                             UINT8_C(235), UINT8_C( 50), UINT8_C(189), UINT8_C(217),
                             UINT8_C(148), UINT8_C( 62), UINT8_C(101), UINT8_C( 56),
                             UINT8_C(177), UINT8_C(219), UINT8_C(157), UINT8_C(200),
                             UINT8_C(137), UINT8_C(200), UINT8_C(248), UINT8_C(240),
                             UINT8_C(115), UINT8_C(161), UINT8_C(183), UINT8_C( 54),
                             UINT8_C(125), UINT8_C( 85), UINT8_C( 78), UINT8_C(191),
                             UINT8_C(  4), UINT8_C( 38), UINT8_C(172), UINT8_C(203),
                             UINT8_C( 68), UINT8_C(148), UINT8_C(135), UINT8_C(141),
                             UINT8_C(197), UINT8_C(178), UINT8_C(145), UINT8_C( 56)),
      simde_x_mm512_set_epu8(UINT8_C(152), UINT8_C(154), UINT8_C(102), UINT8_C(161),
                             UINT8_C( 69), UINT8_C( 13), UINT8_C(235), UINT8_C( 45),
                             UINT8_C( 62), UINT8_C(136), UINT8_C(145), UINT8_C( 32),
                             UINT8_C(149), UINT8_C(226), UINT8_C( 99), UINT8_C(192),
                             UINT8_C(  8), UINT8_C(214), UINT8_C( 81), UINT8_C(222),
                             UINT8_C(210), UINT8_C( 26), UINT8_C( 31), UINT8_C(254),
                             UINT8_C( 68), UINT8_C(249), UINT8_C(185), UINT8_C( 46),
                             UINT8_C(235), UINT8_C(183), UINT8_C( 21), UINT8_C( 83),
                             UINT8_C(148), UINT8_C(159), UINT8_C(187), UINT8_C( 73),
                             UINT8_C( 57), UINT8_C(219), UINT8_C( 21), UINT8_C( 82),
                             UINT8_C(137), UINT8_C(130), UINT8_C(126), UINT8_C( 91),
                             UINT8_C(115), UINT8_C( 31), UINT8_C(177), UINT8_C( 28),
                             UINT8_C(150), UINT8_C(238), UINT8_C( 65), UINT8_C(152),
                             UINT8_C( 81), UINT8_C( 38), UINT8_C(172), UINT8_C(254),
                             UINT8_C(242), UINT8_C( 85), UINT8_C(176), UINT8_C( 80),
                             UINT8_C( 48), UINT8_C( 93), UINT8_C( 79), UINT8_C(127)),
      UINT64_C(0x44ae4230b77305e) },
    { simde_x_mm512_set_epu8(UINT8_C( 50), UINT8_C( 43), UINT8_C(188), UINT8_C( 97),
                             UINT8_C(230), UINT8_C(153), UINT8_C( 71), UINT8_C(149),
                             UINT8_C( 91), UINT8_C( 45), UINT8_C(245), UINT8_C( 47),
                             UINT8_C( 29), UINT8_C(200), UINT8_C( 26), UINT8_C(247),
                             UINT8_C( 10), UINT8_C( 36), UINT8_C(140), UINT8_C(203),
                             UINT8_C( 41), UINT8_C(  1), UINT8_C(233), UINT8_C( 61),
                             UINT8_C(129), UINT8_C(252), UINT8_C( 48), UINT8_C(188),
                             UINT8_C( 89), UINT8_C(144), UINT8_C(225), UINT8_C(120),
                             UINT8_C( 35), UINT8_C( 62), UINT8_C(235), UINT8_C(142),
                             UINT8_C(152), UINT8_C( 57), UINT8_C( 42), UINT8_C(145),
                             UINT8_C( 94), UINT8_C(193), UINT8_C( 87), UINT8_C( 64),
                             UINT8_C(191), UINT8_C(254), UINT8_C(110), UINT8_C(248),
                             UINT8_C( 63), UINT8_C(205), UINT8_C(252), UINT8_C( 32),
                             UINT8_C(191), UINT8_C( 55), UINT8_C( 14), UINT8_C( 81),
                             UINT8_C(133), UINT8_C(156), UINT8_C(217), UINT8_C(212),
                             UINT8_C( 22), UINT8_C(112), UINT8_C( 16), UINT8_C( 15)),
      simde_x_mm512_set_epu8(UINT8_C( 50), UINT8_C(245), UINT8_C(188), UINT8_C(225),
                             UINT8_C(105), UINT8_C(150), UINT8_C( 98), UINT8_C( 51),
                             UINT8_C( 58), UINT8_C(103), UINT8_C(111), UINT8_C(129),
                             UINT8_C( 68), UINT8_C(200), UINT8_C(124), UINT8_C(137),
                             UINT8_C( 74), UINT8_C(194), UINT8_C(140), UINT8_C( 37),
                             UINT8_C(244), UINT8_C(114), UINT8_C(  0), UINT8_C( 61),
                             UINT8_C(103), UINT8_C(252), UINT8_C(151), UINT8_C(188),
                             UINT8_C( 39), UINT8_C(156), UINT8_C(163), UINT8_C( 11),
                             UINT8_C(176), UINT8_C(237), UINT8_C(234), UINT8_C(217),
                             UINT8_C(127), UINT8_C(218), UINT8_C(131), UINT8_C(145),
                             UINT8_C( 84), UINT8_C(160), UINT8_C( 87), UINT8_C(234),
                             UINT8_C(251), UINT8_C(253), UINT8_C(129), UINT8_C( 41),
                             UINT8_C( 74), UINT8_C( 72), UINT8_C(252), UINT8_C( 28),
                             UINT8_C(141), UINT8_C( 93), UINT8_C(102), UINT8_C( 44),
                             UINT8_C(153), UINT8_C(227), UINT8_C(206), UINT8_C( 48),
                             UINT8_C(160), UINT8_C(206), UINT8_C( 46), UINT8_C(191)),
      UINT64_C(0xda1128b28c55930) },
    { simde_x_mm512_set_epu8(UINT8_C(159), UINT8_C( 28), UINT8_C(198), UINT8_C( 11),
                             UINT8_C(242), UINT8_C(126), UINT8_C( 81), UINT8_C( 45),
                             UINT8_C(233), UINT8_C(120), UINT8_C(173), UINT8_C(240),
                             UINT8_C(  7), UINT8_C( 51), UINT8_C(199), UINT8_C(206),
                             UINT8_C(235), UINT8_C( 98), UINT8_C( 88), UINT8_C(  0),
                             UINT8_C(190), UINT8_C(  3), UINT8_C(124), UINT8_C(143),
                             UINT8_C( 50), UINT8_C( 32), UINT8_C(171), UINT8_C(163),
                             UINT8_C(212), UINT8_C(243), UINT8_C(162), UINT8_C( 17),
                             UINT8_C(122), UINT8_C( 79), UINT8_C(140), UINT8_C( 43),
                             UINT8_C(179), UINT8_C(131), UINT8_C(233), UINT8_C(136),
                             UINT8_C( 96), UINT8_C(192), UINT8_C(233), UINT8_C(210),
                             UINT8_C(227), UINT8_C(185), UINT8_C( 71), UINT8_C(176),
                             UINT8_C( 44), UINT8_C(164), UINT8_C(225), UINT8_C( 26),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C(117), UINT8_C(123),
                             UINT8_C(193), UINT8_C( 45), UINT8_C( 95), UINT8_C( 24),
                             UINT8_C(148), UINT8_C( 18), UINT8_C(196), UINT8_C( 28)),
      simde_x_mm512_set_epu8(UINT8_C(233), UINT8_C(155), UINT8_C(116), UINT8_C(127),
                             UINT8_C( 96), UINT8_C( 40), UINT8_C(159), UINT8_C( 40),
                             UINT8_C( 86), UINT8_C(212), UINT8_C( 70), UINT8_C(185),
                             UINT8_C( 62), UINT8_C(235), UINT8_C( 66), UINT8_C( 68),
                             UINT8_C(169), UINT8_C(195), UINT8_C( 48), UINT8_C(186),
                             UINT8_C( 18), UINT8_C(178), UINT8_C(158), UINT8_C(117),
                             UINT8_C( 74), UINT8_C( 32), UINT8_C( 93), UINT8_C(125),
                             UINT8_C(209), UINT8_C(196), UINT8_C(170), UINT8_C(117),
                             UINT8_C(122), UINT8_C(202), UINT8_C( 50), UINT8_C(123),
                             UINT8_C(225), UINT8_C(182), UINT8_C(192), UINT8_C( 54),
                             UINT8_C(175), UINT8_C( 60), UINT8_C( 31), UINT8_C(233),
                             UINT8_C(108), UINT8_C(137), UINT8_C(164), UINT8_C(176),
                             UINT8_C(226), UINT8_C(219), UINT8_C( 51), UINT8_C(220),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C( 97), UINT8_C(123),
                             UINT8_C(207), UINT8_C(132), UINT8_C( 95), UINT8_C(173),
                             UINT8_C( 70), UINT8_C(206), UINT8_C(195), UINT8_C( 25)),
      UINT64_C(0x2db3a93c236c220b) },
    { simde_x_mm512_set_epu8(UINT8_C(121), UINT8_C(236), UINT8_C(167), UINT8_C(162),
                             UINT8_C(112), UINT8_C(229), UINT8_C( 81), UINT8_C(202),
                             UINT8_C(192), UINT8_C(142), UINT8_C( 48), UINT8_C(167),
                             UINT8_C(195), UINT8_C( 26), UINT8_C( 43), UINT8_C( 29),
                             UINT8_C(  0), UINT8_C(125), UINT8_C(214), UINT8_C(189),
                             UINT8_C( 15), UINT8_C(120), UINT8_C( 36), UINT8_C( 40),
                             UINT8_C(203), UINT8_C( 34), UINT8_C(148), UINT8_C(198),
                             UINT8_C( 26), UINT8_C(145), UINT8_C( 63), UINT8_C(158),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C(132), UINT8_C( 96),
                             UINT8_C(243), UINT8_C(158), UINT8_C( 99), UINT8_C( 90),
                             UINT8_C( 56), UINT8_C(211), UINT8_C(148), UINT8_C(237),
                             UINT8_C(132), UINT8_C(229), UINT8_C( 22), UINT8_C(126),
                             UINT8_C(150), UINT8_C(188), UINT8_C(196), UINT8_C(  8),
                             UINT8_C(202), UINT8_C( 93), UINT8_C(223), UINT8_C(229),
                             UINT8_C(249), UINT8_C( 27), UINT8_C(134), UINT8_C(168),
                             UINT8_C( 23), UINT8_C(  6), UINT8_C( 45), UINT8_C(235)),
      simde_x_mm512_set_epu8(UINT8_C(105), UINT8_C( 52), UINT8_C( 85), UINT8_C(152),
                             UINT8_C( 57), UINT8_C(225), UINT8_C(218), UINT8_C(132),
                             UINT8_C(149), UINT8_C(254), UINT8_C( 55), UINT8_C( 46),
                             UINT8_C(185), UINT8_C( 77), UINT8_C( 18), UINT8_C( 70),
                             UINT8_C( 89), UINT8_C(125), UINT8_C(214), UINT8_C(131),
                             UINT8_C(121), UINT8_C(245), UINT8_C(187), UINT8_C(197),
                             UINT8_C(203), UINT8_C( 34), UINT8_C(  9), UINT8_C( 64),
                             UINT8_C(195), UINT8_C(231), UINT8_C(141), UINT8_C(100),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C( 69), UINT8_C(248),
                             UINT8_C(241), UINT8_C(205), UINT8_C(  1), UINT8_C( 90),
                             UINT8_C(115), UINT8_C( 51), UINT8_C(165), UINT8_C( 56),
                             UINT8_C( 64), UINT8_C(217), UINT8_C(137), UINT8_C(228),
                             UINT8_C(202), UINT8_C( 28), UINT8_C( 54), UINT8_C(248),
                             UINT8_C(202), UINT8_C(128), UINT8_C(228), UINT8_C(185),
                             UINT8_C(107), UINT8_C(190), UINT8_C(142), UINT8_C(168),
                             UINT8_C( 34), UINT8_C(173), UINT8_C(235), UINT8_C(192)),
      UINT64_C(0xfd9a10312a5c6181) },
    { simde_x_mm512_set_epu8(UINT8_C( 33), UINT8_C(121), UINT8_C(125), UINT8_C( 35),
                             UINT8_C(153), UINT8_C(208), UINT8_C(234), UINT8_C( 38),
                             UINT8_C(175), UINT8_C(  9), UINT8_C(245), UINT8_C(132),
                             UINT8_C( 71), UINT8_C(  9), UINT8_C(214), UINT8_C(118),
                             UINT8_C( 67), UINT8_C( 45), UINT8_C( 51), UINT8_C(164),
                             UINT8_C(126), UINT8_C(108), UINT8_C(133), UINT8_C(185),
                             UINT8_C(113), UINT8_C( 32), UINT8_C( 71), UINT8_C(  3),
                             UINT8_C(230), UINT8_C( 82), UINT8_C(175), UINT8_C(236),
                             UINT8_C(201), UINT8_C(112), UINT8_C( 66), UINT8_C( 37),
                             UINT8_C( 67), UINT8_C(187), UINT8_C( 64), UINT8_C( 39),
                             UINT8_C( 72), UINT8_C( 45), UINT8_C(120), UINT8_C(251),
                             UINT8_C(147), UINT8_C( 62), UINT8_C( 17), UINT8_C( 31),
                             UINT8_C(226), UINT8_C(198), UINT8_C( 56), UINT8_C( 21),
                             UINT8_C( 72), UINT8_C(181), UINT8_C(222), UINT8_C(120),
                             UINT8_C( 95), UINT8_C(108), UINT8_C( 32), UINT8_C( 64),
                             UINT8_C(128), UINT8_C(102), UINT8_C(235), UINT8_C( 28)),
      simde_x_mm512_set_epu8(UINT8_C(100), UINT8_C(121), UINT8_C( 18), UINT8_C( 28),
                             UINT8_C(139), UINT8_C(107), UINT8_C(  3), UINT8_C(194),
                             UINT8_C( 42), UINT8_C( 72), UINT8_C( 91), UINT8_C( 86),
                             UINT8_C(184), UINT8_C(  9), UINT8_C(176), UINT8_C(118),
                             UINT8_C(122), UINT8_C(148), UINT8_C(186), UINT8_C(193),
                             UINT8_C( 56), UINT8_C( 71), UINT8_C(242), UINT8_C( 49),
                             UINT8_C(183), UINT8_C( 53), UINT8_C(227), UINT8_C(  3),
                             UINT8_C(183), UINT8_C( 43), UINT8_C(234), UINT8_C( 85),
                             UINT8_C(230), UINT8_C(247), UINT8_C( 66), UINT8_C(  1),
                             UINT8_C(243), UINT8_C( 60), UINT8_C(137), UINT8_C(173),
                             UINT8_C(134), UINT8_C(192), UINT8_C(173), UINT8_C(182),
                             UINT8_C(119), UINT8_C(248), UINT8_C( 12), UINT8_C(113),
                             UINT8_C(244), UINT8_C(172), UINT8_C(  6), UINT8_C( 69),
                             UINT8_C(  2), UINT8_C(181), UINT8_C(222), UINT8_C(130),
                             UINT8_C(  3), UINT8_C(128), UINT8_C(247), UINT8_C( 24),
                             UINT8_C( 11), UINT8_C(162), UINT8_C(224), UINT8_C(110)),
      UINT64_C(0x3eb20d0d141a689a) },
    { simde_x_mm512_set_epu8(UINT8_C(  2), UINT8_C(175), UINT8_C( 14), UINT8_C( 90),
                             UINT8_C(156), UINT8_C(134), UINT8_C(221), UINT8_C( 81),
                             UINT8_C(242), UINT8_C(214), UINT8_C(125), UINT8_C(131),
                             UINT8_C(199), UINT8_C( 90), UINT8_C(247), UINT8_C( 63),
                             UINT8_C( 53), UINT8_C( 77), UINT8_C( 63), UINT8_C(172),
                             UINT8_C( 27), UINT8_C( 22), UINT8_C(228), UINT8_C(219),
                             UINT8_C( 65), UINT8_C(118), UINT8_C(130), UINT8_C( 97),
                             UINT8_C(109), UINT8_C(137), UINT8_C(142), UINT8_C(181),
                             UINT8_C(131), UINT8_C(121), UINT8_C(128), UINT8_C(103),
                             UINT8_C(  0), UINT8_C(101), UINT8_C(215), UINT8_C( 89),
                             UINT8_C( 67), UINT8_C(191), UINT8_C(  9), UINT8_C(249),
                             UINT8_C(193), UINT8_C( 13), UINT8_C(105), UINT8_C( 92),
                             UINT8_C(238), UINT8_C(235), UINT8_C(154), UINT8_C(142),
                             UINT8_C( 74), UINT8_C(121), UINT8_C(211), UINT8_C( 52),
                             UINT8_C(193), UINT8_C(163), UINT8_C( 98), UINT8_C(106),
                             UINT8_C(147), UINT8_C(209), UINT8_C( 37), UINT8_C( 70)),
      simde_x_mm512_set_epu8(UINT8_C(214), UINT8_C(132), UINT8_C( 54), UINT8_C( 74),
                             UINT8_C(164), UINT8_C( 99), UINT8_C( 79), UINT8_C(253),
                             UINT8_C( 61), UINT8_C(167), UINT8_C( 84), UINT8_C(162),
                             UINT8_C( 31), UINT8_C(140), UINT8_C(189), UINT8_C(154),
                             UINT8_C(184), UINT8_C(165), UINT8_C(151), UINT8_C(148),
                             UINT8_C(212), UINT8_C( 74), UINT8_C(228), UINT8_C(124),
                             UINT8_C(120), UINT8_C(215), UINT8_C(177), UINT8_C(122),
                             UINT8_C( 87), UINT8_C(137), UINT8_C( 54), UINT8_C(254),
                             UINT8_C(209), UINT8_C( 84), UINT8_C(130), UINT8_C(192),
                             UINT8_C( 14), UINT8_C( 11), UINT8_C( 37), UINT8_C(233),
                             UINT8_C( 67), UINT8_C(124), UINT8_C( 58), UINT8_C(162),
                             UINT8_C( 30), UINT8_C(223), UINT8_C( 70), UINT8_C(232),
                             UINT8_C( 38), UINT8_C(159), UINT8_C(200), UINT8_C(196),
                             UINT8_C(197), UINT8_C( 65), UINT8_C(182), UINT8_C( 45),
                             UINT8_C(245), UINT8_C( 55), UINT8_C(174), UINT8_C( 12),
                             UINT8_C(106), UINT8_C( 22), UINT8_C(132), UINT8_C(252)),
      UINT64_C(0x56ea110a465ac75c) },
    { simde_x_mm512_set_epu8(UINT8_C( 18), UINT8_C( 13), UINT8_C( 14), UINT8_C(  4),
                             UINT8_C(253), UINT8_C(192), UINT8_C( 17), UINT8_C(141),
                             UINT8_C( 21), UINT8_C(222), UINT8_C(125), UINT8_C(196),
                             UINT8_C(184), UINT8_C( 74), UINT8_C(251), UINT8_C(235),
                             UINT8_C(215), UINT8_C( 22), UINT8_C( 45), UINT8_C(102),
                             UINT8_C( 59), UINT8_C(176), UINT8_C(241), UINT8_C(193),
                             UINT8_C( 84), UINT8_C(185), UINT8_C(  8), UINT8_C( 12),
                             UINT8_C(245), UINT8_C(180), UINT8_C( 62), UINT8_C( 93),
                             UINT8_C(181), UINT8_C(179), UINT8_C(172), UINT8_C(148),
                             UINT8_C(221), UINT8_C( 14), UINT8_C(196), UINT8_C( 18),
                             UINT8_C( 23), UINT8_C(196), UINT8_C(193), UINT8_C(142),
                             UINT8_C(201), UINT8_C( 75), UINT8_C(157), UINT8_C(201),
                             UINT8_C( 58), UINT8_C( 76), UINT8_C(154), UINT8_C(138),
                             UINT8_C( 10), UINT8_C( 39), UINT8_C(119), UINT8_C( 85),
                             UINT8_C(248), UINT8_C(184), UINT8_C(196), UINT8_C(162),
                             UINT8_C(144), UINT8_C(119), UINT8_C(124), UINT8_C( 76)),
      simde_x_mm512_set_epu8(UINT8_C( 18), UINT8_C(182), UINT8_C( 14), UINT8_C( 36),
                             UINT8_C(249), UINT8_C(113), UINT8_C( 40), UINT8_C( 48),
                             UINT8_C(149), UINT8_C(222), UINT8_C(181), UINT8_C( 85),
                             UINT8_C(221), UINT8_C(140), UINT8_C( 65), UINT8_C(235),
                             UINT8_C( 15), UINT8_C(  3), UINT8_C( 45), UINT8_C( 21),
                             UINT8_C( 72), UINT8_C( 93), UINT8_C(108), UINT8_C(125),
                             UINT8_C(  1), UINT8_C( 75), UINT8_C( 21), UINT8_C(220),
                             UINT8_C(130), UINT8_C(122), UINT8_C( 71), UINT8_C( 76),
                             UINT8_C( 28), UINT8_C(200), UINT8_C( 32), UINT8_C(101),
                             UINT8_C(149), UINT8_C(145), UINT8_C(168), UINT8_C(237),
                             UINT8_C(179), UINT8_C( 19), UINT8_C(235), UINT8_C(145),
                             UINT8_C(188), UINT8_C( 82), UINT8_C(138), UINT8_C(180),
                             UINT8_C( 47), UINT8_C(127), UINT8_C( 62), UINT8_C(240),
                             UINT8_C( 10), UINT8_C(242), UINT8_C(156), UINT8_C( 86),
                             UINT8_C( 29), UINT8_C(107), UINT8_C( 56), UINT8_C( 21),
                             UINT8_C( 24), UINT8_C( 68), UINT8_C(160), UINT8_C( 64)),
      UINT64_C(0xd12d7cdba4ba0fd) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpgt_epu8_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_equal_mmask64(r, test_vec[i].r);
   }

  return 0;
}

static int
test_simde_mm512_cmpgt_epi32_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__mmask16 r;
  } test_vec[8] = {
    { simde_mm512_set_epi32(INT32_C( -126651070), INT32_C( 1757388710), INT32_C(  617530196), INT32_C(  407807901),
                            INT32_C( 1271989524), INT32_C( 1251214807), INT32_C(-1247045111), INT32_C(-1024057759),
                            INT32_C(   50729453), INT32_C(  464444874), INT32_C( 1840702207), INT32_C( 1916050591),
                            INT32_C(  484601458), INT32_C( -782065931), INT32_C(-1485735658), INT32_C(-1326388993)),
      simde_mm512_set_epi32(INT32_C(  111072774), INT32_C( 1757388710), INT32_C( 1496897687), INT32_C(  407807901),
                            INT32_C( 1271989524), INT32_C( 1496985365), INT32_C(-1247045111), INT32_C(-1225014979),
                            INT32_C(   50729453), INT32_C(  464444874), INT32_C(  924537351), INT32_C( 1916050591),
                            INT32_C(  484601458), INT32_C( -782065931), INT32_C(-1485735658), INT32_C(-1326388993)),
      UINT16_C(  288) },
    { simde_mm512_set_epi32(INT32_C( 2106044062), INT32_C( 1752498924), INT32_C(-1086695378), INT32_C(  627787891),
                            INT32_C(-1783053554), INT32_C(-1485517848), INT32_C( 1105114322), INT32_C(-1862707588),
                            INT32_C(  823946037), INT32_C(-2030244995), INT32_C( -219180660), INT32_C(  810910725),
                            INT32_C( -642105946), INT32_C(  760774613), INT32_C(  -62603432), INT32_C(-2064446807)),
      simde_mm512_set_epi32(INT32_C( 2106044062), INT32_C( 1752498924), INT32_C( -582421212), INT32_C( 1649238471),
                            INT32_C( 1446053889), INT32_C(-1485517848), INT32_C( 1105114322), INT32_C(-1862707588),
                            INT32_C( -846383385), INT32_C(-2030244995), INT32_C( -905258415), INT32_C(  810910725),
                            INT32_C(-1668595380), INT32_C( -760772652), INT32_C( 2145797270), INT32_C(   57887151)),
      UINT16_C(  172) },
    { simde_mm512_set_epi32(INT32_C(  948728954), INT32_C(  965445469), INT32_C( -298261731), INT32_C( 1889741023),
                            INT32_C(  101476677), INT32_C( -598834633), INT32_C( 1592735604), INT32_C(  428243294),
                            INT32_C(-2001034764), INT32_C( -639043872), INT32_C(  567427880), INT32_C(-1305749494),
                            INT32_C( -204185535), INT32_C( -550643286), INT32_C( -170363385), INT32_C( 1483518213)),
      simde_mm512_set_epi32(INT32_C(  948728954), INT32_C(  965445469), INT32_C(  364841947), INT32_C(-1221758106),
                            INT32_C(  101476677), INT32_C( -598834633), INT32_C( 1592735604), INT32_C(-1456245493),
                            INT32_C(-2001034764), INT32_C( -639043872), INT32_C(  567427880), INT32_C(-1305749494),
                            INT32_C( -204185535), INT32_C(  830345587), INT32_C( -170363385), INT32_C( -603563929)),
      UINT16_C( 4353) },
    { simde_mm512_set_epi32(INT32_C( -163413000), INT32_C( -831194762), INT32_C( -664019578), INT32_C( 2031024026),
                            INT32_C( 1912388774), INT32_C(  982200166), INT32_C(  596130243), INT32_C(  446035443),
                            INT32_C( 1373006598), INT32_C(-1540837035), INT32_C( 1581631435), INT32_C(-2083299381),
                            INT32_C( 1992847454), INT32_C(  448258110), INT32_C(  875345838), INT32_C( 1612926819)),
      simde_mm512_set_epi32(INT32_C(   81573630), INT32_C( -831194762), INT32_C( -664019578), INT32_C( 2031024026),
                            INT32_C( 1912388774), INT32_C(-2072470454), INT32_C(  596130243), INT32_C( 1961646011),
                            INT32_C( 1373006598), INT32_C( -197223193), INT32_C( 1581631435), INT32_C(-2083299381),
                            INT32_C( 1457480410), INT32_C( 1181119535), INT32_C( 1263228451), INT32_C(-1998542716)),
      UINT16_C( 1033) },
    { simde_mm512_set_epi32(INT32_C( 1436278246), INT32_C(   99684976), INT32_C( 1345577484), INT32_C(  166701508),
                            INT32_C( -780731111), INT32_C( -840749601), INT32_C( 1523342039), INT32_C( 1058674665),
                            INT32_C( -523908416), INT32_C( 1659465207), INT32_C(-1927062215), INT32_C(-1156760340),
                            INT32_C(  715569317), INT32_C(-1515814414), INT32_C( 1243253180), INT32_C( 2080215882)),
      simde_mm512_set_epi32(INT32_C(  432908742), INT32_C(   99684976), INT32_C(  -14330157), INT32_C(-1223154556),
                            INT32_C( -780731111), INT32_C(  696697372), INT32_C( 1523342039), INT32_C( 1058674665),
                            INT32_C( -523908416), INT32_C( 1659465207), INT32_C(-1927062215), INT32_C(-1156760340),
                            INT32_C( -171262349), INT32_C(-1515814414), INT32_C(-1234169573), INT32_C(-1847568101)),
      UINT16_C(45067) },
    { simde_mm512_set_epi32(INT32_C( 1399825551), INT32_C(-1064541474), INT32_C( 2112452992), INT32_C(  575137303),
                            INT32_C( -979898374), INT32_C(-1476679333), INT32_C( 1320423852), INT32_C( 1767893242),
                            INT32_C( -389599783), INT32_C(-1459729991), INT32_C(  995424065), INT32_C( -522129019),
                            INT32_C( -466751981), INT32_C( 1371238810), INT32_C( 1006677155), INT32_C( 1609037982)),
      simde_mm512_set_epi32(INT32_C( 1399825551), INT32_C(-1064541474), INT32_C( 2112452992), INT32_C(  134645750),
                            INT32_C(  500192289), INT32_C( 1600988950), INT32_C( 1320423852), INT32_C( 1198845893),
                            INT32_C( -389599783), INT32_C( 1504468794), INT32_C(  995424065), INT32_C(-2123865443),
                            INT32_C( -466751981), INT32_C(-1711282630), INT32_C( 1006677155), INT32_C( 1609037982)),
      UINT16_C( 4372) },
    { simde_mm512_set_epi32(INT32_C(-1862774816), INT32_C(   28374488), INT32_C(  250156705), INT32_C( -932694837),
                            INT32_C(-2079251566), INT32_C( -246439183), INT32_C( -875109534), INT32_C( 1740046060),
                            INT32_C( 1735819269), INT32_C( 1371885292), INT32_C( -914870851), INT32_C( -473073032),
                            INT32_C( -580976455), INT32_C( 1688786028), INT32_C(  637430498), INT32_C(-1740972685)),
      simde_mm512_set_epi32(INT32_C(-1862774816), INT32_C(   28374488), INT32_C(  580744870), INT32_C( -666445473),
                            INT32_C( -129274908), INT32_C( -928751425), INT32_C( -388443661), INT32_C( 1740046060),
                            INT32_C(-1909361652), INT32_C( 1371885292), INT32_C(  857928163), INT32_C(   37075976),
                            INT32_C( -580976455), INT32_C(-1545948444), INT32_C(  637430498), INT32_C(-1740972685)),
      UINT16_C( 1156) },
    { simde_mm512_set_epi32(INT32_C(-1890406982), INT32_C( 2110791016), INT32_C( 1083476771), INT32_C( -620691621),
                            INT32_C(  543588207), INT32_C( -227503647), INT32_C( -759273149), INT32_C(  775085710),
                            INT32_C( 1404885802), INT32_C(-1395233065), INT32_C(  832528180), INT32_C( 1065959566),
                            INT32_C(-2083201484), INT32_C(  937916550), INT32_C( -710457746), INT32_C( -246147415)),
      simde_mm512_set_epi32(INT32_C(   84669207), INT32_C(  470641840), INT32_C( 1083476771), INT32_C( -620691621),
                            INT32_C( 1099959895), INT32_C( -961354454), INT32_C(-1751384146), INT32_C(  775085710),
                            INT32_C( 1075765582), INT32_C(  834655006), INT32_C(  832528180), INT32_C( 1065959566),
                            INT32_C(  954342416), INT32_C(  937916550), INT32_C(-1946395018), INT32_C(  757651617)),
      UINT16_C(18050) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask16 r = simde_mm512_cmpgt_epi32_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_equal_mmask16(r, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_cmpgt_epi32_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask16 k;
    simde__m512i a;
    simde__m512i b;
    simde__mmask16 r;
  } test_vec[8] = {
       { UINT16_C(12249),
      simde_mm512_set_epi32(INT32_C(-1151856667), INT32_C(  -49918748), INT32_C(-1709830250), INT32_C( 1750293451),
                            INT32_C(-1728641738), INT32_C(   79295022), INT32_C(  308064941), INT32_C( 1216157597),
                            INT32_C(  320231148), INT32_C( -697875804), INT32_C(  990066955), INT32_C(-2091005609),
                            INT32_C( 1037816180), INT32_C( -748290940), INT32_C( 1166526776), INT32_C(-1428331975)),
      simde_mm512_set_epi32(INT32_C( 1846695950), INT32_C(  884046092), INT32_C( -392734818), INT32_C(-1618937497),
                            INT32_C(  670851975), INT32_C(-1269946840), INT32_C(-1917256160), INT32_C(  228203505),
                            INT32_C( 1263965918), INT32_C(-2053175323), INT32_C(-1206891799), INT32_C( -371464947),
                            INT32_C(  -99745007), INT32_C( -847464628), INT32_C(  -93605380), INT32_C(-1859612096)),
      UINT16_C( 1865) },
    { UINT16_C(47912),
      simde_mm512_set_epi32(INT32_C(  238725197), INT32_C( 1521340392), INT32_C(-2077410041), INT32_C( 2110592657),
                            INT32_C(  630925822), INT32_C(  689275449), INT32_C(-1970822997), INT32_C(-1836727953),
                            INT32_C(  237271984), INT32_C( -578417637), INT32_C( -768235708), INT32_C( 1362514984),
                            INT32_C( 2019276284), INT32_C(-1411239380), INT32_C( 2052618114), INT32_C(-1238213534)),
      simde_mm512_set_epi32(INT32_C( -669654436), INT32_C( -822780196), INT32_C(  205688995), INT32_C( 1680146061),
                            INT32_C(  393599682), INT32_C(-1451941808), INT32_C(  947305201), INT32_C(  -75999449),
                            INT32_C( -484166756), INT32_C(  833555969), INT32_C( -549302423), INT32_C( 1610578173),
                            INT32_C(-2070337581), INT32_C(  664412106), INT32_C(  255732930), INT32_C( 1319359183)),
      UINT16_C(38920) },
    { UINT16_C(35968),
      simde_mm512_set_epi32(INT32_C( -359339347), INT32_C( -666198998), INT32_C(  830421084), INT32_C(-2087460228),
                            INT32_C(-1475104408), INT32_C(  721289147), INT32_C( 1281161083), INT32_C(  852871551),
                            INT32_C(-1589170839), INT32_C( -746357372), INT32_C( -154169474), INT32_C( -148954645),
                            INT32_C(-1357418925), INT32_C(-2112116028), INT32_C(  174617048), INT32_C(   -4103177)),
      simde_mm512_set_epi32(INT32_C( -871886017), INT32_C(-1688556984), INT32_C(  524690471), INT32_C( -124192434),
                            INT32_C( 1423100629), INT32_C( -161239972), INT32_C( -396308843), INT32_C( 1070701282),
                            INT32_C(-1826016016), INT32_C(  425347357), INT32_C(  366897524), INT32_C( -401692546),
                            INT32_C( -812557761), INT32_C( 1614519786), INT32_C(-1648390428), INT32_C( 1830061179)),
      UINT16_C(33920) },
    { UINT16_C(16809),
      simde_mm512_set_epi32(INT32_C(-1280324837), INT32_C( -161347329), INT32_C(  735858798), INT32_C( -674499230),
                            INT32_C(  -21391979), INT32_C( -381504266), INT32_C( 1528317100), INT32_C(  430345703),
                            INT32_C( -679679907), INT32_C(  515475896), INT32_C( -731085275), INT32_C( 1308429395),
                            INT32_C(  582932299), INT32_C(  489160586), INT32_C( 1760701165), INT32_C(  118948129)),
      simde_mm512_set_epi32(INT32_C( 1240889055), INT32_C(  888122014), INT32_C(-1469013917), INT32_C( 1209972337),
                            INT32_C( -691361230), INT32_C(  361393556), INT32_C(-1167116782), INT32_C( 1467757879),
                            INT32_C( 2124803699), INT32_C( -154870634), INT32_C(-1603618479), INT32_C(-2032203238),
                            INT32_C( 2111773805), INT32_C( -496949166), INT32_C( 1844580247), INT32_C(-2053814402)),
      UINT16_C(   33) },
    { UINT16_C(44464),
      simde_mm512_set_epi32(INT32_C( 1072149321), INT32_C( 1813169024), INT32_C(-1284365076), INT32_C(-1623700182),
                            INT32_C(  530512850), INT32_C(  116537892), INT32_C(  258206492), INT32_C(  690441736),
                            INT32_C( 1005371642), INT32_C( 1116924342), INT32_C( 1297564984), INT32_C( -835039581),
                            INT32_C( 1286263864), INT32_C(-1749149234), INT32_C(  558298824), INT32_C( 1064688827)),
      simde_mm512_set_epi32(INT32_C( 1323805616), INT32_C(-1558886902), INT32_C( 1778691088), INT32_C(  108147743),
                            INT32_C( 1106435712), INT32_C( -967535450), INT32_C(  600280311), INT32_C(  109364043),
                            INT32_C(  423389578), INT32_C( 1225761441), INT32_C( -440804681), INT32_C( -707540326),
                            INT32_C(-1898655855), INT32_C(-1268681648), INT32_C(-1360056367), INT32_C( -275254487)),
      UINT16_C( 1440) },
    { UINT16_C(23993),
      simde_mm512_set_epi32(INT32_C(-2038065128), INT32_C( -446679229), INT32_C(   78082001), INT32_C(  379830516),
                            INT32_C(-1929569644), INT32_C( 1595859976), INT32_C(  320798226), INT32_C( -738570818),
                            INT32_C( -165441023), INT32_C( -172594873), INT32_C(  912601062), INT32_C(  -56802863),
                            INT32_C(  503255814), INT32_C( 2046199592), INT32_C( -622599746), INT32_C( 1337235103)),
      simde_mm512_set_epi32(INT32_C(-1519343201), INT32_C( -448055921), INT32_C(-1909251875), INT32_C( -347447915),
                            INT32_C(  397553753), INT32_C(  713040821), INT32_C(-1458903601), INT32_C(  -45886582),
                            INT32_C( 1230465483), INT32_C( -828483015), INT32_C( -699493978), INT32_C(-1811052070),
                            INT32_C( 1577065087), INT32_C( -109599940), INT32_C(-1093577090), INT32_C(-1788879767)),
      UINT16_C(21553) },
    { UINT16_C(10358),
      simde_mm512_set_epi32(INT32_C(  648390363), INT32_C(  -30837841), INT32_C(-1635592815), INT32_C( -694389961),
                            INT32_C( -883952626), INT32_C( -761345991), INT32_C(  346040825), INT32_C(-1780780575),
                            INT32_C( 1510717568), INT32_C(-1185143236), INT32_C( 2143540932), INT32_C(  880567806),
                            INT32_C(-1670993371), INT32_C(-1942419167), INT32_C(-1196759463), INT32_C( 1386099146)),
      simde_mm512_set_epi32(INT32_C(-1614031176), INT32_C(  414071648), INT32_C(-1152911954), INT32_C(  424701353),
                            INT32_C( 1739922394), INT32_C( -506382165), INT32_C(  257126844), INT32_C( 1724223193),
                            INT32_C( 1096709845), INT32_C(-1643231112), INT32_C(-1639890652), INT32_C( -403971200),
                            INT32_C( 1318667734), INT32_C(  206062573), INT32_C(  -18472190), INT32_C(   -1701112)),
      UINT16_C(  112) },
    { UINT16_C(35023),
      simde_mm512_set_epi32(INT32_C(  228305355), INT32_C(-1904004735), INT32_C(  118523411), INT32_C( 1661507666),
                            INT32_C(-1400326500), INT32_C(   63010183), INT32_C(   62197704), INT32_C( -635599967),
                            INT32_C( 1677709284), INT32_C(-1294080152), INT32_C( -900737233), INT32_C(-1991940005),
                            INT32_C( -240404149), INT32_C(-1448242105), INT32_C(-1972665039), INT32_C( 1511694245)),
      simde_mm512_set_epi32(INT32_C(-1506289043), INT32_C(   82234507), INT32_C( -557930538), INT32_C( -911612825),
                            INT32_C( 1352158017), INT32_C( -554125937), INT32_C( -727289650), INT32_C(-1102664191),
                            INT32_C( 1941639559), INT32_C(-2124299952), INT32_C( -385431179), INT32_C(  112242864),
                            INT32_C(  -66697069), INT32_C( 1379403470), INT32_C(-1996504296), INT32_C(  658235880)),
      UINT16_C(32835) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask16 r = simde_mm512_mask_cmpgt_epi32_mask(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_equal_mmask16(r, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_cmpgt_epi64_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__mmask8 r;
  } test_vec[8] = {
    { simde_mm512_set_epi64(INT64_C(-3344943500899736927), INT64_C( -508674271294480923),
                            INT64_C( 4367550852745697236), INT64_C(-1765523250257788813),
                            INT64_C(-6325172456788566604), INT64_C( 3340966423446181237),
                            INT64_C( 4899669249714194025), INT64_C(-3109134868060088778)),
      simde_mm512_set_epi64(INT64_C(-3344943500899736927), INT64_C( -115747659216396604),
                            INT64_C( 7173930031566073597), INT64_C(-1765523250257788813),
                            INT64_C(-4525526016698522721), INT64_C( 3340966423446181237),
                            INT64_C( 4899669249714194025), INT64_C(-3109134868060088778)),
      UINT8_C(  0) },
    { simde_mm512_set_epi64(INT64_C(  161300839730502102), INT64_C(-4154011080047619988),
                            INT64_C( 3510183776865199207), INT64_C( 5188039415407364902),
                            INT64_C(-8649541106015277925), INT64_C( 2036065042708484429),
                            INT64_C(-7714656548902029220), INT64_C(-9105101012109136347)),
      simde_mm512_set_epi64(INT64_C(  161300839730502102), INT64_C(-4154011080047619988),
                            INT64_C( 6120426103009778754), INT64_C( -248023738166197182),
                            INT64_C(-8649541106015277925), INT64_C( 2693047687180833180),
                            INT64_C(-7714656548902029220), INT64_C(-9105101012109136347)),
      UINT8_C( 16) },
    { simde_mm512_set_epi64(INT64_C(-2825253727352691686), INT64_C( 4405965118825132522),
                            INT64_C(-6791426899562410985), INT64_C(-4409900925389880930),
                            INT64_C( 1845845856613597884), INT64_C(-4842241423465696621),
                            INT64_C(  163081221433998591), INT64_C( 4482804709675222173)),
      simde_mm512_set_epi64(INT64_C( 3285810068291760082), INT64_C( 4405965118825132522),
                            INT64_C(-6791426899562410985), INT64_C(-4943963491966669187),
                            INT64_C( 1845845856613597884), INT64_C( 7384036385676540465),
                            INT64_C(-7313503223753260102), INT64_C( 5128036791088991318)),
      UINT8_C( 18) },
    { simde_mm512_set_epi64(INT64_C(-1633105180711142836), INT64_C(-4287337651200520652),
                            INT64_C( 8346707004388378871), INT64_C(-5848595418894109542),
                            INT64_C(-7300386321370732776), INT64_C( -648586863376006844),
                            INT64_C(-3473939784680689044), INT64_C(-1628617817613399979)),
      simde_mm512_set_epi64(INT64_C( 1934898870952452550), INT64_C(-4287337651200520652),
                            INT64_C( 1557479703737443505), INT64_C(-5848595418894109542),
                            INT64_C(-7179299072208562799), INT64_C( -648586863376006844),
                            INT64_C(-3473939784680689044), INT64_C( 2817575692173645704)),
      UINT8_C( 32) },
    { simde_mm512_set_epi64(INT64_C(-8952123954418726140), INT64_C( 5461301954902244462),
                            INT64_C(-5820184907423972656), INT64_C(  420402622060248705),
                            INT64_C(-1664441445637860283), INT64_C(-9088734991256809986),
                            INT64_C( 5606803261787264235), INT64_C( 3392608019150722653)),
      simde_mm512_set_epi64(INT64_C(-8952123954418726140), INT64_C(-6318099565586317695),
                            INT64_C(-5820184907423972656), INT64_C(  420402622060248705),
                            INT64_C(-1664441445637860283), INT64_C( 6565206217411025613),
                            INT64_C( 8598198622090956400), INT64_C(-7576266643160730964)),
      UINT8_C( 65) },
    { simde_mm512_set_epi64(INT64_C(-3313522622815895345), INT64_C(-6452175545498154090),
                            INT64_C( -937049212555566038), INT64_C(-4143019958444030865),
                            INT64_C(-3410665359562609619), INT64_C(  966786109195223540),
                            INT64_C( 7283097367839393163), INT64_C(-2640534975929709368)),
      simde_mm512_set_epi64(INT64_C(-3313522622815895345), INT64_C(-6452175545498154090),
                            INT64_C( 7057508826094118763), INT64_C(-2466255848420720587),
                            INT64_C(-3410665359562609619), INT64_C(-7091282311083875172),
                            INT64_C(-5778676633446214654), INT64_C(-2640534975929709368)),
      UINT8_C(  6) },
    { simde_mm512_set_epi64(INT64_C( 7946101066156420330), INT64_C(-1199223599247032864),
                            INT64_C(-1997073553979895023), INT64_C(-2305098272308636911),
                            INT64_C( -630363562210498119), INT64_C( 4426020973322885294),
                            INT64_C( 8782098874831326668), INT64_C(-6058337867533474769)),
      simde_mm512_set_epi64(INT64_C( 7946101066156420330), INT64_C(-1199223599247032864),
                            INT64_C(-1997073553979895023), INT64_C(-2305098272308636911),
                            INT64_C( -630363562210498119), INT64_C( 8629524505567702841),
                            INT64_C( 8782098874831326668), INT64_C( 2660246489815857132)),
      UINT8_C(  0) },
    { simde_mm512_set_epi64(INT64_C(-2815932903868980343), INT64_C(  791308056982133256),
                            INT64_C( 8277712790583824674), INT64_C(-3943050990178000322),
                            INT64_C(-2127265598488665647), INT64_C( 4379715049649431166),
                            INT64_C(-9154071905230416728), INT64_C(-2123362159730266714)),
      simde_mm512_set_epi64(INT64_C(-2815932903868980343), INT64_C(  791308056982133256),
                            INT64_C(-6685750631550937327), INT64_C( 1585978438239301211),
                            INT64_C( 3432556139556266760), INT64_C( 4379715049649431166),
                            INT64_C(-9154071905230416728), INT64_C(-1483875325616410698)),
      UINT8_C( 32) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask8 r = simde_mm512_cmpgt_epi64_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_equal_mmask8(r, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_cmpgt_epi64_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask8 k;
    simde__m512i a;
    simde__m512i b;
    simde__mmask8 r;
  } test_vec[8] = {
    { UINT8_C( 16),
      simde_mm512_set_epi64(INT64_C( 2255026789087372129), INT64_C( 6954636019969939696),
                            INT64_C( 8135587588110756767), INT64_C(-6775895683000468083),
                            INT64_C( -900701109459786534), INT64_C(-7915280239032503360),
                            INT64_C(-1216817989725562739), INT64_C(-8432176550710264558)),
      simde_mm512_set_epi64(INT64_C( 2255026789087372129), INT64_C( 6954636019969939696),
                            INT64_C( 8135587588110756767), INT64_C(-6775895683000468083),
                            INT64_C( -900701109459786534), INT64_C(-3598046066747317833),
                            INT64_C(-1709941778912207388), INT64_C( 3169788859761289772)),
      UINT8_C(  0) },
    { UINT8_C(  6),
      simde_mm512_set_epi64(INT64_C(-2239217399172416071), INT64_C(-1788368623206610532),
                            INT64_C(-8621353419023287056), INT64_C( 2167646577764527484),
                            INT64_C( 7373916114077140533), INT64_C( 4679914315089846813),
                            INT64_C(-4785189148228967071), INT64_C(-2291884851836211058)),
      simde_mm512_set_epi64(INT64_C(-4674113889822188979), INT64_C( 6851357122574510655),
                            INT64_C(-8621353419023287056), INT64_C( 2167646577764527484),
                            INT64_C( 7373916114077140533), INT64_C(-2091630176064440564),
                            INT64_C(-4166997073722787613), INT64_C(-2291884851836211058)),
      UINT8_C(  4) },
    { UINT8_C(231),
      simde_mm512_set_epi64(INT64_C( -437845083503418422), INT64_C( 7030863114044209442),
                            INT64_C( 8238064857893579595), INT64_C( 3062172269146343786),
                            INT64_C( 7457006241836305381), INT64_C(-9078752323516671886),
                            INT64_C(-6382075143273833301), INT64_C( 3840898770164583597)),
      simde_mm512_set_epi64(INT64_C(-4268408126209392137), INT64_C( 7030863114044209442),
                            INT64_C(  663353489862938549), INT64_C( 3062172269146343786),
                            INT64_C( 7457006241836305381), INT64_C( 8174310593560152615),
                            INT64_C(-6382075143273833301), INT64_C(-4495103935185291795)),
      UINT8_C(161) },
    { UINT8_C( 60),
      simde_mm512_set_epi64(INT64_C( 3543184366849060052), INT64_C( 8101296544771348510),
                            INT64_C( 1359772700119148960), INT64_C(-8357828074665392254),
                            INT64_C(-5672294839872616078), INT64_C(-2918525673450782654),
                            INT64_C(-6303315662009814438), INT64_C( 4773615511108508590)),
      simde_mm512_set_epi64(INT64_C( 3543184366849060052), INT64_C(  286276641590586651),
                            INT64_C( 1359772700119148960), INT64_C(-3217204137928962858),
                            INT64_C(-5672294839872616078), INT64_C(-2918525673450782654),
                            INT64_C(-2554453706959743566), INT64_C(-6197005744039272430)),
      UINT8_C(  0) },
    { UINT8_C( 97),
      simde_mm512_set_epi64(INT64_C(-4278296701436995238), INT64_C( 3569507405853529045),
                            INT64_C(-3380367559374400304), INT64_C(-4948363566435325304),
                            INT64_C(-6678298576976263631), INT64_C( 8848650777417470336),
                            INT64_C( 6320411494008491541), INT64_C( 2280208700508329072)),
      simde_mm512_set_epi64(INT64_C(  326944370261152484), INT64_C( 3569507405853529045),
                            INT64_C(  715678757448860576), INT64_C(-4948363566435325304),
                            INT64_C(-6678298576976263631), INT64_C(-5367013526541491012),
                            INT64_C( 1008601224594483315), INT64_C( 2280208700508329072)),
      UINT8_C(  0) },
    { UINT8_C(153),
      simde_mm512_set_epi64(INT64_C( 8361426666750729591), INT64_C(-6668359429543518025),
                            INT64_C( 2952092805333509636), INT64_C( 8284871946243647248),
                            INT64_C(-8896262213455925533), INT64_C( 3194469353298560173),
                            INT64_C( 5466230282228711049), INT64_C(-1091365868294702661)),
      simde_mm512_set_epi64(INT64_C(-8667260419906723988), INT64_C(-6668359429543518025),
                            INT64_C( 2952092805333509636), INT64_C( 8284871946243647248),
                            INT64_C( 3185065043241333471), INT64_C( -134870333477219304),
                            INT64_C( 5466230282228711049), INT64_C(-4571723861926798973)),
      UINT8_C(129) },
    { UINT8_C( 60),
      simde_mm512_set_epi64(INT64_C(-5632979726637184794), INT64_C( 3790754159972080576),
                            INT64_C(-7842038005332057398), INT64_C(-1292705499011984897),
                            INT64_C( 7597886654367336733), INT64_C( 1457057381762531412),
                            INT64_C(-1572264173383359920), INT64_C(-8716209376375056305)),
      simde_mm512_set_epi64(INT64_C(-5632979726637184794), INT64_C( 3790754159972080576),
                            INT64_C( 1913605115921194336), INT64_C(-6143563121944184390),
                            INT64_C( 7597886654367336733), INT64_C( 1457057381762531412),
                            INT64_C( 7253226870637562008), INT64_C(-6283001429373579825)),
      UINT8_C( 16) },
    { UINT8_C( 88),
      simde_mm512_set_epi64(INT64_C(-2374777447002601129), INT64_C(-5785141086360428669),
                            INT64_C( 6450311718709789609), INT64_C( 4609381622161693926),
                            INT64_C( -638886780002324864), INT64_C(-5739159461288227194),
                            INT64_C(-4392084870376418631), INT64_C( 2798977638636065147)),
      simde_mm512_set_epi64(INT64_C(  753500986908300233), INT64_C(-5785141086360428669),
                            INT64_C( 6450311718709789609), INT64_C(-4648819914956469219),
                            INT64_C(-8767820380557260648), INT64_C(-5739159461288227194),
                            INT64_C( 2360822030941279123), INT64_C(-6092063218708168180)),
      UINT8_C( 24) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask8 r = simde_mm512_mask_cmpgt_epi64_mask(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_equal_mmask8(r, test_vec[i].r);
  }

  return 0;
}

SIMDE_TEST_FUNC_LIST_BEGIN
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmpgt_epi8_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmpgt_epu8_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmpgt_epi32_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_cmpgt_epi32_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmpgt_epi64_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_mask_cmpgt_epi64_mask)
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/avx512/test-avx512-footer.h>
