/* BEGIN_HEADER                                              Java TreeView
 *
 * $Author: alokito $
 * $RCSfile: RCSVersion.java,v $
 * $Revision: 1.4 $
 * $Date: 2004-12-21 03:28:13 $
 * $Name:  $
 *
 * This file is part of Java TreeView
 * Copyright (C) 2001-2014 Alok Saldanha, All Rights Reserved. Modifications Copyright (C) Lawrence Berkeley Lab.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * END_HEADER 
 */
package edu.stanford.genetics.treeview;


import java.util.*;

public class RCSVersion {
	static Vector versions;
	static boolean added;
	String version;

	public RCSVersion(String version) {
		this.version = version;
		if(versions == null)
			versions = new Vector();
		versions.addElement(version);
	}

	public static Vector allVersions() {
		if(!added) {
			added = true;
			new RCSVersion("$Id: RCSVersion.java,v 1.4 2004-12-21 03:28:13 alokito Exp $");
		}
		return versions;
	}

	public String getVersion() {
		return version;
	}

	public static String getAllVersions() {
		StringBuffer b = new StringBuffer();
		for(int i = 0; i < versions.size(); i++)
			b.append(((RCSVersion)versions.elementAt(i)).version + "\n");
		return b.toString();
	}
}
