stats_dt=read.table("stats_for_input.txt", header=TRUE, stringsAsFactors=FALSE);
edges_dt=read.table("raw_graph_edges.txt", header=TRUE, stringsAsFactors=FALSE);
vertices_dt=read.table("raw_graph_vertices.txt", header=TRUE, stringsAsFactors=FALSE);

valnames=grep("VE", colnames(vertices_dt), value=TRUE);
for(valname in valnames)
{
	vertices_dt[,paste0(valname, "_norm")]=vertices_dt[,valname]/vertices_dt$area;
}

stats_dt_edge_value=stats_dt[which(stats_dt$name=="edge_value"),];
stats_dt_area=stats_dt[which(stats_dt$name=="area"),];
stats_dt_boundary=stats_dt[which(stats_dt$name=="boundary"),];
stats_dt_adjacency=stats_dt[which(stats_dt$name=="adjacency"),];
stats_dt_VE=stats_dt[which(stats_dt$name=="VE"),];
stats_dt_VESSa=stats_dt[which(stats_dt$name=="VESSa"),];
stats_dt_VESSb=stats_dt[which(stats_dt$name=="VESSb"),];
stats_dt_MVE=stats_dt[which(stats_dt$name=="MVE"),];
stats_dt_MVESSa=stats_dt[which(stats_dt$name=="MVESSa"),];
stats_dt_MVESSb=stats_dt[which(stats_dt$name=="MVESSb"),];
stats_dt_VE_norm=stats_dt[which(stats_dt$name=="VE_norm"),];
stats_dt_VESSa_norm=stats_dt[which(stats_dt$name=="VESSa_norm"),];
stats_dt_VESSb_norm=stats_dt[which(stats_dt$name=="VESSb_norm"),];
stats_dt_MVE_norm=stats_dt[which(stats_dt$name=="MVE_norm"),];
stats_dt_MVESSa_norm=stats_dt[which(stats_dt$name=="MVESSa_norm"),];
stats_dt_MVESSb_norm=stats_dt[which(stats_dt$name=="MVESSb_norm"),];

result_edges=data.frame(
  from=c(edges_dt$ir_contact_index1, edges_dt$ir_contact_index2),
  to=c(edges_dt$ir_contact_index2, edges_dt$ir_contact_index1),
  weight=(c(edges_dt$edge_value, edges_dt$edge_value)-stats_dt_edge_value$mean_core_01)/stats_dt_edge_value$sd_core_01);

result_self_edges=data.frame(
  from=vertices_dt$ir_contact_index,
  to=vertices_dt$ir_contact_index,
  weight=(sqrt(vertices_dt$area/pi)*pi-stats_dt_edge_value$mean_core_01)/stats_dt_edge_value$sd_core_01);

result_edges=rbind(result_edges, result_self_edges);

N_e=nrow(result_edges);
result_edges$weight=pmin(pmax(result_edges$weight, rep(-5.0, N_e)), rep(5.0, N_e));

result_vertices_in=data.frame(
  id=vertices_dt$ir_contact_index,
  area=(vertices_dt$area-stats_dt_area$mean_core_01)/stats_dt_area$sd_core_01,
  boundary=(vertices_dt$boundary-stats_dt_boundary$mean_core_01)/stats_dt_boundary$sd_core_01,
  adjacency=(vertices_dt$adjacency-stats_dt_adjacency$mean_core_01)/stats_dt_adjacency$sd_core_01,
  VE=(vertices_dt$VE-stats_dt_VE$mean_core_01)/stats_dt_VE$sd_core_01,
  VESSa=(vertices_dt$VESSa-stats_dt_VESSa$mean_core_01)/stats_dt_VESSa$sd_core_01,
  VESSb=(vertices_dt$VESSb-stats_dt_VESSb$mean_core_01)/stats_dt_VESSb$sd_core_01,
  MVE=(vertices_dt$MVE-stats_dt_MVE$mean_core_01)/stats_dt_MVE$sd_core_01,
  MVESSa=(vertices_dt$MVESSa-stats_dt_MVESSa$mean_core_01)/stats_dt_MVESSa$sd_core_01,
  MVESSb=(vertices_dt$MVESSb-stats_dt_MVESSb$mean_core_01)/stats_dt_MVESSb$sd_core_01,
  VE_norm=(vertices_dt$VE_norm-stats_dt_VE_norm$mean_core_01)/stats_dt_VE_norm$sd_core_01,
  VESSa_norm=(vertices_dt$VESSa_norm-stats_dt_VESSa_norm$mean_core_01)/stats_dt_VESSa_norm$sd_core_01,
  VESSb_norm=(vertices_dt$VESSb_norm-stats_dt_VESSb_norm$mean_core_01)/stats_dt_VESSb_norm$sd_core_01,
  MVE_norm=(vertices_dt$MVE_norm-stats_dt_MVE_norm$mean_core_01)/stats_dt_MVE_norm$sd_core_01,
  MVESSa_norm=(vertices_dt$MVESSa_norm-stats_dt_MVESSa_norm$mean_core_01)/stats_dt_MVESSa_norm$sd_core_01,
  MVESSb_norm=(vertices_dt$MVESSb_norm-stats_dt_MVESSb_norm$mean_core_01)/stats_dt_MVESSb_norm$sd_core_01);

N_v=nrow(result_vertices_in);
result_vertices_in$area=pmin(pmax(result_vertices_in$area, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$boundary=pmin(pmax(result_vertices_in$boundary, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$adjacency=pmin(pmax(result_vertices_in$adjacency, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$VE=pmin(pmax(result_vertices_in$VE, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$VESSa=pmin(pmax(result_vertices_in$VESSa, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$VESSb=pmin(pmax(result_vertices_in$VESSb, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$MVE=pmin(pmax(result_vertices_in$MVE, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$MVESSa=pmin(pmax(result_vertices_in$MVESSa, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$MVESSb=pmin(pmax(result_vertices_in$MVESSb, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$VE_norm=pmin(pmax(result_vertices_in$VE_norm, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$VESSa_norm=pmin(pmax(result_vertices_in$VESSa_norm, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$VESSb_norm=pmin(pmax(result_vertices_in$VESSb_norm, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$MVE_norm=pmin(pmax(result_vertices_in$MVE_norm, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$MVESSa_norm=pmin(pmax(result_vertices_in$MVESSa_norm, rep(-5.0, N_v)), rep(5.0, N_v));
result_vertices_in$MVESSb_norm=pmin(pmax(result_vertices_in$MVESSb_norm, rep(-5.0, N_v)), rep(5.0, N_v));

result_edges[,3:ncol(result_edges)]=round(result_edges[,3:ncol(result_edges)], digits=3);
result_vertices_in[,2:ncol(result_vertices_in)]=round(result_vertices_in[,2:ncol(result_vertices_in)], digits=3);

write.table(format(result_edges, digits=3, scientific=FALSE), file="graph_edges.csv", quote=FALSE, row.names=FALSE, sep=",");
write.table(format(result_vertices_in, digits=3, scientific=FALSE), file="graph_vertices.csv", quote=FALSE, row.names=FALSE, sep=",");
