/*
 * Decompiled with CFR 0.152.
 */
package org.bdval.io.compound;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bdval.io.compound.CompoundDataInput;
import org.bdval.io.compound.CompoundDirectoryEntry;

public class CompoundFileReader
implements Closeable {
    private static final Log LOG = LogFactory.getLog(CompoundFileReader.class);
    private final String filename;
    private RandomAccessFile stream;
    private Map<String, CompoundDirectoryEntry> nameToDirEntryMap;
    private long totalNumberOfFiles;

    public CompoundFileReader(String physicalFilename) throws IOException {
        this.filename = physicalFilename;
        this.stream = new RandomAccessFile(new File(physicalFilename), "r");
        this.scanDirectory();
    }

    public long getTotalNumberOfFiles() {
        return this.totalNumberOfFiles;
    }

    public CompoundDataInput readFile(String name) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("CompoundFileReader is not open.");
        }
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("The name specified was null or empty.");
        }
        CompoundDirectoryEntry entry = this.nameToDirEntryMap.get(name);
        if (entry == null) {
            throw new FileNotFoundException("The compound file " + this.filename + " does not contain the file " + name);
        }
        long position = entry.getDataPosition();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading an file that should be " + entry.getFileSize() + " bytes long"));
        }
        this.stream.seek(position);
        return new CompoundDataInput(this.stream, entry.getFileSize());
    }

    public Set<String> getFileNames() {
        return this.nameToDirEntryMap.keySet();
    }

    public long getFileSize(String name) throws FileNotFoundException {
        CompoundDirectoryEntry entry = this.nameToDirEntryMap.get(name);
        if (entry == null) {
            throw new FileNotFoundException("The compound file " + this.filename + " does not contain the file " + name);
        }
        return entry.getFileSize();
    }

    public synchronized void scanDirectory() throws IOException {
        this.nameToDirEntryMap = new LinkedHashMap<String, CompoundDirectoryEntry>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scanning directory from " + this.filename));
        }
        if (this.stream.length() != 0L) {
            this.stream.seek(0L);
            this.totalNumberOfFiles = this.stream.readLong();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Total number of files " + this.totalNumberOfFiles));
            }
            int i = 0;
            while ((long)i < this.totalNumberOfFiles) {
                long fileStartPosition = this.stream.getFilePointer();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Reading file starting at position " + fileStartPosition));
                }
                int fileState = this.stream.readInt();
                String fileName = this.stream.readUTF();
                long fileSize = this.stream.readLong();
                long dataPosition = this.stream.getFilePointer();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("File " + fileName + " has a state " + fileState + " size " + fileSize));
                }
                if (fileState == 0) {
                    CompoundDirectoryEntry dirEntry = new CompoundDirectoryEntry(fileName, fileStartPosition, dataPosition, fileSize);
                    this.nameToDirEntryMap.put(fileName, dirEntry);
                }
                this.stream.seek(dataPosition + fileSize);
                ++i;
            }
        }
    }

    public boolean containsFile(String name) {
        return this.nameToDirEntryMap.containsKey(name);
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    void addToDirectory(CompoundDirectoryEntry entry) {
        this.nameToDirEntryMap.put(entry.getName(), entry);
    }

    void removeFromDirectory(String entryName) {
        this.nameToDirEntryMap.remove(entryName);
    }

    public CompoundDirectoryEntry getDirectoryEntry(String name) {
        return this.nameToDirEntryMap.get(name);
    }

    public Collection<CompoundDirectoryEntry> getDirectory() {
        return this.nameToDirEntryMap.values();
    }
}

