// Generated by gmmproc 2.46.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/treemodel.h>
#include <gtkmm/private/treemodel_p.h>

#include <gtk/gtk.h>

/*
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/vectorutils.h>

#include <gtkmm/treeiter.h>
#include <gtkmm/treepath.h>
#include <gtk/gtk.h>

namespace
{

static gboolean proxy_foreach_iter_callback(GtkTreeModel* model, GtkTreePath*, GtkTreeIter* iter, void* data)
{
  typedef Gtk::TreeModel::SlotForeachIter SlotType;
  auto& slot = *static_cast<SlotType*>(data);

  try
  {
    return slot(Gtk::TreeModel::iterator(model, iter));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 1;
}

static gboolean proxy_foreach_path_callback(GtkTreeModel*, GtkTreePath* path, GtkTreeIter*, void* data)
{
  typedef Gtk::TreeModel::SlotForeachPath SlotType;
  auto& slot = *static_cast<SlotType*>(data);

  try
  {
    return slot(Gtk::TreeModel::Path(path, true));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 1;
}

static gboolean proxy_foreach_path_and_iter_callback(GtkTreeModel* model, GtkTreePath* path,
                                              GtkTreeIter* iter, void* data)
{
  typedef Gtk::TreeModel::SlotForeachPathAndIter SlotType;
  auto& slot = *static_cast<SlotType*>(data);

  try
  {
    return slot(Gtk::TreeModel::Path(path, true), Gtk::TreeModel::iterator(model, iter));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 1;
}

} //anonymous namespace


//Help the code generator, so that it doesn't have to fully qualify this type:
typedef Gtk::TreeModel::iterator iterator;

namespace Gtk
{

TreeModel::iterator TreeModel::get_iter(const Path& path)
{
  Gtk::TreeModel::iterator iter(this);
  gtk_tree_model_get_iter(gobj(), iter.gobj(), const_cast<GtkTreePath*>(path.gobj()));
  return iter;
}

TreeModel::iterator TreeModel::get_iter(const Glib::ustring& path_string)
{
  Gtk::TreeModel::iterator iter (this);
  gtk_tree_model_get_iter_from_string(gobj(), iter.gobj(), path_string.c_str());
  return iter;
}

TreeModel::Children TreeModel::children()
{
  return TreeNodeChildren(this);
}

TreeModel::Children TreeModel::children() const
{
  //TODO: Remove the const when we have a real const TreeNodeChildren, when we have a real const_iterator.
  return TreeNodeChildren(const_cast<TreeModel*>(this));
}

void TreeModel::set_value_impl(const iterator&, int, const Glib::ValueBase&)
{
  g_assert_not_reached();
}

void TreeModel::get_value_impl(const iterator& row, int column, Glib::ValueBase& value) const
{
  gtk_tree_model_get_value(
      const_cast<GtkTreeModel*>(gobj()),
      const_cast<GtkTreeIter*>(row.gobj()),
      column, value.gobj());
}

void TreeModel::foreach_iter(const SlotForeachIter& slot)
{
  SlotForeachIter slot_copy (slot);
  gtk_tree_model_foreach(gobj(), &proxy_foreach_iter_callback, &slot_copy);
}

void TreeModel::foreach_path(const SlotForeachPath& slot)
{
  SlotForeachPath slot_copy (slot);
  gtk_tree_model_foreach(gobj(), &proxy_foreach_path_callback, &slot_copy);
}

void TreeModel::foreach(const SlotForeachPathAndIter& slot)
{
  SlotForeachPathAndIter slot_copy (slot);
  gtk_tree_model_foreach(gobj(), &proxy_foreach_path_and_iter_callback, &slot_copy);
}

// Custom vfunc callbacks, because the C++ vfuncs have different parameters and return types
// that can not be generated automatically:
gboolean TreeModel_Class::iter_next_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      auto iter_input = TreeModel::iterator(self, iter);
      TreeModel::iterator iter_next( self, iter ); //Copies iter by value.
      gboolean test = obj->iter_next_vfunc(iter_input, iter_next);

      //Copy the new iter value to the C output parameter:
      if(test)
        *iter = *(iter_next.gobj());

      return test;
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
        g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
      )
    );

    // Call the original underlying C function:
    if(base && base->iter_next)
      return (*base->iter_next)(self, iter);
  }

  typedef gboolean RType;
  return RType();
}


bool TreeModel::iter_next_vfunc(const iterator& iter, iterator& iter_next) const
{
  //Call the default C implementation:

  const auto base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  if(base && base->iter_next)
  {
    auto iter_copy = iter;
    gboolean test = (*base->iter_next)(const_cast<GtkTreeModel*>(gobj()), iter_copy.gobj());
    if(test)
      iter_next = iter_copy;

    return test;
  }

  return bool();
}

gboolean TreeModel_Class::get_iter_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter, GtkTreePath* path)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      Gtk::TreeModel::iterator iter_out(self, iter); //copies the iter by value.
      gboolean test = obj->get_iter_vfunc(Gtk::TreePath(path, true), iter_out);

      //Copy the new iter value to the C output parameter:
      if(test)
        *iter = *(iter_out.gobj());

      return test;
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->get_iter)
      return (*base->get_iter)(self, iter, const_cast<GtkTreePath*>(path));
  }

  typedef gboolean RType;
  return RType();
}

bool TreeModel::get_iter_vfunc(const Path& path, iterator& iter) const
{
  //Call the default C implementation:

  const auto base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  if(base && base->get_iter)
  {
    return (*base->get_iter)( const_cast<GtkTreeModel*>(gobj()), iter.gobj(), const_cast<GtkTreePath*>(path.gobj()) );
  }

  return bool();
}

gboolean TreeModel_Class::iter_children_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter, GtkTreeIter* parent)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      Gtk::TreeModel::iterator iter_out(self, iter); //copies the iter by value.

      gboolean test = false;
      if(!parent)
      {
        //Deal with this case, which is documented in the C docs as:
        //" If @parent is %NULL returns the first node, equivalent to
        //  <literal>gtk_tree_model_get_iter_first (tree_model, iter);</literal> "
        test = obj->iter_nth_root_child_vfunc(0, iter_out);
      }
      else
      {
        //Normal case:
         Gtk::TreeModel::iterator parent_cpp(self, parent);
         test = obj->iter_children_vfunc(parent_cpp, iter_out);
      }

      //Copy the new iter value to the C output parameter:
      if(test)
        *iter = *(iter_out.gobj());

      return test;
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->iter_children)
      return (*base->iter_children)(self, iter, parent);
  }

  typedef gboolean RType;
  return RType();
}

bool TreeModel::iter_children_vfunc(const iterator& parent, iterator& iter) const
{
  //Call the default C implementation:

  const auto base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  if(base && base->iter_children)
  {
    return (*base->iter_children)( const_cast<GtkTreeModel*>(gobj()), iter.gobj(), const_cast<GtkTreeIter*>(parent.gobj()) );
  }

  return bool();
}

gboolean TreeModel_Class::iter_parent_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter, GtkTreeIter* child)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      Gtk::TreeModel::iterator iter_out(self, iter);
      Gtk::TreeModel::iterator child_cpp(self, child);
      gboolean test = obj->iter_parent_vfunc(child_cpp, iter_out);

      //Copy the new iter value to the C output parameter:
      if(test)
        *iter = *(iter_out.gobj());

      return test;
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->iter_parent)
      return (*base->iter_parent)(self, iter, child);
  }

  typedef gboolean RType;
  return RType();
}

bool TreeModel::iter_parent_vfunc(const iterator& child, iterator& iter) const
{
  //Call the default C implementation:

  const auto base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  if(base && base->iter_parent)
  {
    return (*base->iter_parent)( const_cast<GtkTreeModel*>(gobj()), iter.gobj(), const_cast<GtkTreeIter*>(child.gobj()) );
  }

  return bool();
}

gboolean TreeModel_Class::iter_nth_child_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter, GtkTreeIter* parent, int n)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      Gtk::TreeModel::iterator iter_out(self, iter);

      gboolean test = false;
      if(!parent)
      {
        // Deal with this special case, docuemnted in the C docs as:
        // "As a special case, if @parent is %NULL, then the nth root node is set.":
        test = obj->iter_nth_root_child_vfunc(n, iter_out);
      }
      else
      {
        //The normal case:
        Gtk::TreeModel::iterator parent_cpp(self, parent);
        test = obj->iter_nth_child_vfunc(parent_cpp, n, iter_out);
      }

      //Copy the new iter value to the C output parameter:
      if(test)
        *iter = *(iter_out.gobj());

      return test;
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->iter_nth_child)
      return (*base->iter_nth_child)(self, iter, parent, n);
  }

  typedef gboolean RType;
  return RType();
}

bool TreeModel::iter_nth_child_vfunc(const iterator& parent, int n, iterator& iter) const
{
  //Call the default C implementation:

  const auto base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  if(base && base->iter_nth_child)
  {
    return (*base->iter_nth_child)( const_cast<GtkTreeModel*>(gobj()), iter.gobj(), const_cast<GtkTreeIter*>(parent.gobj()), n );
  }

  return bool();
}

//See the implementation of iter_children_vfunc_callback() and iter_nth_child_vfunc_callback()
//to find out why this virtual function exists:
bool TreeModel::iter_nth_root_child_vfunc(int n, iterator& iter) const
{
  //Call the default C implementation:

  const auto base = static_cast<BaseClassType*>(
    g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
      g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
    )
  );

  if(base && base->iter_nth_child)
  {
    //This means that iter_nth_child(0) might be called by iter_children_vfunc_callback(),
    //but hopefully that's exactly the same thing. TODO: Ask why both vfuncs exist. murrayc.
    return (*base->iter_nth_child)( const_cast<GtkTreeModel*>(gobj()), iter.gobj(), 0 /* the null parent */, n );
  }

  return bool();
}

gboolean TreeModel_Class::iter_n_children_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.

      //Deal with the case that iter is null, as described in the C docs:
      if(iter)
        return obj->iter_n_children_vfunc( Gtk::TreeModel::iterator(self, iter) );
      else
        return obj->iter_n_root_children_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

    // Call the original underlying C function:
    if(base && base->iter_n_children)
      return (*base->iter_n_children)(self, iter);
  }

  typedef gboolean RType;
  return RType();
}

int TreeModel::iter_n_children_vfunc(const iterator& iter) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->iter_n_children)
    return (*base->iter_n_children)(const_cast<GtkTreeModel*>(gobj()), const_cast<GtkTreeIter*>((iter).gobj()));

  typedef int RType;
  return RType();
}

int TreeModel::iter_n_root_children_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->iter_n_children)
    return (*base->iter_n_children)(const_cast<GtkTreeModel*>(gobj()), 0 /* null iter to mean root node, as described in C docs */);

  typedef int RType;
  return RType();
}


void TreeModel::rows_reordered(const Path& path, const iterator& iter, const std::vector<int>& new_order)
{
  //The size of the array seems to be based on the known number of children. murrayc.
  gtk_tree_model_rows_reordered(gobj(),
                                const_cast<GtkTreePath*>((path).gobj()),
                                const_cast<GtkTreeIter*>((iter).gobj()),
                                const_cast<int*>(Glib::ArrayHandler<int>::vector_to_array(new_order).data ()));
}

void TreeModel::rows_reordered(const Path& path, const std::vector<int>& new_order)
{
  //The size of the array seems to be based on the known number of children. murrayc.
  gtk_tree_model_rows_reordered(gobj(),
                                const_cast<GtkTreePath*>((path).gobj()),
                                0,
                                const_cast<int*>(Glib::ArrayHandler<int>::vector_to_array(new_order).data ()));
}

} // namespace Gtk

namespace
{


static void TreeModel_signal_row_changed_callback(GtkTreeModel* self, GtkTreePath* p0,GtkTreeIter* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::Path&,const TreeModel::iterator& > SlotType;

  auto obj = dynamic_cast<TreeModel*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gtk::TreePath(p0, true)
, Gtk::TreeModel::iterator(self, p1)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo TreeModel_signal_row_changed_info =
{
  "row_changed",
  (GCallback) &TreeModel_signal_row_changed_callback,
  (GCallback) &TreeModel_signal_row_changed_callback
};


static void TreeModel_signal_row_inserted_callback(GtkTreeModel* self, GtkTreePath* p0,GtkTreeIter* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::Path&,const TreeModel::iterator& > SlotType;

  auto obj = dynamic_cast<TreeModel*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gtk::TreePath(p0, true)
, Gtk::TreeModel::iterator(self, p1)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo TreeModel_signal_row_inserted_info =
{
  "row_inserted",
  (GCallback) &TreeModel_signal_row_inserted_callback,
  (GCallback) &TreeModel_signal_row_inserted_callback
};


static void TreeModel_signal_row_has_child_toggled_callback(GtkTreeModel* self, GtkTreePath* p0,GtkTreeIter* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::Path&,const TreeModel::iterator& > SlotType;

  auto obj = dynamic_cast<TreeModel*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gtk::TreePath(p0, true)
, Gtk::TreeModel::iterator(self, p1)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo TreeModel_signal_row_has_child_toggled_info =
{
  "row_has_child_toggled",
  (GCallback) &TreeModel_signal_row_has_child_toggled_callback,
  (GCallback) &TreeModel_signal_row_has_child_toggled_callback
};


static void TreeModel_signal_row_deleted_callback(GtkTreeModel* self, GtkTreePath* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::Path& > SlotType;

  auto obj = dynamic_cast<TreeModel*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gtk::TreePath(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo TreeModel_signal_row_deleted_info =
{
  "row_deleted",
  (GCallback) &TreeModel_signal_row_deleted_callback,
  (GCallback) &TreeModel_signal_row_deleted_callback
};


static void TreeModel_signal_rows_reordered_callback(GtkTreeModel* self, GtkTreePath* p0,GtkTreeIter* p1,gint* p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TreeModel::Path&,const TreeModel::iterator&,int* > SlotType;

  auto obj = dynamic_cast<TreeModel*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gtk::TreePath(p0, true)
, Gtk::TreeModel::iterator(self, p1)
, p2
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo TreeModel_signal_rows_reordered_info =
{
  "rows_reordered",
  (GCallback) &TreeModel_signal_rows_reordered_callback,
  (GCallback) &TreeModel_signal_rows_reordered_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::TreeModelFlags>::value_type()
{
  return gtk_tree_model_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gtk::TreeModel> wrap(GtkTreeModel* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::TreeModel>( dynamic_cast<Gtk::TreeModel*> (Glib::wrap_auto_interface<Gtk::TreeModel> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Interface_Class& TreeModel_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &TreeModel_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = gtk_tree_model_get_type();
  }

  return *this;
}

void TreeModel_Class::iface_init_function(void* g_iface, void*)
{
  const auto klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != nullptr); 

  klass->get_flags = &get_flags_vfunc_callback;
  klass->get_n_columns = &get_n_columns_vfunc_callback;
  klass->get_column_type = &get_column_type_vfunc_callback;
    klass->iter_next = &iter_next_vfunc_callback;
    klass->get_iter = &get_iter_vfunc_callback;
    klass->iter_children = &iter_children_vfunc_callback;
    klass->iter_parent = &iter_parent_vfunc_callback;
    klass->iter_nth_child = &iter_nth_child_vfunc_callback;
    klass->iter_n_children = &iter_n_children_vfunc_callback;
    klass->iter_has_child = &iter_has_child_vfunc_callback;
  klass->ref_node = &ref_node_vfunc_callback;
  klass->unref_node = &unref_node_vfunc_callback;
  klass->get_path = &get_path_vfunc_callback;
  klass->get_value = &get_value_vfunc_callback;

  klass->row_changed = &row_changed_callback;
  klass->row_inserted = &row_inserted_callback;
  klass->row_has_child_toggled = &row_has_child_toggled_callback;
  klass->row_deleted = &row_deleted_callback;
  klass->rows_reordered = &rows_reordered_callback;
}

GtkTreeModelFlags TreeModel_Class::get_flags_vfunc_callback(GtkTreeModel* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return ((GtkTreeModelFlags)(obj->get_flags_vfunc()));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_flags)
  {
    GtkTreeModelFlags retval = (*base->get_flags)(self);
    return retval;
  }

  typedef GtkTreeModelFlags RType;
  return RType();
}
gint TreeModel_Class::get_n_columns_vfunc_callback(GtkTreeModel* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return obj->get_n_columns_vfunc();
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_n_columns)
  {
    gint retval = (*base->get_n_columns)(self);
    return retval;
  }

  typedef gint RType;
  return RType();
}
GType TreeModel_Class::get_column_type_vfunc_callback(GtkTreeModel* self, gint index)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return obj->get_column_type_vfunc(index
);
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_column_type)
  {
    GType retval = (*base->get_column_type)(self, index);
    return retval;
  }

  typedef GType RType;
  return RType();
}
gboolean TreeModel_Class::iter_has_child_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->iter_has_child_vfunc(Gtk::TreeModel::iterator(self, iter)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->iter_has_child)
  {
    gboolean retval = (*base->iter_has_child)(self, iter);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
void TreeModel_Class::ref_node_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->ref_node_vfunc(Gtk::TreeModel::iterator(self, iter)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->ref_node)
  {
    (*base->ref_node)(self, iter);
  }

}
void TreeModel_Class::unref_node_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->unref_node_vfunc(Gtk::TreeModel::iterator(self, iter)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->unref_node)
  {
    (*base->unref_node)(self, iter);
  }

}
GtkTreePath* TreeModel_Class::get_path_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return (obj->get_path_vfunc(Gtk::TreeModel::iterator(self, iter)
)).gobj_copy();
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_path)
  {
    GtkTreePath* retval = (*base->get_path)(self, iter);
    return retval;
  }

  typedef GtkTreePath* RType;
  return RType();
}
void TreeModel_Class::get_value_vfunc_callback(GtkTreeModel* self, GtkTreeIter* iter, gint column, GValue* value)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->get_value_vfunc(Gtk::TreeModel::iterator(self, iter)
, column
, *reinterpret_cast<Glib::ValueBase*>(value)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_value)
  {
    (*base->get_value)(self, iter, column, value);
  }

}

void TreeModel_Class::row_changed_callback(GtkTreeModel* self, GtkTreePath* p0, GtkTreeIter* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_row_changed(Gtk::TreePath(p0, true)
, Gtk::TreeModel::iterator(self, p1)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_changed)
    (*base->row_changed)(self, p0, p1);
}
void TreeModel_Class::row_inserted_callback(GtkTreeModel* self, GtkTreePath* p0, GtkTreeIter* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_row_inserted(Gtk::TreePath(p0, true)
, Gtk::TreeModel::iterator(self, p1)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_inserted)
    (*base->row_inserted)(self, p0, p1);
}
void TreeModel_Class::row_has_child_toggled_callback(GtkTreeModel* self, GtkTreePath* p0, GtkTreeIter* p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_row_has_child_toggled(Gtk::TreePath(p0, true)
, Gtk::TreeModel::iterator(self, p1)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_has_child_toggled)
    (*base->row_has_child_toggled)(self, p0, p1);
}
void TreeModel_Class::row_deleted_callback(GtkTreeModel* self, GtkTreePath* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_row_deleted(Gtk::TreePath(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_deleted)
    (*base->row_deleted)(self, p0);
}
void TreeModel_Class::rows_reordered_callback(GtkTreeModel* self, GtkTreePath* p0, GtkTreeIter* p1, gint* p2)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_rows_reordered(Gtk::TreePath(p0, true)
, Gtk::TreeModel::iterator(self, p1)
, p2
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->rows_reordered)
    (*base->rows_reordered)(self, p0, p1, p2);
}


Glib::ObjectBase* TreeModel_Class::wrap_new(GObject* object)
{
  return new TreeModel((GtkTreeModel*)(object));
}


/* The implementation: */

TreeModel::TreeModel()
:
  Glib::Interface(treemodel_class_.init())
{}

TreeModel::TreeModel(GtkTreeModel* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

TreeModel::TreeModel(const Glib::Interface_Class& interface_class)
: Glib::Interface(interface_class)
{
}

TreeModel::TreeModel(TreeModel&& src) noexcept
: Glib::Interface(std::move(src))
{}

TreeModel& TreeModel::operator=(TreeModel&& src) noexcept
{
  Glib::Interface::operator=(std::move(src));
  return *this;
}

TreeModel::~TreeModel() noexcept
{}

// static
void TreeModel::add_interface(GType gtype_implementer)
{
  treemodel_class_.init().add_interface(gtype_implementer);
}

TreeModel::CppClassType TreeModel::treemodel_class_; // initialize static member

GType TreeModel::get_type()
{
  return treemodel_class_.init().get_type();
}


GType TreeModel::get_base_type()
{
  return gtk_tree_model_get_type();
}


TreeModelFlags TreeModel::get_flags() const
{
  return ((TreeModelFlags)(gtk_tree_model_get_flags(const_cast<GtkTreeModel*>(gobj()))));
}

int TreeModel::get_n_columns() const
{
  return gtk_tree_model_get_n_columns(const_cast<GtkTreeModel*>(gobj()));
}

GType TreeModel::get_column_type(int index) const
{
  return gtk_tree_model_get_column_type(const_cast<GtkTreeModel*>(gobj()), index);
}

TreeModel::Path TreeModel::get_path(const iterator& iter) const
{
  return Gtk::TreePath(gtk_tree_model_get_path(const_cast<GtkTreeModel*>(gobj()), const_cast<GtkTreeIter*>((iter).gobj())), false);
}

void TreeModel::row_changed(const Path& path, const iterator& iter)
{
  gtk_tree_model_row_changed(gobj(), const_cast<GtkTreePath*>((path).gobj()), const_cast<GtkTreeIter*>((iter).gobj()));
}

void TreeModel::row_inserted(const Path& path, const iterator& iter)
{
  gtk_tree_model_row_inserted(gobj(), const_cast<GtkTreePath*>((path).gobj()), const_cast<GtkTreeIter*>((iter).gobj()));
}

void TreeModel::row_has_child_toggled(const Path& path, const iterator& iter)
{
  gtk_tree_model_row_has_child_toggled(gobj(), const_cast<GtkTreePath*>((path).gobj()), const_cast<GtkTreeIter*>((iter).gobj()));
}

void TreeModel::row_deleted(const Path& path)
{
  gtk_tree_model_row_deleted(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

void TreeModel::rows_reordered(const Path& path, const iterator& iter, int* new_order)
{
  gtk_tree_model_rows_reordered(gobj(), const_cast<GtkTreePath*>((path).gobj()), const_cast<GtkTreeIter*>((iter).gobj()), new_order);
}

Glib::ustring TreeModel::get_string(const iterator& iter) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_tree_model_get_string_from_iter(const_cast<GtkTreeModel*>(gobj()), const_cast<GtkTreeIter*>((iter).gobj())));
}


Glib::SignalProxy2< void,const TreeModel::Path&,const TreeModel::iterator& > TreeModel::signal_row_changed()
{
  return Glib::SignalProxy2< void,const TreeModel::Path&,const TreeModel::iterator& >(this, &TreeModel_signal_row_changed_info);
}


Glib::SignalProxy2< void,const TreeModel::Path&,const TreeModel::iterator& > TreeModel::signal_row_inserted()
{
  return Glib::SignalProxy2< void,const TreeModel::Path&,const TreeModel::iterator& >(this, &TreeModel_signal_row_inserted_info);
}


Glib::SignalProxy2< void,const TreeModel::Path&,const TreeModel::iterator& > TreeModel::signal_row_has_child_toggled()
{
  return Glib::SignalProxy2< void,const TreeModel::Path&,const TreeModel::iterator& >(this, &TreeModel_signal_row_has_child_toggled_info);
}


Glib::SignalProxy1< void,const TreeModel::Path& > TreeModel::signal_row_deleted()
{
  return Glib::SignalProxy1< void,const TreeModel::Path& >(this, &TreeModel_signal_row_deleted_info);
}


Glib::SignalProxy3< void,const TreeModel::Path&,const TreeModel::iterator&,int* > TreeModel::signal_rows_reordered()
{
  return Glib::SignalProxy3< void,const TreeModel::Path&,const TreeModel::iterator&,int* >(this, &TreeModel_signal_rows_reordered_info);
}


void Gtk::TreeModel::on_row_changed(const TreeModel::Path& path, const TreeModel::iterator& iter)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_changed)
    (*base->row_changed)(gobj(),const_cast<GtkTreePath*>((path).gobj()),const_cast<GtkTreeIter*>((iter).gobj()));
}
void Gtk::TreeModel::on_row_inserted(const TreeModel::Path& path, const TreeModel::iterator& iter)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_inserted)
    (*base->row_inserted)(gobj(),const_cast<GtkTreePath*>((path).gobj()),const_cast<GtkTreeIter*>((iter).gobj()));
}
void Gtk::TreeModel::on_row_has_child_toggled(const TreeModel::Path& path, const TreeModel::iterator& iter)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_has_child_toggled)
    (*base->row_has_child_toggled)(gobj(),const_cast<GtkTreePath*>((path).gobj()),const_cast<GtkTreeIter*>((iter).gobj()));
}
void Gtk::TreeModel::on_row_deleted(const TreeModel::Path& path)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_deleted)
    (*base->row_deleted)(gobj(),const_cast<GtkTreePath*>((path).gobj()));
}
void Gtk::TreeModel::on_rows_reordered(const TreeModel::Path& path, const TreeModel::iterator& iter, int* new_order)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->rows_reordered)
    (*base->rows_reordered)(gobj(),const_cast<GtkTreePath*>((path).gobj()),const_cast<GtkTreeIter*>((iter).gobj()),new_order);
}

TreeModelFlags Gtk::TreeModel::get_flags_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_flags)
  {
    TreeModelFlags retval(((TreeModelFlags)((*base->get_flags)(const_cast<GtkTreeModel*>(gobj())))));
    return retval;
  }

  typedef TreeModelFlags RType;
  return RType();
}
int Gtk::TreeModel::get_n_columns_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_n_columns)
  {
    int retval((*base->get_n_columns)(const_cast<GtkTreeModel*>(gobj())));
    return retval;
  }

  typedef int RType;
  return RType();
}
GType Gtk::TreeModel::get_column_type_vfunc(int index) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_column_type)
  {
    GType retval((*base->get_column_type)(const_cast<GtkTreeModel*>(gobj()),index));
    return retval;
  }

  typedef GType RType;
  return RType();
}
bool Gtk::TreeModel::iter_has_child_vfunc(const iterator& iter) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->iter_has_child)
  {
    bool retval((*base->iter_has_child)(const_cast<GtkTreeModel*>(gobj()),const_cast<GtkTreeIter*>((iter).gobj())));
    return retval;
  }

  typedef bool RType;
  return RType();
}
void Gtk::TreeModel::ref_node_vfunc(const iterator& iter) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->ref_node)
  {
    (*base->ref_node)(const_cast<GtkTreeModel*>(gobj()),const_cast<GtkTreeIter*>((iter).gobj()));
  }
}
void Gtk::TreeModel::unref_node_vfunc(const iterator& iter) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->unref_node)
  {
    (*base->unref_node)(const_cast<GtkTreeModel*>(gobj()),const_cast<GtkTreeIter*>((iter).gobj()));
  }
}
TreeModel::Path Gtk::TreeModel::get_path_vfunc(const iterator& iter) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_path)
  {
    TreeModel::Path retval(Gtk::TreePath((*base->get_path)(const_cast<GtkTreeModel*>(gobj()),const_cast<GtkTreeIter*>((iter).gobj())), false));
    return retval;
  }

  typedef TreeModel::Path RType;
  return RType();
}
void Gtk::TreeModel::get_value_vfunc(const iterator& iter, int column, Glib::ValueBase& value) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_value)
  {
    (*base->get_value)(const_cast<GtkTreeModel*>(gobj()),const_cast<GtkTreeIter*>((iter).gobj()),column,(value).gobj());
  }
}


} // namespace Gtk


