## RabbitMQ 3.6.4

`3.6.4` is a maintanence release.


### Server

#### Bug Fixes

 * Nodes on Windows will successfully start if Erlang is installed in a directory with spaces
   in the path.

   GitHub issue: [rabbitmq-server#859](https://github.com/rabbitmq/rabbitmq-server/issues/859)

 * Node health check is now node-local, as it was meant to be.

   GitHub issue: [rabbitmq-server#818](https://github.com/rabbitmq/rabbitmq-server/issues/818)

 * Queue deletion and termination will no longer leave "tomb stone" messages in message store
   files. This eliminates the confusing behavior when a node or cluster having no messages
   enqueued could have many thousands of such "marker" messages in the message store.

   GitHub issue: [rabbitmq-server#839](https://github.com/rabbitmq/rabbitmq-server/issues/839)

 * `rabbitmqctl cluster_status` will now output an accurate error message
   if invoked shortly after a node was removed from the cluster and the node cannot be
   contacted.

   GitHub issue: [rabbitmq-server#894](https://github.com/rabbitmq/rabbitmq-server/pull/894)
   
   Contributed by Peter Lemenkov (Red Hat)

#### Enhancements

 * Erlang VM scheduler binding type default has changed to `db`. This means fewer
   CPU context switches for some workloads.

   GitHub issue: [rabbitmq-server#612](https://github.com/rabbitmq/rabbitmq-server/issues/612)

### Management Plugin

#### Bug Fixes

 * HTTP API is now compatible with Erlang 19.0.

   GitHub issue: [rabbitmq-management#244](https://github.com/rabbitmq/rabbitmq-management/issues/244)

 * Temporary tables are no longer named using atoms, preventing a potential
   exhaustion of the runtime atom table.

   GitHub issue: [rabbitmq-management#245](https://github.com/rabbitmq/rabbitmq-management/issues/245)

 * Cluster links and traffic charts are correctly displayed again

   GitHub issue: [rabbitmq-management#250](https://github.com/rabbitmq/rabbitmq-management/issues/250)

 * Runtime metric charts now have a description pop-up associated with them.

   GitHub issue: [rabbitmq-management#247](https://github.com/rabbitmq/rabbitmq-management/issues/247)

### AMQP 1.0 plugin

#### Bug fixes

 * When an AMQP 1.0 specified its own list of source outcomes in a link
   attachment, it caused a crash of its session on the server. Now a
   protocol error is raised if the list contains invalid outcomes.

   GitHub issue: [rabbitmq-amqp1.0#31](https://github.com/rabbitmq/rabbitmq-amqp1.0/issues/31)

### Java Client

#### Enhancements

 * The client will now try to use TLS v1.2 and v1.1 before falling back to v1.0 by default.

   GitHub issue: [rabbitmq-java-client#155](https://github.com/rabbitmq/rabbitmq-java-client/issues/155)
