#!/bin/sh -e

PKG="update-motd"
MAJOR=3

error() {
	echo "ERROR: $@"
	exit 1
}

head -n1 debian/changelog | grep "unreleased" || error "This version must be 'unreleased'"

./debian/rules get-orig-source
cp ../*orig.tar.gz ../build-area
bzr bd
bzr bd -S
sed -i "s/) unreleased;/-0ubuntu1) karmic;/" debian/changelog
bzr bd -S

echo
echo
echo "# Test this build:"
echo "  sudo dpkg -i ../*.deb"
echo
echo "# If everything looks good, release:"
echo "  ./debian/release.sh"
echo
echo
