/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

import com.android.dex.util.ByteInput;
import com.android.dex.util.ByteOutput;

public final class EncodedValueCodec {
    private EncodedValueCodec() {
    }

    public static void writeSignedIntegralValue(ByteOutput byteOutput, int n, long l) {
        int n2;
        int n3 = 65 - Long.numberOfLeadingZeros(l ^ l >> 63);
        byteOutput.writeByte(n | n2 - 1 << 5);
        for (n2 = n3 + 7 >> 3; n2 > 0; --n2) {
            byteOutput.writeByte((byte)l);
            l >>= 8;
        }
    }

    public static void writeUnsignedIntegralValue(ByteOutput byteOutput, int n, long l) {
        int n2;
        int n3 = 64 - Long.numberOfLeadingZeros(l);
        if (n3 == 0) {
            n3 = 1;
        }
        byteOutput.writeByte(n | n2 - 1 << 5);
        for (n2 = n3 + 7 >> 3; n2 > 0; --n2) {
            byteOutput.writeByte((byte)l);
            l >>= 8;
        }
    }

    public static void writeRightZeroExtendedValue(ByteOutput byteOutput, int n, long l) {
        int n2;
        int n3 = 64 - Long.numberOfTrailingZeros(l);
        if (n3 == 0) {
            n3 = 1;
        }
        l >>= 64 - n2 * 8;
        byteOutput.writeByte(n | n2 - 1 << 5);
        for (n2 = n3 + 7 >> 3; n2 > 0; --n2) {
            byteOutput.writeByte((byte)l);
            l >>= 8;
        }
    }

    public static int readSignedInt(ByteInput byteInput, int n) {
        int n2 = 0;
        for (int i = n; i >= 0; --i) {
            n2 = n2 >>> 8 | (byteInput.readByte() & 0xFF) << 24;
        }
        return n2 >>= (3 - n) * 8;
    }

    public static int readUnsignedInt(ByteInput byteInput, int n, boolean bl) {
        int n2 = 0;
        if (!bl) {
            for (int i = n; i >= 0; --i) {
                n2 = n2 >>> 8 | (byteInput.readByte() & 0xFF) << 24;
            }
            n2 >>>= (3 - n) * 8;
        } else {
            for (int i = n; i >= 0; --i) {
                n2 = n2 >>> 8 | (byteInput.readByte() & 0xFF) << 24;
            }
        }
        return n2;
    }

    public static long readSignedLong(ByteInput byteInput, int n) {
        long l = 0L;
        for (int i = n; i >= 0; --i) {
            l = l >>> 8 | ((long)byteInput.readByte() & 0xFFL) << 56;
        }
        return l >>= (7 - n) * 8;
    }

    public static long readUnsignedLong(ByteInput byteInput, int n, boolean bl) {
        long l = 0L;
        if (!bl) {
            for (int i = n; i >= 0; --i) {
                l = l >>> 8 | ((long)byteInput.readByte() & 0xFFL) << 56;
            }
            l >>>= (7 - n) * 8;
        } else {
            for (int i = n; i >= 0; --i) {
                l = l >>> 8 | ((long)byteInput.readByte() & 0xFFL) << 56;
            }
        }
        return l;
    }
}

