/*
**
** Copyright 2010, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#include <utils/RefBase.h>
#include <binder/IInterface.h>
#include <binder/Parcel.h>

#include <media/IMediaRecorderClient.h>

namespace android {

enum {
    NOTIFY = IBinder::FIRST_CALL_TRANSACTION,
    READ_AUDIO,
};

class BpMediaRecorderClient: public BpInterface<IMediaRecorderClient>
{
public:
    BpMediaRecorderClient(const sp<IBinder>& impl)
        : BpInterface<IMediaRecorderClient>(impl)
    {
    }

    virtual void notify(int msg, int ext1, int ext2)
    {
        Parcel data, reply;
        data.writeInterfaceToken(IMediaRecorderClient::getInterfaceDescriptor());
        data.writeInt32(msg);
        data.writeInt32(ext1);
        data.writeInt32(ext2);
        remote()->transact(NOTIFY, data, &reply, IBinder::FLAG_ONEWAY);
    }

    virtual void readAudio()
    {
        Parcel data, reply;
        data.writeInterfaceToken(IMediaRecorderClient::getInterfaceDescriptor());
        remote()->transact(READ_AUDIO, data, &reply, IBinder::FLAG_ONEWAY);
    }
};

IMPLEMENT_META_INTERFACE(MediaRecorderClient, "android.media.IMediaRecorderClient");

// ----------------------------------------------------------------------

status_t BnMediaRecorderClient::onTransact(
    uint32_t code, const Parcel& data, Parcel* reply, uint32_t flags)
{
    switch (code) {
        case NOTIFY: {
            CHECK_INTERFACE(IMediaRecorderClient, data, reply);
            int msg = data.readInt32();
            int ext1 = data.readInt32();
            int ext2 = data.readInt32();
            notify(msg, ext1, ext2);
            return NO_ERROR;
        } break;
        case READ_AUDIO: {
            CHECK_INTERFACE(IMediaRecorderClient, data, reply);
            readAudio();
            return NO_ERROR;
        } break;
        default:
            return BBinder::onTransact(code, data, reply, flags);
    }
}

}; // namespace android
