/*

    Adder 5
     (Scorpion 5 Video Board)

    Skeleton Set List - For note keeping.

    This system is not emulated.

    Many sound roms are missing!

*/

#include "emu.h"
#include "includes/bfm_ad5.h"


MACHINE_CONFIG_EXTERN( bfm_ad5 );
INPUT_PORTS_EXTERN( bfm_ad5 );

#define ad5crcpt_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_START( ad5crcpt )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211599.bin", 0x0000, 0x1000000, CRC(0fa50547) SHA1(95b1890851e82ad827b739a8d359309529c0b5b7) )
ROM_END

ROM_START( ad5crcpta )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212599.bin", 0x0000, 0x1000000, CRC(10d4aef1) SHA1(71345ec08cecfdae7a8e0161fd0cf33b9cca5c3e) )
ROM_END



#define ad5bpfpm_others \
	ROM_REGION( 0x5000, "pics", 0 ) \
	ROM_LOAD( "95890492.bin", 0x0000, 0x5000, CRC(5bddee9e) SHA1(7c2af91793f1f8c3c7f12535874c032129af7c8c) ) \
	ROM_LOAD( "95890494.bin", 0x0000, 0x5000, CRC(84513cb2) SHA1(8d45cff91953263c4aa8e7cb4a437c27371bd8a1) ) \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95008987.bin", 0x0000, 0x0fe101, CRC(798c9559) SHA1(4afb21a78be73353741b5903099d3c48e44fcebb) ) /* ITSBULLSEYE SOUNDS */ \
	ROM_LOAD( "95008994.bin", 0x0000, 0x0fb8bc, CRC(2c7a4446) SHA1(b1e327747043c795e179643e8bd485f51f838021) ) /* BULLSEYEPFP SOUNDS */
ROM_START( ad5bpfpm )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211339.bin", 0x0000, 0xa91458, CRC(e653ce23) SHA1(8cf3ad73974d97f3ed1d715c607e7888cf0992b1) )
	ad5bpfpm_others
ROM_END

ROM_START( ad5bpfpma )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211337.bin", 0x0000, 0xa9136a, CRC(4e984598) SHA1(8e5af7faeb7fb650f7bd44e5e7b3c1162514d15f) )
	ad5bpfpm_others
ROM_END

ROM_START( ad5bpfpmb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212339.bin", 0x0000, 0xa91458, CRC(73ed1ef5) SHA1(a8132e47d4b5644a2da26d512fa68c9078fb2bc1) )
	ad5bpfpm_others
ROM_END

ROM_START( ad5bpfpmc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212344.bin", 0x0000, 0x4d2ac4, CRC(01c3c686) SHA1(1c5bb9da7f7ffbf3d2086de3c2a22fa0240187b3) )
	ad5bpfpm_others
ROM_END

ROM_START( ad5bpfpmd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211344.bin", 0x0000, 0x4d2ac4, CRC(2c20765f) SHA1(0856649f6ebef51e1159fdf6a146136a50cf5325) )
	ad5bpfpm_others
ROM_END


#define ad5cmons_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95008434.bin", 0x0000, 0x100000, CRC(2d35e8ab) SHA1(a2e39beb891416bc5fae3d17125d146fe3ec3a12) ) /* PR1601 CRAZY MONEY SOUNDS11 */
ROM_START( ad5cmons )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211009.bin", 0x0000, 0x8ba10c, CRC(3883c4ea) SHA1(ac5876d252ef9900bbd86a43c73b2e3ba08f4e04) )
	ad5cmons_others
ROM_END

ROM_START( ad5cmonsa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212009.bin", 0x00000, 0x8ba10c, CRC(40328a9d) SHA1(0923f4dfffd4eca3aa9f67dbb972dd47b78aa0ab) )
	ad5cmons_others
ROM_END


#define ad5dndpl_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95009108.bin", 0x000000, 0x100000, CRC(113b7f60) SHA1(62a8ca9dd9fc663971037936ddbd634273c3055f) ) /* PR3314 DOND PLATINUM SOUNDS11 */ \
	ROM_LOAD( "95009109.bin", 0x100000, 0x100000, CRC(edf5a701) SHA1(3514b4a46dd921446c74c5b87a3a4b272e7b0fdb) )

ROM_START( ad5dndpl )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211495.bin", 0x0000, 0x1000000, CRC(d87cda50) SHA1(215776dfe2b9393f8c58bdb0e14cf21505d01ae3) )
	ad5dndpl_others
ROM_END

ROM_START( ad5dndpla )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212495.bin", 0x0000, 0x1000000, CRC(67c829da) SHA1(c30353c432389e5648ffb14f9ff14821e11fcf38) )
	ad5dndpl_others
ROM_END

ROM_START( ad5dndplb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3314p71.bin", 0x0000, 0x1000000, CRC(56b9fa95) SHA1(d33d04089b95116da09700278a732d66eb06cf8c) )
	ad5dndpl_others
ROM_END

ROM_START( ad5dndplc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3314s71.bin", 0x0000, 0x1000000, CRC(a6285e1d) SHA1(c790c12150c152e08b541521ed2e80ed2203e639) )
	ad5dndpl_others
ROM_END


#define ad5hir_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95009143.bin", 0x000000, 0x100000, CRC(e8bab23e) SHA1(dc8e5173fcb301ee4abedc76d42ebf4d58d07af1) ) /* PR3401 HI ROLLER SOUNDS11 */ \
	ROM_LOAD( "95009144.bin", 0x100000, 0x100000, CRC(73b81f14) SHA1(0a8d7949a290dce2b9cd6c4ec42a64ac8f18836d) )

ROM_START( ad5hir )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3401p71.bin", 0x0000, 0x1000000, CRC(02dfd5d1) SHA1(cddab71cbd9061390183b773fa9a965812c34087) )
	ad5hir_others
ROM_END

ROM_START( ad5hira )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3401p72.bin", 0x0000, 0x1000000, CRC(f7a52510) SHA1(e6d494346b6b72a8b68dce24c95b35faee52a0a9) )
	ad5hir_others
ROM_END

ROM_START( ad5hirb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3401s71.bin", 0x0000, 0x1000000, CRC(247754f6) SHA1(78a1caaa613d9033b8f870e916df023f724adb95) )
	ad5hir_others
ROM_END

ROM_START( ad5hirc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3401s72.bin", 0x0000, 0x1000000, CRC(f7f13885) SHA1(b9d334fdc3e57f0ebaa32b9da6c0951784b87a65) )
	ad5hir_others
ROM_END

#define ad5hircl_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* game header wants SOUNDS12, check */\
	ROM_LOAD( "95008555.bin", 0x0000, 0x100000, CRC(51d07478) SHA1(1e678b61d594d4884601e92485ab22206dc425d4) ) /* PR1755 HI ROLLER SOUNDS11 */


ROM_START( ad5hircl )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211098.bin", 0x0000, 0x1000000, CRC(0f40863e) SHA1(30c15f42c6f293b3210dbc91f6fe55fc51069ab6) )
	ad5hircl_others
ROM_END

ROM_START( ad5hircla )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212098.bin", 0x0000, 0x1000000, CRC(32da0bbe) SHA1(117bc8496ae44ea641188b7a9e0952f9378520aa) )
	ad5hircl_others
ROM_END

ROM_START( ad5hirclb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212099.bin", 0x0000, 0x1000000, CRC(92661240) SHA1(670c733c73621a561c01cd50d2e0064a12ef615f) )
	ad5hircl_others
ROM_END


#define ad5dnd_others \
	ROM_REGION( 0x1000000, "ymz", ROMREGION_ERASE00 ) \
	PR1945_CASINO_D_O_N_D_SOUNDS11 \
	PR1945_CASINO_DOND_R_SOUNDS12

ROM_START( ad5dnd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211141.bin", 0x0000, 0x1000000, CRC(ef885c23) SHA1(bf874a7d5df40bc89a77aeaf6e9fb849360efbb5) ) // PR1965 CASINO TRIPLE
	ad5dnd_others
ROM_END

ROM_START( ad5dnda )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211152.bin", 0x0000, 0x1000000, CRC(2d9c8289) SHA1(c983a0ea439cd3281c6e9f39292ac9597055b385) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211161.bin", 0x0000, 0x1000000, CRC(2c3e8205) SHA1(dd55563acf8390d4b75672c2aa91e373b27ac841) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211162.bin", 0x0000, 0x1000000, CRC(6ec309e4) SHA1(5e3bd4b7c3bd4714ac642642fbe918b0a12e2fff) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212141.bin", 0x0000, 0x1000000, CRC(cd2b9a5c) SHA1(ce616657c0caec5b7a4418acd6c7af008e04fd9d) )
	ad5dnd_others
ROM_END

ROM_START( ad5dnde )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212152.bin", 0x0000, 0x1000000, CRC(ddc8ec20) SHA1(b009420fd3ba202b9cf1782b44e682de0c706cb8) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212153.bin", 0x0000, 0x1000000, CRC(7dee1072) SHA1(03f28c90a594b909255d8fb4bf2cdaba2f70c60b) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212161.bin", 0x0000, 0x1000000, CRC(5e5d63f4) SHA1(116a90f124700d434d0b7291451ee8759b3ca0d0) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndh )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212162.bin", 0x0000, 0x1000000, CRC(b55998b9) SHA1(925a311954b1c0daf9f38eaaac33d861eb6259df) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndi )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1965p01.bin", 0x0000, 0x1000000, CRC(2f0777f1) SHA1(30d6b3f4a38114fcb51203f86b2784e67b9f7d52) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndj )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1965p12.bin", 0x0000, 0x1000000, CRC(3a5e9a27) SHA1(73decbe70f15329844c78b81052657523302fcbc) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndk )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1965s01.bin", 0x0000, 0x1000000, CRC(1d9c2051) SHA1(e70c414e95995fcbce800e2a16049d3550ae6d1c) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndl )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1965s12.bin", 0x0000, 0x1000000, CRC(c4f520a3) SHA1(ed2655cf024f6c1d2579701cc24b606ca7be05ae) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndm )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1945p41.bin", 0x0000, 0x1000000, CRC(f8fbf79e) SHA1(1c1c351443373a1cf95c9ec3fe95f4b84645ece9) ) // PR1945 VIDEO CASINO DOND
	ad5dnd_others
ROM_END

ROM_START( ad5dndn )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1945p42.bin", 0x0000, 0x1000000, CRC(7a95bf89) SHA1(274feb54f50a59a8dc1352cee27e4330b58431dd) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndo )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1945p43.bin", 0x0000, 0x1000000, CRC(a0fc0903) SHA1(c51fda41eb3effd1f7052050a1104fc7fa9bfcbf) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndp )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1945s41.bin", 0x0000, 0x1000000, CRC(f2767208) SHA1(7efcfc2456843c20c64185e4aed13067383e3f7a) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndq )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1945s42.bin", 0x0000, 0x1000000, CRC(40f970c4) SHA1(59edf22b239686184a6170766969e0c6ec4f5a0e) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndr )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1945s43.bin", 0x0000, 0x1000000, CRC(8c6dcf0e) SHA1(6503c58453f589077316d8bf3c5d07777fea0fdd) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndu )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1945p12.bin", 0x00000, 0x1000000, CRC(31ea70d9) SHA1(8e165132ecd48b5ea178e9b806944cc2fcd36f28) )
	ad5dnd_others
ROM_END

ROM_START( ad5dndv )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1945s12.bin", 0x00000, 0x1000000, CRC(08235fa0) SHA1(b9482c6e65ad602f01f881156e83a5a475745642) )
	ad5dnd_others
ROM_END

#define ad5dndcl_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95008727.bin", 0x0000, 0x100000, CRC(b4c343a0) SHA1(d67faa1bcac1547cdc68874a411624f5c025cdbd) ) /* R3078 TWIN */

ROM_START( ad5dndcl )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211185.bin", 0x0000, 0x1000000, CRC(c29804d6) SHA1(6586056c1cbbf8089c72a3e3e433beeaa8e9c882) ) // R3078 DOND
	ad5dndcl_others
ROM_END

ROM_START( ad5dndcla )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211194.bin", 0x0000, 0x1000000, CRC(2526cdfc) SHA1(6383ed07096b9c6438d957474a30d4f274e1db0c) )
	ad5dndcl_others
ROM_END

ROM_START( ad5dndclb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211379.bin", 0x0000, 0x1000000, CRC(3b497e7c) SHA1(f8fc3cd4e03e8510146649b22e343284a480d349) )
	ad5dndcl_others
ROM_END

ROM_START( ad5dndclc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212185.bin", 0x0000, 0x1000000, CRC(78a5adeb) SHA1(9b4fe8462a9ba8376a7543a7f7409593861465d0) )
	ad5dndcl_others
ROM_END

ROM_START( ad5dndcld )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212194.bin", 0x0000, 0x1000000, CRC(ebbad166) SHA1(8d1ddad198cd5c5ec40d75ea9ee97792eef5e32e) )
	ad5dndcl_others
ROM_END

ROM_START( ad5dndcle )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212379.bin", 0x0000, 0x1000000, CRC(d90dc869) SHA1(c85e857b965dba5675f8c3db4347b182949ce3a2) )
	ad5dndcl_others
ROM_END

ROM_START( ad5dndclf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211171.bin", 0x0000, 0x1000000, CRC(a80f967a) SHA1(bc8dc5c2d30ec38a9119d577114f5e5813f38749) ) // PR3078 DOND
	ad5dnd_others
ROM_END

ROM_START( ad5dndclg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212171.bin", 0x0000, 0x1000000, CRC(666fe2b4) SHA1(8baf5f8682f3937b4b49f8db93f3a21e8764c990) )
	ad5dnd_others
ROM_END


#define ad5dnddd_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR3402 DOUBLE DELUXE SOUNDS11 */ \
	ROM_LOAD( "95009137.bin", 0x000000, 0x100000, CRC(1d1fe8df) SHA1(d3aebec1a956d563de96069b587ebd2d40123497) ) \
	ROM_LOAD( "95009138.bin", 0x100000, 0x100000, CRC(c16971e0) SHA1(45df220ffe61db6a5319f495ff36efa793d428a4) )

ROM_START( ad5dnddd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211494.bin", 0x0000, 0x1000000, CRC(64424b51) SHA1(604fc08e4754f23f54496693c95c050dccf810b2) ) // 3402 DOUBLE DELUXE
	ad5dnddd_others
ROM_END

ROM_START( ad5dnddda )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212494.bin", 0x0000, 0x1000000, CRC(3d5d3877) SHA1(cee45ac7c11a6fa729233b65ae0dddf12eb18276) ) // 3402 DOUBLE DELUXE
	ad5dnddd_others
ROM_END


#define ad5dndpg_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR3526 DOND PERFG CLUB SOUNDS12 */ \
	ROM_LOAD( "95009043.bin", 0x000000, 0x100000, CRC(8f24fedd) SHA1(4168f057c91968ccdc1d87966cd191a53d4969f5) ) \
	ROM_LOAD( "95009044.bin", 0x100000, 0x100000, CRC(21c8e0b5) SHA1(700c9dad452f86e013329db0182c8494af166378) )
ROM_START( ad5dndpg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211613.bin", 0x0000, 0x1000000, CRC(98495946) SHA1(4c3d5d0731dfdaad37cee317a5d862ff46665ebd) )
	ad5dndpg_others
ROM_END

ROM_START( ad5dndpga )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212613.bin", 0x0000, 0x1000000, CRC(1b0deb8f) SHA1(e27aafa91f5a9ca9064e6e89af5f86c305715efc) )
	ad5dndpg_others
ROM_END

ROM_START( ad5dndpgb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211620.bin", 0x00000, 0x1000000, CRC(4b2fb445) SHA1(b50d57500d58199013f7ee4dee535578b63ddb7e) )
	ad5dndpg_others
ROM_END

ROM_START( ad5dndpgc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212620.bin", 0x00000, 0x1000000, CRC(7f1f31a1) SHA1(9a8a826e73e91decce7b7315816b2c74bb37fcd9) )
	ad5dndpg_others
ROM_END


#define ad5copsr_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )

ROM_START( ad5copsr )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211436.bin", 0x0000, 0x1000000, CRC(9bc4cc3a) SHA1(6726d43281b1c7c9630fa8b5854b4f036e12b19b) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsra )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211451.bin", 0x0000, 0x1000000, CRC(76ebb736) SHA1(10e3e349dde9941d900d900dc98e3f9a922bb116) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211453.bin", 0x0000, 0x1000000, CRC(0fad8171) SHA1(c636774a53bd34e42e70b3ef09feecbb7e868154) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211461.bin", 0x0000, 0x1000000, CRC(03f714e1) SHA1(ed4278471dc415c92a7076039307b87381d90882) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211464.bin", 0x0000, 0x1000000, CRC(3f4a00bd) SHA1(1b48da1e9b6fee7fe1451de5cae8206cc9f8d778) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsre )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211465.bin", 0x0000, 0x1000000, CRC(8b6c393d) SHA1(fb3546f94d8ab387078f934f651f3b8be9c3802e) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211466.bin", 0x0000, 0x1000000, CRC(76d0bc51) SHA1(cbcc85c88d558d4720f99ef43ab9de72ed0a30a0) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211483.bin", 0x0000, 0x1000000, CRC(5c7ea8ba) SHA1(0beb1575d9daa9b46af45fb9164b6508bd411f38) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrh )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211546.bin", 0x0000, 0x1000000, CRC(2c7349a3) SHA1(83dc0595888b4b1afa79deb2713130418c8e9d30) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsri )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211547.bin", 0x0000, 0x1000000, CRC(8384d64f) SHA1(c4127b666250a164ed02c415e7b2003293cd2863) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrj )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211548.bin", 0x0000, 0x1000000, CRC(7b103e0b) SHA1(4dc8f5f197f68cba5104cea792f486b31f41a6ea) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrk )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212436.bin", 0x0000, 0x1000000, CRC(ec543259) SHA1(272396189296f6989c35d3d8a0cec744b14da463) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrl )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212451.bin", 0x0000, 0x1000000, CRC(ac5f5f27) SHA1(3adc50085a1d6fc2f63a63c112e75552d9a1f772) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrm )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212453.bin", 0x0000, 0x1000000, CRC(e282bc72) SHA1(4326c656c779e48e8080ef332af7539a5d889140) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrn )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212461.bin", 0x0000, 0x1000000, CRC(2017b8b7) SHA1(32baabdcf929ae9dc12d98dd91d6733961940d40) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsro )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212464.bin", 0x0000, 0x1000000, CRC(33dce15c) SHA1(0b5ffef40f455a4beebbbd830940170207a73f23) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrp )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212465.bin", 0x0000, 0x1000000, CRC(778fccce) SHA1(b4eeccec2b9255ff2810abb0f4d2cb3430acb177) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrq )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212466.bin", 0x0000, 0x1000000, CRC(7d5c2d9d) SHA1(3d72b4ab137a24abdceec0ed7db8eb3a32ddb468) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrr )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212483.bin", 0x0000, 0x1000000, CRC(156a328a) SHA1(e0e8300a536b18cbf687f2673fbf91771d92ad51) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrs )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212546.bin", 0x0000, 0x1000000, CRC(22144763) SHA1(e376c74992c14f5f7787351fcf8c72b3da2fbae5) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrt )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212547.bin", 0x0000, 0x1000000, CRC(b0c8a8d6) SHA1(d52c15a5f51d64232a40976fb1bd630a53396879) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsru )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212548.bin", 0x0000, 0x1000000, CRC(fcd6f179) SHA1(77214ddfd452311e1631dafad3e7bc682a8ae7bd) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrv )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3206p11.bin", 0x0000, 0x1000000, CRC(8b583dc6) SHA1(69ca467c509319d577b27b2945ab7265cdbe572c) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrw )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3206s11.bin", 0x0000, 0x1000000, CRC(944b7cb9) SHA1(7a7c6e5d14371ef2131a1bf40a5e4972a6518a0a) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrx )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3255p01.bin", 0x0000, 0x1000000, CRC(4855b7e3) SHA1(b69f9782c171a38f1f44f3eeab449d68d37ca996) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsry )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3255s01.bin", 0x0000, 0x1000000, CRC(e971e090) SHA1(df201580ee6189f5fabab0e6f955aac90d82f9a6) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsrz )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211578.bin", 0x0000, 0x1000000, CRC(2d8a6d1b) SHA1(cc28c96d33468209192285e3b0d0690e189e4945) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsr0 )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211621.bin", 0x0000, 0x1000000, CRC(e0469d8d) SHA1(0a519c5721133f07e313d50b2199165b1f516027) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsr1 )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212578.bin", 0x0000, 0x1000000, CRC(15731e4b) SHA1(20ba14f87456a9610eb7f255fa1beae75800f3c6) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsr2 )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212621.bin", 0x0000, 0x1000000, CRC(f19c6714) SHA1(16d9c63f36be622a11036aefd39b55c6fbf162b4) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsr3 )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211622.bin", 0x00000, 0x1000000, CRC(6cd72899) SHA1(2f0d2af88276a8d45aac303a81a124ab7b743b6d) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsr7 )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211606.bin", 0x0000, 0x1000000, CRC(fa465b43) SHA1(8be39ffbee06a5b662a40b447276f95aa3b9bbe2) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsr4 )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211623.bin", 0x00000, 0x1000000, CRC(b65943f4) SHA1(8f281bd1b04709085254e3e352b47f187a7b5b47) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsr5 )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212622.bin", 0x00000, 0x1000000, CRC(055e639d) SHA1(b0a9427f0e8038d26b2a24425644dbda964cfa2c) )
	ad5copsr_others
ROM_END

ROM_START( ad5copsr6 )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212623.bin", 0x00000, 0x1000000, CRC(13b1e404) SHA1(ee170ffbd8fcd552c374e550e58a455da76af5fe) )
	ad5copsr_others
ROM_END




ROM_START( ad5crsc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211581.bin", 0x0000, 0x1000000, CRC(4d451612) SHA1(ec892276b1bfa3d9e9d9d39a722e931c9ab55ec8) ) // PR2476 COPSNROB3
	ad5copsr_others
ROM_END

ROM_START( ad5crsca )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211616.bin", 0x0000, 0x1000000, CRC(181d4298) SHA1(c2b3f9123782d6315bb84be0cd51c3dbbc0da728) ) // PR2476 COPSNROB3
	ad5copsr_others
ROM_END

ROM_START( ad5crscb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212581.bin", 0x0000, 0x1000000, CRC(8996b649) SHA1(e10b82bc7e1fcebe9742755e3a33c9abe75ba1fa) ) // PR2476 COPSNROB3
	ad5copsr_others
ROM_END

ROM_START( ad5crscc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212616.bin", 0x0000, 0x1000000, CRC(d091476a) SHA1(db4f2f1a0bbd22f554265ce5330666f3b1a44862) ) // PR2476 COPSNROB3
	ad5copsr_others
ROM_END

ROM_START( ad5crscd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211582.bin", 0x0000, 0x1000000, CRC(d208a456) SHA1(f53b77299cb85c5b0564b907b2ceb66de8206627) ) // PR2495 COPSNROB
	ad5copsr_others
ROM_END

ROM_START( ad5crsce )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211596.bin", 0x0000, 0x1000000, CRC(9814b1b7) SHA1(e6dc1a516f7f73acb1a78502c4baa6fe9589801d) ) // PR2495 COPSNROB
	ad5copsr_others
ROM_END

ROM_START( ad5crscf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212582.bin", 0x0000, 0x1000000, CRC(599f5d55) SHA1(c4941d754b87ddbd58b19dd4edec2af3a5ddd821) ) // PR2495 COPSNROB
	ad5copsr_others
ROM_END

ROM_START( ad5crscg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212596.bin", 0x0000, 0x1000000, CRC(1152f65c) SHA1(1406667c41e0ed8c07b65df95eb34ca6fe5a2708) ) // PR2495 COPSNROB
	ad5copsr_others
ROM_END

ROM_START( ad5crsch )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212606.bin", 0x0000, 0x1000000, CRC(7cfdeb40) SHA1(76e3583dc60464f6b8d503eb0c32d0bf81bc70d6) ) // PR2628 COPSNROB
	ad5copsr_others
ROM_END





#define ad5gldmn_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95008808.bin", 0x0000, 0x100000, CRC(0982179a) SHA1(ea962cc30d191c8e581bb1672a201d6f56a29b22) ) /* PR3217 GOLD MINE SOUNDS11 */ \
	ROM_LOAD( "95008809.bin", 0x0000, 0x100000, CRC(fcd6f506) SHA1(3d2b8768d9b168f06c01568ed248ee9f687a56b5) )
ROM_START( ad5gldmn )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211462.bin", 0x0000, 0x1000000, CRC(811a32ab) SHA1(d37238fd6b4a5d13594cc80da48a6b45f44e7c4b) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmna )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211498.bin", 0x0000, 0x1000000, CRC(56624b52) SHA1(181c8b1a4cd039ea7332b1eb71158a424848eea5) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmnb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211567.bin", 0x0000, 0x1000000, CRC(fe309726) SHA1(f7ae2a2c48ce06845df6ce2b2f57ef754f7b4816) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmnc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212462.bin", 0x0000, 0x1000000, CRC(0bdc0f2d) SHA1(53e6a207fbdfae024337bb68ff68797d08485737) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmnd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212498.bin", 0x0000, 0x1000000, CRC(e7d9b5ce) SHA1(c59adf6ed279af1ff655467036f83b63c45a3f66) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmne )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212567.bin", 0x0000, 0x1000000, CRC(8f807849) SHA1(e1e9eeb08db67c94828db832ebab5d96db747fb0) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmnf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3217p71.bin", 0x0000, 0x1000000, CRC(ad0004ea) SHA1(7af464e25adcbbc08d00ed375d460408a3cd1a65) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmng )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3217p72.bin", 0x0000, 0x1000000, CRC(0e721af2) SHA1(89bfdff03b6d197f34320a14c2f8f7b19b2a91ab) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmnh )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3217p73.bin", 0x0000, 0x1000000, CRC(ee580fdb) SHA1(0ce8f29f59b7a482eeab00241ca148ae35ea3873) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmni )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3217s71.bin", 0x0000, 0x1000000, CRC(0f09c1da) SHA1(1cbdf80c631ba571a12cb0ea1ceb51b9ccfe63f4) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmnj )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3217s72.bin", 0x0000, 0x1000000, CRC(d588b225) SHA1(d74201f8347accc64fa4d8b07adaafb9a2b305bb) )
	ad5gldmn_others
ROM_END

ROM_START( ad5gldmnk )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3217s73.bin", 0x0000, 0x1000000, CRC(4818d397) SHA1(3a96f90cd424deb1242df1443732d3eae8707ac5) )
	ad5gldmn_others
ROM_END



ROM_START( ad5mowow )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211346.bin", 0x0000, 0x511188, CRC(2dc41c91) SHA1(36fe572860e8bba1b8f9e0245ab6fb93ff75d3ad) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211350.bin", 0x0000, 0x4a746f, CRC(55e3d72e) SHA1(ca793fc2fb603e12feed0869dbb53d6e2a820a76) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211356.bin", 0x0000, 0x4a74b7, CRC(8d5b75ab) SHA1(17740100c5df334bc69a690faea39c3a97afc623) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211508.bin", 0x0000, 0x646fd1, CRC(9e405c5a) SHA1(19598d11756fece575785bb75dd620e333b6877b) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211509.bin", 0x0000, 0x646781, CRC(669da0d0) SHA1(e34bcd6cbb21e07e42e274c30126dd536ead908d) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowe )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212346.bin", 0x0000, 0x511188, CRC(40e92995) SHA1(9911761b89a73156b592567385ef61f609ac40dd) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212350.bin", 0x0000, 0x4a746f, CRC(8dd8926d) SHA1(5beee9809c4c7292c8edb410eb748b43550c19d9) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212356.bin", 0x0000, 0x4a74b7, CRC(15a8bb77) SHA1(4a8a2f50d832ce6d3230e76e4164a0bde041ccd4) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowh )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212508.bin", 0x0000, 0x646fcd, CRC(811c9e4c) SHA1(34b59d319d80f45c238aca9f3ec536047427cfb3) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowi )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212509.bin", 0x0000, 0x646781, CRC(637a930a) SHA1(4ad90e242701b3beef5209e967795d632c5d39a4) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowj )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211172.bin", 0x00000, 0x1000000, CRC(8342c383) SHA1(cc92f7ebab0a55d2a6023ca194e81ef6154563a1) ) // video casino wow
	sc_mowow_others
ROM_END

ROM_START( ad5mowowk )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212172.bin", 0x00000, 0x1000000, CRC(3aed8e3a) SHA1(de5a3fc0d77bf4044a17f17f41ab5c953b500e81) ) // video casino wow
	sc_mowow_others
ROM_END

ROM_START( ad5mowowl )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211351.bin", 0x00000, 0x511189, CRC(8dd8fc7d) SHA1(54a5e2887e0df095d12beb7fbe7e5fe766c116a4) )
	sc_mowow_others
ROM_END

ROM_START( ad5mowowm )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212351.bin", 0x00000, 0x511189, CRC(38c7be05) SHA1(9d0057863fcd02b5d68717b3bbd5762131b15ed7) )
	sc_mowow_others
ROM_END


#define ad5pp_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_START( ad5pp )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211267.bin", 0x0000, 0xb071f3, CRC(51d49618) SHA1(0053ecf1b2d2ad20444f05daf80138d4c8c0c885) )
	PINK_PANTHER_SOUNDS
ROM_END

ROM_START( ad5ppa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211268.bin", 0x0000, 0xb08064, CRC(9d8248f4) SHA1(b20b682fa0e058e39608e4b54ced3eec56c4ec08) )
	PINK_PANTHER_SOUNDS
ROM_END


ROM_START( ad5ppf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212267.bin", 0x0000, 0xb071f3, CRC(fcfaac08) SHA1(08aab0b6525ca3f30c3fe849641f5afe9dfa3db3) )
	PINK_PANTHER_SOUNDS
ROM_END

ROM_START( ad5ppg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212268.bin", 0x0000, 0xb08064, CRC(9882907c) SHA1(5ab2fa1b999f6e5d27207e64a9445476df7582cf) )
	PINK_PANTHER_SOUNDS
ROM_END



ROM_START( ad5ppd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211281.bin", 0x0000, 0x43a386, CRC(a429eb90) SHA1(2374ebff3fc5ab1780a82454bcb4856c97492781) )
	PINKP_SOUNDS
ROM_END

ROM_START( ad5ppe )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211321.bin", 0x0000, 0x43a9d4, CRC(6e1b8538) SHA1(04504ceff81f2350cc090eabfd2f53a70b4d647f) )
	PINKP_SOUNDS
ROM_END

ROM_START( ad5ppi )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212281.bin", 0x0000, 0x43a386, CRC(9b460cee) SHA1(54b561e9afc3cf325c82f9c105698d026daa769c) )
	PINKP_SOUNDS
ROM_END

ROM_START( ad5ppj )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212321.bin", 0x0000, 0x43a9d4, CRC(7bdfaeea) SHA1(652cb88ba6f2ecc1bcc98a2581aa3e4c65ba757b) )
	PINKP_SOUNDS
ROM_END

ROM_START( ad5ppb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211279.bin", 0x0000, 0xc0da36, CRC(dfa112e8) SHA1(1097e0bf7a49b75ebe04a92d2c3794993ec73c41) )
	SD_PANTHER_SNDS
ROM_END

ROM_START( ad5ppc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211280.bin", 0x0000, 0xc0e902, CRC(7c52816b) SHA1(1a5552893dcd91a1928d0526ce5ecaaac0f7f29b) )
	SD_PANTHER_SNDS
ROM_END

ROM_START( ad5pph )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212280.bin", 0x0000, 0xc0e902, CRC(f10abe2b) SHA1(9af09874f16e957906bef69d5377c0c744d337de) )
	SD_PANTHER_SNDS
ROM_END


#define ad5rsclb_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR1826 RANDOM SPINNER SOUNDS11 */ \
	ROM_LOAD( "95008546.bin", 0x0000, 0x100000, CRC(3d97132f) SHA1(b611617b21b6b7afafa300604ec09e0a84bde8ba) )

ROM_START( ad5rsclb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211057.bin", 0x0000, 0x1000000, CRC(6bd542ce) SHA1(635a829461555f86da7e5d19e8f4e198d63f5400) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclba )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211096.bin", 0x0000, 0x1000000, CRC(e34160e1) SHA1(92308c870c7782a8025ccbe97e7c17773dcbd3f4) )
	ad5rsclb_others
ROM_END
ROM_START( ad5rsclbb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211097.bin", 0x0000, 0x1000000, CRC(b9c0409b) SHA1(8cef9887f2b89cca2e8a28187db2d3a6828a285e) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclbc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211169.bin", 0x0000, 0x1000000, CRC(45b44bdb) SHA1(2b5a01c9beaa7fa50688ddd50b9f8e5eb135f3fc) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclbd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211170.bin", 0x0000, 0x1000000, CRC(d9e85ee5) SHA1(5da29c3203a9a8ad91c556eb5fb085ee38e1b920) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclbe )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211187.bin", 0x0000, 0x1000000, CRC(2f9c7191) SHA1(32c815cab7475fcfe50cba94a25740c37ae8d04f) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclbf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212057.bin", 0x0000, 0x1000000, CRC(85555f52) SHA1(52464e934b28f637ea8f2577ae270ddd0353bf7c) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclbg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212096.bin", 0x0000, 0x1000000, CRC(8df5a794) SHA1(ca005e560a1772da525435728ace0aff53e95640) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclbh )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212097.bin", 0x0000, 0x1000000, CRC(9e774d32) SHA1(1d8d97539953d5d33703b39eba39a62dfbf5849a) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclbi )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212169.bin", 0x0000, 0x1000000, CRC(1f149fc4) SHA1(808ccaa893f9be2680f8b33e882ab0f3e8b36488) )
	ad5rsclb_others
ROM_END

ROM_START( ad5rsclbj )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212170.bin", 0x0000, 0x1000000, CRC(fedcf3a1) SHA1(c46fd797d81edca5a751e89045c18d6787a43500) )
	ad5rsclb_others
ROM_END


#define ad5monop_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_START( ad5monop )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211239.bin", 0x0000, 0x6a78e0, CRC(024795a6) SHA1(aba82d4a61efaa4c48750fc62e6a369aa2a8df9d) )
	ad5monop_others
ROM_END

ROM_START( ad5monopa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211250.bin", 0x0000, 0x6a791a, CRC(21909cb4) SHA1(28c028469e899659cbcca007f59ee3509d8b0f7a) )
	ad5monop_others
ROM_END

ROM_START( ad5monopb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211251.bin", 0x0000, 0x6a7a5e, CRC(ebbf403c) SHA1(ea993d78c41a71677ec3eacb6d11260037aeaac8) )
	ad5monop_others
ROM_END

ROM_START( ad5monopc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211260.bin", 0x0000, 0x6a839a, CRC(fa8e2b2a) SHA1(1749fbd7515574b77b083c5dc81c2071a089c52d) )
	ad5monop_others
ROM_END

ROM_START( ad5monopd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211262.bin", 0x0000, 0x6a6792, CRC(994ac3ab) SHA1(1b56fa251d32f20210ec695a789a4bd8c7bfe8ed) )
	ad5monop_others
ROM_END

ROM_START( ad5monope )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211263.bin", 0x0000, 0x6a664e, CRC(dc1c15f5) SHA1(a844b41e6c5a96b3165dfc000e525c35a34455ab) )
	ad5monop_others
ROM_END

ROM_START( ad5monopf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212239.bin", 0x0000, 0x6a78e0, CRC(838be734) SHA1(2a44c212cd6c2ba66661aa635ddb726fa9636d3c) )
	ad5monop_others
ROM_END

ROM_START( ad5monopg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212250.bin", 0x0000, 0x6a791a, CRC(a5ceface) SHA1(7fc03517b81e999e26c7ac55ffa6a4afa86e5717) )
	ad5monop_others
ROM_END

ROM_START( ad5monoph )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212251.bin", 0x0000, 0x6a7a5e, CRC(abc6ee9c) SHA1(480db09f6a06d542347cbae6aa7192c5bfccbd48) )
	ad5monop_others
ROM_END

ROM_START( ad5monopi )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212260.bin", 0x0000, 0x6a839a, CRC(c041863e) SHA1(afec88e97b65a3ed1d57085407abd4167007ed72) )
	ad5monop_others
ROM_END

ROM_START( ad5monopj )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212262.bin", 0x0000, 0x6a6792, CRC(b8a7d34c) SHA1(e36964250a6e247030546ca4f181c9a70a89f61d) )
	ad5monop_others
ROM_END

ROM_START( ad5monopk )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212263.bin", 0x0000, 0x6a664e, CRC(3bde8adb) SHA1(0ac2d4619cf2ca637fbdea867662b38de2661e1a) )
	ad5monop_others
ROM_END


#define ad5rspin_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR1826 RANDOM SPINNER SOUNDS12 */\
	ROM_LOAD( "95008549.bin", 0x0000, 0x100000, CRC(dd7399cf) SHA1(1d4f475dde67048c6a425623a696a06e49231308) )
ROM_START( ad5rspin )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211388.bin", 0x0000, 0x1000000, CRC(56fca244) SHA1(56890695c230a62b50c9dc2ecb4e8d6c123ed8dc) )
	ad5rspin_others
ROM_END



ROM_START( ad5rspinb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212388.bin", 0x0000, 0x1000000, CRC(9ed7ae4f) SHA1(ff55640fd2538e9ed9b17b4387d1430401b22e69) )
	ad5rspin_others
ROM_END

ROM_START( ad5rspinc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212612.bin", 0x0000, 0x1000000, CRC(dec693eb) SHA1(69256d4cc47715ea826eb0ca838c09a9d9e4d1e2) ) // hot spinner?
	ad5rspin_others
ROM_END




ROM_START( ad5btc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1758p53.bin", 0x0000, 0x1000000, CRC(0323a676) SHA1(26f5d1c6bc4cd2d8405a95714f0dee6c26c21539) )
	PR1758_BULLSEYE_TRIPLE_SOUNDS11
ROM_END

ROM_START( ad5btca )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1758p82.bin", 0x0000, 0x1000000, CRC(5f5e5869) SHA1(37b471340c42c1776e8e6312f3b8db6eab9441e5) )
	PR1758_BULLSEYE_TRIPLE_SOUNDS11
ROM_END

ROM_START( ad5btcb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1758s82.bin", 0x0000, 0x1000000, CRC(55761c4a) SHA1(56531c4df469e5dc4f7df7dcc49c97656ed1183c) )
	PR1758_BULLSEYE_TRIPLE_SOUNDS11
ROM_END


#define ad5rsnw_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )
ROM_START( ad5rsnw )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211205.bin", 0x0000, 0x6a39e0, CRC(bb426781) SHA1(b1e21abd85589a7ca0e77b123f18b61c16e47971) )
	ad5rsnw_others
ROM_END

ROM_START( ad5rsnwa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211241.bin", 0x0000, 0x6c2cea, CRC(ec610e0d) SHA1(946a0c400745fae967ad4f6f5ddb589a93de13f6) )
	ad5rsnw_others
ROM_END

ROM_START( ad5rsnwb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212205.bin", 0x0000, 0x6a39e0, CRC(20c43fd3) SHA1(38b3489f3e966c94ef87cc8566c8df02b7b9aee8) )
	ad5rsnw_others
ROM_END

ROM_START( ad5rsnwc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212241.bin", 0x0000, 0x6c2cea, CRC(2b433106) SHA1(8e430097ec993549684f34dc9bac64ff88346b24) )
	ad5rsnw_others
ROM_END


ROM_START( ad5sslam )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211387.bin", 0x0000, 0x1000000, CRC(315c9b47) SHA1(75659d9888fdbc83cd2559e88d4c47c90309956f) )
	sc_sslam_others
ROM_END

ROM_START( ad5sslama )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3084p12.bin", 0x0000, 0x1000000, CRC(f08e517d) SHA1(dc6f622d025fabad8302735188757a6f645ad2e3) )
	sc_sslam_others
ROM_END

ROM_START( ad5sslamb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3084s11.bin", 0x0000, 0x1000000, CRC(d51a0816) SHA1(6ff1b486f29395d7f7fbe726c6c8bc185f145f93) )
	sc_sslam_others
ROM_END

ROM_START( ad5sslamc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3084s12.bin", 0x0000, 0x1000000, CRC(7d33e52d) SHA1(6591834c60103f71211449355c592473180c33d9) )
	sc_sslam_others
ROM_END

ROM_START( ad5sslamd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211386.bin", 0x00000, 0x1000000, CRC(05d2c75b) SHA1(7c82d48e74997b4fe2c12e56a96a7c7ca57628cb) )
	sc_sslam_others
ROM_END

ROM_START( ad5sslame )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212386.bin", 0x00000, 0x1000000, CRC(4b47f4fc) SHA1(4a72df0c60968bdedac967f1989e3a4bcd7b974d) )
	sc_sslam_others
ROM_END

ROM_START( ad5sslamf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212387.bin", 0x0000, 0x1000000, CRC(7affbe1b) SHA1(9fced7102afe267f426ada6e7840b877b185ca57) )
	sc_sslam_others
ROM_END


#define ad5mr2r_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )

ROM_START( ad5mr2r )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211501.bin", 0x0000, 0x6bb25b, CRC(94f73ba5) SHA1(1979b6cfd7968ad4d0c117742fafbb8b55a4e89e) )
	ad5mr2r_others
ROM_END

ROM_START( ad5mr2ra )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211506.bin", 0x0000, 0x94ee0b, CRC(dee9ea83) SHA1(f66e5b63e10e0759ebb33a84d21d24d0f9452293) )
	ad5mr2r_others
ROM_END

ROM_START( ad5mr2rb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211510.bin", 0x0000, 0x94ee43, CRC(3f0124ff) SHA1(f44d4688472d8c46ce449033d7e2f1a57ea05574) )
	ad5mr2r_others
ROM_END

ROM_START( ad5mr2rc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211511.bin", 0x0000, 0x94ef97, CRC(051b150b) SHA1(6b1371d7157b69b7fdffaba6e9fa6c41912179b3) )
	ad5mr2r_others
ROM_END

ROM_START( ad5mr2rd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212506.bin", 0x0000, 0x94ee0b, CRC(aef402bb) SHA1(4d0d58339a9c51ab5a33eebf9443ac43efced01d) )
	ad5mr2r_others
ROM_END

ROM_START( ad5mr2re )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212510.bin", 0x0000, 0x94ee43, CRC(cec862b6) SHA1(b9b433218cef13d63e672f9e90649f44cf6aca72) )
	ad5mr2r_others
ROM_END

ROM_START( ad5mr2rf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212511.bin", 0x0000, 0x94ef97, CRC(5a84f20f) SHA1(62d2ea8b462b53acf9b47cf3589cbdd455b5a5ad) )
	ad5mr2r_others
ROM_END

ROM_START( ad5mr2rg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211617.bin", 0x00000, 0x1000000, CRC(89d687e8) SHA1(7086f43fdaa417e9bb54feb859af22f501c6ca52) )
	ad5mr2r_others
ROM_END

ROM_START( ad5mr2rh )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212617.bin", 0x00000, 0x1000000, CRC(2191cc09) SHA1(593b6b16380821553adb377f3f4b5af28e73b2c0) )
	ad5mr2r_others
ROM_END


// might be wrong, our sets have SOUNDS12 in the header
#define ad5rwclb_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR1756 RANDOM WINNER SOUNDS11 */ \
	ROM_LOAD( "95008569.bin", 0x0000, 0x080000, CRC(1a966dd9) SHA1(1314b7ee5b6e22d504e12e9eba3b2b88f6f5d64c) )

ROM_START( ad5rwclb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211073.bin", 0x0000, 0x1000000, CRC(bd3e0d73) SHA1(063058051dd5d774e2755f3fd0fb3f83277221db) )
	ad5rwclb_others
ROM_END

ROM_START( ad5rwclba )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211074.bin", 0x0000, 0x1000000, CRC(917dbae6) SHA1(87c664beba60054c0349861f4bd19393cf993bf1) )
	ad5rwclb_others
ROM_END

ROM_START( ad5rwclbb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212073.bin", 0x0000, 0x1000000, CRC(64d98913) SHA1(b207d411a007079ac2a46df3d801f933635fc55f) )
	ad5rwclb_others
ROM_END

ROM_START( ad5rwclbc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212074.bin", 0x0000, 0x1000000, CRC(972b5457) SHA1(83a0cbc3875027e91224cff6e60b9da696ff9c8e) )
	ad5rwclb_others
ROM_END

ROM_START( ad5rwclbd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1757p11.bin", 0x0000, 0x1000000, CRC(34de65e7) SHA1(c5d449f4eeb596e9d8874c1a80dd77dccc75d1b8) )
	ad5rwclb_others
ROM_END

ROM_START( ad5rwclbe )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1757s11.bin", 0x0000, 0x1000000, CRC(36f2efbc) SHA1(9431a1ae738f24370a785b69c50ce34dd260dc8c) )
	ad5rwclb_others
ROM_END



#define ad5gldwn_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95008945.bin", 0x0000, 0x0ff168, CRC(a467d802) SHA1(4120b3a21598f1c3642f0ce05a3c35c15bf6d811) ) /* GOLDEN WINNER SOUNDS */
ROM_START( ad5gldwn )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211347.bin", 0x0000, 0x1000000, CRC(9db14fec) SHA1(ade5ae1764eb1889624b11ccc5a1faea093fc3ef) )
	ad5gldwn_others
ROM_END

ROM_START( ad5gldwna )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212347.bin", 0x0000, 0x1000000, CRC(a951e5b9) SHA1(adb004cdfc76a8b753a89018f45cee0ab8551a2f) )
	ad5gldwn_others
ROM_END



#define ad5rapid_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR1712 RAPID PAY SOUNDS11 */ \
	ROM_LOAD( "95008570.bin", 0x0000, 0x080000, CRC(edd2bff6) SHA1(213b16eb091f96633dec5ec8df5084062dd68ba0) )


ROM_START( ad5rapid )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211120.bin", 0x0000, 0x1000000, CRC(7de15e7d) SHA1(02ee9bf3d670f9ec7f4428c5b9c1d40a1e68df17) )
	ad5rapid_others
ROM_END

ROM_START( ad5rapida )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212120.bin", 0x0000, 0x1000000, CRC(16f91987) SHA1(1ad0b3b3c58f0566fc1a23904c7bc0e8693d99d4) )
	ad5rapid_others
ROM_END

#define ad5jckmo_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )

ROM_START( ad5jckmo )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211254.bin", 0x0000, 0x432c2c, CRC(66a52091) SHA1(03fd4c1ba2ea7a2ce09dd6200985a2d882e3160e) )
	ad5jckmo_others
ROM_END

ROM_START( ad5jckmoa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211261.bin", 0x0000, 0x4279d8, CRC(8ee6e967) SHA1(f5c37717cf7905a479a80604c622261669f504a1) )
	ad5jckmo_others
ROM_END

ROM_START( ad5jckmob )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211266.bin", 0x0000, 0x427514, CRC(6fad3371) SHA1(5a9d3da46980a24907a0fa131f2f77a65b72cde5) )
	ad5jckmo_others
ROM_END

ROM_START( ad5jckmoc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211294.bin", 0x0000, 0x4284c0, CRC(8fed15d4) SHA1(cc072ee7736f31fb10ad6d293b4ab59cc1a00542) )
	ad5jckmo_others
ROM_END

ROM_START( ad5jckmod )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212254.bin", 0x0000, 0x432c2c, CRC(f9eeb730) SHA1(602fccdd05c621d3707e42f9571bb515af1c7f9b) )
	ad5jckmo_others
ROM_END

ROM_START( ad5jckmoe )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212261.bin", 0x0000, 0x4279d8, CRC(3641bfe6) SHA1(5a34ada0e3c70c0d05d552be2f5fee50055b1dd4) )
	ad5jckmo_others
ROM_END


#define ad5ppbtb_others \
	ROM_REGION( 0x5000, "pics", 0 ) \
	ROM_LOAD( "95890416.bin", 0x0000, 0x5000, CRC(2becd79f) SHA1(e87c668c651adf55c234aaa2f9d8a0ed66792356) ) \
	ROM_LOAD( "95890417.bin", 0x0000, 0x5000, CRC(373a2723) SHA1(61795c8e22e97903f0a4388b3aff6db3ca3af981) ) \
	ROM_LOAD( "95890418.bin", 0x0000, 0x5000, CRC(f46005b3) SHA1(58b6369c0a9414f8ccf16ccbe05adfa47c188e1b) ) \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 )

ROM_START( ad5ppbtb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211324.bin", 0x0000, 0x565596, CRC(0d58ec3b) SHA1(3cbbd08fc182ec425e51f73a1434591a56ce514b) )
	ad5ppbtb_others
ROM_END

ROM_START( ad5ppbtba )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211327.bin", 0x0000, 0x5651c6, CRC(535d29fd) SHA1(a9f1822a8b3ac5eb501dbe957c354f5d29361d4b) )
	ad5ppbtb_others
ROM_END

ROM_START( ad5ppbtbb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212324.bin", 0x0000, 0x565426, CRC(3891535d) SHA1(54b1ae18da66a4c91f3c40f9819dc6d93ddd3177) )
	ad5ppbtb_others
ROM_END

ROM_START( ad5ppbtbc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212327.bin", 0x0000, 0x5651c6, CRC(3091ec62) SHA1(a14fe3bafc3b3a716209f18860f76e2d2d0a3a0e) )
	ad5ppbtb_others
ROM_END





#define ad5vlv_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR3507 VIVA LAS VEGAS SOUNDS11 */ \
	ROM_LOAD( "95009055.bin", 0x000000, 0x100000, CRC(6fa39bdb) SHA1(a78b02d4b7d38da529db590b32d5d22ed7b46870) ) \
	ROM_LOAD( "95009056.bin", 0x100000, 0x100000, CRC(d530f185) SHA1(a3a8ac81ce7d9a8e8e005cfaab3f9ae82804cbd9) )
ROM_START( ad5vlv )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211605.bin", 0x0000, 0x1000000, CRC(b8fab0a2) SHA1(68ad9810549d9d01934182cb578e17af05ffa3c2) )
	ad5vlv_others
ROM_END



ROM_START( ad5vlvb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212605.bin", 0x0000, 0x1000000, CRC(e5deb9fd) SHA1(9490d506080e729a43daf73710d4077c5d33d47b) )
	ad5vlv_others
ROM_END

ROM_START( ad5vlvc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211630.bin", 0x0000, 0x1000000, CRC(2b246fc9) SHA1(ce1140c4f36a362f8c864ebc6aa3af00a173d913) )
	ad5vlv_others
ROM_END

ROM_START( ad5vlvd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212630.bin", 0x0000, 0x1000000, CRC(b50bed01) SHA1(16a1e861baee8a54b1f7227744401351ed3355f7) )
	ad5vlv_others
ROM_END

ROM_START( ad5vlve )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211615.bin", 0x00000, 0x1000000, CRC(d8308232) SHA1(11ddcb313b299a4704dbd24dd78c7303bf17a48a) )
	ad5vlv_others
ROM_END

ROM_START( ad5vlvf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212615.bin", 0x00000, 0x1000000, CRC(b4299ca1) SHA1(d97e7f9d8a3729702d7f5076c10a4afc29333886) )
	ad5vlv_others
ROM_END



#define ad5rroul_others \
	ROM_REGION( 0x400000, "pics", ROMREGION_ERASEFF ) \
	ROM_LOAD( "95890489.bin", 0x0000, 0x5000, CRC(8f41d119) SHA1(83f276c02a0fe404c397cf708552674fb3bb15c4) ) \
	ROM_LOAD( "95890490.bin", 0x0000, 0x5000, CRC(939721a5) SHA1(be0a9c2af853ab8c28e63aa6dcff350d4e69e437) ) \
	ROM_LOAD( "95890491.bin", 0x0000, 0x5000, CRC(50cd0335) SHA1(db2bcf0e2be67eb8c657ab3536a5056bb66649b8) ) \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95008986.bin", 0x0000, 0x0c18ab, CRC(f69f04b5) SHA1(b1095592120c3f4f3bac8963362611def14f7233) ) /* REEL ROULETTE SOUNDS */ \
	ROM_LOAD( "95008996.bin", 0x0000, 0x0ce354, CRC(a462a168) SHA1(6598605123407bb2206928e82a903f9a41ba524c) ) /* REEL ROULETTE SOUNDS (different) */


ROM_START( ad5rroul )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211342.bin", 0x0000, 0xfc273a, CRC(50b63c2f) SHA1(2670f41b05cabf40d1ce1fb03d1c936207a50afa) )
	ad5rroul_others
ROM_END

ROM_START( ad5rroula )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212342.bin", 0x0000, 0xfc273a, CRC(81491291) SHA1(a32687e3e4d535540fcc78cea5f432b5bd4e01b9) )
	ad5rroul_others
ROM_END

ROM_START( ad5rroulb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211345.bin", 0x0000, 0x643110, CRC(c3838739) SHA1(1260e2348bc41a1d364b3bbd3914724ea2c6153a) )
	ad5rroul_others
ROM_END

ROM_START( ad5rroulc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212345.bin", 0x0000, 0x643110, CRC(216efed6) SHA1(8c5b66bac3bde410577d2c8b6f8d352404a36695) )
	ad5rroul_others
ROM_END


#define ad5mcob_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* MMONTE SOUNDS */ \
	ROM_LOAD( "95009011.bin", 0x0000, 0x0ff73b, CRC(9f6e0643) SHA1(d0f76b8a45aef2dd42939f1fca7b010637aaabe1) )

ROM_START( ad5mcob )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211513.bin", 0x0000, 0x9ad06f, CRC(195c3690) SHA1(0fe72c20fb80c8c1430ddb6aac056be77af9ec24) )
	ad5mcob_others
ROM_END

ROM_START( ad5mcoba )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211516.bin", 0x0000, 0x9af0eb, CRC(ef35489e) SHA1(c5d71130ddd8bdb86b45b075bd929ec2eaebeded) )
	ad5mcob_others
ROM_END

ROM_START( ad5mcobb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212513.bin", 0x0000, 0x9ad06f, CRC(0f25723f) SHA1(10cb91accac8a7e5da55e4511e6cffe4164f5314) )
	ad5mcob_others
ROM_END

ROM_START( ad5mcobc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212516.bin", 0x0000, 0x9af0eb, CRC(0b6faf76) SHA1(e9a1158911b8a474acf3b0abe4856aaa406800ca) )
	ad5mcob_others
ROM_END




#define ad5pking_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR1625 POKER KING SOUNDS11 */ \
	ROM_LOAD( "95008495.bin", 0x0000, 0x080000, CRC(dac8c4a8) SHA1(0192e1d2b9558a789753a5e58d97503cc09dfa27) )

ROM_START( ad5pking )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211031.bin", 0x0000, 0x1000000, CRC(ec68ef4b) SHA1(2f00afa1ac3b6776f9e8cb44e861d572025c72b2) )
	ad5pking_others
ROM_END

ROM_START( ad5pkinga )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212031.bin", 0x0000, 0x1000000, CRC(08811e4d) SHA1(983c39b09ad3d33546a9873e1d77dd6be50b9b2e) )
	ad5pking_others
ROM_END



#define ad5vpa_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR3073 POKER ACE SOUNDS11 */ \
	ROM_LOAD( "95008722.bin", 0x0000, 0x080000, CRC(0643d71d) SHA1(027e096a82d5c13a98ef773548c8f5e16257e863) )

ROM_START( ad5vpa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3073p71.bin", 0x0000, 0x1000000, CRC(75320ec0) SHA1(833a44c62a132d06de63995780769966efeff5c3) )
	ad5vpa_others
ROM_END

ROM_START( ad5vpaa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3073p72.bin", 0x0000, 0x1000000, CRC(cdd49281) SHA1(1771504c3b335744a195c93858b1418099599e19) )
	ad5vpa_others
ROM_END

ROM_START( ad5vpab )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3073s71.bin", 0x0000, 0x1000000, CRC(0adee992) SHA1(fba11f05c762bc456adbcd3d682fceb3b19a851b) )
	ad5vpa_others
ROM_END

ROM_START( ad5vpac )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3073s72.bin", 0x0000, 0x1000000, CRC(b048298e) SHA1(0f55563b80d00c743f75d71500e3493087abcfc0) )
	ad5vpa_others
ROM_END





#define ad5tornc_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR1627 TORNADO CLUB SOUNDS11 */ \
	ROM_LOAD( "95008564.bin", 0x0000, 0x100000, CRC(55d0d855) SHA1(343cfe935c34c8f95a638eccb1397238fa7698e4) )

ROM_START( ad5tornc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211114.bin", 0x0000, 0x1000000, CRC(f218d87b) SHA1(230038ee52d47dde9669a6fd3a363264f222f1f8) )
	ad5tornc_others
ROM_END

ROM_START( ad5tornca )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211115.bin", 0x0000, 0x1000000, CRC(867ad45b) SHA1(90b9c256ffb99ecae912771aa8eb1605651f2a68) )
	ad5tornc_others
ROM_END

ROM_START( ad5torncb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212114.bin", 0x0000, 0x1000000, CRC(5f80e76b) SHA1(a8aeef603a815b34ba61963532b4c6699cb3c27d) )
	ad5tornc_others
ROM_END

ROM_START( ad5torncc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212115.bin", 0x0000, 0x1000000, CRC(2be2eb4b) SHA1(c70e27938e60c701cb41060536cc68c69a2df50b) )
	ad5tornc_others
ROM_END

ROM_START( ad5torncd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1627p12.bin", 0x0000, 0x1000000, CRC(71b881b6) SHA1(a18455c2ce769d9ea135f887c83594be319ac8ce) )
	ad5tornc_others
ROM_END

ROM_START( ad5tornce )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p1627s12.bin", 0x0000, 0x1000000, CRC(0cd2ca21) SHA1(fa2dfdd73540d3446ac5c33f72e93d1c4b520d73) )
	ad5tornc_others
ROM_END












#define ad5rcash_others \
	ROM_REGION( 0x400000, "pics", ROMREGION_ERASEFF ) \
	ROM_LOAD( "95890390.bin", 0x0000, 0x5000, CRC(f973db95) SHA1(f91b206e1a1fb5125654ad081d666ae2bfd2036f) ) \
	ROM_LOAD( "95890391.bin", 0x0000, 0x5000, CRC(e5a52b29) SHA1(ac408585a14060b81651e14f0cae6a77edee1985) ) \
	ROM_LOAD( "95890392.bin", 0x0000, 0x5000, CRC(26ff09b9) SHA1(236d0808126d517e4a1c86bebad3c877252de4d8) ) \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* REEL CASH SOUNDS */ \
	ROM_LOAD( "95008946.bin", 0x0000, 0x0f7b10, CRC(9a70fd7b) SHA1(692908750bea92af5f06d7151b15aec294aaf686) )

ROM_START( ad5rcash )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211273.bin", 0x0000, 0x80ceaa, CRC(2577ad05) SHA1(9f9d003331821a79d3bb0901dd91af8c19bbbc49) )
	ad5rcash_others
ROM_END

ROM_START( ad5rcasha )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212273.bin", 0x0000, 0x80ceaa, CRC(7459b4a7) SHA1(d78fe6ffddd97a7ba81a053712b0d5be9cefe33a) )
	ad5rcash_others
ROM_END



#define ad5mww_others \
	ROM_REGION( 0x400000, "pics", ROMREGION_ERASEFF )
	ROM_START( ad5mww )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211269.bin", 0x0000, 0x7a0866, CRC(0fae0667) SHA1(5356149061413c71b662371aa08f616a28ddbafb) )
	ad5mww_others
ROM_END

	ROM_START( ad5mwwa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211270.bin", 0x0000, 0x7a097a, CRC(13cb2a2a) SHA1(f00bf3647abf0593eb0708aee103dfd42e623bef) )
	ad5mww_others
ROM_END


#define ad5eyes_others \
	ROM_REGION( 0x5000, "pics", 0 ) \
	ROM_LOAD( "95890303.bin", 0x0000, 0x5000, CRC(dd0d9672) SHA1(5cf162e77b2b395138e02aca3ac9327ffb08e3e4) ) \
	ROM_LOAD( "95890304.bin", 0x0000, 0x5000, CRC(c1db66ce) SHA1(e45846411d347cad74135a1392b7ce3df2407b07) ) \
	ROM_LOAD( "95890305.bin", 0x0000, 0x5000, CRC(0281445e) SHA1(b93460a79c906fb0f33bd898054f4c7aaea8fe12) ) \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) \
	ROM_LOAD( "95008933.bin", 0x0000, 0x03fc55, CRC(5f01c246) SHA1(b5e2b79f780d48935b8eb158b3292ab26340ba7f) ) /* EDWNS16 SOUNDS */ \
	ROM_LOAD( "95008959.bin", 0x0000, 0x07daf0, CRC(61e7fb11) SHA1(039efe731866314770800224e2b8536822252193) ) /* EDMULTI SOUNDS */
ROM_START( ad5eyes )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211248.bin", 0x0000, 0x4d88b4, CRC(a2b799c9) SHA1(9088de779c31d33d9f1eb83e46ec28c30181a0fc) )
	ad5eyes_others
ROM_END

ROM_START( ad5eyesa )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211256.bin", 0x0000, 0x4d8648, CRC(de99153a) SHA1(42e00c847effc60130451e19328cd36cfba1cc76) )
	ad5eyes_others
ROM_END

ROM_START( ad5eyesb )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211264.bin", 0x0000, 0x4d546c, CRC(73602540) SHA1(2418628a565504281d7a50879fc8ed6bcec73f8b) )
	ad5eyes_others
ROM_END

ROM_START( ad5eyesc )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212246.bin", 0x0000, 0x4d858a, CRC(028d59c7) SHA1(75b0643ec51dc02c678cf3aa034dd1be88fea67f) )
	ad5eyes_others
ROM_END

ROM_START( ad5eyesd )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212248.bin", 0x0000, 0x4d88b4, CRC(25c68cad) SHA1(f80b0ee24187e8c55c4aa66687ba378f3f7d24ea) )
	ad5eyes_others
ROM_END

ROM_START( ad5eyese )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212256.bin", 0x0000, 0x4d8648, CRC(94150812) SHA1(b3839e90e99bfa7ed4e3a1401db99e42d4f58642) )
	ad5eyes_others
ROM_END

ROM_START( ad5eyesf )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39212264.bin", 0x0000, 0x4d546c, CRC(a6ec1842) SHA1(e4ce5d53d140a00e2d620eece6d182b201662b61) )
	ad5eyes_others
ROM_END

ROM_START( ad5eyesg )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "39211246.bin", 0x0000, 0x4d858a, CRC(edabdb3d) SHA1(cdda311e94cdb22432a4b37edb411717a391720e) )
	ad5eyes_others
ROM_END




#define ad5rsrm_others \
	ROM_REGION( 0x400000, "ymz", ROMREGION_ERASE00 ) /* PR3302 RONNIE ROCKET SOUNDS11 */ \
	ROM_LOAD( "95008828.bin", 0x0000, 0x100000, CRC(35a1b9aa) SHA1(a6d03645994b36a9e506b950f752a6c1c899e110) ) \
	ROM_LOAD( "95008829.bin", 0x0000, 0x100000, CRC(3745f572) SHA1(ffc9e67ed92552e7b2790433ea4838df10712f4d) )

ROM_START( ad5rsrm )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3302p71.bin", 0x0000, 0x1000000, CRC(09aa5633) SHA1(1733dc5430f1277ff32c6b8abcbee7a274b1c9de) )
	ad5rsrm_others
ROM_END

ROM_START( ad5rsrma )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3302s71.bin", 0x0000, 0x1000000, CRC(9f4c34ad) SHA1(81493e5f957d0e705d5fe9111f46e119b871b6b0) )
	ad5rsrm_others
ROM_END


ROM_START( ad5rsrr )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3302p12.bin", 0x0000, 0x1000000, CRC(92294235) SHA1(1ff971f24a1de18d29e009800e6c7aa2830962f5) )
	ad5rsrm_others
ROM_END

ROM_START( ad5rsrra )
	ROM_REGION( 0x1000000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "p3302s12.bin", 0x0000, 0x1000000, CRC(ca95d6e0) SHA1(4fdb2e136251ffc8aa475b6c1ccbc0d6a8afe0d2) )
	ad5rsrm_others
ROM_END





































// PR3255 CASINO COPS TRIPLE         CASINO COPS ARCADE  PR3255 COPS & ROBBERS SOUNDS11
GAME( 200?, ad5crcpt    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers Community Party (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5crcpta   ,ad5crcpt,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers Community Party (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )


// PROJECT NUMBER PR2334 BULLSEYE_PFP         ITSBULLSEYE SOUNDS         BULLSEYE_PFP  S.SITE
GAME( 200?, ad5bpfpm    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Bullseye Pounds For Points (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5bpfpma   ,ad5bpfpm,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Bullseye Pounds For Points (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5bpfpmb   ,ad5bpfpm,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Bullseye Pounds For Points (Mazooma) (Adder 5) (set 3)", GAME_IS_SKELETON )
// PROJECT NUMBER PR2334 BULLSEYE_PFP         BULLSEYEPFP SOUNDS         BULLSEYE_PFP  S.SITE
GAME( 200?, ad5bpfpmc   ,ad5bpfpm,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Bullseye Pounds For Points (Mazooma) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5bpfpmd   ,ad5bpfpm,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Bullseye Pounds For Points (Mazooma) (Adder 5) (set 5)", GAME_IS_SKELETON )


// PR1601 AWP CRAZY MONEY         CRAZY MONEY S.SITE  PR1601 CRAZY MONEY SOUNDS11
GAME( 200?, ad5cmons    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Crazy Money (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5cmonsa   ,ad5cmons,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Crazy Money (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR3314 AWP DEAL OR NO DEAL PLATINUM SCORP5         PR3314 DOND PLATINUM SOUNDS11
GAME( 200?, ad5dndpl    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Platinum (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5dndpla   ,ad5dndpl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Platinum (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5dndplb   ,ad5dndpl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Platinum (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5dndplc   ,ad5dndpl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Platinum (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )

// PROJECT NUMBER PR3401 AWP HI ROLLER SCORP5         PR3401 HI ROLLER SOUNDS11         HI ROLLER S.SITE
GAME( 200?, ad5hir      ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Hi Roller (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5hira     ,ad5hir,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Hi Roller (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5hirb     ,ad5hir,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Hi Roller (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5hirc     ,ad5hir,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Hi Roller (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )

// PROJECT NUMBER PR1755 HI ROLLER         PR1755 HI ROLLER SOUNDS12
GAME( 200?, ad5hircl    ,ad5hir,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Hi Roller Club (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5hircla   ,ad5hir,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Hi Roller Club (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5hirclb   ,ad5hir,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Hi Roller Club (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )

// PROJECT NUMBER PR1965 CASINO DOND TRIPLE         CASINO DOND ARCADE  PR1965 CASINO DOND R SOUNDS11
GAME( 200?, ad5dnd      ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5dnda     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5dndb     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5dndc     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5dndd     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5dnde     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 6)", GAME_IS_SKELETON )
GAME( 200?, ad5dndf     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 7)", GAME_IS_SKELETON )
GAME( 200?, ad5dndg     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 8)", GAME_IS_SKELETON )
GAME( 200?, ad5dndh     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 9)", GAME_IS_SKELETON )
GAME( 200?, ad5dndi     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 10)", GAME_IS_SKELETON )
GAME( 200?, ad5dndj     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 11)", GAME_IS_SKELETON )
GAME( 200?, ad5dndk     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 12)", GAME_IS_SKELETON )
GAME( 200?, ad5dndl     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 13)", GAME_IS_SKELETON )
// PROJECT NUMBER PR1945 VIDEO CASINO DOND         VID CASINO DOND ARCADE  PR1945 CASINO D O N D SOUNDS12
GAME( 200?, ad5dndm     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 14)", GAME_IS_SKELETON )
GAME( 200?, ad5dndn     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 15)", GAME_IS_SKELETON )
GAME( 200?, ad5dndo     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 16)", GAME_IS_SKELETON )
GAME( 200?, ad5dndp     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 17)", GAME_IS_SKELETON )
GAME( 200?, ad5dndq     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 18)", GAME_IS_SKELETON )
GAME( 200?, ad5dndr     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 19)", GAME_IS_SKELETON )
// PROJECT NUMBER PR1945 DEAL OR NO DEAL  - BFG*DEAL ( PR1945 CASINO D O N D SOUNDS11 )
GAME( 200?, ad5dndu     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 22)", GAME_IS_SKELETON )
GAME( 200?, ad5dndv     ,ad5dnd,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal (Bellfruit) (Adder 5) (set 23)", GAME_IS_SKELETON )

// PROJECT NUMBER PR3078 DEAL OR NO DEAL - BFG*BDTS ( PR3078 DOND TWIN SOUNDS11 ) (twin screen)
GAME( 200?, ad5dndcl    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5dndcla   ,ad5dndcl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5dndclb   ,ad5dndcl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5dndclc   ,ad5dndcl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5dndcld   ,ad5dndcl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5dndcle   ,ad5dndcl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5) (set 6)", GAME_IS_SKELETON )
GAME( 200?, ad5dndclf   ,ad5dndcl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5) (set 20)", GAME_IS_SKELETON )
GAME( 200?, ad5dndclg   ,ad5dndcl,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Club (Bellfruit) (Adder 5) (set 21)", GAME_IS_SKELETON )

// PR3402 AWP DOND DOUBLE DELUXE S5         PR3402 DOUBLE DELUXE SOUNDS11
GAME( 200?, ad5dnddd    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5dnddda   ,ad5dnddd,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal Double Deal Or No Deal (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR3526 DEAL OR NO DEAL THE PERFECT GAME - BFGNVVPG ( R3526 DOND PERFG CLUB SOUNDS12 ) (twin screen)
GAME( 200?, ad5dndpg    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5dndpga   ,ad5dndpg,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5dndpgb   ,ad5dndpg,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5dndpgc   ,ad5dndpg,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Deal Or No Deal The Perfect Game (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )

// PR3206 AWP COPS N ROBBERS         PR3206 COPS N ROBBERS SOUNDS11
GAME( 200?, ad5copsr    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5copsra   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrb   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrd   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5copsre   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrf   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 6)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrk   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 7)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrl   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 8)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrm   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 9)", GAME_IS_SKELETON )
GAME( 200?, ad5copsro   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 10)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrp   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 11)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrq   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 12)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrv   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 13)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrw   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR3206) (Bellfruit) (Adder 5) (set 14)", GAME_IS_SKELETON )
// PR1965 CASINO COPS TRIPLE         CASINO COPS ARCADE  PR3255 COPS & ROBBERS SOUNDS11
GAME( 200?, ad5copsrc   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR1965) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrg   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR1965) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrn   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR1965) (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrr   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR1965) (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrx   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR1965) (Bellfruit) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5copsry   ,ad5copsr,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Cops 'n' Robbers (PR1965) (Bellfruit) (Adder 5) (set 6)", GAME_IS_SKELETON )


// PR2476 COPSNROBB3         COPNROB SOUNDS         COPSNROBB3  S.SITE    ` MAZNSCBT
GAME( 200?, ad5crsc     ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2476) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5crsca    ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2476) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5crscb    ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2476) (Mazooma) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5crscc    ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2476) (Mazooma) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrj   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2476) (Mazooma) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5copsru   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2476) (Mazooma) (Adder 5) (set 6)", GAME_IS_SKELETON )
GAME( 200?, ad5copsr0   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2476) (Mazooma) (Adder 5) (set 7)", GAME_IS_SKELETON )
GAME( 200?, ad5copsr2   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2476) (Mazooma) (Adder 5) (set 8)", GAME_IS_SKELETON )
//  PR2495 COPSNROB         COPNROB SOUNDS         COPSNROB  S.SITE  ` MAZNSCBF
GAME( 200?, ad5copsrh   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5copsri   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrs   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5copsrt   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5copsr4   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5copsr6   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 6)", GAME_IS_SKELETON )
GAME( 200?, ad5crscd    ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 7)", GAME_IS_SKELETON )
GAME( 200?, ad5crsce    ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 8)", GAME_IS_SKELETON )
GAME( 200?, ad5crscf    ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 9)", GAME_IS_SKELETON )
GAME( 200?, ad5crscg    ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2495) (Mazooma) (Adder 5) (set 10)", GAME_IS_SKELETON )
// PR2628 COPSNROB         COPNROB SOUNDS         COPSNROB  S.SITE  ` MAZ*CRBF
GAME( 200?, ad5copsr3   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2628) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5copsr5   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2628) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5crsch    ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2628) (Mazooma) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5copsr7   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2628) (Mazooma) (Adder 5) (set 4)", GAME_IS_SKELETON )
// PR2497 COPSNROB         COPNROB CD SOUNDS         COPSNROB  S.SITE  ` MAZ*COPV
GAME( 200?, ad5copsrz   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2497) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5copsr1   ,ad5crsc,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Cops 'n' Robbers (PR2497) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )



// PR3217 AWP GOLD MINE         PR3217 GOLD MINE SOUNDS11         GOLD MINE S.SITE
GAME( 200?, ad5gldmn    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmna   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmnb   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmnc   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmnd   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmne   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 6)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmnf   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 7)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmng   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 8)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmnh   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 9)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmni   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 10)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmnj   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 11)", GAME_IS_SKELETON )
GAME( 200?, ad5gldmnk   ,ad5gldmn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Gold Mine (Bellfruit) (Adder 5) (set 12)", GAME_IS_SKELETON )

// PR2365 MONOPOLYWOW         WOW SOUNDS         MONOPOLYWOW S.SITE    ` MAZ*BPFP
GAME( 200?, ad5mowow    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZNBPFP) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowl   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZNBPFP) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowe   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZPBPFP) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowm   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZPBPFP) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
// PR2365 MONOPOLYWOW         WOW SOUNDS         MONOPOLYWOW S.SITE    ` MAZ*MWOW
GAME( 200?, ad5mowowd   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZNMWOW) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowi   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZPMWOW) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
// PR2365 MONOPOLYWOW         WOWT SOUNDS         MONOPOLYWOW S.SITE    ` MAZ*WOWT
GAME( 200?, ad5mowowa   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZNWOWT) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowb   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZNWOWT) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowf   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZPWOWT) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowg   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2365, MAZPWOWT) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
// PR2389 MONOPOLYWOW         WOWT SOUNDS         MONOPOLYWOW S.SITE    ` MAZ*WWBU
GAME( 200?, ad5mowowc   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2389, MAZNWWBU) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowh   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR2389, MAZPWWBU) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
// PR3075 VIDEO CASINO WOW         CASINO DOND WOW ARCADE  PR3075 CASINO DOND WOW SOUNDS11  (wrong game?)
GAME( 200?, ad5mowowj   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR3075) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5mowowk   ,ad5mowow,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Wheel Of Wealth (PR3075) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR2283 PINK PANTHER         ` QPS*PINK   (PINK PANTHER SOUNDS)
GAME( 200?, ad5pp       ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (PR2283, QPSNPINK) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5ppa      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (PR2283, QPSNPINK) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5ppf      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (PR2283, QPSPPINK) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5ppg      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (PR2283, QPSPPINK) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
// PR2267 PINK PANTHER         ` MAZ*PINK (SD_PANTHER SNDS)
GAME( 200?, ad5ppb      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (PR2267, MAZNPINK) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5ppc      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (PR2267, MAZNPINK) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5pph      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (PR2267, MAZPPINK) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
/* (no main ident string) MAZ.PINKP SOUNDS */
GAME( 200?, ad5ppd      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (MAZNPINK) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5ppe      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (MAZNPINK) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5ppi      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (MAZPPINK) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5ppj      ,ad5pp,     bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Pink Panther (MAZPPINK) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR1669 RANDOM SPINNER         ` BFGNRNDN ( PR1669 RANDOM SPINNER SNDS11 )
GAME( 200?, ad5rsclb    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1669, BFGNRNDN) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbc   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1669, BFGNRNDN) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbd   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1669, BFGNRNDN) (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbe   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1669, BFGNRNDN) (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbf   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1669, BFGPRNDN) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbi   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1669, BFGPRNDN) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbj   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1669, BFGPRNDN) (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
// PR1826 RANDOM SPINNER         ` BFGNRNDN  ( PR1826 RANDOM SPINNER SOUNDS12 )
GAME( 200?, ad5rsclba   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1826, BFGNRNDN) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbb   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1826, BFGNRNDN) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbg   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1826, BFGPRNDN) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rsclbh   ,ad5rsclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner Club (PR1826, BFGPRNDN) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR2217 RANDOM MONOPOLY         ` MAZ*RNDN   - S16MONOP SOUNDS
GAME( 200?, ad5monop    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2217, MAZNRNDN) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5monopa   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2217, MAZNRNDN) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5monopb   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2217, MAZNRNDN) (Mazooma) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5monopc   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2217, MAZNRNDN) (Mazooma) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5monopf   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2217, MAZPRNDN) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5monopg   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2217, MAZPRNDN) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5monoph   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2217, MAZPRNDN) (Mazooma) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5monopi   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2217, MAZPRNDN) (Mazooma) (Adder 5) (set 4)", GAME_IS_SKELETON )
// PR2221 RANDOM MONOPOLY         ` MAZ*RNDN   - S16MONOP SOUNDS
GAME( 200?, ad5monopd   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2221, MAZNRNDN) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5monope   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2221, MAZNRNDN) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5monopj   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2221, MAZPRNDN) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5monopk   ,ad5monop,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly (PR2221, MAZPRNDN) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR1669 RANDOM SPINNER         ` BFGNRNDN  (  PR1669 RANDOM SPINNER SNDS11  )
GAME( 200?, ad5rspin    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner (PR1669, BFGNRNDN) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rspinb   ,ad5rspin,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner (PR1669, BFGPRNDN) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR1872 HOT SPINNER ASTURIAS 2.00  (wrong game?)   ( PR1506 RANDOM SPINNER ) (non-english, can't find a sound string)
GAME( 200?, ad5rspinc   ,ad5rspin,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Spinner (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )

// PR1758 BULLSEYE TRIPLE         ` BFG*BULS  ( PR1758 BULLSEYE TRIPLE SOUNDS11 )
GAME( 200?, ad5btc      ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Bullseye Triple Club (PR1758, BFGPBULS) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5btca     ,ad5btc,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Bullseye Triple Club (PR1758, BFGPBULS) (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5btcb     ,ad5btc,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Bullseye Triple Club (PR1758, BFGNBULS) (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )

// PR2226 RANDOM SPINNWIN         ` MAZ*RNDN  ( S16RSPINNWIN SOUNDS )
GAME( 200?, ad5rsnw     ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Spin 'n' Win (PR2226, MAZNRNDN) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rsnwa    ,ad5rsnw,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Spin 'n' Win (PR2226, MAZNRNDN) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5rsnwb    ,ad5rsnw,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Spin 'n' Win (PR2226, MAZPRNDN) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rsnwc    ,ad5rsnw,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Spin 'n' Win (PR2226, MAZPRNDN) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR3084 VIDEO SUPER SLAM         VIDEO SUPER SLAM  CLUB  PR3084 SUPER SLAM VID SOUNDS11
GAME( 200?, ad5sslam    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Super Slam (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5sslama   ,ad5sslam,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Super Slam (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5sslamb   ,ad5sslam,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Super Slam (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5sslamc   ,ad5sslam,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Super Slam (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5sslamd   ,ad5sslam,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Super Slam (Bellfruit) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5sslame   ,ad5sslam,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Super Slam (Bellfruit) (Adder 5) (set 6)", GAME_IS_SKELETON )
GAME( 200?, ad5sslamf   ,ad5sslam,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Super Slam (Bellfruit) (Adder 5) (set 7)", GAME_IS_SKELETON )

// PR2419 ROAD TO RICHES         MR2R SOUNDS
GAME( 200?, ad5mr2r     ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5mr2ra    ,ad5mr2r,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5mr2rb    ,ad5mr2r,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5mr2rc    ,ad5mr2r,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5mr2rd    ,ad5mr2r,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5mr2re    ,ad5mr2r,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 6)", GAME_IS_SKELETON )
GAME( 200?, ad5mr2rf    ,ad5mr2r,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 7)", GAME_IS_SKELETON )
GAME( 200?, ad5mr2rg    ,ad5mr2r,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 8)", GAME_IS_SKELETON )
GAME( 200?, ad5mr2rh    ,ad5mr2r,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Monopoly Road To Riches (Mazooma) (Adder 5) (set 9)", GAME_IS_SKELETON )

// PR1756 RANDOM WINNER         ` BFG*RWSX  ( PR1756 RANDOM WINNER SOUNDS12 )
GAME( 200?, ad5rwclb    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Winner Club (PR1756, BFGNRWSX) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rwclba   ,ad5rwclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Winner Club (PR1756, BFGNRWSX) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5rwclbb   ,ad5rwclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Winner Club (PR1756, BFGPRWSX) (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rwclbc   ,ad5rwclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Winner Club (PR1756, BFGPRWSX) (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
// PR1757 RANDOM WINNER         ` BFG*RWCL  ( PR1756 RANDOM WINNER SOUNDS12 )
GAME( 200?, ad5rwclbd   ,ad5rwclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Winner Club (PR1757, BFGPRWCL) (Bellfruit) (Adder 5)", GAME_IS_SKELETON )
GAME( 200?, ad5rwclbe   ,ad5rwclb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Random Winner Club (PR1757, BFGNRWCL) (Bellfruit) (Adder 5)", GAME_IS_SKELETON )

// PR2258 GOLDEN WINNER
GAME( 200?, ad5gldwn    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Golden Winner (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5gldwna   ,ad5gldwn,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Golden Winner (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR1712 RAPID PAY         PR1712 RAPID PAY SOUNDS11
GAME( 200?, ad5rapid    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Rapid Pay (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rapida   ,ad5rapid,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Rapid Pay (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR2226 JACKPOT MONOPOLY         ` MAZ*JACM  (JPMONP SOUNDS)
GAME( 200?, ad5jckmo    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Jackpot Monopoly (PR2226, MAZNJACM) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5jckmoa   ,ad5jckmo,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Jackpot Monopoly (PR2226, MAZNJACM) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5jckmoc   ,ad5jckmo,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Jackpot Monopoly (PR2226, MAZNJACM) (Mazooma) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5jckmod   ,ad5jckmo,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Jackpot Monopoly (PR2226, MAZPJACM) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5jckmoe   ,ad5jckmo,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Jackpot Monopoly (PR2226, MAZPJACM) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
// PR2253 JACKPOT MONOPOLY         ` MAZNJACM  (JPMONP SOUNDS)
GAME( 200?, ad5jckmob   ,ad5jckmo,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Jackpot Monopoly (PR2253, MAZNJACM) (Mazooma) (Adder 5)", GAME_IS_SKELETON )

// PR2304 PINKP_BTB         PPBTB SOUNDS         PINKP_BTB S.SITE  ` QPSNPPBB
GAME( 200?, ad5ppbtb    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Qps","Pink Panther Break The Bank (PR2304, QPSNPPBB) (Qps) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5ppbtba   ,ad5ppbtb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Qps","Pink Panther Break The Bank (PR2304, QPSNPPBB) (Qps) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5ppbtbb   ,ad5ppbtb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Qps","Pink Panther Break The Bank (PR2304, QPSPPPBB) (Qps) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5ppbtbc   ,ad5ppbtb,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Qps","Pink Panther Break The Bank (PR2304, QPSPPPBB) (Qps) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR3507 AWP VIVA LAS VEGAS SCORP5         PR3507 VIVA LAS VEGAS SOUNDS11
GAME( 200?, ad5vlv      ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Viva Las Vegas (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5vlvb     ,ad5vlv,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Viva Las Vegas (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5vlvc     ,ad5vlv,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Viva Las Vegas (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5vlvd     ,ad5vlv,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Viva Las Vegas (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
GAME( 200?, ad5vlve     ,ad5vlv,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Viva Las Vegas (Bellfruit) (Adder 5) (set 5)", GAME_IS_SKELETON )
GAME( 200?, ad5vlvf     ,ad5vlv,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Viva Las Vegas (Bellfruit) (Adder 5) (set 6)", GAME_IS_SKELETON )

// PR2331 RROULETTE         REEL ROULETTE SOUNDS         RROULETTE S.SITE  ` QPS*RLRO
GAME( 200?, ad5rroul    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Reel Roulette (QPSNRLRO) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
GAME( 200?, ad5rroula   ,ad5rroul,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Reel Roulette (QPSPRLRO) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
// PR2331 RROULETTE         REEL ROULETTE SOUNDS         RROULETTE S.SITE  ` MAZ*RERO
GAME( 200?, ad5rroulb   ,ad5rroul,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Reel Roulette (MAZNRERO) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
GAME( 200?, ad5rroulc   ,ad5rroul,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Reel Roulette (MAZPRERO) (Mazooma) (Adder 5)", GAME_IS_SKELETON )

// PR2444 MONTE CARLO OR BUST         MONTE SOUNDS
GAME( 200?, ad5mcob     ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Qps","Monte Carlo Or Bust (Qps) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5mcoba    ,ad5mcob,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Qps","Monte Carlo Or Bust (Qps) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5mcobb    ,ad5mcob,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Qps","Monte Carlo Or Bust (Qps) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5mcobc    ,ad5mcob,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Qps","Monte Carlo Or Bust (Qps) (Adder 5) (set 4)", GAME_IS_SKELETON )

// PR1625  POKER KING         PR1625 POKER KING SOUNDS11        POKER KING  S.SITE
GAME( 200?, ad5pking    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Poker King (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5pkinga   ,ad5pking,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Poker King (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR3073 VIDEO POKER ACE         VID POKER ACE ARCADE  PR3073 POKER ACE SOUNDS11
GAME( 200?, ad5vpa      ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Video Poker Ace (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5vpaa     ,ad5vpa,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Video Poker Ace (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5vpab     ,ad5vpa,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Video Poker Ace (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5vpac     ,ad5vpa,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Video Poker Ace (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )

// PR1629 TORNADO 5.5 (Revision 8)         ` BFG*TORD  ( PR1627 TORNADO CLUB SOUNDS11 )
GAME( 200?, ad5tornc    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Tornado Club (PR1629, 5.5, rv 8, BFGNTORD) (Bellfruit) (Adder 5)", GAME_IS_SKELETON )
GAME( 200?, ad5torncb   ,ad5tornc,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Tornado Club (PR1629, 5.5, rv 8, BFGPTORD) (Bellfruit) (Adder 5)", GAME_IS_SKELETON )
// PR1629 TORNADO 5.8 (Revision 7)         ` BFGPTORD  ( PR1627 TORNADO CLUB SOUNDS11 )
GAME( 200?, ad5tornca   ,ad5tornc,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Tornado Club (PR1629, 5.8, rv 7, BFGNTORD) (Bellfruit) (Adder 5)", GAME_IS_SKELETON )
GAME( 200?, ad5torncc   ,ad5tornc,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Tornado Club (PR1629, 5.8, rv 7, BFGPTORD) (Bellfruit) (Adder 5)", GAME_IS_SKELETON )
// PR1627 TORNADO 0.1 (Revision 1)         ` BFG*TORN  ( PR1627 TORNADO CLUB SOUNDS11 )
GAME( 200?, ad5tornce   ,ad5tornc,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Tornado Club (PR1627, 0.1, rv 1, BFGNTORN) (Bellfruit) (Adder 5)", GAME_IS_SKELETON )
GAME( 200?, ad5torncd   ,ad5tornc,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Tornado Club (PR1627, 0.1, rv 1, BFGPTORN) (Bellfruit) (Adder 5)", GAME_IS_SKELETON )

// PR2268 REEL CASH
GAME( 200?, ad5rcash    ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Reel Cash (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rcasha   ,ad5rcash,  bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Reel Cash (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR2284 RANDOM MONOPOLY WOTW   ( S16MONOPWOW SOUNDS )
GAME( 200?, ad5mww      ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly Wonders Of The World (PR2284) (Mazooma) (Adder 5)", GAME_IS_SKELETON )
// PR2291 RANDOM MONOPOLY WOTW   ( S16MONOPWOW SOUNDS )
GAME( 200?, ad5mwwa     ,ad5mww,    bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Random Monopoly Wonders Of The World (PR2291) (Mazooma) (Adder 5)", GAME_IS_SKELETON )

// PR2242 EYES DOWN         ` MAZ*EYDW
GAME( 200?, ad5eyes     ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Eyes Down (PR2242, MAZNEYDW) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5eyesa    ,ad5eyes,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Eyes Down (PR2242, MAZNEYDW) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5eyesd    ,ad5eyes,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Eyes Down (PR2242, MAZPEYDW) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5eyese    ,ad5eyes,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Eyes Down (PR2242, MAZPEYDW) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
// PR2246 EYES DOWN         ` MAZ*EYDW
GAME( 200?, ad5eyesb    ,ad5eyes,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Eyes Down (PR2246, MAZNEYDW) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5eyesg    ,ad5eyes,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Eyes Down (PR2246, MAZNEYDW) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5eyesc    ,ad5eyes,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Eyes Down (PR2246, MAZPEYDW) (Mazooma) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5eyesf    ,ad5eyes,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "Mazooma","Eyes Down (PR2246, MAZPEYDW) (Mazooma) (Adder 5) (set 2)", GAME_IS_SKELETON )

// PR3302 AWP RONNIE O SULLIVANS ROCKET MONEY SCORP5         PR3302 RONNIE ROCKET SOUNDS11
GAME( 200?, ad5rsrm     ,0,         bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Ronnie O'Sullivan's Rocket Money (Bellfruit) (Adder 5) (set 1)", GAME_IS_SKELETON )
GAME( 200?, ad5rsrma    ,ad5rsrm,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Ronnie O'Sullivan's Rocket Money (Bellfruit) (Adder 5) (set 2)", GAME_IS_SKELETON )
GAME( 200?, ad5rsrr     ,ad5rsrm,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Ronnie O'Sullivan's Rocket Money (Bellfruit) (Adder 5) (set 3)", GAME_IS_SKELETON )
GAME( 200?, ad5rsrra    ,ad5rsrm,   bfm_ad5, bfm_ad5, adder5_state, ad5, ROT0,  "BFM","Ronnie O'Sullivan's Rocket Money (Bellfruit) (Adder 5) (set 4)", GAME_IS_SKELETON )
