#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Kerbal Space Program
# send your bug reports to contact@dotslashplay.it
###

script_version=20231111.2

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='kerbal-space-program'
GAME_NAME='Kerbal Space Program'

ARCHIVE_BASE_3_NAME='kerbal_space_program_1_10_1_02939_41941.sh'
ARCHIVE_BASE_3_MD5='fe71449cc6478ae7cbfbf0a718c9daa3'
ARCHIVE_BASE_3_SIZE='4000000'
ARCHIVE_BASE_3_VERSION='1.10.1.02939-gog41941'
ARCHIVE_BASE_3_URL='https://www.gog.com/game/kerbal_space_program'

ARCHIVE_BASE_2_NAME='kerbal_space_program_1_10_0_02917_39410.sh'
ARCHIVE_BASE_2_MD5='40d7ea6e6c112a95954b3178030599b0'
ARCHIVE_BASE_2_SIZE='4000000'
ARCHIVE_BASE_2_VERSION='1.10.0.02917-gog39410'

ARCHIVE_BASE_1_NAME='kerbal_space_program_1_9_1_02788_36309.sh'
ARCHIVE_BASE_1_MD5='6157d3ebad90960893e4aa177b8518de'
ARCHIVE_BASE_1_SIZE='3700000'
ARCHIVE_BASE_1_VERSION='1.9.1.02788-gog36309'

ARCHIVE_BASE_0_NAME='kerbal_space_program_1_8_1_02694_33460.sh'
ARCHIVE_BASE_0_MD5='195abb84de4a916192190858d0796c50'
ARCHIVE_BASE_0_SIZE='3400000'
ARCHIVE_BASE_0_VERSION='1.8.1.02694-gog33460'

UNITY3D_NAME='KSP'
UNITY3D_PLUGINS='
libkeyboard.so
liblingoona.grammar.kerbal.so
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME0_DATA_FILES='
GameData
Internals
Missions
Parts
Resources
Ships
saves
sounds
*.cfg'
CONTENT_DOC_DATA_FILES='
LegalNotice.txt
readme.txt'

USER_PERSISTENT_DIRECTORIES='
saves
sounds'
USER_PERSISTENT_FILES='
*.cfg
*.mu'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libdl.so.2
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libgio-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpangoft2-1.0.so.0
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
