///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 1997-2008 Morgan Stanley All rights reserved. 
// See .../src/LICENSE for terms of distribution
//
//
///////////////////////////////////////////////////////////////////////////////

#include <MSTypes/MSFractionTables.H>

FractionTable EightsTable=
{ 16,
  {
    {(0.0/16.0),""},{(1.0/16.0),"1/8"},{(2.0/16.0),"1/8"},{(3.0/16.0),"1/4"},
    {(4.0/16.0),"1/4"},{(5.0/16.0),"3/8"},{(6.0/16.0),"3/8"},{(7.0/16.0),"1/2"},
    {(8.0/16.0),"1/2"},{(9.0/16.0),"5/8"},{(10.0/16.0),"5/8"},{(11.0/16.0),"3/4"},
    {(12.0/16.0),"3/4"},{(13.0/16.0),"7/8"},{(14.0/16.0),"7/8"},{(15.0/16.0),"1/1"},
    
  }
};

FractionTable SixteenthsTable=
{ 32,
  {
    {(0.0/32.0),""},{(1.0/32.0),"1/16"},{(2.0/32.0),"1/16"},{(3.0/32.0),"1/8"},
    {(4.0/32.0),"1/8"},{(5.0/32.0),"3/16"},{(6.0/32.0),"3/16"},{(7.0/32.0),"1/4"},
    {(8.0/32.0),"1/4"},{(9.0/32.0),"5/16"},{(10.0/32.0),"5/16"},{(11.0/32.0),"3/8"},
    {(12.0/32.0),"3/8"},{(13.0/32.0),"7/16"},{(14.0/32.0),"7/16"},{(15.0/32.0),"1/2"},
    {(16.0/32.0),"1/2"},{(17.0/32.0),"9/16"},{(18.0/32.0),"9/16"},{(19.0/32.0),"5/8"},
    {(20.0/32.0),"5/8"},{(21.0/32.0),"11/16"},{(22.0/32.0),"11/16"},{(23.0/32.0),"3/4"},
    {(24.0/32.0),"3/4"},{(25.0/32.0),"13/16"},{(26.0/32.0),"13/16"},{(27.0/32.0),"7/8"},
    {(28.0/32.0),"7/8"},{(29.0/32.0),"15/16"},{(30.0/32.0),"15/16"},{(31.0/32.0),"1/1"}
  }
};

FractionTable ThirtySecondsTable=
{ 64,
  {
    {(0.0/64.0),""},{(1.0/64.0),"1/32"},{(2.0/64.0),"1/32"},{(3.0/64.0),"1/16"},
    {(4.0/64.0),"1/16"},{(5.0/64.0),"3/32"},{(6.0/64.0),"3/32"},{(7.0/64.0),"1/8"},
    {(8.0/64.0),"1/8"},{(9.0/64.0),"5/32"},{(10.0/64.0),"5/32"},{(11.0/64.0),"3/16"},
    {(12.0/64.0),"3/16"},{(13.0/64.0),"7/32"},{(14.0/64.0),"7/32"},{(15.0/64.0),"1/4"},
    {(16.0/64.0),"1/4"},{(17.0/64.0),"9/32"},{(18.0/64.0),"9/32"},{(19.0/64.0),"5/16"},
    {(20.0/64.0),"5/16"},{(21.0/64.0),"11/32"},{(22.0/64.0),"11/32"},{(23.0/64.0),"3/8"},
    {(24.0/64.0),"3/8"},{(25.0/64.0),"13/32"},{(26.0/64.0),"13/32"},{(27.0/64.0),"7/16"},
    {(28.0/64.0),"7/16"},{(29.0/64.0),"15/32"},{(30.0/64.0),"15/32"},{(31.0/64.0),"1/2"},
    {(32.0/64.0),"1/2"},{(33.0/64.0),"17/32"},{(34.0/64.0),"17/32"},{(35.0/64.0),"9/16"},
    {(36.0/64.0),"9/16"},{(37.0/64.0),"19/32"},{(38.0/64.0),"19/32"},{(39.0/64.0),"5/8"},
    {(40.0/64.0),"5/8"},{(41.0/64.0),"21/32"},{(42.0/64.0),"21/32"},{(43.0/64.0),"11/16"},
    {(44.0/64.0),"11/16"},{(45.0/64.0),"23/32"},{(46.0/64.0),"23/32"},{(47.0/64.0),"3/4"},
    {(48.0/64.0),"3/4"},{(49.0/64.0),"25/32"},{(50.0/64.0),"25/32"},{(51.0/64.0),"13/16"},
    {(52.0/64.0),"13/16"},{(53.0/64.0),"27/32"},{(54.0/64.0),"27/32"},{(55.0/64.0),"7/8"},
    {(56.0/64.0),"7/8"},{(57.0/64.0),"29/32"},{(58.0/64.0),"29/32"},{(59.0/64.0),"15/16"},
    {(60.0/64.0),"15/16"},{(61.0/64.0),"31/32"},{(62.0/64.0),"31/32"},{(63.0/64.0),"1/1"},
    
  }
};

FractionTable SixtyForthsTable=
{ 128,
  {
    {(0.0/128.0),""},{(1.0/128.0),"1/64"},{(2.0/128.0),"1/64"},{(3.0/128.0),"1/32"},
    {(4.0/128.0),"1/32"},{(5.0/128.0),"3/64"},{(6.0/128.0),"3/64"},{(7.0/128.0),"1/16"},
    {(8.0/128.0),"1/16"},{(9.0/128.0),"5/64"},{(10.0/128.0),"5/64"},{(11.0/128.0),"3/32"},
    {(12.0/128.0),"3/32"},{(13.0/128.0),"7/64"},{(14.0/128.0),"7/64"},{(15.0/128.0),"1/8"},
    {(16.0/128.0),"1/8"},{(17.0/128.0),"9/64"},{(18.0/128.0),"9/64"},{(19.0/128.0),"5/32"},
    {(20.0/128.0),"5/32"},{(21.0/128.0),"11/64"},{(22.0/128.0),"11/64"},{(23.0/128.0),"3/16"},
    {(24.0/128.0),"3/16"},{(25.0/128.0),"13/64"},{(26.0/128.0),"13/64"},{(27.0/128.0),"7/32"},
    {(28.0/128.0),"7/32"},{(29.0/128.0),"15/64"},{(30.0/128.0),"15/64"},{(31.0/128.0),"1/4"},
    {(32.0/128.0),"1/4"},{(33.0/128.0),"17/64"},{(34.0/128.0),"17/64"},{(35.0/128.0),"9/32"},
    {(36.0/128.0),"9/32"},{(37.0/128.0),"19/64"},{(38.0/128.0),"19/64"},{(39.0/128.0),"5/16"},
    {(40.0/128.0),"5/16"},{(41.0/128.0),"21/64"},{(42.0/128.0),"21/64"},{(43.0/128.0),"11/32"},
    {(44.0/128.0),"11/32"},{(45.0/128.0),"23/64"},{(46.0/128.0),"23/64"},{(47.0/128.0),"3/8"},
    {(48.0/128.0),"3/8"},{(49.0/128.0),"25/64"},{(50.0/128.0),"25/64"},{(51.0/128.0),"13/32"},
    {(52.0/128.0),"13/32"},{(53.0/128.0),"27/64"},{(54.0/128.0),"27/64"},{(55.0/128.0),"7/16"},
    {(56.0/128.0),"7/16"},{(57.0/128.0),"29/64"},{(58.0/128.0),"29/64"},{(59.0/128.0),"15/32"},
    {(60.0/128.0),"15/32"},{(61.0/128.0),"31/64"},{(62.0/128.0),"31/64"},{(63.0/128.0),"1/2"},
    {(64.0/128.0),"1/2"},{(65.0/128.0),"33/64"},{(66.0/128.0),"33/64"},{(67.0/128.0),"17/32"},
    {(68.0/128.0),"17/32"},{(69.0/128.0),"35/64"},{(70.0/128.0),"35/64"},{(71.0/128.0),"9/16"},
    {(72.0/128.0),"9/16"},{(73.0/128.0),"37/64"},{(74.0/128.0),"37/64"},{(75.0/128.0),"19/32"},
    {(76.0/128.0),"19/32"},{(77.0/128.0),"39/64"},{(78.0/128.0),"39/64"},{(79.0/128.0),"5/8"},
    {(80.0/128.0),"5/8"},{(81.0/128.0),"41/64"},{(82.0/128.0),"41/64"},{(83.0/128.0),"21/32"},
    {(84.0/128.0),"21/32"},{(85.0/128.0),"43/64"},{(86.0/128.0),"43/64"},{(87.0/128.0),"11/16"},
    {(88.0/128.0),"11/16"},{(89.0/128.0),"45/64"},{(90.0/128.0),"45/64"},{(91.0/128.0),"23/32"},
    {(92.0/128.0),"23/32"},{(93.0/128.0),"47/64"},{(94.0/128.0),"47/64"},{(95.0/128.0),"3/4"},
    {(96.0/128.0),"3/4"},{(97.0/128.0),"49/64"},{(98.0/128.0),"49/64"},{(99.0/128.0),"25/32"},
    {(100.0/128.0),"25/32"},{(101.0/128.0),"51/64"},{(102.0/128.0),"51/64"},{(103.0/128.0),"13/16"},
    {(104.0/128.0),"13/16"},{(105.0/128.0),"53/64"},{(106.0/128.0),"53/64"},{(107.0/128.0),"27/32"},
    {(108.0/128.0),"27/32"},{(109.0/128.0),"55/64"},{(110.0/128.0),"55/64"},{(111.0/128.0),"7/8"},
    {(112.0/128.0),"7/8"},{(113.0/128.0),"57/64"},{(114.0/128.0),"57/64"},{(115.0/128.0),"29/32"},
    {(116.0/128.0),"29/32"},{(117.0/128.0),"59/64"},{(118.0/128.0),"59/64"},{(119.0/128.0),"15/16"},
    {(120.0/128.0),"15/16"},{(121.0/128.0),"61/64"},{(122.0/128.0),"61/64"},{(123.0/128.0),"31/32"},
    {(124.0/128.0),"31/32"},{(125.0/128.0),"63/64"},{(126.0/128.0),"63/64"},{(127.0/128.0),"1/1"},
    
  }
};

FractionTable OneTwentyEightsTable=
{ 256,
  {
    {(0.0/256.0),""},{(1.0/256.0),"1/128"},{(2.0/256.0),"1/128"},{(3.0/256.0),"1/64"},
    {(4.0/256.0),"1/64"},{(5.0/256.0),"3/128"},{(6.0/256.0),"3/128"},{(7.0/256.0),"1/32"},
    {(8.0/256.0),"1/32"},{(9.0/256.0),"5/128"},{(10.0/256.0),"5/128"},{(11.0/256.0),"3/64"},
    {(12.0/256.0),"3/64"},{(13.0/256.0),"7/128"},{(14.0/256.0),"7/128"},{(15.0/256.0),"1/16"},
    {(16.0/256.0),"1/16"},{(17.0/256.0),"9/128"},{(18.0/256.0),"9/128"},{(19.0/256.0),"5/64"},
    {(20.0/256.0),"5/64"},{(21.0/256.0),"11/128"},{(22.0/256.0),"11/128"},{(23.0/256.0),"3/32"},
    {(24.0/256.0),"3/32"},{(25.0/256.0),"13/128"},{(26.0/256.0),"13/128"},{(27.0/256.0),"7/64"},
    {(28.0/256.0),"7/64"},{(29.0/256.0),"15/128"},{(30.0/256.0),"15/128"},{(31.0/256.0),"1/8"},
    {(32.0/256.0),"1/8"},{(33.0/256.0),"17/128"},{(34.0/256.0),"17/128"},{(35.0/256.0),"9/64"},
    {(36.0/256.0),"9/64"},{(37.0/256.0),"19/128"},{(38.0/256.0),"19/128"},{(39.0/256.0),"5/32"},
    {(40.0/256.0),"5/32"},{(41.0/256.0),"21/128"},{(42.0/256.0),"21/128"},{(43.0/256.0),"11/64"},
    {(44.0/256.0),"11/64"},{(45.0/256.0),"23/128"},{(46.0/256.0),"23/128"},{(47.0/256.0),"3/16"},
    {(48.0/256.0),"3/16"},{(49.0/256.0),"25/128"},{(50.0/256.0),"25/128"},{(51.0/256.0),"13/64"},
    {(52.0/256.0),"13/64"},{(53.0/256.0),"27/128"},{(54.0/256.0),"27/128"},{(55.0/256.0),"7/32"},
    {(56.0/256.0),"7/32"},{(57.0/256.0),"29/128"},{(58.0/256.0),"29/128"},{(59.0/256.0),"15/64"},
    {(60.0/256.0),"15/64"},{(61.0/256.0),"31/128"},{(62.0/256.0),"31/128"},{(63.0/256.0),"1/4"},
    {(64.0/256.0),"1/4"},{(65.0/256.0),"33/128"},{(66.0/256.0),"33/128"},{(67.0/256.0),"17/64"},
    {(68.0/256.0),"17/64"},{(69.0/256.0),"35/128"},{(70.0/256.0),"35/128"},{(71.0/256.0),"9/32"},
    {(72.0/256.0),"9/32"},{(73.0/256.0),"37/128"},{(74.0/256.0),"37/128"},{(75.0/256.0),"19/64"},
    {(76.0/256.0),"19/64"},{(77.0/256.0),"39/128"},{(78.0/256.0),"39/128"},{(79.0/256.0),"5/16"},
    {(80.0/256.0),"5/16"},{(81.0/256.0),"41/128"},{(82.0/256.0),"41/128"},{(83.0/256.0),"21/64"},
    {(84.0/256.0),"21/64"},{(85.0/256.0),"43/128"},{(86.0/256.0),"43/128"},{(87.0/256.0),"11/32"},
    {(88.0/256.0),"11/32"},{(89.0/256.0),"45/128"},{(90.0/256.0),"45/128"},{(91.0/256.0),"23/64"},
    {(92.0/256.0),"23/64"},{(93.0/256.0),"47/128"},{(94.0/256.0),"47/128"},{(95.0/256.0),"3/8"},
    {(96.0/256.0),"3/8"},{(97.0/256.0),"49/128"},{(98.0/256.0),"49/128"},{(99.0/256.0),"25/64"},
    {(100.0/256.0),"25/64"},{(101.0/256.0),"51/128"},{(102.0/256.0),"51/128"},{(103.0/256.0),"13/32"},
    {(104.0/256.0),"13/32"},{(105.0/256.0),"53/128"},{(106.0/256.0),"53/128"},{(107.0/256.0),"27/64"},
    {(108.0/256.0),"27/64"},{(109.0/256.0),"55/128"},{(110.0/256.0),"55/128"},{(111.0/256.0),"7/16"},
    {(112.0/256.0),"7/16"},{(113.0/256.0),"57/128"},{(114.0/256.0),"57/128"},{(115.0/256.0),"29/64"},
    {(116.0/256.0),"29/64"},{(117.0/256.0),"59/128"},{(118.0/256.0),"59/128"},{(119.0/256.0),"15/32"},
    {(120.0/256.0),"15/32"},{(121.0/256.0),"61/128"},{(122.0/256.0),"61/128"},{(123.0/256.0),"31/64"},
    {(124.0/256.0),"31/64"},{(125.0/256.0),"63/128"},{(126.0/256.0),"63/128"},{(127.0/256.0),"1/2"},
    {(128.0/256.0),"1/2"},{(129.0/256.0),"65/128"},{(130.0/256.0),"65/128"},{(131.0/256.0),"33/64"},
    {(132.0/256.0),"33/64"},{(133.0/256.0),"67/128"},{(134.0/256.0),"67/128"},{(135.0/256.0),"17/32"},
    {(136.0/256.0),"17/32"},{(137.0/256.0),"69/128"},{(138.0/256.0),"69/128"},{(139.0/256.0),"35/64"},
    {(140.0/256.0),"35/64"},{(141.0/256.0),"71/128"},{(142.0/256.0),"71/128"},{(143.0/256.0),"9/16"},
    {(144.0/256.0),"9/16"},{(145.0/256.0),"73/128"},{(146.0/256.0),"73/128"},{(147.0/256.0),"37/64"},
    {(148.0/256.0),"37/64"},{(149.0/256.0),"75/128"},{(150.0/256.0),"75/128"},{(151.0/256.0),"19/32"},
    {(152.0/256.0),"19/32"},{(153.0/256.0),"77/128"},{(154.0/256.0),"77/128"},{(155.0/256.0),"39/64"},
    {(156.0/256.0),"39/64"},{(157.0/256.0),"79/128"},{(158.0/256.0),"79/128"},{(159.0/256.0),"5/8"},
    {(160.0/256.0),"5/8"},{(161.0/256.0),"81/128"},{(162.0/256.0),"81/128"},{(163.0/256.0),"41/64"},
    {(164.0/256.0),"41/64"},{(165.0/256.0),"83/128"},{(166.0/256.0),"83/128"},{(167.0/256.0),"21/32"},
    {(168.0/256.0),"21/32"},{(169.0/256.0),"85/128"},{(170.0/256.0),"85/128"},{(171.0/256.0),"43/64"},
    {(172.0/256.0),"43/64"},{(173.0/256.0),"87/128"},{(174.0/256.0),"87/128"},{(175.0/256.0),"11/16"},
    {(176.0/256.0),"11/16"},{(177.0/256.0),"89/128"},{(178.0/256.0),"89/128"},{(179.0/256.0),"45/64"},
    {(180.0/256.0),"45/64"},{(181.0/256.0),"91/128"},{(182.0/256.0),"91/128"},{(183.0/256.0),"23/32"},
    {(184.0/256.0),"23/32"},{(185.0/256.0),"93/128"},{(186.0/256.0),"93/128"},{(187.0/256.0),"47/64"},
    {(188.0/256.0),"47/64"},{(189.0/256.0),"95/128"},{(190.0/256.0),"95/128"},{(191.0/256.0),"3/4"},
    {(192.0/256.0),"3/4"},{(193.0/256.0),"97/128"},{(194.0/256.0),"97/128"},{(195.0/256.0),"49/64"},
    {(196.0/256.0),"49/64"},{(197.0/256.0),"99/128"},{(198.0/256.0),"99/128"},{(199.0/256.0),"25/32"},
    {(200.0/256.0),"25/32"},{(201.0/256.0),"101/128"},{(202.0/256.0),"101/128"},{(203.0/256.0),"51/64"},
    {(204.0/256.0),"51/64"},{(205.0/256.0),"103/128"},{(206.0/256.0),"103/128"},{(207.0/256.0),"13/16"},
    {(208.0/256.0),"13/16"},{(209.0/256.0),"105/128"},{(210.0/256.0),"105/128"},{(211.0/256.0),"53/64"},
    {(212.0/256.0),"53/64"},{(213.0/256.0),"107/128"},{(214.0/256.0),"107/128"},{(215.0/256.0),"27/32"},
    {(216.0/256.0),"27/32"},{(217.0/256.0),"109/128"},{(218.0/256.0),"109/128"},{(219.0/256.0),"55/64"},
    {(220.0/256.0),"55/64"},{(221.0/256.0),"111/128"},{(222.0/256.0),"111/128"},{(223.0/256.0),"7/8"},
    {(224.0/256.0),"7/8"},{(225.0/256.0),"113/128"},{(226.0/256.0),"113/128"},{(227.0/256.0),"57/64"},
    {(228.0/256.0),"57/64"},{(229.0/256.0),"115/128"},{(230.0/256.0),"115/128"},{(231.0/256.0),"29/32"},
    {(232.0/256.0),"29/32"},{(233.0/256.0),"117/128"},{(234.0/256.0),"117/128"},{(235.0/256.0),"59/64"},
    {(236.0/256.0),"59/64"},{(237.0/256.0),"119/128"},{(238.0/256.0),"119/128"},{(239.0/256.0),"15/16"},
    {(240.0/256.0),"15/16"},{(241.0/256.0),"121/128"},{(242.0/256.0),"121/128"},{(243.0/256.0),"61/64"},
    {(244.0/256.0),"61/64"},{(245.0/256.0),"123/128"},{(246.0/256.0),"123/128"},{(247.0/256.0),"31/32"},
    {(248.0/256.0),"31/32"},{(249.0/256.0),"125/128"},{(250.0/256.0),"125/128"},{(251.0/256.0),"63/64"},
    {(252.0/256.0),"63/64"},{(253.0/256.0),"127/128"},{(254.0/256.0),"127/128"},{(255.0/256.0),"1/1"},
    
  }
};

FractionTable TwoFiftySixthsTable=
{ 512,
  {
    {(0.0/512.0),""},{(1.0/512.0),"1/256"},{(2.0/512.0),"1/256"},{(3.0/512.0),"1/128"},
    {(4.0/512.0),"1/128"},{(5.0/512.0),"3/256"},{(6.0/512.0),"3/256"},{(7.0/512.0),"1/64"},
    {(8.0/512.0),"1/64"},{(9.0/512.0),"5/256"},{(10.0/512.0),"5/256"},{(11.0/512.0),"3/128"},
    {(12.0/512.0),"3/128"},{(13.0/512.0),"7/256"},{(14.0/512.0),"7/256"},{(15.0/512.0),"1/32"},
    {(16.0/512.0),"1/32"},{(17.0/512.0),"9/256"},{(18.0/512.0),"9/256"},{(19.0/512.0),"5/128"},
    {(20.0/512.0),"5/128"},{(21.0/512.0),"11/256"},{(22.0/512.0),"11/256"},{(23.0/512.0),"3/64"},
    {(24.0/512.0),"3/64"},{(25.0/512.0),"13/256"},{(26.0/512.0),"13/256"},{(27.0/512.0),"7/128"},
    {(28.0/512.0),"7/128"},{(29.0/512.0),"15/256"},{(30.0/512.0),"15/256"},{(31.0/512.0),"1/16"},
    {(32.0/512.0),"1/16"},{(33.0/512.0),"17/256"},{(34.0/512.0),"17/256"},{(35.0/512.0),"9/128"},
    {(36.0/512.0),"9/128"},{(37.0/512.0),"19/256"},{(38.0/512.0),"19/256"},{(39.0/512.0),"5/64"},
    {(40.0/512.0),"5/64"},{(41.0/512.0),"21/256"},{(42.0/512.0),"21/256"},{(43.0/512.0),"11/128"},
    {(44.0/512.0),"11/128"},{(45.0/512.0),"23/256"},{(46.0/512.0),"23/256"},{(47.0/512.0),"3/32"},
    {(48.0/512.0),"3/32"},{(49.0/512.0),"25/256"},{(50.0/512.0),"25/256"},{(51.0/512.0),"13/128"},
    {(52.0/512.0),"13/128"},{(53.0/512.0),"27/256"},{(54.0/512.0),"27/256"},{(55.0/512.0),"7/64"},
    {(56.0/512.0),"7/64"},{(57.0/512.0),"29/256"},{(58.0/512.0),"29/256"},{(59.0/512.0),"15/128"},
    {(60.0/512.0),"15/128"},{(61.0/512.0),"31/256"},{(62.0/512.0),"31/256"},{(63.0/512.0),"1/8"},
    {(64.0/512.0),"1/8"},{(65.0/512.0),"33/256"},{(66.0/512.0),"33/256"},{(67.0/512.0),"17/128"},
    {(68.0/512.0),"17/128"},{(69.0/512.0),"35/256"},{(70.0/512.0),"35/256"},{(71.0/512.0),"9/64"},
    {(72.0/512.0),"9/64"},{(73.0/512.0),"37/256"},{(74.0/512.0),"37/256"},{(75.0/512.0),"19/128"},
    {(76.0/512.0),"19/128"},{(77.0/512.0),"39/256"},{(78.0/512.0),"39/256"},{(79.0/512.0),"5/32"},
    {(80.0/512.0),"5/32"},{(81.0/512.0),"41/256"},{(82.0/512.0),"41/256"},{(83.0/512.0),"21/128"},
    {(84.0/512.0),"21/128"},{(85.0/512.0),"43/256"},{(86.0/512.0),"43/256"},{(87.0/512.0),"11/64"},
    {(88.0/512.0),"11/64"},{(89.0/512.0),"45/256"},{(90.0/512.0),"45/256"},{(91.0/512.0),"23/128"},
    {(92.0/512.0),"23/128"},{(93.0/512.0),"47/256"},{(94.0/512.0),"47/256"},{(95.0/512.0),"3/16"},
    {(96.0/512.0),"3/16"},{(97.0/512.0),"49/256"},{(98.0/512.0),"49/256"},{(99.0/512.0),"25/128"},
    {(100.0/512.0),"25/128"},{(101.0/512.0),"51/256"},{(102.0/512.0),"51/256"},{(103.0/512.0),"13/64"},
    {(104.0/512.0),"13/64"},{(105.0/512.0),"53/256"},{(106.0/512.0),"53/256"},{(107.0/512.0),"27/128"},
    {(108.0/512.0),"27/128"},{(109.0/512.0),"55/256"},{(110.0/512.0),"55/256"},{(111.0/512.0),"7/32"},
    {(112.0/512.0),"7/32"},{(113.0/512.0),"57/256"},{(114.0/512.0),"57/256"},{(115.0/512.0),"29/128"},
    {(116.0/512.0),"29/128"},{(117.0/512.0),"59/256"},{(118.0/512.0),"59/256"},{(119.0/512.0),"15/64"},
    {(120.0/512.0),"15/64"},{(121.0/512.0),"61/256"},{(122.0/512.0),"61/256"},{(123.0/512.0),"31/128"},
    {(124.0/512.0),"31/128"},{(125.0/512.0),"63/256"},{(126.0/512.0),"63/256"},{(127.0/512.0),"1/4"},
    {(128.0/512.0),"1/4"},{(129.0/512.0),"65/256"},{(130.0/512.0),"65/256"},{(131.0/512.0),"33/128"},
    {(132.0/512.0),"33/128"},{(133.0/512.0),"67/256"},{(134.0/512.0),"67/256"},{(135.0/512.0),"17/64"},
    {(136.0/512.0),"17/64"},{(137.0/512.0),"69/256"},{(138.0/512.0),"69/256"},{(139.0/512.0),"35/128"},
    {(140.0/512.0),"35/128"},{(141.0/512.0),"71/256"},{(142.0/512.0),"71/256"},{(143.0/512.0),"9/32"},
    {(144.0/512.0),"9/32"},{(145.0/512.0),"73/256"},{(146.0/512.0),"73/256"},{(147.0/512.0),"37/128"},
    {(148.0/512.0),"37/128"},{(149.0/512.0),"75/256"},{(150.0/512.0),"75/256"},{(151.0/512.0),"19/64"},
    {(152.0/512.0),"19/64"},{(153.0/512.0),"77/256"},{(154.0/512.0),"77/256"},{(155.0/512.0),"39/128"},
    {(156.0/512.0),"39/128"},{(157.0/512.0),"79/256"},{(158.0/512.0),"79/256"},{(159.0/512.0),"5/16"},
    {(160.0/512.0),"5/16"},{(161.0/512.0),"81/256"},{(162.0/512.0),"81/256"},{(163.0/512.0),"41/128"},
    {(164.0/512.0),"41/128"},{(165.0/512.0),"83/256"},{(166.0/512.0),"83/256"},{(167.0/512.0),"21/64"},
    {(168.0/512.0),"21/64"},{(169.0/512.0),"85/256"},{(170.0/512.0),"85/256"},{(171.0/512.0),"43/128"},
    {(172.0/512.0),"43/128"},{(173.0/512.0),"87/256"},{(174.0/512.0),"87/256"},{(175.0/512.0),"11/32"},
    {(176.0/512.0),"11/32"},{(177.0/512.0),"89/256"},{(178.0/512.0),"89/256"},{(179.0/512.0),"45/128"},
    {(180.0/512.0),"45/128"},{(181.0/512.0),"91/256"},{(182.0/512.0),"91/256"},{(183.0/512.0),"23/64"},
    {(184.0/512.0),"23/64"},{(185.0/512.0),"93/256"},{(186.0/512.0),"93/256"},{(187.0/512.0),"47/128"},
    {(188.0/512.0),"47/128"},{(189.0/512.0),"95/256"},{(190.0/512.0),"95/256"},{(191.0/512.0),"3/8"},
    {(192.0/512.0),"3/8"},{(193.0/512.0),"97/256"},{(194.0/512.0),"97/256"},{(195.0/512.0),"49/128"},
    {(196.0/512.0),"49/128"},{(197.0/512.0),"99/256"},{(198.0/512.0),"99/256"},{(199.0/512.0),"25/64"},
    {(200.0/512.0),"25/64"},{(201.0/512.0),"101/256"},{(202.0/512.0),"101/256"},{(203.0/512.0),"51/128"},
    {(204.0/512.0),"51/128"},{(205.0/512.0),"103/256"},{(206.0/512.0),"103/256"},{(207.0/512.0),"13/32"},
    {(208.0/512.0),"13/32"},{(209.0/512.0),"105/256"},{(210.0/512.0),"105/256"},{(211.0/512.0),"53/128"},
    {(212.0/512.0),"53/128"},{(213.0/512.0),"107/256"},{(214.0/512.0),"107/256"},{(215.0/512.0),"27/64"},
    {(216.0/512.0),"27/64"},{(217.0/512.0),"109/256"},{(218.0/512.0),"109/256"},{(219.0/512.0),"55/128"},
    {(220.0/512.0),"55/128"},{(221.0/512.0),"111/256"},{(222.0/512.0),"111/256"},{(223.0/512.0),"7/16"},
    {(224.0/512.0),"7/16"},{(225.0/512.0),"113/256"},{(226.0/512.0),"113/256"},{(227.0/512.0),"57/128"},
    {(228.0/512.0),"57/128"},{(229.0/512.0),"115/256"},{(230.0/512.0),"115/256"},{(231.0/512.0),"29/64"},
    {(232.0/512.0),"29/64"},{(233.0/512.0),"117/256"},{(234.0/512.0),"117/256"},{(235.0/512.0),"59/128"},
    {(236.0/512.0),"59/128"},{(237.0/512.0),"119/256"},{(238.0/512.0),"119/256"},{(239.0/512.0),"15/32"},
    {(240.0/512.0),"15/32"},{(241.0/512.0),"121/256"},{(242.0/512.0),"121/256"},{(243.0/512.0),"61/128"},
    {(244.0/512.0),"61/128"},{(245.0/512.0),"123/256"},{(246.0/512.0),"123/256"},{(247.0/512.0),"31/64"},
    {(248.0/512.0),"31/64"},{(249.0/512.0),"125/256"},{(250.0/512.0),"125/256"},{(251.0/512.0),"63/128"},
    {(252.0/512.0),"63/128"},{(253.0/512.0),"127/256"},{(254.0/512.0),"127/256"},{(255.0/512.0),"1/2"},
    {(256.0/512.0),"1/2"},{(257.0/512.0),"129/256"},{(258.0/512.0),"129/256"},{(259.0/512.0),"65/128"},
    {(260.0/512.0),"65/128"},{(261.0/512.0),"131/256"},{(262.0/512.0),"131/256"},{(263.0/512.0),"33/64"},
    {(264.0/512.0),"33/64"},{(265.0/512.0),"133/256"},{(266.0/512.0),"133/256"},{(267.0/512.0),"67/128"},
    {(268.0/512.0),"67/128"},{(269.0/512.0),"135/256"},{(270.0/512.0),"135/256"},{(271.0/512.0),"17/32"},
    {(272.0/512.0),"17/32"},{(273.0/512.0),"137/256"},{(274.0/512.0),"137/256"},{(275.0/512.0),"69/128"},
    {(276.0/512.0),"69/128"},{(277.0/512.0),"139/256"},{(278.0/512.0),"139/256"},{(279.0/512.0),"35/64"},
    {(280.0/512.0),"35/64"},{(281.0/512.0),"141/256"},{(282.0/512.0),"141/256"},{(283.0/512.0),"71/128"},
    {(284.0/512.0),"71/128"},{(285.0/512.0),"143/256"},{(286.0/512.0),"143/256"},{(287.0/512.0),"9/16"},
    {(288.0/512.0),"9/16"},{(289.0/512.0),"145/256"},{(290.0/512.0),"145/256"},{(291.0/512.0),"73/128"},
    {(292.0/512.0),"73/128"},{(293.0/512.0),"147/256"},{(294.0/512.0),"147/256"},{(295.0/512.0),"37/64"},
    {(296.0/512.0),"37/64"},{(297.0/512.0),"149/256"},{(298.0/512.0),"149/256"},{(299.0/512.0),"75/128"},
    {(300.0/512.0),"75/128"},{(301.0/512.0),"151/256"},{(302.0/512.0),"151/256"},{(303.0/512.0),"19/32"},
    {(304.0/512.0),"19/32"},{(305.0/512.0),"153/256"},{(306.0/512.0),"153/256"},{(307.0/512.0),"77/128"},
    {(308.0/512.0),"77/128"},{(309.0/512.0),"155/256"},{(310.0/512.0),"155/256"},{(311.0/512.0),"39/64"},
    {(312.0/512.0),"39/64"},{(313.0/512.0),"157/256"},{(314.0/512.0),"157/256"},{(315.0/512.0),"79/128"},
    {(316.0/512.0),"79/128"},{(317.0/512.0),"159/256"},{(318.0/512.0),"159/256"},{(319.0/512.0),"5/8"},
    {(320.0/512.0),"5/8"},{(321.0/512.0),"161/256"},{(322.0/512.0),"161/256"},{(323.0/512.0),"81/128"},
    {(324.0/512.0),"81/128"},{(325.0/512.0),"163/256"},{(326.0/512.0),"163/256"},{(327.0/512.0),"41/64"},
    {(328.0/512.0),"41/64"},{(329.0/512.0),"165/256"},{(330.0/512.0),"165/256"},{(331.0/512.0),"83/128"},
    {(332.0/512.0),"83/128"},{(333.0/512.0),"167/256"},{(334.0/512.0),"167/256"},{(335.0/512.0),"21/32"},
    {(336.0/512.0),"21/32"},{(337.0/512.0),"169/256"},{(338.0/512.0),"169/256"},{(339.0/512.0),"85/128"},
    {(340.0/512.0),"85/128"},{(341.0/512.0),"171/256"},{(342.0/512.0),"171/256"},{(343.0/512.0),"43/64"},
    {(344.0/512.0),"43/64"},{(345.0/512.0),"173/256"},{(346.0/512.0),"173/256"},{(347.0/512.0),"87/128"},
    {(348.0/512.0),"87/128"},{(349.0/512.0),"175/256"},{(350.0/512.0),"175/256"},{(351.0/512.0),"11/16"},
    {(352.0/512.0),"11/16"},{(353.0/512.0),"177/256"},{(354.0/512.0),"177/256"},{(355.0/512.0),"89/128"},
    {(356.0/512.0),"89/128"},{(357.0/512.0),"179/256"},{(358.0/512.0),"179/256"},{(359.0/512.0),"45/64"},
    {(360.0/512.0),"45/64"},{(361.0/512.0),"181/256"},{(362.0/512.0),"181/256"},{(363.0/512.0),"91/128"},
    {(364.0/512.0),"91/128"},{(365.0/512.0),"183/256"},{(366.0/512.0),"183/256"},{(367.0/512.0),"23/32"},
    {(368.0/512.0),"23/32"},{(369.0/512.0),"185/256"},{(370.0/512.0),"185/256"},{(371.0/512.0),"93/128"},
    {(372.0/512.0),"93/128"},{(373.0/512.0),"187/256"},{(374.0/512.0),"187/256"},{(375.0/512.0),"47/64"},
    {(376.0/512.0),"47/64"},{(377.0/512.0),"189/256"},{(378.0/512.0),"189/256"},{(379.0/512.0),"95/128"},
    {(380.0/512.0),"95/128"},{(381.0/512.0),"191/256"},{(382.0/512.0),"191/256"},{(383.0/512.0),"3/4"},
    {(384.0/512.0),"3/4"},{(385.0/512.0),"193/256"},{(386.0/512.0),"193/256"},{(387.0/512.0),"97/128"},
    {(388.0/512.0),"97/128"},{(389.0/512.0),"195/256"},{(390.0/512.0),"195/256"},{(391.0/512.0),"49/64"},
    {(392.0/512.0),"49/64"},{(393.0/512.0),"197/256"},{(394.0/512.0),"197/256"},{(395.0/512.0),"99/128"},
    {(396.0/512.0),"99/128"},{(397.0/512.0),"199/256"},{(398.0/512.0),"199/256"},{(399.0/512.0),"25/32"},
    {(400.0/512.0),"25/32"},{(401.0/512.0),"201/256"},{(402.0/512.0),"201/256"},{(403.0/512.0),"101/128"},
    {(404.0/512.0),"101/128"},{(405.0/512.0),"203/256"},{(406.0/512.0),"203/256"},{(407.0/512.0),"51/64"},
    {(408.0/512.0),"51/64"},{(409.0/512.0),"205/256"},{(410.0/512.0),"205/256"},{(411.0/512.0),"103/128"},
    {(412.0/512.0),"103/128"},{(413.0/512.0),"207/256"},{(414.0/512.0),"207/256"},{(415.0/512.0),"13/16"},
    {(416.0/512.0),"13/16"},{(417.0/512.0),"209/256"},{(418.0/512.0),"209/256"},{(419.0/512.0),"105/128"},
    {(420.0/512.0),"105/128"},{(421.0/512.0),"211/256"},{(422.0/512.0),"211/256"},{(423.0/512.0),"53/64"},
    {(424.0/512.0),"53/64"},{(425.0/512.0),"213/256"},{(426.0/512.0),"213/256"},{(427.0/512.0),"107/128"},
    {(428.0/512.0),"107/128"},{(429.0/512.0),"215/256"},{(430.0/512.0),"215/256"},{(431.0/512.0),"27/32"},
    {(432.0/512.0),"27/32"},{(433.0/512.0),"217/256"},{(434.0/512.0),"217/256"},{(435.0/512.0),"109/128"},
    {(436.0/512.0),"109/128"},{(437.0/512.0),"219/256"},{(438.0/512.0),"219/256"},{(439.0/512.0),"55/64"},
    {(440.0/512.0),"55/64"},{(441.0/512.0),"221/256"},{(442.0/512.0),"221/256"},{(443.0/512.0),"111/128"},
    {(444.0/512.0),"111/128"},{(445.0/512.0),"223/256"},{(446.0/512.0),"223/256"},{(447.0/512.0),"7/8"},
    {(448.0/512.0),"7/8"},{(449.0/512.0),"225/256"},{(450.0/512.0),"225/256"},{(451.0/512.0),"113/128"},
    {(452.0/512.0),"113/128"},{(453.0/512.0),"227/256"},{(454.0/512.0),"227/256"},{(455.0/512.0),"57/64"},
    {(456.0/512.0),"57/64"},{(457.0/512.0),"229/256"},{(458.0/512.0),"229/256"},{(459.0/512.0),"115/128"},
    {(460.0/512.0),"115/128"},{(461.0/512.0),"231/256"},{(462.0/512.0),"231/256"},{(463.0/512.0),"29/32"},
    {(464.0/512.0),"29/32"},{(465.0/512.0),"233/256"},{(466.0/512.0),"233/256"},{(467.0/512.0),"117/128"},
    {(468.0/512.0),"117/128"},{(469.0/512.0),"235/256"},{(470.0/512.0),"235/256"},{(471.0/512.0),"59/64"},
    {(472.0/512.0),"59/64"},{(473.0/512.0),"237/256"},{(474.0/512.0),"237/256"},{(475.0/512.0),"119/128"},
    {(476.0/512.0),"119/128"},{(477.0/512.0),"239/256"},{(478.0/512.0),"239/256"},{(479.0/512.0),"15/16"},
    {(480.0/512.0),"15/16"},{(481.0/512.0),"241/256"},{(482.0/512.0),"241/256"},{(483.0/512.0),"121/128"},
    {(484.0/512.0),"121/128"},{(485.0/512.0),"243/256"},{(486.0/512.0),"243/256"},{(487.0/512.0),"61/64"},
    {(488.0/512.0),"61/64"},{(489.0/512.0),"245/256"},{(490.0/512.0),"245/256"},{(491.0/512.0),"123/128"},
    {(492.0/512.0),"123/128"},{(493.0/512.0),"247/256"},{(494.0/512.0),"247/256"},{(495.0/512.0),"31/32"},
    {(496.0/512.0),"31/32"},{(497.0/512.0),"249/256"},{(498.0/512.0),"249/256"},{(499.0/512.0),"125/128"},
    {(500.0/512.0),"125/128"},{(501.0/512.0),"251/256"},{(502.0/512.0),"251/256"},{(503.0/512.0),"63/64"},
    {(504.0/512.0),"63/64"},{(505.0/512.0),"253/256"},{(506.0/512.0),"253/256"},{(507.0/512.0),"127/128"},
    {(508.0/512.0),"127/128"},{(509.0/512.0),"255/256"},{(510.0/512.0),"255/256"},{(511.0/512.0),"1/1"},
    
  }
};

