/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.merge;

import java.io.File;
import net.sourceforge.cobertura.dsl.ArgumentsBuilder;
import net.sourceforge.cobertura.dsl.Cobertura;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.Header;

public class MergeMain {
    public MergeMain(String[] args) {
        ArgumentsBuilder builder = new ArgumentsBuilder();
        String baseDir = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--datafile")) {
                builder.setDataFile(args[++i]);
                continue;
            }
            if (args[i].equals("--basedir")) {
                baseDir = args[++i];
                builder.setBaseDirectory(baseDir);
                continue;
            }
            if (baseDir != null) {
                builder.addFileToMerge(new File(baseDir, args[i]).getAbsolutePath());
                continue;
            }
            builder.addFileToMerge(new File(args[i]).getAbsolutePath());
        }
        new Cobertura(builder.build()).merge().saveProjectData();
    }

    public static int merge(String[] args) {
        Header.print(System.out);
        try {
            args = CommandLineBuilder.preprocessCommandLineArguments(args);
        }
        catch (Exception ex) {
            System.err.println("Error: Cannot process arguments: " + ex.getMessage());
            return 1;
        }
        new MergeMain(args);
        return 0;
    }

    public static void main(String[] args) {
        int returnValue = MergeMain.merge(args);
        if (returnValue != 0) {
            System.exit(returnValue);
        }
    }
}

