// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file Benchmark_small.h
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifndef _BENCHMARK_SMALL_H_
#define _BENCHMARK_SMALL_H_

// TODO Poner en el contexto.

#include <stdint.h>
#include <array>
#include <string>
#include <vector>
#include <map>
#include <bitset>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif
#else
#define eProsima_user_DllExport
#endif

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(Benchmark_small_SOURCE)
#define Benchmark_small_DllAPI __declspec( dllexport )
#else
#define Benchmark_small_DllAPI __declspec( dllimport )
#endif // Benchmark_small_SOURCE
#else
#define Benchmark_small_DllAPI
#endif
#else
#define Benchmark_small_DllAPI
#endif // _WIN32

namespace eprosima
{
    namespace fastcdr
    {
        class Cdr;
    }
}


/*!
 * @brief This class represents the structure BenchMarkSmall defined by the user in the IDL file.
 * @ingroup BENCHMARK_SMALL
 */
class BenchMarkSmall
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BenchMarkSmall();

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BenchMarkSmall();

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BenchMarkSmall that will be copied.
     */
    eProsima_user_DllExport BenchMarkSmall(const BenchMarkSmall &x);

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BenchMarkSmall that will be copied.
     */
    eProsima_user_DllExport BenchMarkSmall(BenchMarkSmall &&x);

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BenchMarkSmall that will be copied.
     */
    eProsima_user_DllExport BenchMarkSmall& operator=(const BenchMarkSmall &x);

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BenchMarkSmall that will be copied.
     */
    eProsima_user_DllExport BenchMarkSmall& operator=(BenchMarkSmall &&x);

    /*!
     * @brief This function copies the value in member array
     * @param _array New value to be copied in member array
     */
    eProsima_user_DllExport void array(const std::array<char, 16384> &_array);

    /*!
     * @brief This function moves the value in member array
     * @param _array New value to be moved in member array
     */
    eProsima_user_DllExport void array(std::array<char, 16384> &&_array);

    /*!
     * @brief This function returns a constant reference to member array
     * @return Constant reference to member array
     */
    eProsima_user_DllExport const std::array<char, 16384>& array() const;

    /*!
     * @brief This function returns a reference to member array
     * @return Reference to member array
     */
    eProsima_user_DllExport std::array<char, 16384>& array();
    /*!
     * @brief This function sets a value in member index
     * @param _index New value for member index
     */
    eProsima_user_DllExport void index(uint32_t _index);

    /*!
     * @brief This function returns the value of member index
     * @return Value of member index
     */
    eProsima_user_DllExport uint32_t index() const;

    /*!
     * @brief This function returns a reference to member index
     * @return Reference to member index
     */
    eProsima_user_DllExport uint32_t& index();


    /*!
     * @brief This function returns the maximum serialized size of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    eProsima_user_DllExport static size_t getMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function returns the serialized size of a data depending on the buffer alignment.
     * @param data Data which is calculated its serialized size.
     * @param current_alignment Buffer alignment.
     * @return Serialized size.
     */
    eProsima_user_DllExport static size_t getCdrSerializedSize(const BenchMarkSmall& data, size_t current_alignment = 0);


    /*!
     * @brief This function serializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void serialize(eprosima::fastcdr::Cdr &cdr) const;

    /*!
     * @brief This function deserializes an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void deserialize(eprosima::fastcdr::Cdr &cdr);



    /*!
     * @brief This function returns the maximum serialized size of the Key of an object
     * depending on the buffer alignment.
     * @param current_alignment Buffer alignment.
     * @return Maximum serialized size.
     */
    eProsima_user_DllExport static size_t getKeyMaxCdrSerializedSize(size_t current_alignment = 0);

    /*!
     * @brief This function tells you if the Key has been defined for this type
     */
    eProsima_user_DllExport static bool isKeyDefined();

    /*!
     * @brief This function serializes the key members of an object using CDR serialization.
     * @param cdr CDR serialization object.
     */
    eProsima_user_DllExport void serializeKey(eprosima::fastcdr::Cdr &cdr) const;

private:
    std::array<char, 16384> m_array;
    uint32_t m_index;
};

#endif // _BENCHMARK_SMALL_H_