/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import java.io.Serializable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.management.CacheConfigurationMBean;

public class CacheConfiguration
implements CacheConfigurationMBean,
Serializable {
    private static final long serialVersionUID = -8944774509593267228L;
    private transient net.sf.ehcache.config.CacheConfiguration cacheConfiguration;
    private ObjectName objectName;

    public CacheConfiguration(Ehcache cache) {
        this.cacheConfiguration = cache.getCacheConfiguration();
        this.objectName = CacheConfiguration.createObjectName(cache.getCacheManager().toString(), cache.getName());
    }

    static ObjectName createObjectName(String cacheManagerName, String cacheName) {
        ObjectName objectName;
        try {
            objectName = new ObjectName("net.sf.ehcache:type=CacheConfiguration,CacheManager=" + cacheManagerName + ",name=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException(e);
        }
        return objectName;
    }

    public String getName() {
        return this.cacheConfiguration.getName();
    }

    public int getMaxElementsInMemory() {
        return this.cacheConfiguration.getMaxElementsInMemory();
    }

    public int getMaxElementsOnDisk() {
        return this.cacheConfiguration.getMaxElementsOnDisk();
    }

    public String getMemoryStoreEvictionPolicy() {
        return this.cacheConfiguration.getMemoryStoreEvictionPolicy().toString();
    }

    public boolean isEternal() {
        return this.cacheConfiguration.isEternal();
    }

    public long getTimeToIdleSeconds() {
        return this.cacheConfiguration.getTimeToIdleSeconds();
    }

    public long getTimeToLiveSeconds() {
        return this.cacheConfiguration.getTimeToLiveSeconds();
    }

    public boolean isOverflowToDisk() {
        return this.cacheConfiguration.isOverflowToDisk();
    }

    public boolean isDiskPersistent() {
        return this.cacheConfiguration.isDiskPersistent();
    }

    public int getDiskSpoolBufferSizeMB() {
        return this.cacheConfiguration.getDiskSpoolBufferSizeMB();
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.cacheConfiguration.getDiskExpiryThreadIntervalSeconds();
    }

    ObjectName getObjectName() {
        return this.objectName;
    }
}

