#include "gm-iuserlist.h"
#include "gm-marshal.h"

static void gm_iuserlist_base_init(gpointer object_class);

GType 
gm_iuserlist_get_type() {
	static GType iuserlist_type = 0;
	
	if (iuserlist_type == 0) {
		static const GTypeInfo iuserlist_info = {
			sizeof (GmIUserlistInterface),
			gm_iuserlist_base_init,   /* base_init */
			NULL,   /* base_finalize */
			NULL,   /* class_init */
			NULL,   /* class_finalize */
			NULL,   /* class_data */
			0,
			0,      /* n_preallocs */
			NULL    /* instance_init */
		};

		iuserlist_type = g_type_register_static(G_TYPE_INTERFACE, 
				"GmIUserlist", &iuserlist_info, 0);
	}

	return iuserlist_type;
}

static void
gm_iuserlist_base_init(gpointer object_class) {
	static gboolean initialized = FALSE;
	
	if (!initialized) {
		g_signal_new("player_added",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmIUserlistInterface, player_added),
			NULL, NULL,
			g_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);
		g_signal_new("player_removed",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmIUserlistInterface, player_removed),
			NULL, NULL,
			g_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);	
		g_signal_new("name_changed",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmIUserlistInterface, name_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);
		g_signal_new("state_changed",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmIUserlistInterface, state_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);
		g_signal_new("rank_changed",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmIUserlistInterface, rank_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);
		
		initialized = TRUE;
	}
}

GList *
gm_iuserlist_get_menu(GmIUserlist *self, gint id) {
	GmIUserlistInterface *iface;
	
	g_return_val_if_fail(GM_IS_IUSERLIST(self), NULL);

	iface = GM_IUSERLIST_GET_INTERFACE(self);

	if (iface->get_menu) {
		return (* iface->get_menu) (self, id);
	} else {
		return NULL;
	}
}

gboolean
gm_iuserlist_supports_status(GmIUserlist *self) {
	GmIUserlistInterface *iface;
	
	g_return_val_if_fail(GM_IS_IUSERLIST(self), FALSE);
	
	iface = GM_IUSERLIST_GET_INTERFACE(self);
	
	return (iface->get_status != NULL);
}

gchar *
gm_iuserlist_get_status(GmIUserlist *self, gint id) {
	GmIUserlistInterface *iface;
	
	g_return_val_if_fail(GM_IS_IUSERLIST(self), NULL);
	
	iface = GM_IUSERLIST_GET_INTERFACE(self);
	
	if (iface->get_status) {
		return (* iface->get_status) (self, id);
	} else {
		return NULL;
	}
}

gchar const *
gm_iuserlist_get_name(GmIUserlist *self, gint id) {
	GmIUserlistInterface *iface;
	
	g_return_val_if_fail(GM_IS_IUSERLIST(self), NULL);
	
	iface = GM_IUSERLIST_GET_INTERFACE(self);
	
	if (iface->get_name) {
		return (* iface->get_name) (self, id);
	} else {
		return NULL;
	}
}

gchar const *
gm_iuserlist_get_icon(GmIUserlist *self, gint id, gboolean use_state) {
	GmIUserlistInterface *iface;
	
	g_return_val_if_fail(GM_IS_IUSERLIST(self), NULL);
	
	iface = GM_IUSERLIST_GET_INTERFACE(self);
	
	if (iface->get_icon) {
		return (* iface->get_icon) (self, id, use_state);
	} else {
		return NULL;
	}
}

gint 
gm_iuserlist_get_rank_priority(GmIUserlist *self, gint id) {
	GmIUserlistInterface *iface;
	
	g_return_val_if_fail(GM_IS_IUSERLIST(self), 0);
	
	iface = GM_IUSERLIST_GET_INTERFACE(self);
	
	if (iface->get_rank_priority) {
		return (* iface->get_rank_priority) (self, id);
	} else {
		return 0;
	}
}

gint
gm_iuserlist_get_state_priority(GmIUserlist *self, gint id) {
	GmIUserlistInterface *iface;
	
	g_return_val_if_fail(GM_IS_IUSERLIST(self), 0);
	
	iface = GM_IUSERLIST_GET_INTERFACE(self);
	
	if (iface->get_state_priority) {
		return (* iface->get_state_priority) (self, id);
	} else {
		return 0;
	}
}
