/*
     This file is part of GNUnet.
     (C) 2012 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/gns/gnunet-gns-gtk.h
 * @brief Main function header of gnunet-gns-gtk
 * @author Christian Grothoff
 */
#include "gnunet_gtk.h"
#include <gnunet/gnunet_namestore_service.h>

#define NEW_NAME_STR "<new name>"
#define NEW_RECORD_STR "<new record>"
#define ROOT_STR "+"
#define EXPIRE_NEVER_STRING "never"
#define EXPIRE_INVALID_STRING "invalid"
#define PSEU_EMPTY_STR "<empty>"


struct GNUNET_GNS_Context
{
  /**
   * Handle to the namestore.
   */
  struct GNUNET_NAMESTORE_Handle *ns;

  GtkCheckMenuItem *shorten_menu;

  GtkBuilder *builder;

  GtkWidget *main_window;

  GtkTreeStore *ts;
  GtkListStore *ls;
  GtkTreeModel *tm;
  GtkTreeView *tv;

  struct GNUNET_CRYPTO_RsaPrivateKey *pkey;
  struct GNUNET_CRYPTO_RsaPublicKeyBinaryEncoded pubkey;

  struct GNUNET_CRYPTO_ShortHashCode zone;
  int iteration;
};






/* end of gnunet-gns-gtk.h */
