
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQThread.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QThread>
#include <QChildEvent>
#include <QEvent>
#include <QObject>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QThread

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QThread::staticMetaObject);
}


// void QThread::exit(int retcode)


static void _init_f_exit_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("retcode", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_exit_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread *)cls)->exit (arg1);
}


// bool QThread::isFinished()


static void _init_f_isFinished_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFinished_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QThread *)cls)->isFinished ());
}


// bool QThread::isRunning()


static void _init_f_isRunning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRunning_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QThread *)cls)->isRunning ());
}


// QThread::Priority QThread::priority()


static void _init_f_priority_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QThread::Priority>::target_type > ();
}

static void _call_f_priority_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QThread::Priority>::target_type > ((qt_gsi::Converter<QThread::Priority>::target_type)qt_gsi::CppToQtAdaptor<QThread::Priority>(((QThread *)cls)->priority ()));
}


// void QThread::quit()


static void _init_f_quit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_quit_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread *)cls)->quit ();
}


// void QThread::setPriority(QThread::Priority priority)


static void _init_f_setPriority_2099 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("priority");
  decl->add_arg<const qt_gsi::Converter<QThread::Priority>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPriority_2099 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QThread::Priority>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QThread::Priority>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread *)cls)->setPriority (qt_gsi::QtToCppAdaptor<QThread::Priority>(arg1).cref());
}


// void QThread::setStackSize(unsigned int stackSize)


static void _init_f_setStackSize_1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stackSize");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStackSize_1772 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread *)cls)->setStackSize (arg1);
}


// unsigned int QThread::stackSize()


static void _init_f_stackSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_stackSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QThread *)cls)->stackSize ());
}


// void QThread::start(QThread::Priority)


static void _init_f_start_2099 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QThread::InheritPriority");
  decl->add_arg<const qt_gsi::Converter<QThread::Priority>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_start_2099 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QThread::Priority>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QThread::Priority>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QThread::Priority>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QThread::Priority>(heap, QThread::InheritPriority), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread *)cls)->start (qt_gsi::QtToCppAdaptor<QThread::Priority>(arg1).cref());
}


// void QThread::terminate()


static void _init_f_terminate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_terminate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread *)cls)->terminate ();
}


// bool QThread::wait(unsigned long int time)


static void _init_f_wait_2348 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time", true, "ULONG_MAX");
  decl->add_arg<unsigned long int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_wait_2348 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned long int arg1 = args ? gsi::arg_reader<unsigned long int >() (args, heap) : gsi::arg_maker<unsigned long int >() (ULONG_MAX, heap);
  ret.write<bool > ((bool)((QThread *)cls)->wait (arg1));
}


// static QThread *QThread::currentThread()


static void _init_f_currentThread_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QThread * > ();
}

static void _call_f_currentThread_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QThread * > ((QThread *)QThread::currentThread ());
}


// static Qt::HANDLE QThread::currentThreadId()


static void _init_f_currentThreadId_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<Qt::HANDLE > ();
}

static void _call_f_currentThreadId_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<Qt::HANDLE > ((Qt::HANDLE)QThread::currentThreadId ());
}


// static int QThread::idealThreadCount()


static void _init_f_idealThreadCount_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_idealThreadCount_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QThread::idealThreadCount ());
}


// static QString QThread::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QThread::tr (arg1, arg2));
}


// static QString QThread::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QThread::tr (arg1, arg2, arg3));
}


// static QString QThread::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QThread::trUtf8 (arg1, arg2));
}


// static QString QThread::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QThread::trUtf8 (arg1, arg2, arg3));
}


// static void QThread::yieldCurrentThread()


static void _init_f_yieldCurrentThread_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_yieldCurrentThread_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QThread::yieldCurrentThread ();
}


namespace gsi
{

static gsi::Methods methods_QThread () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("exit", "@brief Method void QThread::exit(int retcode)\n", false, &_init_f_exit_767, &_call_f_exit_767);
  methods += new qt_gsi::GenericMethod ("isFinished?", "@brief Method bool QThread::isFinished()\n", true, &_init_f_isFinished_c0, &_call_f_isFinished_c0);
  methods += new qt_gsi::GenericMethod ("isRunning?", "@brief Method bool QThread::isRunning()\n", true, &_init_f_isRunning_c0, &_call_f_isRunning_c0);
  methods += new qt_gsi::GenericMethod (":priority", "@brief Method QThread::Priority QThread::priority()\n", true, &_init_f_priority_c0, &_call_f_priority_c0);
  methods += new qt_gsi::GenericMethod ("quit", "@brief Method void QThread::quit()\n", false, &_init_f_quit_0, &_call_f_quit_0);
  methods += new qt_gsi::GenericMethod ("setPriority|priority=", "@brief Method void QThread::setPriority(QThread::Priority priority)\n", false, &_init_f_setPriority_2099, &_call_f_setPriority_2099);
  methods += new qt_gsi::GenericMethod ("setStackSize|stackSize=", "@brief Method void QThread::setStackSize(unsigned int stackSize)\n", false, &_init_f_setStackSize_1772, &_call_f_setStackSize_1772);
  methods += new qt_gsi::GenericMethod (":stackSize", "@brief Method unsigned int QThread::stackSize()\n", true, &_init_f_stackSize_c0, &_call_f_stackSize_c0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QThread::start(QThread::Priority)\n", false, &_init_f_start_2099, &_call_f_start_2099);
  methods += new qt_gsi::GenericMethod ("terminate", "@brief Method void QThread::terminate()\n", false, &_init_f_terminate_0, &_call_f_terminate_0);
  methods += new qt_gsi::GenericMethod ("wait", "@brief Method bool QThread::wait(unsigned long int time)\n", false, &_init_f_wait_2348, &_call_f_wait_2348);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QThread::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QThread::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("started()", "started", "@brief Signal declaration for QThread::started()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("terminated()", "terminated", "@brief Signal declaration for QThread::terminated()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("currentThread", "@brief Static method QThread *QThread::currentThread()\nThis method is static and can be called without an instance.", &_init_f_currentThread_0, &_call_f_currentThread_0);
  methods += new qt_gsi::GenericStaticMethod ("currentThreadId", "@brief Static method Qt::HANDLE QThread::currentThreadId()\nThis method is static and can be called without an instance.", &_init_f_currentThreadId_0, &_call_f_currentThreadId_0);
  methods += new qt_gsi::GenericStaticMethod ("idealThreadCount", "@brief Static method int QThread::idealThreadCount()\nThis method is static and can be called without an instance.", &_init_f_idealThreadCount_0, &_call_f_idealThreadCount_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QThread::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QThread::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QThread::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QThread::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericStaticMethod ("yieldCurrentThread", "@brief Static method void QThread::yieldCurrentThread()\nThis method is static and can be called without an instance.", &_init_f_yieldCurrentThread_0, &_call_f_yieldCurrentThread_0);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QThread> decl_QThread (qtdecl_QObject (), "QtCore", "QThread_Native",
  methods_QThread (),
  "@hide\n@alias QThread");

GSI_QTCORE_PUBLIC gsi::Class<QThread> &qtdecl_QThread () { return decl_QThread; }

}


class QThread_Adaptor : public QThread, public qt_gsi::QtObjectBase
{
public:

  virtual ~QThread_Adaptor();

  //  [adaptor ctor] QThread::QThread(QObject *parent)
  QThread_Adaptor() : QThread()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QThread::QThread(QObject *parent)
  QThread_Adaptor(QObject *parent) : QThread(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QThread::exec()
  int fp_QThread_exec_0 () {
    return QThread::exec();
  }

  //  [expose] void QThread::msleep(unsigned long int)
  static void fp_QThread_msleep_2348 (unsigned long int arg1) {
    QThread::msleep(arg1);
  }

  //  [expose] int QThread::receivers(const char *signal)
  int fp_QThread_receivers_c1731 (const char *signal) const {
    return QThread::receivers(signal);
  }

  //  [expose] QObject *QThread::sender()
  QObject * fp_QThread_sender_c0 () const {
    return QThread::sender();
  }

  //  [expose] void QThread::setTerminationEnabled(bool enabled)
  static void fp_QThread_setTerminationEnabled_864 (bool enabled) {
    QThread::setTerminationEnabled(enabled);
  }

  //  [expose] void QThread::sleep(unsigned long int)
  static void fp_QThread_sleep_2348 (unsigned long int arg1) {
    QThread::sleep(arg1);
  }

  //  [expose] void QThread::usleep(unsigned long int)
  static void fp_QThread_usleep_2348 (unsigned long int arg1) {
    QThread::usleep(arg1);
  }

  //  [adaptor impl] bool QThread::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QThread::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QThread_Adaptor, bool, QEvent *>(&QThread_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QThread::event(arg1);
    }
  }

  //  [adaptor impl] bool QThread::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QThread::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QThread_Adaptor, bool, QObject *, QEvent *>(&QThread_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QThread::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QThread::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QThread::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QThread_Adaptor, QChildEvent *>(&QThread_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QThread::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QThread::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QThread::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QThread_Adaptor, QEvent *>(&QThread_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QThread::customEvent(arg1);
    }
  }

  //  [emitter impl] void QThread::destroyed(QObject *)
  void emitter_QThread_destroyed_1302(QObject *arg1)
  {
    emit QThread::destroyed(arg1);
  }

  //  [adaptor impl] void QThread::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QThread::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QThread_Adaptor, const char *>(&QThread_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QThread::disconnectNotify(signal);
    }
  }

  //  [emitter impl] void QThread::finished()
  void emitter_QThread_finished_0()
  {
    emit QThread::finished();
  }

  //  [adaptor impl] void QThread::run()
  void cbs_run_0_0()
  {
    QThread::run();
  }

  virtual void run()
  {
    if (cb_run_0_0.can_issue()) {
      cb_run_0_0.issue<QThread_Adaptor>(&QThread_Adaptor::cbs_run_0_0);
    } else {
      QThread::run();
    }
  }

  //  [emitter impl] void QThread::started()
  void emitter_QThread_started_0()
  {
    emit QThread::started();
  }

  //  [emitter impl] void QThread::terminated()
  void emitter_QThread_terminated_0()
  {
    emit QThread::terminated();
  }

  //  [adaptor impl] void QThread::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QThread::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QThread_Adaptor, QTimerEvent *>(&QThread_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QThread::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_run_0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QThread_Adaptor::~QThread_Adaptor() { }

//  Constructor QThread::QThread(QObject *parent) (adaptor class)

static void _init_ctor_QThread_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QThread_Adaptor> ();
}

static void _call_ctor_QThread_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QThread_Adaptor *> (new QThread_Adaptor (arg1));
}


// void QThread::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QThread::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QThread::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QThread_Adaptor *)cls)->emitter_QThread_destroyed_1302 (arg1);
}


// void QThread::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QThread::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QThread_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QThread::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QThread_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed int QThread::exec()

static void _init_fp_exec_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_exec_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QThread_Adaptor *)cls)->fp_QThread_exec_0 ());
}


// emitter void QThread::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QThread_Adaptor *)cls)->emitter_QThread_finished_0 ();
}


// exposed void QThread::msleep(unsigned long int)

static void _init_fp_msleep_2348 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned long int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_msleep_2348 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned long int arg1 = gsi::arg_reader<unsigned long int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QThread_Adaptor::fp_QThread_msleep_2348 (arg1);
}


// exposed int QThread::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QThread_Adaptor *)cls)->fp_QThread_receivers_c1731 (arg1));
}


// void QThread::run()

static void _init_cbs_run_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_run_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread_Adaptor *)cls)->cbs_run_0_0 ();
}

static void _set_callback_cbs_run_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_run_0_0 = cb;
}


// exposed QObject *QThread::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QThread_Adaptor *)cls)->fp_QThread_sender_c0 ());
}


// exposed void QThread::setTerminationEnabled(bool enabled)

static void _init_fp_setTerminationEnabled_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setTerminationEnabled_864 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QThread_Adaptor::fp_QThread_setTerminationEnabled_864 (arg1);
}


// exposed void QThread::sleep(unsigned long int)

static void _init_fp_sleep_2348 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned long int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_sleep_2348 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned long int arg1 = gsi::arg_reader<unsigned long int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QThread_Adaptor::fp_QThread_sleep_2348 (arg1);
}


// emitter void QThread::started()

static void _init_emitter_started_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_started_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QThread_Adaptor *)cls)->emitter_QThread_started_0 ();
}


// emitter void QThread::terminated()

static void _init_emitter_terminated_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_terminated_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QThread_Adaptor *)cls)->emitter_QThread_terminated_0 ();
}


// void QThread::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QThread_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QThread_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QThread::usleep(unsigned long int)

static void _init_fp_usleep_2348 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned long int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_usleep_2348 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned long int arg1 = gsi::arg_reader<unsigned long int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QThread_Adaptor::fp_QThread_usleep_2348 (arg1);
}


namespace gsi
{

gsi::Class<QThread> &qtdecl_QThread ();

static gsi::Methods methods_QThread_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QThread::QThread(QObject *parent)\nThis method creates an object of class QThread.", &_init_ctor_QThread_Adaptor_1302, &_call_ctor_QThread_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QThread::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QThread::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QThread::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QThread::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QThread::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QThread::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*exec", "@brief Method int QThread::exec()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_exec_0, &_call_fp_exec_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QThread::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericStaticMethod ("*msleep", "@brief Method void QThread::msleep(unsigned long int)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_msleep_2348, &_call_fp_msleep_2348);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QThread::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*run", "@brief Virtual method void QThread::run()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_run_0_0, &_call_cbs_run_0_0);
  methods += new qt_gsi::GenericMethod ("*run", "@hide", false, &_init_cbs_run_0_0, &_call_cbs_run_0_0, &_set_callback_cbs_run_0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QThread::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericStaticMethod ("*setTerminationEnabled", "@brief Method void QThread::setTerminationEnabled(bool enabled)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_setTerminationEnabled_864, &_call_fp_setTerminationEnabled_864);
  methods += new qt_gsi::GenericStaticMethod ("*sleep", "@brief Method void QThread::sleep(unsigned long int)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_sleep_2348, &_call_fp_sleep_2348);
  methods += new qt_gsi::GenericMethod ("emit_started", "@brief Emitter for signal void QThread::started()\nCall this method to emit this signal.", false, &_init_emitter_started_0, &_call_emitter_started_0);
  methods += new qt_gsi::GenericMethod ("emit_terminated", "@brief Emitter for signal void QThread::terminated()\nCall this method to emit this signal.", false, &_init_emitter_terminated_0, &_call_emitter_terminated_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QThread::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericStaticMethod ("*usleep", "@brief Method void QThread::usleep(unsigned long int)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_usleep_2348, &_call_fp_usleep_2348);
  return methods;
}

gsi::Class<QThread_Adaptor> decl_QThread_Adaptor (qtdecl_QThread (), "QtCore", "QThread",
  methods_QThread_Adaptor (),
  "@qt\n@brief Binding of QThread");

}


//  Implementation of the enum wrapper class for QThread::Priority
namespace qt_gsi
{

static gsi::Enum<QThread::Priority> decl_QThread_Priority_Enum ("QtCore", "QThread_Priority",
    gsi::enum_const ("IdlePriority", QThread::IdlePriority, "@brief Enum constant QThread::IdlePriority") +
    gsi::enum_const ("LowestPriority", QThread::LowestPriority, "@brief Enum constant QThread::LowestPriority") +
    gsi::enum_const ("LowPriority", QThread::LowPriority, "@brief Enum constant QThread::LowPriority") +
    gsi::enum_const ("NormalPriority", QThread::NormalPriority, "@brief Enum constant QThread::NormalPriority") +
    gsi::enum_const ("HighPriority", QThread::HighPriority, "@brief Enum constant QThread::HighPriority") +
    gsi::enum_const ("HighestPriority", QThread::HighestPriority, "@brief Enum constant QThread::HighestPriority") +
    gsi::enum_const ("TimeCriticalPriority", QThread::TimeCriticalPriority, "@brief Enum constant QThread::TimeCriticalPriority") +
    gsi::enum_const ("InheritPriority", QThread::InheritPriority, "@brief Enum constant QThread::InheritPriority"),
  "@qt\n@brief This class represents the QThread::Priority enum");

static gsi::QFlagsClass<QThread::Priority > decl_QThread_Priority_Enums ("QtCore", "QThread_QFlags_Priority",
  "@qt\n@brief This class represents the QFlags<QThread::Priority> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QThread> inject_QThread_Priority_Enum_in_parent (decl_QThread_Priority_Enum.defs ());
static gsi::ClassExt<QThread> decl_QThread_Priority_Enum_as_child (decl_QThread_Priority_Enum, "Priority");
static gsi::ClassExt<QThread> decl_QThread_Priority_Enums_as_child (decl_QThread_Priority_Enums, "QFlags_Priority");

}

