/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef CONNECTIONMANAGER_H
#define CONNECTIONMANAGER_H

#include <QtCore/QList>
#include <QtCore/QString>

class ConnectionInfo
{
  public:
    typedef QList<ConnectionInfo> List;

    ConnectionInfo();
    ConnectionInfo( const QString &name );

    bool isValid() const;

    QString name() const;

    void setHost( const QString &host );
    QString host() const;

    void setPort( int port );
    int port() const;

    void setBaseDn( const QString &baseDn );
    QString baseDn() const;

    void setNobodyUser( const QString &nobodyUser );
    QString nobodyUser() const;

    void setNobodyPassword( const QString &nobodyPassword );
    QString nobodyPassword() const;

  private:
    QString mName;
    QString mHost;
    int mPort;
    QString mBaseDn;
    QString mNobodyUser;
    QString mNobodyPassword;
};

class ConnectionInfoManager
{
  public:
    ConnectionInfoManager();

    bool contains( const QString &name ) const;

    ConnectionInfo::List connectionInfos() const;
    ConnectionInfo connectionInfo( const QString &name ) const;

    void appendConnectionInfo( const ConnectionInfo &connectionInfo );
    void removeConnectionInfo( const QString &name );

    void load();
    void save();

  private:
    ConnectionInfo::List mConnectionInfos;
};

#endif
