/*
 * @(#)CoveragePostCompilerTaskUTest.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.ant;


import java.io.File;
import java.io.IOException;
import java.util.Properties;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;


/**
 * Tests the CoveragePostCompilerTask class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     February 25, 2004
 */
public class CoveragePostCompilerTaskUTest extends AntTestA
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = CoveragePostCompilerTaskUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public CoveragePostCompilerTaskUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    private static final Properties EXPECTED_1 = new Properties();
    static {
        EXPECTED_1.setProperty( "factory",
            "net.sourceforge.groboutils.codecoverage.v2.logger.DirectoryChannelLoggerFactory" );
        EXPECTED_1.setProperty( "channel-count", "16" );
    }
    public void testConfiguration1()
            throws IOException
    {
        CoveragePostCompilerTask.Configuration c =
            new CoveragePostCompilerTask.Configuration();
        addTempFile( new File( "./grobocoverage.properties" ) );
        c.generatePropertyFile( new File("."), 16 );
        Properties actual = loadGroboProperties();
        assertEquals( "default values weren't set right",
            EXPECTED_1,
            actual );
    }
    
    
    private static final Properties EXPECTED_2 = new Properties();
    static {
        EXPECTED_2.setProperty( "factory",
            "net.sourceforge.groboutils.codecoverage.v2.logger.DirectoryChannelLoggerFactory" );
        EXPECTED_2.setProperty( "channel-count", "17" );
        EXPECTED_2.setProperty( "logger.cache-size", "333" );
    }
    public void testConfiguration2()
            throws IOException
    {
        DOC.getIT().testsIssue( 903797 );
        
        CoveragePostCompilerTask.Configuration c =
            new CoveragePostCompilerTask.Configuration();
        c.setCacheSize( 333 );
        
        addTempFile( new File( "./grobocoverage.properties" ) );
        c.generatePropertyFile( new File("."), 17 );
        Properties actual = loadGroboProperties();
        assertEquals( "cache-size set values weren't set right",
            EXPECTED_2,
            actual );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected void assertEquals( String text, Properties expected,
            Properties actual )
    {
        PropertyCheckUtil.assertEquals( text, expected, actual );
    }
    

    protected Properties loadGroboProperties()
            throws IOException
    {
        return PropertyCheckUtil.loadGroboProperties();
    }
    
    
    protected Properties loadProperties( String file )
            throws IOException
    {
        return PropertyCheckUtil.loadProperties( file );
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
        configureProject( "postcompiler.xml" );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

