/*
 *  @(#)AutoDocTPSet.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.autodoc.v1.defimpl;


import net.sourceforge.groboutils.autodoc.v1.AutoDocTP;

import java.util.Vector;
import java.util.Enumeration;
 

/**
 * Test Procedure entry point.  Generates Test Procedure documentation.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:11 $
 * @since      June 28, 2002
 */
public class AutoDocTPSet implements AutoDocTP, IAutoDocSet
{
    private Vector set = new Vector();
    
    public void addTP( AutoDocTP tp )
    {
        this.set.addElement( tp );
    }
    
    
    public Enumeration getSetContents()
    {
        return this.set.elements();
    }
    
    
    /**
     * Defines a step which occurs during the test setup phase.
     *
     * @param description the text describing the step.
     */
    public void setupStep( String description )
    {
        Enumeration enum = getSetContents();
        while (enum.hasMoreElements())
        {
            ((AutoDocTP)enum.nextElement()).setupStep( description );
        }
    }
    
    
    /**
     * Defines a step which occurs during the test tear-down phase.
     *
     * @param description the text describing the step.
     */
    public void teardownStep( String description )
    {
        Enumeration enum = getSetContents();
        while (enum.hasMoreElements())
        {
            ((AutoDocTP)enum.nextElement()).teardownStep( description );
        }
    }
    
    
    /**
     * Defines a step which occurs during the test proper.
     *
     * @param description the text describing the step.
     */
    public void step( String description )
    {
        Enumeration enum = getSetContents();
        while (enum.hasMoreElements())
        {
            ((AutoDocTP)enum.nextElement()).step( description );
        }
    }
}

