/* readme.h
 */
#ifndef _README_H
#define _README_H

namespace osl
{
  /**
   * 入玉の判定と予測
   * 
   *******************   
   * enterKing.h
   * EnterKing
   * canDeclareWin(state);
   * 手番のプレイヤが宣言法 (27点法) で入玉出来るかを判定する
   * - 宣言法なら宣言できる = 勝ち
   * - 24点法では両者が入玉出来るので, 必ずしも勝ちとは言えない
   * 
   *******************   
   * simplePredictor.h
   * SimplePredictor
   * 入玉出来るかの判定/予測を行う
   * 宣言法向けには、名前の末尾に27 がついているものをつかう　
   *
   * getProbability(state,player): 確率を得る (0.0 - 1.0)
   * predict(state,player): 上記の確率が閾値 (default 0.5) より大きいかどうかで判定
   * 
   *******************
   * getProbability
   * - 玉が敵陣からどれだけ離れているか
   * - 敵陣にある駒が少ない時にペナルティ
   * - 自玉の前方にある敵からの利きの数を計算
   *   - 相手からの利きが多い時にペナルティ
   * - 持駒と敵陣の駒で点数が足りたなら確率を返す
   * - 敵陣から1行ずつ点数を足していく
   *   - ペナルティは必要な枚数
   *   - // 距離は使わない方が今のところは良い
   *   - バグがあったので、距離を使うべきかは不明
   * - 持駒と敵陣の駒で点数が足りた時点で確率を返す
   * - 盤上の全ての駒の点数で足りないなら0.0 を返す
   * - 途中で確率が0.05 以下になるなら0.0 を返す
   * 
   *******************
   * 現状の問題点や試行錯誤
   * - 取れる/取られる駒の点数はカウントしていない
   * - 大駒を自陣に引いていると、ペナルティが重い
   *   - 大駒や香車など移動距離が大きい駒でも一歩一歩カウントしている
   *   - 現在は, 敵陣からの距離を考慮しない
   * - 中央・自陣へのペナルティが少し重い
   */
  namespace enter_king
  {
  }
} // namespace osl

#endif /* _README_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
