# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.writer import Writer


class JSONDataSetWriter(Writer):
    r"""
    JSONDataSetWriter - write DataSet using a Archiver with a
    JSON meta file along
             with all the binary arrays written as standalone binary
    files.
    
    Superclass: Writer
    
    The generated format can be used by vtk.js using the reader below
            
    https://kitware.github.io/vtk-js/examples/http_data_set_reader.html
    
    JSONDataSetWriter writes ImageData / PolyData into a set of
    files representing each arrays that compose the dataset along with a
    JSON meta file that describe what they are and how they should be
    assembled into an actual DataSet.
    
    @warning
    This writer assume little_endian by default. Additional work should be
    done to properly handle endianness.
    
    @sa
    Archiver
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkJSONDataSetWriter, obj, update, **traits)
    
    def _get_archiver(self):
        return wrap_vtk(self._vtk_obj.GetArchiver())
    def _set_archiver(self, arg):
        old_val = self._get_archiver()
        self._wrap_call(self._vtk_obj.SetArchiver,
                        deref_vtk(arg))
        self.trait_property_changed('archiver', old_val, arg)
    archiver = traits.Property(_get_archiver, _set_archiver, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataSet
        C++: DataSet *get_input()
        get_input(self, port:int) -> DataSet
        C++: DataSet *get_input(int port)
        Get the input to this writer.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def get_short_type(self, *args):
        """
        get_short_type(input:DataArray, needConversion:bool) -> str
        C++: static std::string get_short_type(DataArray *input,
            bool &needConversion)
        Compute the target java_script typed array name for the given
        DataArray (Uin8, Uint16, Uin32, Int8, Int16, Int32, Float32,
        Float64) or "xxx" if no match found
        
        Since Uint64 and Int64 does not exist in java_script, the
        needConversion argument will be set to true and Uint32/Int32 will
        be returned instead.
        """
        my_args = deref_array(args, [('vtkDataArray', 'bool')])
        ret = self._wrap_call(self._vtk_obj.GetShortType, *my_args)
        return ret

    def get_uid(self, *args):
        """
        get_uid(__a:DataArray, needConversion:bool) -> str
        C++: static std::string get_uid(DataArray *,
            bool &needConversion)
        Return a Unique identifier for that array (i.e.:
        Float32_356_13f880891af7b77262c49cae09a41e28 )
        """
        my_args = deref_array(args, [('vtkDataArray', 'bool')])
        ret = self._wrap_call(self._vtk_obj.GetUID, *my_args)
        return ret

    def get_valid_string(self, *args):
        """
        get_valid_string(self, __a:str) -> str
        C++: std::string get_valid_string(const char *)
        Return a Unique identifier for any invalid string
        """
        ret = self._wrap_call(self._vtk_obj.GetValidString, *args)
        return ret

    def compute_md5(self, *args):
        """
        compute_md5(content:(int, ...), size:int, hash:str) -> None
        C++: static void compute_md5(const unsigned char *content,
            int size, std::string &hash)
        Compute a MD5 digest of a void/(const unsigned char) pointer to
        compute a
         string hash
        """
        ret = self._wrap_call(self._vtk_obj.ComputeMD5, *args)
        return ret

    def is_data_set_valid(self):
        """
        is_data_set_valid(self) -> bool
        C++: bool is_data_set_valid()"""
        ret = self._vtk_obj.IsDataSetValid()
        return ret
        

    def write_array_as_raw(self, *args):
        """
        write_array_as_raw(__a:DataArray, filePath:str) -> bool
        C++: static bool write_array_as_raw(DataArray *,
            const char *filePath)
        For backwards compatiblity, this static method writes a data
        array's contents directly to a file.
        """
        my_args = deref_array(args, [('vtkDataArray', 'string')])
        ret = self._wrap_call(self._vtk_obj.WriteArrayAsRAW, *my_args)
        return ret

    def write_array_contents(self, *args):
        """
        write_array_contents(self, __a:DataArray, relativeFilePath:str)
            -> bool
        C++: bool write_array_contents(DataArray *,
            const char *relativeFilePath)
        Write the contents of the DataArray to disk based on the
        filePath provided without any extra information. Just the raw
        data will be written.
        
        If DataArray is a Uint64 or Int64, the data will be converted
        to Uint32 or Int32 before being written.
        """
        my_args = deref_array(args, [('vtkDataArray', 'string')])
        ret = self._wrap_call(self._vtk_obj.WriteArrayContents, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(JSONDataSetWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit JSONDataSetWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit JSONDataSetWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit JSONDataSetWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

