# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Light(Object):
    r"""
    Light - a virtual light for 3D rendering
    
    Superclass: Object
    
    Light is a virtual light for 3D rendering. It provides methods to
    locate and point the light, turn it on and off, and set its
    brightness and color. In addition to the basic infinite distance
    point light source attributes, you also can specify the light
    attenuation values and cone angle. These attributes are only used if
    the light is a positional light. The default is a directional light
    (e.g. infinite point light source).
    
    Lights have a type that describes how the light should move with
    respect to the camera.  A Headlight is always located at the current
    camera position and shines on the camera's focal point.  A
    camera_light also moves with the camera, but may not be coincident to
    it.  camera_lights are defined in a normalized coordinate space where
    the camera is located at (0, 0, 1), the camera is looking at (0, 0,
    0), and up is (0, 1, 0).  Finally, a scene_light is part of the scene
    itself and does not move with the camera. (Renderers are responsible
    for moving the light based on its type.)
    
    Lights have a transformation matrix that describes the space in which
    they are positioned.  A light's world space position and focal point
    are defined by their local position and focal point, transformed by
    their transformation matrix (if it exists).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLight, obj, update, **traits)
    
    positional = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn positional lighting on or off.
        """
    )

    def _positional_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPositional,
                        self.positional_)

    switch = tvtk_base.true_bool_trait(desc=\
        r"""
        Turn the light on or off.
        """
    )

    def _switch_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSwitch,
                        self.switch_)

    light_type = tvtk_base.RevPrefixMap({'scene_light': 3, 'camera_light': 2, 'headlight': 1}, default_value='scene_light', desc=\
        r"""
        Set/Get the type of the light. A scene_light is a light located in
        the world coordinate space.  A light is initially created as a
        scene light.
        
        * A Headlight is always located at the camera and is pointed at
          the
        * camera's focal point.  The renderer is free to modify the
          position and
        * focal point of the camera at any time.
        
        * A camera_light is also attached to the camera, but is not
          necessarily
        * located at the camera's position.  camera_lights are defined in
          a
        * coordinate space where the camera is located at (0, 0, 1),
          looking
        * towards (0, 0, 0) at a distance of 1, with up being (0, 1, 0).
        * camera_light uses the transform matrix to establish this space.
        
        * Note: All set_light_type(), and set_light_type_to*() calls clear the
        * light's transform matrix.
        """
    )

    def _light_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightType,
                        self.light_type_)

    ambient_color = tvtk_base.vtk_color_trait((0.0, 0.0, 0.0), desc=\
        r"""
        Set/Get the color of the light. It is possible to set the
        ambient, diffuse and specular colors separately. The set_color()
        method sets the diffuse and specular colors to the same color
        (this is a feature to preserve backward compatibility.)
        """
    )

    def _ambient_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAmbientColor,
                        self.ambient_color, True)

    attenuation_values = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/Get the quadratic attenuation constants. They are specified
        as constant, linear, and quadratic, in that order.
        """
    )

    def _attenuation_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttenuationValues,
                        self.attenuation_values)

    cone_angle = traits.Float(30.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the lighting cone angle of a positional light in degrees.
        This is the angle between the axis of the cone and a ray along
        the edge of the cone. A value of 90 (or more) indicates that you
        want no spot lighting effects just a positional light.
        """
    )

    def _cone_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConeAngle,
                        self.cone_angle)

    diffuse_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        
        """
    )

    def _diffuse_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDiffuseColor,
                        self.diffuse_color, True)

    exponent = traits.Trait(1.0, traits.Range(0.0, 128.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the exponent of the cosine used in positional lighting.
        """
    )

    def _exponent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExponent,
                        self.exponent)

    focal_point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/Get the point at which the light is shining. Note: The focal
        point of the light is defined in the coordinate space indicated
        by its transformation matrix (if it exists). Thus, to get the
        light's world space focal point, use
        GetTransformedFocalPoint() instead of GetFocalPoint().
        """
    )

    def _focal_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFocalPoint,
                        self.focal_point)

    def _get_information(self):
        return wrap_vtk(self._vtk_obj.GetInformation())
    def _set_information(self, arg):
        old_val = self._get_information()
        self._wrap_call(self._vtk_obj.SetInformation,
                        deref_vtk(arg))
        self.trait_property_changed('information', old_val, arg)
    information = traits.Property(_get_information, _set_information, desc=\
        r"""
        Set/Get the information object associated with the light.
        """
    )

    intensity = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the brightness of the light (from one to zero).
        """
    )

    def _intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntensity,
                        self.intensity)

    position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Set/Get the position of the light. Note: The position of the
        light is defined in the coordinate space indicated by its
        transformation matrix (if it exists). Thus, to get the light's
        world space position, use GetTransformedPosition() instead of
        GetPosition().
        """
    )

    def _position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPosition,
                        self.position)

    shadow_attenuation = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the shadow intensity By default a light will be
        completely blocked when in shadow by setting this value to less
        than 1.0 you can control how much light is attenuated when in
        shadow
        """
    )

    def _shadow_attenuation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShadowAttenuation,
                        self.shadow_attenuation)

    specular_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        
        """
    )

    def _specular_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecularColor,
                        self.specular_color, True)

    def _get_transform_matrix(self):
        return wrap_vtk(self._vtk_obj.GetTransformMatrix())
    def _set_transform_matrix(self, arg):
        old_val = self._get_transform_matrix()
        self._wrap_call(self._vtk_obj.SetTransformMatrix,
                        deref_vtk(arg))
        self.trait_property_changed('transform_matrix', old_val, arg)
    transform_matrix = traits.Property(_get_transform_matrix, _set_transform_matrix, desc=\
        r"""
        
        """
    )

    def _get_transformed_focal_point(self):
        return self._vtk_obj.GetTransformedFocalPoint()
    transformed_focal_point = traits.Property(_get_transformed_focal_point, desc=\
        r"""
        Get the focal point of the light, modified by the transformation
        matrix (if it exists).
        """
    )

    def get_transformed_focal_point(self, *args):
        """
        get_transformed_focal_point(self, x:float, y:float, z:float) -> None
        C++: void get_transformed_focal_point(double &x, double &y,
            double &z)
        get_transformed_focal_point(self, a:[float, float, float]) -> None
        C++: void get_transformed_focal_point(double a[3])
        get_transformed_focal_point(self) -> (float, float, float)
        C++: double *get_transformed_focal_point()
        Get the focal point of the light, modified by the transformation
        matrix (if it exists).
        """
        ret = self._wrap_call(self._vtk_obj.GetTransformedFocalPoint, *args)
        return ret

    def _get_transformed_position(self):
        return self._vtk_obj.GetTransformedPosition()
    transformed_position = traits.Property(_get_transformed_position, desc=\
        r"""
        Get the position of the light, modified by the transformation
        matrix (if it exists).
        """
    )

    def get_transformed_position(self, *args):
        """
        get_transformed_position(self, x:float, y:float, z:float) -> None
        C++: void get_transformed_position(double &x, double &y, double &z)
        get_transformed_position(self, a:[float, float, float]) -> None
        C++: void get_transformed_position(double a[3])
        get_transformed_position(self) -> (float, float, float)
        C++: double *get_transformed_position()
        Get the position of the light, modified by the transformation
        matrix (if it exists).
        """
        ret = self._wrap_call(self._vtk_obj.GetTransformedPosition, *args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, light:Light) -> None
        C++: void deep_copy(Light *light)
        Perform deep copy of this light.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def light_type_is_camera_light(self):
        """
        light_type_is_camera_light(self) -> int
        C++: int light_type_is_camera_light()"""
        ret = self._vtk_obj.LightTypeIsCameraLight()
        return ret
        

    def light_type_is_headlight(self):
        """
        light_type_is_headlight(self) -> int
        C++: int light_type_is_headlight()
        Query the type of the light.
        """
        ret = self._vtk_obj.LightTypeIsHeadlight()
        return ret
        

    def light_type_is_scene_light(self):
        """
        light_type_is_scene_light(self) -> int
        C++: int light_type_is_scene_light()"""
        ret = self._vtk_obj.LightTypeIsSceneLight()
        return ret
        

    def render(self, *args):
        """
        render(self, __a:Renderer, __b:int) -> None
        C++: virtual void render(Renderer *, int)
        Abstract interface to renderer. Each concrete subclass of
        Light will load its data into the graphics system in response
        to this method invocation. The actual loading is performed by a
        LightDevice subclass, which will get created automatically.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Render, *my_args)
        return ret

    def set_color(self, *args):
        """
        set_color(self, __a:float, __b:float, __c:float) -> None
        C++: void set_color(double, double, double)
        set_color(self, a:(float, float, float)) -> None
        C++: void set_color(const double a[3])"""
        ret = self._wrap_call(self._vtk_obj.SetColor, *args)
        return ret

    def set_direction_angle(self, *args):
        """
        set_direction_angle(self, elevation:float, azimuth:float) -> None
        C++: void set_direction_angle(double elevation, double azimuth)
        set_direction_angle(self, ang:(float, float)) -> None
        C++: void set_direction_angle(const double ang[2])
        Set the position and focal point of a light based on elevation
        and azimuth.  The light is moved so it is shining from the given
        angle. Angles are given in degrees.  If the light is a positional
        light, it is made directional instead.
        """
        ret = self._wrap_call(self._vtk_obj.SetDirectionAngle, *args)
        return ret

    def shallow_clone(self):
        """
        shallow_clone(self) -> Light
        C++: virtual Light *shallow_clone()
        Create a new light object with the same light parameters than the
        current object (any ivar from the superclasses (Object and
        ObjectBase), like reference counting, timestamp and observers
        are not copied). This is a shallow clone (transform_matrix is
        referenced)
        """
        ret = wrap_vtk(self._vtk_obj.ShallowClone())
        return ret
        

    def transform_point(self, *args):
        """
        transform_point(self, a:[float, float, float], b:[float, float,
            float]) -> None
        C++: void transform_point(double a[3], double b[3])
        Use transform matrix to transform point (if it exists).
        """
        ret = self._wrap_call(self._vtk_obj.TransformPoint, *args)
        return ret

    def transform_vector(self, *args):
        """
        transform_vector(self, a:[float, float, float], b:[float, float,
            float]) -> None
        C++: void transform_vector(double a[3], double b[3])
        Use transform matrix to transform vector (if it exists).
        """
        ret = self._wrap_call(self._vtk_obj.TransformVector, *args)
        return ret

    _updateable_traits_ = \
    (('positional', 'GetPositional'), ('switch', 'GetSwitch'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('light_type', 'GetLightType'), ('ambient_color', 'GetAmbientColor'),
    ('attenuation_values', 'GetAttenuationValues'), ('cone_angle',
    'GetConeAngle'), ('diffuse_color', 'GetDiffuseColor'), ('exponent',
    'GetExponent'), ('focal_point', 'GetFocalPoint'), ('intensity',
    'GetIntensity'), ('position', 'GetPosition'), ('shadow_attenuation',
    'GetShadowAttenuation'), ('specular_color', 'GetSpecularColor'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'positional', 'switch',
    'light_type', 'ambient_color', 'attenuation_values', 'cone_angle',
    'diffuse_color', 'exponent', 'focal_point', 'intensity',
    'object_name', 'position', 'shadow_attenuation', 'specular_color'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Light, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Light properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['positional', 'switch'], ['light_type'], ['ambient_color',
            'attenuation_values', 'cone_angle', 'diffuse_color', 'exponent',
            'focal_point', 'intensity', 'object_name', 'position',
            'shadow_attenuation', 'specular_color']),
            title='Edit Light properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Light properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            
    def __getstate__(self):
        d = tvtk_base.TVTKBase.__getstate__(self)
        if 'color' in d:
            del d['color']
        return d
    
    def __setstate__(self, dict):
        tvtk_base.TVTKBase.__setstate__(self, dict)
        self.update_traits()

